(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12354,        446]
NotebookOptionsPosition[      9238,        342]
NotebookOutlinePosition[     10601,        381]
CellTagsIndexPosition[     10516,        376]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Messages\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MessageName" :> 
          Documentation`HelpLookup["paclet:ref/MessageName"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"], "SyntaxInformation" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MessageName\"\>", 
       2->"\<\"Message\"\>", 3->"\<\"Check\"\>", 
       4->"\<\"SyntaxInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Messages", "ObjectName",
 CellID->29102],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Messages",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Messages"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all the messages assigned to a particular symbol. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10083]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Messages that have been switched off using ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 " are enclosed in ",
 Cell[BoxData["$Off"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->692]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323875800],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->517471021],

Cell["\<\
Get messages that have been explicitly defined for a function:\
\>", "ExampleText",
 CellID->347653889],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "usage"}], "=", "\"\<f[x] gives (x - 1)(x + 1)\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "numb"}], " ", "=", " ", 
   "\"\<Argument `1` should be a number\>\""}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->246403829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Messages", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87167016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "::", "\<\"numb\"\>"}], "]"}], 
    "\[RuleDelayed]", "\<\"Argument `1` should be a number\"\>"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "::", "\<\"usage\"\>"}], "]"}], 
    "\[RuleDelayed]", "\<\"f[x] gives (x - 1)(x + 1)\"\>"}]}], 
  "}"}]], "Output",
 ImageSize->{391, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3752582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217840633],

Cell[TextData[{
 "Get the messages for ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " that have been defined during the current session:"
}], "ExampleText",
 CellID->125585429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Messages", "[", "NDSolve", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448952],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->979956247]
}, Open  ]],

Cell["\<\
Typically, for system commands, messages are only loaded when they are \
required:\
\>", "ExampleText",
 CellID->227655191],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", 
        RowBox[{"t", ",", "s"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "x", 
    ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Messages", "[", "NDSolve", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->58475209],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"dvlen\"\>"}], ":", 
  " ", "\<\"The function \\!\\(x[\\(\\(t, s\\)\\)]\\) does not have the same \
number of arguments as independent variables (\\!\\(1\\)). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/dvlen\\\", \
ButtonNote -> \\\"NDSolve::dvlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->581138442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"NDSolve", "::", "\<\"dvlen\"\>"}], "]"}], 
   "\[RuleDelayed]", "\<\"The function `1` does not have the same number of \
arguments as independent variables (`2`).\"\>"}], "}"}]], "Output",
 ImageSize->{438, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25124092]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11047],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5844]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10532],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->17312]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Messages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 45.1207096}", "context" -> "System`", 
    "keywords" -> {
     "messages associated with functions", "messages associated with symbols",
       "error message", "warnings", "errors", "diagnostics", 
      "message handling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Messages[symbol] gives all the messages assigned to a particular symbol. \
", "synonyms" -> {}, "title" -> "Messages", "type" -> "Symbol", "uri" -> 
    "ref/Messages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3445, 118, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->323875800]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10373, 369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1448, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2071, 62, 46, 1, 70, "ObjectName",
 CellID->29102],
Cell[2120, 65, 505, 16, 70, "Usage",
 CellID->10083]
}, Open  ]],
Cell[CellGroupData[{
Cell[2662, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3140, 103, 268, 10, 70, "Notes",
 CellID->692]
}, Closed]],
Cell[CellGroupData[{
Cell[3445, 118, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323875800],
Cell[CellGroupData[{
Cell[3830, 132, 148, 5, 70, "ExampleSection",
 CellID->517471021],
Cell[3981, 139, 113, 3, 70, "ExampleText",
 CellID->347653889],
Cell[4097, 144, 307, 10, 70, "Input",
 CellID->246403829],
Cell[CellGroupData[{
Cell[4429, 158, 103, 3, 28, "Input",
 CellID->87167016],
Cell[4535, 163, 516, 16, 54, "Output",
 CellID->3752582]
}, Open  ]],
Cell[5066, 182, 125, 3, 70, "ExampleDelimiter",
 CellID->217840633],
Cell[5194, 187, 252, 8, 70, "ExampleText",
 CellID->125585429],
Cell[CellGroupData[{
Cell[5471, 199, 107, 3, 70, "Input",
 CellID->448952],
Cell[5581, 204, 175, 6, 36, "Output",
 CellID->979956247]
}, Open  ]],
Cell[5771, 213, 133, 4, 70, "ExampleText",
 CellID->227655191],
Cell[CellGroupData[{
Cell[5929, 221, 564, 19, 70, "Input",
 CellID->58475209],
Cell[6496, 242, 452, 8, 70, "Message",
 CellID->581138442],
Cell[6951, 252, 403, 11, 71, "Output",
 CellID->25124092]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7415, 270, 311, 9, 70, "SeeAlsoSection",
 CellID->11047],
Cell[7729, 281, 956, 35, 70, "SeeAlso",
 CellID->5844]
}, Open  ]],
Cell[CellGroupData[{
Cell[8722, 321, 314, 9, 70, "TutorialsSection",
 CellID->10532],
Cell[9039, 332, 127, 3, 70, "Tutorials",
 CellID->17312]
}, Open  ]],
Cell[9181, 338, 27, 0, 70, "History"],
Cell[9211, 340, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

