(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69892,       2157]
NotebookOptionsPosition[     59524,       1793]
NotebookOutlinePosition[     60876,       1832]
CellTagsIndexPosition[     60790,       1827]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], "Ordering in Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/OrderingInLists"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Ordering in Lists\"\>", 
       3->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Max" :> Documentation`HelpLookup["paclet:ref/Max"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"], "Minimize" :> 
          Documentation`HelpLookup["paclet:ref/Minimize"], "FindMinimum" :> 
          Documentation`HelpLookup["paclet:ref/FindMinimum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Max\"\>", 2->"\<\"Ordering\"\>", 
       3->"\<\"Minimize\"\>", 4->"\<\"FindMinimum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Math & Counting Operations on Lists\"\>", 
       2->"\<\"Mathematical Functions\"\>", 3->"\<\"Numerical Data\"\>", 
       4->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Min", "ObjectName",
 CellID->16467],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Min",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Min"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the numerically smallest of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Min",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Min"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the smallest element of any of the lists. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " yields a definite result if all its arguments are real numbers. "
}], "Notes",
 CellID->7528],

Cell[TextData[{
 "In other cases, ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " carries out some simplifications. "
}], "Notes",
 CellID->30916],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"], "[", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12634],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->4999]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134303477],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->57186631],

Cell["Minimum of two numbers:", "ExampleText",
 CellID->174071426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"9", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51785422],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7172870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4298180],

Cell["Minimum of a list:", "ExampleText",
 CellID->295399998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "1", ",", "7", ",", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799169278],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30239787]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->157704324],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " works with exact numeric quantities:"
}], "ExampleText",
 CellID->98720759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"{", 
   RowBox[{"Pi", ",", "E", ",", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146820463],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49235621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->517085266],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " effectively flattens out all lists:"
}], "ExampleText",
 CellID->3650413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99727539],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59097125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->325154755],

Cell["Basic symbolic simplification is done automatically:", "ExampleText",
 CellID->141319121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Min", "[", 
    RowBox[{"x", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517739477],

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128472801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->766262428],

Cell[TextData[{
 "Simplify a symbolic ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->244965976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{"1", "-", "x"}], ",", "x", ",", 
    RowBox[{"1", "+", "x"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71481507],

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{
   RowBox[{"1", "-", "x"}], ",", "x"}], "]"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202903392]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141429158],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->33892677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112277622],

Cell[BoxData[
 RowBox[{"1", "-", 
  SqrtBox["2"]}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203678490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", 
      RowBox[{"a", "-", "x"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9913466],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWMluE0EQtWdxnKAkLNnIhWwcWCTggCICEhKCsAQOcCBXnChSckBYIQef
8CV3H/0JPuYT+IR8Rj6j6eqpsttvasbj2IkYyTPu6tq7+nXNfKmdHB78rJ0c
7ddW3h/X6odH+79Xtn8dW1JYLpVKp/b3dalk/xv7z/1OjbHPR/Ye2uF3N3pI
dxoad5V2HTWke9RoNP666+LiYt1Soq6Umw+bzSZLbTj+npYsvvv2FtjZXXX2
z8jUHxwb0WN+kr2EMbkCjiRWNdQgH+GAccAafdqEqtlRQ5tN9mPL+WXHPL9c
xHLcHXNAxWwXikrVHWdm6g7o2FF0UnaibL9TVN3SjElW1clEvkzIMvRc5uca
rhD7kTjiLqbITMiSFdV61ST1IjUkOmOgxWBXvI4U+dX+SJR1XFR9mWZdyI3j
kPmmgT7J9Hv2OWGfdzOt5Hun2euXmAGOaorjdeZa05pMePJSGUSfVSKStST1
W6rWJZCaA+2yVi9V6QcgHcEYfXqhaqG6jJVcznMEuu0N4O5p6CFJAEjyoZAm
9OPbFUrJHtpRudc5A1O8Cp9Vrmeg85PK9ZR16TpGP2Guikp7Loa6N4wqMdc1
PW8br4pSWrASUZtfuVQ0r4zJQOGwHzHFMx3HU35U2EvcKbFCz/ZjDqQTAE0q
sN1udzod+ntzyJhDzmaUGekkaAg8u70Yh7WLOwfPiydqDhaAq+z5Uq/XW62W
5sssxyfngH/2yGknfSBhIzWMpLmsriZW1YLpdVlpj9+qVL1OBO2XVRmsnje+
XRWl5TTPQywdHV32K/75lNw/ZnOn/NUR6XpxZAqixW5Ix0WseMRvHberwEVa
8jAsCw3WvHmRz+/HfC03YDxoHw6ad7Gn1hYzpHe1ev+KHkv3WBQdL+cxSXU7
qUt6OmxuQyUqjYdWXPA3kOxek4+DetlB/Gjv1rVlX1AdT46Y6WSr2xv0vSfJ
uwAJIUIMU8m4C1DXIoyz3lfiLrzLtTaEF2i1yrnO6/KNstJ4UqyaPNzZHqBN
3iYfF5J+rnK9Yx2b6uz/0KeO1r0iNlRN3heG8XSzFc5pVZ3VLY+nf5W6RL/1
+ho2Wr+PlRhxZ4wnr1jpm9mZzEGvqOdLdHZ21nTX+fk5fikQlKP3YSLPw3zS
/SF1L2d15zg7B8bf38nX0FL5H0ofW1I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{132, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483397232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282297654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587199693],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->202474440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268929988],

Cell[TextData[{
 "Reduce inequalities involving ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->232198900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ">", "0"}], ",", 
     RowBox[{"0", "<", "x", "<", "20"}]}], "}"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->34807664],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", 
   FractionBox["\[Pi]", "2"]}], "||", 
  RowBox[{
   RowBox[{"2", " ", "\[Pi]"}], "<", "x", "<", 
   FractionBox[
    RowBox[{"5", " ", "\[Pi]"}], "2"]}], "||", 
  RowBox[{
   RowBox[{"4", " ", "\[Pi]"}], "<", "x", "<", 
   FractionBox[
    RowBox[{"9", " ", "\[Pi]"}], "2"]}], "||", 
  RowBox[{
   RowBox[{"6", " ", "\[Pi]"}], "<", "x", "<", "20"}]}]], "Output",
 ImageSize->{335, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165254959]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->260337424],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " works on sparse arrays:"
}], "ExampleText",
 CellID->83615357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "x"}], ",", 
      RowBox[{"2", "->", "y"}]}], "}"}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308635788],

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"0", ",", "x", ",", "y"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->774977947]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->176048651],

Cell["Use in bounds of iterator variables:", "ExampleText",
 CellID->696510501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", " ", "j", " ", "k"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"Min", "[", 
      RowBox[{"i", ",", " ", "j"}], "]"}], ",", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->577203314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "18"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "18"}], "}"}], ",", 
     RowBox[{"{", "27", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{398, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4055466]
}, Open  ]],

Cell["Cumulative minima:", "ExampleText",
 CellID->787612001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{"Min", ",", "Infinity", ",", 
    RowBox[{"{", 
     RowBox[{
     "10", ",", "18", ",", "16", ",", "22", ",", "12", ",", "30", ",", "6", 
      ",", "24", ",", "24", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125470392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "6", ",", 
   "6", ",", "6", ",", "2"}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37758311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141532301],

Cell["Find the lowest point of a plotted curve:", "ExampleText",
 CellID->247841153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "3", "]"}], " ", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"20", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317474938],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411471818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Last", "/@", 
   RowBox[{"Level", "[", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"%", ",", "_Line", ",", "Infinity"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->201071900],

Cell[BoxData[
 RowBox[{"-", "1.9991398727037748`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->684773502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466603996],

Cell["Mean of the length ratio of a randomly broken stick:", "ExampleText",
 CellID->190985155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", 
      RowBox[{"1", "-", "x"}]}], "]"}], "/", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", " ", 
      RowBox[{"1", "-", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567995973],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "2", "]"}]}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106644017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117629070],

Cell["\<\
R\[Hyphen]function based solid modeling:\
\>", "ExampleText",
 CellID->265243269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{
      RowBox[{"x", "-", 
       RowBox[{"y", " ", "z"}]}], ",", 
      RowBox[{"Min", "[", 
       RowBox[{"y", "-", "z"}], "]"}], ",", 
      RowBox[{"Min", "[", 
       RowBox[{"x", "+", 
        RowBox[{"z", "^", "2"}]}], "]"}]}], "]"}], ">", "0"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388032020],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246984369]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->651626383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->484258982],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538100051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191324997],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->208007807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{
   RowBox[{"Min", "[", 
    RowBox[{"z", ",", "y"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->480797745],

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286033132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104091369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19714680],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVz1SAjEUDrsbFlFEKdQSa/UMaiFWHkCtGMYZHUfdQQs6am2w4wiUHMEj
cAyOEZPdF8i+vMSIjmaGTfJe3v/Lt8tF9+X25qH7ctfrts/73ez2rvfc7jz1
JSmuMMbe5e9gj8m1kKv89y6EnM1nrJ7JYDD4yMd8Pn9d0uPhcCjywarywaWK
hpxjVvA5zBGDBStGJJeJnC+dmpgSFXoomc381IIKUu59BHZM2jVpL0WnmiGW
LP/CbNXQqaCoSFvcn79kqYOREan8JO5ILKrbFieqE4GFwkQ+gKI5SpMSuCL1
7lgx4PzeO+VSeeiB5L79KVXlRoXQhvnQmL/ujH20P0L7gyAt6yjrW4hfRfsa
VCUV5VtbqqlBw/Kq01Q/cERfE0tU0LUcj8eTyURzI8COctW3gVODOb+rVm9y
Sy62KFrDFqmhathx3Ajwms61RijtI86B4teBz90x8MVp07JFrSLN+hbiaui8
0ohqRpVl2Wg0WkRVylwDtGxbHN0ldFWwNwnap2S1cXd+VZWwt8eGZasZ5PNq
kdE+NC0fqNsXGqfql7iMsEaP6bvaIE/RsetqcmO2ZVWXc+c9on09Js/SVFrD
CfhyKkwc+V98fxQFnu+R3EyUa7vrrKJZL4zXOts/xekY6cU3jYOd1Jtf+8vC
Rmx/b62O37btFuiso1g8XzXkt18EXruwWy1/F7tNSxjL/W+6sChayPuf4/RC
a6kCunvXvuFrcA9Zb5pfwuWSXhrF/Pky4kqm0+kwH7PZLBFhd9lvk6PZlLbR
GH/v+Xr/jOQdeyQ6gkLd4n8hq3wCJZFdlA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195060425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222170392],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->595017756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "-", 
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"-", "x"}], ",", 
     RowBox[{"-", "y"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->295397960],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydVcFOwzAMdZNm2QaFC6BJXHaEK0iIC3CYBCc+opqQtsM0tO3/g5M6Xea4
W0ekxrHj+jkvdvtd7xY/q3q3nNfTr039u1jOt9PP9QZNugCAGT73E8C1w1V4
Zs6hvMO5RPUxaBM/a78bBjwEq8bZGwcoDUrLvCra17TvpQJaQDMU4ag2YhrB
RwbT6vSapTjXzJu/zXUVcRJbKeLyk6Q69EXO8u6HPZQ4KPc6wNW/0U0n0yMp
tyyGhOxZlb1VtzXDH/O7ck3tEEk0KsFLHXqRJe7EGtUiqlxftxnj/OZuxGiW
sHzvWJK511uwxvw+Wi31eT9ileNx64tr+ko+96vAo8yOIXJTTi+YbsiPV+45
PW0yzqvMMmCRxskd9+vh+NVQlK2XaeVDZzSpK9NoMRebZX1Gv504fzzBUGRw
j6MpH6lTjt2hVMuH/VcE5VLEfwoyfvOfg9b8S6D4A04MNc8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{67, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280727667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", " ", ",", "y"}], "]"}], "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "y"}], ")"}], "^", "2"}], "]"}]}], ")"}], "/", 
     "2"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "y"}], "}"}], ",", "Reals"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->618055587],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["y", "2"]}]], "Output",
 ImageSize->{23, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136589995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49315004],

Cell[TextData[{
 "Minimize a function containing ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->176053404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"2", "x"}], "+", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"3", " ", "x"}], "+", "2"}]}], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328759607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"3", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], "4"]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{497, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159954400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60760440],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " can be differentiated:"
}], "ExampleText",
 CellID->819974720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Min", "'"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410591786],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7884290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Derivative", "[", 
   RowBox[{"1", ",", "0"}], "]"}], "[", "Min", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->528280672],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVNsKwjAMzW7dpm6IL/q4r9Env2EMGbgHUXT/X9M1u5BGERnioElzkqYn
Wdtj1Z7rS9U2p6o43KvbuTk9iv31jlDgAUCNY7sDnGucdaPWGnWAMkCzHCww
pu6+P0YVigjNlTHCEbeRxpO/9KiJNikT1D5QgF0AXjf1ybNguy9RKDRDhmeE
m3UQDbhN62QJxCgl8qack9Ups91ORCwiorpDJ5LXkVLd6jVDQgdp+c3A0v1v
PEIRu0RkF0tdds5PMgMvxSLit137HS++E88pn7v+FnzG67sbsBbRTNyx76Zb
X0ietegxKTakczFzOSM6vp32PQXvCdQT1UM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->900948991]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->359191660],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " flattens lists, rather than being ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->133796363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317083564],

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264999156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->406333015],

Cell["\<\
One\[Hyphen]argument form evaluates for any argument:\
\>", "ExampleText",
 CellID->601996302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19285346],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14035408]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15749],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17757],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->29240],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "Tutorials",
 CellID->581],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->13623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15941],

Cell[TextData[{
 ButtonBox["Demonstrations with Min",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Min"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Minimum.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Min/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->57342527],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->25449330],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->182109352],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->219219328],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->640660513]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Min - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 48.3864182}", "context" -> "System`", 
    "keywords" -> {
     "infimum", "lists", "lowest", "min", "minimal element", "minimum", 
      "smallest"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Min[x_1, x_2, ...] yields the numerically smallest of the x_i. Min[{x_1, \
x_2, ...}, {y_1, ...}, ...] yields the smallest element of any of the lists. \
", "synonyms" -> {}, "title" -> "Min", "type" -> "Symbol", "uri" -> 
    "ref/Min"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6726, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->134303477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60647, 1820}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2829, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3452, 90, 41, 1, 70, "ObjectName",
 CellID->16467],
Cell[3496, 93, 1613, 52, 70, "Usage",
 CellID->30000]
}, Open  ]],
Cell[CellGroupData[{
Cell[5146, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5624, 167, 221, 7, 70, "Notes",
 CellID->7528],
Cell[5848, 176, 213, 8, 70, "Notes",
 CellID->30916],
Cell[6064, 186, 316, 13, 70, "Notes",
 CellID->12634],
Cell[6383, 201, 306, 12, 70, "Notes",
 CellID->4999]
}, Closed]],
Cell[CellGroupData[{
Cell[6726, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134303477],
Cell[CellGroupData[{
Cell[7111, 232, 147, 5, 70, "ExampleSection",
 CellID->57186631],
Cell[7261, 239, 66, 1, 70, "ExampleText",
 CellID->174071426],
Cell[CellGroupData[{
Cell[7352, 244, 121, 4, 28, "Input",
 CellID->51785422],
Cell[7476, 250, 156, 5, 36, "Output",
 CellID->7172870]
}, Open  ]],
Cell[7647, 258, 123, 3, 70, "ExampleDelimiter",
 CellID->4298180],
Cell[7773, 263, 61, 1, 70, "ExampleText",
 CellID->295399998],
Cell[CellGroupData[{
Cell[7859, 268, 166, 5, 70, "Input",
 CellID->799169278],
Cell[8028, 275, 157, 5, 36, "Output",
 CellID->30239787]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8234, 286, 220, 7, 70, "ExampleSection",
 CellID->157704324],
Cell[8457, 295, 203, 7, 70, "ExampleText",
 CellID->98720759],
Cell[CellGroupData[{
Cell[8685, 306, 190, 6, 70, "Input",
 CellID->146820463],
Cell[8878, 314, 168, 6, 38, "Output",
 CellID->49235621]
}, Open  ]],
Cell[9061, 323, 125, 3, 70, "ExampleDelimiter",
 CellID->517085266],
Cell[9189, 328, 201, 7, 70, "ExampleText",
 CellID->3650413],
Cell[CellGroupData[{
Cell[9415, 339, 239, 8, 70, "Input",
 CellID->99727539],
Cell[9657, 349, 157, 5, 36, "Output",
 CellID->59097125]
}, Open  ]],
Cell[9829, 357, 125, 3, 70, "ExampleDelimiter",
 CellID->325154755],
Cell[9957, 362, 95, 1, 70, "ExampleText",
 CellID->141319121],
Cell[CellGroupData[{
Cell[10077, 367, 188, 6, 70, "Input",
 CellID->517739477],
Cell[10268, 375, 220, 7, 36, "Output",
 CellID->128472801]
}, Open  ]],
Cell[10503, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->766262428],
Cell[10631, 390, 193, 8, 70, "ExampleText",
 CellID->244965976],
Cell[CellGroupData[{
Cell[10849, 402, 217, 7, 70, "Input",
 CellID->71481507],
Cell[11069, 411, 234, 8, 36, "Output",
 CellID->202903392]
}, Open  ]],
Cell[11318, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->141429158],
Cell[11446, 427, 204, 8, 70, "ExampleText",
 CellID->33892677],
Cell[CellGroupData[{
Cell[11675, 439, 355, 12, 70, "Input",
 CellID->112277622],
Cell[12033, 453, 192, 7, 38, "Output",
 CellID->203678490]
}, Open  ]],
Cell[CellGroupData[{
Cell[12262, 465, 301, 10, 70, "Input",
 CellID->9913466],
Cell[12566, 477, 1403, 27, 70, "Output",
 Evaluatable->False,
 CellID->483397232]
}, Open  ]],
Cell[13984, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->282297654],
Cell[CellGroupData[{
Cell[14134, 514, 371, 12, 70, "Input",
 CellID->587199693],
Cell[14508, 528, 2965, 53, 70, "Output",
 Evaluatable->False,
 CellID->202474440]
}, Open  ]],
Cell[17488, 584, 125, 3, 70, "ExampleDelimiter",
 CellID->268929988],
Cell[17616, 589, 203, 8, 70, "ExampleText",
 CellID->232198900],
Cell[CellGroupData[{
Cell[17844, 601, 372, 13, 70, "Input",
 CellID->34807664],
Cell[18219, 616, 549, 18, 51, "Output",
 CellID->165254959]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18817, 640, 243, 7, 70, "ExampleSection",
 CellID->260337424],
Cell[19063, 649, 190, 7, 70, "ExampleText",
 CellID->83615357],
Cell[CellGroupData[{
Cell[19278, 660, 269, 9, 70, "Input",
 CellID->308635788],
Cell[19550, 671, 220, 7, 36, "Output",
 CellID->774977947]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19819, 684, 227, 7, 70, "ExampleSection",
 CellID->176048651],
Cell[20049, 693, 79, 1, 70, "ExampleText",
 CellID->696510501],
Cell[CellGroupData[{
Cell[20153, 698, 403, 14, 70, "Input",
 CellID->577203314],
Cell[20559, 714, 895, 30, 54, "Output",
 CellID->4055466]
}, Open  ]],
Cell[21469, 747, 61, 1, 70, "ExampleText",
 CellID->787612001],
Cell[CellGroupData[{
Cell[21555, 752, 330, 9, 70, "Input",
 CellID->125470392],
Cell[21888, 763, 296, 9, 36, "Output",
 CellID->37758311]
}, Open  ]],
Cell[22199, 775, 125, 3, 70, "ExampleDelimiter",
 CellID->141532301],
Cell[22327, 780, 84, 1, 70, "ExampleText",
 CellID->247841153],
Cell[CellGroupData[{
Cell[22436, 785, 359, 12, 70, "Input",
 CellID->317474938],
Cell[22798, 799, 7589, 128, 70, "Output",
 Evaluatable->False,
 CellID->411471818]
}, Open  ]],
Cell[CellGroupData[{
Cell[30424, 932, 315, 10, 70, "Input",
 CellID->201071900],
Cell[30742, 944, 193, 6, 36, "Output",
 CellID->684773502]
}, Open  ]],
Cell[30950, 953, 125, 3, 70, "ExampleDelimiter",
 CellID->466603996],
Cell[31078, 958, 95, 1, 70, "ExampleText",
 CellID->190985155],
Cell[CellGroupData[{
Cell[31198, 963, 386, 13, 70, "Input",
 CellID->567995973],
Cell[31587, 978, 252, 9, 36, "Output",
 CellID->106644017]
}, Open  ]],
Cell[31854, 990, 125, 3, 70, "ExampleDelimiter",
 CellID->117629070],
Cell[31982, 995, 91, 3, 70, "ExampleText",
 CellID->265243269],
Cell[CellGroupData[{
Cell[32098, 1002, 721, 23, 70, "Input",
 CellID->388032020],
Cell[32822, 1027, 12408, 207, 70, "Output",
 Evaluatable->False,
 CellID->246984369]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45279, 1240, 237, 7, 70, "ExampleSection",
 CellID->651626383],
Cell[CellGroupData[{
Cell[45541, 1251, 94, 3, 70, "Input",
 CellID->484258982],
Cell[45638, 1256, 168, 5, 36, "Output",
 CellID->538100051]
}, Open  ]],
Cell[45821, 1264, 125, 3, 70, "ExampleDelimiter",
 CellID->191324997],
Cell[45949, 1269, 419, 17, 70, "ExampleText",
 CellID->208007807],
Cell[CellGroupData[{
Cell[46393, 1290, 178, 6, 70, "Input",
 CellID->480797745],
Cell[46574, 1298, 220, 7, 36, "Output",
 CellID->286033132]
}, Open  ]],
Cell[46809, 1308, 125, 3, 70, "ExampleDelimiter",
 CellID->104091369],
Cell[CellGroupData[{
Cell[46959, 1315, 222, 7, 70, "Input",
 CellID->19714680],
Cell[47184, 1324, 1041, 21, 70, "Output",
 Evaluatable->False,
 CellID->195060425]
}, Open  ]],
Cell[48240, 1348, 125, 3, 70, "ExampleDelimiter",
 CellID->222170392],
Cell[48368, 1353, 334, 13, 70, "ExampleText",
 CellID->595017756],
Cell[CellGroupData[{
Cell[48727, 1370, 285, 10, 70, "Input",
 CellID->295397960],
Cell[49015, 1382, 686, 15, 70, "Output",
 Evaluatable->False,
 CellID->280727667]
}, Open  ]],
Cell[CellGroupData[{
Cell[49738, 1402, 591, 21, 70, "Input",
 CellID->618055587],
Cell[50332, 1425, 196, 7, 49, "Output",
 CellID->136589995]
}, Open  ]],
Cell[50543, 1435, 124, 3, 70, "ExampleDelimiter",
 CellID->49315004],
Cell[50670, 1440, 204, 8, 70, "ExampleText",
 CellID->176053404],
Cell[CellGroupData[{
Cell[50899, 1452, 371, 13, 70, "Input",
 CellID->328759607],
Cell[51273, 1467, 954, 35, 41, "Output",
 CellID->159954400]
}, Open  ]],
Cell[52242, 1505, 124, 3, 70, "ExampleDelimiter",
 CellID->60760440],
Cell[52369, 1510, 190, 7, 70, "ExampleText",
 CellID->819974720],
Cell[CellGroupData[{
Cell[52584, 1521, 117, 4, 70, "Input",
 CellID->410591786],
Cell[52704, 1527, 156, 5, 36, "Output",
 CellID->7884290]
}, Open  ]],
Cell[CellGroupData[{
Cell[52897, 1537, 160, 5, 70, "Input",
 CellID->528280672],
Cell[53060, 1544, 553, 13, 70, "Output",
 Evaluatable->False,
 CellID->900948991]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53662, 1563, 230, 7, 70, "ExampleSection",
 CellID->359191660],
Cell[53895, 1572, 327, 12, 70, "ExampleText",
 CellID->133796363],
Cell[CellGroupData[{
Cell[54247, 1588, 220, 8, 70, "Input",
 CellID->317083564],
Cell[54470, 1598, 231, 7, 36, "Output",
 CellID->264999156]
}, Open  ]],
Cell[54716, 1608, 125, 3, 70, "ExampleDelimiter",
 CellID->406333015],
Cell[54844, 1613, 104, 3, 70, "ExampleText",
 CellID->601996302],
Cell[CellGroupData[{
Cell[54973, 1620, 98, 3, 70, "Input",
 CellID->19285346],
Cell[55074, 1625, 169, 5, 36, "Output",
 CellID->14035408]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55304, 1637, 311, 9, 70, "SeeAlsoSection",
 CellID->15749],
Cell[55618, 1648, 937, 35, 70, "SeeAlso",
 CellID->31539]
}, Open  ]],
Cell[CellGroupData[{
Cell[56592, 1688, 314, 9, 70, "TutorialsSection",
 CellID->17757],
Cell[56909, 1699, 163, 3, 70, "Tutorials",
 CellID->29240],
Cell[57075, 1704, 141, 3, 70, "Tutorials",
 CellID->581],
Cell[57219, 1709, 148, 3, 70, "Tutorials",
 CellID->13623]
}, Open  ]],
Cell[CellGroupData[{
Cell[57404, 1717, 321, 9, 70, "RelatedLinksSection",
 CellID->15941],
Cell[57728, 1728, 346, 11, 70, "RelatedLinks"],
Cell[58077, 1741, 178, 4, 70, "RelatedLinks"],
Cell[58258, 1747, 195, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58490, 1756, 318, 9, 70, "MoreAboutSection",
 CellID->57342527],
Cell[58811, 1767, 189, 4, 70, "MoreAbout",
 CellID->25449330],
Cell[59003, 1773, 155, 3, 70, "MoreAbout",
 CellID->182109352],
Cell[59161, 1778, 139, 3, 70, "MoreAbout",
 CellID->219219328],
Cell[59303, 1783, 149, 3, 70, "MoreAbout",
 CellID->640660513]
}, Open  ]],
Cell[59467, 1789, 27, 0, 70, "History"],
Cell[59497, 1791, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

