(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    128278,       4077]
NotebookOptionsPosition[    111622,       3508]
NotebookOutlinePosition[    113619,       3555]
CellTagsIndexPosition[    113532,       3550]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
          "Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/Inequalities-SymbolicMathematics"], 
          "Minimization and Maximization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MinimizationAndMaximization"], 
          "Constrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"Inequalities\"\>", 3->"\<\"Minimization and Maximization\"\>", 
       4->"\<\"Constrained Optimization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Maximize" :> Documentation`HelpLookup["paclet:ref/Maximize"], 
          "NMinimize" :> Documentation`HelpLookup["paclet:ref/NMinimize"], 
          "FindMinimum" :> Documentation`HelpLookup["paclet:ref/FindMinimum"],
           "Min" :> Documentation`HelpLookup["paclet:ref/Min"], "D" :> 
          Documentation`HelpLookup["paclet:ref/D"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], 
          "LinearProgramming" :> 
          Documentation`HelpLookup["paclet:ref/LinearProgramming"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Maximize\"\>", 
       2->"\<\"NMinimize\"\>", 3->"\<\"FindMinimum\"\>", 4->"\<\"Min\"\>", 
       5->"\<\"D\"\>", 6->"\<\"FindInstance\"\>", 
       7->"\<\"LinearProgramming\"\>", 
       8->"\<\"LeastSquares\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Calculus\"\>", 3->"\<\"Discrete Mathematics\"\>", 
       4->"\<\"Polynomial Systems\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Minimize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Minimize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Minimize"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Minimize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Minimize"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["cons", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Minimize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Minimize"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["cons", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes with variables over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ", typically ",
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Integers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " returns a list of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["min", "TI"]], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "->", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]]}], ",", 
      RowBox[{
       StyleBox["y", "TI"], "->", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["min", "TI"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20229],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " can contain equations, inequalities or logical combinations of these. "
}], "Notes",
 CellID->19298],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " are linear or polynomial, ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " will always find a global minimum. "
}], "Notes",
 CellID->29356],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " will return exact results if given exact input. "
}], "Notes",
 CellID->5470],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " is given an expression containing approximate numbers, it automatically \
calls ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->148710633],

Cell[TextData[{
 "If the minimum is achieved only infinitesimally outside the region defined \
by the constraints, or only asymptotically, ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " will return the infimum and the closest specifiable point. "
}], "Notes",
 CellID->23175],

Cell["\<\
If no domain is specified, all variables are assumed to be real. \
\>", "Notes",
 CellID->24196],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 " can be used to specify that a particular variable can take on only integer \
values. "
}], "Notes",
 CellID->1683],

Cell[TextData[{
 "If the constraints cannot be satisfied, ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"+", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "->", 
       ButtonBox["Indeterminate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Indeterminate"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9988],

Cell["\<\
Even if the same minimum is achieved at several points, only one is returned. \
\
\>", "Notes",
 CellID->7619]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4078014],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->21722904],

Cell["Minimize a univariate function:", "ExampleText",
 CellID->95476681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"3", "x"}], "+", "5"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303084943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["31", "8"], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "4"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{96, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54626474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187776654],

Cell["Minimize a multivariate function:", "ExampleText",
 CellID->3230957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "-", "3"}], ")"}], "^", "2"}], "+", "1"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114846595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165841479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275658031],

Cell["Minimize a function subject to constraints:", "ExampleText",
 CellID->514914013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306285297],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox["5"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["4", 
        SqrtBox["5"]], "-", 
       SqrtBox["5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["2", 
       SqrtBox["5"]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{225, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445488467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61381153],

Cell["A minimization problem containing parameters:", "ExampleText",
 CellID->196243439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55196351],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{372, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295056732]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5794],

Cell["Unconstrained univariate polynomial minimization:", "ExampleText",
 CellID->268465082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"5", "x"}], "-", "7"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194093916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "7"}], "+", 
    RowBox[{"5", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"5", "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], "3"]}], 
    "+", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], "4"]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{411, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102716360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62740543],

Cell["Constrained univariate polynomial minimization:", "ExampleText",
 CellID->9290849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "-", "x", "+", "9"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", 
        RowBox[{"x", "^", "3"}]}], "+", 
       RowBox[{"5", "x"}], "-", "7"}], "\[GreaterEqual]", "0"}]}], "}"}], ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87280424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531083160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192428172],

Cell["Univariate transcendental minimization:", "ExampleText",
 CellID->207021031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], "\[LessEqual]", 
      RowBox[{"Cos", "[", "x", "]"}], "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133973068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", "\[Pi]"}], "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{103, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424375750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22982105],

Cell["Univariate piecewise minimization:", "ExampleText",
 CellID->454751844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"Floor", "[", 
       RowBox[{"x", "+", 
        RowBox[{"UnitStep", "[", 
         RowBox[{"x", "-", "1"}], "]"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"Ceiling", "[", 
       RowBox[{"Abs", "[", "x", "]"}], "]"}], "<", "5"}]}], "}"}], ",", "x"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301089152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408992288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21103409],

Cell["Multivariate linear constrained minimization:", "ExampleText",
 CellID->101386429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "-", "z"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3561804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46919576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271356286],

Cell["Linear-fractional constrained minimization: ", "ExampleText",
 CellID->260073986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "y", "-", "z"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", "x"}], "-", 
        RowBox[{"7", "y"}], "+", "3"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"0", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->695124919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "7"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["3", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340708084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489602931],

Cell["Unconstrained polynomial minimization:", "ExampleText",
 CellID->472029359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", "y"}]}], ")"}], "^", "2"}], "-", 
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"2", "y"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163965134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["5", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5868224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193283604],

Cell["Constrained polynomial optimization can always be solved:", \
"ExampleText",
 CellID->392024223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405571012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{183, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22245405]
}, Open  ]],

Cell["The minimum value may not be attained:", "ExampleText",
 CellID->426077459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[GreaterEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101417820],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"The minimum is not attained at any point satisfying the given \
constraints.\"\>"}]], "Message", "MSG",
 CellID->297313956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186100291]
}, Open  ]],

Cell["The objective function may be unbounded:", "ExampleText",
 CellID->262241521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->539447548],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"The minimum is not attained at any point satisfying the given \
constraints.\"\>"}]], "Message", "MSG",
 CellID->477710151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47936019]
}, Open  ]],

Cell["There may be no points satisfying the constraints:", "ExampleText",
 CellID->353970800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->248070447],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"infeas\"\>"}], ":", 
  " ", "\<\"There are no values of \\!\\({x, y}\\) for which the constraints \
\\!\\(\\(\\(x\\^2 + y\\^2\\)\\) < 0\\) are satisfied and the objective \
function \\!\\(x\\) is real-valued. \"\>"}]], "Message", "MSG",
 CellID->418814169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5870610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26152599],

Cell["Algebraic minimization:", "ExampleText",
 CellID->152197366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "+", "y"}], "]"}], "+", "x"}], " ", ",", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"Sqrt", "[", "y", "]"}]}], "\[GreaterEqual]", "1"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212088409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "283"}], "-", 
       RowBox[{"216", " ", "#1"}], "-", 
       RowBox[{"504", " ", 
        SuperscriptBox["#1", "2"]}], "-", 
       RowBox[{"288", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "7"]}]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "4"]}], "-", 
          SuperscriptBox["#1", "6"], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "7"]}]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], "+", "#1", "-", 
          RowBox[{"40", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["#1", "4"]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["#1", "5"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["#1", "7"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{421, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154074964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117376046],

Cell["Bounded transcendental minimization:", "ExampleText",
 CellID->352688884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "+", 
      RowBox[{"Log", "[", "y", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"Log", "[", "y", "]"}]}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"-", "10"}], "\[LessEqual]", "x", "\[LessEqual]", "10"}], "&&",
       
      RowBox[{
       RowBox[{"1", "/", "10"}], "\[LessEqual]", "y", "\[LessEqual]", 
       "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25329921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"Log", "[", "10", "]"}]]}]], "-", 
    RowBox[{"Log", "[", "10", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["2", 
        RowBox[{"Log", "[", "10", "]"}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "10"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{292, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1976620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642251835],

Cell["Piecewise minimization:", "ExampleText",
 CellID->357845437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"x", "-", "y"}], ",", 
       RowBox[{"Abs", "[", "y", "]"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"x", "-", "2"}], ",", 
        RowBox[{"x", "-", 
         RowBox[{"y", "^", "2"}]}]}], "]"}], "\[GreaterEqual]", 
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"x", " ", "y"}], "-", "1"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132161290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148924248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7039544],

Cell["Unconstrained parametric minimization:", "ExampleText",
 CellID->718818873],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->459540071],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWktrFEEQnp3ZmU1ifKLiC42KD0QFxRd614OIohHEgyT4wIBiUA+55eZJ
2GO8RVHIMT/Bn7BXb0ERcsxPGLt6unZ7vqmenllnVXBhZ7a6ux79VXd1d/Xe
mn37/OnL2bdzj2enbryenX8+9/jN1PVXr1VR1AqC1scgCE7sCdTvVP3SX/p8
Ut8g+KaeoSp6b95XdOkEPdsLCwtf9Wd9ff2zLlG/u92uevZ6vaNUErG0VEuw
6UsDSdHi4qIp/UJ6lIBjQ3GPqwc1+uCQsgD09kpSJ6DVUol0wmhHJalj6tFW
jTZB6/NA3zfaEtO3COrpZ9vUxebdxjbqEQu6xiy+mPnag/qgz7kZODu2JpFj
0qCRGawbFGzv2Hqt8s1WX2PztmXRJzT4bXOiyxIDoecXgJ42KJNFQdwvN9xh
jdLIXWrpk3knodW44MciF6GXOFBEb6MNEp/GKufT2OCPMwE5t0j2ltAho2iV
6dkjzuywrh8L47KWDy2psYBckYtsjg1afVwLrWIRXcSfZ0VfjpeDNQ3G/LYm
vCUj5vUXjhQcyWV+azfsrcjIxNkVi9IS09rvJ5xfw/ob7cJVqTm/xf14STLD
/twf+G0XyLok0MS3P200Xtaea4hZIqM8hDfQqw6OkXu0750a6IbBIFZrmwro
+vzNsce1U+AVWUKt6oq9FXjLx1KUDnYatgZpjxNZ7W3MeV5H5l3uvdAhwe93
1t0xva/rd/Zh1lB/TAnXsAbUjJLDSt7XiEdqs76oP7pK06YetUyIHhp+19L0
3gHxLh9Z2Bp7i/3A8UAWS/unMqu45xIf0ns99cV9Gmre7ZFQZ5RsbGzkRomi
HbjxSiP7vdouaTR7Fdf4SIxN+6AedzHEH3IEyyHP6ylisd0uFznoTRV7DZ2A
BPJyR5F7GvGlFO+r743k0mb3J67VAU/b6JtzQB+3aJJ/BOpPjQTPahFSXoOk
iIZ0EzsF7BPGORfidjuScw7ok8aW0SDNuQK0lkZw2bpvz7wg6Jc0sgrzHMax
aCMonVpxrJ4E+pDhO90IcohY2bqGtISXFKHqrUNjeQ5AF9HsGDS/V0IDdWet
lpaWVlZWUiFuSDFeiuDs6w7U09zm+Ez1mGWJCuiIsZZ2Xd1ud21tLfjh6Wcr
E2Pl1TKPuE/fvj5OAY2nc45OpGfcvMkjPwVLW4okC1sl3pifn1d9rWKpncOg
sXgY6i8K8slS8RQXKZNnZmaqY+ybWWMObZh5OQT0ZaA1SrkxghGj3hzw2f0u
ry/Nz7+daT56PTLvh83prrDaPAL6wX+k/SbQOJ7+vDXSaXa0VjRx31F+O1GI
D0PfYySpnJO4lsrZEvveZXQI/t27DNcpF5F3tXPfQuD+BTmvivZwTkZGxXcW
zzzhypry/dl0Ko8DvpfkvUTOQ3/4lsKfxbJP6MPcO+AJrpp/+IZHPmPK2U28
dUhE3rtiaZJa+7VC7RnLQ6O6j6ifR67P4bsDumZsKZ8d8h1rHbR5pyTz2Gj/
jduEf8ET8qzAs9bv++demnm8+vj//Zx89Zx7MbPmy7FXGeEce+sgJ2Vj7ogy
pNW9LqK+XDRF2iq5ZldOGmlfNvF2TbTyGZbpUswZCVfWddKSl7G4sqtbnC05
q8qncpxHd2wL5R5ZredK+4H75f1AH7Bo4sMz7JOBDe3V1dUsy97r9bgvL4yt
Z3ULdXrNWiwvL+N/rPaBpoNGgqyR/9t1AGoPCjS1e6a5qCj7b1jQ+gXxL3iL
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{416, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102790393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30496838],

Cell["Constrained parametric minimization:", "ExampleText",
 CellID->65207227],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "3"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "a"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->298396418],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGz1vHUXw/O6e7TzjxA4BTD6NSGxAUAQJBEpCrHxAigTcBBkqmwgpKVCe
QopXAI4rSzSukKGyoHHp0mXoXBDJP8Gly1e6gmVnP97tzc3e7n35EV6elLub
3dmZ2dnZ3flw7iw9vv/td0uPH9xbmv7s0VL7/oN7309/+vARbwqHgmDoryAI
Hk4F/JvxL/EPfs/4vyDo8GeDN11W77vq/Y16LwisK/AM9/f3xUgWfCRgTYkF
lxB8F8FLCP5SUH0LnlGn03kqfpz8pMBbXFysnk+4vLysWiWX3d3dW7dudbvd
4GMHl2sInkDw547+LCk4zAXZ2trykgJWZJLgTrXTXIVskWR5cHCwuro6ylua
fNg4f8PwENGBz0j1NdU7QjhjisYwHlsBzTHU3hQziGFJHTBfUpqQ7ARCivOw
wsXcjmVSrZ//lKGppnqbtODX4J/A+ELGyrbbbb6s/JN3jAhxezwUoWNkayNH
a2hvNWbUIrFGEFbUV2nw2oI0wxZbTK45WAGszxFqPgZ81EKxfs6vIzi1BxHc
0Bo22mYZZWkJG27yY3t9fV128eMkoK2uqcbQuyfXWuO9aM6BxbvHLkPURxla
Vj1gOmPG+N5T7t6MVbfrGdOvWxIv+6N17rRAwXuYW5s86/hvY2Njb28PbC9S
skUVr+uYokmdYHXxct89eCQegX0R973noli9DMUtBRrp23BcwNxCtre319bW
FE3p9/RmUdfdmLGyh3or5pZjcO0Nbr88Wqet7qiAuYnJUEmtArdCYy7AeIKk
qb1l7RlrX5DyCUKrtealEprUMvXcYLHn0dCzKLXWjdp44zXW4yWi+KkW3aP1
MEOu7Am0klOk7nEMhmdxptAo3G/zKamYoohviu/gqvhpTR9neLUxx7cVZtN4
29Ykhl9j0tJPImqnLe3HiXkm5YpM/mim0I7j3bQd2yiU50XtthEOvuexCjZd
bm5uci8KPj9Eo3A2AuvuLILPOfpd+Pj+ulFiVnxKfGI+szJ3GuzMMwh+A+Hj
fhc+lvp6oVm9guAPWDKH93KGlFrXgDftiWdKBbO66SW19sGxtBKOT1J44HXx
W218LuLzQHLi3p/B6cdClFsIHiE58XufO5j5OYGOSa8n5IG1stxXBczdCh7o
aA4/OTgMCQ7mTRmo8+VI7zxJnp5BuLCwsCx+AWSQLsFHKF1m6J4jOA5xEDgZ
3BLnGpm/C9vttlwY0bzuNRPa33GtDTx+8VoLOJOh0fARerupCD28b5+vkXIP
8PBJxtgCeaUEpfn5eRV76fwRdN5QOseraOZqdGaZ8mL9JACrbECS3WijvX0t
Ex2jNdQ73Yuzca7b2k9uPWu5Z2RdBLbkcE7ZEzlD68zwHLS/lu2FyV3Zi6y5
wezs7AgJIy99jipMzQWfFxMZXHuwLGVYonq7DGQO1Vs/tGQy88BP7k6nI0wO
9eu4DICbJL9JRu8JbFM0fxmDdrtdYxWDUObHmNrHt0m+s1705XnIicmsr0C+
oySeZYaHb/HGuFoUDI+fMzB7+T2MGXG9yluKm52Uh9ucOl1iXHlb8XNH3Wgt
cZtJNWjMHwQmfD3z+PqCZVdLV3pYWV6mq2q5XCEV0Bfsrjcd1MrWOGNuZut5
D655apo0F51VKVJl1Flw6rwuSnOwKpfaa/KpXMq/JhhTGKcIDodRC7Tfgilt
vahM1sAZV46KVCa/FizxDUlaVO2VPnr0f6HiOTjVRi+bclYb/a2q6opfi9HV
xWYNvAaruljcMqBR3lhe50yt9bpDvbMcdjqodUPKkvLWDcvYk29lr8WqrDL+
P+uDeC3964NflVjBF/XBrH6xHzPrgu8g+IrXWmgvZTDqgqBFqAO+q/o/iXUU
02VJ26Zz6DHsiuPrrgbOIfiymBOOM8KU7qg7AeY745hP3XXAOSWHtN9Ri5Sw
snGlJu6/wOqt962Q2tV2OE5Ia8Lw+INR+7KRWh+cIcF2B4/fY1pW+z2RPS7j
bHheMEEzGpxh+Wom17042GsK58mecvUQKVO+TJBdlmL1DSkDziYW1YOrjhFz
01h5uJSrVEjeF3Py9K1DFKOOqw2Syvssbee6qiCqJaLHnqG/yJKZeei5Fstn
8MP5c3jM5cTUUTvOrruy6UkKWTetLUNup1BFNvxwMsfm/zhyZY5hgPDTevcQ
ptbf7DG+FevJ16a8nQyYyprC47Rgi7FJbfYpc6rrJ3XlCr006cwV5tNlXflC
0hurNOtRXFu68aS3lvqRQ+uPBvPmjcrqMW/uSOOn/56rbOYFa8M/8wLop0ro
wJVHwZLDOVJFXiN95rvyGv94zdKW18Dz9M8+2HIKMAMzp8C85MO+DJbrnAO+
iuC/BVesOz0XHNPjv3s8i2Ack19VdKTuTX/GFn/7ZD2SPiglO75T/vTSLTye
DigmRDlg909YvjgYOpteHOjz4wnZWi4OjmXK59fSshSLg2MZqDxg5Jy5K/JN
0rdHvzSXcpFvzBtyRNCxQo73jXVjer+SdHBUG+P/xpLRLPQImxFfMnoNhv4F
l2S4Aw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{459, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85754847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462090459],

Cell["Integer linear programming:", "ExampleText",
 CellID->115493641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "-", "z"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}], " ", "&&", 
      RowBox[{"Element", "[", 
       RowBox[{
        RowBox[{"x", "|", "y", "|", "z"}], ",", "Integers"}], "]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111064747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81779148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528344132],

Cell["Polynomial minimization over the integers:", "ExampleText",
 CellID->119371554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"x", " ", "y"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{"Element", "[", 
       RowBox[{
        RowBox[{"x", "|", "y"}], ",", "Integers"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529056659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21475410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24837],

Cell["\<\
Finding the exact solution takes a long time due to high-degree algebraic \
number operations:\
\>", "ExampleText",
 CellID->422401855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "7"}], "-", 
          RowBox[{"3", " ", "x", " ", "y", " ", "z"}], "+", 
          RowBox[{"9", " ", 
           RowBox[{"z", "^", "3"}]}], "-", 
          RowBox[{"3", " ", "z"}]}], "==", "5"}], "&&", 
        RowBox[{
         RowBox[{"x", " ", "y", " ", "z"}], "\[GreaterEqual]", "4"}]}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], ",", "300"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5965103],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198987732]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "100"}]], 
  "InlineFormula"],
 ", we get an exact minimum value, but it might be incorrect:"
}], "ExampleText",
 CellID->358216118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "7"}], "-", 
         RowBox[{"3", " ", "x", " ", "y", " ", "z"}], "+", 
         RowBox[{"9", " ", 
          RowBox[{"z", "^", "3"}]}], "-", 
         RowBox[{"3", " ", "z"}]}], "==", "5"}], "&&", 
       RowBox[{
        RowBox[{"x", " ", "y", " ", "z"}], "\[GreaterEqual]", "4"}]}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173571601],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.296999999999997`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
         "-", "552384939695636978741359750332276780910490090727454843368740005\
86226147031452617561617068464441528481784330649"}], "+", 
         RowBox[{
         "58095142313093455631289492065939602726119222114858587224117366585493\
28231804244544474345182733705898424118976", " ", "#1"}], "-", 
         RowBox[{
         "23359544947209610857061451025032837383279527380431129978082010551514\
290901788319851401906545163000238896303876", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
         "13970451383785737218827862538164860795799658807069580373808884976569\
04016469680636083439194944533200368676653", " ", 
          SuperscriptBox["#1", "3"]}], "-", 
         RowBox[{
         "46554510640082812101262275242998076527779557649316964795621357221580\
91840730925600859147742128492837242162308", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{
         "15874993217489669375022443178583290419150632247403696048230149241496\
82986689845671718778585967427402172320342", " ", 
          SuperscriptBox["#1", "5"]}], "-", 
         RowBox[{
         "38055679000478203339528586338572039826510255200521653506391818653427\
5180040215775753493767258694813165525314", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         RowBox[{
         "47049962315474680577843353069259491818966176197725180313822217344967\
4880661653824563105044858723313559299021", " ", 
          SuperscriptBox["#1", "7"]}], "-", 
         RowBox[{
         "33291769962682439324079472136333400820024950358223252373312415080611\
084611641580673894670734259075674968344", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{
         "26409037388820214893232351380392562965322154586788827667869141311954\
957988385618608837861872428916556214770", " ", 
          SuperscriptBox["#1", "9"]}], "-", 
         RowBox[{
         "20435546803669728002940557365330169954213364418298198730993486771881\
719347019400020777914813806532924765034", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         RowBox[{
         "26712042261959900946448616948066573046980876561465755094651032980186\
4048052771940937237401137097619546942", " ", 
          SuperscriptBox["#1", "11"]}], "-", 
         RowBox[{
         "75122220085862284931385789178053280863318196389234492330372121617317\
8703785985942991905034651104569674322", " ", 
          SuperscriptBox["#1", "12"]}], "+", 
         RowBox[{
         "44341217357898703449868106371875310433032426028126232785734270291353\
5120133907547641655549593959783538796", " ", 
          SuperscriptBox["#1", "13"]}], "+", 
         RowBox[{
         "55013954588543414756729533243629720486957771968398576692743571579057\
19097559350025190501282425614142527", " ", 
          SuperscriptBox["#1", "14"]}], "+", 
         RowBox[{
         "11124756443645116450016167344154740491980159278129601634218321714042\
758458803532982350733317104477091090", " ", 
          SuperscriptBox["#1", "15"]}], "-", 
         RowBox[{
         "54563091682552673226306422114573535364042774171369110026068035116159\
70196389265551616076185055784458055", " ", 
          SuperscriptBox["#1", "16"]}], "-", 
         RowBox[{
         "20523701423797192597876117892664372361927110531990922290489852085275\
0776643060668800550674624644441906", " ", 
          SuperscriptBox["#1", "17"]}], "-", 
         RowBox[{
         "92305488644057724464879818401431999367007012452107635757277542911972\
890454402054571011997478526946059", " ", 
          SuperscriptBox["#1", "18"]}], "+", 
         RowBox[{
         "41708194821659849564384387755034087015749405715805572168957451776406\
357877553051488702131697989961018", " ", 
          SuperscriptBox["#1", "19"]}], "+", 
         RowBox[{
         "27401730926819128573586184456751108371973093334888695278688185643800\
20263846074301495261645798773114", " ", 
          SuperscriptBox["#1", "20"]}], "+", 
         RowBox[{
         "41766974711065089170999288815959416153672999327119365527744384633047\
4443302918128402637510961558981", " ", 
          SuperscriptBox["#1", "21"]}], "-", 
         RowBox[{
         "21551335340398035412400694478731544089124847440442416029484968780408\
2871971253147630715072809028396", " ", 
          SuperscriptBox["#1", "22"]}], "-", 
         RowBox[{
         "18903011955483765297725392038904326744889684638798372168938095594576\
232551301528861484459000388443", " ", 
          SuperscriptBox["#1", "23"]}], "-", 
         RowBox[{
         "73790934809318727807192391216487740633538580293496076837827238958991\
2177724127285254059336243259", " ", 
          SuperscriptBox["#1", "24"]}], "+", 
         RowBox[{
         "82576251960297787430033477187603330105962256960639268810059774304451\
3791173797089112757714691405", " ", 
          SuperscriptBox["#1", "25"]}], "+", 
         RowBox[{
         "67878080409338579779076771359881120268582627568692099543586538442583\
878531749009149535362942658", " ", 
          SuperscriptBox["#1", "26"]}], "-", 
         RowBox[{
         "21830361549528039228627808749880908425505212708603290538882023349596\
77594143928171364306783860", " ", 
          SuperscriptBox["#1", "27"]}], "-", 
         RowBox[{
         "24662415113528347052531825375569491788908427291174996020038050920144\
58789689821757598932187308", " ", 
          SuperscriptBox["#1", "28"]}], "-", 
         RowBox[{
         "85113334067520700953545668252041010625538605555639312274068524580618\
145942913049192912692488", " ", 
          SuperscriptBox["#1", "29"]}], "+", 
         RowBox[{
         "18282223478114904797257924664320447937466590530738493187594334341897\
190542069326792479945215", " ", 
          SuperscriptBox["#1", "30"]}], "+", 
         RowBox[{
         "50469201890401823670170098907435567211764472740195405041362597919705\
05180016724438686315647", " ", 
          SuperscriptBox["#1", "31"]}], "-", 
         RowBox[{
         "23109434723939664124775698987943674031824296924662700269119673163300\
3689096796103795652958", " ", 
          SuperscriptBox["#1", "32"]}], "-", 
         RowBox[{
         "63906159420609562372613394835399236607471339190476745595576550952659\
104740089176174053490", " ", 
          SuperscriptBox["#1", "33"]}], "-", 
         RowBox[{
         "28700279928251192534873633848944237310378786973707178047463520164127\
54920000744460138003", " ", 
          SuperscriptBox["#1", "34"]}], "+", 
         RowBox[{
         "10409940085857408940293982593846950213296951907901657967953115555013\
05942927871524657962", " ", 
          SuperscriptBox["#1", "35"]}], "+", 
         RowBox[{
         "14274891602046271182415679887397011042548563839194965094378752877224\
6177783525663446980", " ", 
          SuperscriptBox["#1", "36"]}], "-", 
         RowBox[{
         "17423269718174174156477076892558390731034253878484373366656878664808\
299061330805517391", " ", 
          SuperscriptBox["#1", "37"]}], "-", 
         RowBox[{
         "15121189070690326984451943132794226344126755550899497554718077778138\
04713072393875202", " ", 
          SuperscriptBox["#1", "38"]}], "-", 
         RowBox[{
         "16351542945944398535579313087190548476968562522949956384551362556565\
8708843178782068", " ", 
          SuperscriptBox["#1", "39"]}], "+", 
         RowBox[{
         "49827968888536506689713037781569794235478742062294423280591234327812\
794017592072838", " ", 
          SuperscriptBox["#1", "40"]}], "+", 
         RowBox[{
         "95913012798176706582498631071823788498571412846986272148755409017777\
6866967889635", " ", 
          SuperscriptBox["#1", "41"]}], "-", 
         RowBox[{
         "96897299676344676164140027996821315893445939280715792159330109038679\
352530512142", " ", 
          SuperscriptBox["#1", "42"]}], "-", 
         RowBox[{
         "40901555608645645805438973447455599059195206959438505407698482763658\
027405885674", " ", 
          SuperscriptBox["#1", "43"]}], "-", 
         RowBox[{
         "75993606244950200305500972725953704433576576392701320359890588449849\
7492182368", " ", 
          SuperscriptBox["#1", "44"]}], "+", 
         RowBox[{
         "59751183849914393174335122080515739527034747628669392502930979424719\
8007906878", " ", 
          SuperscriptBox["#1", "45"]}], "-", 
         RowBox[{
         "33771718034033833550191710966670808238799657399495718132284123124803\
696959891", " ", 
          SuperscriptBox["#1", "46"]}], "+", 
         RowBox[{
         "13526382296094468742662581381032997580891729345280768565908821128176\
91409618", " ", 
          SuperscriptBox["#1", "47"]}], "-", 
         RowBox[{
         "76295384028823633974561870275829033206085957326660922829542602229777\
9153801", " ", 
          SuperscriptBox["#1", "48"]}], "+", 
         RowBox[{
         "90117201031023701711085058678964191425748722781819522070005710195315\
258408", " ", 
          SuperscriptBox["#1", "49"]}], "-", 
         RowBox[{
         "10153453099184708499809568618426911722834041339268006505005772139224\
48640", " ", 
          SuperscriptBox["#1", "50"]}], "+", 
         RowBox[{
         "43464886109767942026592559395895120019208058747322275369238614194494\
0708", " ", 
          SuperscriptBox["#1", "51"]}], "-", 
         RowBox[{
         "68432809526370885569472462879496636577036485575572169544984646686164\
945", " ", 
          SuperscriptBox["#1", "52"]}], "+", 
         RowBox[{
         "28197494983995037071272754327709534557919219111835147082626509935202\
5", " ", 
          SuperscriptBox["#1", "53"]}], "-", 
         RowBox[{
         "13595280799036018270947713685391790683774517639700298521903498613445\
4", " ", 
          SuperscriptBox["#1", "54"]}], "+", 
         RowBox[{
         "22658801331726697118246189475652984472957529399500497536505831022409\
", " ", 
          SuperscriptBox["#1", "55"]}]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", 
        RowBox[{
        "-", "1.51976060365026228992347823124529407116270662029549135042216465\
4358`50.82013634599696"}]}], ",", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{
        "-", "1.5917881467842082985548815843079353412034694160651602411424`48.\
1213867041882"}]}], ",", 
       RowBox[{
       "z", "\[Rule]", 
        "1.6534822710786465033496866535363604085251423878512521430517545356107\
`49.195761575257805"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{578, 1977},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100414631]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28900],

Cell["\<\
Find the minimal perimeter among rectangles with a unit area:\
\>", "ExampleText",
 CellID->504661259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[Equal]", "1"}], "&&", 
      RowBox[{"x", ">", "0"}], "&&", 
      RowBox[{"y", ">", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37864644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468790736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6354034],

Cell["Find the minimal perimeter among triangles with a unit area:", \
"ExampleText",
 CellID->53431186],

Cell[BoxData[{
 RowBox[{
  RowBox[{"triangle", "=", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->545322231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "c"}], ",", 
     RowBox[{"triangle", "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"s", 
          RowBox[{"(", 
           RowBox[{"s", "-", "a"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"s", "-", "b"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"s", "-", "c"}], ")"}]}], "]"}], "^", "2"}], "\[Equal]", 
       "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100593768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "432"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "432"}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}]}]}], 
     ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{480, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->648377223]
}, Open  ]],

Cell["The minimal perimeter triangle is equilateral:", "ExampleText",
 CellID->439051982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "RootReduce"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->593915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "432"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{527, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->169716702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3021488],

Cell["Find the distance to a parabola from a point on its axis:", \
"ExampleText",
 CellID->776908962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", "c"}], ")"}], "^", "2"}]}], "]"}], ",", 
     RowBox[{"y", "\[Equal]", 
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->729262980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{580, 300},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290595560]
}, Open  ]],

Cell[TextData[{
 "Assuming a particular relationship between the ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " parameters:"
}], "ExampleText",
 CellID->283001851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"0", "<", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"2", "c"}], ")"}]}], "<", "a"}], ",", 
   RowBox[{"Refine", "@", " ", 
    RowBox[{"Minimize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", "c"}], ")"}], "^", "2"}]}], "]"}], ",", 
        RowBox[{"y", "\[Equal]", 
         RowBox[{"a", " ", 
          RowBox[{"x", "^", "2"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13268546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"4", " ", "a", " ", "c"}]}]], 
    RowBox[{"2", " ", "a"}]], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", 
           SuperscriptBox["a", "2"]], "-", 
          FractionBox[
           RowBox[{"4", " ", "c"}], "a"], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{"8", " ", "a", " ", "c"}]}], ")"}], " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            FractionBox["1", 
             SuperscriptBox["a", "2"]], "-", 
            FractionBox[
             RowBox[{"4", " ", "c"}], "a"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"4", "-", 
               RowBox[{"8", " ", "a", " ", "c"}]}], ")"}], " ", 
             SuperscriptBox["#1", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
        "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16445331]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13232],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " gives an exact global minimum of the objective function:"
}], "ExampleText",
 CellID->83860016],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "4"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "7"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "9"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "10"}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170192576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43630285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["35721", "64"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["11", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->268843611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10.5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "/.", 
          RowBox[{"%", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"%", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->220378345],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->582396917]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " attempts to find a global minimum numerically, but may find a local \
minimum:"
}], "ExampleText",
 CellID->179571605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17885355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "228.4001364327751`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.4024194394025435`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->795443214]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10.5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "/.", 
          RowBox[{"%", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"%", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->311368626],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7898307]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " finds local minima depending on the starting point:"
}], "ExampleText",
 CellID->31148106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindMinimum", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->186995912],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "228.40013643277274`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "1.4024194391813876`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "558.1406249999491`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "5.5000000002814`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->118602714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10.5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "/.", 
            RowBox[{"%", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
           RowBox[{"%", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "/.", 
            RowBox[{"%", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ",", 
           RowBox[{"%", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}],
      "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->560258836],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->109725712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148375834],

Cell["\<\
The minimum point satisfies the constraints, unless messages say otherwise:\
\>", "ExampleText",
 CellID->195277511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", 
          RowBox[{"3", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237456092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "4"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["4", "5"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["3", "5"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170485679]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "/.", 
  RowBox[{"m", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27441563],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->425150715]
}, Open  ]],

Cell[TextData[{
 "The given point minimizes the distance from the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", 
    FractionBox["3", "2"]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->460857148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.2"}], ",", "2.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.2"}], ",", "2.2"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Point", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", 
          RowBox[{"m", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->721702684],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->240964860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196947503],

Cell[TextData[{
 "When the minimum is not attained, ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " may give a point on the boundary:"
}], "ExampleText",
 CellID->556211698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", 
         RowBox[{"3", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421324397],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Minimize/wksol\\\", ButtonNote -> \
\\\"Minimize::wksol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->120187725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "4"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["4", "5"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["3", "5"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159101717]
}, Open  ]],

Cell[TextData[{
 "Here the objective function tends to the minimum value when ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " tends to infinity:"
}], "ExampleText",
 CellID->794807772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[Equal]", "1"}], "&&", 
      RowBox[{"x", ">", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390848494],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"The minimum is not attained at any point satisfying the given \
constraints.\"\>"}]], "Message", "MSG",
 CellID->561209731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "ComplexInfinity"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81947554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11671239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " can solve linear programming problems:"
}], "ExampleText",
 CellID->922674425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "-", "z"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747118779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299467683]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " can be used to solve the same problem given in matrix notation:"
}], "ExampleText",
 CellID->20812021],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->541483476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{"c", ",", "m", ",", "b", ",", 
   RowBox[{"-", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->116676670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "}"}]], "Output",
 ImageSize->{85, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->67544672]
}, Open  ]],

Cell["This computes the minimum value:", "ExampleText",
 CellID->600747964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", ".", "%"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->95719142],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->15366799]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12675],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " requires that all functions present in the input be real-valued:"
}], "ExampleText",
 CellID->42800722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "x", "]"}], "-", 
       RowBox[{"Sqrt", "[", "y", "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215217577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366027233]
}, Open  ]],

Cell["\<\
Values for which the equation is satisfied but the square roots are not real \
are disallowed:\
\>", "ExampleText",
 CellID->45228127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", "x", "]"}], "-", 
      RowBox[{"Sqrt", "[", "y", "]"}]}], "\[Equal]", "0"}], ",", 
    RowBox[{"Sqrt", "[", "x", "]"}], ",", 
    RowBox[{"Sqrt", "[", "y", "]"}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->748279558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "\[ImaginaryI]", ",", "\[ImaginaryI]"}], 
  "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38546476]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14341],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Maximize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Maximize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMinimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMinimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearProgramming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearProgramming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2946],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Inequalities-SymbolicMathematics"]], "Tutorials",\

 CellID->32190],

Cell[TextData[ButtonBox["Minimization and Maximization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MinimizationAndMaximization"]], "Tutorials",
 CellID->8275],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstrainedOptimizationOverview"]], "Tutorials",\

 CellID->78894921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2469],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#24355"], None}]], "RelatedLinks",
 CellID->25519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17809507],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->232159568],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->1460712],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->31417753],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->175799939],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->43513674]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Minimize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 46.9176306}", "context" -> "System`", 
    "keywords" -> {
     "constrained optimization", "cost function", "cylindrical decomposition",
       "exact optimization", "extremization", "global minimization", 
      "goal functions", "inequalities", "infeasible constraints", 
      "integer linear programming", "integer programming", 
      "linear fractional programming", "linear programming", 
      "LP (linear programming)", "minimization", "objective functions", 
      "operations research", "optimization", "parametric optimization", 
      "pay-off functions", "polynomial programming", "quadratic programming", 
      "simplex algorithm", "symbolic optimization"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Minimize[f, {x, y, ...}] minimizes f with respect to x, y, .... \
Minimize[{f, cons}, {x, y, ...}] minimizes f subject to the constraints cons. \
Minimize[{f, cons}, {x, y, ...}, dom] minimizes with variables over the \
domain dom, typically Reals or Integers.", "synonyms" -> {}, "title" -> 
    "Minimize", "type" -> "Symbol", "uri" -> "ref/Minimize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15115, 440, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4078014]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 113390, 3543}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3688, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4311, 107, 4192, 83, 70, "ObjectNameGrid"],
Cell[8506, 192, 2616, 86, 70, "Usage",
 CellID->9023]
}, Open  ]],
Cell[CellGroupData[{
Cell[11159, 283, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11637, 300, 713, 27, 70, "Notes",
 CellID->20229],
Cell[12353, 329, 179, 5, 70, "Notes",
 CellID->19298],
Cell[12535, 336, 370, 14, 70, "Notes",
 CellID->29356],
Cell[12908, 352, 215, 7, 70, "Notes",
 CellID->5470],
Cell[13126, 361, 387, 14, 70, "Notes",
 CellID->148710633],
Cell[13516, 377, 353, 9, 70, "Notes",
 CellID->23175],
Cell[13872, 388, 106, 3, 70, "Notes",
 CellID->24196],
Cell[13981, 393, 307, 10, 70, "Notes",
 CellID->1683],
Cell[14291, 405, 664, 24, 70, "Notes",
 CellID->9988],
Cell[14958, 431, 120, 4, 70, "Notes",
 CellID->7619]
}, Closed]],
Cell[CellGroupData[{
Cell[15115, 440, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4078014],
Cell[CellGroupData[{
Cell[15498, 454, 147, 5, 70, "ExampleSection",
 CellID->21722904],
Cell[15648, 461, 73, 1, 70, "ExampleText",
 CellID->95476681],
Cell[CellGroupData[{
Cell[15746, 466, 227, 8, 28, "Input",
 CellID->303084943],
Cell[15976, 476, 304, 11, 51, "Output",
 CellID->54626474]
}, Open  ]],
Cell[16295, 490, 125, 3, 70, "ExampleDelimiter",
 CellID->187776654],
Cell[16423, 495, 74, 1, 70, "ExampleText",
 CellID->3230957],
Cell[CellGroupData[{
Cell[16522, 500, 310, 12, 70, "Input",
 CellID->114846595],
Cell[16835, 514, 361, 13, 36, "Output",
 CellID->165841479]
}, Open  ]],
Cell[17211, 530, 125, 3, 70, "ExampleDelimiter",
 CellID->275658031],
Cell[17339, 535, 86, 1, 70, "ExampleText",
 CellID->514914013],
Cell[CellGroupData[{
Cell[17450, 540, 393, 14, 70, "Input",
 CellID->306285297],
Cell[17846, 556, 480, 19, 55, "Output",
 CellID->445488467]
}, Open  ]],
Cell[18341, 578, 124, 3, 70, "ExampleDelimiter",
 CellID->61381153],
Cell[18468, 583, 88, 1, 70, "ExampleText",
 CellID->196243439],
Cell[CellGroupData[{
Cell[18581, 588, 236, 8, 28, "Input",
 CellID->55196351],
Cell[18820, 598, 2465, 44, 133, "Output",
 Evaluatable->False,
 CellID->295056732]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21334, 648, 216, 7, 70, "ExampleSection",
 CellID->5794],
Cell[21553, 657, 92, 1, 70, "ExampleText",
 CellID->268465082],
Cell[CellGroupData[{
Cell[21670, 662, 262, 9, 70, "Input",
 CellID->194093916],
Cell[21935, 673, 1442, 50, 60, "Output",
 CellID->102716360]
}, Open  ]],
Cell[23392, 726, 124, 3, 70, "ExampleDelimiter",
 CellID->62740543],
Cell[23519, 731, 88, 1, 70, "ExampleText",
 CellID->9290849],
Cell[CellGroupData[{
Cell[23632, 736, 417, 15, 70, "Input",
 CellID->87280424],
Cell[24052, 753, 259, 9, 36, "Output",
 CellID->531083160]
}, Open  ]],
Cell[24326, 765, 125, 3, 70, "ExampleDelimiter",
 CellID->192428172],
Cell[24454, 770, 82, 1, 70, "ExampleText",
 CellID->207021031],
Cell[CellGroupData[{
Cell[24561, 775, 378, 12, 70, "Input",
 CellID->133973068],
Cell[24942, 789, 333, 12, 51, "Output",
 CellID->424375750]
}, Open  ]],
Cell[25290, 804, 124, 3, 70, "ExampleDelimiter",
 CellID->22982105],
Cell[25417, 809, 77, 1, 70, "ExampleText",
 CellID->454751844],
Cell[CellGroupData[{
Cell[25519, 814, 439, 15, 70, "Input",
 CellID->301089152],
Cell[25961, 831, 277, 10, 36, "Output",
 CellID->408992288]
}, Open  ]],
Cell[26253, 844, 124, 3, 70, "ExampleDelimiter",
 CellID->21103409],
Cell[26380, 849, 88, 1, 70, "ExampleText",
 CellID->101386429],
Cell[CellGroupData[{
Cell[26493, 854, 617, 18, 70, "Input",
 CellID->3561804],
Cell[27113, 874, 454, 16, 51, "Output",
 CellID->46919576]
}, Open  ]],
Cell[27582, 893, 125, 3, 70, "ExampleDelimiter",
 CellID->271356286],
Cell[27710, 898, 87, 1, 70, "ExampleText",
 CellID->260073986],
Cell[CellGroupData[{
Cell[27822, 903, 767, 23, 70, "Input",
 CellID->695124919],
Cell[28592, 928, 476, 17, 51, "Output",
 CellID->340708084]
}, Open  ]],
Cell[29083, 948, 125, 3, 70, "ExampleDelimiter",
 CellID->489602931],
Cell[29211, 953, 81, 1, 70, "ExampleText",
 CellID->472029359],
Cell[CellGroupData[{
Cell[29317, 958, 394, 14, 70, "Input",
 CellID->163965134],
Cell[29714, 974, 405, 15, 51, "Output",
 CellID->5868224]
}, Open  ]],
Cell[30134, 992, 125, 3, 70, "ExampleDelimiter",
 CellID->193283604],
Cell[30262, 997, 102, 2, 70, "ExampleText",
 CellID->392024223],
Cell[CellGroupData[{
Cell[30389, 1003, 398, 14, 70, "Input",
 CellID->405571012],
Cell[30790, 1019, 466, 18, 55, "Output",
 CellID->22245405]
}, Open  ]],
Cell[31271, 1040, 81, 1, 70, "ExampleText",
 CellID->426077459],
Cell[CellGroupData[{
Cell[31377, 1045, 345, 12, 70, "Input",
 CellID->101417820],
Cell[31725, 1059, 211, 5, 70, "Message",
 CellID->297313956],
Cell[31939, 1066, 341, 11, 36, "Output",
 CellID->186100291]
}, Open  ]],
Cell[32295, 1080, 83, 1, 70, "ExampleText",
 CellID->262241521],
Cell[CellGroupData[{
Cell[32403, 1085, 289, 10, 70, "Input",
 CellID->539447548],
Cell[32695, 1097, 211, 5, 70, "Message",
 CellID->477710151],
Cell[32909, 1104, 369, 12, 36, "Output",
 CellID->47936019]
}, Open  ]],
Cell[33293, 1119, 93, 1, 70, "ExampleText",
 CellID->353970800],
Cell[CellGroupData[{
Cell[33411, 1124, 334, 12, 70, "Input",
 CellID->248070447],
Cell[33748, 1138, 313, 6, 70, "Message",
 CellID->418814169],
Cell[34064, 1146, 349, 11, 36, "Output",
 CellID->5870610]
}, Open  ]],
Cell[34428, 1160, 124, 3, 70, "ExampleDelimiter",
 CellID->26152599],
Cell[34555, 1165, 66, 1, 70, "ExampleText",
 CellID->152197366],
Cell[CellGroupData[{
Cell[34646, 1170, 426, 15, 70, "Input",
 CellID->212088409],
Cell[35075, 1187, 1759, 55, 77, "Output",
 CellID->154074964]
}, Open  ]],
Cell[36849, 1245, 125, 3, 70, "ExampleDelimiter",
 CellID->117376046],
Cell[36977, 1250, 79, 1, 70, "ExampleText",
 CellID->352688884],
Cell[CellGroupData[{
Cell[37081, 1255, 635, 21, 70, "Input",
 CellID->25329921],
Cell[37719, 1278, 605, 21, 56, "Output",
 CellID->1976620]
}, Open  ]],
Cell[38339, 1302, 125, 3, 70, "ExampleDelimiter",
 CellID->642251835],
Cell[38467, 1307, 66, 1, 70, "ExampleText",
 CellID->357845437],
Cell[CellGroupData[{
Cell[38558, 1312, 629, 21, 70, "Input",
 CellID->132161290],
Cell[39190, 1335, 364, 13, 51, "Output",
 CellID->148924248]
}, Open  ]],
Cell[39569, 1351, 123, 3, 70, "ExampleDelimiter",
 CellID->7039544],
Cell[39695, 1356, 81, 1, 70, "ExampleText",
 CellID->718818873],
Cell[CellGroupData[{
Cell[39801, 1361, 283, 10, 70, "Input",
 CellID->459540071],
Cell[40087, 1373, 1981, 37, 70, "Output",
 Evaluatable->False,
 CellID->102790393]
}, Open  ]],
Cell[42083, 1413, 124, 3, 70, "ExampleDelimiter",
 CellID->30496838],
Cell[42210, 1418, 78, 1, 70, "ExampleText",
 CellID->65207227],
Cell[CellGroupData[{
Cell[42313, 1423, 483, 17, 70, "Input",
 CellID->298396418],
Cell[42799, 1442, 2782, 50, 70, "Output",
 Evaluatable->False,
 CellID->85754847]
}, Open  ]],
Cell[45596, 1495, 125, 3, 70, "ExampleDelimiter",
 CellID->462090459],
Cell[45724, 1500, 70, 1, 70, "ExampleText",
 CellID->115493641],
Cell[CellGroupData[{
Cell[45819, 1505, 752, 22, 70, "Input",
 CellID->111064747],
Cell[46574, 1529, 380, 13, 36, "Output",
 CellID->81779148]
}, Open  ]],
Cell[46969, 1545, 125, 3, 70, "ExampleDelimiter",
 CellID->528344132],
Cell[47097, 1550, 85, 1, 70, "ExampleText",
 CellID->119371554],
Cell[CellGroupData[{
Cell[47207, 1555, 513, 17, 70, "Input",
 CellID->529056659],
Cell[47723, 1574, 360, 13, 36, "Output",
 CellID->21475410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48132, 1593, 218, 7, 70, "ExampleSection",
 CellID->13341],
Cell[CellGroupData[{
Cell[48375, 1604, 233, 7, 70, "ExampleSubsection",
 CellID->24837],
Cell[48611, 1613, 145, 4, 70, "ExampleText",
 CellID->422401855],
Cell[CellGroupData[{
Cell[48781, 1621, 814, 26, 70, "Input",
 CellID->5965103],
Cell[49598, 1649, 165, 5, 36, "Output",
 CellID->198987732]
}, Open  ]],
Cell[49778, 1657, 294, 10, 70, "ExampleText",
 CellID->358216118],
Cell[CellGroupData[{
Cell[50097, 1671, 815, 26, 70, "Input",
 CellID->173571601],
Cell[50915, 1699, 10717, 249, 1998, "Output",
 CellID->100414631]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[61693, 1955, 223, 7, 70, "ExampleSection",
 CellID->28900],
Cell[61919, 1964, 112, 3, 70, "ExampleText",
 CellID->504661259],
Cell[CellGroupData[{
Cell[62056, 1971, 448, 16, 70, "Input",
 CellID->37864644],
Cell[62507, 1989, 317, 11, 36, "Output",
 CellID->468790736]
}, Open  ]],
Cell[62839, 2003, 123, 3, 70, "ExampleDelimiter",
 CellID->6354034],
Cell[62965, 2008, 104, 2, 70, "ExampleText",
 CellID->53431186],
Cell[63072, 2012, 572, 20, 70, "Input",
 CellID->545322231],
Cell[CellGroupData[{
Cell[63669, 2036, 636, 21, 70, "Input",
 CellID->100593768],
Cell[64308, 2059, 1410, 49, 58, "Output",
 CellID->648377223]
}, Open  ]],
Cell[65733, 2111, 89, 1, 70, "ExampleText",
 CellID->439051982],
Cell[CellGroupData[{
Cell[65847, 2116, 99, 3, 70, "Input",
 CellID->593915],
Cell[65949, 2121, 1151, 40, 58, "Output",
 CellID->169716702]
}, Open  ]],
Cell[67115, 2164, 123, 3, 70, "ExampleDelimiter",
 CellID->3021488],
Cell[67241, 2169, 102, 2, 70, "ExampleText",
 CellID->776908962],
Cell[CellGroupData[{
Cell[67368, 2175, 489, 17, 70, "Input",
 CellID->729262980],
Cell[67860, 2194, 5133, 88, 70, "Output",
 Evaluatable->False,
 CellID->290595560]
}, Open  ]],
Cell[73008, 2285, 260, 9, 70, "ExampleText",
 CellID->283001851],
Cell[CellGroupData[{
Cell[73293, 2298, 731, 24, 70, "Input",
 CellID->13268546],
Cell[74027, 2324, 1795, 56, 89, "Output",
 CellID->16445331]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75871, 2386, 233, 7, 70, "ExampleSection",
 CellID->13232],
Cell[76107, 2395, 233, 7, 70, "ExampleText",
 CellID->83860016],
Cell[76343, 2404, 503, 18, 70, "Input",
 CellID->170192576],
Cell[CellGroupData[{
Cell[76871, 2426, 126, 4, 70, "Input",
 CellID->43630285],
Cell[77000, 2432, 331, 12, 51, "Output",
 CellID->268843611]
}, Open  ]],
Cell[CellGroupData[{
Cell[77368, 2449, 596, 19, 70, "Input",
 CellID->220378345],
Cell[77967, 2470, 3177, 56, 70, "Output",
 Evaluatable->False,
 CellID->582396917]
}, Open  ]],
Cell[81159, 2529, 258, 8, 70, "ExampleText",
 CellID->179571605],
Cell[CellGroupData[{
Cell[81442, 2541, 127, 4, 70, "Input",
 CellID->17885355],
Cell[81572, 2547, 315, 11, 36, "Output",
 CellID->795443214]
}, Open  ]],
Cell[CellGroupData[{
Cell[81924, 2563, 596, 19, 70, "Input",
 CellID->311368626],
Cell[82523, 2584, 3191, 56, 70, "Output",
 Evaluatable->False,
 CellID->7898307]
}, Open  ]],
Cell[85729, 2643, 234, 7, 70, "ExampleText",
 CellID->31148106],
Cell[CellGroupData[{
Cell[85988, 2654, 275, 10, 70, "Input",
 CellID->186995912],
Cell[86266, 2666, 533, 18, 36, "Output",
 CellID->118602714]
}, Open  ]],
Cell[CellGroupData[{
Cell[86836, 2689, 1153, 36, 70, "Input",
 CellID->560258836],
Cell[87992, 2727, 3246, 57, 70, "Output",
 Evaluatable->False,
 CellID->109725712]
}, Open  ]],
Cell[91253, 2787, 125, 3, 70, "ExampleDelimiter",
 CellID->148375834],
Cell[91381, 2792, 126, 3, 70, "ExampleText",
 CellID->195277511],
Cell[CellGroupData[{
Cell[91532, 2799, 609, 21, 70, "Input",
 CellID->237456092],
Cell[92144, 2822, 389, 14, 51, "Output",
 CellID->170485679]
}, Open  ]],
Cell[CellGroupData[{
Cell[92570, 2841, 252, 9, 70, "Input",
 CellID->27441563],
Cell[92825, 2852, 161, 5, 36, "Output",
 CellID->425150715]
}, Open  ]],
Cell[93001, 2860, 226, 8, 70, "ExampleText",
 CellID->460857148],
Cell[CellGroupData[{
Cell[93252, 2872, 1015, 33, 70, "Input",
 CellID->721702684],
Cell[94270, 2907, 3267, 58, 70, "Output",
 Evaluatable->False,
 CellID->240964860]
}, Open  ]],
Cell[97552, 2968, 125, 3, 70, "ExampleDelimiter",
 CellID->196947503],
Cell[97680, 2973, 250, 8, 70, "ExampleText",
 CellID->556211698],
Cell[CellGroupData[{
Cell[97955, 2985, 558, 20, 70, "Input",
 CellID->421324397],
Cell[98516, 3007, 440, 8, 70, "Message",
 CellID->120187725],
Cell[98959, 3017, 389, 14, 51, "Output",
 CellID->159101717]
}, Open  ]],
Cell[99363, 3034, 199, 6, 70, "ExampleText",
 CellID->794807772],
Cell[CellGroupData[{
Cell[99587, 3044, 341, 12, 70, "Input",
 CellID->390848494],
Cell[99931, 3058, 211, 5, 70, "Message",
 CellID->561209731],
Cell[100145, 3065, 332, 12, 36, "Output",
 CellID->81947554]
}, Open  ]],
Cell[100492, 3080, 124, 3, 70, "ExampleDelimiter",
 CellID->11671239],
Cell[100619, 3085, 216, 7, 70, "ExampleText",
 CellID->922674425],
Cell[CellGroupData[{
Cell[100860, 3096, 619, 18, 70, "Input",
 CellID->747118779],
Cell[101482, 3116, 455, 16, 51, "Output",
 CellID->299467683]
}, Open  ]],
Cell[101952, 3135, 258, 7, 70, "ExampleText",
 CellID->20812021],
Cell[102213, 3144, 1170, 41, 70, "Input",
 CellID->541483476],
Cell[CellGroupData[{
Cell[103408, 3189, 182, 5, 70, "Input",
 CellID->116676670],
Cell[103593, 3196, 296, 11, 51, "Output",
 CellID->67544672]
}, Open  ]],
Cell[103904, 3210, 75, 1, 70, "ExampleText",
 CellID->600747964],
Cell[CellGroupData[{
Cell[104004, 3215, 91, 3, 70, "Input",
 CellID->95719142],
Cell[104098, 3220, 157, 5, 36, "Output",
 CellID->15366799]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[104304, 3231, 226, 7, 70, "ExampleSection",
 CellID->12675],
Cell[104533, 3240, 241, 7, 70, "ExampleText",
 CellID->42800722],
Cell[CellGroupData[{
Cell[104799, 3251, 383, 13, 70, "Input",
 CellID->215217577],
Cell[105185, 3266, 317, 11, 36, "Output",
 CellID->366027233]
}, Open  ]],
Cell[105517, 3280, 144, 4, 70, "ExampleText",
 CellID->45228127],
Cell[CellGroupData[{
Cell[105686, 3288, 495, 17, 70, "Input",
 CellID->748279558],
Cell[106184, 3307, 242, 8, 36, "Output",
 CellID->38546476]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106487, 3322, 311, 9, 70, "SeeAlsoSection",
 CellID->14341],
Cell[106801, 3333, 1939, 71, 70, "SeeAlso",
 CellID->26197]
}, Open  ]],
Cell[CellGroupData[{
Cell[108777, 3409, 313, 9, 70, "TutorialsSection",
 CellID->2946],
Cell[109093, 3420, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[109286, 3426, 157, 4, 70, "Tutorials",
 CellID->32190],
Cell[109446, 3432, 166, 3, 70, "Tutorials",
 CellID->8275],
Cell[109615, 3437, 171, 4, 70, "Tutorials",
 CellID->78894921]
}, Open  ]],
Cell[CellGroupData[{
Cell[109823, 3446, 320, 9, 70, "RelatedLinksSection",
 CellID->2469],
Cell[110146, 3457, 254, 5, 70, "RelatedLinks",
 CellID->25519]
}, Open  ]],
Cell[CellGroupData[{
Cell[110437, 3467, 318, 9, 70, "MoreAboutSection",
 CellID->17809507],
Cell[110758, 3478, 156, 3, 70, "MoreAbout",
 CellID->232159568],
Cell[110917, 3483, 126, 3, 70, "MoreAbout",
 CellID->1460712],
Cell[111046, 3488, 150, 3, 70, "MoreAbout",
 CellID->31417753],
Cell[111199, 3493, 147, 3, 70, "MoreAbout",
 CellID->175799939],
Cell[111349, 3498, 178, 3, 70, "MoreAbout",
 CellID->43513674]
}, Open  ]],
Cell[111542, 3504, 50, 0, 70, "History"],
Cell[111595, 3506, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

