(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13382,        520]
NotebookOptionsPosition[      9940,        401]
NotebookOutlinePosition[     11098,        436]
CellTagsIndexPosition[     11013,        431]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/Arithmetic"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Arithmetic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subtract" :> Documentation`HelpLookup["paclet:ref/Subtract"], 
          "Plus" :> Documentation`HelpLookup["paclet:ref/Plus"], 
          "SubtractFrom" :> 
          Documentation`HelpLookup["paclet:ref/SubtractFrom"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subtract\"\>", 2->"\<\"Plus\"\>", 
       3->"\<\"SubtractFrom\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Syntax" :> 
          Documentation`HelpLookup["paclet:guide/Syntax"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematica Syntax\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Minus", "ObjectName",
 CellID->3198],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"-", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is the arithmetic negation of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12280]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " on input. "
}], "Notes",
 CellID->27479]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->254332],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->565703319],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minus"]], "InlineFormula"],
 " automatically distributes over groupings:"
}], "ExampleText",
 CellID->420586188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    RowBox[{"x", "^", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352326788],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "x", "-", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30449347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->513858270],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minus"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->473848263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623014647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176246826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188875688],

Cell[TextData[{
 "Explicit ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->115190554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minus", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448421756],

Cell[BoxData[
 RowBox[{"-", "x"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450940290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207465212],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "x"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->322669956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236819973],

Cell[TextData[{
 "Pattern match both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->158270858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "x"}]}], "}"}], ",", 
   RowBox[{"a_.", " ", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175880071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "x"}], "}"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250040042]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29846],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subtract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subtract"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubtractFrom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubtractFrom"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32707],

Cell[TextData[ButtonBox["Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Arithmetic"]], "Tutorials",
 CellID->1813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Mathematica Syntax",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Syntax"]], "MoreAbout",
 CellID->589032306]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Minus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 52.9021588}", "context" -> "System`", 
    "keywords" -> {"-", "minus"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "-x is the arithmetic negation of x. ", "synonyms" -> {}, "title" -> 
    "Minus", "type" -> "Symbol", "uri" -> "ref/Minus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3910, 135, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->254332]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10873, 424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1882, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2505, 75, 42, 1, 70, "ObjectName",
 CellID->3198],
Cell[2550, 78, 442, 15, 70, "Usage",
 CellID->12280]
}, Open  ]],
Cell[CellGroupData[{
Cell[3029, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3507, 115, 366, 15, 70, "Notes",
 CellID->27479]
}, Closed]],
Cell[CellGroupData[{
Cell[3910, 135, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->254332],
Cell[CellGroupData[{
Cell[4292, 149, 148, 5, 70, "ExampleSection",
 CellID->565703319],
Cell[4443, 156, 213, 7, 70, "ExampleText",
 CellID->420586188],
Cell[CellGroupData[{
Cell[4681, 167, 169, 6, 28, "Input",
 CellID->352326788],
Cell[4853, 175, 231, 8, 36, "Output",
 CellID->30449347]
}, Open  ]],
Cell[5099, 186, 125, 3, 70, "ExampleDelimiter",
 CellID->513858270],
Cell[5227, 191, 204, 7, 70, "ExampleText",
 CellID->473848263],
Cell[CellGroupData[{
Cell[5456, 202, 144, 5, 70, "Input",
 CellID->623014647],
Cell[5603, 209, 270, 10, 36, "Output",
 CellID->176246826]
}, Open  ]],
Cell[5888, 222, 125, 3, 70, "ExampleDelimiter",
 CellID->188875688],
Cell[6016, 227, 192, 8, 70, "ExampleText",
 CellID->115190554],
Cell[CellGroupData[{
Cell[6233, 239, 101, 3, 70, "Input",
 CellID->448421756],
Cell[6337, 244, 175, 6, 36, "Output",
 CellID->450940290]
}, Open  ]],
Cell[CellGroupData[{
Cell[6549, 255, 104, 3, 70, "Input",
 CellID->207465212],
Cell[6656, 260, 368, 14, 50, "Output",
 CellID->322669956]
}, Open  ]],
Cell[7039, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->236819973],
Cell[7167, 282, 226, 10, 70, "ExampleText",
 CellID->158270858],
Cell[CellGroupData[{
Cell[7418, 296, 220, 8, 70, "Input",
 CellID->175880071],
Cell[7641, 306, 198, 7, 36, "Output",
 CellID->250040042]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7900, 320, 311, 9, 70, "SeeAlsoSection",
 CellID->29846],
Cell[8214, 331, 695, 26, 70, "SeeAlso",
 CellID->7271]
}, Open  ]],
Cell[CellGroupData[{
Cell[8946, 362, 314, 9, 70, "TutorialsSection",
 CellID->32707],
Cell[9263, 373, 130, 3, 70, "Tutorials",
 CellID->1813]
}, Open  ]],
Cell[CellGroupData[{
Cell[9430, 381, 299, 8, 70, "MoreAboutSection"],
Cell[9732, 391, 136, 3, 70, "MoreAbout",
 CellID->589032306]
}, Open  ]],
Cell[9883, 397, 27, 0, 70, "History"],
Cell[9913, 399, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

