(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70949,       2293]
NotebookOptionsPosition[     59543,       1884]
NotebookOutlinePosition[     61375,       1939]
CellTagsIndexPosition[     61237,       1932]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PowerMod" :> Documentation`HelpLookup["paclet:ref/PowerMod"], 
          "Quotient" :> Documentation`HelpLookup["paclet:ref/Quotient"], 
          "Divisible" :> Documentation`HelpLookup["paclet:ref/Divisible"], 
          "CoprimeQ" :> Documentation`HelpLookup["paclet:ref/CoprimeQ"], 
          "FractionalPart" :> 
          Documentation`HelpLookup["paclet:ref/FractionalPart"], 
          "MantissaExponent" :> 
          Documentation`HelpLookup["paclet:ref/MantissaExponent"], 
          "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"], 
          "PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"], "Xor" :> 
          Documentation`HelpLookup["paclet:ref/Xor"], "Modulus" :> 
          Documentation`HelpLookup["paclet:ref/Modulus"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PowerMod\"\>", 2->"\<\"Quotient\"\>", 
       3->"\<\"Divisible\"\>", 4->"\<\"CoprimeQ\"\>", 
       5->"\<\"FractionalPart\"\>", 6->"\<\"MantissaExponent\"\>", 
       7->"\<\"PolynomialMod\"\>", 8->"\<\"PolynomialRemainder\"\>", 
       9->"\<\"Xor\"\>", 10->"\<\"Modulus\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"Integer Functions\"\>", 4->"\<\"Mathematical Functions\"\>", 
       5->"\<\"Number Theoretic Functions\"\>", 
       6->"\<\"Numerical Functions\"\>", 
       7->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mod", "ObjectName",
 CellID->527],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Mod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Mod"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the remainder on division of ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " by ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Mod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Mod"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses an offset ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15282]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 "For integers ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " lies between 0 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->26393],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " gives a result in the range ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", suitable for use in functions such as ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28134,
  ButtonNote->"28134"]
}], "Notes",
 CellID->17187],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " gives a result ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[LessEqual]", "x", "<", "d", "+", "n"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "mod", "n", "=", "m", "mod", "n"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->7863],

Cell[TextData[{
 "The sign of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is always the same as the sign of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", at least so long as ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " are both real. "
}], "Notes",
 CellID->23961],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "-", 
   RowBox[{
    StyleBox["n", "TI"], 
    StyleBox[" ", "TI"], 
    RowBox[{"Quotient", "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "-", 
   RowBox[{
    StyleBox["n", "TI"], 
    StyleBox[" ", "TI"], 
    RowBox[{"Quotient", "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["d", "TI"]}], "]"}]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28599],

Cell[TextData[{
 "The arguments of ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " can be any numeric quantities, not necessarily integers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6881,
  ButtonNote->"6881"]
}], "Notes",
 CellID->19251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " gives the fractional part of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27318],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12081],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " works with complex numbers, using its definition in terms of ",
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11802743],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47275922],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->5868024],

Cell["Remainders mod 3:", "ExampleText",
 CellID->25756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}],
     "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "0", ",", "1", ",", "2", ",", "0", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507103460]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9298],

Cell["Remainders mod 3 offset to start with 1:", "ExampleText",
 CellID->25343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}],
     "}"}], ",", "3", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "1", ",", "2", ",", "3", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160143861]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25352],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Evaluation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14062],

Cell["Reduce an approximate number:", "ExampleText",
 CellID->8411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"4.56", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16811],

Cell[BoxData["0.5599999999999996`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5626261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17405],

Cell["Reduce an exact numeric quantity:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "Pi", "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3651],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "22"}], "+", 
  SuperscriptBox["\[ExponentialE]", "\[Pi]"]}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257622738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17898],

Cell[BoxData["1.1406926327792668`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->479421355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15842],

Cell[TextData[{
 "Reduce mod ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->5694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"20", ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5084],

Cell[BoxData[
 RowBox[{"20", "-", 
  RowBox[{"6", " ", "\[Pi]"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52436391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16500],

Cell["Complex number:", "ExampleText",
 CellID->10955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"-", "113"}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31155],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "10"}], " ", "\[ImaginaryI]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox["113"]}]}]], "Output",
 ImageSize->{99, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138964759]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Manipulation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "n"}], "+", "1"}], ",", "2"}], "]"}], ",", 
   RowBox[{"n", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6688],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417190228]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "^", "16"}], ",", "2"}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4010],

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["x", "8"]}], ",", "2"}], "]"}]], "Output",
 ImageSize->{90, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->409774234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14932],

Cell["Wilson\[CloseCurlyQuote]s theorem:", "ExampleText",
 CellID->14948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "!"}], ",", "p"}], "]"}], ",", 
   RowBox[{"p", "\[Element]", "Primes"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31210],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "p"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103569671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26419],

Cell["Solve a modular equation:", "ExampleText",
 CellID->14648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "+", "1"}], ",", "5"}], "]"}], "==", 
     RowBox[{"Mod", "[", 
      RowBox[{"x", ",", "7"}], "]"}]}], "&&", 
    RowBox[{"0", "<", "x", "<", "50"}]}], ",", "x"}], "]"}]], "Input",
 CellTags->"S3.4.9",
 CellLabel->"In[1]:=",
 CellID->4189],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "4"}], "||", 
  RowBox[{"x", "\[Equal]", "7"}], "||", 
  RowBox[{"x", "\[Equal]", "15"}], "||", 
  RowBox[{"x", "\[Equal]", "23"}], "||", 
  RowBox[{"x", "\[Equal]", "31"}], "||", 
  RowBox[{"x", "\[Equal]", "39"}], "||", 
  RowBox[{"x", "\[Equal]", "42"}]}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.4.9",
 CellLabel->"Out[1]=",
 CellID->236808188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15851],

Cell["Evaluate an integral:", "ExampleText",
 CellID->3695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11223],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "46"}], "+", 
    RowBox[{"9", " ", 
     SqrtBox["2"]}], "+", 
    RowBox[{"6", " ", 
     SqrtBox["3"]}], "+", 
    RowBox[{"3", " ", 
     SqrtBox["6"]}], "+", 
    RowBox[{"3", " ", 
     SqrtBox["10"]}], "+", 
    RowBox[{"3", " ", 
     SqrtBox["14"]}]}], ")"}]}]], "Output",
 ImageSize->{301, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413636024]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24407],

Cell["Extract parts cyclically:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", "3", ",", "1"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "c", ",", "a", ",", "b", 
   ",", "c", ",", "a"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353294812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14812],

Cell["Select primes equal to 1 modulo 3:", "ExampleText",
 CellID->20641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Prime", ",", "50"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"#", ",", "3"}], "]"}], "==", "1"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7", ",", "13", ",", "19", ",", "31", ",", "37", ",", "43", ",", "61", ",", 
   "67", ",", "73", ",", "79", ",", "97", ",", "103", ",", "109", ",", "127", 
   ",", "139", ",", "151", ",", "157", ",", "163", ",", "181", ",", "193", 
   ",", "199", ",", "211", ",", "223", ",", "229"}], "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644425580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23162],

Cell["Simulate a particle bouncing in a non-commensurate box:", "ExampleText",
 CellID->12537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"t", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20", ",", ".001"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18551],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->536466414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31565],

Cell["Define a notation for addition mod 2:", "ExampleText",
 CellID->18938],

Cell[BoxData[
 RowBox[{
  RowBox[{"x_", "\[CirclePlus]", "y_"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "\[CirclePlus]", "0"}], ")"}], "\[CirclePlus]", 
  "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21228],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1782380]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14526],

Cell["The results have the same sign as the second argument:", "ExampleText",
 CellID->2178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}], ",",
    "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15745],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "0", ",", "1", ",", "2", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12761758]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}], ",",
    
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92909667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{"x", ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5312],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->415509403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25199],

Cell[TextData[{
 "Expressions generated by ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " can be difficult to evaluate with machine precision:"
}], "ExampleText",
 CellID->24727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"GoldenRatio", "^", "100"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32692],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "792070839848372253126"}], "+", 
  SuperscriptBox["GoldenRatio", "100"]}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75569903]
}, Open  ]],

Cell["\<\
Machine-precision numerical evaluation gives the wrong answer:\
\>", "ExampleText",
 CellID->27795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26542],

Cell[BoxData["2.62144`*^6"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66713240]
}, Open  ]],

Cell["Arbitrary precision gives the correct answer:", "ExampleText",
 CellID->27149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", "30"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12376],

Cell[BoxData["0.999999999999999999998737486661936157057810977294`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->74154366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26742],

Cell["\<\
Some computations may require higher internal precision than the default:\
\>", "ExampleText",
 CellID->16748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"GoldenRatio", "^", "1000"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30103],

Cell[BoxData[
 RowBox[{
  RowBox[{"Floor", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Floor[\\(\\(GoldenRatio\\^1000\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"Floor::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->82539324],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["GoldenRatio", "1000"], "-", 
  RowBox[{"Floor", "[", 
   SuperscriptBox["GoldenRatio", "1000"], "]"}]}]], "Output",
 ImageSize->{261, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84820912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"GoldenRatio", "^", "1000"}], ",", "1"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11073],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "9719417773590817520798198207932647373779787915534568508272808108477251\
881844481526908061914904596829767957830540320934740116303690766057397174086246\
3751801641201490284097309096322681531675707666695323797578126"}], "+", 
  SuperscriptBox["GoldenRatio", "1000"]}]], "Output",
 ImageSize->{567, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198889971]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "30"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "30"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32169],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDGIE0EUTThkNyDxUhxKEDmwNJWksQhY5SpNJ2ksllO4IKKs10gaiy1s
Frvt3ErYwiZgtXamElJYpM0VV6RNmzLOm8yEybqb5IIXkstb2MzszP/v/Tl2
/vz5s9wz5/zs9VvnvHXqHJ+4zvuz1umH4/o7VzQd5HO53CXuezlRn4ja9D6Y
TFDBdSHu/PTxAH3yyl2In/xUYAOtd8WPNRqN7qjS6vV61nA4tPAcx7GN58Fg
IPvQ5nme5fu+FQSBHYahFUWR1el0IGt1u13o2/1+X+oAB3rj8fg22clOdsFe
AKLo1VLQktqoo0Q70AWybAci+gwrLGGFnWIF9O2EFXIEgv4WraE1tGYD1hxq
a1AKLamNOkq0Ax0+w/QxhhXwL3aKFXJUCSuKtm3TClpBK9axopCwAlpS24wI
gA4foH1Gwgr4CzvFCjkqw4qjUqlEK2gFrVjHCviLopKUGnpVV35CznvtJxLM
MqZPYZYjUcz3y+UymclM5s0ww6scKSlbRezSCyhPIj0DnlNYZRSfwipHIfAe
iousZL2ZrA8m0ygZUrP118hYyfYrZKmg/6hSqZCNbLvBZmZ7iphjetUy5p2c
RxmMWRmdx9VqlYxk3G1GnVlBXGfrFSlxopGV50zLnjyp1WpkItN2MZlZiSLm
j151zOz+ghxhMvPwtF6vk4lM28Uk5xNWDsybkTqpNjPiC/Jq5j78pNFokIEM
u85QUDNOamC9QN2cdUvyUnp3/bzZbJKBDNfLoL8zkv5+os429VxYkgOCzAvH
cYhM5Ksh//MtDDyr+V6vkHt52Wq1iE70/4M+960HvKb5ri/Jc7xyXZeoRF3x
2wRRzr5BWJJbeNNut4lK1CUn4wPjBHzBHt71PI9IRMpCmp0VD9WZ8IL970ff
94myqyjyLHSkzjwz9oyfgiCg9rZoz0W/auXIinI/h2FIlF1FOTRRRD0t2vwS
RRG1t0V7LrpDmRLFBZ1Oh9rboq1PAXQ8bsZHX+M4ptZ1ac1ltI1Y5ZvYBVFj
8xqzHK+KQL6LeJKSmd7GeMd/iJWd0qtKm7m1n8JX76+UuXL9EvN0f6Xw9/ot
3p6b04tx/xHj3pfe9f63y+W0L/8X8FhTNg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->346416559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7970],

Cell["Binomial coefficients mod 2:", "ExampleText",
 CellID->26053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "63"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8768],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJylldEJAzEMQ+1u0k06Q0foAt3/r7R3JRebSJF9IQgjLg9jhO+v9/N1M7PH
edufN49573rzflvo6O+Vhh5SV2/qf4zV+jzl2kYvpfrSS6m262uFenqtUM+l
XnuzjnFW/XBkP+RZ9sOV/ZBn2Q95lv2QZ9kPKvuLuW77i7lu+4u5bvu+7m3L
B71t+fD1DR/b3Mc298lHfk/5ZnnPfHw5H1/Ox/ud8w0q52PlfKycj/c75+P9
zvl4v3M+3u+cj/c75+P9zvm45nxcc76W98zX8p75Wt4zX8t75mt5z3wt75k/
q86fVefX5j74tbkPfr33g1/v/eB36PW5D37r9ybd/QNaOg9Q
   "], {{0, 0}, {64, 64}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->58406753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13178],

Cell["Mod 4 additive cellular automaton:", "ExampleText",
 CellID->11156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Total", "[", "#", "]"}], ",", "4"}], "]"}], "&"}], ",", 
      RowBox[{"{", "}"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellTags->"S3.8.6",
 CellLabel->"In[1]:=",
 CellID->24981],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1V1uS4zAI5HGSOcPeZI8wVfu99/8bC4GEW1JkxxnHLgKEtIPpAF/f//9+
CxH9Oa5/xyVMLKrK9lJFHeVdf9VFiu2wMptEHeVdf9WrTZVdoo7yrr/qQvVk
qmcYhOvp5mZXqmcExAfDHgFhcCyWI4Eld2w5JLfxcZHbONlLHLmtxJB/Nuzx
Peo2Ryk/Q8geVpGHYCk1cdxeya3VR7IXWfSjgswv9r7b43tIOkbJG9vFLktG
7Td4bgns6jq5X8Ae35Mx1J6IWv7Vs10SU+6zBHDzl8yHLFkPP5XEeJzac6r+
81GfBXvOq6z32eudLP9dZj5QipPkB5SWf2rSKjHVe81/l9mf47IfUFr+u8R6
Z5DZTxA/w9DGjah5Kxa7K/a816wHZ9CP8fMjuBE1H/9K2vJeuRGcQT/GL1C8
3inlO66ad2n8mPkxfoGS+BH5jqvmvfNj5sf4BYqVaP9M8CAOshKlpR/jFyhQ
38GDhuL8WfkxfoEC+WTmkx78Wfnn/BhQQGfQaeO/gtH7C/aVOFFXOp/Xjugv
2Fco8SDr0Uf0JT8GFO8v2FcyD2Z95DU/BpRFX5GFHn3kDoYO/SOYvdLn/WOL
Av0jmL3S5/1jiwL9I66Vfo0fA4qe+wdv9Hcwen+JmUzsX0uMDDGPlfev+8cW
xXmgab5S50PMY7rtH1sU50Ger4IPMY/t+8cWxXmQ5yvR8zy27x9bFO8Peb7C
eew+PwaUyXyF89hTjHHfmM1jz4/ZfJX1T2CM+8t8/3iMAvvLfP94jAL7S8hn
/BhQYO+Y7x+PUWB/ea9/bFFgf3mvf2xRYH/5DD8GFL2yfzxGubR/PEa5tH88
Rrm0fzxG+Uj/2KJ8pH9sUX6FHwPKrz6PhnI/5AdKOzNN
   "], {{0, 0}, {101, 51}}, {0, 3}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellTags->"S3.8.6",
 CellLabel->"Out[1]=",
 CellID->261747967]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17464],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FractionalPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionalPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MantissaExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MantissaExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Xor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17457]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3558],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->28103],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->6358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15238],

Cell[TextData[{
 ButtonBox["Demonstrations with Mod",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Mod"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Congruence.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Mod/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Mod"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->126918755],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->226822986],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->126262382],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->30055996],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->20610456],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->121146008],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->570270797],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->722493708]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 54.3865718}", "context" -> "System`", 
    "keywords" -> {
     "aliquant", "arrays", "cyclic indices", "finite fields", "irem", "modp", 
      "mods", "modulo", "one-origin arrays", "origin", "rem", "remainder", 
      "wraparound", "zero-origin arrays", "congruence"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mod[m, n] gives the remainder on division of m by n. Mod[m, n, d] uses \
an offset d. ", "synonyms" -> {"%"}, "title" -> "Mod", "type" -> "Symbol", 
    "uri" -> "ref/Mod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11714, 403, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->47275922]},
 "S3.4.9"->{
  Cell[19040, 728, 400, 14, 70, "Input",
   CellTags->"S3.4.9",
   CellID->4189],
  Cell[19443, 744, 473, 14, 36, "Output",
   CellTags->"S3.4.9",
   CellID->236808188]},
 "S3.8.6"->{
  Cell[51140, 1594, 490, 17, 70, "Input",
   CellTags->"S3.8.6",
   CellID->24981],
  Cell[51633, 1613, 1347, 29, 139, "Output",
   CellTags->"S3.8.6",
   CellID->261747967]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60721, 1911},
 {"S3.4.9", 60854, 1915},
 {"S3.8.6", 61038, 1922}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3943, 83, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4566, 110, 39, 1, 70, "ObjectName",
 CellID->527],
Cell[4608, 113, 1124, 38, 70, "Usage",
 CellID->15282]
}, Open  ]],
Cell[CellGroupData[{
Cell[5769, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6247, 173, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[6382, 179, 532, 22, 70, "Notes",
 CellID->26393],
Cell[6917, 203, 699, 26, 70, "Notes",
 CellID->17187],
Cell[7619, 231, 654, 26, 70, "Notes",
 CellID->7863],
Cell[8276, 259, 556, 21, 70, "Notes",
 CellID->23961],
Cell[8835, 282, 534, 22, 70, "Notes",
 CellID->2565],
Cell[9372, 306, 599, 24, 70, "Notes",
 CellID->28599],
Cell[9974, 332, 341, 12, 70, "Notes",
 CellID->19251],
Cell[10318, 346, 334, 13, 70, "Notes",
 CellID->27318],
Cell[10655, 361, 474, 14, 70, "Notes",
 CellID->12081],
Cell[11132, 377, 347, 12, 70, "Notes",
 CellID->11802743],
Cell[11482, 391, 195, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[11714, 403, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47275922],
Cell[CellGroupData[{
Cell[12098, 417, 146, 5, 70, "ExampleSection",
 CellID->5868024],
Cell[12247, 424, 56, 1, 70, "ExampleText",
 CellID->25756],
Cell[CellGroupData[{
Cell[12328, 429, 222, 7, 28, "Input",
 CellID->10867],
Cell[12553, 438, 257, 8, 36, "Output",
 CellID->507103460]
}, Open  ]],
Cell[12825, 449, 120, 3, 70, "ExampleDelimiter",
 CellID->9298],
Cell[12948, 454, 79, 1, 70, "ExampleText",
 CellID->25343],
Cell[CellGroupData[{
Cell[13052, 459, 231, 7, 70, "Input",
 CellID->5234],
Cell[13286, 468, 257, 8, 36, "Output",
 CellID->160143861]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13592, 482, 216, 7, 70, "ExampleSection",
 CellID->25352],
Cell[CellGroupData[{
Cell[13833, 493, 227, 7, 70, "ExampleSubsection",
 CellID->14062],
Cell[14063, 502, 67, 1, 70, "ExampleText",
 CellID->8411],
Cell[CellGroupData[{
Cell[14155, 507, 121, 4, 70, "Input",
 CellID->16811],
Cell[14279, 513, 174, 5, 36, "Output",
 CellID->5626261]
}, Open  ]],
Cell[14468, 521, 121, 3, 70, "ExampleDelimiter",
 CellID->17405],
Cell[14592, 526, 119, 2, 70, "ExampleText",
 CellID->6881],
Cell[CellGroupData[{
Cell[14736, 532, 149, 5, 70, "Input",
 CellID->3651],
Cell[14888, 539, 241, 8, 36, "Output",
 CellID->257622738]
}, Open  ]],
Cell[CellGroupData[{
Cell[15166, 552, 93, 3, 70, "Input",
 CellID->17898],
Cell[15262, 557, 176, 5, 36, "Output",
 CellID->479421355]
}, Open  ]],
Cell[15453, 565, 121, 3, 70, "ExampleDelimiter",
 CellID->15842],
Cell[15577, 570, 138, 6, 70, "ExampleText",
 CellID->5694],
Cell[CellGroupData[{
Cell[15740, 580, 119, 4, 70, "Input",
 CellID->5084],
Cell[15862, 586, 207, 7, 36, "Output",
 CellID->52436391]
}, Open  ]],
Cell[16084, 596, 121, 3, 70, "ExampleDelimiter",
 CellID->16500],
Cell[16208, 601, 54, 1, 70, "ExampleText",
 CellID->10955],
Cell[CellGroupData[{
Cell[16287, 606, 172, 6, 70, "Input",
 CellID->31155],
Cell[16462, 614, 285, 10, 38, "Output",
 CellID->138964759]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16796, 630, 227, 7, 70, "ExampleSubsection",
 CellID->650],
Cell[CellGroupData[{
Cell[17048, 641, 266, 9, 70, "Input",
 CellID->6688],
Cell[17317, 652, 158, 5, 36, "Output",
 CellID->417190228]
}, Open  ]],
Cell[CellGroupData[{
Cell[17512, 662, 300, 10, 70, "Input",
 CellID->4010],
Cell[17815, 674, 260, 9, 39, "Output",
 CellID->409774234]
}, Open  ]],
Cell[18090, 686, 121, 3, 70, "ExampleDelimiter",
 CellID->14932],
Cell[18214, 691, 73, 1, 70, "ExampleText",
 CellID->14948],
Cell[CellGroupData[{
Cell[18312, 696, 299, 10, 70, "Input",
 CellID->31210],
Cell[18614, 708, 198, 7, 36, "Output",
 CellID->103569671]
}, Open  ]],
Cell[18827, 718, 121, 3, 70, "ExampleDelimiter",
 CellID->26419],
Cell[18951, 723, 64, 1, 70, "ExampleText",
 CellID->14648],
Cell[CellGroupData[{
Cell[19040, 728, 400, 14, 70, "Input",
 CellTags->"S3.4.9",
 CellID->4189],
Cell[19443, 744, 473, 14, 36, "Output",
 CellTags->"S3.4.9",
 CellID->236808188]
}, Open  ]],
Cell[19931, 761, 121, 3, 70, "ExampleDelimiter",
 CellID->15851],
Cell[20055, 766, 59, 1, 70, "ExampleText",
 CellID->3695],
Cell[CellGroupData[{
Cell[20139, 771, 265, 9, 70, "Input",
 CellID->11223],
Cell[20407, 782, 512, 20, 51, "Output",
 CellID->413636024]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20980, 809, 223, 7, 70, "ExampleSection",
 CellID->24407],
Cell[21206, 818, 112, 2, 70, "ExampleText",
 CellID->28134],
Cell[CellGroupData[{
Cell[21343, 824, 278, 10, 70, "Input",
 CellID->30884],
Cell[21624, 836, 291, 9, 36, "Output",
 CellID->353294812]
}, Open  ]],
Cell[21930, 848, 121, 3, 70, "ExampleDelimiter",
 CellID->14812],
Cell[22054, 853, 73, 1, 70, "ExampleText",
 CellID->20641],
Cell[CellGroupData[{
Cell[22152, 858, 289, 10, 70, "Input",
 CellID->25304],
Cell[22444, 870, 475, 11, 54, "Output",
 CellID->644425580]
}, Open  ]],
Cell[22934, 884, 121, 3, 70, "ExampleDelimiter",
 CellID->23162],
Cell[23058, 889, 94, 1, 70, "ExampleText",
 CellID->12537],
Cell[CellGroupData[{
Cell[23177, 894, 424, 14, 70, "Input",
 CellID->18551],
Cell[23604, 910, 13575, 227, 70, "Output",
 Evaluatable->False,
 CellID->536466414]
}, Open  ]],
Cell[37194, 1140, 121, 3, 70, "ExampleDelimiter",
 CellID->31565],
Cell[37318, 1145, 76, 1, 70, "ExampleText",
 CellID->18938],
Cell[37397, 1148, 205, 7, 70, "Input",
 CellID->27445],
Cell[CellGroupData[{
Cell[37627, 1159, 162, 6, 70, "Input",
 CellID->21228],
Cell[37792, 1167, 156, 5, 36, "Output",
 CellID->1782380]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37997, 1178, 233, 7, 70, "ExampleSection",
 CellID->14526],
Cell[38233, 1187, 92, 1, 70, "ExampleText",
 CellID->2178],
Cell[CellGroupData[{
Cell[38350, 1192, 284, 10, 70, "Input",
 CellID->15745],
Cell[38637, 1204, 256, 8, 36, "Output",
 CellID->12761758]
}, Open  ]],
Cell[CellGroupData[{
Cell[38930, 1217, 302, 11, 70, "Input",
 CellID->4205],
Cell[39235, 1230, 329, 11, 36, "Output",
 CellID->92909667]
}, Open  ]],
Cell[39579, 1244, 121, 3, 70, "ExampleDelimiter",
 CellID->15257],
Cell[CellGroupData[{
Cell[39725, 1251, 254, 9, 70, "Input",
 CellID->5312],
Cell[39982, 1262, 3664, 64, 70, "Output",
 Evaluatable->False,
 CellID->415509403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43695, 1332, 226, 7, 70, "ExampleSection",
 CellID->25199],
Cell[43924, 1341, 246, 8, 70, "ExampleText",
 CellID->24727],
Cell[CellGroupData[{
Cell[44195, 1353, 154, 5, 70, "Input",
 CellID->32692],
Cell[44352, 1360, 254, 8, 36, "Output",
 CellID->75569903]
}, Open  ]],
Cell[44621, 1371, 109, 3, 70, "ExampleText",
 CellID->27795],
Cell[CellGroupData[{
Cell[44755, 1378, 93, 3, 70, "Input",
 CellID->26542],
Cell[44851, 1383, 167, 5, 36, "Output",
 CellID->66713240]
}, Open  ]],
Cell[45033, 1391, 84, 1, 70, "ExampleText",
 CellID->27149],
Cell[CellGroupData[{
Cell[45142, 1396, 118, 4, 70, "Input",
 CellID->12376],
Cell[45263, 1402, 213, 6, 36, "Output",
 CellID->74154366]
}, Open  ]],
Cell[45491, 1411, 121, 3, 70, "ExampleDelimiter",
 CellID->26742],
Cell[45615, 1416, 120, 3, 70, "ExampleText",
 CellID->16748],
Cell[CellGroupData[{
Cell[45760, 1423, 155, 5, 70, "Input",
 CellID->30103],
Cell[45918, 1430, 459, 8, 70, "Message",
 CellID->82539324],
Cell[46380, 1440, 287, 9, 39, "Output",
 CellID->84820912]
}, Open  ]],
Cell[CellGroupData[{
Cell[46704, 1454, 291, 10, 70, "Input",
 CellID->11073],
Cell[46998, 1466, 451, 11, 88, "Output",
 CellID->198889971]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47498, 1483, 222, 7, 70, "ExampleSection",
 CellID->137],
Cell[CellGroupData[{
Cell[47745, 1494, 329, 11, 70, "Input",
 CellID->32169],
Cell[48077, 1507, 1399, 27, 70, "Output",
 Evaluatable->False,
 CellID->346416559]
}, Open  ]],
Cell[49491, 1537, 120, 3, 70, "ExampleDelimiter",
 CellID->7970],
Cell[49614, 1542, 67, 1, 70, "ExampleText",
 CellID->26053],
Cell[CellGroupData[{
Cell[49706, 1547, 415, 13, 70, "Input",
 CellID->8768],
Cell[50124, 1562, 779, 19, 246, "Output",
 CellID->58406753]
}, Open  ]],
Cell[50918, 1584, 121, 3, 70, "ExampleDelimiter",
 CellID->13178],
Cell[51042, 1589, 73, 1, 70, "ExampleText",
 CellID->11156],
Cell[CellGroupData[{
Cell[51140, 1594, 490, 17, 70, "Input",
 CellTags->"S3.8.6",
 CellID->24981],
Cell[51633, 1613, 1347, 29, 139, "Output",
 CellTags->"S3.8.6",
 CellID->261747967]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53041, 1649, 311, 9, 70, "SeeAlsoSection",
 CellID->17464],
Cell[53355, 1660, 2461, 89, 70, "SeeAlso",
 CellID->17457]
}, Open  ]],
Cell[CellGroupData[{
Cell[55853, 1754, 313, 9, 70, "TutorialsSection",
 CellID->3558],
Cell[56169, 1765, 163, 3, 70, "Tutorials",
 CellID->28103],
Cell[56335, 1770, 197, 4, 70, "Tutorials",
 CellID->6358]
}, Open  ]],
Cell[CellGroupData[{
Cell[56569, 1779, 321, 9, 70, "RelatedLinksSection",
 CellID->15238],
Cell[56893, 1790, 346, 11, 70, "RelatedLinks"],
Cell[57242, 1803, 181, 4, 70, "RelatedLinks"],
Cell[57426, 1809, 192, 4, 70, "RelatedLinks"],
Cell[57621, 1815, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58039, 1833, 319, 9, 70, "MoreAboutSection",
 CellID->126918755],
Cell[58361, 1844, 136, 3, 70, "MoreAbout",
 CellID->226822986],
Cell[58500, 1849, 164, 3, 70, "MoreAbout",
 CellID->126262382],
Cell[58667, 1854, 144, 3, 70, "MoreAbout",
 CellID->30055996],
Cell[58814, 1859, 154, 3, 70, "MoreAbout",
 CellID->20610456],
Cell[58971, 1864, 162, 3, 70, "MoreAbout",
 CellID->121146008],
Cell[59136, 1869, 149, 3, 70, "MoreAbout",
 CellID->570270797],
Cell[59288, 1874, 160, 3, 70, "MoreAbout",
 CellID->722493708]
}, Open  ]],
Cell[59463, 1880, 50, 0, 70, "History"],
Cell[59516, 1882, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

