(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    275149,       5431]
NotebookOptionsPosition[    266669,       5137]
NotebookOutlinePosition[    267981,       5174]
CellTagsIndexPosition[    267894,       5169]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DedekindEta" :> 
          Documentation`HelpLookup["paclet:ref/DedekindEta"], 
          "KleinInvariantJ" :> 
          Documentation`HelpLookup["paclet:ref/KleinInvariantJ"], 
          "WeierstrassHalfPeriods" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassHalfPeriods"], 
          "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DedekindEta\"\>", 
       2->"\<\"KleinInvariantJ\"\>", 3->"\<\"WeierstrassHalfPeriods\"\>", 
       4->"\<\"EllipticTheta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ModularLambda", "ObjectName",
 CellID->4667],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ModularLambda",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ModularLambda"], "[", 
       StyleBox["\[Tau]", "TR"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the modular lambda elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " is defined only in the upper half of the complex ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
 " plane. It is not defined for real ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18899],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
 " is the ratio of Weierstrass half\[Hyphen]periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Omega]", "\[Prime]"], "/", "\[Omega]"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21054],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " gives the parameter ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " for elliptic functions in terms of ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
 " according to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->10167],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[CurlyTheta]", "2", "4"], "(", 
      RowBox[{"0", ",", "q"}], ")"}], "/", 
     RowBox[{
      SubsuperscriptBox["\[CurlyTheta]", "3", "4"], "(", 
      RowBox[{"0", ",", "q"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " where the nome ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"i", "\[Pi]", "\[Tau]"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19212],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is invariant under any combination of the modular transformations ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "\[RightArrow]", "\[Tau]", "+", "2"}], TraditionalForm]],
   "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "\[RightArrow]", "\[Tau]", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "2", "\[Tau]"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->26114],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->136997468],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->430355927],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->340957348],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->367082541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ModularLambda", "[", 
  RowBox[{"1", "+", 
   RowBox[{"3.", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640505947],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.00129202623999477542339047336`14.803812538458361"}], "+", 
  RowBox[{"0``21.074929192463994", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248334456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62858631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ModularLambda", "[", 
     RowBox[{"x", "+", "I"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434631559],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->473518722]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2489],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->300764116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ModularLambda", "[", 
    RowBox[{"1", "+", 
     RowBox[{"I", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473585789],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "773.9780888691885189744483578282378992345195990608226821277843`50.\
15051499783199"}], "+", 
  RowBox[{"0``47.26178633174587", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68800034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->285336765],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->749607522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ModularLambda", "[", 
  RowBox[{"1", "+", 
   RowBox[{"0.333333333333333333333333333333333333333", " ", "I"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269092720],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "773.978088869188518974448357828237899241818881220729`36.\
59327582751519"}], "+", 
  RowBox[{"0``34.658633290130204", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163917846]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79992783],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->156500339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ModularLambda", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"0.2", "+", 
     RowBox[{"2", "I"}]}], ",", " ", 
    RowBox[{"0.3", "+", 
     RowBox[{"2", "I"}]}], ",", " ", 
    RowBox[{"0.4", "+", 
     RowBox[{"2", "I"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95565713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.02403336074828978186091314752`14.426738117633818", "+", 
    RowBox[{
    "0.01714229070331021948074456789`14.547648349775306", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.01769609358472196834438518987`14.313029734550122", "+", 
    RowBox[{
    "0.02374959251940133792205080206`14.611508536730298", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.00959055308788405631975227388`14.100188104680933", "+", 
    RowBox[{
    "0.02815166247347707966055922225`14.654141018885902", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{581, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510155556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108435872],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->362619855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ModularLambda", "[", "\[Tau]", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262917800],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"\[Lambda]", "(", 
    TagBox["\[Tau]",
     Identity,
     Editable->True,
     Selectable->True], ")"}],
   InterpretTemplate[ModularLambda[#]& ],
   Editable->False,
   Selectable->False], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->668050169]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6612],

Cell[TextData[{
 "Some modular properties of ",
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " are automatically applied:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26114,
  ButtonNote->"26114"]
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->113946985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ModularLambda", "[", 
  RowBox[{"\[Tau]", "+", "2"}], "]"}]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 CellLabel->"In[1]:=",
 CellID->280610937],

Cell[BoxData[
 RowBox[{"ModularLambda", "[", "\[Tau]", "]"}]], "Output",
 CellFrameLabels->{{None, None}, {None, None}},
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23299313]
}, Open  ]],

Cell["Verify a more complicated identity numerically:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->84070064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ModularLambda", "[", 
    RowBox[{"\[Tau]", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "\[Tau]"}]}], ")"}]}], "]"}], "\[Equal]", 
   RowBox[{"ModularLambda", "[", "\[Tau]", "]"}]}], "/.", 
  RowBox[{"\[Tau]", "\[Rule]", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"I", "/", "10"}]}], ",", 
       RowBox[{"3", "+", 
        RowBox[{"10", " ", "I"}]}]}], "}"}], ",", 
     RowBox[{"{", "100", "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]}]}]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 CellLabel->"In[2]:=",
 CellID->484125019],

Cell[BoxData["True"], "Output",
 CellFrameLabels->{{None, None}, {None, None}},
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18025639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->898404421],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " is a modular function. Make an ansatz for a modular equation:"
}], "ExampleText",
 CellID->247947759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"ansatz", "=", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "=", 
          RowBox[{"ModularLambda", "[", "z", "]"}]}], ",", 
         RowBox[{"v", "=", 
          RowBox[{"ModularLambda", "[", 
           RowBox[{"2", "z"}], "]"}]}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["c", 
            RowBox[{"i", ",", "j"}]], 
           RowBox[{"u", "^", "i"}], " ", 
           RowBox[{"v", "^", "j"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
        RowBox[{
         SubscriptBox["c", 
          RowBox[{"2", ",", "0"}]], "->", "1"}]}]}], "]"}], "==", "0"}]}], 
   ")"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599501020],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWctu1DAUdZN5FdoOfZeWiqqtBLQIiRWCBRtQWbFCIDbQjiqkdoFApQs2
IP4BwWcAfxhiJ57JHN/42o5n1EqdyXV8z33a8Zy8HFyeffg4uDw/Hey8uBh8
Pjs//bJz9OkiH0pnhJh5L4S4syHy6yy/Uv/y7zj/Ly6LqyfyM9V3M/EK5Icg
Pwb5KcibCnULRq+DPJt/SFG01HRR3JEjczAzBXmdQe5r5HSILFoOuKv5R5KL
Sfld1b/pEM2Y7iiq/G+D0V6oaHf0/CKPlVnzhM2q3AL5GshtIl4bft+SLxkV
RoH4y8qpkVwmdGwEa4k+dA0NtLLGIMwZCNU8DasjlsbnQR2LkXYZQ0vHUrGj
K49VQDlxsEPhd6hqNPC3N2V/29mox7mu6FE+RaiNaRu7qRvZctfZ8mJW7FrF
prNkzFfj7aonQuM6jpp5Rm+Z2pMYtC2sYI3tRvHMsvG0fW1Y0bCjVbY6VQ1b
RhIXtElUvM5Dy5OQWQVRfOs5+kbtTz27B8WTp7LDU/uBzQaNTVbM8nykUXDd
21CDfedqaXlqV/HjRDFE9dz1qzbiVdHsZe4ZEMUPS67M3OCMPhmJW6877fFx
et2SE2rH6YJesPce3W7m2ne9uURCWzI7vl3qcj6E1ZDv9FZM+14dbuZikYyh
6PGVrDhF+fjB1VKjJ2VekrLrh3a64EsNZt05t6mvvWw6vtps4C/MMZsTrMOk
7HYZu/I+d7ZYJe9RHZ8SHqSlpSUSJa3RQvROIx80V9HcB4myQuW4cX7iourf
utskik9d8YyyTmpR/etfP9wB5OVmkL1bQdnEWJED80fRUexb6iDPM3pNuq5l
eblG6GWZeb5d8MGv2Vc3HG09CIxlN4KPthxvAS61594G2cbC1mGgDof5yAHz
MMCuzMVwXxA/4O5fkO95zPomP8fOMX+MEeWx+F7W9F/5fV+NyinHDld3wfpb
kN+B/FVpYV6QsZVrU7rqz8FvM8jzGhk4eGRnOVy8v5lRbw0SB+SBUsA9DbVw
t8IVzXHq+NYD8ecBH0/emHcOH+/jOwPz5M2x9ifFtCvMhGMEsThazl8Xxj2W
vy44+tTqzbU4W8Rn+ZsMekNYz8rBvDTHoITz0rgeJ8ZsWuOJx7M7xhMPydPr
0PcFutMy3aF19rn1aljCs5aN6xh2J8t/2nZVEeq7ZSVSTM6UovBG8e9+ko/y
5qBdemhSzFpTflSuh6vCzPn2cmgsrjj+by1jcbyvlb4+31xFNhLX3jSZs6i+
BmJwjGYM1rTYV9zeEcblATHaOKzY8gR8cNXW9WjGRfpUxJ/BU54I84wSzn/x
LJ6fTRfNMOawfIZWfsVH5eVqVuANQqfWVghH52GX09mz6VTkEzUfKxXCvE2D
ibPZcJl/wNwv2JgjGD1k5D2Qf0ZEeSY/x04NBw4ju8bIL/X1PBuxfNXv/fL7
t5olVY4LtZn/wMClAg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{350, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->166463411]
}, Open  ]],

Cell["Form overdetermined system of equations and solve it:", "ExampleText",
 CellID->245616256],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"ansatz", "/.", 
        RowBox[{"z", "->", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "/", "3"}], "+", 
            RowBox[{"1", "/", "k"}], "+", 
            RowBox[{"I", "/", "3"}]}], ",", "250"}], "]"}]}]}], ",", "50"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "3", ",", "24"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->589318435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"eqs", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["c", 
          RowBox[{"i", ",", "j"}]], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], "]"}], "//",
     "Chop"}], "//", "Rationalize"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->244320265],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->143604003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"0", ",", "0"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"0", ",", "1"}]], "\[Rule]", 
     RowBox[{"-", "16"}]}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"0", ",", "2"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"1", ",", "0"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"1", ",", "1"}]], "\[Rule]", "16"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"1", ",", "2"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"2", ",", "1"}]], "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"2", ",", "2"}]], "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2027060]
}, Open  ]],

Cell["This is the modular equation of order 2:", "ExampleText",
 CellID->368716069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ansatz", "/.", 
   RowBox[{"First", "[", "sol", "]"}]}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->162996499],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWetOwjAULrsxVK4qkHgJ8fLD+Boq+sOHWIgJ/DAa5GGMPuxcx2bK6WlP
y8pYwrZz1vN9X0/PSimvyWr+9p6sFrNkMl0mn/PF7Gvy9LHMXH6DscYDY6w/
Ztl9mt3lH348Zh/GWvzsl76UHQK7D2wf2LdE/BERf0E8v6+IT+kb51mIgbcN
7C6wQ2BfE/EHRPwZ8fyuIj6lb5RngQX/nuzwGPesH6w9YXbH8xsUVxEh4ici
HosbCLjW/KHYnhVeM15YB8GW+iEOz7xftPNLgBr71XbBL+D1BLyNClFq9Sy8
8aY6uQ6UkacGkdX1KTAN9ME3LHCGFKmVOuyVde7kaEFzpz7N4LsgLosd5xHf
BATBA3aAMIh2U7DVPYSz84mGhTlQ5WF4pCpsZquOoqleSnHtGdBU7Q61dlFW
k2qFNmSCStBq1bSHNp+9m5kZaXRguLY6bTOs0mn7XqlwQnSEbOui7ix4e1Wv
q2p+9hAOHSamKRZxmoBLETNE+uVCywaOoRZsrnSBIa//4Ojss9ed2hVSawL8
2wHOcrytjzC00Ghf0RrWH67LlBuPVnHDWmlWis41RvKY81HDkXfTq87OdOjm
MLOaEfcZ8j6UbaTIFtLy2CgvOk51FMYHI/HsmURiGaaRq/ckLevBObd2lVb8
WOYHumqG7IqZkvfPY/K6NNTE4LowJKUaZNa1UdBzGLMT3aA2XPL20OyvqwK+
Jx5Sq9QcS63C+Ohzs23ARe2cQntk2b6nyKnIu622KtiDVNzRuiR6+QxsuJP6
7RAl3wXe2NEYSp6p5LmSPD/55bzIybi4vhTXm+L6m7fiIet/AljjD4gOoVs=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{324, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//TraditionalForm=",
 CellID->249911769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239529986],

Cell["\<\
Solution of the Darboux\[Hyphen]Halphen system:\
\>", "ExampleText",
 CellID->79806370],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"w1", "[", "\[Tau]_", "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ModularLambda", "'"}], "[", "\[Tau]", "]"}], "/", 
        RowBox[{"ModularLambda", "[", "\[Tau]", "]"}]}], "]"}], ",", 
      "\[Tau]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"w2", "[", "\[Tau]_", "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ModularLambda", "'"}], "[", "\[Tau]", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ModularLambda", "[", "\[Tau]", "]"}], "-", "1"}], ")"}]}], 
       "]"}], ",", "\[Tau]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"w3", "[", "\[Tau]_", "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ModularLambda", "'"}], "[", "\[Tau]", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ModularLambda", "[", "\[Tau]", "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ModularLambda", "[", "\[Tau]", "]"}], "-", "1"}], 
           ")"}]}], ")"}]}], "]"}], ",", "\[Tau]"}], "]"}]}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->421540520],

Cell["Check:", "ExampleText",
 CellID->256774412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"w1", "[", "\[Tau]", "]"}], ",", "\[Tau]"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"w1", "[", "\[Tau]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"w2", "[", "\[Tau]", "]"}], "+", 
          RowBox[{"w3", "[", "\[Tau]", "]"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"w2", "[", "\[Tau]", "]"}], " ", 
        RowBox[{"w3", "[", "\[Tau]", "]"}]}]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"w2", "[", "\[Tau]", "]"}], ",", "\[Tau]"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"w2", "[", "\[Tau]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"w1", "[", "\[Tau]", "]"}], "+", 
          RowBox[{"w3", "[", "\[Tau]", "]"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"w1", "[", "\[Tau]", "]"}], " ", 
        RowBox[{"w3", "[", "\[Tau]", "]"}]}]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"w3", "[", "\[Tau]", "]"}], ",", "\[Tau]"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"w3", "[", "\[Tau]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"w1", "[", "\[Tau]", "]"}], "+", 
          RowBox[{"w2", "[", "\[Tau]", "]"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"w1", "[", "\[Tau]", "]"}], " ", 
        RowBox[{"w2", "[", "\[Tau]", "]"}]}]}], ")"}]}]}], "}"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->213559680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29012146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182306764],

Cell["Plot the real part in the complex plane:", "ExampleText",
 CellID->63938395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ModularLambda", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0.2", ",", "1.5"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540455162],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnQm8zcX7xy0hlH0JSXZCtmxZpizJvkS2JERF+IVsRVlStuyylJ1sRfaQ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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFllls1FUUxi9ttZRp5z+dznSWNgiKaFxiwLXFJRrBB0UQBWRfFEE0ECJB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXu8llMWx59Ucur0Ps/b6dwvnVNuI7lVk0pGpBojgySVXHL5CB/lUkpD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlk01I1FEUxY+WHynN/++ko/PRmEVaWYuEgpmgRWhQIuVARVQEhqZjmJUV
WgQVNRFk5KaoLMuIIAxrMRGBUC0qa6cbjb7ECDTChJZSvz93ceC98+459757
3ytrOJxoy5S0HmSB3jJpT6E0OE9q9En9BVI9+2/wH1gPgwMZ0uvF0o6wFM+X
9sJVONLGkPQ9IrWj88HF86SUXzpSKrW60iFQkyuVLZJGlkgFxBSCauJiQWk0
IH3F5xxx8QXSeLH0CXzJlu7CV8G7RfhQy0V0l8Aj8r/Ha85v+Ry4fHCnRFoG
tqA5CJ6SN4R/BETnSxuocQDPBLX0ENdEzCnHzirIcYM7V7JfBQLkT1PHc/Av
B47YlaCKu16Gu8X5GeL+LpR2ortNffeooYscU/SxmphNUXhiMtDdxOMd3Fuw
lv1LeMHNUMv2gK1/wU2j/0MtDp4zrH871ouj9LOD3kfo0Un0xz0PvKa4xwz3
HCd2NdwuelLj1YdfJvti+M3sW/E8jVfIsbNm9i2gi30+GKIHs9SR5H4VaCbh
monrCFoez7sfdJJ/rMR64/VjjNgJ8regm0bfgGYCbbnPZtELBjkf8Nlc2rnH
Bb/NJsm+BfygT8fg1sHVsA+DNH7bQvZO/PR1P/pr9KSOvH3kWOrl8O6Drhb9
Q9aVrs2qh7g1zGM3un0F9l4T1FYPhohrAg49DeOVQB/AexbuKtpu6q1jJhH6
0QnXiOdPvK7jeZ9PM4LfKOgjbjnYyvkT9M9yrZ+RYvPJc6y3aXKm0EZZvyEu
xlkbOSepOYg25NpbyiEuGzwmLuaz/Al0Ify6vVnCZzmWs7zE/lSta/m9+wfx
nCNuhWu98OadBMP4hB2bvfcew36b4QPX3uYV5hEssr93Hu4siDLzV/z1Us5P
uPbmXlDbx7D9vRT3/8zZfxNXjG0=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4033488084998764, 0.2485478649771257, 0.6839358612492815], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgm0VdWRhg9vuve+B0buu8O59+IzOMUJB9QGBWfEGAeQeYigAoJDUAGN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmneAVEW2xi9M6pnBfTLT02mme6YlrK4EV1BXQAQlGRglR5XkquiKklbA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         "],
         VertexColors->None], 
        PolygonBox[{{5926, 5233, 5232, 7845, 1941}, {6729, 6571, 6570, 8245, 
         2620}, {5765, 5764, 5763, 7450, 1790}, {4744, 7799, 7798, 7797, 
         690}, {5938, 7297, 7296, 5943, 1943}, {5790, 5791, 1785, 7446, 
         5789}, {5490, 4799, 1723, 5540, 5489}, {5242, 5944, 1943, 7853, 
         5241}, {4953, 7258, 7257, 4951, 1059}, {6129, 6262, 2195, 7970, 
         6128}, {6025, 5490, 5489, 6026, 2009}, {7217, 6027, 2009, 7218, 
         7216}, {6996, 7217, 7216, 6994, 2873}, {7256, 4999, 1110, 4998, 
         7255}, {6104, 6102, 1272, 5617, 6103}, {4672, 5616, 5615, 6107, 
         2074}, {5711, 4660, 2060, 6088, 5710}, {5691, 7448, 7447, 5000, 
         1110}, {7452, 5708, 1059, 4952, 7451}, {6080, 6083, 6082, 5712, 
         1239}, {7290, 5921, 1941, 5930, 7289}, {7793, 5509, 685, 7791, 
         7792}},
         VertexColors->None]}]}, 
     {RGBColor[0.5570257309766548, 0.5157505304058505, 0.8999473665502218], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHeYldW1xr9pnDZzI+fMzCkDKo+JJRaIBW80IWpsxBassSKKLbGBoF6Q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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmgjdX6x185wz5DdZ29z9nTGZs0Oio0UN1IM5KhiUKkWyqU3BtlLhqM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         "],
         VertexColors->None], 
        PolygonBox[{{6137, 4699, 574, 7739, 6136}, {6567, 5548, 5547, 7252, 
         2484}, {8409, 7092, 2959, 7654, 8408}, {4932, 5542, 5541, 5735, 
         1802}, {5703, 4950, 1813, 5765, 5702}, {5523, 5529, 5528, 7725, 
         521}, {6592, 6598, 6597, 7881, 1546}, {5934, 5931, 521, 4679, 
         5933}, {4995, 5686, 5685, 5791, 1831}, {5536, 5445, 5444, 5533, 
         1721}, {5787, 5785, 441, 5683, 5786}, {6171, 6170, 6169, 5708, 
         1791}, {6728, 6566, 2484, 6729, 6727}, {5699, 4917, 1032, 4953, 
         5698}, {5883, 5620, 5619, 5103, 1904}, {7409, 5670, 1782, 5669, 
         7408}, {7086, 7884, 7883, 7091, 2959}, {5848, 6459, 6458, 5402, 
         1549}, {6756, 6725, 6724, 6624, 2635}, {7118, 5822, 1546, 5393, 
         7117}, {5542, 6156, 2100, 6157, 5541}, {6734, 6265, 6264, 6732, 
         2627}, {7876, 7072, 2953, 7081, 7875}, {5572, 6130, 2086, 7254, 
         5571}, {6261, 4889, 2627, 6733, 6260}, {5445, 5449, 1031, 4911, 
         5444}, {4908, 5679, 5678, 4999, 1031}, {5948, 5954, 5953, 7847, 
         574}, {6608, 6604, 1549, 7889, 6607}, {6265, 6761, 2637, 6164, 
         6264}, {7442, 7742, 7741, 5673, 1782}, {5725, 5900, 1919, 5136, 
         5724}, {5584, 7409, 7408, 4916, 1032}, {5717, 4937, 1804, 5737, 
         5716}, {6220, 6222, 1786, 5691, 6219}, {6105, 5725, 5724, 6102, 
         2073}, {6127, 6261, 6260, 6262, 2086}, {6159, 5717, 5716, 6160, 
         2102}, {5620, 6081, 2058, 6080, 5619}, {7728, 7359, 1721, 5535, 
         7727}, {7076, 8399, 8398, 7652, 2953}, {5757, 5760, 5759, 5701, 
         326}},
         VertexColors->None]}]}, 
     {RGBColor[0.6718129652010951, 0.7010786884651279, 0.9119606285299552], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHe8VNX19s/tbQa4M3PvnZkrYhdLrDFgQxBjiUhTlKqIXSm2KGAJgmID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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmneAVdXVxe8MM0ylvf7edJQiNtQoWMACKmChKFYQQxARgcSOUhRQFKTY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         "],
         VertexColors->None], 
        PolygonBox[{{5653, 5463, 5462, 4884, 1775}, {4823, 5839, 1865, 5841, 
         4822}, {6165, 6168, 6167, 5709, 1058}, {6086, 5751, 5750, 4659, 
         2059}, {5935, 4681, 4680, 5931, 1942}, {5551, 6568, 6567, 6566, 
         1012}, {6276, 4850, 4849, 6277, 2206}, {5751, 5758, 1811, 5757, 
         5750}, {5826, 4817, 4816, 5827, 1855}, {5642, 5461, 5460, 4873, 
         1768}, {4703, 5949, 1944, 5948, 4702}, {5740, 4939, 4938, 5636, 
         1766}, {5557, 5828, 1855, 5040, 5556}, {7718, 5230, 1942, 5934, 
         7717}, {4927, 6283, 2209, 6285, 4926}, {4939, 6759, 2636, 6758, 
         4938}, {5840, 5565, 5564, 5047, 1865}, {4817, 5641, 1768, 5643, 
         4816}, {4924, 5899, 5898, 5900, 1796}, {6217, 6215, 1109, 5690, 
         6216}, {6172, 5700, 5699, 6170, 2106}, {5706, 4730, 2106, 6171, 
         5705}, {4775, 5688, 5687, 6222, 2147}, {5655, 4823, 4822, 5656, 
         1776}, {5463, 5657, 1776, 4885, 5462}, {5744, 6110, 2075, 4673, 
         5743}, {6131, 5576, 1025, 6127, 6130}, {6050, 5557, 5556, 6049, 
         2029}, {5461, 5637, 1766, 4871, 5460}, {4944, 5742, 1775, 5654, 
         4943}, {5238, 7851, 7850, 5954, 1944}, {5680, 6221, 2147, 6220, 
         5679}, {5788, 5744, 5743, 5785, 1830}, {6289, 4944, 4943, 6288, 
         2212}, {5565, 6053, 2031, 6052, 5564}, {5882, 4848, 1760, 5883, 
         5881}},
         VertexColors->None]}]}, 
     {RGBColor[0.7825412211136075, 0.8536375282147592, 0.9051112387833026], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHmclNWV/quruquqq6tBuqura2nZFxVwYRWBKAouLMYYFJNxZjJGRdS4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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmgjtUWxl/nODOO8w3nm5zvfIeiORoMlak0oHuTBl2lOUpK0y0yj3Xp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         "],
         VertexColors->None], 
        PolygonBox[{{7434, 8417, 8416, 6750, 2629}, {5635, 5739, 1805, 5740, 
         5634}, {5746, 6109, 6108, 6110, 1807}, {5582, 7444, 7443, 5671, 
         1737}, {8558, 5396, 5395, 5823, 1853}, {4907, 5990, 1977, 5989, 
         4906}, {7993, 6722, 6721, 4864, 1011}, {8514, 4859, 1011, 8509, 
         8513}, {8475, 7568, 2726, 6850, 8474}, {6851, 7230, 7229, 6846, 
         2726}, {5550, 5821, 1853, 5820, 5549}, {7271, 7878, 7877, 6599, 
         2503}, {5631, 7710, 7709, 4865, 1765}, {5676, 4907, 4906, 5450, 
         1647}, {7886, 7287, 2508, 6609, 7885}, {4638, 5635, 5634, 5637, 
         1659}, {5677, 4776, 4775, 6221, 1784}, {5407, 8560, 1868, 5849, 
         5406}, {5741, 5652, 5651, 5742, 1806}, {5107, 5622, 5621, 5885, 
         1905}, {6218, 5749, 5748, 6215, 2146}, {6085, 5752, 1809, 6086, 
         6084}, {8435, 8437, 2629, 6744, 8434}, {5762, 4949, 4948, 5753, 
         1809}, {6610, 8271, 8270, 6605, 2508}, {7713, 5664, 1779, 4888, 
         7712}, {4914, 5693, 1737, 5585, 4913}, {8267, 6594, 2503, 6593, 
         8266}, {4997, 5793, 1807, 5745, 4996}, {4901, 8524, 8523, 8519, 
         1026}, {5689, 4774, 2146, 6217, 5688}, {4728, 5707, 5706, 6168, 
         2105}, {4731, 5695, 1789, 6172, 4730}, {5995, 4914, 4913, 5994, 
         1979}, {5723, 5138, 1920, 5901, 5722}, {5850, 5574, 5573, 5847, 
         1868}, {7361, 5447, 1647, 5537, 7360}, {5652, 4647, 1664, 5653, 
         5651}, {5755, 6166, 2105, 6165, 5754}, {6739, 7971, 1026, 4900, 
         6738}},
         VertexColors->None]}]}, 
     {RGBColor[0.8840122013935924, 0.8874753963481167, 0.8596523305493255], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmQldWVxz96ea/7NU3gLb297oZGlmZpMqIYUUDEQVwSsJSpEWhaBg0q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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXeAVdW1xo8ww8ydUcqde6fduY2iiCDSwRcFBhEEIogmUiIqSmcGFAtS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         "],
         VertexColors->None], 
        PolygonBox[{{4868, 7762, 1726, 5552, 4867}, {5951, 7721, 1358, 5239, 
         5950}, {7302, 5942, 5941, 5947, 1358}, {4637, 5632, 5631, 5630, 
         280}, {7466, 5139, 1273, 5746, 7465}, {7638, 5694, 1788, 5995, 
         7637}, {5553, 7532, 7531, 5821, 1726}, {7433, 5459, 5458, 5648, 
         1771}, {7534, 5575, 1735, 5850, 7533}, {7636, 5697, 5696, 5992, 
         1978}, {5692, 5581, 5580, 5693, 1788}, {5925, 7295, 1357, 5929, 
         5924}, {7817, 7818, 1720, 5525, 7816}, {7763, 4892, 4891, 5577, 
         1735}, {5610, 5612, 5611, 4647, 297}, {5665, 4648, 297, 5662, 
         5664}, {5646, 5644, 280, 4638, 5645}, {7215, 5674, 1783, 5676, 
         7214}, {7469, 5761, 1812, 5762, 7468}, {5792, 7466, 7465, 5793, 
         1832}, {5106, 7469, 7468, 5752, 1240}, {5465, 7413, 1757, 5614, 
         5464}, {5682, 7633, 1976, 5986, 5681}, {7720, 5937, 5936, 5231, 
         1357}, {7745, 6133, 2087, 6139, 7744}, {5675, 7635, 7634, 5990, 
         1783}, {8035, 8034, 8033, 4701, 2087}, {7358, 7731, 7730, 5531, 
         1720}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlG1olWUYxy83tzk3n+c8p3N2znMObmxBSyeUOWp9CJzzmKXl1jZf1odw
uaDcVm1Q0DAog9QI5svMT30p6MP8oLZcUJ9WUAoNClQEwTci2LRolTO2Rr+L
//lwcd/P9fzv//W/Xu67vvf1FwZLzOwgVooVUma1ebPGMrP9ObOepNlTANrw
7WG/nn1raLYROw+mCV9P2uy9cjhisw+wX/FX15gF2Az+w/i+wkYrza4HZiXY
9HKzA/jexW6DH8mY9afFeYFYP2KfVZmNw7GeGIVlZoucezYy+7iCM6wLgXTW
se8OFXcK3xTf0yvMLqfE65yH8J8OpWeMvI5ib680ezRh9in+a/gzYL+Oxb+P
mDV8t5LvF2hYx/eTaLiDxpm08N9lzb7PKtbf/F/Efxv/Iue2EruJuGPsl9Bz
C86ZB8zma5T7WeKcwb6plK5HEtL2Gnnvx9rJfQLsYfZVaBhiHcZ24m8B/0qk
/WowGXjnONuJvzZSPZ8jfgP4EjD3wMzxfRP/BmL+Vdy/yf83sG4wA6z9WEeV
+O5kxTlP3YbQVorOPrifCIUvgac0ln8hrfw99+NwXIF/Ev4C+4Ps14A/xv4o
9g77u2B/48xV8J/AOZ7QbHjfBhKqZysa9qF7BXV7uUbfvj9HzC+xb8H/5NiE
5tN7OBKoL4P09iXwHfT3F/7/nFAf51aZrY2krQFffUJ98T73JYVpj8TrnEvg
O0LVyuvntfN9I5iHsXb4Z4kzm1VPffbfL86/z+PO4kw2x8rZ862nBs/AtYw6
9MLRHKrm1dTjB/6VgSkDv9yNHF+EfyCnWH5Xfs+qv12h+u37bEaz63PbC89m
Yn0ETwX12Bbp7uxgtVD8x3KaaZ9n1+5z6fqfT2rmfN7+5Wwt9iD8uzm7K1If
H2L9k7pM4N8FX13xDj6W1F31WOvANEWqf4acNqXE47W5l1JNRtHwOXHfWqkZ
P5FT3H9Sehc8rzK4n46k0/PYXsylwLrF80HPJfCjeenxd2tLSnp8Bgcz6rVz
lAfi8Tfsw5zesWH6fD9QnY/Eeqd8DjeQ195Id9BrWZdXPQ/ldG/9zrallJvn
VR5Lh2vwevjb5BpO8H8MOwBPEv+pSDleZ70RScNErLfGZ+9VOFrA56s0sycj
+SdjvSn+njRH4nKe/1iXAvkH0poh728nmK5IPN7DP0Lp9Lf88bxm2+9Qf073
yLXEgfRcTEif73OB7oPj/b08Xnwz/wfwZdPM
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXu0j2UWx19CKO/7/nLOcTmHc44kl1J0VUpCqXRxalpdLIWaSiVCZHUx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlk0tI1FEUxr8Zp4dZ/5kpsxlnLDXKpoweY2mvhThZCQ4+xzKomKyU0tER
IooWNouCsAe0qEUr2xQY0SKKClwGRUa1CawoCclEoWyUkuz35y4+uOc733nc
c+4tiCfqOpySSsAcsK5AasuWAllSg1eqBS050sWgFLakAbc0f56UQlOMthH/
fhBC7/CTA7gypWm0XR7p0BLpRkA6j78V3T34U9j9xG8mV9yugW+S/B25nBfQ
A9wZdGk0T9BewF4BvtHghE+6hu40ujBcJzV8aCrQrrT95KyA3wpXCuo455Jr
F5e8jt1MP3exT8CfpW6EuCR8jPNxuD/4prjv1TzpE+fP4LVL6kaTAC1oytxG
v42e89D+nCvdh3PYsfnSQWrU0N8atKvAOD3fId8I/gZ0w/R5mdlFF0tZ9HUT
zS3wgNltJ/4ld3oFnjLHf/A/wMQiqRDuK7PfgeYh2mf438ANgrXkq+YuTvqK
oq8GLjTlcGnqdnvMXh5zh9/ZpoflaHrATvLtgROxldjv0Lahaw+Y3ZTQ8xH4
F9hRdA7sFHYfvgy/2bu96ynqZGSaOXWBRvylbjOz5qXSemJ/oUnC9TCzA3Bj
YIjzOfhO+EvM9C/cMFwf9hb4Y8zpETXeU+MtKGdmQbiFzH4U3Qa4GeZjYdcT
m7DzWMY3gl0IWuFugw9wZfR2hX18RFPvNW89Yr8hsIncfvgY/D76DTHXvfYZ
ONC18/ae02McTZHX7HmU/KvpZ5YeNnrMfaqI9S2TetlXFbpZ9JVw+dSIYDfR
SxE7mCF2kvcybpn72vcepLeU37z3mD0DMAC3O2D+WRPxQbiTAbMnezdh7Bp8
Y+Q6mmP+qP1Xv5P3MNw0Ow6hK/aaP9ZLvjS6L9SoRTdkmXfm9JsdJj3mzf0H
rmKMLg==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz2Ecx/HvmBUWbTNzmMOf5DCSzYXtyubQsFzMDVMOm8MKcyE3yqEU
xtQ2I1FLGSLJFrZyyDFyoTleyAW7QLEph9nFLK//xXuf7/N5Pt/v8zy//xKV
O8trUiJiuD9rJ0Ysx7tJEZ14jq4JEQWJiA/0pr3SyRElSFVv42/iL5B7nxvx
l/cPp+03o4f/G+0yZ2W3yDTb30BPWrfyB+G5uhOP8dFeo97PdNG4iCL9863z
0Z/Jk3mlvjQ+4jyemlct+2hsRBk/Oztip8x2c1vV3fbKZVKzIibRGB0xwZxq
dS5Ntx6BVbJD9bTTW3jCqxwV8cmsKnrcXi/vp7rAWb/ofNptxhf5KeiRnUrv
yy5xt4Mys3mL1YuwRvawNx1Bq97rKHLn6e7WYf+P/F7ePvSMiWgxp5teoD9o
vb4W2Ufqx2jK8R0xkBHxDYP0DUYKhiAVxWaOSZ5Pc2gJzXOPCvecoz7mfiut
b3hbrf0mZ5xEA06gEZfszZZJ2F+mZ6ae5cm5zs5Bh3Pa0a8u5aep39J6+UY0
oMK9/3rrWrrDzLt+lz5z79Dj7tJLu+19RxW/mG6ih/kl6l90L71I1/EzzM/C
LN/mnHUe3ZW8p/+Xy+56ze9b5T4v+fn81zSPzsJcM0qd+ZAWyN2jp6yPqmux
Qv88vTPUu51xxXv3y0zj7aN13vGGHqIv6Gqz78m0qb/yMqy76HBa4a296t/Y
aN5WDPDXy/fRzbSR16y3WqYGF73hAL1K21CefCM9gyY8ky3jLcVpdbsZC9V1
KEvmMR6JZJ38XrTQGQfoIezBMOsHuI1C/S3Ou4I0pCMTU8zLlh2Joeg3ayld
x/8PjXSfyA==
         "]],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV01toDnAYx/FHXEi7kMMM22xLmi1CYmM5lHHhkFMyRIa0g3cbcpazkMgp
blzhQiPmODmEVpsLpmhuHIob2aitbTRaPrv47vccfs/z///fd29mccXiRK+I
SPJnWUZEzoiIpsyIvmkRt+Ul8gpky0fK05GCJ3iAIt5P6RHfkIq98uM4hMLU
iF88c2nQLnt20a24oTbFzhq+s+IG8U/xG7oVtbzPUIeEvRPVus314+mDq2Yu
qV9Wz5ZfoUfk+zBdr25YxBm1VL2LNIvuop9pNd2P/uKjNJkeMTNpiJxWy3cM
ihjds0tt7YCIYvdYh055B2bqDTbbODjiNQqSI6ahSW0mfU838t3i22k+1+we
9bHqB+gY2jYw4ouzWmmXHdecXSuvkm+QF9Jjan/F7Xb861G1Dgw1v0q+Et32
tfMlvHmN3h+f02p6fnjEBZzDB+9JuE8T3U3LzW1CEur1X6EBC/Rz3GE+zZJP
cG61/ePpiaG+W9zHPaxXS7ZrA30gL3DuHHPFds5SG2G+UJ5OZ9MMOotupltQ
gSpUogmlKEMJNqEcN/nT7H7rvQl5Iz0kP4yD6NR/pJ7tvVOdf0ftLsp9FmVY
4R6T9Ccj17tK+PPEp+xpF59Qy/fZpXnjEDtaUiKaaTP9QX+rn+Yt4/3KW0rn
8T/3xhfoEBfRFvzAKOft9J1n00yzWT2/C3uW0F+89TwJ+6rsyhAvdOd37rtD
r5Gnxt0e4qP6fJ5RZieL8zHS/9BSb3rMO0HczN+Kk+L+9Ap/pd5V8TZ6Xf7U
WeN6ftdowEss5++NFp4ZtJRnO2+yuVX6xfggblFfot5GP/J9xXcs0ssz+x8E
E6QJ
         "]],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03uIzXkYx/FnzR9iy4QZt2MwTUyKNsPYcZ2xtnUtwrRnSQ2FI47RDoYY
m2mUzT+k1v6hlEFuRbmMxthISy47WzQSu1hpxbhtLAnx+v3xPp/n8nme7/f3
O+cULqyeteKLiBjm4+u+ETP7RTzqH/EP7uC/gohZhRHt9KbeggER85AvXqO+
VL2cr91sB/o9zutfwmB8hRaeA7yreRrNVdM98lzxVv6X9AmGiZv1ZveJKBKX
mR2Jgd0jpvPfEZ9KRRxDK38t7/XeETPU++dHrOTJOut2j4iL8tc9Iy7TlPlC
/gHq/ZBFHoq7ubd+Gs/xDLfUHtMX9LekTrs5ozs69YrojC9x3fyNZFeeXXrL
aT5N8w93v4y8hJZiBBbJlyRed15Mi8w+7RpxT+9PeSu+MT8R5ZiACtTadziZ
5TtCM/QAnePZXuiXustQ9zyo1svuQ7QBU/im4jtMxiRMQx+k0BsF6IsW7+eu
mYfiLs5bYm+1vSuRxlz8gJ18Oc74lWb5xvKPwyiMwWg0o0xvvjvVu+MmnOPf
7Ts9T5cl7wpZ/MuzQb1GfT1dRevoXfOt5uqc2Z7sl28U/6zXTM8kdxNXo8rM
fXvuJXing+xt8iwD6WlaTN/wvDHzll629wquYgf/CfWTOI4mnML/zmvU24vF
9s6UZ8Qz6F79fajHj/btp6/UP+i/Ss7h/93utfIhfov1tDJ5PtqDdy3vNPF6
Wk4zvBW0jXeZuIR3nPyaPa3IU6/w232vN9/MAv+LKjpeXuv5jujV0THyUjT4
fvL9Dzaby6U/0UP4W7yOFtJfaIpuoxe8w/FmNtrTgD1qxXq76E55o16OvBM+
+p8NV8+qX3CPs2hCjdofeMpziW43c0w8SnxYXGNuHd7xfsJUtWfyb2k93xZs
QMreB/gLaflJnjPoiQIUodjOFXZkcFTeUd7GO1heKf8MZcG1mg==
         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/GPRuaaYW5mQ2nu0Rx/yKyWWBH+cN/mmDOhiETNkb+02RpG
jg0pzFVozoyxWa7QjPaHHMUfFpLz8f3judf7eH3e7+/3s983ecHqyasahRCG
+jO7ewiZPUL41S2EWBqHBCSrt0kKoQWa4BSOYURyCFcTQ7iJZtjIm4utGCGf
TSeZlUS7RDGysMe80bjsfKF+pjgL98R5+kU4HPnVyujpaKZ9JXQlXYJi3r12
LDLjB98c+ocuVpuHBp5vmN4lhObq9eJ4+p6WOVvOP1VeLc5Ve0r30C20d8cQ
UrAuIYQ+Zq2mg+Xj24awS76vfQgHMER8i3+seCDt3yGEfu08A+8Ts1PlC8QD
6ElnR9JSOr5TCOvFubxHaArvWlrHO5O2tS9OPEr/HO9mupuexRk8sS+bb4VZ
a8SF4gKk833Vb0C589fRl2ev3o7O9uGG2g/z08Rf+HvRC/Ke9Dxd3zWE1/wv
zH2JWTz55hVgHwqxCWnmVptVhTrxIfd8g3epOcuQg63mxZo3kDalg+hPnk/i
Yc6U2lMkb+zu9kf3plaLj/oD6EX+znqX6DX9qXZNi+7Fc01EK54NvC3pYvuy
Uew5DuIqfzV9hAeowkOk8FbQe7iLStzHFf4pZh+3awedYP6a6N3kO+k2eX+U
yE+go+cqpRvMS1NPkg+jVWrVeOO5PrVxr97xA62T59uRhzHiDIzGdt50mmnO
YDpPHu895tMEe9vhufwZYt17axqHY+oX7Cszr8KOGudb03hMju6GJqrF0OX4
q/YPiX6zMdHvSnzKnDO0PPL4Da7yTSTIs3wHt/WWeKcK/qOeqxSP1TN4fpmb
Kh6Kkb7JDPf3Lvoe5W/pHZ4aVKKRueeQL56rV2xedvT/ll9Wb3D+M4qdLcRv
/e94xTNcfSFPDm+M2hj9sbgorlUfol5PK/lq8Bzj9GbgP7Gct8o=
         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltMz3EYx/FvmYaMSEkqx5HDBWaptjC5cbggtm7amBvkNGyUUlqpXDAX
5BCjXJicZmuGpY0ZN246uOjAimUzx7XZSOH1v3j3eT7f5/M8v++v33/WjgN5
+6NCCAn+DEwK4UNSCP3xIbyj7+kAbaD3E0M4PC2EJ1Nl+I/OmyfzySF84o/p
lWC2sweyc2gp3yI/TiYW45FvrtZZunoBymVOoAJdZrrxFHUyF3AReXpb0JEQ
Qic6poRwenoI7fQMbfK8NWYW2bcYC9HLP9OLka83ewVXMdG+OEw1OyYlhES6
RDaVjuXTaDJSsJifTmPt2EDj+Y10xPt2esYbtKED7YizJ1q/Wz2K9tAoGu15
bci054c73ZU7yPfp7bHrq7MRpNu/AEPu+RvX5ArkrtNh/k/kfyVXHsmbLTb7
Xd2gXxj5bnQn3Y1dmMSvcIdMZCAbWSiLvK9+Gk7bfzlyF3u++f5BL8s9u/ge
dOOVZ9XQWlShGidxSfat7Du0yvTSHty17w7muu9D5zmesxKr0Odb1ZlbrT6n
LvQO/+hu+sjZY2zCaPdskhuxL4/fjJvqU3I3aCMqneXyFbQaVRg0M2Tfj8gs
/Sn3wl1e4ihfhmJsjfxmaYKZJKxXHzOTol6rztAvNLOUttkx6LvMdx6f6j3S
PEOvQH77jBC20Rz+iHe9rVdKs/nlqDQ3ZZa7mZtAy+gt9KqL6Ex6nibT5965
FTlmjttTiQa9eXr1tI5v1Ivmx2B4ZgjLnO91/tw9WvAQh5y9xmeZl/Ssmfvq
THWT+pC5IvyS/Yt1zr7wubRCrgYlSLa3Hz3I55tlniARKZiNeXbus2Mn7vEx
fKdsOr+V/w+pDqhn
         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5084, 6369, 5085, 5871, 6072, 6884, 5129, 6546, 6547, 5895, 
         5128, 7104, 5381, 7103, 5380, 4605, 4580, 7132, 5010, 5180, 7184, 
         5179, 6562, 6561, 6560, 4840, 6709, 7065, 7064, 5831, 5832, 5178, 
         7183, 5177, 5515, 4876, 7160, 4877, 4818, 6689, 6691, 6690, 6717, 
         5561, 4616, 7139, 5045, 5044, 5176, 7182, 5175, 4640, 5159, 7179, 
         5160, 5156, 5158, 7178, 5157, 5220, 4615, 7138, 5043, 5042, 6928, 
         6929, 6925, 6927, 6926, 4639, 6900, 6901, 6899, 6903, 6902, 5155, 
         6399, 6400, 6396, 6398, 6397, 6413, 4614, 5554, 6050, 5557, 5828, 
         5826, 4817, 5641, 5642, 5461, 5637, 5634, 5740, 4939, 6759, 5633, 
         6726, 4865, 7709, 4866, 5551, 6568, 5549, 5820, 7119, 5823, 5395, 
         8266, 6593, 6599, 7877, 7073, 7077, 8400, 8513, 8509, 4858, 8396, 
         4864, 6721, 7396, 8336, 7390, 8642, 8654, 8648, 7424, 7599, 8595, 
         7262, 7836, 7268, 8601, 7605, 8178, 8172, 8348, 8342, 7931, 7925, 
         7384, 7990, 7522, 8553, 7682, 8256, 8262, 7859, 7642, 8497, 7648, 
         8136, 8142, 8148, 7752, 7769}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0mtozXEcx/GfkmuuM3OfIWm1za0OWfNE2EouD7RcpsbmgRly2Zkd0lpN
ZwvJZjRyKxvSkDQpl+QBHrjO3JcilHJdYcXrPHifz/f+/X//559WuGFJabcQ
Qoqft8NCuDIihDdJIbxmv6Ud9Bg9PzSEE/Qm/yS9RWcnh9Cq/iN/6/AQtiFt
cAgtai/iEvoPCaFB/BAOo3eKPjX17IMowwQzorQcn+Q6R4bwmT7Banse0zX0
PS2hd+29h3p7a/TW0Uo9t+3KVFNtzm4MlhuEZexa+YfycfqA1tAmz9eMZH7P
USEMoVn6/5rXg99F/yQQ/41/g0L4gjS5Q+6oxQW0YIC+Z3a1ow1B/XP6T38X
u8DzRnBO3S71ZxM3JZ6b5ojv9Rx78A7L5Y+KV4pno1tK4g/yXOZE9RyRK/Ye
OmiGHZmodWMNImLtbpuqbyF/MRZhCn86pmGHmvFumIBxKDVrPWKoQLr6qBnl
KEMFtqPV/h10J2K4yo+Z9dzMF7jGb6NP0ex5m5Bq1gXxWeZ+Z//ASzfW6csW
289e66ZytcX0p9gvzMQ3fEWhmhk0gnz2RnUb7FhnRqHb5/PjcrWoSXyX/L7m
ZdN+dJmeV/QNNrIbsQlV8lvoPD25mME+beYC9mR2hnyRnnSaZ99cHMcN72zK
GN8z+wCq2bn6stSWunUifzOdxB+PmPr42BAe0Sp6ny4d7X2l+XbYH8QG8Dto
gXvy8Z29ypwidMmtVNtJV9N9Yo36itWU4FSq/4SeoS1YpO4obcB+3FGbJzYH
9ezLZuSw48hL1GM4UhO2/AoasWMnrUIUvfjX0YqI/hP2NaE7+mAgxpqXpLYf
euKPWXPoCvH/KdGnfQ==
         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6370, 6372, 5088, 7213, 5872, 6073, 6888, 5133, 6548, 6549, 
         5896, 5130, 6887, 5132, 6885, 5131, 6886, 5281, 7014, 4811, 6686, 
         4812, 6731, 4879, 6730, 4878, 5359, 5358, 6006, 4714, 5400, 5836, 
         5835, 5833, 5834, 5182, 7185, 5181, 5516, 4880, 7161, 4881, 4821, 
         6693, 6695, 6694, 4617, 5562, 6905, 6906, 6904, 6908, 6907, 5161, 
         5163, 7180, 5162, 4644, 5183, 7186, 5184, 5046, 6810, 6811, 6499, 
         6500, 4618, 6961, 6910, 6911, 6909, 6913, 6912, 5164, 6917, 6918, 
         6914, 6916, 6915, 4645, 6931, 6932, 6930, 6934, 6933, 5048, 6348, 
         6349, 6054, 6055, 4619, 6417, 5608, 5563, 6053, 5565, 5840, 5839, 
         4823, 5655, 5657, 5463, 5653, 5651, 5742, 4944, 6289, 5663, 6263, 
         4888, 7712, 4890, 5576, 6131, 5573, 5847, 6460, 5849, 5406, 8270, 
         6605, 6609, 7885, 7087, 7093, 8410, 8523, 8519, 4896, 8406, 4900, 
         6738, 7353, 7984, 7913, 7919, 8074, 7694, 8609, 7278, 7842, 7284, 
         8615, 7611, 8238, 8232, 8390, 8384, 8022, 7937, 7402, 7998, 7528, 
         8565, 7700, 8282, 8288, 7893, 7658, 8529, 7664, 8154, 8160, 8166, 
         7759, 7222}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4753, 4974, 7166, 4975, 4786, 5009, 4813, 6687, 4814, 6688, 
         4755, 5969, 5970, 5283, 7190, 5282, 4754, 4972, 4973, 4796, 6033, 
         6034, 6035, 4582, 5650, 4585, 5442, 4882, 6574, 6575, 4693, 6753, 
         4694, 5213, 6958, 5214, 6959, 5212, 5919, 6603, 6149, 6412, 6411, 
         6052, 5564, 5047, 5841, 4822, 5656, 4885, 5462, 4884, 5654, 4943, 
         6288, 4945, 6762, 6761, 6265, 6734, 4889, 6261, 6127, 6130, 5572, 
         5846, 6459, 5848, 5405, 8269, 6604, 6608, 7884, 7086, 7092, 8409, 
         8522, 8518, 4895, 8405, 4899, 6737, 7352, 7983, 7912, 7918, 8073, 
         7693, 8608, 7277, 7841, 7283, 8614, 7610, 8237, 8231, 8389, 8383, 
         8021, 7936, 7401, 7997, 7527, 8564, 7699, 8281, 8287, 7892, 7657, 
         8528, 7663, 8153, 8159, 8165, 7758, 7221}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0VtoznEcx/HfIppk2YaZ2UFpOcQcepRT6UltNVZqtOaxQ5SoLXPhQhu1
EHIKOcwOTMlxysghc5xyyGGT2RW7QNwYkS0XvJ6L9/P5Hj7f7+/3+z85ldUr
qhJCCCl+mlNCiKWF8CQ5hPHpIXTS+/Im9dX0sXycehruyTvQgzZ5N88V+pZe
pV20eUII31JDaKRfaRM9OCaEWfqzkYe5mIPbdu8fF0K5fX18g6NDqBAP0KF6
LXrN+IgPiKplmJuIdDyTT6B/+Jv0G3EKj9S/4HMcd/iEzerr5UnucnlsCJeQ
rJat99DZj9Bv13e88I4z9CxaMdbcdd4xtJ1eQ5l7PpX/Ntcnbx0fwgLehegR
v8Mm/aheDe2Vv0ed8xabKXOPctQ56598G73BV8yzEj+9qSx+H5qgXqqWKk/B
A3luRgiJ4jbxHrMD+n+wRbxd/bVzX8W/m/46d+1GV/w7e/cdvtu4hSL3Web8
5SjEDvkJvpg9x2kDTuK4PSX2HaO/zEXV7vJOE19Qv4iddu9Ch9mp8T59SXN4
srHXbK03XzU3X71f7QeKzR7Ri6itMr8gfjat4t1AC+TFNEm/gu6ji9VGmBuJ
mFovLaFL7KmmJ9CACOp559N8c/PoclqImeLpemvNTqEFzluKFtzzffMy7REf
xk5xvt3TeGdgsrzGO3LFk7CVf3d2CG9oPX1Oiyf61jn+I/EntVHyDzTm/1mF
H+I19qzFX73VvL9pJT2g1mBuHc9GtGb5dvQ8bUMRXyM9hkPo5C1Qi+KouN2O
ReLdKIj7kYbMeKxfSiPOqKX12ILh8g7cRMT8aeedwxAkIglZ9iXzjsQwDNoV
paXq/wGKEqUq
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV01tMz3EYx/FvJrnAJipJ6CLkKmtmtuYiDJucMozNIVubFZY5bA6tctiE
cqHNdIML/f85DGlYmFg3uijkMGeyMTZbsjkk8/pdvPt8n+f5PM/38PuXVbx1
2ZaEEEKyP4UpIbwaHcJLbE0LYVZyCIPkFuL8qBCacD01hBt4bn1tbAjPaAv9
OzKE4vQQNmA94vIn5WO0mT6lV+gTepX28yeav453LVLlUtAqV2fv4/gTzRwT
Qo98E84jjou4gIdmvacf8BZJzv2OJjhvjHaqN9Iu+lktc1wIn+hS9SXYbo9E
8RDajXx7D45yGCL/Su8bvI725a937zSezxkhfFTvwbborHLf5HJ4Gux1lL8W
x9CgvsYd7vH08eRZX8FVVPIGZ6qK3lV9pXdYhT73rtHbY1413Y8q7OY7QC/z
9pp1RPyPfwB7rA9Gb2PuI3t+4Cm1foJuJPEMxQgzH+gdTjvoXt5/elutb+EY
Tx1qMdXZdqhVmNtoRhwxNJi9Wt8pOlc8B7nmLdKzMbq/dzqMGtwXT4vuTztp
Ds+UaA+9FXraveFi+SIsxxJzy7AZMfW7fGfNuUNL6BxzzskP4/1FD9Jetd9q
/fgh16b3O82T3ym3D5WYhxX6C6PvqG8BzaBjMdt6utomvbm0S3+v+0+ST870
vzDeHtG3jH6zE/xmab64AE1qe9xjpnUeqvWNyvLd9A2n+2gML6130Qn0BE2n
bd72NvL17DWnGqfVstVO0XrxGbUEcRL6J3pP+VL5NudoRQvK5Trwhaed1um5
ZD3DOm5drm8XfvIOYL7cV3EBreQ7hN1IN/cdXmCFuJnnJlKQgSxkm1lmRgku
ihPFj3kni4vE/wFiW6tR
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5495, 5498, 7800, 4745}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5510, 7794, 5513, 7349}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5514, 6472, 5418, 6471, 5419, 6473, 5355, 6005, 5356, 7082, 
         5357, 7083, 4773, 6020, 6021, 5508, 5507, 4713, 4934, 7162, 4935, 
         4920, 6271, 4919, 6272, 5605, 5649, 4583, 5441, 4874, 6572, 6573, 
         4691, 6755, 4692, 6955, 6956, 6954, 5209, 6957, 5207, 5917, 6145, 
         6143, 6456, 6455, 6049, 5556, 5040, 5827, 4816, 5643, 4873, 5460, 
         4871, 5636, 4938, 6758, 4940, 6756, 6725, 4870, 6728, 6566, 6567, 
         5548, 5819, 7118, 5822, 5394, 8265, 6592, 6598, 7876, 7072, 7076, 
         8399, 8512, 8508, 4857, 8395, 4863, 6720, 7395, 8335, 7389, 8641, 
         8653, 8647, 7423, 7598, 8594, 7261, 7835, 7267, 8600, 7604, 8177, 
         8171, 8347, 8341, 7930, 7924, 7383, 7989, 7521, 8552, 7681, 8255, 
         8261, 7858, 7641, 8496, 7647, 8135, 8141, 8147, 7751, 7768}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{4744, 7799, 5497, 5494}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4772, 5982, 5983, 5315, 7041, 5314, 4669, 6394, 6395, 6393, 
         6392, 6101, 5154, 6898, 5153, 6897, 6422, 6462, 6461, 7120, 6890, 
         6891, 6889, 5145, 6892, 5144, 5905, 6559, 6558, 6894, 6893, 7068, 
         5862, 4711, 6591, 6590, 5205, 6953, 4793, 6924, 5174, 6564, 6565, 
         5909, 5173, 5386, 7199, 5385, 5604, 4628, 7143, 5346, 5067, 6952, 
         5204, 6949, 6951, 6950, 5518, 6922, 5171, 6921, 5172, 6923, 5168, 
         7110, 5384, 7108, 5383, 7109, 5602, 6514, 6513, 6066, 5063, 6358, 
         5062, 5859, 6142, 6410, 5203, 6948, 6947, 6230, 6662, 7163, 6229, 
         6771, 6772, 6773, 6769, 6770, 6314, 6628, 4736, 6315, 4735, 6175, 
         5771, 4962, 5959, 5492, 6427, 6428, 6192, 6194, 4750, 5967, 6191, 
         6190, 6445, 5267, 7055, 5332, 6996, 7217, 6027, 6025, 5490, 4799, 
         5735, 5541, 6157, 4719, 5623, 5625, 5103, 5619, 6080, 6083, 5711, 
         4660, 5701, 5759, 5702, 5765, 5764, 7452, 5708, 6169, 5698, 4953, 
         7258, 8591, 4916, 7408, 5669, 5673, 7741, 6136, 7739, 4707, 7820, 
         7847, 5953, 7849, 5242, 5944, 5938, 7297, 8466, 7554, 8460, 7548, 
         7591, 8666, 7542, 8478, 7571, 8472, 6848, 6844, 7227, 7803, 7809, 
         7583, 8484, 7577, 7828, 7328, 8448, 8454, 8442, 7472, 7786, 8128, 
         8122, 8116, 7536, 7626, 8681, 7620, 7310, 8621, 7478, 7336, 8304, 
         8310, 8182, 8188, 7239, 8426, 7233, 8575, 8581, 8569, 7704, 7903, 
         7897, 8533, 8370, 8376, 8212, 8218, 8224, 7460, 8043, 8037, 8364, 
         7428, 8658, 7974, 8274}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4965, 6424, 5256, 6180, 6629, 6630, 5960, 5961, 5258, 6991, 
         5257, 7101, 7102, 6454, 5379, 6258, 4844, 6114, 6116, 6117, 6280, 
         6279, 5521, 5522, 5249, 6620, 6621, 6622, 5868, 6619, 6618, 6161, 
         5248, 6423, 4875, 6363, 6364, 6362, 5083, 6838, 5866, 6147, 6146, 
         6144, 5208, 5825, 5824, 5560, 6123, 6121, 6287, 4872, 5640, 6626, 
         6757, 6624, 6724, 4869, 6727, 6729, 6571, 7252, 5547, 5818, 7117, 
         5393, 8557, 5399, 7881, 6597, 7875, 7081, 7652, 8398, 8511, 8507, 
         4856, 8394, 4862, 6719, 7394, 8334, 7388, 8640, 8652, 8646, 7422, 
         7597, 8593, 7260, 7834, 7266, 8599, 7603, 8176, 8170, 8346, 8340, 
         7929, 7923, 7382, 7988, 7520, 8551, 7680, 8254, 8260, 7857, 7640, 
         8495, 7646, 8134, 8140, 8146, 7750, 7767}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5440, 6468, 5412, 6183, 6184, 6185, 5962, 5963, 5260, 6992, 
         5259, 7084, 7085, 6446, 5360, 6259, 4854, 6118, 6119, 6120, 6307, 
         6306, 4689, 5479, 5210, 6600, 6601, 6602, 5873, 6840, 5093, 6375, 
         5094, 6376, 4883, 6449, 6450, 6447, 5361, 6448, 5877, 6151, 6150, 
         6148, 5215, 5838, 5837, 5567, 6125, 6124, 6291, 4886, 5659, 6627, 
         6760, 6164, 6264, 6732, 6733, 6260, 6262, 6129, 7254, 5571, 5845, 
         6458, 5402, 8078, 5404, 7889, 6607, 7883, 7091, 7654, 8408, 8521, 
         8517, 4894, 8404, 4898, 6736, 7351, 7982, 7911, 7917, 8072, 7692, 
         8607, 7276, 7840, 7282, 8613, 7609, 8236, 8230, 8388, 8382, 8020, 
         7935, 7400, 7996, 7526, 8563, 7698, 8280, 8286, 7891, 7656, 8527, 
         7662, 8152, 8158, 8164, 7757, 7220}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5519, 5007, 7170, 5008, 4787, 5984, 5985, 5323, 7196, 5322, 
         4632, 5320, 7195, 5321, 5070, 6821, 5069, 6822, 5863, 4771, 5981, 
         4770, 6656, 6655, 5311, 5451, 4597, 4611, 5337, 7062, 5338, 7063, 
         5280, 5416, 6637, 6636, 7013, 7012, 7067, 5861, 4782, 6664, 6663, 
         5318, 7043, 5473, 7011, 5279, 6634, 6635, 5860, 5066, 5345, 7142, 
         4627, 5776, 4626, 7141, 5065, 5064, 7010, 5278, 7007, 7009, 7008, 
         4666, 7005, 5276, 7004, 5277, 7006, 5061, 7066, 5343, 6510, 6511, 
         6512, 5773, 6063, 6062, 6353, 5060, 7173, 6352, 6817, 6816, 5270, 
         6998, 7125, 7124, 6015, 5112, 6864, 6863, 7123, 7122, 5368, 6305, 
         4968, 6188, 6189, 4749, 6444, 5853, 5854, 5768, 4961, 5966, 5491, 
         6425, 6426, 6187, 6469, 6631, 4748, 6470, 5413, 5500, 5499, 5974, 
         5294, 6477, 5423, 6475, 5422, 5715, 4921, 6013, 4922, 5737, 5716, 
         6160, 4725, 5727, 5728, 5136, 5724, 6102, 6104, 5616, 4672, 5683, 
         5786, 5685, 5791, 5790, 7448, 5691, 6219, 5678, 4999, 7256, 8589, 
         4911, 5444, 5533, 5535, 7727, 5528, 7725, 4685, 8052, 4679, 5933, 
         7716, 5233, 5926, 5921, 7290, 8328, 7376, 8322, 7370, 7508, 8634, 
         7342, 8420, 7437, 8414, 6748, 6742, 8432, 7773, 7779, 7674, 8539, 
         7668, 8545, 7822, 7322, 8292, 8298, 8098, 8316, 8104, 8110, 7502, 
         8092, 8086, 8080, 7364, 7496, 7490, 7316, 8627, 7484, 7560, 8008, 
         8014, 7959, 7965, 7246, 8026, 7733, 8060, 8066, 8054, 7686, 7869, 
         7863, 8501, 8352, 8358, 8194, 8200, 8206, 7454, 7953, 7947, 7941, 
         7416, 8002, 7514}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5509, 7793, 5512, 7348}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4598, 5312, 7194, 5313, 5021, 6799, 5020, 7211, 6391, 5151, 
         5476, 5475, 6019, 5124, 5891, 5374, 6703, 4836, 6544, 6545, 6790, 
         4994, 6658, 6660, 6659, 7206, 4792, 6671, 6672, 6489, 4596, 6752, 
         4592, 4610, 6493, 6492, 6807, 6806, 5031, 5170, 7181, 5169, 4667, 
         5201, 8672, 5202, 5914, 5913, 6589, 6588, 6141, 5200, 6409, 5336, 
         6342, 5030, 6176, 5029, 6341, 5813, 5814, 5255, 8675, 5254, 7308, 
         5268, 8678, 5269, 7618, 6997, 5266, 8493, 6995, 6994, 7216, 7218, 
         6026, 5489, 5540, 4718, 7908, 4720, 7764, 7765, 5104, 5712, 6082, 
         5710, 6088, 6087, 5704, 7450, 5763, 7451, 4952, 8663, 4951, 7257, 
         8590, 4915, 7407, 5668, 5672, 7740, 6135, 7738, 4706, 7819, 7846, 
         5952, 7848, 5241, 7853, 7615, 5943, 7296, 8465, 7553, 8459, 7547, 
         7590, 8665, 7541, 8477, 7570, 8471, 6847, 6843, 7226, 7802, 7808, 
         7582, 8483, 7576, 7827, 7327, 8447, 8453, 8441, 7471, 7785, 8127, 
         8121, 8115, 7535, 7625, 8680, 7619, 7309, 8620, 7477, 7335, 8303, 
         8309, 8181, 8187, 7238, 8425, 7232, 8574, 8580, 8568, 7703, 7902, 
         7896, 8532, 8369, 8375, 8211, 8217, 8223, 7459, 8042, 8036, 8363, 
         7427, 8657, 7973, 8273}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4739, 7795, 4740, 7791, 7792, 5511, 7347}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4742, 8049, 4743, 6182, 6181, 6304, 6303, 6809, 5038, 6346, 
         5039, 6347, 6638, 6196, 7156, 4808, 6238, 4807, 5211, 8605, 7274, 
         5874, 5092, 6377, 6378, 6075, 6516, 4635, 7746, 5956, 5875, 5876, 
         6008, 6007, 5095, 5920, 5482, 5483, 5958, 5957, 4695, 6290, 4946, 
         6126, 4947, 5660, 5658, 7306, 6162, 6163, 7970, 6128, 7253, 5570, 
         5844, 6457, 5401, 8077, 5403, 7888, 6606, 7882, 7090, 7653, 8407, 
         8520, 8516, 4893, 8403, 4897, 6735, 7350, 7981, 7910, 7916, 8071, 
         7691, 8606, 7275, 7839, 7281, 8612, 7608, 8235, 8229, 8387, 8381, 
         8019, 7934, 7399, 7995, 7525, 8562, 7697, 8279, 8285, 7890, 7655, 
         8526, 7661, 8151, 8157, 8163, 7756, 7219}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5797, 5005, 7169, 5006, 4835, 6099, 6332, 6333, 5004, 5376, 
         7198, 5375, 6010, 4785, 7154, 5434, 6178, 7164, 6177, 6775, 6776, 
         6777, 6774, 6316, 6783, 4982, 6645, 4764, 6646, 7205, 4789, 6669, 
         6670, 6484, 4593, 6778, 5601, 7000, 7001, 6999, 7003, 7002, 5273, 
         5275, 7189, 5274, 4737, 5271, 8679, 5272, 5415, 7121, 5414, 5504, 
         5503, 6014, 5307, 5435, 6210, 6209, 5263, 6993, 6632, 6633, 5964, 
         5965, 5265, 8677, 5264, 7307, 5261, 8676, 5262, 7617, 6430, 5295, 
         7028, 8050, 6476, 6474, 7127, 5713, 5714, 5409, 5718, 6158, 4723, 
         7909, 4724, 7747, 7748, 5135, 5617, 6103, 5615, 6107, 6106, 5684, 
         7446, 5789, 7447, 5000, 8664, 4998, 7255, 8588, 4910, 5443, 5532, 
         5534, 7726, 5527, 7724, 4684, 8051, 4678, 5932, 7715, 5232, 7845, 
         7614, 5930, 7289, 8327, 7375, 8321, 7369, 7507, 8633, 7341, 8419, 
         7436, 8413, 6747, 6741, 8431, 7772, 7778, 7673, 8538, 7667, 8544, 
         7821, 7321, 8291, 8297, 8097, 8315, 8103, 8109, 7501, 8091, 8085, 
         8079, 7363, 7495, 7489, 7315, 8626, 7483, 7559, 8007, 8013, 7958, 
         7964, 7245, 8025, 7732, 8059, 8065, 8053, 7685, 7868, 7862, 8500, 
         8351, 8357, 8193, 8199, 8205, 7453, 7952, 7946, 7940, 7415, 8001, 
         7513}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7722, 8048, 4741, 7148, 6302, 6179, 6301, 6300, 6344, 5036, 
         6343, 5037, 6345, 6657, 6214, 7159, 4843, 6257, 6115, 5206, 8604, 
         7273, 5867, 5082, 6360, 6361, 6070, 6071, 4634, 7755, 4633, 5864, 
         5865, 5870, 5869, 5081, 5918, 5480, 5481, 5916, 5915, 4690, 6286, 
         4941, 6122, 4942, 5639, 5638, 7305, 6623, 6625, 8245, 6570, 7251, 
         5546, 5817, 7116, 5392, 8556, 5398, 7880, 6596, 7874, 7080, 7651, 
         8397, 8510, 8506, 4855, 8393, 4861, 6718, 7393, 8333, 7387, 8639, 
         8651, 8645, 7421, 7596, 8592, 7259, 7833, 7265, 8598, 7602, 8175, 
         8169, 8345, 8339, 7928, 7922, 7381, 7987, 7519, 8550, 7679, 8253, 
         8259, 7856, 7639, 8494, 7645, 8133, 8139, 8145, 7749, 7766}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7723, 7796, 4746, 7797, 7798, 5496, 5493}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, {}, {}}}],
  Frame->True,
  PlotRange->{{-1, 1}, {0.2, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178526160]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24387],

Cell["Find derivatives:", "ExampleText",
 CellID->211775500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"ModularLambda", "[", "\[Tau]", "]"}], ",", "\[Tau]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2259480],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox[
    RowBox[{"EllipticK", "[", 
     RowBox[{"ModularLambda", "[", "\[Tau]", "]"}], "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"ModularLambda", "[", "\[Tau]", "]"}]}], ")"}], " ", 
   RowBox[{"ModularLambda", "[", "\[Tau]", "]"}]}], "\[Pi]"]], "Output",
 ImageSize->{488, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254027549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->824263366],

Cell["Find a numerical root:", "ExampleText",
 CellID->34907641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ModularLambda", "[", "z", "]"}], "+", 
     RowBox[{"ModularLambda", "[", 
      RowBox[{"z", "^", "2"}], "]"}], "+", "z"}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"1", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67131020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"1.2955647725322852`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9547246764669517`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283364877]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11957],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->39264097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ModularLambda", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10.", "^", "22"}], " ", "Pi"}], "+", " ", "I"}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->984650579],

Cell[BoxData[
 RowBox[{"ModularLambda", "[", 
  RowBox[{"3.141592653589793`*^22", "+", "\[ImaginaryI]"}], "]"}]], "Output",
 ImageSize->{215, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->659916502]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->152675266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ModularLambda", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"10", "^", "22"}], " ", "Pi"}], "+", " ", "I"}], " ", "]"}], 
   ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->671820007],

Cell[BoxData[
 RowBox[{"0.32250952910404466187178457768377518753`19.858978759770498", "+", 
  RowBox[{
  "0.54243824412757965966927364148456335924`20.084786510110998", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->612153076]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->713031972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ModularLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ModularLambda"]], "InlineFormula"],
 " remains unevaluated outside of its domain of analyticity:"
}], "ExampleText",
 CellID->119463066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ModularLambda", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423114294],

Cell[BoxData[
 RowBox[{"ModularLambda", "[", "1", "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->621157897]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->746482900],

Cell[BoxData[
 RowBox[{"ModularLambda", "[", "1.`", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5101944]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15012],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DedekindEta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DedekindEta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KleinInvariantJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KleinInvariantJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassHalfPeriods",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassHalfPeriods"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6831]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30129],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->5793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11977],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticLambdaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/ModularLambda/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ModularLambda"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->384681874],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->340904650]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ModularLambda - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 55.4647244}", "context" -> "System`", 
    "keywords" -> {
     "elliptic lambda function", "modular form", "modular function"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ModularLambda[\\[Tau]] gives the modular lambda elliptic function \
\\[Lambda](\\[Tau]). ", "synonyms" -> {"modular lambda"}, "title" -> 
    "ModularLambda", "type" -> "Symbol", "uri" -> "ref/ModularLambda"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7723, 270, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->430355927]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 267751, 5162}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2218, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2841, 82, 50, 1, 70, "ObjectName",
 CellID->4667],
Cell[2894, 85, 634, 20, 70, "Usage",
 CellID->403]
}, Open  ]],
Cell[CellGroupData[{
Cell[3565, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4043, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4166, 133, 412, 13, 70, "Notes",
 CellID->18899],
Cell[4581, 148, 331, 12, 70, "Notes",
 CellID->21054],
Cell[4915, 162, 532, 19, 70, "Notes",
 CellID->10167],
Cell[5450, 183, 931, 32, 70, "Notes",
 CellID->19212],
Cell[6384, 217, 596, 20, 70, "Notes",
 CellID->26114],
Cell[6983, 239, 258, 8, 70, "Notes",
 CellID->136997468],
Cell[7244, 249, 228, 7, 70, "Notes",
 CellID->31226],
Cell[7475, 258, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7723, 270, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->430355927],
Cell[CellGroupData[{
Cell[8108, 284, 148, 5, 70, "ExampleSection",
 CellID->340957348],
Cell[8259, 291, 201, 5, 70, "ExampleText",
 CellID->367082541],
Cell[CellGroupData[{
Cell[8485, 300, 152, 5, 28, "Input",
 CellID->640505947],
Cell[8640, 307, 303, 8, 36, "Output",
 CellID->248334456]
}, Open  ]],
Cell[8958, 318, 124, 3, 70, "ExampleDelimiter",
 CellID->62858631],
Cell[CellGroupData[{
Cell[9107, 325, 301, 10, 28, "Input",
 CellID->434631559],
Cell[9411, 337, 4267, 74, 163, "Output",
 Evaluatable->False,
 CellID->473518722]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13727, 417, 215, 7, 70, "ExampleSection",
 CellID->2489],
Cell[13945, 426, 207, 5, 70, "ExampleText",
 CellID->300764116],
Cell[CellGroupData[{
Cell[14177, 435, 213, 7, 70, "Input",
 CellID->473585789],
Cell[14393, 444, 336, 10, 36, "Output",
 CellID->68800034]
}, Open  ]],
Cell[14744, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->285336765],
Cell[14872, 462, 113, 3, 70, "ExampleText",
 CellID->749607522],
Cell[CellGroupData[{
Cell[15010, 469, 199, 6, 70, "Input",
 CellID->269092720],
Cell[15212, 477, 328, 10, 36, "Output",
 CellID->163917846]
}, Open  ]],
Cell[15555, 490, 124, 3, 70, "ExampleDelimiter",
 CellID->79992783],
Cell[15682, 495, 357, 11, 70, "ExampleText",
 CellID->156500339],
Cell[CellGroupData[{
Cell[16064, 510, 319, 11, 70, "Input",
 CellID->95565713],
Cell[16386, 523, 724, 19, 54, "Output",
 CellID->510155556]
}, Open  ]],
Cell[17125, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->108435872],
Cell[17253, 550, 341, 11, 70, "ExampleText",
 CellID->362619855],
Cell[CellGroupData[{
Cell[17619, 565, 155, 5, 70, "Input",
 CellID->262917800],
Cell[17777, 572, 412, 15, 50, "Output",
 CellID->668050169]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18238, 593, 222, 7, 70, "ExampleSection",
 CellID->6612],
Cell[18463, 602, 400, 13, 70, "ExampleText",
 CellID->113946985],
Cell[CellGroupData[{
Cell[18888, 619, 185, 5, 70, "Input",
 CellID->280610937],
Cell[19076, 626, 250, 7, 36, "Output",
 CellID->23299313]
}, Open  ]],
Cell[19341, 636, 137, 2, 70, "ExampleText",
 CellID->84070064],
Cell[CellGroupData[{
Cell[19503, 642, 753, 23, 70, "Input",
 CellID->484125019],
Cell[20259, 667, 208, 6, 36, "Output",
 CellID->18025639]
}, Open  ]],
Cell[20482, 676, 125, 3, 70, "ExampleDelimiter",
 CellID->898404421],
Cell[20610, 681, 249, 7, 70, "ExampleText",
 CellID->247947759],
Cell[CellGroupData[{
Cell[20884, 692, 995, 31, 70, "Input",
 CellID->599501020],
Cell[21882, 725, 1713, 32, 70, "Output",
 Evaluatable->False,
 CellID->166463411]
}, Open  ]],
Cell[23610, 760, 96, 1, 70, "ExampleText",
 CellID->245616256],
Cell[23709, 763, 573, 19, 70, "Input",
 CellID->589318435],
Cell[CellGroupData[{
Cell[24307, 786, 539, 17, 70, "Input",
 CellID->244320265],
Cell[24849, 805, 386, 7, 70, "Message",
 CellID->143604003],
Cell[25238, 814, 994, 34, 36, "Output",
 CellID->2027060]
}, Open  ]],
Cell[26247, 851, 83, 1, 70, "ExampleText",
 CellID->368716069],
Cell[CellGroupData[{
Cell[26355, 856, 171, 5, 70, "Input",
 CellID->162996499],
Cell[26529, 863, 1083, 22, 70, "Output",
 Evaluatable->False,
 CellID->249911769]
}, Open  ]],
Cell[27627, 888, 125, 3, 70, "ExampleDelimiter",
 CellID->239529986],
Cell[27755, 893, 97, 3, 70, "ExampleText",
 CellID->79806370],
Cell[27855, 898, 1479, 49, 70, "Input",
 CellID->421540520],
Cell[29337, 949, 49, 1, 70, "ExampleText",
 CellID->256774412],
Cell[CellGroupData[{
Cell[29411, 954, 1646, 51, 70, "Input",
 CellID->213559680],
Cell[31060, 1007, 212, 7, 36, "Output",
 CellID->29012146]
}, Open  ]],
Cell[31287, 1017, 125, 3, 70, "ExampleDelimiter",
 CellID->182306764],
Cell[31415, 1022, 82, 1, 70, "ExampleText",
 CellID->63938395],
Cell[CellGroupData[{
Cell[31522, 1027, 461, 14, 70, "Input",
 CellID->540455162],
Cell[31986, 1043, 226389, 3763, 70, "Output",
 CellID->178526160]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[258424, 4812, 233, 7, 70, "ExampleSection",
 CellID->24387],
Cell[258660, 4821, 60, 1, 70, "ExampleText",
 CellID->211775500],
Cell[CellGroupData[{
Cell[258745, 4826, 172, 6, 70, "Input",
 CellID->2259480],
Cell[258920, 4834, 502, 14, 54, "Output",
 CellID->254027549]
}, Open  ]],
Cell[259437, 4851, 125, 3, 70, "ExampleDelimiter",
 CellID->824263366],
Cell[259565, 4856, 64, 1, 70, "ExampleText",
 CellID->34907641],
Cell[CellGroupData[{
Cell[259654, 4861, 380, 12, 70, "Input",
 CellID->67131020],
Cell[260037, 4875, 331, 10, 36, "Output",
 CellID->283364877]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[260417, 4891, 226, 7, 70, "ExampleSection",
 CellID->11957],
Cell[260646, 4900, 115, 3, 70, "ExampleText",
 CellID->39264097],
Cell[CellGroupData[{
Cell[260786, 4907, 198, 7, 70, "Input",
 CellID->984650579],
Cell[260987, 4916, 254, 7, 39, "Output",
 CellID->659916502]
}, Open  ]],
Cell[261256, 4926, 83, 1, 70, "ExampleText",
 CellID->152675266],
Cell[CellGroupData[{
Cell[261364, 4931, 257, 9, 70, "Input",
 CellID->671820007],
Cell[261624, 4942, 339, 9, 36, "Output",
 CellID->612153076]
}, Open  ]],
Cell[261978, 4954, 125, 3, 70, "ExampleDelimiter",
 CellID->713031972],
Cell[262106, 4959, 245, 7, 70, "ExampleText",
 CellID->119463066],
Cell[CellGroupData[{
Cell[262376, 4970, 109, 3, 70, "Input",
 CellID->423114294],
Cell[262488, 4975, 198, 6, 36, "Output",
 CellID->621157897]
}, Open  ]],
Cell[CellGroupData[{
Cell[262723, 4986, 97, 3, 70, "Input",
 CellID->746482900],
Cell[262823, 4991, 198, 6, 36, "Output",
 CellID->5101944]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[263082, 5004, 311, 9, 70, "SeeAlsoSection",
 CellID->15012],
Cell[263396, 5015, 998, 35, 70, "SeeAlso",
 CellID->6831]
}, Open  ]],
Cell[CellGroupData[{
Cell[264431, 5055, 314, 9, 70, "TutorialsSection",
 CellID->30129],
Cell[264748, 5066, 191, 4, 70, "Tutorials",
 CellID->5793]
}, Open  ]],
Cell[CellGroupData[{
Cell[264976, 5075, 321, 9, 70, "RelatedLinksSection",
 CellID->11977],
Cell[265300, 5086, 193, 4, 70, "RelatedLinks"],
Cell[265496, 5092, 203, 4, 70, "RelatedLinks"],
Cell[265702, 5098, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[266130, 5116, 319, 9, 70, "MoreAboutSection",
 CellID->384681874],
Cell[266452, 5127, 145, 3, 70, "MoreAbout",
 CellID->340904650]
}, Open  ]],
Cell[266612, 5133, 27, 0, 70, "History"],
Cell[266642, 5135, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

