(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30266,       1125]
NotebookOptionsPosition[     24493,        926]
NotebookOutlinePosition[     25823,        964]
CellTagsIndexPosition[     25738,        959]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomials Modulo Primes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsModuloPrimes"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Polynomials Modulo Primes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Extension" :> Documentation`HelpLookup["paclet:ref/Extension"],
           "Mod" :> Documentation`HelpLookup["paclet:ref/Mod"], "Coefficient" :> 
          Documentation`HelpLookup["paclet:ref/Coefficient"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"], "Resultant" :> 
          Documentation`HelpLookup["paclet:ref/Resultant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Extension\"\>", 2->"\<\"Mod\"\>", 
       3->"\<\"Coefficient\"\>", 4->"\<\"Factor\"\>", 
       5->"\<\"FindInstance\"\>", 6->"\<\"Reduce\"\>", 
       7->"\<\"PolynomialMod\"\>", 
       8->"\<\"Resultant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Division\"\>", 
       3->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Modulus", "ObjectName",
 CellID->30185],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Modulus", "->", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is an option that can be given in certain algebraic \
functions to specify that integers should be treated modulo ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Equations for ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " can be given in ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and related functions."
}], "Notes",
 CellID->42668812],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " appears as an option in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolynomialLCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFormula"],
 ", as well as in linear algebra functions such as ",
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28608],

Cell[TextData[{
 "Arithmetic is usually done over the full ring ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"],
 " of integers; setting the option ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " specifies that arithmetic should instead be done in the finite ring ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[DoubleStruckCapitalZ]", "n"], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->17888],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"Modulus", "->", "0"}]], "InlineFormula"],
 " specifies the full ring ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"],
 " of integers. "
}], "Notes",
 CellID->9499],

Cell[TextData[{
 "Some functions require that ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " be set to a prime, or a power of a prime. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[DoubleStruckCapitalZ]", "n"], TraditionalForm]], 
  "InlineMath"],
 " is a finite field when ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is prime. "
}], "Notes",
 CellID->12425]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114856791],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->697571020],

Cell["Solve equations: ", "ExampleText",
 CellID->887485360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "==", 
    RowBox[{
     RowBox[{"y", "^", "4"}], "+", 
     RowBox[{"x", "y"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Modulus", "->", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14071071],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}]}]], "Output",
 ImageSize->{347, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141872883]
}, Open  ]],

Cell["Factor polynomials:", "ExampleText",
 CellID->224236719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "6"}], "+", 
      RowBox[{"3", 
       RowBox[{"x", "^", "4"}]}], "+", "x"}], ",", 
     RowBox[{"Modulus", "\[Rule]", 
      RowBox[{"Prime", "[", "k", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443120878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "5"]}], ")"}]}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}], "+", 
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      SuperscriptBox["x", "4"]}], ")"}]}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SuperscriptBox["x", "3"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{510, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50798118]
}, Open  ]],

Cell["Compute inverse:", "ExampleText",
 CellID->360976199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->453950136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->779373822]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6851],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " over the integers modulo 2:"
}], "ExampleText",
 CellID->73688638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "4"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607080612],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "3"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661666954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16666516],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " a polynomial over the integers modulo 3:"
}], "ExampleText",
 CellID->835606921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"3", "x"}], "+", "5"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46119768],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{114, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80246940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215124762],

Cell[TextData[{
 "Find a ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " over the integers modulo 5:"
}], "ExampleText",
 CellID->581860290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"2", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"y", "^", "3"}], "-", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "y"}], "+", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126926758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "4"]}], "+", 
    SuperscriptBox["y", "5"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "7"]}], "+", 
    SuperscriptBox["y", "8"], "+", 
    SuperscriptBox["y", "9"]}], ",", 
   RowBox[{"4", "+", "x", "+", "y", "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    SuperscriptBox["y", "7"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "8"]}]}]}], "}"}]], "Output",
 ImageSize->{464, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339773338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147006271],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " equations over the integers modulo 7:"
}], "ExampleText",
 CellID->138771324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"3", "x", " ", "y"}], "+", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "^", "3"}], "-", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "y"}], "+", "3"}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6098712],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758691726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440552291],

Cell["Compute the determinant of a matrix modulo 8:", "ExampleText",
 CellID->290805486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "210", ",", "2100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2221", ",", "3332", ",", "4443"}], "}"}]}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258693633],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470309040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30915891],

Cell["\<\
Find a modulus for which a system of equations has a solution:\
\>", "ExampleText",
 CellID->640369772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197039454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Modulus", "\[Rule]", "191721"}], ",", 
    RowBox[{"y", "\[Rule]", "96231"}], ",", 
    RowBox[{"x", "\[Rule]", "47377"}]}], "}"}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284234754]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3505],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " a polynomial over a finite field:"
}], "ExampleText",
 CellID->33862607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "2"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82310624],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435593803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->664447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " a polynomial over a finite ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " of rationals:"
}], "ExampleText",
 CellID->66380571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "2"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27171419],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "-", 
     SuperscriptBox["x", "2"]}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{141, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413645141]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11502],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resultant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resultant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5970]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26896],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "Tutorials",
 CellID->27769]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->726232880],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->30567364],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->226898261],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->128411000]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Modulus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 1.3398748}", "context" -> "System`", 
    "keywords" -> {
     "modular computation", "modular ring", "prime fields", "quotient rings"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Modulus -> n is an option that can be given in certain algebraic \
functions to specify that integers should be treated modulo n. ", 
    "synonyms" -> {}, "title" -> "Modulus", "type" -> "Symbol", "uri" -> 
    "ref/Modulus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7170, 234, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114856791]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25595, 952}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2791, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3414, 89, 45, 1, 70, "ObjectName",
 CellID->30185],
Cell[3462, 92, 538, 16, 70, "Usage",
 CellID->25516]
}, Open  ]],
Cell[CellGroupData[{
Cell[4037, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4515, 130, 345, 13, 70, "Notes",
 CellID->42668812],
Cell[4863, 145, 1009, 37, 70, "Notes",
 CellID->28608],
Cell[5875, 184, 528, 16, 70, "Notes",
 CellID->17888],
Cell[6406, 202, 262, 9, 70, "Notes",
 CellID->9499],
Cell[6671, 213, 462, 16, 70, "Notes",
 CellID->12425]
}, Closed]],
Cell[CellGroupData[{
Cell[7170, 234, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114856791],
Cell[CellGroupData[{
Cell[7555, 248, 148, 5, 70, "ExampleSection",
 CellID->697571020],
Cell[7706, 255, 60, 1, 70, "ExampleText",
 CellID->887485360],
Cell[CellGroupData[{
Cell[7791, 260, 346, 12, 28, "Input",
 CellID->14071071],
Cell[8140, 274, 898, 30, 54, "Output",
 CellID->141872883]
}, Open  ]],
Cell[9053, 307, 62, 1, 70, "ExampleText",
 CellID->224236719],
Cell[CellGroupData[{
Cell[9140, 312, 429, 14, 28, "Input",
 CellID->443120878],
Cell[9572, 328, 960, 32, 39, "Output",
 CellID->50798118]
}, Open  ]],
Cell[10547, 363, 59, 1, 70, "ExampleText",
 CellID->360976199],
Cell[CellGroupData[{
Cell[10631, 368, 317, 11, 70, "Input",
 CellID->453950136],
Cell[10951, 381, 302, 11, 36, "Output",
 CellID->779373822]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11302, 398, 215, 7, 70, "ExampleSection",
 CellID->6851],
Cell[11520, 407, 227, 8, 70, "ExampleText",
 CellID->73688638],
Cell[CellGroupData[{
Cell[11772, 419, 347, 11, 70, "Input",
 CellID->607080612],
Cell[12122, 432, 228, 8, 36, "Output",
 CellID->661666954]
}, Open  ]],
Cell[12365, 443, 124, 3, 70, "ExampleDelimiter",
 CellID->16666516],
Cell[12492, 448, 214, 7, 70, "ExampleText",
 CellID->835606921],
Cell[CellGroupData[{
Cell[12731, 459, 295, 10, 70, "Input",
 CellID->46119768],
Cell[13029, 471, 310, 11, 39, "Output",
 CellID->80246940]
}, Open  ]],
Cell[13354, 485, 125, 3, 70, "ExampleDelimiter",
 CellID->215124762],
Cell[13482, 490, 227, 8, 70, "ExampleText",
 CellID->581860290],
Cell[CellGroupData[{
Cell[13734, 502, 511, 17, 70, "Input",
 CellID->126926758],
Cell[14248, 521, 892, 29, 39, "Output",
 CellID->339773338]
}, Open  ]],
Cell[15155, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->147006271],
Cell[15283, 558, 211, 7, 70, "ExampleText",
 CellID->138771324],
Cell[CellGroupData[{
Cell[15519, 569, 565, 19, 70, "Input",
 CellID->6098712],
Cell[16087, 590, 406, 14, 36, "Output",
 CellID->758691726]
}, Open  ]],
Cell[16508, 607, 125, 3, 70, "ExampleDelimiter",
 CellID->440552291],
Cell[16636, 612, 88, 1, 70, "ExampleText",
 CellID->290805486],
Cell[CellGroupData[{
Cell[16749, 617, 421, 13, 70, "Input",
 CellID->258693633],
Cell[17173, 632, 158, 5, 36, "Output",
 CellID->470309040]
}, Open  ]],
Cell[17346, 640, 124, 3, 70, "ExampleDelimiter",
 CellID->30915891],
Cell[17473, 645, 113, 3, 70, "ExampleText",
 CellID->640369772],
Cell[CellGroupData[{
Cell[17611, 652, 584, 20, 70, "Input",
 CellID->197039454],
Cell[18198, 674, 350, 11, 36, "Output",
 CellID->284234754]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18597, 691, 232, 7, 70, "ExampleSection",
 CellID->3505],
Cell[18832, 700, 206, 7, 70, "ExampleText",
 CellID->33862607],
Cell[CellGroupData[{
Cell[19063, 711, 209, 7, 70, "Input",
 CellID->82310624],
Cell[19275, 720, 372, 13, 39, "Output",
 CellID->435593803]
}, Open  ]],
Cell[19662, 736, 122, 3, 70, "ExampleDelimiter",
 CellID->664447],
Cell[19787, 741, 340, 12, 70, "ExampleText",
 CellID->66380571],
Cell[CellGroupData[{
Cell[20152, 757, 244, 8, 70, "Input",
 CellID->27171419],
Cell[20399, 767, 377, 15, 43, "Output",
 CellID->413645141]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20837, 789, 311, 9, 70, "SeeAlsoSection",
 CellID->11502],
Cell[21151, 800, 1930, 71, 70, "SeeAlso",
 CellID->5970]
}, Open  ]],
Cell[CellGroupData[{
Cell[23118, 876, 314, 9, 70, "TutorialsSection",
 CellID->26896],
Cell[23435, 887, 159, 3, 70, "Tutorials",
 CellID->27769]
}, Open  ]],
Cell[CellGroupData[{
Cell[23631, 895, 319, 9, 70, "MoreAboutSection",
 CellID->726232880],
Cell[23953, 906, 146, 3, 70, "MoreAbout",
 CellID->30567364],
Cell[24102, 911, 149, 3, 70, "MoreAbout",
 CellID->226898261],
Cell[24254, 916, 167, 3, 70, "MoreAbout",
 CellID->128411000]
}, Open  ]],
Cell[24436, 922, 27, 0, 70, "History"],
Cell[24466, 924, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

