(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61635,       2087]
NotebookOptionsPosition[     51084,       1723]
NotebookOutlinePosition[     52717,       1765]
CellTagsIndexPosition[     52631,       1760]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Convolutions and Correlations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvolutionsAndCorrelations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Convolutions and Correlations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
          "MovingMedian" :> 
          Documentation`HelpLookup["paclet:ref/MovingMedian"], 
          "ExponentialMovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/ExponentialMovingAverage"], 
          "Partition" :> Documentation`HelpLookup["paclet:ref/Partition"], 
          "ListCorrelate" :> 
          Documentation`HelpLookup["paclet:ref/ListCorrelate"], "Accumulate" :> 
          Documentation`HelpLookup["paclet:ref/Accumulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mean\"\>", 
       2->"\<\"MovingMedian\"\>", 3->"\<\"ExponentialMovingAverage\"\>", 
       4->"\<\"Partition\"\>", 5->"\<\"ListCorrelate\"\>", 
       6->"\<\"Accumulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Data Transforms and Smoothing\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 3->"\<\"Numerical Data\"\>", 
       4->"\<\"Signal Processing\"\>", 5->"\<\"Statistics\"\>", 
       6->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       8->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       9->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MovingAverage", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MovingAverage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MovingAverage"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the moving average of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ", computed by averaging runs of ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " elements."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MovingAverage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MovingAverage"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["w", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["w", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["w", "TI"], 
           StyleBox["r", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the moving average of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ", computed with weights ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27277]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " gives a list of the means of elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " taken in blocks of length ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->331423122,
  ButtonNote->"331423122"]
}], "Notes",
 CellID->24023],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["wts", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["wts", "TI"], "/", 
     RowBox[{
      ButtonBox["Total",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Total"], "[", 
      StyleBox["wts", "TI"], "]"}]}], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->43284639,
  ButtonNote->"43284639"]
}], "Notes",
 CellID->2788332],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 " handles both numerical and symbolic data."
}], "Notes",
 CellID->787242721],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 " gives a list of length ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}], "-", 
   StyleBox["r", "TI"], "+", "1"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25709],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->625271644,
  ButtonNote->"625271644"]
}], "Notes",
 CellID->18986194]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459241430],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->306850804],

Cell["Compute a pairwise simple moving average:", "ExampleText",
 CellID->207735283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230914973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", "b"}], "2"], ",", 
   FractionBox[
    RowBox[{"b", "+", "c"}], "2"], ",", 
   FractionBox[
    RowBox[{"c", "+", "d"}], "2"], ",", 
   FractionBox[
    RowBox[{"d", "+", "e"}], "2"]}], "}"}]], "Output",
 ImageSize->{175, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105959448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348971872],

Cell["Compute weighted moving averages:", "ExampleText",
 CellID->189707948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412882448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["a", "3"], "+", 
    FractionBox[
     RowBox[{"2", " ", "b"}], "3"]}], ",", 
   RowBox[{
    FractionBox["b", "3"], "+", 
    FractionBox[
     RowBox[{"2", " ", "c"}], "3"]}], ",", 
   RowBox[{
    FractionBox["c", "3"], "+", 
    FractionBox[
     RowBox[{"2", " ", "d"}], "3"]}], ",", 
   RowBox[{
    FractionBox["d", "3"], "+", 
    FractionBox[
     RowBox[{"2", " ", "e"}], "3"]}]}], "}"}]], "Output",
 ImageSize->{232, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237834412]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7966],

Cell["Lists of integers yield rational numbers:", "ExampleText",
 CellID->16129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["13", "3"], ",", "5", ",", 
   FractionBox["16", "3"], ",", 
   FractionBox["11", "3"]}], "}"}]], "Output",
 ImageSize->{113, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363624225]
}, Open  ]],

Cell["Lists of approximate numbers yield approximate numbers:", "ExampleText",
 CellID->587699784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "5.2", ",", "3.4", ",", "4.5", ",", "2.3", ",", "4.5"}], 
    "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->80080504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.2666666666666666`", ",", "4.366666666666667`", ",", "3.4`", ",", 
   "3.7666666666666666`"}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228515084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->722951932],

Cell["Moving averages of matrices are matrices: ", "ExampleText",
 CellID->14559980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357143563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.1515110707265994`", ",", "4.778544863551181`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.359489984287731`", ",", "0.5361571130741716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.655383779374696`", ",", "0.8137881394372648`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5580174974671275`", ",", "0.8423864231081568`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6297747206871303`", ",", "2.914406982817294`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.880366485905823`", ",", "1.2660665688698003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.757599263604952`", ",", "4.464835593438209`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.28875400369130166`", ",", "4.788116599289257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.305601313542993`", ",", "0.7827567809940417`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4712289396503675`", ",", "4.033900038841821`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19537340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{"data", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452249129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.1811005829640386`", ",", "1.7427191347926936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3006664954541716`", ",", "1.2766846646092218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.430885620858694`", ",", "1.459162028558129`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7064394919162584`", ",", "2.3719238920583647`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.139123618472302`", ",", "3.35835643610364`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.058080266686267`", ",", "2.825443885647827`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2057958801224036`", ",", "3.5174022531408324`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{531, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248752310]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "4"}], ",", 
     RowBox[{"1", "/", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->652462847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.0813259541269944`", ",", "2.290843471907477`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5561030419010176`", ",", "1.0385604717064978`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.36146599963325`", ",", "1.3009126781036118`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.371853347916925`", ",", "2.0276462078428064`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2640208874948087`", ",", "3.0803048565579094`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.552746826846223`", ",", "2.7077083025470845`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6070366878042064`", ",", "3.7643578177914785`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99253112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11857],

Cell["Obtain results for lists of any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
     ",", "25"}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.33333333333333333333333333333333333332`24.69897000433602", ",", 
   "4.99999999999999999999999999999999999999`24.69897000433602", ",", 
   "5.33333333333333333333333333333333333332`24.69897000433601", ",", 
   "3.66666666666666666666666666666666666666`24.69897000433602"}], 
  "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361746581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307792789],

Cell["Obtain results for weights of any precision: ", "ExampleText",
 CellID->459280447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "30"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296292495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.33333333333333333333333333333333333333`29.397940008672034", ",", 
   "4.66666666666666666666666666666666666666`29.397940008672037", ",", 
   "5.16666666666666666666666666666666666666`29.397940008672037", ",", 
   "3.5`29.397940008672037"}], "}"}]], "Output",
 ImageSize->{450, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520980992]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398387186],

Cell["Filter large datasets:", "ExampleText",
 CellID->218242787],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"ConstantArray", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"10", "^", "6"}]}], "]"}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}], ",", 
      RowBox[{"10", "^", "6"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554709021],

Cell[BoxData[
 RowBox[{
  RowBox[{"fdata", "=", 
   RowBox[{"MovingAverage", "[", 
    RowBox[{"data", ",", "100"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142717200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", "100"}], "]"}], "]"}], ",", 
     RowBox[{"fdata", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", "100"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->149620619],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9UwtM1HUcJwMOJI+TGAvEu4MOCE95ZwIJn+N5PO/9sB2w4WF4scjJRBPX
BQUCUnSEQ8IlSkQaG8VDhYaHmC0h1iD1UiBbiLyfBVZC2fp/ue2/2+c+/8/j
+/39ziMzV561ycrKSv/0+e/7/89CZJXCr11knI9kfoBN9VLy1N8LDLbD9LRn
2sBdwhw8mzMa+F7RIoOdEeOpP604RPwLkMs+Dyn7c4bB7vBNf/Kx0DTLYD5+
5ZztadzQe6LP3P/48QrpBRg/sT48ake8N1pNW+p3dlC/l1D+XNPhvmZ6fwcu
1LgW3NpEeCd63xwMZWcT9oM4ePXH36bnGBwAYdHmj0IlxAfim1HrmYOVhIPQ
rgxZiqyjvsHo7etoc1dSfgjujZmqLlSR38tYtMtIZb9G/G7k131ncbxM/CuQ
lPmrFqaI34Nq3+uHD7oQH4pcle94u5RwGCbWbq4E3aD8cASAPeZXTv1eRc0b
BucgR/Lbi7bqfG1EHukjsHq7+/kOD+IjwZlYVg8dJT2g13dyfVsZ3ghYsu+w
eBv7EMFkNXojsoDJN4qQVZoRYVtCfaKwXirzcOMRHwXNLklTp5H4aDTIXxx3
62L6GKNxRsWuuBhG/jF49ItX4YdlzPkaY6AZGflrK4/4WBywPTY1OEz6WGyx
vyzIcCP/OLiX8aLbvqX8OKzFhq9fs9D88ThkaA1rKmD8jPHYfOmPeaEz3Scx
kvlXXAYNlC9GrWGXLjCX+ASkn5s7dcme/BPQHCW/VThJ+0zEndmx4qJ58k/E
co1iNt+X+ifBiX9yh+dD2m8Sio9OWD+wJf9k8KNZ4kAnyk+G40hA5poP9U/B
M2P2etcWmj8Fwv3c80Vsmj8V194uPK3rpvxUNDQ7FKOQeAnS3T5jeeeSXoJs
veDnER3lSzGRFNf5RTDDQ4qVzKWKT1vIT4pturTfDZVMf7MUXd9XnLPtoflk
aAz/6QCvlsGQYTpl+Gwm/R+NMqxx/bXvcJk8sww+geWcu5Okl8O88PBIyRGG
hxw5Fps8sZT2JYfH/eysfXmUL0dPzNb+4wLajwIpc+MP9odTvgI+VxIj0oWU
r8Da9ifjZxwZbFbg3cYpS80Q7UcJ6Zjl69wTlK9Et6L9BzWL8pVosK4fiDKR
XomMkhShqI7OXwXnoYsOUdWkV8G1a/hY3weUr8Jwjvit7Vymr1kFUX/I1ZMi
ml8NjnBFt7ua+qvBd7p5Nf42nZca7NaZAq85ylfjy+VtDd7x1F+D83uWQr9y
IL0G6wmr/CYb0mtwvMLln/vRtD8NVur9bQfiaH9aXB/cW+q1sX8tUgWi3pZY
uo9a1CqnJj5hUb4W7y+k3XskoP77UGmZfH3x6f39F0mo6WA=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxFlA1QVFUYhq+wLggU4pKZ5g/GyIbxp6y0xM8Lwu4Ci+4fsAwjwWoMGmUt
MuAsM2yZozZKOJSKhJlErU0wRMZGuHBTA5MMC0aYYQElFKmMXYIUVMwmv9Od
uXPnue95z3vud757/Aw7Na+4cBy37dH97/O/yxGb/N7rZSOujtjHLxAu9lf0
c8Tu2Du03TV7euIxL0R1wq/SO78T+6KgN38y+TrxElwu7fX8n5/F1mfCa06P
Ea9CtUvztuI/iVejWLZh8o0RYn80zy7dKhkkXgM3Q+X9JVeIxXCM5/SFdBEH
oi5MIDl7nvgF/GYa7xB1EAejdZWxcKmNOBQxHhPW053EYdB1Z98VtRGvg3ZL
vWSmmXg9ho7sS2huJQ6HvbH87R1Ml+DjmaAp51niDdC57xEPfUscgV5BnMrG
8l9EGfeHsb6dWIrjvKDf+ANxJBqyj3nLeohfQpGfeH77MHEUzHmHnxL0EUdj
sX+osJLpMXA9EFl0e4g4Fp6dtVWDTAdOBqfMO0R+M7B6y1pTBat3HFJPLLju
Q/tnjkP/wsR1Xmy/4/HOgwhd1t+kx+NoQJPPHDG3ESuOaQO+nCV9Iz7MHGge
Y/2UgELPnmg19Zs5AbdEP40r75I/EbWRR3bVzZA/EZ/Zba4W5pchELvneOaX
4YYfX7l2AelyZL5sDAgiNsvx/b2u16I8SFfgijN/7Lwb6QrYCsvygwWkJyF8
e4mP/SHlJ2FkLCvQzvKTcej+88mpD0hPhmGiTzFF47kUXFve1eLH1peCTus5
KfteTomi/eUmiwvpSmhEDQ3fEXOpKP1ILj4zn/RUNATgq3K2/k3It0l3x3iT
vglBy/YFX32C9M2ImP08bJrpm3HxQq9B6Eu6Cl1yb5OIxkOF/TdbuvO9aLwK
jvqjz50k5lXg5/auCWHzq5GTdCF00J38ajj1qa1uVD+zGu+7xHZ8TfXi1bAi
q/4hq58GPUmLVlqpftCgZni9V9NfVE8NfKfzdtqpf3gNLNfqahex+mhRWaiM
LppH+VpUq0xNlnvk16JYHPmFhPqR18I28KRRMEn7o0N3/OXlnjQ/dGi7mrty
xR3y63D44EW5lvqR1yFE0TlaQP3IpeGX3IK8ePoepKHqzdGbNgf506C0vnpG
ROcln4ZTXLtQNEX+dHhI534+fpvy07G46YRvCf1f5nQkCr+RRNF6+XQMKEtm
P2HnZwZaS6tyPqX5kIG3Tu35sZHYnAHn8MG2DpafAcPooHCZk/x61O5oqdjF
/Hp8UHOusfgW+fWQZVVYFKPk10P/9NS7WpafiUs3LuWqH50P/wDfiPNu
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{1., 100.}, {0, 1.3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->35475807]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29081],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10758000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{"sp", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "45", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 45, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"96", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151747741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6466390],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "40", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 40, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"97", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137262975]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12907],

Cell["Smooth noisy data:", "ExampleText",
 CellID->7299883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], "+", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "20"}], "]"}]}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->595911816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4714904398798003`"}], ",", "0.6998223150394836`", ",", 
   "2.7934387784405423`", ",", "4.3540681718206775`", ",", "5.346469051304`", 
   ",", "5.2925350714850135`", ",", "8.240038147358288`", ",", 
   "9.436384730501121`", ",", "8.750135970728248`", ",", "8.231809075565645`",
    ",", "10.724638809803622`", ",", "10.284758333525918`", ",", 
   "14.907423952891191`", ",", "14.33982751290236`", ",", 
   "15.782367586721701`", ",", "16.62620892928333`", ",", 
   "15.765919172251952`", ",", "17.926986920461246`", ",", 
   "20.985040309798574`", ",", "20.021647367156596`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->943851821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"smoothed", "=", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74563834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0072568845334084`", ",", "2.615776421766901`", ",", "4.164658667188406`",
    ",", "4.997690764869897`", ",", "6.2930140900491`", ",", 
   "7.6563193164481405`", ",", "8.808852949529218`", ",", 
   "8.806109925598339`", ",", "9.235527952032506`", ",", "9.747068739631729`",
    ",", "11.972273698740244`", ",", "13.177336599773156`", ",", 
   "15.009873017505084`", ",", "15.582801342969129`", ",", 
   "16.058165229418993`", ",", "16.773038340665508`", ",", 
   "18.22598213417059`", ",", "19.644558199138803`"}], "}"}]], "Output",
 ImageSize->{549, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->633245287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37373693],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., -0.4714904398798003}, {2., 0.6998223150394836}, {3., 
     2.7934387784405423`}, {4., 4.3540681718206775`}, {5., 5.346469051304}, {
     6., 5.2925350714850135`}, {7., 8.240038147358288}, {8., 
     9.436384730501121}, {9., 8.750135970728248}, {10., 8.231809075565645}, {
     11., 10.724638809803622`}, {12., 10.284758333525918`}, {13., 
     14.907423952891191`}, {14., 14.33982751290236}, {15., 
     15.782367586721701`}, {16., 16.62620892928333}, {17., 
     15.765919172251952`}, {18., 17.926986920461246`}, {19., 
     20.985040309798574`}, {20., 20.021647367156596`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 20.}, {-0.4714904398798003, 20.985040309798574`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->176325943]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "smoothed", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->163379734],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.0072568845334084`}, {2., 2.615776421766901}, {3., 
     4.164658667188406}, {4., 4.997690764869897}, {5., 6.2930140900491}, {6., 
     7.6563193164481405`}, {7., 8.808852949529218}, {8., 8.806109925598339}, {
     9., 9.235527952032506}, {10., 9.747068739631729}, {11., 
     11.972273698740244`}, {12., 13.177336599773156`}, {13., 
     15.009873017505084`}, {14., 15.582801342969129`}, {15., 
     16.058165229418993`}, {16., 16.773038340665508`}, {17., 
     18.22598213417059}, {18., 19.644558199138803`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 18.}, {0., 19.644558199138803`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->207796772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->779737576],

Cell["\<\
Compute the 100-day moving average of a financial time series:\
\>", "ExampleText",
 CellID->100557842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{
    RowBox[{"FinancialData", "[", 
     RowBox[{
     "\"\<GE\>\"", ",", "\"\<Jan. 1, 2000\>\"", ",", "\"\<Value\>\""}], "]"}],
     ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149127020],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147206555]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19551],

Cell["A moving average is a sequence of means:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->331423122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99227007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c", "+", "d"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "d", "+", "e"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "+", "e", "+", "f"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{350, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->613292229]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mean", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "+", "2"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527641572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c", "+", "d"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "d", "+", "e"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "+", "e", "+", "f"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{350, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84766289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252744176],

Cell[TextData[{
 "A two\[Hyphen]term ",
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 " is equivalent to a two\[Hyphen]term ",
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24718506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544020951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.430260458957948`", ",", "7.294306828738333`", ",", "2.8014367308527066`",
    ",", "6.937681754243985`", ",", "8.670429883682138`", ",", 
   "4.40538298322495`", ",", "1.828957760170269`", ",", "9.169155310697272`", 
   ",", "5.040301633516629`", ",", "3.937172501231232`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19524636]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", "2"}], "]"}], "\[Equal]", 
  RowBox[{"MovingMedian", "[", 
   RowBox[{"data", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46558435],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63040446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10615],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]term moving average is equivalent to a moving average with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " equal weights:"
}], "ExampleText",
 CellID->685553467],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", "10"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73156436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", "3"}], "]"}], "\[Equal]", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592569850],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->296821393]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", "3"}], "]"}], "\[Equal]", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30770209],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137563356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447953604],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]term moving average is equivalent to a ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12202579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157607688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.877481381765492`", ",", "5.465891767486384`", ",", "0.6610244048875225`",
    ",", "5.4398499423441145`", ",", "7.5233500468453425`", ",", 
   "0.6564692342297551`", ",", "9.052470290691454`", ",", 
   "4.717046670111513`", ",", "7.266121472246196`", ",", 
   "6.94434835699389`"}], "}"}]], "Output",
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275394646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", "4"}], "]"}], "\[Equal]", 
  RowBox[{"ListCorrelate", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"1", "/", "4"}], ",", 
      RowBox[{"{", "4", "}"}]}], "]"}], ",", "data"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343281550],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21574852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35147579],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]term weighted moving average is equivalent to a ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->43284639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568165368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.0083130502020317`", ",", "0.7373685084939674`", ",", 
   "7.903045076991941`", ",", "3.5361194689465236`", ",", "2.04850766104969`",
    ",", "3.442372467521746`", ",", "3.7261634739535365`", ",", 
   "9.865316959925208`", ",", "5.388912695221995`", ",", 
   "5.570368821367322`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5092048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"ListCorrelate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "/", 
     RowBox[{"Total", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}]}], ",", "data"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436375989],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99746870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739256280],

Cell["\<\
Multiplying weights by a constant gives the same moving average:\
\>", "ExampleText",
 CellID->198021901],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", "10"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165946157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "2000", ",", "3000"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231276693],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136479525]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18944],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingMedian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExponentialMovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentialMovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1278],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "Tutorials",
 CellID->20416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MovingAverage",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MovingAverage"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->84815914],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->464968],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->61923914],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->234680266],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->306359327],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->100682323],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->407540732],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->709709581],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->206707219]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MovingAverage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 10.4494830}", "context" -> "System`", 
    "keywords" -> {
     "data filter", "data filtering", "data smoother", "data smoothing", 
      "filter taps", "finite impulse response filter", "FIR filter", 
      "linear moving average", "MA", "moving mean", "simple moving average", 
      "SMA", "weighted moving average", "WMA"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MovingAverage[list, r] gives the moving average of list, computed by \
averaging runs of r elements. MovingAverage[list, {w_1, w_2, ..., w_r}] gives \
the moving average of list, computed with weights w_i.", 
    "synonyms" -> {"moving average"}, "title" -> "MovingAverage", "type" -> 
    "Symbol", "uri" -> "ref/MovingAverage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10651, 324, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->459241430]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52487, 1753}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3716, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4339, 107, 1578, 37, 70, "ObjectNameGrid"],
Cell[5920, 146, 1659, 53, 70, "Usage",
 CellID->27277]
}, Open  ]],
Cell[CellGroupData[{
Cell[7616, 204, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8094, 221, 588, 21, 70, "Notes",
 CellID->24023],
Cell[8685, 244, 817, 30, 70, "Notes",
 CellID->2788332],
Cell[9505, 276, 223, 7, 70, "Notes",
 CellID->787242721],
Cell[9731, 285, 434, 16, 70, "Notes",
 CellID->25709],
Cell[10168, 303, 446, 16, 70, "Notes",
 CellID->18986194]
}, Closed]],
Cell[CellGroupData[{
Cell[10651, 324, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459241430],
Cell[CellGroupData[{
Cell[11036, 338, 148, 5, 70, "ExampleSection",
 CellID->306850804],
Cell[11187, 345, 84, 1, 70, "ExampleText",
 CellID->207735283],
Cell[CellGroupData[{
Cell[11296, 350, 214, 7, 28, "Input",
 CellID->230914973],
Cell[11513, 359, 412, 15, 51, "Output",
 CellID->105959448]
}, Open  ]],
Cell[11940, 377, 125, 3, 70, "ExampleDelimiter",
 CellID->348971872],
Cell[12068, 382, 76, 1, 70, "ExampleText",
 CellID->189707948],
Cell[CellGroupData[{
Cell[12169, 387, 260, 8, 70, "Input",
 CellID->412882448],
Cell[12432, 397, 608, 23, 51, "Output",
 CellID->237834412]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13089, 426, 215, 7, 70, "ExampleSection",
 CellID->7966],
Cell[13307, 435, 80, 1, 70, "ExampleText",
 CellID->16129],
Cell[CellGroupData[{
Cell[13412, 440, 221, 7, 70, "Input",
 CellID->17137],
Cell[13636, 449, 293, 10, 51, "Output",
 CellID->363624225]
}, Open  ]],
Cell[13944, 462, 98, 1, 70, "ExampleText",
 CellID->587699784],
Cell[CellGroupData[{
Cell[14067, 467, 242, 8, 70, "Input",
 CellID->80080504],
Cell[14312, 477, 287, 9, 36, "Output",
 CellID->228515084]
}, Open  ]],
Cell[14614, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->722951932],
Cell[14742, 494, 84, 1, 70, "ExampleText",
 CellID->14559980],
Cell[CellGroupData[{
Cell[14851, 499, 208, 7, 70, "Input",
 CellID->357143563],
Cell[15062, 508, 1127, 28, 71, "Output",
 CellID->19537340]
}, Open  ]],
Cell[CellGroupData[{
Cell[16226, 541, 135, 4, 70, "Input",
 CellID->452249129],
Cell[16364, 547, 845, 22, 54, "Output",
 CellID->248752310]
}, Open  ]],
Cell[CellGroupData[{
Cell[17246, 574, 308, 10, 70, "Input",
 CellID->652462847],
Cell[17557, 586, 846, 22, 54, "Output",
 CellID->99253112]
}, Open  ]],
Cell[18418, 611, 121, 3, 70, "ExampleDelimiter",
 CellID->11857],
Cell[18542, 616, 86, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[18653, 621, 286, 9, 70, "Input",
 CellID->190699768],
Cell[18942, 632, 470, 12, 54, "Output",
 CellID->361746581]
}, Open  ]],
Cell[19427, 647, 125, 3, 70, "ExampleDelimiter",
 CellID->307792789],
Cell[19555, 652, 88, 1, 70, "ExampleText",
 CellID->459280447],
Cell[CellGroupData[{
Cell[19668, 657, 346, 12, 70, "Input",
 CellID->296292495],
Cell[20017, 671, 434, 11, 54, "Output",
 CellID->520980992]
}, Open  ]],
Cell[20466, 685, 125, 3, 70, "ExampleDelimiter",
 CellID->398387186],
Cell[20594, 690, 65, 1, 70, "ExampleText",
 CellID->218242787],
Cell[20662, 693, 410, 14, 70, "Input",
 CellID->554709021],
Cell[21075, 709, 185, 6, 70, "Input",
 CellID->142717200],
Cell[CellGroupData[{
Cell[21285, 719, 456, 15, 70, "Input",
 CellID->149620619],
Cell[21744, 736, 3241, 61, 136, "Output",
 CellID->35475807]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25034, 803, 239, 7, 70, "ExampleSection",
 CellID->29081],
Cell[25276, 812, 259, 9, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[25560, 825, 570, 19, 70, "Input",
 CellID->19878761],
Cell[26133, 846, 483, 17, 36, "Output",
 CellID->10758000]
}, Open  ]],
Cell[CellGroupData[{
Cell[26653, 868, 133, 4, 70, "Input",
 CellID->235263230],
Cell[26789, 874, 483, 17, 36, "Output",
 CellID->151747741]
}, Open  ]],
Cell[CellGroupData[{
Cell[27309, 896, 200, 6, 70, "Input",
 CellID->6466390],
Cell[27512, 904, 483, 17, 36, "Output",
 CellID->137262975]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28044, 927, 223, 7, 70, "ExampleSection",
 CellID->12907],
Cell[28270, 936, 59, 1, 70, "ExampleText",
 CellID->7299883],
Cell[CellGroupData[{
Cell[28354, 941, 294, 11, 70, "Input",
 CellID->595911816],
Cell[28651, 954, 785, 16, 71, "Output",
 CellID->943851821]
}, Open  ]],
Cell[CellGroupData[{
Cell[29473, 975, 165, 5, 70, "Input",
 CellID->74563834],
Cell[29641, 982, 708, 15, 54, "Output",
 CellID->633245287]
}, Open  ]],
Cell[CellGroupData[{
Cell[30386, 1002, 106, 3, 70, "Input",
 CellID->37373693],
Cell[30495, 1007, 1037, 23, 137, "Output",
 CellID->176325943]
}, Open  ]],
Cell[CellGroupData[{
Cell[31569, 1035, 111, 3, 70, "Input",
 CellID->163379734],
Cell[31683, 1040, 956, 22, 145, "Output",
 CellID->207796772]
}, Open  ]],
Cell[32654, 1065, 125, 3, 70, "ExampleDelimiter",
 CellID->779737576],
Cell[32782, 1070, 113, 3, 70, "ExampleText",
 CellID->100557842],
Cell[CellGroupData[{
Cell[32920, 1077, 303, 9, 70, "Input",
 CellID->149127020],
Cell[33226, 1088, 2795, 50, 70, "Output",
 Evaluatable->False,
 CellID->147206555]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36070, 1144, 233, 7, 70, "ExampleSection",
 CellID->19551],
Cell[36306, 1153, 131, 2, 70, "ExampleText",
 CellID->331423122],
Cell[CellGroupData[{
Cell[36462, 1159, 224, 7, 70, "Input",
 CellID->99227007],
Cell[36689, 1168, 656, 23, 51, "Output",
 CellID->613292229]
}, Open  ]],
Cell[CellGroupData[{
Cell[37382, 1196, 450, 15, 70, "Input",
 CellID->527641572],
Cell[37835, 1213, 655, 23, 51, "Output",
 CellID->84766289]
}, Open  ]],
Cell[38505, 1239, 125, 3, 70, "ExampleDelimiter",
 CellID->252744176],
Cell[38633, 1244, 380, 13, 70, "ExampleText",
 CellID->24718506],
Cell[CellGroupData[{
Cell[39038, 1261, 158, 5, 70, "Input",
 CellID->544020951],
Cell[39199, 1268, 468, 11, 54, "Output",
 CellID->19524636]
}, Open  ]],
Cell[CellGroupData[{
Cell[39704, 1284, 231, 7, 70, "Input",
 CellID->46558435],
Cell[39938, 1293, 160, 5, 36, "Output",
 CellID->63040446]
}, Open  ]],
Cell[40113, 1301, 121, 3, 70, "ExampleDelimiter",
 CellID->10615],
Cell[40237, 1306, 268, 9, 70, "ExampleText",
 CellID->685553467],
Cell[40508, 1317, 177, 6, 70, "Input",
 CellID->73156436],
Cell[CellGroupData[{
Cell[40710, 1327, 294, 9, 70, "Input",
 CellID->592569850],
Cell[41007, 1338, 161, 5, 36, "Output",
 CellID->296821393]
}, Open  ]],
Cell[CellGroupData[{
Cell[41205, 1348, 299, 9, 70, "Input",
 CellID->30770209],
Cell[41507, 1359, 161, 5, 36, "Output",
 CellID->137563356]
}, Open  ]],
Cell[41683, 1367, 125, 3, 70, "ExampleDelimiter",
 CellID->447953604],
Cell[41811, 1372, 305, 11, 70, "ExampleText",
 CellID->12202579],
Cell[CellGroupData[{
Cell[42141, 1387, 158, 5, 70, "Input",
 CellID->157607688],
Cell[42302, 1394, 476, 12, 54, "Output",
 CellID->275394646]
}, Open  ]],
Cell[CellGroupData[{
Cell[42815, 1411, 347, 11, 70, "Input",
 CellID->343281550],
Cell[43165, 1424, 160, 5, 36, "Output",
 CellID->21574852]
}, Open  ]],
Cell[43340, 1432, 124, 3, 70, "ExampleDelimiter",
 CellID->35147579],
Cell[43467, 1437, 362, 12, 70, "ExampleText",
 CellID->43284639],
Cell[CellGroupData[{
Cell[43854, 1453, 158, 5, 70, "Input",
 CellID->568165368],
Cell[44015, 1460, 474, 12, 54, "Output",
 CellID->5092048]
}, Open  ]],
Cell[CellGroupData[{
Cell[44526, 1477, 456, 16, 70, "Input",
 CellID->436375989],
Cell[44985, 1495, 160, 5, 36, "Output",
 CellID->99746870]
}, Open  ]],
Cell[45160, 1503, 125, 3, 70, "ExampleDelimiter",
 CellID->739256280],
Cell[45288, 1508, 115, 3, 70, "ExampleText",
 CellID->198021901],
Cell[45406, 1513, 178, 6, 70, "Input",
 CellID->165946157],
Cell[CellGroupData[{
Cell[45609, 1523, 364, 11, 70, "Input",
 CellID->231276693],
Cell[45976, 1536, 161, 5, 36, "Output",
 CellID->136479525]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46198, 1548, 311, 9, 70, "SeeAlsoSection",
 CellID->18944],
Cell[46512, 1559, 1478, 53, 70, "SeeAlso",
 CellID->9009]
}, Open  ]],
Cell[CellGroupData[{
Cell[48027, 1617, 313, 9, 70, "TutorialsSection",
 CellID->1278],
Cell[48343, 1628, 167, 3, 70, "Tutorials",
 CellID->20416]
}, Open  ]],
Cell[CellGroupData[{
Cell[48547, 1636, 305, 8, 70, "RelatedLinksSection"],
Cell[48855, 1646, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49263, 1663, 299, 8, 70, "MoreAboutSection"],
Cell[49565, 1673, 166, 3, 70, "MoreAbout",
 CellID->84815914],
Cell[49734, 1678, 152, 3, 70, "MoreAbout",
 CellID->464968],
Cell[49889, 1683, 138, 3, 70, "MoreAbout",
 CellID->61923914],
Cell[50030, 1688, 145, 3, 70, "MoreAbout",
 CellID->234680266],
Cell[50178, 1693, 132, 3, 70, "MoreAbout",
 CellID->306359327],
Cell[50313, 1698, 185, 3, 70, "MoreAbout",
 CellID->100682323],
Cell[50501, 1703, 179, 3, 70, "MoreAbout",
 CellID->407540732],
Cell[50683, 1708, 175, 3, 70, "MoreAbout",
 CellID->709709581],
Cell[50861, 1713, 151, 3, 70, "MoreAbout",
 CellID->206707219]
}, Open  ]],
Cell[51027, 1719, 27, 0, 70, "History"],
Cell[51057, 1721, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

