(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39659,       1365]
NotebookOptionsPosition[     32299,       1106]
NotebookOutlinePosition[     33613,       1143]
CellTagsIndexPosition[     33527,       1138]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/MovingAverage"], "Median" :> 
          Documentation`HelpLookup["paclet:ref/Median"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MovingAverage\"\>", 
       2->"\<\"Median\"\>", 3->"\<\"Partition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Statistics" :> 
          Documentation`HelpLookup["paclet:guide/Statistics"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Data Transforms and Smoothing\"\>", 2->"\<\"Statistics\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       4->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       5->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MovingMedian", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MovingMedian",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MovingMedian"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the moving median of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ", computed using spans of ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " elements."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 " gives a list of the medians of elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " taken in blocks of length ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->331423122,
  ButtonNote->"331423122"]
}], "Notes",
 CellID->24023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 " gives a list of length ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}], "-", 
   StyleBox["r", "TI"], "+", "1"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->141351230],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->625271644,
  ButtonNote->"625271644"]
}], "Notes",
 CellID->18986194]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641012719],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->344182904],

Cell["Moving median of a vector:", "ExampleText",
 CellID->36551312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5", ",", "6", ",", "1", ",", "4", ",", "3"}],
     "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167889794],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "5", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450818793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348971872],

Cell["Moving median of a matrix:", "ExampleText",
 CellID->189707948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412882448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     FractionBox["5", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     FractionBox["7", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     FractionBox["7", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123113750]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12891],

Cell["Compute moving medians for any numeric data:", "ExampleText",
 CellID->153144611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "E", ",", 
     RowBox[{"Sqrt", "[", "Pi", "]"}], ",", "2", ",", "10", ",", 
     RowBox[{"E", "^", "2"}]}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149389612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["\[Pi]"], ",", "2", ",", "2", ",", 
   SuperscriptBox["\[ExponentialE]", "2"]}], "}"}]], "Output",
 ImageSize->{103, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149118420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295248089],

Cell["Obtain results at machine precision:", "ExampleText",
 CellID->16600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
    "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.`", ",", "5.`", ",", "6.`", ",", "3.`"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11985874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11857],

Cell["Obtain results for lists of any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
     ",", "25"}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.`25.", ",", "5.`25.", ",", "6.`25.", ",", "3.`25."}], 
  "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24314467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->722951932],

Cell["Moving medians of matrices are matrices: ", "ExampleText",
 CellID->14559980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357143563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.572623361002236`", ",", "1.1833330352633975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0452742308489007`", ",", "4.666486347539926`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9637850288294703`", ",", "3.7213901596359102`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.394537384480709`", ",", "1.5567703237361874`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.459972159987813`", ",", "1.4350827269471356`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.32399395128404`", ",", "1.814402734396623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2417645628601826`", ",", "0.09308868648898128`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"4.256325188460495`", ",", "0.5270681083652717`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9809323850265381`", ",", "1.044409943232919`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9498226685200537`", ",", "3.725609178231266`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{552, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380270461]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{"data", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452249129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.6791612066550896`", ",", "2.639080241686049`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6791612066550896`", ",", "2.639080241686049`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.927254772234261`", ",", "1.6855865290664052`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.927254772234261`", ",", "1.4959265253416616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8581486742241538`", ",", "0.9810754176562037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1186287867435163`", ",", "0.7857390257990954`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9653775267732958`", ",", "0.7857390257990954`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{545, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307910454]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30369],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[RuleDelayed]", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "<", "i"}]}], "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j"}], ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "955", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 955, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271605881]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{"sp", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "932", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 932, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"96", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201050290]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13776],

Cell["Smooth noisy data:", "ExampleText",
 CellID->7299883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], "+", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "20"}], "]"}]}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->595911816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.4855405428965698`", ",", "3.0105957162906964`", ",", 
   "2.1219200691079605`", ",", "4.261842393600124`", ",", "5.16711570760095`",
    ",", "5.126088970482162`", ",", "8.731971631132595`", ",", 
   "6.010445224870372`", ",", "9.517874161405881`", ",", "9.814053449199339`",
    ",", "10.841962248482549`", ",", "10.424103422597401`", ",", 
   "11.604499479169139`", ",", "14.30482945292995`", ",", 
   "16.633582832899833`", ",", "14.159448943441925`", ",", 
   "17.868766923574274`", ",", "17.01266842138447`", ",", 
   "18.122481280672808`", ",", "21.782775618819286`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2805810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"smoothed", "=", 
  RowBox[{"MovingMedian", "[", 
   RowBox[{"data", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74563834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.0105957162906964`", ",", "4.261842393600124`", ",", "5.126088970482162`",
    ",", "5.16711570760095`", ",", "6.010445224870372`", ",", 
   "8.731971631132595`", ",", "9.517874161405881`", ",", "9.814053449199339`",
    ",", "10.424103422597401`", ",", "10.841962248482549`", ",", 
   "11.604499479169139`", ",", "14.159448943441925`", ",", 
   "14.30482945292995`", ",", "16.633582832899833`", ",", 
   "17.01266842138447`", ",", "17.868766923574274`"}], "}"}]], "Output",
 ImageSize->{482, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650141825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37373693],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.4855405428965698`}, {2., 3.0105957162906964`}, {3., 
     2.1219200691079605`}, {4., 4.261842393600124}, {5., 5.16711570760095}, {
     6., 5.126088970482162}, {7., 8.731971631132595}, {8., 
     6.010445224870372}, {9., 9.517874161405881}, {10., 9.814053449199339}, {
     11., 10.841962248482549`}, {12., 10.424103422597401`}, {13., 
     11.604499479169139`}, {14., 14.30482945292995}, {15., 
     16.633582832899833`}, {16., 14.159448943441925`}, {17., 
     17.868766923574274`}, {18., 17.01266842138447}, {19., 
     18.122481280672808`}, {20., 21.782775618819286`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 21.782775618819286`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->369020372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "smoothed", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->163379734],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 3.0105957162906964`}, {2., 4.261842393600124}, {3., 
     5.126088970482162}, {4., 5.16711570760095}, {5., 6.010445224870372}, {6.,
      8.731971631132595}, {7., 9.517874161405881}, {8., 9.814053449199339}, {
     9., 10.424103422597401`}, {10., 10.841962248482549`}, {11., 
     11.604499479169139`}, {12., 14.159448943441925`}, {13., 
     14.30482945292995}, {14., 16.633582832899833`}, {15., 
     17.01266842138447}, {16., 17.868766923574274`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 4.},
  PlotRange->{{0., 16.}, {3.0105957162906964`, 17.868766923574274`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->65871370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->779737576],

Cell["\<\
Compute the 100-day moving median of a financial time series:\
\>", "ExampleText",
 CellID->100557842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"MovingMedian", "[", 
   RowBox[{
    RowBox[{"FinancialData", "[", 
     RowBox[{
     "\"\<GE\>\"", ",", "\"\<Jan. 1, 2000\>\"", ",", "\"\<Value\>\""}], "]"}],
     ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149127020],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->643205056]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32212],

Cell["A moving median is a sequence of medians:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->331423122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "5", ",", "2", ",", "2", ",", "4", ",", "10", ",", 
     "5"}], "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99227007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "2"], ",", 
   FractionBox["5", "2"], ",", "3", ",", "3", ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{111, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65807148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1", ",", "3", ",", "5", ",", "2", ",", "2", ",", "4", ",", "10", ",", 
        "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "+", "3"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527641572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "2"], ",", 
   FractionBox["5", "2"], ",", "3", ",", "3", ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{111, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->300224510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252744176],

Cell[TextData[{
 "A two\[Hyphen]term ",
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 " is equivalent to a two\[Hyphen]term ",
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24718506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544020951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.569937411652139`", ",", "1.2002992242714772`", ",", "6.064805162481446`",
    ",", "6.314434194340248`", ",", "4.908112551511039`", ",", 
   "9.566361650914601`", ",", "6.864747844545851`", ",", "6.810429083558147`",
    ",", "6.040842275148746`", ",", "5.306381611404076`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91534611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingMedian", "[", 
   RowBox[{"data", ",", "2"}], "]"}], "\[Equal]", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"data", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46558435],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271213417]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 " requires numeric values:"
}], "ExampleText",
 CellID->9090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9034],

Cell[BoxData[
 RowBox[{
  RowBox[{"MovingMedian", "::", "\<\"arg1\"\>"}], ":", 
  " ", "\<\"The first argument \\!\\({a, b, c}\\) must be a vector or matrix \
of real values.\"\>"}]], "Message", "MSG",
 CellID->67228651],

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466400723]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12517],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MovingMedian",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MovingMedian"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->208254188],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->58410176],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->330823101],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->46791604],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->171725434]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MovingMedian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 11.2776292}", "context" -> "System`", 
    "keywords" -> {
     "data filter", "data filtering", "data smoother", "data smoothing"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MovingMedian[list, r] gives the moving median of list, computed using \
spans of r elements.", "synonyms" -> {"moving median"}, "title" -> 
    "MovingMedian", "type" -> "Symbol", "uri" -> "ref/MovingMedian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6938, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->641012719]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33384, 1131}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 73, 1577, 37, 70, "ObjectNameGrid"],
Cell[4278, 112, 727, 23, 70, "Usage",
 CellID->579]
}, Open  ]],
Cell[CellGroupData[{
Cell[5042, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5520, 157, 495, 17, 70, "Notes",
 CellID->24023],
Cell[6018, 176, 436, 16, 70, "Notes",
 CellID->141351230],
Cell[6457, 194, 444, 16, 70, "Notes",
 CellID->18986194]
}, Closed]],
Cell[CellGroupData[{
Cell[6938, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641012719],
Cell[CellGroupData[{
Cell[7323, 229, 148, 5, 70, "ExampleSection",
 CellID->344182904],
Cell[7474, 236, 68, 1, 70, "ExampleText",
 CellID->36551312],
Cell[CellGroupData[{
Cell[7567, 241, 235, 7, 28, "Input",
 CellID->167889794],
Cell[7805, 250, 233, 7, 36, "Output",
 CellID->450818793]
}, Open  ]],
Cell[8053, 260, 125, 3, 70, "ExampleDelimiter",
 CellID->348971872],
Cell[8181, 265, 69, 1, 70, "ExampleText",
 CellID->189707948],
Cell[CellGroupData[{
Cell[8275, 270, 475, 16, 70, "Input",
 CellID->412882448],
Cell[8753, 288, 492, 18, 51, "Output",
 CellID->123113750]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9294, 312, 216, 7, 70, "ExampleSection",
 CellID->12891],
Cell[9513, 321, 87, 1, 70, "ExampleText",
 CellID->153144611],
Cell[CellGroupData[{
Cell[9625, 326, 282, 8, 70, "Input",
 CellID->149389612],
Cell[9910, 336, 280, 9, 43, "Output",
 CellID->149118420]
}, Open  ]],
Cell[10205, 348, 125, 3, 70, "ExampleDelimiter",
 CellID->295248089],
Cell[10333, 353, 75, 1, 70, "ExampleText",
 CellID->16600],
Cell[CellGroupData[{
Cell[10433, 358, 252, 8, 70, "Input",
 CellID->31864],
Cell[10688, 368, 231, 7, 36, "Output",
 CellID->11985874]
}, Open  ]],
Cell[10934, 378, 121, 3, 70, "ExampleDelimiter",
 CellID->11857],
Cell[11058, 383, 86, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[11169, 388, 285, 9, 70, "Input",
 CellID->190699768],
Cell[11457, 399, 246, 8, 54, "Output",
 CellID->24314467]
}, Open  ]],
Cell[11718, 410, 125, 3, 70, "ExampleDelimiter",
 CellID->722951932],
Cell[11846, 415, 83, 1, 70, "ExampleText",
 CellID->14559980],
Cell[CellGroupData[{
Cell[11954, 420, 208, 7, 70, "Input",
 CellID->357143563],
Cell[12165, 429, 1132, 29, 71, "Output",
 CellID->380270461]
}, Open  ]],
Cell[CellGroupData[{
Cell[13334, 463, 134, 4, 70, "Input",
 CellID->452249129],
Cell[13471, 469, 848, 22, 54, "Output",
 CellID->307910454]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14368, 497, 239, 7, 70, "ExampleSection",
 CellID->30369],
Cell[14610, 506, 259, 9, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[14894, 519, 574, 19, 70, "Input",
 CellID->19878761],
Cell[15471, 540, 486, 17, 36, "Output",
 CellID->271605881]
}, Open  ]],
Cell[CellGroupData[{
Cell[15994, 562, 132, 4, 70, "Input",
 CellID->235263230],
Cell[16129, 568, 485, 17, 36, "Output",
 CellID->201050290]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16663, 591, 223, 7, 70, "ExampleSection",
 CellID->13776],
Cell[16889, 600, 59, 1, 70, "ExampleText",
 CellID->7299883],
Cell[CellGroupData[{
Cell[16973, 605, 294, 11, 70, "Input",
 CellID->595911816],
Cell[17270, 618, 767, 16, 71, "Output",
 CellID->2805810]
}, Open  ]],
Cell[CellGroupData[{
Cell[18074, 639, 164, 5, 70, "Input",
 CellID->74563834],
Cell[18241, 646, 649, 14, 54, "Output",
 CellID->650141825]
}, Open  ]],
Cell[CellGroupData[{
Cell[18927, 665, 106, 3, 70, "Input",
 CellID->37373693],
Cell[19036, 670, 1041, 24, 139, "Output",
 CellID->369020372]
}, Open  ]],
Cell[CellGroupData[{
Cell[20114, 699, 111, 3, 70, "Input",
 CellID->163379734],
Cell[20228, 704, 934, 22, 138, "Output",
 CellID->65871370]
}, Open  ]],
Cell[21177, 729, 125, 3, 70, "ExampleDelimiter",
 CellID->779737576],
Cell[21305, 734, 112, 3, 70, "ExampleText",
 CellID->100557842],
Cell[CellGroupData[{
Cell[21442, 741, 302, 9, 70, "Input",
 CellID->149127020],
Cell[21747, 752, 2909, 52, 70, "Output",
 Evaluatable->False,
 CellID->643205056]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24705, 810, 233, 7, 70, "ExampleSection",
 CellID->32212],
Cell[24941, 819, 132, 2, 70, "ExampleText",
 CellID->331423122],
Cell[CellGroupData[{
Cell[25098, 825, 251, 8, 70, "Input",
 CellID->99227007],
Cell[25352, 835, 299, 10, 51, "Output",
 CellID->65807148]
}, Open  ]],
Cell[CellGroupData[{
Cell[25688, 850, 483, 16, 70, "Input",
 CellID->527641572],
Cell[26174, 868, 300, 10, 51, "Output",
 CellID->300224510]
}, Open  ]],
Cell[26489, 881, 125, 3, 70, "ExampleDelimiter",
 CellID->252744176],
Cell[26617, 886, 380, 13, 70, "ExampleText",
 CellID->24718506],
Cell[CellGroupData[{
Cell[27022, 903, 158, 5, 70, "Input",
 CellID->544020951],
Cell[27183, 910, 469, 11, 54, "Output",
 CellID->91534611]
}, Open  ]],
Cell[CellGroupData[{
Cell[27689, 926, 231, 7, 70, "Input",
 CellID->46558435],
Cell[27923, 935, 161, 5, 36, "Output",
 CellID->271213417]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28133, 946, 226, 7, 70, "ExampleSection",
 CellID->10991],
Cell[28362, 955, 205, 7, 70, "ExampleText",
 CellID->9090],
Cell[CellGroupData[{
Cell[28592, 966, 185, 6, 70, "Input",
 CellID->9034],
Cell[28780, 974, 220, 5, 70, "Message",
 CellID->67228651],
Cell[29003, 981, 279, 9, 36, "Output",
 CellID->466400723]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29343, 997, 311, 9, 70, "SeeAlsoSection",
 CellID->12517],
Cell[29657, 1008, 703, 26, 70, "SeeAlso",
 CellID->9009]
}, Open  ]],
Cell[CellGroupData[{
Cell[30397, 1039, 305, 8, 70, "RelatedLinksSection"],
Cell[30705, 1049, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31111, 1066, 299, 8, 70, "MoreAboutSection"],
Cell[31413, 1076, 167, 3, 70, "MoreAbout",
 CellID->208254188],
Cell[31583, 1081, 131, 3, 70, "MoreAbout",
 CellID->58410176],
Cell[31717, 1086, 179, 3, 70, "MoreAbout",
 CellID->330823101],
Cell[31899, 1091, 174, 3, 70, "MoreAbout",
 CellID->46791604],
Cell[32076, 1096, 151, 3, 70, "MoreAbout",
 CellID->171725434]
}, Open  ]],
Cell[32242, 1102, 27, 0, 70, "History"],
Cell[32272, 1104, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

