(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43172,       1187]
NotebookOptionsPosition[     38776,       1043]
NotebookOutlinePosition[     40121,       1081]
CellTagsIndexPosition[     40035,       1076]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>", 
       3->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelfLoopStyle" :> 
          Documentation`HelpLookup["paclet:ref/SelfLoopStyle"], 
          "EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SelfLoopStyle\"\>", 
       2->"\<\"EdgeRenderingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MultiedgeStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MultiedgeStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which specifies how to draw multiple edges."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->99769023],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "draw multiple edges for graphs given by explicit rules", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "always draw multiple edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "never draw multiple edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["\[Delta]", "TR"], Cell[TextData[{
     "spread multiple edges by scaled distance ",
     Cell[BoxData[
      StyleBox["\[Delta]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->265287133],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"MultiedgeStyle", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are not drawn for graphs specified by adjacency matrices."
}], "Notes",
 CellID->691530915]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30514158],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->97869304],

Cell["Draw multiple edges:", "ExampleText",
 CellID->1704158010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->777512491],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7388289718852955, 0.8027437456625879}, {
    1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
    1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
    0.}, {0.8456160123620551, 0.7885107997890654}, {0.8741410637916219, 
    0.7841996306751271}, {0.9024978014720523, 0.7788930153403147}, {
    0.9306514979945546, 0.7725974525928516}, {0.9585676746070542, 
    0.7653206523669188}, {0.9862121434389982, 0.7570715262805943}, {
    1.0135510493699291`, 0.7478601767221357}, {1.040550911490552, 
    0.7376978844779735}, {1.417909998289886, 0.5880768884319323}, {
    1.4445377509048538`, 0.5769760988715235}, {1.4707607840270558`, 
    0.5649504067059845}, {1.4965469833138176`, 0.5520145393391704}, {
    1.5218647693961054`, 0.5381843388315888}, {1.546683136552567, 
    0.5234767424992347}, {1.5709716906810494`, 0.5079097621711113}, {
    1.5947006865210902`, 0.4915024621308322}, {0.8263549742478375, 
    0.7399325390792401}, {0.8500839700878781, 0.7235252390389609}, {
    0.8743725242163607, 0.7079582587108374}, {0.8991908913728223, 
    0.6932506623784835}, {0.9245086774551102, 0.6794204618709017}, {
    0.9502948767418721, 0.6664845945040878}, {0.9765179098640739, 
    0.6544589023385488}, {1.0031456624790418`, 0.6433581127781399}, {
    1.3805047492783755`, 0.49373711673209864`}, {1.4075046113989986`, 
    0.48357482448793654`}, {1.4348435173299294`, 0.47436347492947784`}, {
    1.4624879861618734`, 0.46611434884315345`}, {1.4904041627743732`, 
    0.45883754861722054`}, {1.5185578592968754`, 0.45254198586975763`}, {
    1.5469145969773057`, 0.44723537053494505`}, {1.5754396484068727`, 
    0.44292420142100686`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
         2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
        37, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
     1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
     1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1541259790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355164303],

Cell["\<\
Draw multiple edges for a graph specified by its adjacency matrix:\
\>", "ExampleText",
 CellID->591791095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2062836331],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7388289718852955, 0.8027437456625879}, {
    1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
    1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
    0.}, {0.8456160123620551, 0.7885107997890654}, {0.8741410637916219, 
    0.7841996306751271}, {0.9024978014720523, 0.7788930153403147}, {
    0.9306514979945546, 0.7725974525928516}, {0.9585676746070542, 
    0.7653206523669188}, {0.9862121434389982, 0.7570715262805943}, {
    1.0135510493699291`, 0.7478601767221357}, {1.040550911490552, 
    0.7376978844779735}, {1.417909998289886, 0.5880768884319323}, {
    1.4445377509048538`, 0.5769760988715235}, {1.4707607840270558`, 
    0.5649504067059845}, {1.4965469833138176`, 0.5520145393391704}, {
    1.5218647693961054`, 0.5381843388315888}, {1.546683136552567, 
    0.5234767424992347}, {1.5709716906810494`, 0.5079097621711113}, {
    1.5947006865210902`, 0.4915024621308322}, {0.8263549742478375, 
    0.7399325390792401}, {0.8500839700878781, 0.7235252390389609}, {
    0.8743725242163607, 0.7079582587108374}, {0.8991908913728223, 
    0.6932506623784835}, {0.9245086774551102, 0.6794204618709017}, {
    0.9502948767418721, 0.6664845945040878}, {0.9765179098640739, 
    0.6544589023385488}, {1.0031456624790418`, 0.6433581127781399}, {
    1.3805047492783755`, 0.49373711673209864`}, {1.4075046113989986`, 
    0.48357482448793654`}, {1.4348435173299294`, 0.47436347492947784`}, {
    1.4624879861618734`, 0.46611434884315345`}, {1.4904041627743732`, 
    0.45883754861722054`}, {1.5185578592968754`, 0.45254198586975763`}, {
    1.5469145969773057`, 0.44723537053494505`}, {1.5754396484068727`, 
    0.44292420142100686`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
         2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
        37, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
     1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
     1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->850648330]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Spread multiple edges by a specified scaled distance:", "ExampleText",
 CellID->2139252208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "5"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}]}], "}"}], ",", 
     RowBox[{"MultiedgeStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5."}], ",", 
       RowBox[{"1", "/", "4."}], ",", 
       RowBox[{"1", "/", "3."}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1346912410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.7388289718852955, 0.8027437456625879}, {
      1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
      1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
      0.}, {0.8638055713944088, 0.8135392626408907}, {0.8922346463808141, 
      0.8150488053528235}, {0.9207012952478835, 0.8146734041530679}, {
      0.9490806769112616, 0.8124147053714416}, {0.977248332998741, 
      0.8082826145787214}, {1.0050807336650587`, 0.802295253145555}, {
      1.0324558193346167`, 0.794478878770811}, {1.059253535996307, 
      0.7848677703278905}, {1.436612622795641, 0.6352467742818492}, {
      1.4627154485022218`, 0.6238830814879694}, {1.488008908765278, 
      0.610816640055697}, {1.5123820785854851`, 0.5961047531373872}, {
      1.5357280689165165`, 0.5798119400210099}, {1.5579444954291912`, 
      0.5620096531794624}, {1.5789339275200929`, 0.5427759649142538}, {
      1.5986043155955216`, 0.5221952249677932}, {0.8224513451734057, 
      0.709239776242279}, {0.8421217332488343, 0.6886590362958185}, {
      0.8631111653397362, 0.6694253480306099}, {0.8853275918524107, 
      0.6516230611890624}, {0.9086735821834422, 0.6353302480726851}, {
      0.9330467520036493, 0.6206183611543752}, {0.9583402122667055, 
      0.607551919722103}, {0.9844430379732863, 0.5961882269282232}, {
      1.3618021247726204`, 0.4465672308821819}, {1.3885998414343106`, 
      0.43695612243926135`}, {1.4159749271038689`, 0.4291397480645173}, {
      1.4438073277701862`, 0.4231523866313511}, {1.471974983857666, 
      0.4190202958386308}, {1.5003543655210438`, 0.41676159705700455`}, {
      1.5288210143881134`, 0.41638619585724895`}, {1.5572500893745185`, 
      0.4178957385691817}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
       1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
       1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
       0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.7388289718852955, 0.8027437456625879}, {
      1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
      1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
      0.}, {0.8744403678210091, 0.8275775709859543}, {0.9023895646309924, 
      0.8315509538858193}, {0.9305665572217454, 0.833283715419551}, {
      0.9587920090158352, 0.8327648271737388}, {0.9868862750101641, 
      0.8299975916882745}, {1.014670545152784, 0.8249996214368571}, {
      1.0419679824055403`, 0.8178027267298352}, {1.0686048482491843`, 
      0.8084527132528488}, {1.4459639350485187`, 0.6588317172068076}, {
      1.4717706952668443`, 0.6473880944838244}, {1.4965830989719229`, 
      0.6339236971200978}, {1.5202432240028279`, 0.6185242212357023}, {
      1.5426004820442512`, 0.6012876790400842}, {1.5635125770677936`, 
      0.582323775019064}, {1.5828464109957798`, 0.561753207704642}, {
      1.600478930823383, 0.5397069014715945}, {0.8205767299455443, 
      0.6917280997384778}, {0.8382092497731475, 0.6696817935054303}, {
      0.8575430837011339, 0.6491112261910085}, {0.878455178724676, 
      0.6301473221699881}, {0.9008124367660998, 0.61291077997437}, {
      0.9244725617970045, 0.5975113040899747}, {0.9492849655020831, 
      0.5840469067262479}, {0.9750917257204088, 0.5726032840032648}, {
      1.352450812519743, 0.4229822879572236}, {1.379087678363387, 
      0.4136322744802373}, {1.4063851156161435`, 0.4064353797732153}, {
      1.4341693857587632`, 0.40143740952179796`}, {1.4622636517530923`, 
      0.39867017403633387`}, {1.490489103547182, 0.39815128579052156`}, {
      1.5186660961379348`, 0.39988404732425337`}, {1.5466152929479184`, 
      0.40385743022411835`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
       1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
       1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
       0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.7388289718852955, 0.8027437456625879}, {
      1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
      1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
      0.}, {0.8934305199559088, 0.8535068586217622}, {0.9202489931874497, 
      0.8608607901736821}, {0.947664158495768, 0.8655212114914155}, {
      0.9754061917906458, 0.8674422540227232}, {1.0032020518990536`, 
      0.8666050105843929}, {1.030778167876544, 0.8630177214495178}, {
      1.057863131532735, 0.8567156932455168}, {1.0841903686706469`, 
      0.847760951461113}, {1.4615494554699813`, 0.6981399554150716}, {
      1.4868598495485033`, 0.686620633936307}, {1.5109042919455098`, 
      0.6726501076198709}, {1.533446133721569, 0.6563658764410797}, {
      1.554263514753619, 0.6379282121988922}, {1.5731515473149396`, 
      0.6175185810972849}, {1.5899243326103, 0.5953378577281757}, {
      1.6044167904192512`, 0.5716043480341383}, {0.8166388703496757, 
      0.6598306531759341}, {0.8311313281586271, 0.6360971434818968}, {
      0.8479041134539874, 0.6139164201127876}, {0.8667921460153081, 
      0.5935067890111804}, {0.8876095270473582, 0.5750691247689929}, {
      0.9101513688234172, 0.5587848935902016}, {0.9341958112204237, 
      0.5448143672737654}, {0.9595062052989457, 0.5332950457950009}, {
      1.3368652920982802`, 0.38367404974895963`}, {1.363192529236192, 
      0.37471930796455577`}, {1.3902774928923831`, 0.36841727976055477`}, {
      1.4178536088698734`, 0.3648299906256797}, {1.4456494689782813`, 
      0.36399274718734936`}, {1.473391502273159, 0.365913789718657}, {
      1.5008066675814773`, 0.3705742110363904}, {1.5276251408130181`, 
      0.3779281425883103}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
       1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
       1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
       0.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->102091074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->380143786],

Cell["Multiedges for a hierarchical-style drawing:", "ExampleText",
 CellID->2083951074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2123051490],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdUg0w1GkcXmptl4v0ZUP5CI1G5SMXKs9bV5KtC6WmkbOT2gpxOKorG32S
47IKdWVy2j6Uo8z57NTKdIPNZ2c7e5dlkeW/a/8+I3HLzM1NPfP85pnfM8/v
fWfe92d+IMznkDaDwdiuqSn9FLPIZ8ZnvRqf6uf+f/n/czsaPKRzvsuHCzfD
zbmYRfq9nx6OchXhjtMo//h+FpGXbQ3lsGqwMdZC9DulQzbsyo7dXNcIA7KA
qXtUh0jj9881jH2DBVG1ngENTCLm7+QtSXuLbabeglIrJrlk5CZ6GN+Ox243
pSa8maTJN/xJ+/tOcJryrC8KZpCt4aKLBT8rwP4nMXI4R5tEvysa3SLohaPN
WL7AXJskKs/OD/hGiUyupbOJQItcPGfxeqJOhX3nZn+ROs4gBbtrbgl01QhM
ebRshMsg6Xl9looUNU4tXDg3hT+JYz78Se0PatS99QjRWz2BtRuOr5S503jB
H/TjNY1jIKzl19goGnuHDFszgj/AxaHil7QkGnlDYjM/3jASCu9OGl+hcZo/
+dR9bBCi7LIwXwGN53b9Bg7JA2gbZQxsukrj1JdC0yUW/egujk7ouEYj14Dd
xSpUo1lm4uiaTiMnNq26I1WFR+EDfV9n0Oi2i3EtKevF0eCxZ1rXaSxY02Gc
JO+GXq19dqSmX3m5JpSr24Ub16dAw3EacmSGvtJP1NyX+ThRgjAZHimPRARc
oDHlxt2TomJRiGhRCI1pETWjTdE8nu9BY/GJUifYNmLW4QeWq4xpPDhMtQ/V
1cAlWe6cLFcj1U2h4QtEBlxwachSo3V6rgS/tSRbj/iqMbZCnKDHvI+q1u5w
J+FtfHuUVj6JY5Gi+NFdrfMKEM26McgZ0SHrhZe6eWbP4dkyOr+Gq0MELUZs
R9UfeNM2d7tdOZPYOfiZBJ2sh8XS1pun9JnEx3yllVX6n7D+6aBO7u6ZJN/1
3F1PLym61mTFVybNIFbPVnkda5SBq39tWUWpNtEf9k8I8uxA2lIiEUq1yIjU
0ibQrAvKttkrhP5aZCF7VXBQ+TvU61d///YvBjmSc3JnrKUCuB9T5O3FIGoB
q/mOTw8i93A6PsZNIrdBMiHx6EWc/flt4r0TuM3rqVrMonCvTZipZ/ERVd5Y
G5REoZOXL6+UfYB1arN7lZTCOlE2uy91DM+5B1HeScGY48svWD6MW+zLhmdl
FBJs1kYmVg3iTSnzhlyTl11Zxw4MHkDEVsnLdgmFpXEHjrnO6UdQ+cStM68p
bBl7GGGQp4bI9LRpaQOFnPerveqzVIgO3skR1FG4rrfDOKazF5ezTpjPqqWw
76s8dxsbBcZFI1nGryj0hO1pfB3ShVfiKVDglG0qP5MvR6XFIZmimcLM4uAt
RPOOOZrf3zhEIWNx9Xoj/I2YxuUaKuER6S8Q20kAWx+dzFAl2DEpieknG6G2
zy3MrlJCL1TsNewgxvS6OKtgu6moQWVWCc1hP/o/VWGe8qWj/Q8lSPNsf2Kw
uw9XbTcLa5fcx79o/zd8
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
        40, 41, 4}], 
      ArrowBox[{1, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
        57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 
       74, 75, 76, 4}], ArrowBox[{2, 3}], ArrowBox[{3, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{84, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318343001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22846099],

Cell["Draw several edges:", "ExampleText",
 CellID->633054285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2107150362],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdknsw1AkAxzeuUgjRxp5UHFG6dLSU8jVkGnd7brQ3lh7ToqeuwR56ifYM
IXkTqTMn6ZCUHjOny6u46yRWXFr7zj7Yh2Wyv99uqat/7zvznc985/Pvd21c
4u5DZhQKJexTPzPxwezN9Hol6Db/NtjfmURPAjP38JQJ2dQmTkviOEI2/100
/2l3d/zDbHk5C4rGU+aeEAYL8VKHtDYjKP+Lyq/nh3AbNebZfpSzgZMYP+56
20CqEeEyOezlOIlsp267UKkGxMJMy7saFRjZZxvkf2lRl/HuW5c/VLBYcXtV
5S0dInk1f3LPqRBWJ35qVTSNuJQntrqtKgg0qyK4/nrssl9z8pROiaTnCQ8d
G/TY6rWwKqBGCWydO9jTakDDuuO1OTwZOOXiay+dCRwJOVJemSbDlxvaU7fn
EvgxeIVkuYMMW9ZPYHyGQDHN+xCtSYp8PktcGEPid4uhfS8CpLgebsWjd5Lo
XeTJ2N0lwdNmD/o9VyMKzAKN/cES6HeSwoksI7KjfTr6UsS4uP98kWx0CnGB
JaY6gQqjKZIl5o/UiM20FPrUqiCS546Y1WpgH/kguHW/CtMsbdYgV4u0cXaS
m6MKfasie6Piddg4f2Jp2Qsl+N4h7JzQaVyxj6J8wVXiqMnC2cNOjwibzZXp
m5Q48P6GR3+mHvXjvnHmfAV8j/mMpuQZYM2vPhZpK8MAZ/UyJmFAmWshU/tQ
Ck2adUXsQQIruaHlN2KkKF2UeOXyEIEPq033uaQEHfl0tiaQhEbQV5hXJsEv
DnnbWA0kIkl9eO/6T/5+cvGgjRHWHaXtZ9LFmGOUCRinjFjjT9DmakRYPMP5
2Jo7BU1G6/C0kwqpax9ebopRI+2R1KylUQlN7IXQGm8NvF23Ud13KJGS6k0m
LdCiZMdBHntEgefnHmXRxrRIN/k0H01UwPFaRmHOHR0OVSv7dy5TIOrGnqvX
86cxSVy1mr8jR9g+58U+vnokB5cYqlhyOD1rePB6uwGvg4h5xSUJbPpDuzKa
DdhoaXp2IkACy9YNt6Q0At3WTZ3PB8SooNefNuYTqN12pvn2N2JwnaJoj98R
sM4oF1+qFSFvtwXH7QSJl6XqoDQHEawv7mO5iUn407Ho5xIh2ioLyu9FGuHX
4dtfSBWCtqDxfWbyFLboli+40KJEoi+D8cZXDfVK/WGXdUrcJ85TBSY17tqb
O1TdVEA+Omnc0KfBkN1ec+dNCpTQeQFlFVooPn4wDT6Wo9fPfWDoqA5f8Vec
f8WUgxrHT6/DNGzHnvQzZyYQVMA6KbPSgzfb2RVfOQEro9S9gGrAGdl3xfHV
Yvw29nWhW7YB7GXU4TezIux5KzjtMmeAJ2PwV3KvCGR76kDMYQLfl7rs4o0I
8crMZknbGIFG/wPrq/YL0R7wE9OcQcLcK7qRYxCgqCgw26vr8x+yaNxaAZY0
H/ejbDHiLUfbKYoW4D+ebTFm
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
         2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
        37, 2}, {1, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
        50, 51, 52, 53, 2}, {1, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 
        65, 66, 67, 68, 69, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
     1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
     1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1446411132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350066624],

Cell["\<\
Draw several edges for a graph specified by a generalized adjacency matrix:\
\>", "ExampleText",
 CellID->1395239523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "5"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2025761170],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdknsw1AkAxzeuUgjRxp5UHFG6dLSU8jVkGnd7brQ3lh7ToqeuwR56ifYM
IXkTqTMn6ZCUHjOny6u46yRWXFr7zj7Yh2Wyv99uqat/7zvznc985/Pvd21c
4u5DZhQKJexTPzPxwezN9Hol6Db/NtjfmURPAjP38JQJ2dQmTkviOEI2/100
/2l3d/zDbHk5C4rGU+aeEAYL8VKHtDYjKP+Lyq/nh3AbNebZfpSzgZMYP+56
20CqEeEyOezlOIlsp267UKkGxMJMy7saFRjZZxvkf2lRl/HuW5c/VLBYcXtV
5S0dInk1f3LPqRBWJ35qVTSNuJQntrqtKgg0qyK4/nrssl9z8pROiaTnCQ8d
G/TY6rWwKqBGCWydO9jTakDDuuO1OTwZOOXiay+dCRwJOVJemSbDlxvaU7fn
EvgxeIVkuYMMW9ZPYHyGQDHN+xCtSYp8PktcGEPid4uhfS8CpLgebsWjd5Lo
XeTJ2N0lwdNmD/o9VyMKzAKN/cES6HeSwoksI7KjfTr6UsS4uP98kWx0CnGB
JaY6gQqjKZIl5o/UiM20FPrUqiCS546Y1WpgH/kguHW/CtMsbdYgV4u0cXaS
m6MKfasie6Piddg4f2Jp2Qsl+N4h7JzQaVyxj6J8wVXiqMnC2cNOjwibzZXp
m5Q48P6GR3+mHvXjvnHmfAV8j/mMpuQZYM2vPhZpK8MAZ/UyJmFAmWshU/tQ
Ck2adUXsQQIruaHlN2KkKF2UeOXyEIEPq033uaQEHfl0tiaQhEbQV5hXJsEv
DnnbWA0kIkl9eO/6T/5+cvGgjRHWHaXtZ9LFmGOUCRinjFjjT9DmakRYPMP5
2Jo7BU1G6/C0kwqpax9ebopRI+2R1KylUQlN7IXQGm8NvF23Ud13KJGS6k0m
LdCiZMdBHntEgefnHmXRxrRIN/k0H01UwPFaRmHOHR0OVSv7dy5TIOrGnqvX
86cxSVy1mr8jR9g+58U+vnokB5cYqlhyOD1rePB6uwGvg4h5xSUJbPpDuzKa
DdhoaXp2IkACy9YNt6Q0At3WTZ3PB8SooNefNuYTqN12pvn2N2JwnaJoj98R
sM4oF1+qFSFvtwXH7QSJl6XqoDQHEawv7mO5iUn407Ho5xIh2ioLyu9FGuHX
4dtfSBWCtqDxfWbyFLboli+40KJEoi+D8cZXDfVK/WGXdUrcJ85TBSY17tqb
O1TdVEA+Omnc0KfBkN1ec+dNCpTQeQFlFVooPn4wDT6Wo9fPfWDoqA5f8Vec
f8WUgxrHT6/DNGzHnvQzZyYQVMA6KbPSgzfb2RVfOQEro9S9gGrAGdl3xfHV
Yvw29nWhW7YB7GXU4TezIux5KzjtMmeAJ2PwV3KvCGR76kDMYQLfl7rs4o0I
8crMZknbGIFG/wPrq/YL0R7wE9OcQcLcK7qRYxCgqCgw26vr8x+yaNxaAZY0
H/ejbDHiLUfbKYoW4D+ebTFm
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
         2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
        37, 2}, {1, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
        50, 51, 52, 53, 2}, {1, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 
        65, 66, 67, 68, 69, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7388289718852955, 0.8027437456625879}, {
     1.6822266888836315`, 0.4286912555474845}, {1.6823707214817465`, 
     1.176678969681163}, {0.0006535229661673858, 1.606069639483339}, {0., 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1532949890]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MultiedgeStyle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MultiedgeStyle"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultiedgeStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 11.8713944}", "context" -> "System`", 
    "keywords" -> {
     "rendering multiple edges", "multiple edges in graphs", "multiedges"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MultiedgeStyle is an option for GraphPlot and related functions which \
specifies how to draw multiple edges.", "synonyms" -> {"multiedge style"}, 
    "title" -> "MultiedgeStyle", "type" -> "Symbol", "uri" -> 
    "ref/MultiedgeStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6617, 198, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30514158]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39893, 1069}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1636, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2259, 65, 1579, 37, 70, "ObjectNameGrid"],
Cell[3841, 104, 629, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4507, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4985, 144, 217, 8, 70, "Notes",
 CellID->99769023],
Cell[5205, 154, 1075, 28, 70, "2ColumnTableMod",
 CellID->265287133],
Cell[6283, 184, 297, 9, 70, "Notes",
 CellID->691530915]
}, Closed]],
Cell[CellGroupData[{
Cell[6617, 198, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30514158],
Cell[CellGroupData[{
Cell[7001, 212, 147, 5, 70, "ExampleSection",
 CellID->97869304],
Cell[7151, 219, 64, 1, 70, "ExampleText",
 CellID->1704158010],
Cell[CellGroupData[{
Cell[7240, 224, 378, 11, 28, "Input",
 CellID->777512491],
Cell[7621, 237, 2991, 65, 193, "Output",
 CellID->1541259790]
}, Open  ]],
Cell[10627, 305, 125, 3, 70, "ExampleDelimiter",
 CellID->355164303],
Cell[10755, 310, 117, 3, 70, "ExampleText",
 CellID->591791095],
Cell[CellGroupData[{
Cell[10897, 317, 839, 26, 70, "Input",
 CellID->2062836331],
Cell[11739, 345, 2990, 65, 70, "Output",
 CellID->850648330]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14778, 416, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[15002, 425, 97, 1, 70, "ExampleText",
 CellID->2139252208],
Cell[CellGroupData[{
Cell[15124, 430, 728, 22, 70, "Input",
 CellID->1346912410],
Cell[15855, 454, 9080, 191, 70, "Output",
 CellID->102091074]
}, Open  ]],
Cell[24950, 648, 125, 3, 70, "ExampleDelimiter",
 CellID->380143786],
Cell[25078, 653, 88, 1, 70, "ExampleText",
 CellID->2083951074],
Cell[CellGroupData[{
Cell[25191, 658, 345, 10, 70, "Input",
 CellID->2123051490],
Cell[25539, 670, 2884, 65, 70, "Output",
 CellID->318343001]
}, Open  ]],
Cell[28438, 738, 124, 3, 70, "ExampleDelimiter",
 CellID->22846099],
Cell[28565, 743, 62, 1, 70, "ExampleText",
 CellID->633054285],
Cell[CellGroupData[{
Cell[28652, 748, 502, 14, 70, "Input",
 CellID->2107150362],
Cell[29157, 764, 3001, 69, 70, "Output",
 CellID->1446411132]
}, Open  ]],
Cell[32173, 836, 125, 3, 70, "ExampleDelimiter",
 CellID->350066624],
Cell[32301, 841, 127, 3, 70, "ExampleText",
 CellID->1395239523],
Cell[CellGroupData[{
Cell[32453, 848, 839, 26, 70, "Input",
 CellID->2025761170],
Cell[33295, 876, 3001, 69, 70, "Output",
 CellID->1532949890]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36357, 952, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[36676, 963, 491, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[37204, 985, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[37525, 996, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[37675, 1001, 173, 3, 70, "Tutorials",
 CellID->106430589],
Cell[37851, 1006, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[38026, 1014, 305, 8, 70, "RelatedLinksSection"],
Cell[38334, 1024, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[38719, 1039, 27, 0, 70, "History"],
Cell[38749, 1041, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

