(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33693,       1240]
NotebookOptionsPosition[     26191,        987]
NotebookOutlinePosition[     27856,       1029]
CellTagsIndexPosition[     27770,       1024]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerPhi" :> Documentation`HelpLookup["paclet:ref/EulerPhi"], 
          "PowerMod" :> Documentation`HelpLookup["paclet:ref/PowerMod"], 
          "PrimitiveRoot" :> 
          Documentation`HelpLookup["paclet:ref/PrimitiveRoot"], 
          "CarmichaelLambda" :> 
          Documentation`HelpLookup["paclet:ref/CarmichaelLambda"], 
          "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EulerPhi\"\>", 
       2->"\<\"PowerMod\"\>", 3->"\<\"PrimitiveRoot\"\>", 
       4->"\<\"CarmichaelLambda\"\>", 
       5->"\<\"RealDigits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Diophantine Equations\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Number Theoretic Functions\"\>", 
       5->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultiplicativeOrder", "ObjectName",
 CellID->14662],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MultiplicativeOrder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multiplicative order of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", defined as the smallest integer ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["k", "m"], "\[Congruent]", 
        RowBox[{"1", "mod", " ", "n"}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MultiplicativeOrder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized multiplicative order of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", defined as the smallest integer ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["k", "m"], "\[Congruent]", 
        RowBox[{
         SubscriptBox["r", "i"], "mod", " ", "n"}]}], TraditionalForm]], 
      "InlineMath"],
     " for some ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MultiplicativeOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFormula"],
 " returns unevaluated if there is no integer ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " satisfying the necessary conditions. "
}], "Notes",
 CellID->21906]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159384469],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->67200716],

Cell["The multiplicative order of 3 modulo 108:", "ExampleText",
 CellID->484401378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{"7", ",", "108"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223454269],

Cell[BoxData["18"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313614746]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30498],

Cell["Evaluate for large arguments:", "ExampleText",
 CellID->1570607619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "^", "100"}], "+", "1"}], ",", 
   RowBox[{"Prime", "[", "1000", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333263609],

Cell[BoxData["3959"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->998166284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->500653216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MultiplicativeOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFormula"],
 " works for negative first arguments:"
}], "ExampleText",
 CellID->637672366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{
   RowBox[{"-", "5"}], ",", " ", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1416056832],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38484824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425503178],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->525340902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MultiplicativeOrder", "[", 
   RowBox[{"m", ",", "n"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143731351],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["ord", "n"], "(", "m", ")"}], TraditionalForm]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->421859221]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4867],

Cell["Generalized multiplicative order: ", "ExampleText",
 CellID->1441307926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{"5", ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->446774122],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1344408600]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26103],

Cell["Find all primitive roots modulo 43:", "ExampleText",
 CellID->1878896518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "43", "]"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MultiplicativeOrder", "[", 
      RowBox[{"#", ",", "43"}], "]"}], "\[Equal]", " ", 
     RowBox[{"EulerPhi", "[", "43", "]"}]}], " ", "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2014232538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "5", ",", "12", ",", "18", ",", "19", ",", "20", ",", "26", ",", 
   "28", ",", "29", ",", "30", ",", "33", ",", "34"}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1799890113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->863746018],

Cell[TextData[{
 "Find a solution to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Mod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mod"], "[", 
    RowBox[{
     RowBox[{"5", "^", "k"}], ",", "7"}], "]"}], "=", "2"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2137354453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{"5", ",", "7", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1680650002],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1298477549]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"5", "^", "%"}], ",", "7"}], "]"}], "\[Equal]", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113474803],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->783345229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1596061092],

Cell[TextData[{
 "The function digitCycleLength gives the digit period for any rational \
number ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->780538567],

Cell[BoxData[
 RowBox[{
  RowBox[{"digitCycleLength", "[", 
   RowBox[{"r_Rational", ",", 
    RowBox[{"b_Integer", "?", "Positive"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"MultiplicativeOrder", "[", 
   RowBox[{"b", ",", 
    RowBox[{"FixedPoint", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Quotient", "[", 
        RowBox[{"#", ",", 
         RowBox[{"GCD", "[", 
          RowBox[{"#", ",", "b"}], "]"}]}], "]"}], "&"}], ",", 
      RowBox[{"Denominator", "[", "r", "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1681579693],

Cell[TextData[{
 "This shows that the decimal representation of ",
 Cell[BoxData[
  FractionBox["123", "999"]], "InlineFormula"],
 " in base ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula"],
 " repeats every ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula"],
 " digits. "
}], "ExampleText",
 CellID->1425105731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"digitCycleLength", "[", 
  RowBox[{
   FractionBox["123", "999"], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->866905926],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1608507693]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   FractionBox["123", "999"], ",", "18"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73537038],

Cell[BoxData["0.12312312312312312312312312312`18.000000000000004"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1664647815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->698189809],

Cell[TextData[{
 "The digits of ",
 Cell[BoxData[
  FractionBox["1", "13"]], "InlineFormula"],
 "in base ",
 Cell[BoxData["4"], "InlineFormula"],
 " repeat with period ",
 Cell[BoxData["6"], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1053519643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "=", "4"}], ",", 
     RowBox[{"n", "=", "13"}]}], "}"}], ",", 
   RowBox[{"MultiplicativeOrder", "[", 
    RowBox[{"b", ",", 
     RowBox[{"FixedPoint", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
        "#", "/", "\[NegativeVeryThinSpace]", "\[NegativeVeryThinSpace]", 
         RowBox[{"GCD", "[", 
          RowBox[{"#", ",", "b"}], "]"}]}], "&"}], ",", "n"}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625472655],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318873589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "=", "4"}], ",", 
     RowBox[{"n", "=", "13"}]}], "}"}], ",", 
   RowBox[{"RealDigits", "[", 
    RowBox[{
     RowBox[{"1", "/", "n"}], ",", "b", ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1251411112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "3", ",", "2", ",", "3", ",", "0", ",", "1", ",", "0",
      ",", "3", ",", "2", ",", "3", ",", "0", ",", "1", ",", "0", ",", "3", 
     ",", "2", ",", "3", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{411, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1336711058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1568221585],

Cell[TextData[{
 "The repetition period in Rule 90 for odd ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " divides ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1033379464],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"q", "[", "n_", "]"}], "=", 
   RowBox[{
    RowBox[{"2", "^", 
     RowBox[{"MultiplicativeOrder", "[", 
      RowBox[{"2", ",", "n", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "-", "1"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1308398159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"q", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3", ",", "50", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15313033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "7", ",", "7", ",", "31", ",", "63", ",", "15", ",", 
   "15", ",", "511", ",", "63", ",", "2047", ",", "1023", ",", "511", ",", 
   "16383", ",", "31", ",", "31", ",", "4095", ",", "262143", ",", "4095", 
   ",", "1023", ",", "127", ",", "4095", ",", "8388607", ",", "2097151"}], 
  "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1276320539]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " is a multiple of the multiplicative order:"
}], "ExampleText",
 CellID->1336371934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", "12", "]"}], ",", " ", 
   RowBox[{"MultiplicativeOrder", "[", 
    RowBox[{"5", ",", "12"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1945379497],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2052632737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2019114412],

Cell[TextData[{
 "The multiplicative order of a primitive root modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->719332590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MultiplicativeOrder", "[", 
   RowBox[{
    RowBox[{"PrimitiveRoot", "[", "109", "]"}], ",", "109"}], "]"}], 
  "\[Equal]", " ", 
  RowBox[{"EulerPhi", "[", "109", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644967631],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1421105351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MultiplicativeOrder", "[", 
      RowBox[{
       RowBox[{"PrimitiveRoot", "[", "p", "]"}], ",", "p"}], "]"}], ",", 
     RowBox[{"EulerPhi", "[", "p", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"Prime", "[", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"10", "^", "4"}], ",", 
        RowBox[{"10", "^", "5"}], ",", 
        RowBox[{"10", "^", "4"}]}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658003593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"104728", ",", "104728"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"224736", ",", "224736"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"350376", ",", "350376"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"479908", ",", "479908"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"611952", ",", "611952"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"746772", ",", "746772"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"882376", ",", "882376"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1020378", ",", "1020378"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1159522", ",", "1159522"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1299708", ",", "1299708"}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204512323]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16218],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimitiveRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimitiveRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CarmichaelLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CarmichaelLambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1991]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5418],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->21622]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->215696979],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->114540122],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->57291981],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->659028154],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->216097219],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->369411330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MultiplicativeOrder"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultiplicativeOrder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 16.9183986}", "context" -> "System`", 
    "keywords" -> {
     "discrete log", "discrete logarithm", "group order", "index function", 
      "logarithm", "modular root", "Order", "primitive root", "Root"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MultiplicativeOrder[k, n] gives the multiplicative order of k modulo n, \
defined as the smallest integer m such that k^m \\[Congruent] 1 mod n. \
MultiplicativeOrder[k, n, {r_1, r_2, ...}] gives the generalized \
multiplicative order of k modulo n, defined as the smallest integer m such \
that k^m \\[Congruent] r_i mod n for some i. ", 
    "synonyms" -> {"multiplicative order"}, "title" -> "MultiplicativeOrder", 
    "type" -> "Symbol", "uri" -> "ref/MultiplicativeOrder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6890, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->159384469]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27627, 1017}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2921, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3544, 94, 57, 1, 70, "ObjectName",
 CellID->14662],
Cell[3604, 97, 2266, 72, 70, "Usage",
 CellID->15190]
}, Open  ]],
Cell[CellGroupData[{
Cell[5907, 174, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6385, 191, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[6520, 197, 333, 10, 70, "Notes",
 CellID->21906]
}, Closed]],
Cell[CellGroupData[{
Cell[6890, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159384469],
Cell[CellGroupData[{
Cell[7275, 226, 147, 5, 70, "ExampleSection",
 CellID->67200716],
Cell[7425, 233, 84, 1, 70, "ExampleText",
 CellID->484401378],
Cell[CellGroupData[{
Cell[7534, 238, 140, 4, 28, "Input",
 CellID->223454269],
Cell[7677, 244, 159, 5, 36, "Output",
 CellID->313614746]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7885, 255, 216, 7, 70, "ExampleSection",
 CellID->30498],
Cell[8104, 264, 73, 1, 70, "ExampleText",
 CellID->1570607619],
Cell[CellGroupData[{
Cell[8202, 269, 226, 7, 70, "Input",
 CellID->333263609],
Cell[8431, 278, 161, 5, 36, "Output",
 CellID->998166284]
}, Open  ]],
Cell[8607, 286, 125, 3, 70, "ExampleDelimiter",
 CellID->500653216],
Cell[8735, 291, 235, 7, 70, "ExampleText",
 CellID->637672366],
Cell[CellGroupData[{
Cell[8995, 302, 163, 5, 70, "Input",
 CellID->1416056832],
Cell[9161, 309, 157, 5, 36, "Output",
 CellID->38484824]
}, Open  ]],
Cell[9333, 317, 125, 3, 70, "ExampleDelimiter",
 CellID->425503178],
Cell[9461, 322, 203, 7, 70, "ExampleText",
 CellID->525340902],
Cell[CellGroupData[{
Cell[9689, 333, 177, 5, 70, "Input",
 CellID->143731351],
Cell[9869, 340, 256, 8, 50, "Output",
 CellID->421859221]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10174, 354, 238, 7, 70, "ExampleSection",
 CellID->4867],
Cell[10415, 363, 78, 1, 70, "ExampleText",
 CellID->1441307926],
Cell[CellGroupData[{
Cell[10518, 368, 198, 6, 70, "Input",
 CellID->446774122],
Cell[10719, 376, 159, 5, 36, "Output",
 CellID->1344408600]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10927, 387, 223, 7, 70, "ExampleSection",
 CellID->26103],
Cell[11153, 396, 79, 1, 70, "ExampleText",
 CellID->1878896518],
Cell[CellGroupData[{
Cell[11257, 401, 342, 10, 70, "Input",
 CellID->2014232538],
Cell[11602, 413, 322, 9, 36, "Output",
 CellID->1799890113]
}, Open  ]],
Cell[11939, 425, 125, 3, 70, "ExampleDelimiter",
 CellID->863746018],
Cell[12067, 430, 305, 13, 70, "ExampleText",
 CellID->2137354453],
Cell[CellGroupData[{
Cell[12397, 447, 173, 5, 70, "Input",
 CellID->1680650002],
Cell[12573, 454, 159, 5, 36, "Output",
 CellID->1298477549]
}, Open  ]],
Cell[CellGroupData[{
Cell[12769, 464, 178, 6, 70, "Input",
 CellID->113474803],
Cell[12950, 472, 161, 5, 36, "Output",
 CellID->783345229]
}, Open  ]],
Cell[13126, 480, 126, 3, 70, "ExampleDelimiter",
 CellID->1596061092],
Cell[13255, 485, 271, 10, 70, "ExampleText",
 CellID->780538567],
Cell[13529, 497, 572, 17, 70, "Input",
 CellID->1681579693],
Cell[14104, 516, 351, 12, 70, "ExampleText",
 CellID->1425105731],
Cell[CellGroupData[{
Cell[14480, 532, 162, 5, 70, "Input",
 CellID->866905926],
Cell[14645, 539, 159, 5, 36, "Output",
 CellID->1608507693]
}, Open  ]],
Cell[CellGroupData[{
Cell[14841, 549, 146, 5, 70, "Input",
 CellID->73537038],
Cell[14990, 556, 209, 5, 36, "Output",
 CellID->1664647815]
}, Open  ]],
Cell[15214, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->698189809],
Cell[15342, 569, 254, 10, 70, "ExampleText",
 CellID->1053519643],
Cell[CellGroupData[{
Cell[15621, 583, 554, 18, 70, "Input",
 CellID->625472655],
Cell[16178, 603, 158, 5, 36, "Output",
 CellID->318873589]
}, Open  ]],
Cell[CellGroupData[{
Cell[16373, 613, 328, 12, 70, "Input",
 CellID->1251411112],
Cell[16704, 627, 470, 13, 36, "Output",
 CellID->1336711058]
}, Open  ]],
Cell[17189, 643, 126, 3, 70, "ExampleDelimiter",
 CellID->1568221585],
Cell[17318, 648, 283, 11, 70, "ExampleText",
 CellID->1033379464],
Cell[17604, 661, 360, 13, 70, "Input",
 CellID->1308398159],
Cell[CellGroupData[{
Cell[17989, 678, 222, 7, 70, "Input",
 CellID->15313033],
Cell[18214, 687, 495, 12, 54, "Output",
 CellID->1276320539]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18758, 705, 233, 7, 70, "ExampleSection",
 CellID->17430],
Cell[18994, 714, 221, 7, 70, "ExampleText",
 CellID->1336371934],
Cell[CellGroupData[{
Cell[19240, 725, 244, 7, 70, "Input",
 CellID->1945379497],
Cell[19487, 734, 162, 5, 36, "Output",
 CellID->2052632737]
}, Open  ]],
Cell[19664, 742, 126, 3, 70, "ExampleDelimiter",
 CellID->2019114412],
Cell[19793, 747, 352, 13, 70, "ExampleText",
 CellID->719332590],
Cell[CellGroupData[{
Cell[20170, 764, 260, 8, 70, "Input",
 CellID->644967631],
Cell[20433, 774, 162, 5, 36, "Output",
 CellID->1421105351]
}, Open  ]],
Cell[CellGroupData[{
Cell[20632, 784, 580, 18, 70, "Input",
 CellID->658003593],
Cell[21215, 804, 880, 27, 71, "Output",
 CellID->204512323]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22156, 838, 311, 9, 70, "SeeAlsoSection",
 CellID->16218],
Cell[22470, 849, 1215, 44, 70, "SeeAlso",
 CellID->1991]
}, Open  ]],
Cell[CellGroupData[{
Cell[23722, 898, 313, 9, 70, "TutorialsSection",
 CellID->5418],
Cell[24038, 909, 198, 4, 70, "Tutorials",
 CellID->21622]
}, Open  ]],
Cell[CellGroupData[{
Cell[24273, 918, 319, 9, 70, "MoreAboutSection",
 CellID->215696979],
Cell[24595, 929, 164, 3, 70, "MoreAbout",
 CellID->114540122],
Cell[24762, 934, 152, 3, 70, "MoreAbout",
 CellID->57291981],
Cell[24917, 939, 155, 3, 70, "MoreAbout",
 CellID->659028154],
Cell[25075, 944, 162, 3, 70, "MoreAbout",
 CellID->216097219],
Cell[25240, 949, 137, 3, 70, "MoreAbout",
 CellID->369411330]
}, Open  ]],
Cell[CellGroupData[{
Cell[25414, 957, 305, 8, 70, "RelatedLinksSection"],
Cell[25722, 967, 397, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[26134, 983, 27, 0, 70, "History"],
Cell[26164, 985, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

