(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10680,        378]
NotebookOptionsPosition[      8275,        300]
NotebookOutlinePosition[      9553,        336]
CellTagsIndexPosition[      9469,        331]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"N\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NCache", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NCache",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NCache"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["xn", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a numeric cache object for a quantity with \
exact value ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and approximate numerical value ",
     Cell[BoxData[
      StyleBox["xn", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10640]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NCache",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NCache"]], "InlineFormula"],
 " objects are generated by ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " during formatting if the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option ",
 Cell[BoxData["\"\<CacheSymbolicGraphics\>\""], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1131]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->318420814],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->26540729],

Cell[TextData[{
 "Exact values and numerical values of coordinates are represented by ",
 Cell[BoxData[
  ButtonBox["NCache",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NCache"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->573549012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "4"}]}], "}"}]}], "}"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3782273],

Cell[BoxData[
 RowBox[{"GraphicsBox", "[", 
  RowBox[{"LineBox", "[", 
   RowBox[{"NCache", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox["1", "4"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "0.25`"}], "}"}]}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{476, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103188663]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Pi", ",", 
       RowBox[{"Sqrt", "[", "Pi", "]"}]}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->483913473],

Cell[BoxData[
 RowBox[{"GraphicsBox", "[", 
  RowBox[{"RectangleBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"NCache", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Pi]", ",", 
        SqrtBox["\[Pi]"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.141592653589793`", ",", "1.7724538509055159`"}], "}"}]}], 
     "]"}]}], "]"}], "]"}]], "Output",
 ImageSize->{492, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3017516]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19445],

Cell[BoxData[Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->27609]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NCache - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 18.5590656}", "context" -> "System`", 
    "keywords" -> {"numerical graphics cache", "graphics cache"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NCache[x, xn] represents a numeric cache object for a quantity with \
exact value x and approximate numerical value xn.", "synonyms" -> {}, "title" -> 
    "NCache", "type" -> "Symbol", "uri" -> "ref/NCache"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4820, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->318420814]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9326, 324}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 527, 13, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1150, 40, 1571, 37, 70, "ObjectNameGrid"],
Cell[2724, 79, 745, 24, 70, "Usage",
 CellID->10640]
}, Open  ]],
Cell[CellGroupData[{
Cell[3506, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3984, 125, 799, 29, 70, "Notes",
 CellID->1131]
}, Closed]],
Cell[CellGroupData[{
Cell[4820, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->318420814],
Cell[CellGroupData[{
Cell[5205, 173, 147, 5, 70, "ExampleSection",
 CellID->26540729],
Cell[5355, 180, 247, 8, 70, "ExampleText",
 CellID->573549012],
Cell[CellGroupData[{
Cell[5627, 192, 390, 14, 28, "Input",
 CellID->3782273],
Cell[6020, 208, 689, 24, 51, "Output",
 CellID->103188663]
}, Open  ]],
Cell[CellGroupData[{
Cell[6746, 237, 347, 12, 28, "Input",
 CellID->483913473],
Cell[7096, 251, 546, 18, 43, "Output",
 CellID->3017516]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7703, 276, 311, 9, 70, "SeeAlsoSection",
 CellID->19445],
Cell[8017, 287, 186, 6, 70, "SeeAlso",
 CellID->27609]
}, Open  ]],
Cell[8218, 296, 27, 0, 70, "History"],
Cell[8248, 298, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

