(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25307,        983]
NotebookOptionsPosition[     19225,        768]
NotebookOutlinePosition[     20568,        806]
CellTagsIndexPosition[     20483,        801]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Controlling Numerical Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingNumericalEvaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Controlling Numerical Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NHoldRest" :> Documentation`HelpLookup["paclet:ref/NHoldRest"],
           "NHoldAll" :> Documentation`HelpLookup["paclet:ref/NHoldAll"], 
          "NumericFunction" :> 
          Documentation`HelpLookup["paclet:ref/NumericFunction"], "HoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/HoldFirst"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NHoldRest\"\>", 
       2->"\<\"NHoldAll\"\>", 3->"\<\"NumericFunction\"\>", 
       4->"\<\"HoldFirst\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NHoldFirst", "ObjectName",
 CellID->25162],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NHoldFirst",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that the first argument \
to a function should not be affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->951144012],

Cell[TextData[{
 "Prevent ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " from affecting the first argument of a function:"
}], "ExampleText",
 CellID->98927649],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NHoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4075639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   RowBox[{"3", ",", "Pi"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->654359576],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"3", ",", "3.141592653589793`"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93200572]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Pi", ",", "E"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->334661698],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"\[Pi]", ",", "2.71828182845904523536028579257075851155`20."}], 
  "]"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->294081590]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26010],

Cell[TextData[{
 "System symbols with the ",
 Cell[BoxData[
  ButtonBox["NHoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->115115300],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ssymb", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], "]"}], ",", 
     "_Symbol"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Select", "[", 
  RowBox[{"ssymb", ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Attributes", "[", "#", "]"}], ",", "NHoldFirst"}], "]"}], 
    "&"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->20129150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "AiryAiZero", ",", "AiryBiZero", ",", "BellB", ",", "EllipticTheta", ",", 
   "EllipticThetaPrime", ",", "MathieuC", ",", "MathieuCharacteristicA", ",", 
   "MathieuCharacteristicB", ",", "MathieuCPrime", ",", "MathieuS", ",", 
   "MathieuSPrime", ",", "StieltjesGamma", ",", "ZetaZero"}], "}"}]], "Output",\

 ImageSize->{455, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264578762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408841256],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " zero of the zeta function on the critical line with the imaginary part \
greater than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "+", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->384522430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zz20", "=", 
  RowBox[{"ZetaZero", "[", 
   RowBox[{"20", ",", 
    RowBox[{"t", "+", "Pi"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->549513507],

Cell[BoxData[
 RowBox[{"ZetaZero", "[", 
  RowBox[{"20", ",", 
   RowBox[{"\[Pi]", "+", "t"}]}], "]"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79808160]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " does not affect the index ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->151377661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "zz20", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38624791],

Cell[BoxData[
 RowBox[{"ZetaZero", "[", 
  RowBox[{"20", ",", 
   RowBox[{"3.141592653589793`", "\[InvisibleSpace]", "+", "t"}]}], 
  "]"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204131781]
}, Open  ]],

Cell[TextData[{
 "When the second argument is numeric, ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " evaluates numerically:"
}], "ExampleText",
 CellID->138615536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"zz20", " ", "/.", " ", 
   RowBox[{"t", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->711715932],

Cell[BoxData[
 RowBox[{"0.5`", "\[InvisibleSpace]", "+", 
  RowBox[{"77.1448400688748`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2358007]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19275],

Cell[TextData[{
 "Define an \"inverse\" for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "k"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->786655052],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", ":", 
   RowBox[{"binv", "[", 
    RowBox[{"k_Integer", ",", 
     RowBox[{"x_", "?", "InexactNumberQ"}]}], "]"}]}], ":=", " ", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", "=", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Check", "[", 
        RowBox[{
         RowBox[{"z", " ", "/.", " ", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BesselJ", "[", 
              RowBox[{"k", ",", "z"}], "]"}], "-", "x"}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0"}], "}"}], ",", 
            RowBox[{"WorkingPrecision", "\[Rule]", 
             RowBox[{"Precision", "[", "x", "]"}]}]}], "]"}]}], ",", 
         "$Failed"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"r", " ", "/;", 
     RowBox[{"NumberQ", "[", "r", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489938302],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  ButtonBox["NHoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
 " attribute so that ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " remains an integer:"
}], "ExampleText",
 CellID->4970114],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"binv", ",", "NHoldFirst"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142526631],

Cell[TextData[{
 "A symbolic representation of an inverse of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "1"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->67648367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"binv", "[", 
  RowBox[{"1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->283199919],

Cell[BoxData[
 RowBox[{"binv", "[", 
  RowBox[{"1", ",", "x"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->193981958]
}, Open  ]],

Cell[TextData[{
 "This remains unmodified with ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->419285339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->410603361],

Cell[BoxData[
 RowBox[{"binv", "[", 
  RowBox[{"1", ",", "x"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->301474006]
}, Open  ]],

Cell[TextData[{
 "With a numeric value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", the function binv evaluates numerically:"
}], "ExampleText",
 CellID->26712399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"binv", "[", 
   RowBox[{"1", ",", 
    RowBox[{"1", "/", "Pi"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->61932684],

Cell[BoxData["0.674209497633699`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->743080626]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3435],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " prevents evaluation while ",
 Cell[BoxData[
  ButtonBox["NHoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
 " only prevents numerical evaluation:"
}], "ExampleText",
 CellID->293430125],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f1", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47837573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"3", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160953],

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", "7"}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18638555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->123348454],

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{
   RowBox[{"1.`", "\[InvisibleSpace]", "+", "2.`"}], ",", "7.`"}], 
  "]"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->112120584]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f2", ",", "NHoldFirst"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21768317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"3", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->137692413],

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"3", ",", "7"}], "]"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->182093225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->195540706],

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"3", ",", "7.`"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->118885855]
}, Open  ]],

Cell["You can prevent both by setting both attributes:", "ExampleText",
 CellID->200417411],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"HoldFirst", ",", "NHoldFirst"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->217759067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"3", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->152019579],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", "7"}], "]"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->639594708]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->41745134],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", "7.`"}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->49129660]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6372],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldRest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldRest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32702]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28220],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->30437],

Cell[TextData[ButtonBox["Controlling Numerical Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingNumericalEvaluation"]], "Tutorials",
 CellID->126352843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->629679200],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->282400684]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NHoldFirst - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 6.3259134}", "context" -> "System`", 
    "keywords" -> {
     "indexed functions", "numerical evaluation control", 
      "suppressing numerical evaluation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NHoldFirst is an attribute which specifies that the first argument to a \
function should not be affected by N. ", "synonyms" -> {"hold first"}, 
    "title" -> "NHoldFirst", "type" -> "Symbol", "uri" -> "ref/NHoldFirst"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3664, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20348, 794}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2337, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2960, 82, 48, 1, 70, "ObjectName",
 CellID->25162],
Cell[3011, 85, 616, 19, 70, "Usage",
 CellID->8358]
}, Open  ]],
Cell[CellGroupData[{
Cell[3664, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4041, 123, 148, 5, 70, "ExampleSection",
 CellID->951144012],
Cell[4192, 130, 224, 8, 70, "ExampleText",
 CellID->98927649],
Cell[4419, 140, 139, 4, 70, "Input",
 CellID->4075639],
Cell[CellGroupData[{
Cell[4583, 148, 150, 5, 28, "Input",
 CellID->654359576],
Cell[4736, 155, 224, 7, 36, "Output",
 CellID->93200572]
}, Open  ]],
Cell[CellGroupData[{
Cell[4997, 167, 176, 6, 28, "Input",
 CellID->334661698],
Cell[5176, 175, 259, 8, 36, "Output",
 CellID->294081590]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5484, 189, 216, 7, 70, "ExampleSection",
 CellID->26010],
Cell[5703, 198, 221, 8, 70, "ExampleText",
 CellID->115115300],
Cell[CellGroupData[{
Cell[5949, 210, 514, 17, 70, "Input",
 CellID->20129150],
Cell[6466, 229, 482, 12, 71, "Output",
 CellID->264578762]
}, Open  ]],
Cell[6963, 244, 125, 3, 70, "ExampleDelimiter",
 CellID->408841256],
Cell[7091, 249, 398, 14, 70, "ExampleText",
 CellID->384522430],
Cell[CellGroupData[{
Cell[7514, 267, 181, 6, 70, "Input",
 CellID->549513507],
Cell[7698, 275, 244, 8, 36, "Output",
 CellID->79808160]
}, Open  ]],
Cell[7957, 286, 260, 10, 70, "ExampleText",
 CellID->151377661],
Cell[CellGroupData[{
Cell[8242, 300, 99, 3, 70, "Input",
 CellID->38624791],
Cell[8344, 305, 282, 9, 36, "Output",
 CellID->204131781]
}, Open  ]],
Cell[8641, 317, 228, 8, 70, "ExampleText",
 CellID->138615536],
Cell[CellGroupData[{
Cell[8894, 329, 164, 5, 70, "Input",
 CellID->711715932],
Cell[9061, 336, 253, 7, 36, "Output",
 CellID->2358007]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9363, 349, 223, 7, 70, "ExampleSection",
 CellID->19275],
Cell[9589, 358, 210, 9, 70, "ExampleText",
 CellID->786655052],
Cell[9802, 369, 925, 27, 70, "Input",
 CellID->489938302],
Cell[10730, 398, 300, 11, 70, "ExampleText",
 CellID->4970114],
Cell[11033, 411, 144, 4, 70, "Input",
 CellID->142526631],
Cell[11180, 417, 226, 9, 70, "ExampleText",
 CellID->67648367],
Cell[CellGroupData[{
Cell[11431, 430, 123, 4, 70, "Input",
 CellID->283199919],
Cell[11557, 436, 211, 7, 36, "Output",
 CellID->193981958]
}, Open  ]],
Cell[11783, 446, 198, 8, 70, "ExampleText",
 CellID->419285339],
Cell[CellGroupData[{
Cell[12006, 458, 97, 3, 70, "Input",
 CellID->410603361],
Cell[12106, 463, 211, 7, 36, "Output",
 CellID->301474006]
}, Open  ]],
Cell[12332, 473, 185, 6, 70, "ExampleText",
 CellID->26712399],
Cell[CellGroupData[{
Cell[12542, 483, 177, 6, 70, "Input",
 CellID->61932684],
Cell[12722, 491, 175, 5, 36, "Output",
 CellID->743080626]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12946, 502, 232, 7, 70, "ExampleSection",
 CellID->3435],
Cell[13181, 511, 370, 12, 70, "ExampleText",
 CellID->293430125],
Cell[13554, 525, 140, 4, 70, "Input",
 CellID->47837573],
Cell[CellGroupData[{
Cell[13719, 533, 166, 6, 70, "Input",
 CellID->160953],
Cell[13888, 541, 232, 8, 36, "Output",
 CellID->18638555]
}, Open  ]],
Cell[CellGroupData[{
Cell[14157, 554, 97, 3, 70, "Input",
 CellID->123348454],
Cell[14257, 559, 263, 9, 36, "Output",
 CellID->112120584]
}, Open  ]],
Cell[14535, 571, 141, 4, 70, "Input",
 CellID->21768317],
Cell[CellGroupData[{
Cell[14701, 579, 169, 6, 70, "Input",
 CellID->137692413],
Cell[14873, 587, 209, 7, 36, "Output",
 CellID->182093225]
}, Open  ]],
Cell[CellGroupData[{
Cell[15119, 599, 97, 3, 70, "Input",
 CellID->195540706],
Cell[15219, 604, 211, 7, 36, "Output",
 CellID->118885855]
}, Open  ]],
Cell[15445, 614, 91, 1, 70, "ExampleText",
 CellID->200417411],
Cell[15539, 617, 198, 6, 70, "Input",
 CellID->217759067],
Cell[CellGroupData[{
Cell[15762, 627, 168, 6, 70, "Input",
 CellID->152019579],
Cell[15933, 635, 232, 8, 36, "Output",
 CellID->639594708]
}, Open  ]],
Cell[CellGroupData[{
Cell[16202, 648, 96, 3, 70, "Input",
 CellID->41745134],
Cell[16301, 653, 233, 8, 36, "Output",
 CellID->49129660]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16595, 668, 310, 9, 70, "SeeAlsoSection",
 CellID->6372],
Cell[16908, 679, 959, 35, 70, "SeeAlso",
 CellID->32702]
}, Open  ]],
Cell[CellGroupData[{
Cell[17904, 719, 314, 9, 70, "TutorialsSection",
 CellID->28220],
Cell[18221, 730, 131, 3, 70, "Tutorials",
 CellID->30437],
Cell[18355, 735, 177, 3, 70, "Tutorials",
 CellID->126352843]
}, Open  ]],
Cell[CellGroupData[{
Cell[18569, 743, 299, 8, 70, "MoreAboutSection"],
Cell[18871, 753, 132, 3, 70, "MoreAbout",
 CellID->629679200],
Cell[19006, 758, 147, 3, 70, "MoreAbout",
 CellID->282400684]
}, Open  ]],
Cell[19168, 764, 27, 0, 70, "History"],
Cell[19198, 766, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

