(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28405,       1102]
NotebookOptionsPosition[     21668,        862]
NotebookOutlinePosition[     23017,        901]
CellTagsIndexPosition[     22932,        896]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Controlling Numerical Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingNumericalEvaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Controlling Numerical Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NHoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/NHoldFirst"], "NHoldAll" :> 
          Documentation`HelpLookup["paclet:ref/NHoldAll"], "NumericFunction" :> 
          Documentation`HelpLookup["paclet:ref/NumericFunction"], "HoldRest" :> 
          Documentation`HelpLookup["paclet:ref/HoldRest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NHoldFirst\"\>", 
       2->"\<\"NHoldAll\"\>", 3->"\<\"NumericFunction\"\>", 
       4->"\<\"HoldRest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NHoldRest", "ObjectName",
 CellID->25847],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NHoldRest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that all but the first \
argument to a function should not be affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15719]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->155226897],

Cell[TextData[{
 "Prevent ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " from affecting all but the first argument of a function:"
}], "ExampleText",
 CellID->98927649],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NHoldRest"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4075639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Pi", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->654359576],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"3.141592653589793`", ",", "3"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->395088418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"E", ",", "Pi"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->334661698],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"2.71828182845904523536028747135266249776`20.", ",", "\[Pi]"}], 
  "]"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18551570]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2466],

Cell[TextData[{
 "System symbols with the ",
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->115115300],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ssymb", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], "]"}], ",", 
     "_Symbol"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Select", "[", 
  RowBox[{"ssymb", ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Attributes", "[", "#", "]"}], ",", "NHoldRest"}], "]"}], 
    "&"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->20129150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Drop", ",", "Extract", ",", "GraphicsComplex", ",", "HeldPart", ",", 
   "Overscript", ",", "Part", ",", "Subscript", ",", "Subsuperscript", ",", 
   "Superscript", ",", "Take", ",", "Underoverscript", ",", "Underscript"}], 
  "}"}]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1387590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418490313],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " symbolically:"
}], "ExampleText",
 CellID->162096730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", " ", 
  RowBox[{"Quiet", "[", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "+", 
    RowBox[{"x", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}], " ", "-", " ", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->562361870],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"x", "\[LeftDoubleBracket]", 
   RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], "+", 
  RowBox[{
  "x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->602924599]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " does not affect the specified parts:"
}], "ExampleText",
 CellID->778099821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ne", " ", "=", " ", 
  RowBox[{"Quiet", "[", 
   RowBox[{"N", "[", "e", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->353647330],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.`"}], "+", 
  RowBox[{"x", "\[LeftDoubleBracket]", 
   RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], "+", 
  RowBox[{
  "x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74604768]
}, Open  ]],

Cell[TextData[{
 "The expression works when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is substituted with a list:"
}], "ExampleText",
 CellID->26572090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ne", " ", "/.", " ", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8"}], "}"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28946381],

Cell[BoxData["9.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->93707224]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7887],

Cell[TextData[{
 "Define a function that represents the real-valued root  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"1", "/", "n"}]], TraditionalForm]], "InlineMath"],
 " for positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and positive integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->80110771],

Cell[BoxData[
 RowBox[{
  RowBox[{"nthroot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "?", "InexactNumberQ"}], " ", "/;", " ", 
     RowBox[{"Positive", "[", "x", "]"}]}], ",", 
    RowBox[{"n_Integer", "/;", 
     RowBox[{"Positive", "[", "n", "]"}]}]}], "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], " ", 
         RowBox[{"#", "^", "n"}]}], " ", "+", " ", "x"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"n", " ", 
        RowBox[{"#", "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], "&"}], ",", 
    RowBox[{"N", "[", 
     RowBox[{"1", ",", 
      RowBox[{"Precision", "[", "x", "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141147017],

Cell[TextData[{
 "Prevent its second argument from being converted to real using ",
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->711531574],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"nthroot", ",", " ", "NHoldRest"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22712307],

Cell["An exact representation of the cube root of 2:", "ExampleText",
 CellID->377440979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"crt", "=", 
  RowBox[{"nthroot", "[", 
   RowBox[{"2", ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->608601075],

Cell[BoxData[
 RowBox[{"nthroot", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144652799]
}, Open  ]],

Cell["Machine-number approximation:", "ExampleText",
 CellID->158336978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "crt", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7375132],

Cell[BoxData["1.259921049894873`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->183447890]
}, Open  ]],

Cell["47-digit approximation:", "ExampleText",
 CellID->14214760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"crt", ",", "47"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->8800314],

Cell[BoxData["1.2599210498948731647672106072782283505702514647015079800819`47.\
"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->58761369]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14473],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subscript"]], "InlineFormula"],
 " by default has the ",
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->849253738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Subscript", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348499892],

Cell[BoxData[
 RowBox[{"{", "NHoldRest", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64669993]
}, Open  ]],

Cell[TextData[{
 "This means that subscripts generally do not change under ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->412689949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"i", "+", "1"}], ")"}], 
     RowBox[{"Subscript", "[", 
      RowBox[{"a", ",", "i"}], "]"}], " ", 
     RowBox[{"x", "^", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68311171],

Cell[BoxData[
 RowBox[{
  SubscriptBox["a", "0"], "+", 
  RowBox[{"2", " ", "x", " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"], " ", 
   SubscriptBox["a", "4"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "5"], " ", 
   SubscriptBox["a", "5"]}]}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249057577]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "poly", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->989441331],

Cell[BoxData[
 RowBox[{
  SubscriptBox["a", "0"], "+", 
  RowBox[{"2.`", " ", "x", " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{"3.`", " ", 
   SuperscriptBox["x", "2"], " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{"4.`", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{"5.`", " ", 
   SuperscriptBox["x", "4"], " ", 
   SubscriptBox["a", "4"]}], "+", 
  RowBox[{"6.`", " ", 
   SuperscriptBox["x", "5"], " ", 
   SubscriptBox["a", "5"]}]}]], "Output",
 ImageSize->{300, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100766202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236972060],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 " prevents evaluation while ",
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 " only prevents numerical evaluation:"
}], "ExampleText",
 CellID->293430125],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f1", ",", "HoldRest"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47837573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160953],

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92677825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->123348454],

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{"1.`", ",", 
   RowBox[{"2.`", "\[InvisibleSpace]", "+", "3.`"}]}], "]"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->372077348]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f2", ",", "NHoldRest"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21768317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"1", ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->137692413],

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"1", ",", "5"}], "]"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->44152755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->195540706],

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"1.`", ",", "5"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->606729995]
}, Open  ]],

Cell["You can prevent both by setting both attributes:", "ExampleText",
 CellID->200417411],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"HoldRest", ",", "NHoldRest"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->217759067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->152019579],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->339973850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->41745134],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1.`", ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->343333253]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12048],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldRest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldRest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30883],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->18614],

Cell[TextData[ButtonBox["Controlling Numerical Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingNumericalEvaluation"]], "Tutorials",
 CellID->126352843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->31948749],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->5489426]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NHoldRest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 6.6696722}", "context" -> "System`", 
    "keywords" -> {
     "index variables", "numerical evaluation control", 
      "suppressing numerical evaluation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NHoldRest is an attribute which specifies that all but the first \
argument to a function should not be affected by N. ", 
    "synonyms" -> {"hold rest"}, "title" -> "NHoldRest", "type" -> "Symbol", 
    "uri" -> "ref/NHoldRest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3670, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22797, 889}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2337, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2960, 82, 47, 1, 70, "ObjectName",
 CellID->25847],
Cell[3010, 85, 623, 19, 70, "Usage",
 CellID->15719]
}, Open  ]],
Cell[CellGroupData[{
Cell[3670, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4047, 123, 148, 5, 70, "ExampleSection",
 CellID->155226897],
Cell[4198, 130, 232, 8, 70, "ExampleText",
 CellID->98927649],
Cell[4433, 140, 138, 4, 70, "Input",
 CellID->4075639],
Cell[CellGroupData[{
Cell[4596, 148, 150, 5, 28, "Input",
 CellID->654359576],
Cell[4749, 155, 225, 7, 36, "Output",
 CellID->395088418]
}, Open  ]],
Cell[CellGroupData[{
Cell[5011, 167, 176, 6, 28, "Input",
 CellID->334661698],
Cell[5190, 175, 258, 8, 36, "Output",
 CellID->18551570]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5497, 189, 215, 7, 70, "ExampleSection",
 CellID->2466],
Cell[5715, 198, 219, 8, 70, "ExampleText",
 CellID->115115300],
Cell[CellGroupData[{
Cell[5959, 210, 513, 17, 70, "Input",
 CellID->20129150],
Cell[6475, 229, 416, 11, 54, "Output",
 CellID->1387590]
}, Open  ]],
Cell[6906, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->418490313],
Cell[7034, 248, 192, 8, 70, "ExampleText",
 CellID->162096730],
Cell[CellGroupData[{
Cell[7251, 260, 316, 11, 70, "Input",
 CellID->562361870],
Cell[7570, 273, 365, 11, 36, "Output",
 CellID->602924599]
}, Open  ]],
Cell[7950, 287, 211, 8, 70, "ExampleText",
 CellID->778099821],
Cell[CellGroupData[{
Cell[8186, 299, 164, 5, 70, "Input",
 CellID->353647330],
Cell[8353, 306, 366, 11, 36, "Output",
 CellID->74604768]
}, Open  ]],
Cell[8734, 320, 173, 6, 70, "ExampleText",
 CellID->26572090],
Cell[CellGroupData[{
Cell[8932, 330, 191, 6, 70, "Input",
 CellID->28946381],
Cell[9126, 338, 159, 5, 36, "Output",
 CellID->93707224]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9334, 349, 222, 7, 70, "ExampleSection",
 CellID->7887],
Cell[9559, 358, 407, 14, 70, "ExampleText",
 CellID->80110771],
Cell[9969, 374, 870, 28, 70, "Input",
 CellID->141147017],
Cell[10842, 404, 248, 8, 70, "ExampleText",
 CellID->711531574],
Cell[11093, 414, 150, 4, 70, "Input",
 CellID->22712307],
Cell[11246, 420, 89, 1, 70, "ExampleText",
 CellID->377440979],
Cell[CellGroupData[{
Cell[11360, 425, 152, 5, 70, "Input",
 CellID->608601075],
Cell[11515, 432, 214, 7, 36, "Output",
 CellID->144652799]
}, Open  ]],
Cell[11744, 442, 72, 1, 70, "ExampleText",
 CellID->158336978],
Cell[CellGroupData[{
Cell[11841, 447, 97, 3, 70, "Input",
 CellID->7375132],
Cell[11941, 452, 175, 5, 36, "Output",
 CellID->183447890]
}, Open  ]],
Cell[12131, 460, 65, 1, 70, "ExampleText",
 CellID->14214760],
Cell[CellGroupData[{
Cell[12221, 465, 121, 4, 70, "Input",
 CellID->8800314],
Cell[12345, 471, 223, 6, 36, "Output",
 CellID->58761369]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12617, 483, 233, 7, 70, "ExampleSection",
 CellID->14473],
Cell[12853, 492, 336, 12, 70, "ExampleText",
 CellID->849253738],
Cell[CellGroupData[{
Cell[13214, 508, 114, 3, 70, "Input",
 CellID->348499892],
Cell[13331, 513, 187, 6, 36, "Output",
 CellID->64669993]
}, Open  ]],
Cell[13533, 522, 226, 8, 70, "ExampleText",
 CellID->412689949],
Cell[CellGroupData[{
Cell[13784, 534, 384, 13, 70, "Input",
 CellID->68311171],
Cell[14171, 549, 623, 21, 36, "Output",
 CellID->249057577]
}, Open  ]],
Cell[CellGroupData[{
Cell[14831, 575, 100, 3, 70, "Input",
 CellID->989441331],
Cell[14934, 580, 633, 21, 36, "Output",
 CellID->100766202]
}, Open  ]],
Cell[15582, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->236972060],
Cell[15710, 609, 366, 12, 70, "ExampleText",
 CellID->293430125],
Cell[16079, 623, 139, 4, 70, "Input",
 CellID->47837573],
Cell[CellGroupData[{
Cell[16243, 631, 142, 5, 70, "Input",
 CellID->160953],
Cell[16388, 638, 232, 8, 36, "Output",
 CellID->92677825]
}, Open  ]],
Cell[CellGroupData[{
Cell[16657, 651, 97, 3, 70, "Input",
 CellID->123348454],
Cell[16757, 656, 260, 8, 36, "Output",
 CellID->372077348]
}, Open  ]],
Cell[17032, 667, 140, 4, 70, "Input",
 CellID->21768317],
Cell[CellGroupData[{
Cell[17197, 675, 145, 5, 70, "Input",
 CellID->137692413],
Cell[17345, 682, 208, 7, 36, "Output",
 CellID->44152755]
}, Open  ]],
Cell[CellGroupData[{
Cell[17590, 694, 97, 3, 70, "Input",
 CellID->195540706],
Cell[17690, 699, 211, 7, 36, "Output",
 CellID->606729995]
}, Open  ]],
Cell[17916, 709, 91, 1, 70, "ExampleText",
 CellID->200417411],
Cell[18010, 712, 196, 6, 70, "Input",
 CellID->217759067],
Cell[CellGroupData[{
Cell[18231, 722, 144, 5, 70, "Input",
 CellID->152019579],
Cell[18378, 729, 232, 8, 36, "Output",
 CellID->339973850]
}, Open  ]],
Cell[CellGroupData[{
Cell[18647, 742, 96, 3, 70, "Input",
 CellID->41745134],
Cell[18746, 747, 234, 8, 36, "Output",
 CellID->343333253]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19041, 762, 311, 9, 70, "SeeAlsoSection",
 CellID->12048],
Cell[19355, 773, 958, 35, 70, "SeeAlso",
 CellID->3195]
}, Open  ]],
Cell[CellGroupData[{
Cell[20350, 813, 314, 9, 70, "TutorialsSection",
 CellID->30883],
Cell[20667, 824, 131, 3, 70, "Tutorials",
 CellID->18614],
Cell[20801, 829, 177, 3, 70, "Tutorials",
 CellID->126352843]
}, Open  ]],
Cell[CellGroupData[{
Cell[21015, 837, 299, 8, 70, "MoreAboutSection"],
Cell[21317, 847, 131, 3, 70, "MoreAbout",
 CellID->31948749],
Cell[21451, 852, 145, 3, 70, "MoreAbout",
 CellID->5489426]
}, Open  ]],
Cell[21611, 858, 27, 0, 70, "History"],
Cell[21641, 860, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

