(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66085,       2457]
NotebookOptionsPosition[     52618,       1979]
NotebookOutlinePosition[     54132,       2019]
CellTagsIndexPosition[     54046,       2014]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Sums, Products and Integrals" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalSumsProductsAndIntegrals"], 
          "Numerical Mathematics in Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsInMathematica"], 
          "Numerical Evaluation of Sums and Products" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalEvaluationOfSumsAndProducts"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Sums, Products and Integrals\"\>", 
       2->"\<\"Numerical Mathematics in Mathematica\"\>", 
       3->"\<\"Numerical Evaluation of Sums and Products\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Product" :> Documentation`HelpLookup["paclet:ref/Product"], 
          "NSum" :> Documentation`HelpLookup["paclet:ref/NSum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Product\"\>", 
       2->"\<\"NSum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NProduct", "ObjectName",
 CellID->24730],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NProduct",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NProduct"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the product ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{
         StyleBox["i", "TI"], "=", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NProduct",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NProduct"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses a step ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     " in the product. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " can be used for products with both finite and infinite limits. "
}], "Notes",
 CellID->6589],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NProduct"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["j", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be used to evaluate multidimensional products. "
}], "Notes",
 CellID->14510],

Cell["The following options can be given: ", "Notes",
 CellID->23437],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "number of digits of final accuracy sought", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "expression to evaluate whenever ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is evaluated "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of digits of final precision sought", "TableText"]},
   {Cell["      ", "TableRowIcon"], "VerifyConvergence", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to explicitly test for convergence ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->32012],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option include:"
}], "Notes",
 CellID->7845],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EulerMaclaurin\>\"", Cell["\<\
Euler\[Dash]Maclaurin summation method\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WynnEpsilon\>\"", Cell[
    "Wynn epsilon extrapolation method", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->31308],

Cell[TextData[{
 "With the Euler\[Dash]Maclaurin method, the options ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " can be used to specify the accuracy and precision to try and get in the \
final answer. ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " stops when the error estimates it gets imply that either the accuracy or \
precision sought has been reached. "
}], "Notes",
 CellID->28146],

Cell[TextData[{
 "You should realize that in sufficiently pathological cases, the algorithms \
used by ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " can give wrong answers. In most cases, you can test the answer by looking \
at its sensitivity to changes in the setting of options for ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26460],

Cell[TextData[{
 Cell[BoxData["VerifyConvergence"], "InlineFormula"],
 " is only used for products with infinite limits. "
}], "Notes",
 CellID->1405],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    ButtonBox["Product",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Product"], "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " first localizes the values of all variables, then evaluates ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " with the variables being symbolic, and then repeatedly evaluates the \
result numerically."
}], "Notes",
 CellID->18513],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and effectively uses ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to localize variables."
}], "Notes",
 CellID->7675]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->471717464],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->787992163],

Cell["Approximate an infinite product numerically:", "ExampleText",
 CellID->226825228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"i", "^", "2"}]}]}], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12053745],

Cell[BoxData["3.6760779100585657`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34003575]
}, Open  ]],

Cell[TextData[{
 "The error versus the exact value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sinh", "(", "\[Pi]", ")"}], "/", "\[Pi]"}], TraditionalForm]]],
 ":"
}], "ExampleText",
 CellID->90781056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", 
  RowBox[{
   RowBox[{"Sinh", "[", "\[Pi]", "]"}], "/", "\[Pi]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39174757],

Cell[BoxData[
 RowBox[{"-", "3.164117856613302`*^-10"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->706617382]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22243445],

Cell["Approximate the value of a finite product:", "ExampleText",
 CellID->715570151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", 
     RowBox[{"i", "^", "2"}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "100", ",", " ", 
     RowBox[{"10", "^", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73359430],

Cell[BoxData["1.0000504316971588`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134337850]
}, Open  ]],

Cell["This is effectively the ratio of two infinite products:", "ExampleText",
 CellID->39454065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", 
      RowBox[{"i", "^", "2"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "100", ",", " ", "\[Infinity]"}], "}"}]}], "]"}], 
  " ", "/", 
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", 
      RowBox[{"i", "^", "2"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "  ", 
      RowBox[{"10", "^", "4"}], ",", " ", "\[Infinity]"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42115105],

Cell[BoxData["1.000050421696656`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112524501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11272844],

Cell["Approximate a multidimensional product:", "ExampleText",
 CellID->39868800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "n"}], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "n"}], ")"}], "^", "k"}], "/", 
      RowBox[{"k", "^", "2"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->552226847],

Cell[BoxData["0.8123313656455685`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75587874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->757934043],

Cell["\<\
Approximate a multidimensional product with the second index depending on the \
first:\
\>", "ExampleText",
 CellID->923515544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "n"}], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "n"}], ")"}], "^", "k"}], "/", 
      RowBox[{"k", "^", "2"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->945501495],

Cell[BoxData["0.5640967215994084`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274077630]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->492849990],

Cell["Complex infinite product approximation:", "ExampleText",
 CellID->266585647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", " ", "+", " ", 
    RowBox[{
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"I", " ", "n", " ", 
        RowBox[{"2", "/", "3"}]}], ")"}]}], "/", 
     RowBox[{"n", "^", "2"}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->858603866],

Cell[BoxData[
 RowBox[{"1.4370622465169092`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.0794499043020052`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52182948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->497703030],

Cell["Multiply the even factors of an infinite product:", "ExampleText",
 CellID->144564436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", 
     RowBox[{"2", "^", "i"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "\[Infinity]", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310085196],

Cell[BoxData["2.711819347726958`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501870642]
}, Open  ]],

Cell["An equivalent way of specifying the same multiplication:", "ExampleText",
 CellID->105472116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"2", "j"}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->642821719],

Cell[BoxData["2.711819347726958`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272519639]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2108864447],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AccuracyGoal and PrecisionGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->906276870],

Cell["Approximate a product with the default tolerances:", "ExampleText",
 CellID->313601664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"n", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->518750079],

Cell[BoxData["3.6760779100585657`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332771103]
}, Open  ]],

Cell["Find the error versus the exact value:", "ExampleText",
 CellID->482113350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exact", "=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"n", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97020561],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sinh", "[", "\[Pi]", "]"}], "\[Pi]"]], "Output",
 ImageSize->{59, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36011647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "-", "exact"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->129873791],

Cell[BoxData[
 RowBox[{"-", "3.164117856613302`*^-10"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->239466145]
}, Open  ]],

Cell["The error with smaller absolute and relative tolerances:", "ExampleText",
 CellID->76531130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"n", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "4"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "4"}]}], "]"}], "-", 
  "exact"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->105238400],

Cell[BoxData["1.2599136445246018`*^-7"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->583357455]
}, Open  ]],

Cell["The error with larger absolute and relative tolerances:", "ExampleText",
 CellID->361447028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"n", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "8"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "8"}]}], "]"}], "-", 
  "exact"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->394312397],

Cell[BoxData["3.772093748466432`*^-12"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->423147008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->160946707],

Cell["\<\
Get the number of evaluation points used in a product approximation:\
\>", "ExampleText",
 CellID->353531660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NProduct", "[", 
      RowBox[{
       RowBox[{"1", "+", 
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "n"}], "+", "1"}], ")"}], "2"]]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"k", "++"}]}]}], "]"}], ",", "k"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->711990419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2545892393073292`", ",", "114"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93596901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33802175],

Cell["\<\
The evaluation points used in a product approximated by an integration \
method:\
\>", "ExampleText",
 CellID->17998260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{"NProduct", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "2"]]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "n", "]"}]}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->650141528],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlH1MVWUcx6+Xi9AgsbKgwImoWM7pPSAXefN+ebsX5V7kvr8RG3dmzuF0
BlhU7qDltCRaWw2y6VauFHI6V/6hsg6+TY2tZNxcuN42K724vFNRlrWlnO+v
P3y2u9++z/d8z/09n+c5z9zoRvdLRoPBsPnB72HVR8Kq18XgBOsi1lTW51ln
suazzmKdz5rFmseaw5r7SM155DnJyXvkvfI/8r/Sh/QlfUrfsg5Z1xLxOczo
mEwJtbW3cF7Bog3bb+87UEldgJ3vTGs+lmehLsTPf+2aHfYVUC9D+UQs7Ztz
ZuoiyHv1akGX+fP8styl1MVYt9k62NsnfSyHkmcf0uyiSzDv/t6SwmdFlyK9
dHoo2yS6TO/3w03U5fCMTf/T6nJQVyDj6aSTrbUrqFdg8Kenyr7ql/6teC0+
kLm1u5Aa/69zqqhgvwrnK9kv16NWsl9ZXxX7Fb+K/YpfjSvb73yQZmT/ajV2
3Wqf50iX9dQg/sIbEzvmil+DU3+fSD5fJX4tZuxpjrdvEr8WA/0Ph/g29L5p
HPohIb4N5d/mf2mA8LZjofJi0fUeatWOK9GBS7NHxK/DcHdSV/ye+HU63wUq
/ZU630tB+ivJ105/FTpPLOxY57PSX4Vbo4Gl/zxXQr+elfzVehhbHM4OLOO8
A99d3dqpFHI/VAeiNe9t6+qR8+WE7W7FK2sLZH+cyGpLP2pJFb+BfIV/A/kK
/9XkK/5q8hW/kXyp0Ui+8nwj+VJrjeQr58NFvtRwkS+16iJfas2F8UTG0Wtj
Pcy7db5PvMy8W+d71sO8m3zrmHeTbxXzfM7A8w4PTKd6P76hljLvwd4L/96J
rl3OvAdnduYkJ80pZs6L3Tde/2N4DfcHXpivZa3ZMFP2y4tjKdcXZJrIW/Pi
yd/Hbb1Zwt+HUc9k/PFqavjw1sSWtPfflv3yIdsyODr+q+R98E0N+f78UO6b
th36jRp+vPqRMzhN5flQ/WiIHl8/Mof3iubH12f9n5Xtl3smgL7sFGPsJjUC
Ot9P9zEf0PkqHcwHdL7JUeaDOt+Yl/kgrh483DxZ5GSe597A864Fybea8yHy
5X2JEPnyXlFDyPzx3nDfBe6PFkLL98r5sVy5n8JozRipX5Iq/MOYf/Fyt1kR
/mEc+CIRy95BrYWRMn7zmdw02b8ILK2dBy8PUSOCqePbz/1WI4jefcwUOc3v
UYsgsXjPEeODe1TPN+GTM22x/dZy5puw/t1Dti11Fcw3oaB4hqn/lwr8B6VD
mIs=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 114.}, {0., 64.10498721159531}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109986364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119193572],

Cell["\<\
The evaluation points used in a product approximated by a sequence \
extrapolation method:\
\>", "ExampleText",
 CellID->606763501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{"NProduct", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "2"]]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "n", "]"}]}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302137647],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 14.}, {2., 13.}, {3., 12.}, {4., 11.}, {5., 10.}, {6., 
     9.}, {7., 8.}, {8., 7.}, {9., 6.}, {10., 5.}, {11., 4.}, {12., 3.}, {13.,
      2.}, {14., 1.}, {15., 0.}, {16., 15.}, {17., 16.}, {18., 17.}, {19., 
     18.}, {20., 19.}, {21., 20.}, {22., 21.}, {23., 22.}, {24., 23.}, {25., 
     24.}, {26., 25.}, {27., 26.}, {28., 27.}, {29., 28.}, {30., 29.}}]}, {}},
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 30.}, {0., 29.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80173857]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->61795497],

Cell["\<\
Use the Wynn epsilon method to approximate an infinite product:\
\>", "ExampleText",
 CellID->23850897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "2"]]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<WynnEpsilon\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->278174180],

Cell[BoxData["3.6733353855049202`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119780991]
}, Open  ]],

Cell["Compare to the exact value:", "ExampleText",
 CellID->145019020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exact", "=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "2"]]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36618609],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sinh", "[", "\[Pi]", "]"}], "\[Pi]"]], "Output",
 ImageSize->{59, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->998504867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "-", "exact"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->504154],

Cell[BoxData[
 RowBox[{"-", "0.002742524870057217`"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->116174070]
}, Open  ]],

Cell["The error is smaller with the default method:", "ExampleText",
 CellID->351976872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "2"]]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}], "-", 
  "exact"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22326231],

Cell[BoxData[
 RowBox[{"-", "3.164117856613302`*^-10"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->426259445]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "NProductFactors",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17976202],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " uses 15 factors at the beginning before approximating the tail:"
}], "ExampleText",
 CellID->14797858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "-", "20"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1511011986],

Cell[BoxData["12.856732194379108`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467047067]
}, Open  ]],

Cell["\<\
The error for this example is large because the factors peak at 20:\
\>", "ExampleText",
 CellID->337030487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exact", "=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "-", "20"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45631921],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "20"}], "-", "\[ImaginaryI]"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "20"}], "+", "\[ImaginaryI]"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "20"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["2"]}]}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["2"]}]}], "]"}]}]]], "Output",
 ImageSize->{248, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39392449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "-", "exact"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->830381387],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.044582961425211565`"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->255151912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "-", "20"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->687972278],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWM1uEzEQdta7ySkSQkrLJW1AQB+gHNoiVKQIgoRQDxXiHFVIzaEU9ect
2geoxIUKeAGq9gG4wIkrZ15k8Xi9tnc8u8wm3QBipaz92Z7xNz8eJ3kxPtp9
vTc+muyMB6OD8dvdyc7h4On+gRqSLSHEhfoc3xKqn6qe/lykqWr996p6SzUV
qTZS7UC1sYeXzbw0+A5IwYI0fyIzK8SD4pzRIqQbWYJXkmH7DlYte7h0PtgH
TG5By+RCa6nDo298JRJrjr+SwWHA2CHKxwuaSG7hXtfAYYkVVZollwPYKdr+
iuki8jsmq6nLV2hvIwz6udmenZ8biMH76Ubv29GPH75vPjo7PfnSdH8b9l2Z
23Z+X8Ta8i6M2dhoP6xbP3z7+nP/zeeryx9ZX43bPme8Vl8pUcSeDN+9evkp
66jBsr6zoo3imcyItVc2fI9x+Fjys3hgCg9n4zGZ2XfhtWAFOAxIF99EevU+
i2UeqmW0uId0S9ISqBiiQxLNNHRIBuKh1QYVYy3Q4rJI176Ob5PTskly0rql
49FHeFgh5XT3Eaal6MqleUlnQw/hUcH6x4hfD+FRxR6OXw9hWmq6+gsszyvW
mIJlHv/WASzzBYEcvp9iJMmTwnVCIjxE3u8i/JzUiqsXzAMcouh0EeZrCzm6
6HURprVqSwv3OO0xc3j10zbxxF7jR3s+OfXHMjfxv8+IUk/VzUJaClbF7Ez3
debMAJafpvJI11vtZ1CHZWnTkdf1zTvFCcJbhf2epcVTmiC8VbGHO4UJwrTU
vGssdPlx5taMZuXKs1aaWX7WVmE6e6NS9vOrV39t/fsnssqvVtW51CSrevfq
/5RX+X9kvGzKs9ADjURNf4vy7gj9Gz+4v8J/R/KKlcm7W6OOfMjD3SPbZlkg
c605GP67KVq/ACZSaoY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->624104277]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData["NProductFactors"], "InlineFormula"],
 " to include this feature improves the approximation:"
}], "ExampleText",
 CellID->276554093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"k", "-", "20"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"NProductFactors", "\[Rule]", "30"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->527822580],

Cell[BoxData["12.901315156139699`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->121917101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", "exact"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->370003863],

Cell[BoxData[
 RowBox[{"3.353797239924461`*^-10", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->93368326]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VerifyConvergence",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1635903],

Cell["By default the factor's convergence is verified:", "ExampleText",
 CellID->262495757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"k", ",", "3"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1660533051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.157`", ",", "3.1206419377163335`"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->658715793]
}, Open  ]],

Cell["\<\
Generally, if the convergence is not verified the computation is faster:\
\>", "ExampleText",
 CellID->75399569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"k", ",", "3"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"VerifyConvergence", "\[Rule]", "False"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1691205057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "3.1206419377163335`"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->431156]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->46877855],

Cell["Use higher precision to get a better approximation:", "ExampleText",
 CellID->557111647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pa", "=", 
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", "n"}]]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"2", " ", "n"}]]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2098564950],

Cell[BoxData["0.8455012816335291808872934128`17.206319471113506"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26842733]
}, Open  ]],

Cell["Find the error versus the exact value:", "ExampleText",
 CellID->394449208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pe", "=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", "n"}]]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"2", " ", "n"}]]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541855939],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "/", "2"}]]}], 
  SqrtBox["\[Pi]"]]], "Output",
 ImageSize->{91, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->480047787]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pe", "-", "pa"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->880559633],

Cell[BoxData["0``17.279205200864016"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->655735420]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->85002637],

Cell[TextData[{
 "Estimate the infinite product of a ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " sequence: "
}], "ExampleText",
 CellID->1285022925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", 
     RowBox[{"1", "/", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28805666],

Cell[BoxData["0.6503972585192618`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49702455]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392013976],

Cell[TextData[{
 "Use a product representation to approximate the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->253143714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"NProduct", "[", 
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Pi", "^", "2"}], " ", 
          RowBox[{"k", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222067751],

Cell[BoxData["0.47942553860523146`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435616450]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", "/", "2."}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218126839],

Cell[BoxData["0.479425538604203`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42906566]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->751857929],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " to compute exact formulae:"
}], "ExampleText",
 CellID->1888242911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exact", "=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "5"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1440448629],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     SqrtBox["5"]}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["5"]}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     SqrtBox["6"]}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["6"]}], "]"}]}]]], "Output",
 ImageSize->{187, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174793073]
}, Open  ]],

Cell[TextData[{
 "The results of ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " agree closely:"
}], "ExampleText",
 CellID->1447376270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NProduct", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "5"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}], "-", 
  "exact"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233626939],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.3678792260284354`*^-10"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2931662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->567852632],

Cell["\<\
A product is equivalent to the exponential of a sum of logarithms of factors:\
\
\>", "ExampleText",
 CellID->45240981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"NSum", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", 
        RowBox[{"n", "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", 
         RowBox[{"n", "^", "2"}]}], "-", "1"}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203044292],

Cell[BoxData["1.5707963267612874`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280042490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", 
      RowBox[{"n", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", 
       RowBox[{"n", "^", "2"}]}], "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->381759678],

Cell[BoxData["1.5707963267612879`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102253440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->133949735],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " may not detect divergence for some infinite products:"
}], "ExampleText",
 CellID->16581059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", "k"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1783999730],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->6263499],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(k\\) near \\!\\({k}\\) = \
\\!\\({6.132236402772647`*^28}\\). NIntegrate obtained \
\\!\\(23229.329407159807`\\) and \\!\\(19751.299458866175`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->36433483],

Cell[BoxData["3.86364619832005298969852037746224`15.954589770191005*^10089"], \
"Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270772254]
}, Open  ]],

Cell["\<\
Convergence verification is based on a ratio test that is inconclusive when \
equal to 1:\
\>", "ExampleText",
 CellID->267742979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}]}], "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", "k"}], "-", "1"}], ")"}]}], ",", 
   RowBox[{"k", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1833087983],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26268300]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6379],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9624]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20145],

Cell[TextData[ButtonBox["Numerical Sums, Products and Integrals",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalSumsProductsAndIntegrals"]], "Tutorials",
 CellID->22562],

Cell[TextData[{
 ButtonBox["Numerical Mathematics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsInMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsInMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->5895],

Cell[TextData[ButtonBox["Numerical Evaluation of Sums and Products",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalEvaluationOfSumsAndProducts"]], "Tutorials",
 CellID->32480]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 53.7817892}", "context" -> "System`", 
    "keywords" -> {
     "numerical product", "products", "sequence acceleration", "Wynn epsilon",
       "extrapolation method", "Euler-Maclaurin"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NProduct[f, {i, i_min, i_max}] gives a numerical approximation to the \
product UnderoverscriptBox[\"\\[Product]\", RowBox[{\"i\", \"=\", \
\"i_min\"}], \"i_max\", LimitsPositioning->True]\\ f. NProduct[f, {i, i_min, \
i_max, di}] uses a step di in the product. ", "synonyms" -> {}, "title" -> 
    "NProduct", "type" -> "Symbol", "uri" -> "ref/NProduct"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11404, 374, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->471717464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53902, 2007}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1736, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2359, 68, 46, 1, 70, "ObjectName",
 CellID->24730],
Cell[2408, 71, 1897, 62, 70, "Usage",
 CellID->29333]
}, Open  ]],
Cell[CellGroupData[{
Cell[4342, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4820, 155, 230, 7, 70, "Notes",
 CellID->6589],
Cell[5053, 164, 584, 20, 70, "Notes",
 CellID->14510],
Cell[5640, 186, 69, 1, 70, "Notes",
 CellID->23437],
Cell[5712, 189, 2237, 59, 70, "3ColumnTableMod",
 CellID->32012],
Cell[7952, 250, 209, 8, 70, "Notes",
 CellID->7845],
Cell[8164, 260, 511, 12, 70, "2ColumnTableMod",
 CellID->31308],
Cell[8678, 274, 694, 20, 70, "Notes",
 CellID->28146],
Cell[9375, 296, 520, 15, 70, "Notes",
 CellID->26460],
Cell[9898, 313, 150, 4, 70, "Notes",
 CellID->1405],
Cell[10051, 319, 462, 18, 70, "Notes",
 CellID->13741],
Cell[10516, 339, 381, 11, 70, "Notes",
 CellID->18513],
Cell[10900, 352, 467, 17, 70, "Notes",
 CellID->7675]
}, Closed]],
Cell[CellGroupData[{
Cell[11404, 374, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->471717464],
Cell[CellGroupData[{
Cell[11789, 388, 148, 5, 70, "ExampleSection",
 CellID->787992163],
Cell[11940, 395, 87, 1, 70, "ExampleText",
 CellID->226825228],
Cell[CellGroupData[{
Cell[12052, 400, 297, 10, 28, "Input",
 CellID->12053745],
Cell[12352, 412, 175, 5, 36, "Output",
 CellID->34003575]
}, Open  ]],
Cell[12542, 420, 214, 8, 70, "ExampleText",
 CellID->90781056],
Cell[CellGroupData[{
Cell[12781, 432, 154, 5, 28, "Input",
 CellID->39174757],
Cell[12938, 439, 198, 6, 36, "Output",
 CellID->706617382]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13185, 451, 219, 7, 70, "ExampleSection",
 CellID->22243445],
Cell[13407, 460, 85, 1, 70, "ExampleText",
 CellID->715570151],
Cell[CellGroupData[{
Cell[13517, 465, 380, 13, 70, "Input",
 CellID->73359430],
Cell[13900, 480, 176, 5, 36, "Output",
 CellID->134337850]
}, Open  ]],
Cell[14091, 488, 97, 1, 70, "ExampleText",
 CellID->39454065],
Cell[CellGroupData[{
Cell[14213, 493, 738, 26, 70, "Input",
 CellID->42115105],
Cell[14954, 521, 175, 5, 36, "Output",
 CellID->112524501]
}, Open  ]],
Cell[15144, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->11272844],
Cell[15271, 534, 81, 1, 70, "ExampleText",
 CellID->39868800],
Cell[CellGroupData[{
Cell[15377, 539, 532, 18, 70, "Input",
 CellID->552226847],
Cell[15912, 559, 175, 5, 36, "Output",
 CellID->75587874]
}, Open  ]],
Cell[16102, 567, 125, 3, 70, "ExampleDelimiter",
 CellID->757934043],
Cell[16230, 572, 137, 4, 70, "ExampleText",
 CellID->923515544],
Cell[CellGroupData[{
Cell[16392, 580, 522, 18, 70, "Input",
 CellID->945501495],
Cell[16917, 600, 176, 5, 36, "Output",
 CellID->274077630]
}, Open  ]],
Cell[17108, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->492849990],
Cell[17236, 613, 82, 1, 70, "ExampleText",
 CellID->266585647],
Cell[CellGroupData[{
Cell[17343, 618, 416, 14, 70, "Input",
 CellID->858603866],
Cell[17762, 634, 272, 7, 36, "Output",
 CellID->52182948]
}, Open  ]],
Cell[18049, 644, 125, 3, 70, "ExampleDelimiter",
 CellID->497703030],
Cell[18177, 649, 92, 1, 70, "ExampleText",
 CellID->144564436],
Cell[CellGroupData[{
Cell[18294, 654, 284, 10, 70, "Input",
 CellID->310085196],
Cell[18581, 666, 175, 5, 36, "Output",
 CellID->501870642]
}, Open  ]],
Cell[18771, 674, 99, 1, 70, "ExampleText",
 CellID->105472116],
Cell[CellGroupData[{
Cell[18895, 679, 321, 11, 70, "Input",
 CellID->642821719],
Cell[19219, 692, 175, 5, 36, "Output",
 CellID->272519639]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19443, 703, 223, 7, 70, "ExampleSection",
 CellID->2108864447],
Cell[CellGroupData[{
Cell[19691, 714, 251, 7, 70, "ExampleSubsection",
 CellID->906276870],
Cell[19945, 723, 93, 1, 70, "ExampleText",
 CellID->313601664],
Cell[CellGroupData[{
Cell[20063, 728, 300, 10, 70, "Input",
 CellID->518750079],
Cell[20366, 740, 176, 5, 36, "Output",
 CellID->332771103]
}, Open  ]],
Cell[20557, 748, 81, 1, 70, "ExampleText",
 CellID->482113350],
Cell[CellGroupData[{
Cell[20663, 753, 302, 10, 70, "Input",
 CellID->97020561],
Cell[20968, 765, 216, 7, 51, "Output",
 CellID->36011647]
}, Open  ]],
Cell[CellGroupData[{
Cell[21221, 777, 96, 3, 70, "Input",
 CellID->129873791],
Cell[21320, 782, 198, 6, 36, "Output",
 CellID->239466145]
}, Open  ]],
Cell[21533, 791, 98, 1, 70, "ExampleText",
 CellID->76531130],
Cell[CellGroupData[{
Cell[21656, 796, 412, 13, 70, "Input",
 CellID->105238400],
Cell[22071, 811, 180, 5, 36, "Output",
 CellID->583357455]
}, Open  ]],
Cell[22266, 819, 98, 1, 70, "ExampleText",
 CellID->361447028],
Cell[CellGroupData[{
Cell[22389, 824, 412, 13, 70, "Input",
 CellID->394312397],
Cell[22804, 839, 180, 5, 36, "Output",
 CellID->423147008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23033, 850, 238, 7, 70, "ExampleSubsection",
 CellID->160946707],
Cell[23274, 859, 119, 3, 70, "ExampleText",
 CellID->353531660],
Cell[CellGroupData[{
Cell[23418, 866, 638, 20, 70, "Input",
 CellID->711990419],
Cell[24059, 888, 223, 7, 36, "Output",
 CellID->93596901]
}, Open  ]],
Cell[24297, 898, 124, 3, 70, "ExampleDelimiter",
 CellID->33802175],
Cell[24424, 903, 130, 4, 70, "ExampleText",
 CellID->17998260],
Cell[CellGroupData[{
Cell[24579, 911, 596, 18, 70, "Input",
 CellID->650141528],
Cell[25178, 931, 1767, 38, 140, "Output",
 CellID->109986364]
}, Open  ]],
Cell[26960, 972, 125, 3, 70, "ExampleDelimiter",
 CellID->119193572],
Cell[27088, 977, 141, 4, 70, "ExampleText",
 CellID->606763501],
Cell[CellGroupData[{
Cell[27254, 985, 682, 21, 70, "Input",
 CellID->302137647],
Cell[27939, 1008, 812, 21, 139, "Output",
 CellID->80173857]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28800, 1035, 226, 7, 70, "ExampleSubsection",
 CellID->61795497],
Cell[29029, 1044, 113, 3, 70, "ExampleText",
 CellID->23850897],
Cell[CellGroupData[{
Cell[29167, 1051, 422, 14, 70, "Input",
 CellID->278174180],
Cell[29592, 1067, 176, 5, 36, "Output",
 CellID->119780991]
}, Open  ]],
Cell[29783, 1075, 70, 1, 70, "ExampleText",
 CellID->145019020],
Cell[CellGroupData[{
Cell[29878, 1080, 358, 12, 70, "Input",
 CellID->36618609],
Cell[30239, 1094, 217, 7, 51, "Output",
 CellID->998504867]
}, Open  ]],
Cell[CellGroupData[{
Cell[30493, 1106, 93, 3, 70, "Input",
 CellID->504154],
Cell[30589, 1111, 195, 6, 36, "Output",
 CellID->116174070]
}, Open  ]],
Cell[30799, 1120, 88, 1, 70, "ExampleText",
 CellID->351976872],
Cell[CellGroupData[{
Cell[30912, 1125, 362, 13, 70, "Input",
 CellID->22326231],
Cell[31277, 1140, 198, 6, 36, "Output",
 CellID->426259445]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31524, 1152, 235, 7, 70, "ExampleSubsection",
 CellID->17976202],
Cell[31762, 1161, 256, 8, 70, "ExampleText",
 CellID->14797858],
Cell[CellGroupData[{
Cell[32043, 1173, 420, 14, 70, "Input",
 CellID->1511011986],
Cell[32466, 1189, 176, 5, 36, "Output",
 CellID->467047067]
}, Open  ]],
Cell[32657, 1197, 118, 3, 70, "ExampleText",
 CellID->337030487],
Cell[CellGroupData[{
Cell[32800, 1204, 421, 14, 70, "Input",
 CellID->45631921],
Cell[33224, 1220, 676, 24, 61, "Output",
 CellID->39392449]
}, Open  ]],
Cell[CellGroupData[{
Cell[33937, 1249, 96, 3, 70, "Input",
 CellID->830381387],
Cell[34036, 1254, 256, 8, 36, "Output",
 CellID->255151912]
}, Open  ]],
Cell[CellGroupData[{
Cell[34329, 1267, 493, 16, 70, "Input",
 CellID->687972278],
Cell[34825, 1285, 1148, 23, 70, "Output",
 Evaluatable->False,
 CellID->624104277]
}, Open  ]],
Cell[35988, 1311, 178, 5, 70, "ExampleText",
 CellID->276554093],
Cell[CellGroupData[{
Cell[36191, 1320, 441, 14, 70, "Input",
 CellID->527822580],
Cell[36635, 1336, 176, 5, 36, "Output",
 CellID->121917101]
}, Open  ]],
Cell[CellGroupData[{
Cell[36848, 1346, 96, 3, 70, "Input",
 CellID->370003863],
Cell[36947, 1351, 239, 7, 36, "Output",
 CellID->93368326]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37235, 1364, 236, 7, 70, "ExampleSubsection",
 CellID->1635903],
Cell[37474, 1373, 91, 1, 70, "ExampleText",
 CellID->262495757],
Cell[CellGroupData[{
Cell[37590, 1378, 321, 11, 70, "Input",
 CellID->1660533051],
Cell[37914, 1391, 227, 7, 36, "Output",
 CellID->658715793]
}, Open  ]],
Cell[38156, 1401, 122, 3, 70, "ExampleText",
 CellID->75399569],
Cell[CellGroupData[{
Cell[38303, 1408, 382, 12, 70, "Input",
 CellID->1691205057],
Cell[38688, 1422, 220, 7, 36, "Output",
 CellID->431156]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38957, 1435, 236, 7, 70, "ExampleSubsection",
 CellID->46877855],
Cell[39196, 1444, 94, 1, 70, "ExampleText",
 CellID->557111647],
Cell[CellGroupData[{
Cell[39315, 1449, 532, 17, 70, "Input",
 CellID->2098564950],
Cell[39850, 1468, 206, 5, 36, "Output",
 CellID->26842733]
}, Open  ]],
Cell[40071, 1476, 81, 1, 70, "ExampleText",
 CellID->394449208],
Cell[CellGroupData[{
Cell[40177, 1481, 473, 16, 70, "Input",
 CellID->541855939],
Cell[40653, 1499, 311, 11, 58, "Output",
 CellID->480047787]
}, Open  ]],
Cell[CellGroupData[{
Cell[41001, 1515, 94, 3, 70, "Input",
 CellID->880559633],
Cell[41098, 1520, 178, 5, 36, "Output",
 CellID->655735420]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41337, 1532, 226, 7, 70, "ExampleSection",
 CellID->85002637],
Cell[41566, 1541, 227, 8, 70, "ExampleText",
 CellID->1285022925],
Cell[CellGroupData[{
Cell[41818, 1553, 281, 9, 70, "Input",
 CellID->28805666],
Cell[42102, 1564, 175, 5, 36, "Output",
 CellID->49702455]
}, Open  ]],
Cell[42292, 1572, 125, 3, 70, "ExampleDelimiter",
 CellID->392013976],
Cell[42420, 1577, 230, 8, 70, "ExampleText",
 CellID->253143714],
Cell[CellGroupData[{
Cell[42675, 1589, 567, 20, 70, "Input",
 CellID->222067751],
Cell[43245, 1611, 177, 5, 36, "Output",
 CellID->435616450]
}, Open  ]],
Cell[CellGroupData[{
Cell[43459, 1621, 123, 4, 70, "Input",
 CellID->218126839],
Cell[43585, 1627, 174, 5, 36, "Output",
 CellID->42906566]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43808, 1638, 237, 7, 70, "ExampleSection",
 CellID->751857929],
Cell[44048, 1647, 212, 8, 70, "ExampleText",
 CellID->1888242911],
Cell[CellGroupData[{
Cell[44285, 1659, 331, 11, 70, "Input",
 CellID->1440448629],
Cell[44619, 1672, 607, 22, 70, "Output",
 CellID->174793073]
}, Open  ]],
Cell[45241, 1697, 340, 13, 70, "ExampleText",
 CellID->1447376270],
Cell[CellGroupData[{
Cell[45606, 1714, 334, 12, 70, "Input",
 CellID->233626939],
Cell[45943, 1728, 257, 8, 36, "Output",
 CellID->2931662]
}, Open  ]],
Cell[46215, 1739, 125, 3, 70, "ExampleDelimiter",
 CellID->567852632],
Cell[46343, 1744, 129, 4, 70, "ExampleText",
 CellID->45240981],
Cell[CellGroupData[{
Cell[46497, 1752, 474, 17, 70, "Input",
 CellID->203044292],
Cell[46974, 1771, 176, 5, 36, "Output",
 CellID->280042490]
}, Open  ]],
Cell[CellGroupData[{
Cell[47187, 1781, 394, 14, 70, "Input",
 CellID->381759678],
Cell[47584, 1797, 176, 5, 36, "Output",
 CellID->102253440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47809, 1808, 230, 7, 70, "ExampleSection",
 CellID->133949735],
Cell[48042, 1817, 230, 7, 70, "ExampleText",
 CellID->16581059],
Cell[CellGroupData[{
Cell[48297, 1828, 246, 8, 70, "Input",
 CellID->1783999730],
Cell[48546, 1838, 520, 9, 70, "Message",
 CellID->6263499],
Cell[49069, 1849, 619, 11, 70, "Message",
 CellID->36433483],
Cell[49691, 1862, 220, 6, 36, "Output",
 CellID->270772254]
}, Open  ]],
Cell[49926, 1871, 140, 4, 70, "ExampleText",
 CellID->267742979],
Cell[CellGroupData[{
Cell[50091, 1879, 422, 14, 70, "Input",
 CellID->1833087983],
Cell[50516, 1895, 157, 5, 36, "Output",
 CellID->26268300]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50734, 1907, 310, 9, 70, "SeeAlsoSection",
 CellID->6379],
Cell[51047, 1918, 440, 17, 70, "SeeAlso",
 CellID->9624]
}, Open  ]],
Cell[CellGroupData[{
Cell[51524, 1940, 314, 9, 70, "TutorialsSection",
 CellID->20145],
Cell[51841, 1951, 185, 4, 70, "Tutorials",
 CellID->22562],
Cell[52029, 1957, 323, 9, 70, "Tutorials",
 CellID->5895],
Cell[52355, 1968, 191, 4, 70, "Tutorials",
 CellID->32480]
}, Open  ]],
Cell[52561, 1975, 27, 0, 70, "History"],
Cell[52591, 1977, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

