(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11917,        425]
NotebookOptionsPosition[      9061,        329]
NotebookOutlinePosition[     10339,        366]
CellTagsIndexPosition[     10254,        361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NSolve" :> Documentation`HelpLookup["paclet:ref/NSolve"], 
          "Roots" :> Documentation`HelpLookup["paclet:ref/Roots"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], "RootIntervals" :> 
          Documentation`HelpLookup["paclet:ref/RootIntervals"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NSolve\"\>", 2->"\<\"Roots\"\>", 
       3->"\<\"Solve\"\>", 4->"\<\"FindRoot\"\>", 
       5->"\<\"RootIntervals\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NRoots", "ObjectName",
 CellID->17248],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NRoots",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NRoots"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["lhs", "TI"], "==", 
         StyleBox["rhs", "TI"]}], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a disjunction of equations which represent \
numerical approximations to the roots of a polynomial equation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NRoots"]], "InlineFormula"],
 " gives several identical equations when roots with multiplicity greater \
than one occur. "
}], "Notes",
 CellID->21459]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24304303],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187454307],

Cell["Numerically find the roots of a polynomial:", "ExampleText",
 CellID->66905662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
     RowBox[{"4", " ", 
      RowBox[{"x", "^", "3"}]}]}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273168583],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "0.605829586188268`"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.07208520690586599`"}], "-", 
    RowBox[{"0.6383267351483765`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.07208520690586599`"}], "+", 
    RowBox[{"0.6383267351483765`", " ", "\[ImaginaryI]"}]}]}]}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105501405]
}, Open  ]],

Cell["Change the result to rules:", "ExampleText",
 CellID->352824898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ToRules", "[", "%", "]"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->656327094],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.605829586188268`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.07208520690586599`"}], "-", 
      RowBox[{"0.6383267351483765`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.07208520690586599`"}], "+", 
      RowBox[{"0.6383267351483765`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{509, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89541670]
}, Open  ]],

Cell["Test the roots:", "ExampleText",
 CellID->538827406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"3", " ", 
    RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
   RowBox[{"4", " ", 
    RowBox[{"x", "^", "3"}]}]}], " ", "/.", " ", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->901914394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1102230246251565`*^-16", ",", 
   RowBox[{"1.1102230246251565`*^-16", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.1102230246251565`*^-16", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{385, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->441898842]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21052],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Roots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootIntervals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootIntervals"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->787463636],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->132453613]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NRoots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 57.5787614}", "context" -> "System`", 
    "keywords" -> {"polynomial roots"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NRoots[lhs == rhs, var] yields a disjunction of equations which \
represent numerical approximations to the roots of a polynomial equation. ", 
    "synonyms" -> {}, "title" -> "NRoots", "type" -> "Symbol", "uri" -> 
    "ref/NRoots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3682, 120, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->24304303]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10112, 354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1536, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2159, 62, 44, 1, 70, "ObjectName",
 CellID->17248],
Cell[2206, 65, 671, 20, 70, "Usage",
 CellID->22636]
}, Open  ]],
Cell[CellGroupData[{
Cell[2914, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3392, 107, 253, 8, 70, "Notes",
 CellID->21459]
}, Closed]],
Cell[CellGroupData[{
Cell[3682, 120, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24304303],
Cell[CellGroupData[{
Cell[4066, 134, 148, 5, 70, "ExampleSection",
 CellID->187454307],
Cell[4217, 141, 85, 1, 70, "ExampleText",
 CellID->66905662],
Cell[CellGroupData[{
Cell[4327, 146, 346, 12, 28, "Input",
 CellID->273168583],
Cell[4676, 160, 555, 16, 36, "Output",
 CellID->105501405]
}, Open  ]],
Cell[5246, 179, 70, 1, 70, "ExampleText",
 CellID->352824898],
Cell[CellGroupData[{
Cell[5341, 184, 126, 4, 28, "Input",
 CellID->656327094],
Cell[5470, 190, 667, 21, 36, "Output",
 CellID->89541670]
}, Open  ]],
Cell[6152, 214, 58, 1, 70, "ExampleText",
 CellID->538827406],
Cell[CellGroupData[{
Cell[6235, 219, 278, 9, 70, "Input",
 CellID->901914394],
Cell[6516, 230, 409, 11, 39, "Output",
 CellID->441898842]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6986, 248, 311, 9, 70, "SeeAlsoSection",
 CellID->21052],
Cell[7300, 259, 1179, 44, 70, "SeeAlso",
 CellID->8683]
}, Open  ]],
Cell[CellGroupData[{
Cell[8516, 308, 319, 9, 70, "MoreAboutSection",
 CellID->787463636],
Cell[8838, 319, 151, 3, 70, "MoreAbout",
 CellID->132453613]
}, Open  ]],
Cell[9004, 325, 27, 0, 70, "History"],
Cell[9034, 327, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

