(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11624,        423]
NotebookOptionsPosition[      8445,        314]
NotebookOutlinePosition[      9698,        351]
CellTagsIndexPosition[      9614,        346]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Names" :> Documentation`HelpLookup["paclet:ref/Names"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Names\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Atomic Elements of Expressions\"\>",
        2->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NameQ", "ObjectName",
 CellID->29397],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NameQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NameQ"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if there are any symbols whose names match the string pattern given, \
and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can test for classes of symbol names using abbreviated string patterns \
with metacharacters such as ",
 Cell[BoxData["*"], "InlineFormula"],
 ", as specified in ",
 ButtonBox["Some General Notations and Conventions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SomeGeneralNotationsAndConventions#41"],
 "."
}], "Notes",
 CellID->7406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32099569],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->126810172],

Cell[TextData[{
 "Test whether a string corresponds to a ",
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->282055449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NameQ", "[", "\"\<Plot\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501108994],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162501530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NameQ", "[", "\"\<plot\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127378321],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53979234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267881734],

Cell["\<\
Test whether there are any symbols corresponding to a class of strings:\
\>", "ExampleText",
 CellID->743418011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NameQ", "[", "\"\<*File*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114685941],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92400257]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NameQ", "[", "\"\<*file*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->329643151],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59219522]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4969],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Names",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Names"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->5344]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11410],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->28463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->357270431],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->262538500]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NameQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 17.2934082}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NameQ[\"string\"] yields True if there are any symbols whose names match \
the string pattern given, and yields False otherwise. ", 
    "synonyms" -> {"name q"}, "title" -> "NameQ", "type" -> "Symbol", "uri" -> 
    "ref/NameQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4364, 142, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32099569]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9472, 339}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1947, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2570, 76, 43, 1, 70, "ObjectName",
 CellID->29397],
Cell[2616, 79, 831, 26, 70, "Usage",
 CellID->8125]
}, Open  ]],
Cell[CellGroupData[{
Cell[3484, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3962, 127, 365, 10, 70, "Notes",
 CellID->7406]
}, Closed]],
Cell[CellGroupData[{
Cell[4364, 142, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32099569],
Cell[CellGroupData[{
Cell[4748, 156, 148, 5, 70, "ExampleSection",
 CellID->126810172],
Cell[4899, 163, 218, 8, 70, "ExampleText",
 CellID->282055449],
Cell[CellGroupData[{
Cell[5142, 175, 112, 3, 28, "Input",
 CellID->501108994],
Cell[5257, 180, 161, 5, 36, "Output",
 CellID->162501530]
}, Open  ]],
Cell[CellGroupData[{
Cell[5455, 190, 112, 3, 28, "Input",
 CellID->127378321],
Cell[5570, 195, 161, 5, 36, "Output",
 CellID->53979234]
}, Open  ]],
Cell[5746, 203, 125, 3, 70, "ExampleDelimiter",
 CellID->267881734],
Cell[5874, 208, 122, 3, 70, "ExampleText",
 CellID->743418011],
Cell[CellGroupData[{
Cell[6021, 215, 114, 3, 70, "Input",
 CellID->114685941],
Cell[6138, 220, 160, 5, 36, "Output",
 CellID->92400257]
}, Open  ]],
Cell[CellGroupData[{
Cell[6335, 230, 114, 3, 70, "Input",
 CellID->329643151],
Cell[6452, 235, 161, 5, 36, "Output",
 CellID->59219522]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6674, 247, 310, 9, 70, "SeeAlsoSection",
 CellID->4969],
Cell[6987, 258, 189, 6, 70, "SeeAlso",
 CellID->5344]
}, Open  ]],
Cell[CellGroupData[{
Cell[7213, 269, 314, 9, 70, "TutorialsSection",
 CellID->11410],
Cell[7530, 280, 191, 4, 70, "Tutorials",
 CellID->28463]
}, Open  ]],
Cell[CellGroupData[{
Cell[7758, 289, 299, 8, 70, "MoreAboutSection"],
Cell[8060, 299, 169, 3, 70, "MoreAbout",
 CellID->357270431],
Cell[8232, 304, 141, 3, 70, "MoreAbout",
 CellID->262538500]
}, Open  ]],
Cell[8388, 310, 27, 0, 70, "History"],
Cell[8418, 312, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

