(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18371,        648]
NotebookOptionsPosition[     14417,        512]
NotebookOutlinePosition[     15752,        550]
CellTagsIndexPosition[     15667,        545]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"], "Using Nearest" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingNearest"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>", 
       2->"\<\"Using Nearest\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Nearest" :> Documentation`HelpLookup["paclet:ref/Nearest"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "FindClusters" :> 
          Documentation`HelpLookup["paclet:ref/FindClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Nearest\"\>", 
       2->"\<\"InterpolatingFunction\"\>", 
       3->"\<\"FindClusters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Exploratory Data Analysis\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       4->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       5->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NearestFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NearestFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NearestFunction"], "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a function whose values give the elements \
closest to an element that is supplied."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31911]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23922],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 " is generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19951],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"NearestFunction", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives the element closest to a particular element ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26700],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"NearestFunction", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox[
    RowBox[{"x", ",", "n"}], "TI"], "]"}]], "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " nearest elements."
}], "Notes",
 CellID->10342]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187308649],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->581169488],

Cell[TextData[{
 "Generate a ",
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "6", ",", "10"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12425],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21614]
}, Open  ]],

Cell["Apply to a single element:", "ExampleText",
 CellID->16612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3192],

Cell[BoxData[
 RowBox[{"{", "6", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4009]
}, Open  ]],

Cell["Apply to several elements:", "ExampleText",
 CellID->14938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
   "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "6", "}"}]}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26866]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "6", ",", "10"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3080],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6964]
}, Open  ]],

Cell["Give the 3 nearest elements:", "ExampleText",
 CellID->27541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", 
  RowBox[{"5", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7886]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17720],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->630],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256],

Cell[TextData[ButtonBox["Using Nearest",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingNearest"]], "Tutorials",
 CellID->510394019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->902423542],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->190513678],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->162356979],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->223950792],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->148389259],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->22705788]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NearestFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 51.4505326}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NearestFunction[data] represents a function whose values give the \
elements closest to an element that is supplied.", 
    "synonyms" -> {"nearest function"}, "title" -> "NearestFunction", "type" -> 
    "Symbol", "uri" -> "ref/NearestFunction"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7552, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->187308649]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15524, 538}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2891, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3514, 93, 1580, 37, 70, "ObjectNameGrid"],
Cell[5097, 132, 554, 16, 70, "Usage",
 CellID->31911]
}, Open  ]],
Cell[CellGroupData[{
Cell[5688, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6166, 170, 319, 12, 70, "Notes",
 CellID->23922],
Cell[6488, 184, 375, 14, 70, "Notes",
 CellID->19951],
Cell[6866, 200, 322, 11, 70, "Notes",
 CellID->26700],
Cell[7191, 213, 324, 12, 70, "Notes",
 CellID->10342]
}, Closed]],
Cell[CellGroupData[{
Cell[7552, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187308649],
Cell[CellGroupData[{
Cell[7937, 244, 148, 5, 70, "ExampleSection",
 CellID->581169488],
Cell[8088, 251, 204, 8, 70, "ExampleText",
 CellID->21382],
Cell[CellGroupData[{
Cell[8317, 263, 193, 6, 28, "Input",
 CellID->12425],
Cell[8513, 271, 443, 16, 36, "Output",
 CellID->21614]
}, Open  ]],
Cell[8971, 290, 65, 1, 70, "ExampleText",
 CellID->16612],
Cell[CellGroupData[{
Cell[9061, 295, 93, 3, 70, "Input",
 CellID->3192],
Cell[9157, 300, 175, 6, 36, "Output",
 CellID->4009]
}, Open  ]],
Cell[9347, 309, 65, 1, 70, "ExampleText",
 CellID->14938],
Cell[CellGroupData[{
Cell[9437, 314, 181, 6, 70, "Input",
 CellID->25005],
Cell[9621, 322, 409, 14, 36, "Output",
 CellID->26866]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10079, 342, 216, 7, 70, "ExampleSection",
 CellID->32171],
Cell[CellGroupData[{
Cell[10320, 353, 192, 6, 70, "Input",
 CellID->3080],
Cell[10515, 361, 442, 16, 36, "Output",
 CellID->6964]
}, Open  ]],
Cell[10972, 380, 67, 1, 70, "ExampleText",
 CellID->27541],
Cell[CellGroupData[{
Cell[11064, 385, 117, 4, 70, "Input",
 CellID->15026],
Cell[11184, 391, 208, 7, 36, "Output",
 CellID->7886]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11453, 405, 311, 9, 70, "SeeAlsoSection",
 CellID->17720],
Cell[11767, 416, 728, 26, 70, "SeeAlso",
 CellID->10198]
}, Open  ]],
Cell[CellGroupData[{
Cell[12532, 447, 312, 9, 70, "TutorialsSection",
 CellID->630],
Cell[12847, 458, 170, 3, 70, "Tutorials",
 CellID->22256],
Cell[13020, 463, 140, 3, 70, "Tutorials",
 CellID->510394019]
}, Open  ]],
Cell[CellGroupData[{
Cell[13197, 471, 319, 9, 70, "MoreAboutSection",
 CellID->902423542],
Cell[13519, 482, 155, 3, 70, "MoreAbout",
 CellID->190513678],
Cell[13677, 487, 155, 3, 70, "MoreAbout",
 CellID->162356979],
Cell[13835, 492, 179, 3, 70, "MoreAbout",
 CellID->223950792],
Cell[14017, 497, 175, 3, 70, "MoreAbout",
 CellID->148389259],
Cell[14195, 502, 150, 3, 70, "MoreAbout",
 CellID->22705788]
}, Open  ]],
Cell[14360, 508, 27, 0, 70, "History"],
Cell[14390, 510, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

