(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14461,        501]
NotebookOptionsPosition[     11042,        390]
NotebookOutlinePosition[     12602,        433]
CellTagsIndexPosition[     12476,        427]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematica Packages\"\>", 
       2->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Get" :> Documentation`HelpLookup["paclet:ref/Get"], 
          "DeclarePackage" :> 
          Documentation`HelpLookup["paclet:ref/DeclarePackage"], "FileNames" :> 
          Documentation`HelpLookup["paclet:ref/FileNames"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Get\"\>", 
       2->"\<\"DeclarePackage\"\>", 
       3->"\<\"FileNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Expressions in Files\"\>", 
       2->"\<\"Namespace Management\"\>", 
       3->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Needs", "ObjectName",
 CellID->12135],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Needs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Needs"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]loads an appropriate file if the specified context is \
not already in ",
     Cell[BoxData[
      ButtonBox["$Packages",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Packages"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Needs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Needs"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]loads ",
     Cell[BoxData[
      StyleBox["file", "TI"]], "InlineFormula"],
     " if the specified context is not already in ",
     Cell[BoxData[
      ButtonBox["$Packages",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Packages"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15632]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Needs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Needs"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 ". By convention, the file loaded in this way is the one which contains a \
package that defines ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["context", "TI"], "`"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19582],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Needs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Needs"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"file\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " typically reads in a file named ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", "m"}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->1382]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130843593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->85461490],

Cell[TextData[{
 "Read in the file for the ",
 Cell[BoxData[
  ButtonBox["ComputerArithmetic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComputerArithmetic"]], "InlineFormula"],
 " package if it has not already been read:"
}], "ExampleText",
 CellID->227303730],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ComputerArithmetic`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33422920],

Cell["The commands defined by the package are ready for use:", "ExampleText",
 CellID->249025330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Ulp"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->428743927],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Ulp\\\", \\\"[\\\", StyleBox[\\\"x\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) gives the size of an ulp for numbers near \
\!\(\*StyleBox[\\\"x\\\", \\\"TI\\\"]\).\"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/Ulp"]}]], "Print", "PrintUsage",
 
 CellTags->"Info3385815078-9791993",
 CellID->258622647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ulp", "[", "1000.", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->577149367],

Cell[BoxData["1.1368683772161603`*^-13"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->190673076]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9601],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclarePackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeclarePackage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32268]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13250],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->312865463],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->12644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->9293897],

Cell[TextData[ButtonBox["Mathematica Expressions in Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]], "MoreAbout",
 CellID->515496850],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->37343975],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->620089430]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Needs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 53.1380758}", "context" -> "System`", 
    "keywords" -> {"load package on demand", "needs package"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Needs[\"StyleBox[ context`]\"] loads an appropriate file if the \
specified context is not already in $Packages. Needs[\"StyleBox[ context`]\", \
\" file\"] loads file if the specified context is not already in $Packages. ",
     "synonyms" -> {"with"}, "title" -> "Needs", "type" -> "Symbol", "uri" -> 
    "ref/Needs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6079, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130843593]},
 "Info3385815078-9791993"->{
  Cell[7228, 244, 460, 12, 70, "Print",
   CellTags->"Info3385815078-9791993",
   CellID->258622647]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12201, 416},
 {"Info3385815078-9791993", 12350, 420}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2483, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3106, 86, 43, 1, 70, "ObjectName",
 CellID->12135],
Cell[3152, 89, 1330, 42, 70, "Usage",
 CellID->15632]
}, Open  ]],
Cell[CellGroupData[{
Cell[4519, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4997, 153, 670, 24, 70, "Notes",
 CellID->19582],
Cell[5670, 179, 372, 14, 70, "Notes",
 CellID->1382]
}, Closed]],
Cell[CellGroupData[{
Cell[6079, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130843593],
Cell[CellGroupData[{
Cell[6464, 212, 147, 5, 70, "ExampleSection",
 CellID->85461490],
Cell[6614, 219, 268, 8, 70, "ExampleText",
 CellID->227303730],
Cell[6885, 229, 126, 3, 70, "Input",
 CellID->33422920],
Cell[7014, 234, 97, 1, 70, "ExampleText",
 CellID->249025330],
Cell[CellGroupData[{
Cell[7136, 239, 89, 3, 70, "Input",
 CellID->428743927],
Cell[7228, 244, 460, 12, 70, "Print",
 CellTags->"Info3385815078-9791993",
 CellID->258622647]
}, Open  ]],
Cell[CellGroupData[{
Cell[7725, 261, 103, 3, 70, "Input",
 CellID->577149367],
Cell[7831, 266, 181, 5, 36, "Output",
 CellID->190673076]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8073, 278, 310, 9, 70, "SeeAlsoSection",
 CellID->9601],
Cell[8386, 289, 700, 26, 70, "SeeAlso",
 CellID->32268]
}, Open  ]],
Cell[CellGroupData[{
Cell[9123, 320, 314, 9, 70, "TutorialsSection",
 CellID->13250],
Cell[9440, 331, 284, 9, 70, "Tutorials",
 CellID->312865463],
Cell[9727, 342, 408, 12, 70, "Tutorials",
 CellID->12644]
}, Open  ]],
Cell[CellGroupData[{
Cell[10172, 359, 317, 9, 70, "MoreAboutSection",
 CellID->9293897],
Cell[10492, 370, 173, 3, 70, "MoreAbout",
 CellID->515496850],
Cell[10668, 375, 150, 3, 70, "MoreAbout",
 CellID->37343975],
Cell[10821, 380, 149, 3, 70, "MoreAbout",
 CellID->620089430]
}, Open  ]],
Cell[10985, 386, 27, 0, 70, "History"],
Cell[11015, 388, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

