(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11367,        407]
NotebookOptionsPosition[      8814,        322]
NotebookOutlinePosition[     10023,        357]
CellTagsIndexPosition[      9939,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NonNegative" :> 
          Documentation`HelpLookup["paclet:ref/NonNegative"], "Positive" :> 
          Documentation`HelpLookup["paclet:ref/Positive"], "NonPositive" :> 
          Documentation`HelpLookup["paclet:ref/NonPositive"], "Sign" :> 
          Documentation`HelpLookup["paclet:ref/Sign"], "Less" :> 
          Documentation`HelpLookup["paclet:ref/Less"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NonNegative\"\>", 
       2->"\<\"Positive\"\>", 3->"\<\"NonPositive\"\>", 4->"\<\"Sign\"\>", 
       5->"\<\"Less\"\>", 6->"\<\"Simplify\"\>", 
       7->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Negative", "ObjectName",
 CellID->6586],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Negative",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Negative"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a negative number. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26874]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Negative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Negative"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is manifestly a non\[Hyphen]negative or complex numerical quantity. \
Otherwise, it remains unevaluated. "
}], "Notes",
 CellID->30242]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197986204],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->274530476],

Cell["Evaluate different types of numbers:", "ExampleText",
 CellID->115213883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Negative", "[", 
  RowBox[{"{", 
   RowBox[{"1.6", ",", 
    RowBox[{"3", "/", "4"}], ",", "Pi", ",", "0", ",", 
    RowBox[{"-", "5"}], ",", 
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", "^", "5"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187009233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
   "False", ",", "False"}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9429461]
}, Open  ]],

Cell[TextData[{
 "Quantities that are not ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " remain unevaluated:"
}], "ExampleText",
 CellID->236549865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Negative", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"Sin", "[", "y", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238276832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Negative", "[", "x", "]"}], ",", 
   RowBox[{"Negative", "[", 
    RowBox[{"Sin", "[", "y", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248053402]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31248],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonNegative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonNegative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonPositive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonPositive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Less",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Less"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2242]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->35230161]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Negative - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 53.8880950}", "context" -> "System`", 
    "keywords" -> {"negative number", "test for negative"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Negative[x] gives True if x is a negative number. ", "synonyms" -> {}, 
    "title" -> "Negative", "type" -> "Symbol", "uri" -> "ref/Negative"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4181, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->197986204]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9796, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1758, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2381, 66, 45, 1, 70, "ObjectName",
 CellID->6586],
Cell[2429, 69, 685, 23, 70, "Usage",
 CellID->26874]
}, Open  ]],
Cell[CellGroupData[{
Cell[3151, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3629, 114, 515, 18, 70, "Notes",
 CellID->30242]
}, Closed]],
Cell[CellGroupData[{
Cell[4181, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197986204],
Cell[CellGroupData[{
Cell[4566, 151, 148, 5, 70, "ExampleSection",
 CellID->274530476],
Cell[4717, 158, 79, 1, 70, "ExampleText",
 CellID->115213883],
Cell[CellGroupData[{
Cell[4821, 163, 333, 10, 28, "Input",
 CellID->187009233],
Cell[5157, 175, 286, 9, 36, "Output",
 CellID->9429461]
}, Open  ]],
Cell[5458, 187, 226, 8, 70, "ExampleText",
 CellID->236549865],
Cell[CellGroupData[{
Cell[5709, 199, 183, 6, 28, "Input",
 CellID->238276832],
Cell[5895, 207, 308, 10, 36, "Output",
 CellID->248053402]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6264, 224, 311, 9, 70, "SeeAlsoSection",
 CellID->31248],
Cell[6578, 235, 1677, 62, 70, "SeeAlso",
 CellID->2242]
}, Open  ]],
Cell[CellGroupData[{
Cell[8292, 302, 299, 8, 70, "MoreAboutSection"],
Cell[8594, 312, 148, 3, 70, "MoreAbout",
 CellID->35230161]
}, Open  ]],
Cell[8757, 318, 27, 0, 70, "History"],
Cell[8787, 320, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

