(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65147,       2398]
NotebookOptionsPosition[     52401,       1941]
NotebookOutlinePosition[     53959,       1987]
CellTagsIndexPosition[     53847,       1981]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Nest" :> Documentation`HelpLookup["paclet:ref/Nest"], 
          "NestWhileList" :> 
          Documentation`HelpLookup["paclet:ref/NestWhileList"], "FoldList" :> 
          Documentation`HelpLookup["paclet:ref/FoldList"], "FixedPointList" :> 
          Documentation`HelpLookup["paclet:ref/FixedPointList"], 
          "ComposeList" :> 
          Documentation`HelpLookup["paclet:ref/ComposeList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Nest\"\>", 
       2->"\<\"NestWhileList\"\>", 3->"\<\"FoldList\"\>", 
       4->"\<\"FixedPointList\"\>", 
       5->"\<\"ComposeList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"Functional Iteration\"\>", 
       4->"\<\"Functional Programming\"\>", 5->"\<\"Language Overview\"\>", 
       6->"\<\"List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NestList", "ObjectName",
 CellID->15406],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the results of applying ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["0"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives a list of length ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "+", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12515]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->466418587],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->191197810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->711885723]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Cos", ",", "1.0", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->638050643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "0.5403023058681398`", ",", "0.8575532158463934`", ",", 
   "0.6542897904977791`", ",", "0.7934803587425656`", ",", 
   "0.7013687736227565`", ",", "0.7639596829006542`", ",", 
   "0.7221024250267077`", ",", "0.7504177617637605`", ",", 
   "0.7314040424225098`", ",", "0.7442373549005569`"}], "}"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228256563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78172925],

Cell["The function to nest can be a pure function:", "ExampleText",
 CellID->1655192358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}], "^", "2"}], "&"}], ",", "x", ",", "3"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "2"]}], ")"}], "2"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}], "2"]}], ")"}], "2"]}], ")"}], 
    "2"]}], "}"}]], "Output",
 ImageSize->{315, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601942568]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->66072025],

Cell["Nesting a function can build a formula:", "ExampleText",
 CellID->1403736563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}], "^", "2"}], "&"}], ",", "x", ",", "3"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1727899158],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "2"]}], ")"}], "2"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}], "2"]}], ")"}], "2"]}], ")"}], 
    "2"]}], "}"}]], "Output",
 ImageSize->{315, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749801723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->719466300],

Cell["Nesting can return a single number:", "ExampleText",
 CellID->1794672579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Sqrt", ",", "100.0", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1708060685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "100.`", ",", "10.`", ",", "3.1622776601683795`", ",", 
   "1.7782794100389228`", ",", "1.333521432163324`"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119665959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125783396],

Cell["The nested function can operate on a list:", "ExampleText",
 CellID->1171950486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", "0.1"}], "}"}], ",", 
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"xy", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "\[Epsilon]"}], ",", "0"}], "}"}], "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"2", "\[Epsilon]"}]}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "-", 
              RowBox[{"2", "\[Epsilon]"}]}]}], "}"}]}], "}"}], ".", 
         "xy"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "1.0"}], "}"}], ",", "4"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1848319124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.6400000000000001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.5120000000000001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.40960000000000013`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->646097150]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28663259],

Cell["\<\
To nest a function of more than one argument, the arguments can be put into a \
list:\
\>", "ExampleText",
 CellID->2112928093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "2"], ",", 
      SqrtBox[
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], " ", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]]}], "}"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.0"}], "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701746386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", "0.7071067811865476`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7285533905932737`", ",", "0.7282376575609851`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7283955240771294`", ",", "0.7283955069697775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7283955155234534`", ",", "0.7283955155234534`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{347, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6605627]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8092],

Cell["Powers of 2:", "ExampleText",
 CellID->26905],

Cell[CellGroupData[{

Cell["NestList[2 #&, 1, 10]", "Input",
 CellTags->"S2.4.1",
 CellLabel->"In[1]:=",
 CellID->7251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64", ",", 
   "128", ",", "256", ",", "512", ",", "1024"}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.4.1",
 CellLabel->"Out[1]=",
 CellID->48464144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13730],

Cell["Successive integers:", "ExampleText",
 CellID->27703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", "1"}], "&"}], ",", "0", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
   ",", "8", ",", "9", ",", "10"}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51709895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22255],

Cell["Successive squaring:", "ExampleText",
 CellID->14684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}], ",", " ", "2", ",", " ", "6"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "16", ",", "256", ",", "65536", ",", "4294967296", ",", 
   "18446744073709551616"}], "}"}]], "Output",
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328398541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->750985290],

Cell["Growth of annually compounded capital:", "ExampleText",
 CellID->546491048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", 
     RowBox[{"(", 
      RowBox[{"1", "+", "0.05"}], ")"}]}], "&"}], ",", "1000", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299056208],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1000", ",", "1050.`", ",", "1102.5`", ",", "1157.625`", ",", 
   "1215.5062500000001`", ",", "1276.2815625000003`", ",", 
   "1340.0956406250004`", ",", "1407.1004226562504`", ",", 
   "1477.455443789063`", ",", "1551.3282159785163`", ",", 
   "1628.8946267774422`"}], "}"}]], "Output",
 ImageSize->{354, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->671952954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146],

Cell["Successive derivatives:", "ExampleText",
 CellID->7790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"x", "^", "n"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "n"], ",", 
   RowBox[{"n", " ", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}]]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}]]}]}], "}"}]], "Output",
 ImageSize->{331, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17806102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8505],

Cell[TextData[{
 "Newton iterations for ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->10607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1.0", 
   ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235429315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16281],

Cell["Continued fraction:", "ExampleText",
 CellID->17746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}]}], "&"}], ",", "x", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "x"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", "x"}]]}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", "x"}]]}]]}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", 
           FractionBox["1", 
            RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]}], "}"}]], "Output",
 ImageSize->{362, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100753092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24592],

Cell["Iterated map:", "ExampleText",
 CellID->6413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", "#", 
     RowBox[{"(", 
      RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
   RowBox[{"1", "/", "3"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "3"], ",", 
   FractionBox["8", "9"], ",", 
   FractionBox["32", "81"], ",", 
   FractionBox["6272", "6561"], ",", 
   FractionBox["7250432", "43046721"], ",", 
   FractionBox["1038154236987392", "1853020188851841"]}], "}"}]], "Output",
 ImageSize->{338, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392384986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", "#", 
     RowBox[{"(", 
      RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28041],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3333333333333333`", ",", "0.888888888888889`", ",", 
   "0.39506172839506154`", ",", "0.9559518366102727`", ",", 
   "0.16843169076687667`", ",", "0.5602498252491516`", ",", 
   "0.9854798342297868`", ",", "0.05723732222487492`", ",", 
   "0.21584484467760304`", ",", "0.6770233908148179`", ",", 
   "0.874650876417697`"}], "}"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->435149123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27576],

Cell[TextData[{
 "Iterates in the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", " ", "n"}], "+", "1"}], TraditionalForm]], "InlineMath"],
 " problem:"
}], "ExampleText",
 CellID->16924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "#", "]"}], ",", 
      RowBox[{"#", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "#"}], "+", "1"}], ")"}], "/", "2"}]}], "]"}], "&"}], 
   ",", "100", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "100", ",", "50", ",", "25", ",", "38", ",", "19", ",", "29", ",", "44", 
   ",", "22", ",", "11", ",", "17", ",", "26", ",", "13", ",", "20", ",", 
   "10", ",", "5", ",", "8", ",", "4", ",", "2", ",", "1", ",", "2", ",", 
   "1"}], "}"}]], "Output",
 ImageSize->{494, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->686726126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23946],

Cell["Linear congruential pseudorandom generator:", "ExampleText",
 CellID->29958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"59", "#"}], ",", "101"}], "]"}], "&"}], ",", "1", ",", "15"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "59", ",", "47", ",", "46", ",", "88", ",", "41", ",", "96", ",", 
   "8", ",", "68", ",", "73", ",", "65", ",", "98", ",", "25", ",", "61", ",",
    "64", ",", "39"}], "}"}]], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163776419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1627],

Cell["Random walk:", "ExampleText",
 CellID->17831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "&"}], ",", "0", ",", 
   "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "1", ",", "2", ",", 
   "3", ",", "2", ",", "3", ",", "2", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99231143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->583250231],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.}, {2., -1.}, {3., -2.}, {4., -3.}, {5., -2.}, {
     6., -1.}, {7., -2.}, {8., -1.}, {9., -2.}, {10., -1.}, {11., 0.}, {12., 
     1.}, {13., 2.}, {14., 1.}, {15., 2.}, {16., 3.}, {17., 2.}, {18., 3.}, {
     19., 2.}, {20., 1.}, {21., 0.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 21.}, {-3., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62726988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10637],

Cell["Iterated string replacements:", "ExampleText",
 CellID->21100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StringReplace", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "->", "\"\<BA\>\""}], ",", 
        RowBox[{"\"\<B\>\"", "->", "\"\<AB\>\""}]}], "}"}]}], "]"}], "&"}], 
   ",", "\"\<A\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BA\"\>", ",", "\<\"ABBA\"\>", 
   ",", "\<\"BAABABBA\"\>", ",", "\<\"ABBABAABBAABABBA\"\>", 
   ",", "\<\"BAABABBAABBABAABABBABAABBAABABBA\"\>"}], "}"}]], "Output",
 ImageSize->{515, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19941312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31750],

Cell["Successively append to a list:", "ExampleText",
 CellID->4654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Append", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"{", "a", "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8590264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8827],

Cell["Successively rotate a list:", "ExampleText",
 CellID->26979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"RotateLeft", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15232948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25838],

Cell["Operations on a pair of values:", "ExampleText",
 CellID->8081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"Last", "[", "#", "]"}], "]"}], ",", 
      RowBox[{"g", "[", 
       RowBox[{"First", "[", "#", "]"}], "]"}]}], "}"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->898],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWu9u1DAMz11bNjh2G3xAJ8GkDd4FPvEQpwlp+4BAY08MD1KaXnPr+Zra
jp0/Byf1GqdpYjt2nObnr9un+2/ft08Pd9ubL4/bn/cPd79uPv947KqqhTGL
38aY243pym1X6i/7+9Ndu+KutLL/lXvamlfd37Ij6+5uq5uBfu2pXw33ZuY+
7v+c2K+rr7p7PTznjFNPyCWRM4QfDflD9E3RR9XPPtQKtIYXgF4qt4dcYXQ1
0k5JfIXKcWr6L3W+SpO7H/9odm1tM/g01FI9UU9qX+/rB10v2+eVQ1OmMwmX
hPap6fMUs1Og3LHnMY91hnlkBWgYNfu3mrEMxiOxvJflob4MHsMptNX1WUIp
sF7G+ybt+bb9vswi1WnopiQ7yOkT/HUDWhVslduq7OzCPRBX0ovEPM/1Mn5u
FGYdvn/BbF/SKqGtm5LtIK0HYFYAny96fkreU/yza8NBTNBe8y+zyHUq2inJ
FvKuDxG/OcZ0qF6QPvT3VjCqxuJcxyqyrBL/jXaKsoXknqCzUsydsFg5hkN8
sy9K3o12UrOOwa3v3QMpqr1hG8+72mtA0hkrRAdJ5zerJaeJ/xCr4LaXYh3v
EvObOg5L+U0tX+r5yIOVTXFdmWec3eHhjacew8U3yPuwnpvX8EbIf8j4IXJR
9cXLI7BFmFnCL2GWAk9hfUgWpH25H1O5HON2MFdj5WlHHa+e6Y+TKzKXgzLH
FzfXh5LrQuGXIjeF/w+9lWD7FycVnAXf/gHLwcCsKzTHIZQfaa6DFr9c2o2L
xZvUuRyl5hQ5vq5br9WTd7ow1wEbm5obwaUPVmy1fXpQJofa6Nx8Cm0aRsVS
81JEeSfJvunet15vg75+dGLk8g98sSwkP8G3N3H1NEw/7IQrXj5FOD86OQxz
WqVwkQfzk3KdMv8jXjbTbhcIo62v9dWo3vIJozY3EwBD3+no2BQilS5PgYKH
6SB93HwF+HwdTQeaXMfRXVx8E4522/ePxT43Wu9Zs0gz92QOx65l3iXlr1jv
EuH9V1M9pvEvEd+n4GGQ/thSPOw4dq5JXMaxZwqSy4/2MdBzPhdqKLUYTw/y
wiI4T4X06+8oZ7zR+71pT4mqvZrcD/Yxiwsz8Vkvvhr8TSxGrYNHZmPFylg2
9LJSMfcomHq0MxRaVLsGtBS3hbgodt4qHQ/rX4rTakeI2Li1VF7p+fjO6kjn
eSMaw2kdNrUBdCjeC7EuH16LYYFvieNRcWQMN6ZidJ/6WbBFCsJrFn8BGMko
fw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{482, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710596304]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->79374911],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " gives the last element of ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10293],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180037962]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6206],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13404059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->421777096],

Cell["Nesting zero times simply returns to original argument:", "ExampleText",
 CellID->701851334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1667062147],

Cell[BoxData[
 RowBox[{"{", "x", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148027784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240038012],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 " goes on until the result no longer changes:"
}], "ExampleText",
 CellID->351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000", ",", "15"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1000", ",", "501", ",", "251", ",", "126", ",", "64", ",", "33", ",", "17",
    ",", "9", ",", "5", ",", "3", ",", "2", ",", "2", ",", "2", ",", "2", ",",
    "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56963503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000", ",", "15"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1000", ",", "501", ",", "251", ",", "126", ",", "64", ",", "33", ",", "17",
    ",", "9", ",", "5", ",", "3", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322306544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177250742],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhileList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhileList"]], "InlineFormula"],
 " goes on while a condition is true:"
}], "ExampleText",
 CellID->396943745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"NestWhileList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "#", "]"}], ",", 
       RowBox[{"#", "/", "2"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "#"}], "+", "1"}], ")"}], "/", "2"}]}], "]"}], 
     "&"}], ",", "29", ",", 
    RowBox[{
     RowBox[{"#", ">", "1"}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->708326668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "29", ",", "44", ",", "22", ",", "11", ",", "17", ",", "26", ",", "13", ",",
    "20", ",", "10", ",", "5", ",", "8", ",", "4", ",", "2", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221724942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506876756],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " automatically inserts second arguments from a list:"
}], "ExampleText",
 CellID->13971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#", ",", "a"}], "]"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], ",", "a"}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725623822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], ",", "a"}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25097071]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Framed", ",", "x", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox["x",
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox["x",
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox[
        FrameBox["x",
         StripOnInput->False],
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{345, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124134625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6395],

Cell["Power towers:", "ExampleText",
 CellID->27184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "#"}], "&"}], ",", "x", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27928],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVs1OwkAQ3v6AikYhWm1aRBBF/LnoRZ9AT76DDTGBg9Eg76APpM+kxjvX
ut1utfmmixMPFZLu129mdrrzdbbsdTQZ3t5Fk9Egal+No4fhaPDYvrwfS5Nj
CSGm8ur6Qt7H8k5d0ziW6MrRlvRDY0VZnWR0kij1E5/A7TmJqgHfAB4AbwPf
B34M/JS9ikQ7T2OosaOxp/FE45k5q/tt1bG2RhfmVMC/9It/DfxV8KNyOB+V
RD8qi35UOq3ZBitooPsxmb9APDWjp649i8TjGeeERk/H6DmA1Vup2Ukhr3K2
ouz5zZxqRR1yKDHZtklGq1Ap94+Z+4Vrxo62Sa2rxLJOLAGxtIhlj1iOiKVX
2Cuz98cK8AZwH3gT+C7wPvDi/kXdwhJV2mGtKKuT2x+4j8vMalCvmrekI+4G
btwWM26bGddlxvms+i+YaoYlZMu+L+fknQRzrnW289OTTMSpnhl1Q7Ro/VON
qt/Fs2G1mwzvE6mF883xFLwwIusKXuHZjRlWQ1aGGursI97jn38CZG8k97KC
9AwsrC8iPIj/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{246, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->784881662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "#"}], "&"}], ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "x"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["x", "x"], ")"}], 
    SuperscriptBox["x", "x"]], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", "x"], ")"}], 
      SuperscriptBox["x", "x"]], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["x", "x"], ")"}], 
     SuperscriptBox["x", "x"]]], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["x", "x"], ")"}], 
        SuperscriptBox["x", "x"]], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["x", "x"], ")"}], 
       SuperscriptBox["x", "x"]]], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["x", "x"], ")"}], 
       SuperscriptBox["x", "x"]], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", "x"], ")"}], 
      SuperscriptBox["x", "x"]]]]}], "}"}]], "Output",
 ImageSize->{375, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628468295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], "]"}], "]"}], "&"}], ",", "x", ",", 
   "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9463],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXD1v2zAQpWXZcdKPpYZhdMpP6CR4yNxO/RFGUCAZigZpJsNLfrlLiqJp
XUjxjpIpNzwChnXM6fju6fFEy2Z+bl8efv3evjzeb29/PG+fHh7v/95+//Ms
u6YTIYq1EOLbWsjjgzyqX6Z9lS9tflBH08ViIXRTblN1oPq0s5gD72Ok+m0K
+i7N+xVkuAPZXYOzCod/Ic09OK/oGM327oDtHq3tX0hzH/Dj0YYd7e7QvuoV
USVVo5JNQCUh1JS4KrsyEkcXC7a3IqKvGlSbgB+OBVxcywIdB7PgZ6FszobZ
Z8FGqW09p2b1Eby7ZMnL7Gg37JRObr4c2lVpSaymy6aKrQaupl1xXdUUi6Pv
NUuJ06WBsXiia8raSyLnywb7auBr1xXXxTUWxzCaSoPTr6n0PLGmWFNjauoG
2HMHBrO+0IEWPbKkRUrKXy9krDTTupWmxrhyjN2K6fCJrWSYWKNxF4GNdWYa
0Fl5+jc1gg/BzIPUvOtwupm+mXN0zLXDRDYoUSiCnMQo6twofUo6OztnYStX
9jD1ICc+sPUJ+oJ6dYIMrr3eer7tmbd7PJHCGNyRj1xgUPhXVEhUY6B0qSkJ
O4OzlTN7mNqUEx8Ue3IyUN15RPMZeJrKaeoVvHuGPp+7zi9A9phVMfU5QJ9x
XVd0qDz65vU/5YmZoZeMP1RZJtJUM0nPJl9mPKN4RvGMir1HwSdKYN0kDz4B
D/QKmqCZ1PdzqoZzXef0nes58cbr5YAd9azxoydDypMGjIpTPumImVXnxudT
b0pehq4+OfGGqT458UGqPie+/HuAfnOOvz1jTbGmWFOsqcvgiTXFmhpfU+u1
2oqmmv4duLQ7OW/7F9JcgfPirh0uruWKjmMYTaXB6ddUep4omuJ9F5Yb3qNz
aD4e6j06vHOLWWizYGtTBWpS6N5TNbVsE6hl1HtPV1xXTcXicLPwnvfsvv/R
rAp2RPXuGtXsA6q5tN36sd428/o7C5C19VZN//cDMfkHbZeRMw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{536, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323306203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", "#", "]"}], "[", "#", "]"}], "&"}], ",", "x", ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1286],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmm1PgzAQxw/K5sOce2cWM5N9Gn3lhyCLyfbCaOa+P7asFbwVuLoWblIS
KFd6vV//g1t5eM0P27f3/LDb5OuXff653W2+1s8fe1klEoD0EQAWS5D7hdwr
V7Os5AqQqa34qYcbZE/lRplXskxlOdPlFNmTDr/UoZ96vaufK0efXG3+fXNg
nUR5NghUe6tbX1tUrdszZOOzCh8XxH5Tz3HxcWyHjudr3P9Nl3Pjj1KP49Wa
1XO6yQiqxD6KMTNXPtkrc2/dFBPx981i03BoBpI+zJg5MLQyMWPlwNCSP3Bt
FROq2YKaXcCkTgMWCrt/J0enhyPBYJydPbAhC6Iom9FdBllUelClT+Zw5rpY
kMZhZvJ45kdtN6erFZzFzy/rm8KnQmPWsc+8Mw4Fcf5JSg48mzK9x3zCgyLm
k5hPeFL89e7svqjuCk9aBp5zzR1iD8VI0ZkLWwg9uYyNs+4+WbmOiTNbS+5r
fPp1p0v90qpcQj5do8fri4jmPRSNT72ioj7popoU2z7/ekK26zu+h47jvt8Z
+u7flZ/7eM6Nd+njO57luFZ9FdT2Hcmy+P0fTP1Ohdoe9x8qTpNf6Hj2724K
vawcLUi+Ad8s3GM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{538, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->696878787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Subsuperscript", "[", 
     RowBox[{"#", ",", "#", ",", "#"}], "]"}], "&"}], ",", "x", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28449],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNGbtuE0HwfH7EjmM7wQnkAbIRIiGAIAXPAhoQVNQ0NFZElEhEEBOFAr4s
FEkDBTRQhAKK5AfyDcvd7Q3e3ZnxzZ4NIlJuvbPz2tnZmd3ZZ73dzZfbvd2t
9V73ab/3ZnNr/W33yet+BCoWgiA4jf5fzAfRbxX9Sv5PlYpa/T2Ov6UYmvxF
PyaT5iT6hlGvTvR+xt+KSaO/YdwUB/BqAv6V0k4nvSMkL7TGf6S90EsGUFUt
Pb8JeZQtqu9pb4qxDIwvJr0v5HwkUksM/68p/xo5p+GjnzxmnIUXsNb+nMps
Wyt3gOZTJPEO015RqOuklycA95ojW9tnX8irQlJ/THsNNNMZZi2BYi3pvUdY
t3N7T1msw4dUh7uOZWgL+WHvCbW9kXtWUnv4eck7Z5azivLUHVKbP+tJ+jpw
wj5ix7m+MuKchbemjP1hjZxBkAbLpWVJmUDj19QgfmRJqbJctIe98ljdmM+y
EB92IdhUGjHseL5trEjcrqRt0+FecvBsapwNltmVxhYssly0BUH2Bhq/hSBX
SHkxdbJ7tJUMazxA+B0EwStbyUWFIRcEnMuOxiE5j4fpLC8qOgO6cGg7Dl7l
P5S2hGzSRhBpJMTe55VTcpwK2jnp8kf7pZwSXbvTqzHp9FvKiD8EHHZvLWMc
sssw/mZEWlVGJBJpDfnF5DatsJYU3NSO4uOh1WBN1SA/gSwqUodGiyOnH4XU
h7isMTpn6VlENLccXl4Xyu/m1FOvNImF4jp/bqBHYC/wtIAB/lphMd0Mv2pi
GpoX1MDVtA2AJ+yBOaffcvptZtyVHGeF+FIeSyyQViwxklvs7PAIvgmAPk00
grPFCoK4OUxrTnoF0jArq3UQBN+JnlOSMiLNlNOfcfr41OZSSG55DUKqv31l
5x/JGQFOHXPsCHjqWYQxoWiflZ1gzivbX2uGHLMP8s8p+5w0HqnSG0LbE18a
0WEW0kzxbyJ1Hk+CrL/IjoANMTfYDfnOMfeVfcLmb9I8Buh4iaWV6XJPaPd5
IR7kFal/+PKV+jPsG6ketF9BrhrXXQn46XvsY4fa9/bvSwc2XPCUo+sEj5Tr
aR0E4asAPC727QWWi64lQMXiTtpeVcZOFtdqcHX6soddsnLgqDVyqGuB51xX
tmfNKtoT62Og3hHoHhBzwXWbcWeJ0ar6spqoi8XHXptuD+Hhcx6cpvBNgj7R
yirqsHq40imtmPtGkOEVdYhyTRJbMiM+NnAz2kfwm0lzgOD4FsXxPFT0ya4u
GMVy/06dn36pAmhWjV76muab1bVusne+fDVv/CqZVYG2XzWlL6dcfKbfY2no
kUAWH7Xs12W75/dOfWJpZfeOmXnqN/Sg8BudtkO/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{237, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345294772]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26913],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21935],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->31588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->269430411],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->626540035],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->240694749],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->2779509],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->126662171],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->445908150],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->137195914]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with NestList",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=NestList"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
NestList"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NestList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 57.3100576}", "context" -> "System`", 
    "keywords" -> {
     "dynamic system", "iterated functions", "iterated operations", 
      "iteration of unary operators", "unary operators"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NestList[f, expr, n] gives a list of the results of applying f to expr 0 \
through n times. ", "synonyms" -> {"nest list"}, "title" -> "NestList", 
    "type" -> "Symbol", "uri" -> "ref/NestList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5473, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->466418587]},
 "S2.4.1"->{
  Cell[14349, 518, 97, 3, 70, "Input",
   CellTags->"S2.4.1",
   CellID->7251],
  Cell[14449, 523, 333, 10, 36, "Output",
   CellTags->"S2.4.1",
   CellID->48464144]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53523, 1967},
 {"S2.4.1", 53656, 1971}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2967, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3590, 94, 46, 1, 70, "ObjectName",
 CellID->15406],
Cell[3639, 97, 872, 29, 70, "Usage",
 CellID->18810]
}, Open  ]],
Cell[CellGroupData[{
Cell[4548, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5026, 148, 410, 16, 70, "Notes",
 CellID->12515]
}, Closed]],
Cell[CellGroupData[{
Cell[5473, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->466418587],
Cell[CellGroupData[{
Cell[5858, 183, 148, 5, 70, "ExampleSection",
 CellID->191197810],
Cell[CellGroupData[{
Cell[6031, 192, 133, 4, 28, "Input",
 CellID->15726],
Cell[6167, 198, 534, 17, 36, "Output",
 CellID->711885723]
}, Open  ]],
Cell[CellGroupData[{
Cell[6738, 220, 142, 4, 28, "Input",
 CellID->638050643],
Cell[6883, 226, 495, 12, 54, "Output",
 CellID->228256563]
}, Open  ]],
Cell[7393, 241, 124, 3, 70, "ExampleDelimiter",
 CellID->78172925],
Cell[7520, 246, 88, 1, 70, "ExampleText",
 CellID->1655192358],
Cell[CellGroupData[{
Cell[7633, 251, 232, 9, 70, "Input",
 CellID->7975],
Cell[7868, 262, 721, 26, 44, "Output",
 CellID->601942568]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8638, 294, 219, 7, 70, "ExampleSection",
 CellID->66072025],
Cell[8860, 303, 83, 1, 70, "ExampleText",
 CellID->1403736563],
Cell[CellGroupData[{
Cell[8968, 308, 238, 9, 70, "Input",
 CellID->1727899158],
Cell[9209, 319, 721, 26, 44, "Output",
 CellID->749801723]
}, Open  ]],
Cell[9945, 348, 125, 3, 70, "ExampleDelimiter",
 CellID->719466300],
Cell[10073, 353, 79, 1, 70, "ExampleText",
 CellID->1794672579],
Cell[CellGroupData[{
Cell[10177, 358, 145, 4, 70, "Input",
 CellID->1708060685],
Cell[10325, 364, 301, 9, 36, "Output",
 CellID->119665959]
}, Open  ]],
Cell[10641, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->125783396],
Cell[10769, 381, 86, 1, 70, "ExampleText",
 CellID->1171950486],
Cell[CellGroupData[{
Cell[10880, 386, 879, 29, 70, "Input",
 CellID->1848319124],
Cell[11762, 417, 549, 17, 36, "Output",
 CellID->646097150]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12360, 440, 242, 7, 70, "ExampleSection",
 CellID->28663259],
Cell[12605, 449, 137, 4, 70, "ExampleText",
 CellID->2112928093],
Cell[CellGroupData[{
Cell[12767, 457, 613, 21, 70, "Input",
 CellID->701746386],
Cell[13383, 480, 615, 18, 54, "Output",
 CellID->6605627]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14047, 504, 223, 7, 70, "ExampleSection",
 CellID->8092],
Cell[14273, 513, 51, 1, 70, "ExampleText",
 CellID->26905],
Cell[CellGroupData[{
Cell[14349, 518, 97, 3, 70, "Input",
 CellTags->"S2.4.1",
 CellID->7251],
Cell[14449, 523, 333, 10, 36, "Output",
 CellTags->"S2.4.1",
 CellID->48464144]
}, Open  ]],
Cell[14797, 536, 121, 3, 70, "ExampleDelimiter",
 CellID->13730],
Cell[14921, 541, 59, 1, 70, "ExampleText",
 CellID->27703],
Cell[CellGroupData[{
Cell[15005, 546, 177, 6, 70, "Input",
 CellID->5547],
Cell[15185, 554, 301, 9, 36, "Output",
 CellID->51709895]
}, Open  ]],
Cell[15501, 566, 121, 3, 70, "ExampleDelimiter",
 CellID->22255],
Cell[15625, 571, 59, 1, 70, "ExampleText",
 CellID->14684],
Cell[CellGroupData[{
Cell[15709, 576, 189, 7, 70, "Input",
 CellID->8535],
Cell[15901, 585, 296, 9, 36, "Output",
 CellID->328398541]
}, Open  ]],
Cell[16212, 597, 125, 3, 70, "ExampleDelimiter",
 CellID->750985290],
Cell[16340, 602, 81, 1, 70, "ExampleText",
 CellID->546491048],
Cell[CellGroupData[{
Cell[16446, 607, 239, 9, 70, "Input",
 CellID->299056208],
Cell[16688, 618, 460, 12, 54, "Output",
 CellID->671952954]
}, Open  ]],
Cell[17163, 633, 119, 3, 70, "ExampleDelimiter",
 CellID->146],
Cell[17285, 638, 61, 1, 70, "ExampleText",
 CellID->7790],
Cell[CellGroupData[{
Cell[17371, 643, 232, 8, 70, "Input",
 CellID->18036],
Cell[17606, 653, 791, 29, 39, "Output",
 CellID->17806102]
}, Open  ]],
Cell[18412, 685, 120, 3, 70, "ExampleDelimiter",
 CellID->8505],
Cell[18535, 690, 159, 7, 70, "ExampleText",
 CellID->10607],
Cell[CellGroupData[{
Cell[18719, 701, 278, 10, 70, "Input",
 CellID->3278],
Cell[19000, 713, 327, 9, 36, "Output",
 CellID->235429315]
}, Open  ]],
Cell[19342, 725, 121, 3, 70, "ExampleDelimiter",
 CellID->16281],
Cell[19466, 730, 58, 1, 70, "ExampleText",
 CellID->17746],
Cell[CellGroupData[{
Cell[19549, 735, 233, 9, 70, "Input",
 CellID->30299],
Cell[19785, 746, 1029, 37, 88, "Output",
 CellID->100753092]
}, Open  ]],
Cell[20829, 786, 121, 3, 70, "ExampleDelimiter",
 CellID->24592],
Cell[20953, 791, 51, 1, 70, "ExampleText",
 CellID->6413],
Cell[CellGroupData[{
Cell[21029, 796, 254, 9, 70, "Input",
 CellID->12808],
Cell[21286, 807, 427, 13, 51, "Output",
 CellID->392384986]
}, Open  ]],
Cell[CellGroupData[{
Cell[21750, 825, 285, 10, 70, "Input",
 CellID->28041],
Cell[22038, 837, 517, 13, 54, "Output",
 CellID->435149123]
}, Open  ]],
Cell[22570, 853, 121, 3, 70, "ExampleDelimiter",
 CellID->27576],
Cell[22694, 858, 197, 8, 70, "ExampleText",
 CellID->16924],
Cell[CellGroupData[{
Cell[22916, 870, 398, 14, 70, "Input",
 CellID->10657],
Cell[23317, 886, 424, 11, 36, "Output",
 CellID->686726126]
}, Open  ]],
Cell[23756, 900, 121, 3, 70, "ExampleDelimiter",
 CellID->23946],
Cell[23880, 905, 82, 1, 70, "ExampleText",
 CellID->29958],
Cell[CellGroupData[{
Cell[23987, 910, 239, 9, 70, "Input",
 CellID->26632],
Cell[24229, 921, 369, 10, 36, "Output",
 CellID->163776419]
}, Open  ]],
Cell[24613, 934, 120, 3, 70, "ExampleDelimiter",
 CellID->1627],
Cell[24736, 939, 51, 1, 70, "ExampleText",
 CellID->17831],
Cell[CellGroupData[{
Cell[24812, 944, 302, 11, 70, "Input",
 CellID->6441],
Cell[25117, 957, 568, 17, 36, "Output",
 CellID->99231143]
}, Open  ]],
Cell[CellGroupData[{
Cell[25722, 979, 108, 3, 70, "Input",
 CellID->583250231],
Cell[25833, 984, 692, 19, 133, "Output",
 CellID->62726988]
}, Open  ]],
Cell[26540, 1006, 121, 3, 70, "ExampleDelimiter",
 CellID->10637],
Cell[26664, 1011, 68, 1, 70, "ExampleText",
 CellID->21100],
Cell[CellGroupData[{
Cell[26757, 1016, 381, 12, 70, "Input",
 CellID->26637],
Cell[27141, 1030, 356, 9, 36, "Output",
 CellID->19941312]
}, Open  ]],
Cell[27512, 1042, 121, 3, 70, "ExampleDelimiter",
 CellID->31750],
Cell[27636, 1047, 68, 1, 70, "ExampleText",
 CellID->4654],
Cell[CellGroupData[{
Cell[27729, 1052, 237, 8, 70, "Input",
 CellID->28540],
Cell[27969, 1062, 614, 19, 36, "Output",
 CellID->8590264]
}, Open  ]],
Cell[28598, 1084, 120, 3, 70, "ExampleDelimiter",
 CellID->8827],
Cell[28721, 1089, 66, 1, 70, "ExampleText",
 CellID->26979],
Cell[CellGroupData[{
Cell[28812, 1094, 214, 7, 70, "Input",
 CellID->19046],
Cell[29029, 1103, 578, 17, 36, "Output",
 CellID->15232948]
}, Open  ]],
Cell[29622, 1123, 121, 3, 70, "ExampleDelimiter",
 CellID->25838],
Cell[29746, 1128, 69, 1, 70, "ExampleText",
 CellID->8081],
Cell[CellGroupData[{
Cell[29840, 1133, 387, 13, 70, "Input",
 CellID->898],
Cell[30230, 1148, 1497, 29, 70, "Output",
 Evaluatable->False,
 CellID->710596304]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31776, 1183, 236, 7, 70, "ExampleSection",
 CellID->79374911],
Cell[32015, 1192, 317, 12, 70, "ExampleText",
 CellID->18697],
Cell[CellGroupData[{
Cell[32357, 1208, 133, 4, 70, "Input",
 CellID->10293],
Cell[32493, 1214, 534, 17, 36, "Output",
 CellID->180037962]
}, Open  ]],
Cell[CellGroupData[{
Cell[33064, 1236, 128, 4, 70, "Input",
 CellID->6206],
Cell[33195, 1242, 271, 9, 36, "Output",
 CellID->13404059]
}, Open  ]],
Cell[33481, 1254, 125, 3, 70, "ExampleDelimiter",
 CellID->421777096],
Cell[33609, 1259, 98, 1, 70, "ExampleText",
 CellID->701851334],
Cell[CellGroupData[{
Cell[33732, 1264, 138, 4, 70, "Input",
 CellID->1667062147],
Cell[33873, 1270, 180, 6, 36, "Output",
 CellID->148027784]
}, Open  ]],
Cell[34068, 1279, 125, 3, 70, "ExampleDelimiter",
 CellID->240038012],
Cell[34196, 1284, 227, 7, 70, "ExampleText",
 CellID->351],
Cell[CellGroupData[{
Cell[34448, 1295, 245, 9, 70, "Input",
 CellID->4816],
Cell[34696, 1306, 366, 10, 36, "Output",
 CellID->56963503]
}, Open  ]],
Cell[CellGroupData[{
Cell[35099, 1321, 252, 9, 70, "Input",
 CellID->16238],
Cell[35354, 1332, 323, 9, 36, "Output",
 CellID->322306544]
}, Open  ]],
Cell[35692, 1344, 125, 3, 70, "ExampleDelimiter",
 CellID->177250742],
Cell[35820, 1349, 222, 7, 70, "ExampleText",
 CellID->396943745],
Cell[CellGroupData[{
Cell[36067, 1360, 486, 17, 70, "Input",
 CellID->708326668],
Cell[36556, 1379, 343, 10, 36, "Output",
 CellID->221724942]
}, Open  ]],
Cell[36914, 1392, 125, 3, 70, "ExampleDelimiter",
 CellID->506876756],
Cell[37042, 1397, 225, 7, 70, "ExampleText",
 CellID->13971],
Cell[CellGroupData[{
Cell[37292, 1408, 209, 8, 70, "Input",
 CellID->421],
Cell[37504, 1418, 569, 20, 36, "Output",
 CellID->725623822]
}, Open  ]],
Cell[CellGroupData[{
Cell[38110, 1443, 191, 6, 70, "Input",
 CellID->1683],
Cell[38304, 1451, 568, 20, 36, "Output",
 CellID->25097071]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38921, 1477, 223, 7, 70, "ExampleSection",
 CellID->2466],
Cell[CellGroupData[{
Cell[39169, 1488, 138, 4, 70, "Input",
 CellID->23668],
Cell[39310, 1494, 1143, 49, 89, "Output",
 CellID->124134625]
}, Open  ]],
Cell[40468, 1546, 120, 3, 70, "ExampleDelimiter",
 CellID->6395],
Cell[40591, 1551, 52, 1, 70, "ExampleText",
 CellID->27184],
Cell[CellGroupData[{
Cell[40668, 1556, 177, 6, 70, "Input",
 CellID->27928],
Cell[40848, 1564, 773, 17, 70, "Output",
 Evaluatable->False,
 CellID->784881662]
}, Open  ]],
Cell[CellGroupData[{
Cell[41658, 1586, 177, 6, 70, "Input",
 CellID->21866],
Cell[41838, 1594, 1246, 44, 64, "Output",
 CellID->628468295]
}, Open  ]],
Cell[43099, 1641, 121, 3, 70, "ExampleDelimiter",
 CellID->15266],
Cell[CellGroupData[{
Cell[43245, 1648, 278, 10, 70, "Input",
 CellID->9463],
Cell[43526, 1660, 1240, 24, 70, "Output",
 Evaluatable->False,
 CellID->323306203]
}, Open  ]],
Cell[CellGroupData[{
Cell[44803, 1689, 216, 8, 70, "Input",
 CellID->1286],
Cell[45022, 1699, 838, 18, 70, "Output",
 Evaluatable->False,
 CellID->696878787]
}, Open  ]],
Cell[45875, 1720, 121, 3, 70, "ExampleDelimiter",
 CellID->23166],
Cell[CellGroupData[{
Cell[46021, 1727, 234, 8, 70, "Input",
 CellID->28449],
Cell[46258, 1737, 1594, 30, 70, "Output",
 Evaluatable->False,
 CellID->345294772]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47913, 1774, 311, 9, 70, "SeeAlsoSection",
 CellID->26913],
Cell[48227, 1785, 1206, 44, 70, "SeeAlso",
 CellID->29023]
}, Open  ]],
Cell[CellGroupData[{
Cell[49470, 1834, 314, 9, 70, "TutorialsSection",
 CellID->21935],
Cell[49787, 1845, 167, 3, 70, "Tutorials",
 CellID->31588]
}, Open  ]],
Cell[CellGroupData[{
Cell[49991, 1853, 319, 9, 70, "MoreAboutSection",
 CellID->269430411],
Cell[50313, 1864, 165, 3, 70, "MoreAbout",
 CellID->626540035],
Cell[50481, 1869, 147, 3, 70, "MoreAbout",
 CellID->240694749],
Cell[50631, 1874, 149, 3, 70, "MoreAbout",
 CellID->2779509],
Cell[50783, 1879, 155, 3, 70, "MoreAbout",
 CellID->126662171],
Cell[50941, 1884, 145, 3, 70, "MoreAbout",
 CellID->445908150],
Cell[51089, 1889, 145, 3, 70, "MoreAbout",
 CellID->137195914]
}, Open  ]],
Cell[CellGroupData[{
Cell[51271, 1897, 305, 8, 70, "RelatedLinksSection"],
Cell[51579, 1907, 361, 12, 70, "RelatedLinks"],
Cell[51943, 1921, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[52344, 1937, 27, 0, 70, "History"],
Cell[52374, 1939, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

