(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    102822,       2552]
NotebookOptionsPosition[     94582,       2264]
NotebookOutlinePosition[     95951,       2302]
CellTagsIndexPosition[     95865,       2297]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NevilleThetaS" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaS"], 
          "NevilleThetaD" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaD"], 
          "NevilleThetaN" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaN"], 
          "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"], "JacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCN"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NevilleThetaS\"\>", 
       2->"\<\"NevilleThetaD\"\>", 3->"\<\"NevilleThetaN\"\>", 
       4->"\<\"EllipticTheta\"\>", 5->"\<\"JacobiCN\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NevilleThetaC", "ObjectName",
 CellID->18636],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NevilleThetaC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NevilleThetaC"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Neville theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CurlyTheta]", "c"], " ", 
        RowBox[{"(", 
         RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}]}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "c"], "(", 
     RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], "\[Equal]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", " ", "\[Pi]"}]], " ", 
       RadicalBox[
        RowBox[{
         InterpretationBox["q",
          EllipticNomeQ,
          Editable->False,
          Selectable->False], "(", "m", ")"}], "4"]}], 
      RowBox[{
       RadicalBox["m", "4"], " ", 
       SqrtBox[
        RowBox[{"K", "(", "m", ")"}]]}]], " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "0"}], "\[Infinity]"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         InterpretationBox["q",
          EllipticNomeQ,
          Editable->False,
          Selectable->False], "(", "m", ")"}], 
        RowBox[{"k", " ", 
         RowBox[{"(", 
          RowBox[{"k", "+", "1"}], ")"}]}]], " ", 
       RowBox[{"cos", "(", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], " ", "\[Pi]", " ", 
          "z"}], 
         RowBox[{"2", " ", 
          RowBox[{"K", "(", "m", ")"}]}]], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->654237551],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NevilleThetaC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaC"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is a meromorphic function of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " and has a complicated branch cut structure in the complex ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "\[Hyphen]plane."
}], "Notes",
 CellID->67591759],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->381856642],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316627680],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->804682800],

Cell["Evaluate numerically: ", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->478479045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{"2.", ",", " ", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713779413],

Cell[BoxData[
 RowBox[{"-", "0.2381464372572015`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224142031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175186327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"NevilleThetaC", "[", " ", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706241487],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWk1sXVcRvvWzk+C/2E7sOGkSO/VfHDt2HBf6I7X5T5o0aWmbtAsE1Elb
HFApKoEFbOgGNrBo2VCpahcFJH4WQUhFSEWqqIRaqaISohJqkaogobKgqtSK
RSSky5yZufeb971jxy6R8nznvHO++WbOzJy5975zS1eWH39y6crlS0ujp55e
+sby5UvfHD351NMy1LipKIpr8v/Z4UKuS7nS/9fKUv62fi7JZ0MmtCUpXZT6
r2iTyw009qSuuEijjfTRDrkoOrLrDqTPjW//+Z/PfO/Ve0+/dOiu508ce+Fb
V155/Y/vF2PyXYJoXxN2mnCbfv3hh/95/idvPnLh50Wb4BWNSxd//bOfvv3J
J9eLOZ2un10i/+D7rz319d/+4dW/y7WMXb/+3zff+Md3v/N70Z9mT6/bps/p
DAH84hd+ISo/+OBj9WD7e+/+WxjJoBi6X5fqZ0O0CIHfvfK3YqPKol7IyrJi
77p1f1bll158SzyZ2G+ofOEaZnXZbNArrIrPqCwaRU56p9at91b5aBO1nTou
LhVl6XKfTp/RUfHs5eWrSV9XpU9k4VZMpNUeVbnoWlT5V7/8y4+f+5Num8pi
ojg5XU4HLdDdrfI7f/2XWCW6lWNEPUjfdxNLQ1ULGgIpwOmyV+XfXH3nRz98
HdyAulD51vfQ5l+79pGgph3RPfWoEtslHNJon8pCRGKj4pY8cZAs3UxspgKa
xKwkTLrsq/wr6Mmyg8TxQBVnEuPpsp+0TyqqRZ9ACnC6HPA9ZrT5ym9isdip
84qGeFAsTtoNbYq8u6WSJUVTDCxkUSV/JGfSpc2XAJAwSJcTARWRsZXkA4Q6
V/ldtCZuW0k21EniNkhyHhXcBonFeEDF6BDJ877nzHGItBvaBI1uI3meOO4n
jjZfnCsuTpdjARXxNUwc5wh1lrgOkxxRJTxk44EKrnlUcNtO3G9R1HGKzx20
aj+hzpDWHcQ1oiKXeFYeFR67mdbvUdSxKifECelyp8pSQqSQwGJGhccMVdJT
kpRRgbKTtMx6RBmaVDrJvXS5i9BHFU3tT5XrgftfTpbuplkzxNEqI2rTLoqV
iIrR3eQvRp3OspAraQySHFGlvEnBAap8L6tSPc2jgsWIyjgrVDavBv+Nkn/3
ZVHhoRHapYiK6B2l3WDUvcTC1kv4SUGvbXUURDN7ZNr3fppsSGipio8EFOSQ
oaDqcvdTV3H3s80XYsKCuSEHbJawlFUro4KFxTXOI40s9y4iY5xmcbc0RfFp
qDi5IyricZxkRp3MsoBtEVWOVzlkgYooHvbdaQT0IvXame5nknhPELZmvWcA
6tQkWa+nSFMPt5H0NLJ64V8+G6JesLNVolRUp8vUi7RXdxE31J/ECfIoezzq
pZ4leHj99k6QJVPkZ63BXuXAbi/5ebBFb0eZ72onyIIp8m/UB1Z7yb95fVEP
y+OVP8VTQITnol7Ormb/trlX2zJaOY+myU96rvqJBW/uI59PZFHx/TR5I6Ki
inEPz6hjFGH7yNaIKkVbSjdQsaq6i2HLZ8hy7Wb8REflnCXLxrMc8f0MWR5R
YfkscWFUPvNnyfKIilio7x89gvKo4GY9E84D7f+8swLKHGkZy6LCj/vJtoiK
UUNF/jDqHrJ4jlhFVFhQ9+get2O+92z5PNmkXbf3s9B5gCLrlixHdCvzZFNE
xV1dQk0nfd5iUW0PPBwNkRjRoNM4SnMhLUaOo5356H0WyKahgCpOE9dhFnqb
PVlU9PQLbpNxHCaddmeKTiuPBm0LZNNQQIXOg6SFUUcIZZG0DAZU9GeLtAuj
HkHGERm8SGwMbRvpvJV2azTLEXG4SDYZalXLe4nDAKGls7e95orxXT7OsdFH
tnaX4US0z6YTrIdih/WPVLJAFhkeuytZHFKsyAfe6mph0GF/Gvan6syq4Xqa
PzNCtegq0e2kvzv8b91rePUeKXOMpWh4Kzjq6+zJDOrJSkxbfWjMUAf7g0b4
RGqIDzEjPf/b0ek3ezkhDFS2+9mxGrdGvauo3wNlrJnpWRmYpHH1STti1O6k
0jf2LAjR3OkaLJ64z7OnhbBkSxkyrSPyTc+l8n4Q2e+fmAU/laS+q9jks+1b
WLOVZldW1/dmzCFVFI9Fruj9lQe9glf5ZQzsaRSq4u0q4/5zN6HxU4Q7yubK
NRBQUeVsFir7rgxqsu3OsrmeGZp5A/XMZiFDc2ixQtxB3o2oqGOGivtMRrU+
B6f6nRQ5hppy+33dB+7oVd5Yy/IP2cFvUbJrV+nabzSfZdXXUfeLpeXspv8T
NctqQ7TYeiS+t1qvnjXJyF0rcy3viJitlXPGsncWqLGcmXy6mGfr7msFz24m
2TpI9HzsIZ5/Iw/U1TecPGu1FXl1W862UEl2Zq1Aj8lvirgy60nrozj/7yqb
K8rNWS14ZmXzkceGah5Azt+tMipLHhUVy1BRcyIqUO4mLYxqHS2q5SHSsjmg
wuJD5JHErc37hVQlD+v3qNmG0k+MD9Nu7shyQ5U8RLZEVHjXUOmeOqDWz/i9
Sh4hW3oDKiLhcBWvXg/zqLinOUK2GWpfheJRf1Rl3BVvz6Li+yNkW0RFr3SU
uDBq/a7Fc/ko2RZR0e/YLOTWdt9z44hT6Rh5Tvsmrw84i46rzO9UmCP8Z6jo
ViIq8vm4x1/eYuzxMbIloiFvj1NuMMchiscTlCXdARUZdYLkbVlUZPAJkg21
l7idJO55VGaBLgqoyX+nyDJGs+4JmXyK0LsCR/jjJMXANo8g44YMPkW2GFoP
6byH4nMoyxFxyDYBNVl8mnKI0eo3rV41bD76xc7AEVFtHJFZeVRk6mmKekPt
pmg9UzZXhcEsKiw/TVkSUeH1M+QBRt1CHjhDuxlRUbPPkAcGfc/Z8ntpN/U3
HfilhVt+liznXofPb0NFvYyo0H2WLGfUAbL8bGW518+ICt1nyfI8KlicUxnP
6LQj844Huu8jDzTKtb+JGSCG58juqBG87qNZa3sT0np/xzbAM1Ev2PGsT6sX
ltxPMabr/ddDYPf59NFy58H3P7nePIncN5hOnI5RJ5iZztrHK+is9pr3tS9n
QXi3GnUiM01n7d9VdK5mdx9Z8oDKqN32TMPuLpDHD+pe1rFerv4uhn9dZDpw
dkUdqGeqI+R+P6FuJk4PqYwzrCOgoqI/WPnWq14ONZ0n5/1vfKaD0/o8eakv
yw1cHiKuHQEVXfZ58kuf+9PQcPJdoEjQ+06PKkTNwyrj9OY7PDvdcVZdoEiI
qNgFQ0Ufx6g9FQuvrQ9Xse3vhSMqIoJn5VHB7RGVm6tohWqQmIWK3JtFRWyk
+W2yScbxUfI6r+6mmPiSrloir/f4HvZQxMTZ1BW3PDuEX74cVmE0vwqotuoi
RVs3reqk+Hk0rIKu/CrEh626RLr46UAneT6uQofIq6wCoharH4rHaJc73eOs
I87GrnWSjk2kQ+0vHtdR6m5aVkFXXAXf8SrLf5zMan/xhI7ifiH/zAz79FhY
hV9B5laleqaciq9QbFeV27Dxm1SbvUyM+PxqJ91PhFUyKliCuMIq1B9bdVlH
8fvV3Dmd7FD0VX8jrvvh9ZdPQZsvMF5PlkOs09mJp4tyIYgSATQuZCUyxD1f
XRmlN6LYAsESy9Mz/6KQnZBkkQ0V9K+tjNLUPZkNsl5cKFg6WT3nM1Zhs4bf
xH/adUshktLfb+to66/7i5v+BxPNlIQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50740484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203155056],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->418674895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"NevilleThetaC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385334140],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["z", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["z", "4"], "24"], "-", 
   FractionBox[
    SuperscriptBox["z", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["z", "8"], "40320"], "-", 
   FractionBox[
    SuperscriptBox["z", "10"], "3628800"], "+", 
   FractionBox[
    SuperscriptBox["z", "12"], "479001600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, 0, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 24], 0, 
    Rational[-1, 720], 0, 
    Rational[1, 40320], 0, 
    Rational[-1, 3628800], 0, 
    Rational[1, 479001600]}, 0, 13, 1],
  Editable->False]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->680547167]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16139],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->329173574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"NevilleThetaC", "[", 
    RowBox[{
     RowBox[{"18", "/", "10"}], ",", " ", 
     RowBox[{"41", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234864796],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "353.0661117961451597678909952911610762726159028561510917765011`50.\
1251506396317"}], "+", 
  RowBox[{
  "124.2786217957430515657049927690788338441697888395838584619624`49.\
671691033225734", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{379, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15627145]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->9807842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{"1.80000000000000000000000", ",", " ", 
   RowBox[{"41", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343782575],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "353.06611179614515976789099529116`20.875021291406846"}], "+", 
  
  RowBox[{
  "124.27862179574305156570499276908`20.423946648211125", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237880527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76533932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->592108485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{"z", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565132979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"NevilleThetaC", "[", 
    RowBox[{"z", ",", "2"}], "]"}], ",", 
   RowBox[{"NevilleThetaC", "[", 
    RowBox[{"z", ",", "3"}], "]"}], ",", 
   RowBox[{"NevilleThetaC", "[", 
    RowBox[{"z", ",", "4"}], "]"}]}], "}"}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69119592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "4"}], ",", 
     RowBox[{"1", "/", "5"}]}], "}"}], ",", " ", "2."}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144878634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.0035686449153294`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.05738457700033992`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.0007062547907801`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.025409308632680046`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.000223534652958`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.014283743500962285`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.0000915677664768`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.009140022912317271`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{308, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440997087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->848712893],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->657153339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"0.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701501174],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.8421261198857204`"}], "-", 
  RowBox[{"2.0304698438642395`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91285421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97528283],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " evaluates symbolically for special arguments and parameters:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->64218225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{"z", ",", " ", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70201537],

Cell[BoxData[
 RowBox[{"Cos", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120212938]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{"0", ",", " ", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677513287],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221751632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->551390728],

Cell[TextData[{
 "Format ",
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->402140406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NevilleThetaC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128180748],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[CurlyTheta]", "c"], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->331421689]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1835],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->259924736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{
   RowBox[{"z", "-", 
    FractionBox[
     SuperscriptBox["z", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["z", "3"], "9"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"]}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633875027],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["z", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["z", "3"], "2"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["z", "4"]}], "36"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "5"],
    SeriesData[$CellContext`z, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 
    Rational[-1, 2], 
    Rational[1, 2], 
    Rational[-7, 36]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{155, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90052917]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21069],

Cell[TextData[{
 "Plot over the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "-", "m"}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->367265575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"NevilleThetaC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"z", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "/", "2"}], "Pi"}], ",", " ", 
      RowBox[{
       RowBox[{"3", "/", "2"}], "Pi"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"m", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235130194],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->769819444]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72062006],

Cell["\<\
Current flow in a rectangular conducting sheet with voltage applied at a pair \
of opposite corners:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->680389630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"flow", "[", "m_", "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NevilleThetaD", "[", 
      RowBox[{"x", ",", "m"}], "]"}], " ", 
     RowBox[{"NevilleThetaD", "[", 
      RowBox[{"y", ",", 
       RowBox[{"1", "-", "m"}]}], "]"}], " ", 
     RowBox[{"NevilleThetaS", "[", 
      RowBox[{"x", ",", "m"}], "]"}], " ", 
     RowBox[{"NevilleThetaS", "[", 
      RowBox[{"y", ",", 
       RowBox[{"1", "-", "m"}]}], "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"NevilleThetaC", "[", 
      RowBox[{"x", ",", "m"}], "]"}], " ", 
     RowBox[{"NevilleThetaC", "[", 
      RowBox[{"y", ",", 
       RowBox[{"1", "-", "m"}]}], "]"}], " ", 
     RowBox[{"NevilleThetaN", "[", 
      RowBox[{"x", ",", "m"}], "]"}], " ", 
     RowBox[{"NevilleThetaN", "[", 
      RowBox[{"y", ",", 
       RowBox[{"1", "-", "m"}]}], "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35411314],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"x", ",", "m"}], "]"}], " ", 
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"y", ",", 
      RowBox[{"1", "-", "m"}]}], "]"}], " ", 
    RowBox[{"NevilleThetaS", "[", 
     RowBox[{"x", ",", "m"}], "]"}], " ", 
    RowBox[{"NevilleThetaS", "[", 
     RowBox[{"y", ",", 
      RowBox[{"1", "-", "m"}]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"NevilleThetaC", "[", 
     RowBox[{"x", ",", "m"}], "]"}], " ", 
    RowBox[{"NevilleThetaC", "[", 
     RowBox[{"y", ",", 
      RowBox[{"1", "-", "m"}]}], "]"}], " ", 
    RowBox[{"NevilleThetaN", "[", 
     RowBox[{"x", ",", "m"}], "]"}], " ", 
    RowBox[{"NevilleThetaN", "[", 
     RowBox[{"y", ",", 
      RowBox[{"1", "-", "m"}]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{468, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59818419]
}, Open  ]],

Cell["Plot the flow lines:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->41069000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", " ", "=", " ", "0.4"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"flow", "[", "m", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", " ", 
       RowBox[{"EllipticK", "[", "m", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"1", "-", "m"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ContourShading", " ", "->", " ", "False"}], ",", 
     RowBox[{"MaxRecursion", "->", "1"}], ",", 
     RowBox[{"Contours", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "0.02", ",", "0.13", ",", "0.3", ",", "0.54", ",", "0.9", ",", "1.46", 
        ",", "2.53", ",", "5.17", ",", "28.4"}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29651036],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnXk4VV/U+NOokZJKpdJASShNolaDZhpV0pwkRSpSmosIZWjQROYoKmQK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   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2205, 2208, 1689, 2197, 1610, 2193, 2066, 1979, 1981, 2213, 
         2071, 2072, 1428, 1982, 1347, 2214, 2073, 2074, 1429, 1893, 1901, 
         1696, 1348, 1761, 1349, 1697, 1902, 1903, 1698, 1699, 1422, 1701, 
         1700, 1247, 1762, 2082, 1446, 2081, 1447, 1604, 1306, 1498, 1751, 
         1752, 1780, 1779, 1605, 1606, 1499, 1500, 1411, 1778, 1412, 1753, 
         1895, 1896, 1669, 1670, 1413, 1881, 2127, 1243, 1302, 1754, 1658, 
         1659, 1756, 1755, 1599, 2049, 2050, 1882, 1883, 1884, 1660, 2037, 
         1405, 2036, 1406, 2038, 1596, 2035, 1404, 1875, 1876, 1877, 1655, 
         2025, 1397, 2024, 2027, 2026, 1593, 1745, 1388, 1744, 1870, 1232, 
         1291, 2183, 1442, 2079, 1443, 1743, 1742, 1477, 1737, 1381, 1775, 
         1380, 1736, 1473, 1474, 1575, 1772, 1379, 1733, 1219, 1277, 1566, 
         1435, 1731, 1730, 1214, 1272, 2172, 2173, 2076, 1433, 1726, 1725, 
         1465, 1649, 1650, 1720, 1719, 1328, 1648, 1375, 1643, 1325, 1715, 
         1324, 2006, 2007, 1959, 2096, 1908, 1907, 2212, 1320, 1998, 1955, 
         2091, 2191, 2192, 1523, 2195, 1630, 2211, 1193}],
        "5.17`"],
       Annotation[#, 5.17, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1192, 2210, 1629, 2194, 1711, 1522, 1995, 1524, 2090, 1954, 
         1360, 1997, 1319, 1712, 1713, 1640, 1639, 1714, 1642, 1814, 1813, 
         1803, 1374, 1543, 1263, 1205, 1647, 1327, 1718, 1550, 1464, 1463, 
         1723, 1724, 1432, 2075, 1431, 2171, 1271, 1213, 1728, 1729, 1771, 
         1770, 1565, 1472, 1471, 1732, 1378, 2175, 1437, 2174, 1436, 1281, 
         1222, 1734, 1735, 1774, 1773, 1584, 1476, 1475, 1740, 1741, 1440, 
         2077, 1439, 2182, 1290, 2112, 2111, 1869, 1441, 2078, 1387, 2023, 
         1395, 2022, 1394, 2153, 1295, 2118, 2117, 1873, 1444, 2080, 1396, 
         2034, 1403, 2033, 1402, 1595, 1594, 2189, 1445, 2186, 2188, 2187, 
         1747, 1242, 1746, 1401, 1777, 1400, 1497, 1496, 1301, 1598, 1410, 
         2163, 1409, 2164, 1668, 1246, 1666, 1667, 1750, 1749, 1342, 2065, 
         1421, 2064, 1420, 1603, 1602, 1759, 1760, 1665, 1664, 1758, 1305, 
         2131, 2130, 1894, 1419, 1695, 1694, 1900, 1899, 1692, 1346, 1757, 
         1345, 2069, 2070, 1980, 1423, 1609, 2068, 1608, 1764, 2196, 1688, 
         2207, 2204}],
        "2.53`"],
       Annotation[#, 2.53, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1191, 2209, 1628, 1710, 1709, 1521, 1994, 1996, 1986, 1359, 
         1993, 1638, 1802, 1801, 1789, 1366, 2004, 1531, 1532, 2095, 1804, 
         1367, 2005, 1323, 2011, 1373, 2010, 1372, 2145, 1262, 1204, 1459, 
         1326, 1716, 1717, 1646, 1645, 1462, 1722, 1212, 2104, 2103, 2170, 
         2169, 1557, 1469, 1468, 1727, 2107, 2106, 2105, 1434, 1564, 1276, 
         1218, 1470, 1377, 1852, 1851, 1280, 1221, 1853, 1582, 1583, 1864, 
         2015, 1231, 1480, 1589, 2180, 2181, 2177, 2179, 2178, 1739, 1236, 
         1738, 1386, 1776, 1385, 1484, 1483, 1294, 1235, 2116, 2115, 2185, 
         2184, 1393, 1492, 1491, 1299, 2124, 2123, 2122, 1399, 1657, 1656, 
         1241, 1495, 1597, 2162, 1408, 2159, 2161, 2160, 1663, 1245, 1892, 
         1662, 1341, 1748, 1340, 2062, 2063, 2061, 1417, 2167, 1304, 1891, 
         1890, 1693, 1418, 1691, 1690, 1898, 1897, 1887, 1424, 2067, 1607, 
         1763, 1765, 1687, 2206, 2203}],
        "1.46`"],
       Annotation[#, 1.46, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1190, 1627, 1635, 1708, 1706, 1315, 1989, 1990, 1985, 2140, 
         2139, 1254, 1185, 2089, 1790, 1354, 1992, 1318, 2003, 1365, 2002, 
         1364, 2142, 1259, 1200, 1454, 1322, 2009, 1371, 2008, 1370, 1542, 
         1541, 1458, 1457, 1644, 2099, 2098, 2097, 1376, 2146, 1549, 1461, 
         1460, 1721, 2102, 2101, 2100, 1430, 2168, 1556, 1467, 1466, 2013, 
         1217, 1840, 1275, 1842, 1841, 1574, 1220, 1848, 1279, 1850, 1849, 
         1581, 1862, 1861, 1285, 1227, 1863, 1384, 1479, 1478, 1289, 2110, 
         2109, 2108, 1438, 2176, 1383, 1482, 1481, 1293, 1234, 2114, 2113, 
         2152, 2151, 1331, 1490, 1489, 1298, 1239, 2121, 2120, 2156, 2155, 
         1336, 1494, 1493, 1300, 1240, 2126, 1880, 2048, 2047, 1339, 2053, 
         2054, 2051, 2166, 2165, 1303, 1244, 2129, 1889, 2060, 2058, 1344, 
         1767, 1769, 1686, 1681, 2202}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1189, 1626, 1634, 1358, 1707, 1314, 1991, 1622, 2087, 1948, 
         1353, 1988, 1520, 1704, 1705, 1615, 1613, 1703, 1253, 1182, 1451, 
         1317, 1637, 1800, 1799, 1363, 2001, 1530, 1453, 1452, 1641, 1203, 
         1957, 1958, 1956, 1321, 2144, 1369, 2143, 1368, 1540, 1539, 1456, 
         1455, 2012, 1209, 1823, 1267, 1548, 1821, 1266, 1208, 1822, 1555, 
         1831, 1830, 1270, 1211, 1832, 1563, 1838, 1837, 1274, 1216, 1839, 
         1572, 1573, 1847, 1580, 1226, 1858, 1284, 1860, 1859, 2014, 1382, 
         1868, 1867, 1288, 1230, 2020, 2021, 1909, 1910, 2149, 2150, 2147, 
         1392, 2148, 1653, 1654, 1488, 1487, 1297, 1238, 2119, 1874, 2032, 
         2031, 1334, 1912, 1335, 1971, 2046, 2045, 1661, 1886, 1885, 1878, 
         1414, 2052, 1600, 1601, 2128, 1888, 1416, 2059, 1343, 1766, 1768, 
         1685, 1680, 2201}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1188, 1625, 1633, 1357, 1621, 1618, 2088, 2086, 1947, 1987, 
         1313, 1940, 1312, 1984, 1352, 1614, 1351, 1519, 1518, 1450, 1612, 
         1611, 1702, 1252, 1517, 1449, 2190, 1448, 1636, 1199, 1952, 2132, 
         1953, 1905, 1316, 1951, 2094, 2093, 1362, 2141, 2000, 1906, 1361, 
         1999, 1796, 1258, 1798, 1797, 1538, 1202, 1537, 1536, 1810, 1809, 
         1261, 1812, 1811, 1547, 1207, 1818, 1265, 1820, 1819, 1554, 1210, 
         1827, 1269, 1829, 1828, 1562, 1836, 1835, 1273, 1215, 1571, 1278, 
         1846, 1845, 1579, 1857, 1856, 1283, 1225, 1588, 1287, 1229, 1866, 
         1389, 2017, 1390, 2018, 1391, 2019, 1651, 1652, 1486, 1485, 1296, 
         1237, 1966, 1967, 1911, 1913, 1914, 2125, 1879, 2044, 2043, 1337, 
         2137, 1338, 1978, 1415, 2057, 1673, 1676, 1427, 1684, 1679, 2200}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1187, 1624, 1632, 1356, 1620, 1617, 1184, 1946, 1950, 1939, 
         1944, 1942, 1181, 2085, 1936, 1311, 1931, 1310, 1934, 2084, 1928, 
         1309, 1923, 1308, 1926, 2083, 1919, 1350, 2138, 1983, 1904, 1307, 
         1921, 1788, 1251, 2092, 1516, 1787, 1250, 1513, 1785, 1249, 1175, 
         1786, 1529, 1198, 1528, 1527, 1197, 1795, 1257, 1526, 1793, 1256, 
         1196, 1794, 1535, 1201, 1806, 1260, 1808, 1807, 1546, 1817, 1816, 
         1264, 1206, 1553, 1268, 1826, 1825, 1560, 1561, 1834, 1569, 1570, 
         1844, 1578, 1223, 1854, 1282, 1224, 1586, 1286, 1228, 1591, 2016, 
         1292, 1233, 1872, 1329, 1961, 1330, 1964, 1398, 2029, 2135, 1332, 
         2136, 1333, 1970, 1407, 2158, 2040, 2042, 1973, 1977, 1975, 2056, 
         1672, 1675, 1426, 1683, 1678, 2199}],
        "0.13`"],
       Annotation[#, 0.13, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1186, 1623, 1631, 1355, 1619, 1616, 1183, 1945, 1949, 1938, 
         1943, 1941, 1180, 1935, 1937, 1930, 1933, 1932, 1179, 1927, 1929, 
         1922, 1925, 1924, 1178, 1918, 1920, 1915, 1917, 1916, 1177, 1515, 
         1514, 1176, 1512, 1511, 1174, 1510, 1509, 1173, 1508, 1507, 1172, 
         1506, 1505, 1171, 1504, 1503, 1170, 1502, 1501, 1782, 1781, 1248, 
         1784, 1783, 1525, 1194, 1791, 1255, 1195, 1792, 1533, 1534, 1805, 
         1544, 1545, 1815, 1551, 1552, 1824, 1558, 1559, 1833, 1567, 1568, 
         1843, 1576, 1577, 1855, 1585, 1587, 1865, 1590, 1592, 1871, 2133, 
         2134, 1960, 1963, 1962, 2154, 2028, 2030, 1965, 1969, 1968, 2157, 
         2039, 2041, 1972, 1976, 1974, 2055, 1671, 1674, 1425, 1682, 1677, 
         2198}],
        "0.02`"],
       Annotation[#, 0.02, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0, 1.7775193714912534`}, {0, 1.9495677498060258`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120697937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->539830174],

Cell["Parametrize a lemniscate by arc length:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->95554192],

Cell[BoxData[
 RowBox[{
  RowBox[{"lemniscate", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], " ", 
      RowBox[{"NevilleThetaD", "[", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], " ", 
      RowBox[{
       RowBox[{"NevilleThetaS", "[", 
        RowBox[{
         RowBox[{
          SqrtBox["2"], " ", "s"}], ",", 
         RowBox[{"1", "/", "2"}]}], "]"}], "/", 
       SqrtBox["2"]}]}]}], " ", "}"}], "/", 
   SuperscriptBox[
    RowBox[{"NevilleThetaN", "[", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", "s"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "2"]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417755930],

Cell["Show the classical and arc length parametrizations:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->406593316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", " ", "+", " ", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "^", "2"}]}], ")"}]}], ",", 
       
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{
         RowBox[{"Cos", "[", "\[Theta]", "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", " ", "+", " ", 
           RowBox[{
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "^", "2"}]}], ")"}]}]}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"lemniscate", "[", "s", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "/", "4"}], "]"}], "^", "2"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "Pi"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->664050487],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->764778154]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7573],

Cell["Basic simplifications are automatically carried out:", "ExampleText",
 CellID->303218647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{
   RowBox[{"-", "z"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540037476],

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->819633087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{
   RowBox[{"z", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156341269],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"NevilleThetaC", "[", 
   RowBox[{"z", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90000316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->678095437],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->491447878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], "3"], "+", 
     RowBox[{"NevilleThetaC", "[", 
      RowBox[{"z", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352650886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.7906464077328367`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->769924604]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11444],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->564243286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaC", "[", 
  RowBox[{
   RowBox[{"10.", "^", "30"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565074931],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->390185087],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281888746]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6990],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29408]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12593],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->4477]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->197635962],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->81850125]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NevilleThetaC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 59.7788708}", "context" -> "System`", 
    "keywords" -> {
     "elliptic function", "elliptic Neville theta function C", 
      "Neville theta function", "theta function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NevilleThetaC[z, m] gives the Neville theta function \\[CurlyTheta]_c (z \
\\[VerticalSeparator] m). ", "synonyms" -> {"Neville theta C"}, "title" -> 
    "NevilleThetaC", "type" -> "Symbol", "uri" -> "ref/NevilleThetaC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6987, 239, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->316627680]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 95722, 2290}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2300, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2923, 84, 51, 1, 70, "ObjectName",
 CellID->18636],
Cell[2977, 87, 776, 25, 70, "Usage",
 CellID->11210]
}, Open  ]],
Cell[CellGroupData[{
Cell[3790, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4268, 134, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4391, 140, 1331, 47, 70, "Notes",
 CellID->654237551],
Cell[5725, 189, 519, 17, 70, "Notes",
 CellID->67591759],
Cell[6247, 208, 258, 8, 70, "Notes",
 CellID->381856642],
Cell[6508, 218, 228, 7, 70, "Notes",
 CellID->31226],
Cell[6739, 227, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6987, 239, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316627680],
Cell[CellGroupData[{
Cell[7372, 253, 148, 5, 70, "ExampleSection",
 CellID->804682800],
Cell[7523, 260, 202, 5, 70, "ExampleText",
 CellID->478479045],
Cell[CellGroupData[{
Cell[7750, 269, 162, 5, 28, "Input",
 CellID->713779413],
Cell[7915, 276, 193, 6, 36, "Output",
 CellID->224142031]
}, Open  ]],
Cell[8123, 285, 125, 3, 70, "ExampleDelimiter",
 CellID->175186327],
Cell[CellGroupData[{
Cell[8273, 292, 300, 10, 28, "Input",
 CellID->706241487],
Cell[8576, 304, 3965, 69, 166, "Output",
 Evaluatable->False,
 CellID->50740484]
}, Open  ]],
Cell[12556, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->203155056],
Cell[12684, 381, 197, 5, 70, "ExampleText",
 CellID->418674895],
Cell[CellGroupData[{
Cell[12906, 390, 251, 8, 70, "Input",
 CellID->385334140],
Cell[13160, 400, 960, 32, 54, "Output",
 CellID->680547167]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14169, 438, 216, 7, 70, "ExampleSection",
 CellID->16139],
Cell[14388, 447, 207, 5, 70, "ExampleText",
 CellID->329173574],
Cell[CellGroupData[{
Cell[14620, 456, 247, 8, 70, "Input",
 CellID->234864796],
Cell[14870, 466, 401, 12, 54, "Output",
 CellID->15627145]
}, Open  ]],
Cell[15286, 481, 111, 3, 70, "ExampleText",
 CellID->9807842],
Cell[CellGroupData[{
Cell[15422, 488, 186, 5, 70, "Input",
 CellID->343782575],
Cell[15611, 495, 346, 11, 36, "Output",
 CellID->237880527]
}, Open  ]],
Cell[15972, 509, 124, 3, 70, "ExampleDelimiter",
 CellID->76533932],
Cell[16099, 514, 357, 11, 70, "ExampleText",
 CellID->592108485],
Cell[CellGroupData[{
Cell[16481, 529, 201, 6, 70, "Input",
 CellID->565132979],
Cell[16685, 537, 421, 13, 36, "Output",
 CellID->69119592]
}, Open  ]],
Cell[CellGroupData[{
Cell[17143, 555, 311, 10, 70, "Input",
 CellID->144878634],
Cell[17457, 567, 705, 16, 54, "Output",
 CellID->440997087]
}, Open  ]],
Cell[18177, 586, 125, 3, 70, "ExampleDelimiter",
 CellID->848712893],
Cell[18305, 591, 226, 5, 70, "ExampleText",
 CellID->657153339],
Cell[CellGroupData[{
Cell[18556, 600, 184, 6, 70, "Input",
 CellID->701501174],
Cell[18743, 608, 269, 8, 36, "Output",
 CellID->91285421]
}, Open  ]],
Cell[19027, 619, 124, 3, 70, "ExampleDelimiter",
 CellID->97528283],
Cell[19154, 624, 384, 11, 70, "ExampleText",
 CellID->64218225],
Cell[CellGroupData[{
Cell[19563, 639, 136, 4, 70, "Input",
 CellID->70201537],
Cell[19702, 645, 187, 6, 36, "Output",
 CellID->120212938]
}, Open  ]],
Cell[CellGroupData[{
Cell[19926, 656, 137, 4, 70, "Input",
 CellID->677513287],
Cell[20066, 662, 158, 5, 36, "Output",
 CellID->221751632]
}, Open  ]],
Cell[20239, 670, 125, 3, 70, "ExampleDelimiter",
 CellID->551390728],
Cell[20367, 675, 480, 17, 70, "ExampleText",
 CellID->402140406],
Cell[CellGroupData[{
Cell[20872, 696, 184, 6, 70, "Input",
 CellID->128180748],
Cell[21059, 704, 312, 10, 50, "Output",
 CellID->331421689]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21420, 720, 238, 7, 70, "ExampleSection",
 CellID->1835],
Cell[21661, 729, 221, 7, 70, "ExampleText",
 CellID->259924736],
Cell[CellGroupData[{
Cell[21907, 740, 333, 11, 70, "Input",
 CellID->633875027],
Cell[22243, 753, 687, 24, 54, "Output",
 CellID->90052917]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22979, 783, 223, 7, 70, "ExampleSection",
 CellID->21069],
Cell[23205, 792, 172, 7, 70, "ExampleText",
 CellID->367265575],
Cell[CellGroupData[{
Cell[23402, 803, 525, 18, 70, "Input",
 CellID->235130194],
Cell[23930, 823, 20481, 340, 70, "Output",
 Evaluatable->False,
 CellID->769819444]
}, Open  ]],
Cell[44426, 1166, 124, 3, 70, "ExampleDelimiter",
 CellID->72062006],
Cell[44553, 1171, 288, 8, 70, "ExampleText",
 CellID->680389630],
Cell[CellGroupData[{
Cell[44866, 1183, 956, 29, 70, "Input",
 CellID->35411314],
Cell[45825, 1214, 966, 30, 71, "Output",
 CellID->59818419]
}, Open  ]],
Cell[46806, 1247, 199, 5, 70, "ExampleText",
 CellID->41069000],
Cell[CellGroupData[{
Cell[47030, 1256, 910, 24, 70, "Input",
 CellID->29651036],
Cell[47943, 1282, 32335, 541, 70, "Output",
 CellID->120697937]
}, Open  ]],
Cell[80293, 1826, 125, 3, 70, "ExampleDelimiter",
 CellID->539830174],
Cell[80421, 1831, 218, 5, 70, "ExampleText",
 CellID->95554192],
Cell[80642, 1838, 1069, 37, 70, "Input",
 CellID->417755930],
Cell[81714, 1877, 231, 5, 70, "ExampleText",
 CellID->406593316],
Cell[CellGroupData[{
Cell[81970, 1886, 1238, 39, 70, "Input",
 CellID->664050487],
Cell[83211, 1927, 5144, 88, 70, "Output",
 Evaluatable->False,
 CellID->764778154]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88404, 2021, 232, 7, 70, "ExampleSection",
 CellID->7573],
Cell[88639, 2030, 95, 1, 70, "ExampleText",
 CellID->303218647],
Cell[CellGroupData[{
Cell[88759, 2035, 151, 5, 70, "Input",
 CellID->540037476],
Cell[88913, 2042, 221, 7, 36, "Output",
 CellID->819633087]
}, Open  ]],
Cell[CellGroupData[{
Cell[89171, 2054, 220, 7, 70, "Input",
 CellID->156341269],
Cell[89394, 2063, 239, 8, 36, "Output",
 CellID->90000316]
}, Open  ]],
Cell[89648, 2074, 125, 3, 70, "ExampleDelimiter",
 CellID->678095437],
Cell[89776, 2079, 96, 1, 70, "ExampleText",
 CellID->491447878],
Cell[CellGroupData[{
Cell[89897, 2084, 468, 15, 70, "Input",
 CellID->352650886],
Cell[90368, 2101, 227, 7, 36, "Output",
 CellID->769924604]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90644, 2114, 226, 7, 70, "ExampleSection",
 CellID->11444],
Cell[90873, 2123, 253, 7, 70, "ExampleText",
 CellID->564243286],
Cell[CellGroupData[{
Cell[91151, 2134, 159, 5, 70, "Input",
 CellID->565074931],
Cell[91313, 2141, 357, 7, 70, "Message",
 CellID->390185087],
Cell[91673, 2150, 187, 6, 36, "Output",
 CellID->281888746]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91921, 2163, 310, 9, 70, "SeeAlsoSection",
 CellID->6990],
Cell[92234, 2174, 1226, 44, 70, "SeeAlso",
 CellID->29408]
}, Open  ]],
Cell[CellGroupData[{
Cell[93497, 2223, 314, 9, 70, "TutorialsSection",
 CellID->12593],
Cell[93814, 2234, 191, 4, 70, "Tutorials",
 CellID->4477]
}, Open  ]],
Cell[CellGroupData[{
Cell[94042, 2243, 319, 9, 70, "MoreAboutSection",
 CellID->197635962],
Cell[94364, 2254, 146, 3, 70, "MoreAbout",
 CellID->81850125]
}, Open  ]],
Cell[94525, 2260, 27, 0, 70, "History"],
Cell[94555, 2262, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

