(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    125953,       3263]
NotebookOptionsPosition[    115662,       2907]
NotebookOutlinePosition[    117021,       2945]
CellTagsIndexPosition[    116934,       2940]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NevilleThetaC" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaC"], 
          "NevilleThetaN" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaN"], 
          "NevilleThetaS" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NevilleThetaC\"\>", 
       2->"\<\"NevilleThetaN\"\>", 
       3->"\<\"NevilleThetaS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NevilleThetaD", "ObjectName",
 CellID->31942],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NevilleThetaD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NevilleThetaD"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Neville theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CurlyTheta]", "d"], " ", 
        RowBox[{"(", 
         RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}]}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->269845972]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "d"], "(", 
      RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], "\[Equal]", 
     RowBox[{
      SqrtBox[
       FractionBox["\[Pi]", "2"]], 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"K", "(", "m", ")"}]]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"k", "=", "1"}], "\[Infinity]"], 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox["q",
              EllipticNomeQ,
              Editable->False,
              Selectable->False], "(", "m", ")"}], 
            SuperscriptBox["k", "2"]], " ", 
           RowBox[{"cos", "(", 
            FractionBox[
             RowBox[{"k", " ", "\[Pi]", " ", "z"}], 
             RowBox[{"K", "(", "m", ")"}]], ")"}]}]}]}]}], ")"}]}]}], ")"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->147493720],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NevilleThetaD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaD"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is a meromorphic function of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " and has a complicated branch cut structure in the complex ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "\[Hyphen]plane."
}], "Notes",
 CellID->267475031],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["NevilleThetaD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->269206836],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57506100],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->430942801],

Cell["Evaluate numerically: ", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->27128698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{"2.", ",", " ", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491064098],

Cell[BoxData["0.9090952774832136`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->959608496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367065575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"NevilleThetaD", "[", " ", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115404415],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173442040]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->131777478],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->195249063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"NevilleThetaD", "[", 
    RowBox[{
     RowBox[{"18", "/", "10"}], ",", 
     RowBox[{"41", "/", "3"}]}], "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246183492],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "342.77514192015351407205254022322030208698`30.125150639631702"}], "+",
   
  RowBox[{
  "120.65621933229678691050647337465782213598`29.671691033225738", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{470, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101426491]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->5262006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{"1.80000000000000000000000", ",", 
   RowBox[{"41", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->355126709],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "342.77514192015351407205254022322`20.60449652709838"}], "+", 
  RowBox[{
  "120.65621933229678691050647337462`20.174375888969728", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1720502166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152197557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->111878254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "0.5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73998127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8433150748865417`", ",", "0.9492701739196124`", ",", 
   "0.9904665582607235`", ",", "0.8743372009451004`"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->612597107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284720074],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->120058668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"0.2", "-", 
    RowBox[{"0.3", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59822958],

Cell[BoxData[
 RowBox[{"1.1866614170855576`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.17333179762845413`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->882973631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45121555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFormula"],
 " evaluates symbolically for special arguments:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->165638291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{"z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15277420],

Cell[BoxData["1"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1025815447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191736510],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->207815448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NevilleThetaD", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311187615],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[CurlyTheta]", "d"], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->881499613]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->527811175],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFormula"],
 " can be applied to power series: "
}], "ExampleText",
 CellID->317718863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"]}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192778272],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["\[Pi]", 
        RowBox[{"EllipticK", "[", 
         RowBox[{"-", "1"}], "]"}]], ")"}], 
      RowBox[{"5", "/", "2"}]], " ", 
     RowBox[{
      SuperscriptBox["EllipticThetaPrime", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"3", ",", "0", ",", 
       RowBox[{"Re", "[", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[Pi]", " ", 
            RowBox[{"EllipticK", "[", "2", "]"}]}], 
           RowBox[{"EllipticK", "[", 
            RowBox[{"-", "1"}], "]"}]]}]], "]"}]}], "]"}], " ", 
     SuperscriptBox["z", "2"]}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 8] 2^Rational[-1, 2] (Pi/EllipticK[-1])^Rational[5, 2] 
    Derivative[0, 1, 0][EllipticThetaPrime][3, 0, 
      Re[E^(-Pi EllipticK[-1]^(-1) EllipticK[2])]]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{515, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2021798685]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->125199713],

Cell["Plot over the arguments' plane:", "ExampleText",
 CellID->151609180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"x", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "/", "2"}], "Pi"}], ",", 
      RowBox[{
       RowBox[{"3", "/", "2"}], "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174272292],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309734943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304816084],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->54956261],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       FractionBox[
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "3"]}], 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "/", "3"}]], 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], "4", "\[Pi]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}]]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"Pi", "/", "12"}], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}], 
       RowBox[{"(", 
        RowBox[{"1", " ", "+", " ", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NevilleThetaC", "[", 
          RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}], " ", "-", " ", "\n", 
         "    ", 
         RowBox[{"NevilleThetaN", "[", 
          RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "+", " ", 
            RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}], 
          RowBox[{"NevilleThetaC", "[", 
           RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}]}], " ", "-", " ", "\n", 
         "    ", 
         RowBox[{"NevilleThetaN", "[", 
          RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"NevilleThetaC", "[", 
         RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}], "^", "2"}], " ", "-", " ",
        "\n", "   ", 
       RowBox[{"2", 
        RowBox[{"NevilleThetaC", "[", 
         RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}], 
        RowBox[{"NevilleThetaN", "[", 
         RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}]}], " ", "+", " ", "\n", 
       "   ", 
       RowBox[{
        RowBox[{"NevilleThetaN", "[", 
         RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}], "^", "2"}], " ", "+", " ",
        
       RowBox[{"2", " ", 
        RowBox[{"3", "^", 
         RowBox[{"(", 
          RowBox[{"1", "/", "4"}], ")"}]}], 
        RowBox[{"NevilleThetaD", "[", 
         RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}], "\n", "    ", 
        RowBox[{"NevilleThetaS", "[", 
         RowBox[{"\[Zeta]", ",", " ", "m"}], "]"}]}]}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317180885],

Cell["Show points before and after the map:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->53552400],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"N", "[", 
            RowBox[{"#1", "+", 
             RowBox[{
              RowBox[{"j", "/", "16"}], 
              RowBox[{"(", 
               RowBox[{"#2", "-", "#1"}], ")"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
        
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}], ",", 
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}], ",", "2"}], "}"}]}], "}"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", 
           SqrtBox["3"]}], ")"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"1", "/", "8"}], ",", "1", ",", 
        RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592588416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"w", "/@", "trianglePoints"}], ")"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86122901],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6112133]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223500304],

Cell[TextData[{
 "Uniformization of a Fermat cubic ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"a", "(", "u", ")"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"b", "(", "u", ")"}], "3"]}], "\[LongEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->465809535],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "u_", "]"}], ",", 
     RowBox[{"b", "[", "u_", "]"}]}], "}"}], "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "-", 
          SqrtBox["3"]}], ")"}], "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"NevilleThetaD", "[", 
            RowBox[{"u", ",", "m"}], "]"}], " ", 
           RowBox[{"NevilleThetaS", "[", 
            RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"NevilleThetaC", "[", 
               RowBox[{"u", ",", "m"}], "]"}], "-", 
              RowBox[{"NevilleThetaN", "[", 
               RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["3", 
             RowBox[{"1", "/", "4"}]], " ", 
            RowBox[{"NevilleThetaD", "[", 
             RowBox[{"u", ",", "m"}], "]"}], " ", 
            RowBox[{"NevilleThetaS", "[", 
             RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["2", 
            RowBox[{"1", "/", "3"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"NevilleThetaC", "[", 
              RowBox[{"u", ",", "m"}], "]"}], "-", 
             RowBox[{"NevilleThetaN", "[", 
              RowBox[{"u", ",", "m"}], "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SqrtBox["3"]}], ")"}], " ", 
              RowBox[{"NevilleThetaC", "[", 
               RowBox[{"u", ",", "m"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SqrtBox["3"]}], ")"}], " ", 
              RowBox[{"NevilleThetaN", "[", 
               RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"NevilleThetaC", "[", 
              RowBox[{"u", ",", "m"}], "]"}], "-", 
             RowBox[{"NevilleThetaN", "[", 
              RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"NevilleThetaD", "[", 
            RowBox[{"u", ",", "m"}], "]"}], " ", 
           RowBox[{"NevilleThetaS", "[", 
            RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25890382],

Cell[TextData[{
 "Plot the curve for real ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->445819958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "[", "u", "]"}], ",", 
       RowBox[{"b", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521221765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmdtL1EEUx8e9qCWW11pK0CwzLwRlIFGua+Yl7wYVdIEWifQhFfN/qId6
q4cyKMKCIChQ7DUIop567bl/ZDsz83PO7NnzO+sddWFnfzO/z/meM2fmN85v
HE7PTz54lJ6fmkjX9c2lZyenJh7X9c7MQVO0QCm1DN+VhILrDFyZ73ImA783
dRnVdfNRd/ZZq27cXRHlb+0y9Q+Lfzo7Xj1/9kMdFahbNz4C1dP9RqR+//o3
M730beWvR+3FzGx8DrSRnDawNm0kpxKFOeWp7e3XMJQxaIyzd0e8VsVQzSQb
Zw3XH2hGCR1jrTFL1nqMUNFArYlkK5zme6li2Cr1NwKNhZvI6ymSkwsChX2X
KOwzT218NteSWC+yNrUkVonCWHmKj6qGxHFZoDAOicI4eOoY8ZgUKPQoUeiR
pxLEYyprJBLEU0rQQE88dYR4uiJQ6JGnqnURs1rXxxfBqcB5at0sVZWjJnCe
2lWWqsxREzhPrcdQLRm7rjSy9NMn34GenV5SZQHXTDizmqlWr1UFarpKfZYT
jldrCHzRlfJ0nhgryP3GjLeq25XSu9uQJz+Vgne1ujrmVa3IGR2qq6N0q60Z
j+w1mo5MBZfTLIumLMXWoHaG1cnOnuZa2DGhs4lG0StQ6EOiNqZl/9TZz1f4
FpjqQWJbvMl60ZbYj428h6burgV1YIvjo/XoLs4CjCA06RHcmSzQ+cw/Bzj7
qsj9JlZ152f69msNDbwDqqtzQaRgFgOlZzFSGrLrkL/S8SrlJO4+gcK4earM
82nleO6wLuKOSyVf632DwMZsfBbsZ7lDOf29xnKlOTEOsJx5Wosc19/3FiPl
Lex8txaAqwj8qiiMTLAvGjRWo7ossdTkwy9+CVJ4bazjlDCtMdBM3/987+4n
kDVvETaiOFENNFJJm+SgNCGrElv3b3il6aV5izHvTeq461Uu+vLFT+igK0Hb
XdsgCRBkY9yo93rZsOo2X5Tm34zMPq3Y7SntJHEJLwm3KXTz3W1bS8Npb29b
xlJJb+T13rZaoPBJ46lLJj6n5VwLtKeZECjsBU9ln5u0kz7VsDbtxL9EoX+e
4t/KzpM4TggUxiFRGAdP8XHot3BuF2zvjnqtKpRqIX2pJ9TqqcJtj8Y+nSR0
RPCBfVyblTlTydq1hvczosJOKjZ/BlBPMnROoDAzEoWZ4Km9fVpI36o7BArz
JVGYr449nZn9eJZuHko32EOE4U8ZjY0b+nXYuImg9xbhKx93GotrmLxeyHfX
doq6nvzZ/wqpgv89gQYP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256541776]
}, Open  ]],

Cell[TextData[{
 "Verify that points on the curve satisfy ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"a", "(", "u", ")"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"b", "(", "u", ")"}], "3"]}], "\[LongEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->186161311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"Point", "[", "l__", "]"}], "\[RuleDelayed]", 
    RowBox[{"Map", "[", 
     RowBox[{"Total", ",", 
      RowBox[{"l", "^", "3"}]}], "]"}]}], ",", "Infinity", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->352610275],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtKAzEQTTdtxQtY+2AXqtJX8fIg4ifYJz9iKUL7IJXa/4+5bFYZFtKF
rMzICezOTpIdzp4Zkpx9q/br949qv1lVi+Wu+lxvVl+L1+3OdumBUsWzUuqp
VPbZ2Cd/xfZirx83eDfurptZ6jKzP/vn8YbEf2xYLWzn7EBb/tG8MoH+waM/
t/eR7dT1W2Mya8x8/Aj4RONrr8oL0vv7bWePmY+fAJ9YfN2rE/toN/8swfI9
WM4Q7zTBMmoZLEuJB5b5sDwxPPVOtKndJag2U7c2nZzHg9rOG++qYZVz9UV7
7dFCXQMfZ3xzd4PaBj7W+MLKj9Nd3ni3YBWsCokHVsGqlHiBVe4qOdo7j9bU
rT81TFU49SeZsyCtanLHo772WdCJLLi1QELVRjs86KsKw1uFSVeRwNfvuKvf
dJVTn5uKk65Cga/f8bBDFWQWreoR8XFOyOv7c1jntQZZQBbkx0MWOMRDFjjE
a89CinW3e0vSj1P/VaZuXf9pqME3NbDoyw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->84036821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46364941],

Cell["Parametrize a lemniscate by arc length:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->177387289],

Cell[BoxData[
 RowBox[{
  RowBox[{"lemniscate", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], " ", 
      RowBox[{"NevilleThetaD", "[", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], " ", 
      RowBox[{
       RowBox[{"NevilleThetaS", "[", 
        RowBox[{
         RowBox[{
          SqrtBox["2"], " ", "s"}], ",", 
         RowBox[{"1", "/", "2"}]}], "]"}], "/", 
       SqrtBox["2"]}]}]}], " ", "}"}], "/", 
   SuperscriptBox[
    RowBox[{"NevilleThetaN", "[", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", "s"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "2"]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461545843],

Cell["Show the classical and arc length parametrizations:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->845665902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], ">", "0"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", "0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"lemniscate", "[", "s", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "/", "4"}], "]"}], "^", "2"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "Pi"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->800344190],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{386, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42354705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->487046254],

Cell["Complex parametrization of a sphere:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->28550100],

Cell[BoxData[
 RowBox[{
  RowBox[{"ellipticSphere", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Alpha]_", ",", "\[Beta]_"}], "}"}], ",", "m_"}], "]"}], ":=", 
  "\[IndentingNewLine]", " ", 
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox["m"], " ", 
      RowBox[{"NevilleThetaS", "[", 
       RowBox[{"\[Alpha]", ",", "m"}], "]"}], " ", 
      RowBox[{"NevilleThetaS", "[", 
       RowBox[{"\[Beta]", ",", "m"}], "]"}]}], 
     RowBox[{
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"\[Alpha]", ",", "m"}], "]"}], " ", 
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"\[Beta]", ",", "m"}], "]"}]}]], ",", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["m"], " ", 
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{"\[Alpha]", ",", "m"}], "]"}], " ", 
      RowBox[{"NevilleThetaC", "[", 
       RowBox[{"\[Beta]", ",", "m"}], "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", "m"}]], " ", 
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"\[Alpha]", ",", "m"}], "]"}], " ", 
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"\[Beta]", ",", "m"}], "]"}]}]], ",", 
    FractionBox[
     RowBox[{
      RowBox[{"NevilleThetaD", "[", 
       RowBox[{"\[Alpha]", ",", "m"}], "]"}], " ", 
      RowBox[{"NevilleThetaD", "[", 
       RowBox[{"\[Beta]", ",", "m"}], "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", "m"}]], " ", 
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"\[Alpha]", ",", "m"}], "]"}], " ", 
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"\[Beta]", ",", "m"}], "]"}]}]]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36071541],

Cell["The square of all points on the complex sphere is 1:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->300652830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ellipticSphere", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"2", "I"}]}], ",", 
       RowBox[{"3", "+", 
        RowBox[{"2", "I"}]}]}], "}"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->212806752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "2.61213957546829496532159713156622436668`20.13724209890735", "+", 
    RowBox[{
    "0.65580144168638223199628619896516435937`19.53701808692778", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.90831008798950042530316122085881027061`19.65997429990458"}], "+", 
    
    RowBox[{
    "2.65961737924181596534347542968952610459`20.126559324453925", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "1.11816431808452074230237420509970852931`20.090905584496568"}], "-",
     
    RowBox[{
    "0.62845181599352277602085067152665883279`19.840671940713424", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{358, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2119143402]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->388814414],

Cell[BoxData[
 RowBox[{"0.99999999999999999999999999999`18.34585866484626", "+", 
  RowBox[{"0``18.525840603883548", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->426871919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82983447],

Cell["Conformal map from an ellipse to the unit disk:", "ExampleText",
 CellID->138105804],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"z_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", "=", 
      RowBox[{"InverseEllipticNomeQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "/", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], "^", "2"}]}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "m", "]"}], 
       RowBox[{"NevilleThetaS", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", 
            RowBox[{"ArcSin", "[", 
             RowBox[{"z", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"a", "^", "2"}], " ", "-", " ", 
                RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}], "\n", "      ", 
            RowBox[{"EllipticK", "[", "m", "]"}]}], ")"}], "/", "Pi"}], ",", 
         " ", "m"}], "]"}]}], ")"}], "/", 
     RowBox[{"NevilleThetaN", "[", "\n", "   ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", 
          RowBox[{"ArcSin", "[", 
           RowBox[{"z", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{
              RowBox[{"a", "^", "2"}], " ", "-", " ", 
              RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}], 
          RowBox[{"EllipticK", "[", "m", "]"}]}], ")"}], "/", "Pi"}], ",", 
       " ", "m"}], "]"}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352107157],

Cell["Visualize the map:", "ExampleText",
 CellID->269661815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"w", "[", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], " ", "+", " ", 
           RowBox[{"I", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"w", "[", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], " ", "+", " ", 
           RowBox[{"I", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281490551],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->664382986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64753],

Cell["Cartesian coordinates of a pendulum:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->155514320],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t_", "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "l", " ", 
       RowBox[{"NevilleThetaD", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"g", "/", "l"}], "]"}], "t"}], ",", " ", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "^", "2"}]}], "]"}], 
       "*", "\n", "    ", 
       RowBox[{"NevilleThetaS", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"g", "/", "l"}], "]"}], "t"}], ",", " ", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "^", "2"}]}], "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}]}], ")"}], "/", "\n", "   ", 
     
     RowBox[{
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"g", "/", "l"}], "]"}], "t"}], ",", " ", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "^", "2"}]}], "]"}], "^",
       "2"}]}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "t_", "]"}], " ", "=", 
   RowBox[{"l", " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "l", " ", 
       RowBox[{
        RowBox[{"NevilleThetaD", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"g", "/", "l"}], "]"}], "t"}], ",", " ", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "^", "2"}]}], "]"}], 
        "^", "2"}]}], ")"}], "/", "\n", "    ", 
     RowBox[{
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"g", "/", "l"}], "]"}], "t"}], ",", " ", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "^", "2"}]}], "]"}], "^",
       "2"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->119056588],

Cell["Plot the time dependence of the coordinates:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->35763337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"l", "->", "1"}], ",", 
       RowBox[{"g", "->", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "->", 
        RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0.1", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2994896],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->451197197]
}, Open  ]],

Cell["Plot the trajectory:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->138273096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"l", "->", "1"}], ",", 
       RowBox[{"g", "->", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "->", 
        RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0.1", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->232761379],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->353387430]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->496385360],

Cell["Basic simplifications are automatically carried out:", "ExampleText",
 CellID->201435483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{
   RowBox[{"-", "z"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462884903],

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2069671635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{
   RowBox[{"z", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78886733],

Cell[BoxData[
 RowBox[{"NevilleThetaD", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31055339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->393036074],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " for expressions containing Neville theta functions:  "
}], "ExampleText",
 CellID->146910023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NevilleThetaS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "\[Equal]", 
   FractionBox[
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], 
    RowBox[{"JacobiDS", "[", 
     RowBox[{"z", ",", "m"}], "]"}]]}], "  ", "//", " ", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->530672086],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108556352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196248980],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->180578001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"NevilleThetaD", "[", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], "3"], "+", 
     RowBox[{"NevilleThetaD", "[", 
      RowBox[{"z", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], "+", "z"}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123001478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"-", "0.8114080001578872`"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1292991761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->201186050],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->981706923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360529857],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->925503134]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"NevilleThetaS", "[", 
    RowBox[{
     RowBox[{"10", "^", "3"}], ",", "2"}], "]"}], ",", "20"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->143094373],

Cell[BoxData[
 RowBox[{"2.175281171968250143816657556985378`19.90607702187664*^99224", "-", 
  
  RowBox[{
  "3.138974764780554560819744005870325`20.065349445315668*^99224", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->707117917]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9047],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->209805832],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->79800858]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NevilleThetaD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 0.7163948}", "context" -> "System`", 
    "keywords" -> {
     "elliptic function", "Jacobi elliptic function", 
      "Neville theta function", "theta function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NevilleThetaD[z, m] gives the Neville theta function \\[CurlyTheta]_d (z \
\\[VerticalSeparator] m). ", "synonyms" -> {"Neville theta D"}, "title" -> 
    "NevilleThetaD", "type" -> "Symbol", "uri" -> "ref/NevilleThetaD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5840, 206, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57506100]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 116792, 2933}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1423, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2046, 63, 51, 1, 70, "ObjectName",
 CellID->31942],
Cell[2100, 66, 780, 25, 70, "Usage",
 CellID->269845972]
}, Open  ]],
Cell[CellGroupData[{
Cell[2917, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3395, 113, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3518, 119, 1056, 35, 70, "Notes",
 CellID->147493720],
Cell[4577, 156, 520, 17, 70, "Notes",
 CellID->267475031],
Cell[5100, 175, 258, 8, 70, "Notes",
 CellID->269206836],
Cell[5361, 185, 228, 7, 70, "Notes",
 CellID->31226],
Cell[5592, 194, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5840, 206, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57506100],
Cell[CellGroupData[{
Cell[6224, 220, 148, 5, 70, "ExampleSection",
 CellID->430942801],
Cell[6375, 227, 201, 5, 70, "ExampleText",
 CellID->27128698],
Cell[CellGroupData[{
Cell[6601, 236, 162, 5, 28, "Input",
 CellID->491064098],
Cell[6766, 243, 224, 7, 36, "Output",
 CellID->959608496]
}, Open  ]],
Cell[7005, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->367065575],
Cell[CellGroupData[{
Cell[7155, 260, 300, 10, 28, "Input",
 CellID->115404415],
Cell[7458, 272, 5433, 94, 163, "Output",
 Evaluatable->False,
 CellID->173442040]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12940, 372, 220, 7, 70, "ExampleSection",
 CellID->131777478],
Cell[13163, 381, 207, 5, 70, "ExampleText",
 CellID->195249063],
Cell[CellGroupData[{
Cell[13395, 390, 242, 8, 70, "Input",
 CellID->246183492],
Cell[13640, 400, 415, 14, 36, "Output",
 CellID->101426491]
}, Open  ]],
Cell[14070, 417, 111, 3, 70, "ExampleText",
 CellID->5262006],
Cell[CellGroupData[{
Cell[14206, 424, 181, 5, 70, "Input",
 CellID->355126709],
Cell[14390, 431, 391, 12, 36, "Output",
 CellID->1720502166]
}, Open  ]],
Cell[14796, 446, 125, 3, 70, "ExampleDelimiter",
 CellID->152197557],
Cell[14924, 451, 357, 11, 70, "ExampleText",
 CellID->111878254],
Cell[CellGroupData[{
Cell[15306, 466, 205, 7, 70, "Input",
 CellID->73998127],
Cell[15514, 475, 351, 11, 36, "Output",
 CellID->612597107]
}, Open  ]],
Cell[15880, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->284720074],
Cell[16008, 494, 226, 5, 70, "ExampleText",
 CellID->120058668],
Cell[CellGroupData[{
Cell[16259, 503, 210, 7, 70, "Input",
 CellID->59822958],
Cell[16472, 512, 322, 9, 36, "Output",
 CellID->882973631]
}, Open  ]],
Cell[16809, 524, 124, 3, 70, "ExampleDelimiter",
 CellID->45121555],
Cell[16936, 529, 370, 11, 70, "ExampleText",
 CellID->165638291],
Cell[CellGroupData[{
Cell[17331, 544, 131, 4, 70, "Input",
 CellID->15277420],
Cell[17465, 550, 207, 7, 36, "Output",
 CellID->1025815447]
}, Open  ]],
Cell[17687, 560, 125, 3, 70, "ExampleDelimiter",
 CellID->191736510],
Cell[17815, 565, 340, 11, 70, "ExampleText",
 CellID->207815448],
Cell[CellGroupData[{
Cell[18180, 580, 171, 5, 70, "Input",
 CellID->311187615],
Cell[18354, 587, 360, 12, 50, "Output",
 CellID->881499613]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18763, 605, 243, 7, 70, "ExampleSection",
 CellID->527811175],
Cell[19009, 614, 220, 7, 70, "ExampleText",
 CellID->317718863],
Cell[CellGroupData[{
Cell[19254, 625, 264, 9, 70, "Input",
 CellID->192778272],
Cell[19521, 636, 1446, 44, 74, "Output",
 CellID->2021798685]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21016, 686, 227, 7, 70, "ExampleSection",
 CellID->125199713],
Cell[21246, 695, 74, 1, 70, "ExampleText",
 CellID->151609180],
Cell[CellGroupData[{
Cell[21345, 700, 505, 18, 70, "Input",
 CellID->174272292],
Cell[21853, 720, 15796, 263, 70, "Output",
 Evaluatable->False,
 CellID->309734943]
}, Open  ]],
Cell[37664, 986, 125, 3, 70, "ExampleDelimiter",
 CellID->304816084],
Cell[37792, 991, 231, 5, 70, "ExampleText",
 CellID->54956261],
Cell[38026, 998, 2694, 79, 70, "Input",
 CellID->317180885],
Cell[40723, 1079, 216, 5, 70, "ExampleText",
 CellID->53552400],
Cell[40942, 1086, 1753, 54, 70, "Input",
 CellID->592588416],
Cell[CellGroupData[{
Cell[42720, 1144, 891, 29, 70, "Input",
 CellID->86122901],
Cell[43614, 1175, 8717, 148, 70, "Output",
 Evaluatable->False,
 CellID->6112133]
}, Open  ]],
Cell[52346, 1326, 125, 3, 70, "ExampleDelimiter",
 CellID->223500304],
Cell[52474, 1331, 480, 17, 70, "ExampleText",
 CellID->465809535],
Cell[52957, 1350, 3082, 89, 70, "Input",
 CellID->25890382],
Cell[56042, 1441, 282, 10, 70, "ExampleText",
 CellID->445819958],
Cell[CellGroupData[{
Cell[56349, 1455, 452, 14, 70, "Input",
 CellID->521221765],
Cell[56804, 1471, 1514, 29, 70, "Output",
 Evaluatable->False,
 CellID->256541776]
}, Open  ]],
Cell[58333, 1503, 350, 13, 70, "ExampleText",
 CellID->186161311],
Cell[CellGroupData[{
Cell[58708, 1520, 316, 10, 70, "Input",
 CellID->352610275],
Cell[59027, 1532, 735, 16, 70, "Output",
 Evaluatable->False,
 CellID->84036821]
}, Open  ]],
Cell[59777, 1551, 124, 3, 70, "ExampleDelimiter",
 CellID->46364941],
Cell[59904, 1556, 219, 5, 70, "ExampleText",
 CellID->177387289],
Cell[60126, 1563, 1069, 37, 70, "Input",
 CellID->461545843],
Cell[61198, 1602, 231, 5, 70, "ExampleText",
 CellID->845665902],
Cell[CellGroupData[{
Cell[61454, 1611, 1369, 42, 70, "Input",
 CellID->800344190],
Cell[62826, 1655, 5171, 90, 70, "Output",
 Evaluatable->False,
 CellID->42354705]
}, Open  ]],
Cell[68012, 1748, 125, 3, 70, "ExampleDelimiter",
 CellID->487046254],
Cell[68140, 1753, 215, 5, 70, "ExampleText",
 CellID->28550100],
Cell[68358, 1760, 1661, 49, 70, "Input",
 CellID->36071541],
Cell[70022, 1811, 232, 5, 70, "ExampleText",
 CellID->300652830],
Cell[CellGroupData[{
Cell[70279, 1820, 371, 13, 70, "Input",
 CellID->212806752],
Cell[70653, 1835, 840, 26, 71, "Output",
 CellID->2119143402]
}, Open  ]],
Cell[CellGroupData[{
Cell[71530, 1866, 92, 3, 70, "Input",
 CellID->388814414],
Cell[71625, 1871, 284, 7, 36, "Output",
 CellID->426871919]
}, Open  ]],
Cell[71924, 1881, 124, 3, 70, "ExampleDelimiter",
 CellID->82983447],
Cell[72051, 1886, 90, 1, 70, "ExampleText",
 CellID->138105804],
Cell[72144, 1889, 1619, 49, 70, "Input",
 CellID->352107157],
Cell[73766, 1940, 61, 1, 70, "ExampleText",
 CellID->269661815],
Cell[CellGroupData[{
Cell[73852, 1945, 1187, 35, 70, "Input",
 CellID->281490551],
Cell[75042, 1982, 19907, 332, 70, "Output",
 Evaluatable->False,
 CellID->664382986]
}, Open  ]],
Cell[94964, 2317, 121, 3, 70, "ExampleDelimiter",
 CellID->64753],
Cell[95088, 2322, 216, 5, 70, "ExampleText",
 CellID->155514320],
Cell[95307, 2329, 2146, 66, 70, "Input",
 CellID->119056588],
Cell[97456, 2397, 223, 5, 70, "ExampleText",
 CellID->35763337],
Cell[CellGroupData[{
Cell[97704, 2406, 568, 18, 70, "Input",
 CellID->2994896],
Cell[98275, 2426, 7215, 124, 70, "Output",
 Evaluatable->False,
 CellID->451197197]
}, Open  ]],
Cell[105505, 2553, 200, 5, 70, "ExampleText",
 CellID->138273096],
Cell[CellGroupData[{
Cell[105730, 2562, 580, 18, 70, "Input",
 CellID->232761379],
Cell[106313, 2582, 2724, 50, 70, "Output",
 Evaluatable->False,
 CellID->353387430]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109086, 2638, 237, 7, 70, "ExampleSection",
 CellID->496385360],
Cell[109326, 2647, 95, 1, 70, "ExampleText",
 CellID->201435483],
Cell[CellGroupData[{
Cell[109446, 2652, 151, 5, 70, "Input",
 CellID->462884903],
Cell[109600, 2659, 270, 9, 36, "Output",
 CellID->2069671635]
}, Open  ]],
Cell[CellGroupData[{
Cell[109907, 2673, 219, 7, 70, "Input",
 CellID->78886733],
Cell[110129, 2682, 268, 9, 36, "Output",
 CellID->31055339]
}, Open  ]],
Cell[110412, 2694, 125, 3, 70, "ExampleDelimiter",
 CellID->393036074],
Cell[110540, 2699, 248, 8, 70, "ExampleText",
 CellID->146910023],
Cell[CellGroupData[{
Cell[110813, 2711, 367, 12, 70, "Input",
 CellID->530672086],
Cell[111183, 2725, 209, 7, 36, "Output",
 CellID->108556352]
}, Open  ]],
Cell[111407, 2735, 125, 3, 70, "ExampleDelimiter",
 CellID->196248980],
Cell[111535, 2740, 96, 1, 70, "ExampleText",
 CellID->180578001],
Cell[CellGroupData[{
Cell[111656, 2745, 468, 15, 70, "Input",
 CellID->123001478],
Cell[112127, 2762, 296, 10, 36, "Output",
 CellID->1292991761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112472, 2778, 230, 7, 70, "ExampleSection",
 CellID->201186050],
Cell[112705, 2787, 253, 7, 70, "ExampleText",
 CellID->981706923],
Cell[CellGroupData[{
Cell[112983, 2798, 158, 5, 70, "Input",
 CellID->360529857],
Cell[113144, 2805, 240, 7, 36, "Output",
 CellID->925503134]
}, Open  ]],
Cell[CellGroupData[{
Cell[113421, 2817, 216, 8, 70, "Input",
 CellID->143094373],
Cell[113640, 2827, 345, 10, 36, "Output",
 CellID->707117917]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[114046, 2844, 310, 9, 70, "SeeAlsoSection",
 CellID->9047],
Cell[114359, 2855, 726, 26, 70, "SeeAlso",
 CellID->22153]
}, Open  ]],
Cell[CellGroupData[{
Cell[115122, 2886, 319, 9, 70, "MoreAboutSection",
 CellID->209805832],
Cell[115444, 2897, 146, 3, 70, "MoreAbout",
 CellID->79800858]
}, Open  ]],
Cell[115605, 2903, 27, 0, 70, "History"],
Cell[115635, 2905, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

