(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    274757,       5488]
NotebookOptionsPosition[    265679,       5175]
NotebookOutlinePosition[    267038,       5213]
CellTagsIndexPosition[    266951,       5208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NevilleThetaC" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaC"], 
          "NevilleThetaD" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaD"], 
          "NevilleThetaN" :> 
          Documentation`HelpLookup["paclet:ref/NevilleThetaN"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NevilleThetaC\"\>", 
       2->"\<\"NevilleThetaD\"\>", 
       3->"\<\"NevilleThetaN\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NevilleThetaS", "ObjectName",
 CellID->26660],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NevilleThetaS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NevilleThetaS"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Neville theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CurlyTheta]", "s"], " ", 
        RowBox[{"(", 
         RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}]}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->232553040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "s"], "(", 
     RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], "\[Equal]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", " ", "\[Pi]"}]], " ", 
       RadicalBox[
        RowBox[{
         InterpretationBox["q",
          EllipticNomeQ,
          Editable->False,
          Selectable->False], "(", "m", ")"}], "4"]}], 
      RowBox[{
       RadicalBox[
        RowBox[{"1", "-", "m"}], "4"], " ", 
       RadicalBox["m", "4"], " ", 
       SqrtBox[
        RowBox[{"K", "(", "m", ")"}]]}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "0"}], "\[Infinity]"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "k"], " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox["q",
          EllipticNomeQ,
          Editable->False,
          Selectable->False], "(", "m", ")"}], 
        RowBox[{"k", " ", 
         RowBox[{"(", 
          RowBox[{"k", "+", "1"}], ")"}]}]], " ", 
       RowBox[{"sin", "(", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], " ", "\[Pi]", " ", 
          "z"}], 
         RowBox[{"2", " ", 
          RowBox[{"K", "(", "m", ")"}]}]], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->332344037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NevilleThetaS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaS"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is a meromorphic function of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " and has a complicated branch cut structure in the complex ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "\[Hyphen]plane."
}], "Notes",
 CellID->357751223],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["NevilleThetaS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->41224833],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88103723],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->245459113],

Cell["Evaluate numerically: ", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->165320842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{"2.5", ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716090850],

Cell[BoxData["0.8497984190270284`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14710754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386901079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"NevilleThetaS", "[", " ", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131671312],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81615590]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->751110847],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->181752673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"NevilleThetaS", "[", 
    RowBox[{
     RowBox[{"18", "/", "10"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->949316997],

Cell[BoxData["1.\
1879407963330129755957858976647753569595000511390238840127301282526`50."], \
"Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81007909]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348792755],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->139999503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{"1.8000000000000000000000000", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40464168],

Cell[BoxData["1.18794079633301297559578589766477535696`24.016289119444245"], \
"Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178897488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327581776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->622073750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "0.4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56712901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8769664666018695`", ",", "1.114157523096203`", ",", "0.533532233481293`",
    ",", 
   RowBox[{"-", "0.433842815211433`"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225667784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139623543],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8497793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"0.2", "-", 
    RowBox[{"0.3", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97908953],

Cell[BoxData[
 RowBox[{"1.2627481312486235`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.119183990685058`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273608535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->788262499],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFormula"],
 " evaluates symbolically for special arguments:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->514284625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{"z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86235157],

Cell[BoxData[
 RowBox[{"Sin", "[", "z", "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8443951]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46966542],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->362547317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NevilleThetaS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->764212764],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[CurlyTheta]", "s"], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->119762613]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->192316772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NevilleThetaS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->682037774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"]}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222541118],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["\[Pi]", 
       RowBox[{"EllipticK", "[", 
        FractionBox["1", "2"], "]"}]], ")"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    RowBox[{"EllipticThetaPrime", "[", 
     RowBox[{"1", ",", "0", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Pi]"}]]}], "]"}], " ", "z"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["\[Pi]", 
       RowBox[{"EllipticK", "[", 
        FractionBox["1", "2"], "]"}]], ")"}], 
     RowBox[{"5", "/", "2"}]], " ", 
    RowBox[{
     SuperscriptBox["EllipticThetaPrime", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"1", ",", "0", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Pi]"}]]}], "]"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {Rational[1, 2] (Pi/EllipticK[
       Rational[1, 2]])^Rational[3, 2] EllipticThetaPrime[1, 0, E^(-Pi)], 
    Rational[1, 8] (Pi/EllipticK[
       Rational[1, 2]])^Rational[5, 2] 
    Derivative[0, 1, 0][EllipticThetaPrime][1, 0, E^(-Pi)]}, 1, 3, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{441, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433162790]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->154935901],

Cell["Plot over the arguments' plane: ", "ExampleText",
 CellID->262705325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"NevilleThetaS", "[", 
    RowBox[{"x", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "/", "2"}], "Pi"}], ",", 
     RowBox[{
      RowBox[{"3", "/", "2"}], "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45726795],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94438969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419712],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->112622043],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       FractionBox[
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           FractionBox["1", "3"], "]"}], "3"]}], 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["2", 
          RowBox[{"1", "/", "3"}]], " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]]}]]}], ",", 
      RowBox[{"m", "=", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "12"], "]"}], "2"]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"1", "/", "3"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["3"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NevilleThetaC", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], "-", 
         RowBox[{"NevilleThetaN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            SqrtBox["3"]}], ")"}], " ", 
          RowBox[{"NevilleThetaC", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "-", 
         RowBox[{"NevilleThetaN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"NevilleThetaC", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], "2"], "-", 
       RowBox[{"2", " ", 
        RowBox[{"NevilleThetaC", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
        RowBox[{"NevilleThetaN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"NevilleThetaN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], "2"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "4"}]], " ", 
        RowBox[{"NevilleThetaD", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
        RowBox[{"NevilleThetaS", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111426961],

Cell["Show points before and after the map:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->727922517],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"N", "[", 
            RowBox[{"#1", "+", 
             RowBox[{
              RowBox[{"j", "/", "16"}], 
              RowBox[{"(", 
               RowBox[{"#2", "-", "#1"}], ")"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
        
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}], ",", 
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["3"]}]}], ",", "2"}], "}"}]}], "}"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", 
           SqrtBox["3"]}], ")"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"1", "/", "8"}], ",", "1", ",", 
        RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->234316327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"w", "/@", "trianglePoints"}], ")"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73481383],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->69106609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134899328],

Cell[TextData[{
 "Uniformization of a Fermat cubic ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"a", "(", "u", ")"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"b", "(", "u", ")"}], "3"]}], "\[LongEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->63611837],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "u_", "]"}], ",", 
     RowBox[{"b", "[", "u_", "]"}]}], "}"}], "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "-", 
          SqrtBox["3"]}], ")"}], "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"NevilleThetaD", "[", 
            RowBox[{"u", ",", "m"}], "]"}], " ", 
           RowBox[{"NevilleThetaS", "[", 
            RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"NevilleThetaC", "[", 
               RowBox[{"u", ",", "m"}], "]"}], "-", 
              RowBox[{"NevilleThetaN", "[", 
               RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["3", 
             RowBox[{"1", "/", "4"}]], " ", 
            RowBox[{"NevilleThetaD", "[", 
             RowBox[{"u", ",", "m"}], "]"}], " ", 
            RowBox[{"NevilleThetaS", "[", 
             RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["2", 
            RowBox[{"1", "/", "3"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"NevilleThetaC", "[", 
              RowBox[{"u", ",", "m"}], "]"}], "-", 
             RowBox[{"NevilleThetaN", "[", 
              RowBox[{"u", ",", "m"}], "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SqrtBox["3"]}], ")"}], " ", 
              RowBox[{"NevilleThetaC", "[", 
               RowBox[{"u", ",", "m"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SqrtBox["3"]}], ")"}], " ", 
              RowBox[{"NevilleThetaN", "[", 
               RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"NevilleThetaC", "[", 
              RowBox[{"u", ",", "m"}], "]"}], "-", 
             RowBox[{"NevilleThetaN", "[", 
              RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"NevilleThetaD", "[", 
            RowBox[{"u", ",", "m"}], "]"}], " ", 
           RowBox[{"NevilleThetaS", "[", 
            RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17774370],

Cell[TextData[{
 "Plot the curve for real ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->445819958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "[", "u", "]"}], ",", 
       RowBox[{"b", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521221765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmdtL1EEUx8e9qCWW11pK0CwzLwRlIFGua+Yl7wYVdIEWifQhFfN/qId6
q4cyKMKCIChQ7DUIop567bl/ZDsz83PO7NnzO+sddWFnfzO/z/meM2fmN85v
HE7PTz54lJ6fmkjX9c2lZyenJh7X9c7MQVO0QCm1DN+VhILrDFyZ73ImA783
dRnVdfNRd/ZZq27cXRHlb+0y9Q+Lfzo7Xj1/9kMdFahbNz4C1dP9RqR+//o3
M730beWvR+3FzGx8DrSRnDawNm0kpxKFOeWp7e3XMJQxaIyzd0e8VsVQzSQb
Zw3XH2hGCR1jrTFL1nqMUNFArYlkK5zme6li2Cr1NwKNhZvI6ymSkwsChX2X
KOwzT218NteSWC+yNrUkVonCWHmKj6qGxHFZoDAOicI4eOoY8ZgUKPQoUeiR
pxLEYyprJBLEU0rQQE88dYR4uiJQ6JGnqnURs1rXxxfBqcB5at0sVZWjJnCe
2lWWqsxREzhPrcdQLRm7rjSy9NMn34GenV5SZQHXTDizmqlWr1UFarpKfZYT
jldrCHzRlfJ0nhgryP3GjLeq25XSu9uQJz+Vgne1ujrmVa3IGR2qq6N0q60Z
j+w1mo5MBZfTLIumLMXWoHaG1cnOnuZa2DGhs4lG0StQ6EOiNqZl/9TZz1f4
FpjqQWJbvMl60ZbYj428h6burgV1YIvjo/XoLs4CjCA06RHcmSzQ+cw/Bzj7
qsj9JlZ152f69msNDbwDqqtzQaRgFgOlZzFSGrLrkL/S8SrlJO4+gcK4earM
82nleO6wLuKOSyVf632DwMZsfBbsZ7lDOf29xnKlOTEOsJx5Wosc19/3FiPl
Lex8txaAqwj8qiiMTLAvGjRWo7ossdTkwy9+CVJ4bazjlDCtMdBM3/987+4n
kDVvETaiOFENNFJJm+SgNCGrElv3b3il6aV5izHvTeq461Uu+vLFT+igK0Hb
XdsgCRBkY9yo93rZsOo2X5Tm34zMPq3Y7SntJHEJLwm3KXTz3W1bS8Npb29b
xlJJb+T13rZaoPBJ46lLJj6n5VwLtKeZECjsBU9ln5u0kz7VsDbtxL9EoX+e
4t/KzpM4TggUxiFRGAdP8XHot3BuF2zvjnqtKpRqIX2pJ9TqqcJtj8Y+nSR0
RPCBfVyblTlTydq1hvczosJOKjZ/BlBPMnROoDAzEoWZ4Km9fVpI36o7BArz
JVGYr449nZn9eJZuHko32EOE4U8ZjY0b+nXYuImg9xbhKx93GotrmLxeyHfX
doq6nvzZ/wqpgv89gQYP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179723376]
}, Open  ]],

Cell[TextData[{
 "Verify that points on the curve satisfy ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{
      StyleBox["a", "TI"], "[", 
      StyleBox["u", "TI"], "]"}], "3"], "+", 
    SuperscriptBox[
     RowBox[{
      StyleBox["b", "TI"], "[", 
      StyleBox["u", "TI"], "]"}], "3"]}], "==", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->186161311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"Point", "[", "l__", "]"}], "\[RuleDelayed]", 
    RowBox[{"Map", "[", 
     RowBox[{"Total", ",", 
      RowBox[{"l", "^", "3"}]}], "]"}]}], ",", "Infinity", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->352610275],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtKAzEQTTdtxQtY+2AXqtJX8fIg4ifYJz9iKUL7IJXa/4+5bFYZFtKF
rMzICezOTpIdzp4Zkpx9q/br949qv1lVi+Wu+lxvVl+L1+3OdumBUsWzUuqp
VPbZ2Cd/xfZirx83eDfurptZ6jKzP/vn8YbEf2xYLWzn7EBb/tG8MoH+waM/
t/eR7dT1W2Mya8x8/Aj4RONrr8oL0vv7bWePmY+fAJ9YfN2rE/toN/8swfI9
WM4Q7zTBMmoZLEuJB5b5sDwxPPVOtKndJag2U7c2nZzHg9rOG++qYZVz9UV7
7dFCXQMfZ3xzd4PaBj7W+MLKj9Nd3ni3YBWsCokHVsGqlHiBVe4qOdo7j9bU
rT81TFU49SeZsyCtanLHo772WdCJLLi1QELVRjs86KsKw1uFSVeRwNfvuKvf
dJVTn5uKk65Cga/f8bBDFWQWreoR8XFOyOv7c1jntQZZQBbkx0MWOMRDFjjE
a89CinW3e0vSj1P/VaZuXf9pqME3NbDoyw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->362123272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4689963],

Cell["\<\
Current flow in a rectangular conducting sheet with voltage applied at a pair \
of opposite corners:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->135928130],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"flow", "[", "m_", "]"}], "=", 
   RowBox[{
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"x", ",", "m"}], "]"}], " ", 
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"y", ",", 
      RowBox[{"1", "-", "m"}]}], "]"}], " ", 
    RowBox[{"NevilleThetaS", "[", 
     RowBox[{"x", ",", "m"}], "]"}], " ", 
    RowBox[{
     RowBox[{"NevilleThetaS", "[", 
      RowBox[{"y", ",", 
       RowBox[{"1", "-", "m"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"NevilleThetaC", "[", 
        RowBox[{"x", ",", "m"}], "]"}], " ", 
       RowBox[{"NevilleThetaC", "[", 
        RowBox[{"y", ",", 
         RowBox[{"1", "-", "m"}]}], "]"}], " ", 
       RowBox[{"NevilleThetaN", "[", 
        RowBox[{"x", ",", "m"}], "]"}], " ", 
       RowBox[{"NevilleThetaN", "[", 
        RowBox[{"y", ",", 
         RowBox[{"1", "-", "m"}]}], "]"}]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->295932],

Cell["Plot the flow lines:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->465920297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", "=", "0.2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"flow", "[", "m", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"EllipticK", "[", "m", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"1", "-", "m"}], "]"}]}], "}"}], ",", 
     RowBox[{"ContourShading", "->", "False"}], ",", 
     RowBox[{"MaxRecursion", "->", "1"}], ",", 
     RowBox[{"Contours", "->", "50"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->872996547],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJysvXk8Vd/3+H9vszRIpUHzjEpSGlTrNM9Kc5GkkTI2aiRNqNBApVQoqVQi
KSWZpcwzCV1cMxfXvcbv+bx6rXNeZ9/f4/H+5+cfj+djnbPPXntYe+291953
tJH5hn2deDzejgk83v/9J/+S/Rfvr9kWClxOYHhn1LtrAeEZhDyf4bHryh/d
aSoini9h2E37tHXy9XLi/WqGuw247NtNsY5IT8Qw5aDjOu5XA5G+mOFTvEF2
i55LiO81M4x/KpEp1hO8IgH15XICw6gvV57PMOrLfb6EYdSX+341w6gvNz0R
w6gvN30xw6gvMle/NEK/NEK/NEK/NEK/NEK/NEK/NEK/NEK/NEK/NEK/NEK/
NEK/NEK/NEa/BRM+B31syGf043ICw6gfV57PMOrHfb6EYdSP+341w6gfNz0R
w6gfN30xw6gfMrf+BET9CYj6ExD1JyDqT0DUn4CoPwFRfwKi/gRE/QmI+hMQ
9Scg6k9A1J+A0U/z2PLBtfFljH5cTmAY9ePK8xlG/bjPlzCM+nHfr2YY9eOm
J2IY9eOmL2YY9UNG/eb/U5/VjH5cTmAY9ePK8xlG/bjPlzCM+nHfr2YY9eOm
J2IY9eOmL2YY9UNG/bwP3X3xrY+I0Y/LCQyjflx5PsOoH/f5EoZRP+771Qyj
ftz0RAyjftz0xQyjfsjc/tdA9L8Gov81EP2vgeh/DUT/ayD6XwPR/xqI/tdA
9L8Gov81EP2vgeh/DUT/Y8fN18N6r3Sc1cTox+UEhlE/rjyfYdSP+3wJw6gf
9/1qhlE/bnoihlE/bvpihlE/ZK59kRL2RUrYFylhX6SEfZES9kVK2BcpYV+k
hH2REvZFStgXKWFfpIR9kTL6BP+0Ld1k2Mrow+UEhlEfrjyfYdSH+3wJw6gP
9/1qhlEfbnoihlEfbvpihrn2sZ2wj+2EfWwn7GM7YR/bCfvYTtjHdsI+thP2
sZ2wj+2EfWwn7GM7YR/bGX12Q8sip0gehfpwOYFh1Icrz2cY9eE+X8Iw6sN9
v5ph1Iebnohhrv3uRJ0Qb5wKI2v/tQ+BcFsjeFxCFxHD7w4PU95ZXs9wgo9N
v8rERoYriwTdT79vYrjHiJXtcu5ShjH9v/5NApM+MqaPjOkjY/rImD6Z3ox/
+ks2kx4ypoeM6SFjesh/y/M1NEtHrLvyou3f+o5m+G95pjD8tz5yGP5b/oUM
/20/Aob/2ishw4HHf5sbHqlkGMsLGfVDRv2QUT9kzD/lO7nv8ZHYfqIZxvwj
Y/6RMf/ImH9kzD8y5h8Z84+M+UfG/CNjfi+kxx1/bsxn8ouM+UXG/CJjfpEx
v8iYX2T8HrZP7ngfyNQHMnc8DiTG40BiPA4kxuNAYjwOJMZjsv9EMu0R88Xt
T5FM/rD9c+cjCcR8JIGYjyQQ85EEYj6SQMxHEoj+nMZ8H/sL1jcyfh8Zv4+M
30fG7yPj95Hxe3/tVRHzPWRsX8jYvpCxfyBjeSOjfmT6f/2JUiZ9ZEwfGdNH
xvSRMX3y/b/jYSXzPjK+j4ztv3bFi7dfbCUMH38iOD9GqYWxPyhHRjn2D5Qj
oxz7C8qRUY79B+XIKMf6QTkyyrE8UY6McixflGP5IKMcn8fyIp9HOZYfyvF5
Uo6M9oBkrv8SzciRuf5PCuE/5RD+UiHhHwkYxvIk/S2yfEn/iyxf0h8jy5f0
z1DObY+sv0aWN8q57bOVKS+ufxRN+FMphD+WQ/hfhYS/JZDx38jxk/TnyPGU
9O/I8ZX098jxlvT/yPGX9AfJ8Zj0b8nxjvQPyfGa9BfJ8Zv0H8nxnPQnyfGd
9C/J8Z70N8nxn/Q/SX+A9EdJ/4D0T0l/AeVY/tzyC2XGcxwnueN7AuFPZBDj
fz7hXxQRz5cQ/ka5jP+A30X9uf5jNTOecNcnioj1iSJifaKIWJ8oItYnioj5
cikxXy4l5sulxHy5lJgvlxLztUpivsaOP9z5bg4xvy0k5rMChrG9IGP7QMb2
QM6PSftPzpdJ+0/On0n7z82PhJGjPUM5d/4TScx3Igl5GjE/SiOeTyP8uzTC
f8sn5kP5xHwon5gP5RPzoXxiPpQP3PmcgMivgMivgMivgMivgPD/BER5lxHl
W0aUJ7t+i+WN/Y/rzxQxjP2P68+UE+9XE/5MHfF+BjGe5zOM3+OO5yWEP1VO
vB9KzK8SiPlhBiHPJ+aLRcTzJQzrU7pFGuew/kPBNWhI4rqVYoYD6s5G5U+V
MJw0uSjEdEAzw9i/0F/H9P7aixSwPv0+K2xPA8OYPjKmj4z9meuvCwj/XMjw
otv9Kibur4KP/9iLPOb7yPh9ZPw+Mn4fGe0L194VEvZQyPCCrlUVnndrocRt
pmLDtj/M95Hx+8j4fWT8PjLaO7SPmB+uvRQQ9lTIMPZvZPz+3/YpZL6PjN9H
5vqTlYT/WEn4j5WE/1hJ+IuVhH9YSfiDlUz/Ju393/G3Frj+Qi1w/YNa4PoD
tcAd/2uBO97XAnd8r2XsCTLaE2S0J8joH/2tr3omv8hYX8iYf2TMPzLmHxnz
j4z5R8b8I2P+kTH/yJh/ZMz/4Vrzwm1VjUx+kTG/yJhfZMwvMuYXGfOLjPlF
xvwiY36RMb/ImF/u/DANFH+fFGRMwPE8j+G/3yti+G/6xQz/bW9lDKP9QMb+
jIz9GRn7EzL2J2TsT8iYX7dZAQHaIS1MfpExv8iYX2TMLzLmFxnzi4z5Rcb8
ImN+kTG/yH/LOwiGOVddeLwO5z/fGUZ9kFEfZNQHGfVBRn2QUR9k1AcZ9UFG
fZBRH2TM//qG/r6drHD+8J1hzD8y5h8Z84+M+UfG/CNj/pEx/8iYf2TMPzLm
99Yof4WZn/nUuLTVqwbNa2LG14V931LPRqP/482Mv8g/x4w8YOKI611x0P1e
6carWxoZxvJBxvSRMX2ScTzG9P+OJ5lQvtNup9SinmH8HjJ+Dxm/h4ztjZTj
+IvfRzkyyv/a23DI3rNe2awrrncnM4z1i/zXXmUx/Nc+Fcgwtp+/9ukPI8f6
R/5rn0plGN+fsN2v4a5NBSNHRrlh4rHCoNU1jBzbCzLK8Xksf5Rje0JGOT6P
9YNyZJRjfaEc6wsZ5fg81g/Ksb0afHYoT7nXwdQHMtYHydjesT5QjoxyrA+U
Y39ERjk+j/WFcqwvZJTj81hfKMf+jIxyfB7rD+XY35FRjs9j/aEc6xcZ5fg8
1h/KsX6RUY7PY32iHO0JMsrxeaxPlP+dH3iAlUNRnvIgXE/wYOwP1ifK0X4i
Y30iY39DxvpERvuKjPWHjPWLjPWFjPWJjPWDjPWHjPWBjPWFjOWPjPWDzN2P
CGXaP86/ufPfUGJ+StrnQGL9JIWxZzhf4tp3Nv6MnK/gfIdrv9n9CnI+g3Ku
fc9m2pPRP/5sAdNekLG9IOP3kfH7yPg9Uo7zGfw+ypFRjvn56+8VM/lBxvaN
jPlDxvyRcpzPYH5QjvlFRjk+j/kj0/s7H69gvoeM7yNj+98kr7RGzrKZsVfI
2L6RsT0jY/tFxvaLjO2XZPTfsDzR/8TyREY5vo/6kc+jHMsfGfXF5/F9lGP5
kOlj/vB9lGN9kOnj8zj/wPEH119Qjvrjegky7g/gfASfR8b0cH7C9R8aZPxn
TJ/bHlqY/kr61yjntg/2fcwfzn+4/j87PuP75P4HPo/zNRyvkdHeY/kh4/oS
6a/gehC2R9w/wPkePo/MHU+qZfwbTA/Tx/RwvsidP1QS/kKdzHwA08P2i4zf
w/SxfvF9ZK6/IpKZX2B62P7J72H62F648x0RUd4NMv4WmT6mh/Nhrv/Jju/Y
nvB9TA/fx/ZCzn+4+xUJjD+A4ze538Md/zJk/DXu/k0ysX+SwjyPzPUv8mX8
O+5+Thax35NDzN9ymPRwPZOcr3HjO/4Q+z0FxH5QIVEehYT+JTLzP0wP+wf5
Pe5+kYCYbwoIf6pcZj6J6WF/Ib+H6WP/49aPkCjvapn5KaaH/YX8HqaP/ZE7
P64k/L86mfkupof9hfwepo/9kdseaon6FcnMnzE97D/k9zB97I/kfJt8H5/H
/obP4/4a+sPoH3P358Qy67m4Hoz2mtw/I9d7Uc6dbxcx4w2u33Ln16XE/pKQ
mG+XEvPtUmK+za4P43iL5U36B+R+FHc9q0HGX8DnsTxRjozfw/yT/gO+j/aM
u37XKOMf4PM4HuLzyKR/geMv1z+OI85XJDDjG+mP4/Pc+KA4Zn+FG39UKHOe
A+XYnnF9g7t/mknUfyaxn5pJ7KdmEvupmUR8exGzvkuetyD3M1CO+UN/HfOH
jPlDxvwhY/6QMX9ceQaxf5xC7NeVyOx3kOcnyPaMcu5+bhmjD/rzqA8yd3+X
PW+BctQHGfVBxvkf9/xGCnNegRvvXEnEm1QT8c6VRHxJNRH/XEnEl1QT8dCV
RHwJe96C3H9BOde/rSDicyqIeJNqIj6ngog3Yc9rkPFk3PykEOcnConzESUy
+z0o58bjiYh4PPb8BbnfQ57HIPd/yPMZ5H4QeV6D3B8iz5+Q+y3k+Qxyv4h7
nkIgcz6D3C8iz2uQ+0fk+Q1yP4k8z0HuL5HnO8j9JvK8B7n/RJ7/IPejuO9H
E+c1chjG/kPuT5HnPcj9KvL8B7l/RZ4HIfezyPMh5P4WeV6E3O8iz4+Q+1/k
eRJyP4w8X0Luj3HfjybiU9KY8Q/X35DRX0ZG/xYZ/VFk9O+Q0Z4mvss9453X
xIz/yCgn1w9QjuM9Msox/+jPoBzHe2SU4/M4nqMcmSwPnD9jeXDn/0Uy6/34
PJYHuf5Ars9w9yPqZMqPjI8ky5OMjyTLj7v+LpZZb+HGTwYR8YNpzHwS9SfX
17nzyWKZ+Ef8PpYHGf+IciwPMv6R3O8g4x/J/Q0y/hHlWB5k/CO5n4H6YXmQ
69nc9YsEYn3ku0z8I3d+nyYT/0iWLxn/SJY3Gf9I7l+Q8Y/kfgUZ/0juT5Dx
j+R+BBn/SO4/kPGP3PIKJeabCTLrB+T8n5y/k/Ntcn5MzmfJ+Sd3v6CeWZ/H
9Xdcb0d9cb6E+iFje/q7vlJFrLdUMfYEGe0drv+jvcZ4TLRvuB+A6SGj/cbn
ufsL3sz3kLnjdSSz3oXzD9QPGfOHjPohY/mQzJ2PhDPzX1zvQcb1GmRcX+Hu
H7HxZPh9ZCwfknG/hLs/EkqURyCxXxJInKeKI+SRRHxiKHHeKo7wlyKZ9UqU
Y38iyxfbF7c9JDD6oJyrbwKxPpAC3P3+BCLeLoE4H5JCnOfIJNpHGtM+UI7t
AxnbP85Hue0jm9Ef52uYHs53sHyx/6D+OB/grp9WEeufVcR8nN0/QTnaE+75
kWRmvRvbH4732P6QcT0OGdfPkFE/ZNQPGcsLGddDuOnXy/g/GJ/EjbeTgFKD
UNpnYgMUtIUraaiz8cCkP4TPc+PzJDBdfW3tw15i5n1s76R/hM9z4/kksN7E
v2SyqIl5H+03Nx41nClfZO55j2SZ8yVcf6dQJh4C00Mmz5tw61MoEy+BcmSu
/1ZJxFNVysRDkPFRqC/KkbH+yPgpUk6+j/lBfx/fx+dRju0F5cjc8mLjK7D8
cT0fmTzfwt3vSZZh8vwLN70UmfgL7v5Olsx5GW48WI5MfAUZP0OepyHjv3A/
A+0rMnc8Zve/yHgU8rwLGY/C3Y8Ilzn/QvqD3PMt4YR/Fi0TP8Y9b5LHMPZn
8rwIjo/oj3LPf4QT5z2+E+vPCQyjnHv+NJk4f5pGfC+DYZRzz6dmMYz6cL+f
zzDK8Xm0v8jo3yJje0BG/xYZ7QMytg9kbjx5EWMvyfhqUo6M/RXHK248Wymx
HsueTyHjAcjzKjhe4fdxvYu7v8ueZyH9S5Rz93crmf7LXZ9PYRj7HzLaX2Ts
b8hoX8n4AlwvRybPx6Acx0eSyfMzKEcm57c4Hl3OCDq3fEY98G+7rFqVxp6v
wefzOl34YPW4gZF791M+ljGkkeHm+SV+/MtihsPWnD+0r4Nl7nlnb+K8M+lf
RxLxOuz9WOjvcc8TxxHnh+OI99OI81Gsf4b7ATgeoX+Fz3PX09OI+sgj9mOK
iP2SYoax/yDj98jzTeR6DXm+CeVYnshYnsiYP+54WCSzfoKM9h6Z239aGf25
8QJ5DGP/4Y6HQTLzVXL+gfWL7elv/X0kzpuHEufjUojzcSnE+bgUpr+if6BT
vG7eS796xt8yGRU4fe6tRoav6g1WiTvJ+mNo/7n9uY7wx0REfDYb74zjC45P
OK/kjj8exP6mB7F+8Fom3hHtL/Z3jC/D/oHMnY9mM+2NPF+I9pp7XkrI2AMs
D2S0F2gPUI6McqxPlCOjHO0FypFRjvYD5ciM/269ytv5kISRY3tBe4dytD/I
+D6WD/ZvtAfI6A9ivXHbqzfRfgMZ/xLl3PUPb8D7Bg9seDXtwFLRvBTCvpH2
So44v0eetyP3t36pH7h+xVUic95RaW7dukwFNr7G6NbOXjuzeRR+3/Lf/pX8
L/sQ81kc/0x7XbZ3vScBx/bxgS0fpGDwc+Gq7RoS0Po62f9+aAuYXF5gPPhc
Azwyi75UacejzP/t/7f/9U/uE/7TQsIfIv0bnT/zHybebYI7P4ap29u1QYb5
6FHPFzfBovGblm9Z2g6Pw0c8+xHRCP0Dch7NGsSjeq6tlp+iKIbrx462JQo6
QH1klxGb4sVQWHDn0jFeB9S152Td1hVA8aifl4fdo793Q8VV10wIwu2vK/TO
8inIWqYat78SWhZ6njPcx6dmK8Ye62RXCW+M3AO37qV51XA/uYAaUOr5/t78
uXxql0vUVunxWvg9WziCN5VPpRPxpVrTXVX2F9LjRA/7rgbrCuH9+kWLJwZJ
oV/S8t7fq0qgIspJcXmGWCZ+qda3wjyqg7WXN191f5ZwmEf9DNvbv/Dc/0d8
hH2Vfo4vay/ucNZ7iiBzt7+6mhe7nrd1lzAx+LLs+eXXrX7CXZFs/9gZ8yhv
9iZ2fx71yxrPXa/B9uE+A3xv75TC26v2yRKLWrB3WatZsFEKMfrTv24bXwcT
fALevJskBVHas26WX0Qw9Oq0Ey5KUvD8Psx2ZO8GGLCqqfWuVALnH3jaRfdr
hEHT617m5Emgx/bo/p1rxVBsOfxrjaYElCft/7g1sAXej334ym58A5wWRsRs
fsCj5vzb3lD/jH/zOy3qb//zcLpt1B5PzxcDV0wRvuFRR979tbf4vP/0s6/G
9qyGBcfcgn/p8KlireqHC0KqoePlAVXtFXwqx/3jOL23tXBaoDZt/kQ+5XPC
bIPKlToYPScbZg3gU38qLkV6udRBwpHLugWKfCq33aSxW4IIlryYUJ1cwKOE
mtua9FaKYJ9pQviUeh5VNcR50ZS+9bDSbJ3p/TQe9cql9VVPFwmoSlJGX6yQ
wqk26bPTeyWgWxM9tOFjM+P/lV1oWle9l8/E58y0bxjfZyafibfxMDNPDujP
Z+JpDFcNzo+L5lHLF/QY+9I6fR7e74Tjjeu/+ucR51dGxvFWn7eWMvvDWN8T
zV2HN96uhN/bnR5N3y5l9lvtc+t712tLmf3W8Yr7HUNHSZn9Rdc9VSN+dpMy
+4va8nsP2lax+2fdw93rDNLY+9qK5J4oDy6QwOOdeXdO2zXBmGnzR8V+l0D/
PTPL4jZIYFfc3GkGpU1QPOfl7anerfDt80DFyPViiA42XSn2YtfLveS9XbdW
suvxKreKvnVbw65Xhz44ZOM5kk+NETdFTD/Orl/LE/dJoX18/K99lOOsV2ZD
38tKwXHdmoGXsUdvpFIeWNQsUF7UpRlMJJFP1wbnMc/j+HtObPpOO1kKD+4F
DZnsWQTu+1Vev4iVwk29PXpyEwUy98PM6tZjkI6/lLaDdjuGHS2FNZo7W176
SKGwp9G0W75lzPqDHXE/kt3/T/cj4Xgx5l//GsuDIvxtv3/9a+Q3/7Lyv/4U
jgeTiPXsrsR6dvf/sb79v9a7Sf75tKTU+sYfcOjTJUL8gE+1Vpjvcu9bCj/T
K18m2PGp3vI7HIYJpVCjZx/SaU0BbIjvdvP8VylkBfwcubFbMbMe1DKzxytq
eRsk9t7CF8Sz60P2+h237OY3geeitiYn3Xao1nCpWOcgux4y++vcKQcVedTN
ruqXheMaYfuZgY8Xr+dRWkMCnR8ENMqsV5y2HT1oxkJ2vQLL79b/WI+A/7He
8L/WE1aWtWS7ZRaCSZ+Oe+mv+NSTb6Et9bOKIKLzy6qkF+x6QkcPv88lL9n1
BA0FrzlT3fnUoRFaRjvXFAPP4cMHayc+VTKjukhqVAKqgnMpMxzY9YbLU0bv
lbvOrjfMdt8YlGrDpx68lkq7ZQphYt9Z652s+dT3fkZNY46Vg4ODTn4vK3Y9
QlvfdciQ43zqRsfgCKtMdv5zUL4qUZ8nYeYvOL+M9bi94Mb3FiDXc8j1GbJ8
qlpheMRP9nxgcdz9fVFPyiFrkSVYWtD5db9nuHRoJdNf0F9XUry14NJhPrXj
rarhja8SeO+zsOnwE9ZfreiafNrRXArzst+/UvZn/VeUN3/9rKnl+wh2rJma
pX2TnR+jP6nSPkon1Nx1HpefMfwo9O6nhNS3hDyI4YD5voV+8p+J58MY3puv
fzH6SQTxfjTDVcOLBwXNjyPS+8Gw9U7Tl0+zE4j0kxi2TTj16PvcFOJ7qQwv
r15gHN4jnfh+BsPyfTprfsrIJPKTzXDylJhWf+8cIn95DN9Z6xjta/WLyG8+
w6+DJsauH1VA5J9l52g5vzVXCgl9ihg+klHhsqK6iNDvD8ObS34eX7JZQOhb
zPBs8Rs96nMxoX8Jw0O73aTmjS0lyoPl1oFHx892EBLlU8bw7/Fbes6oYznp
n/IqZ/jbzNk16tsqGH73T/lVMuy1dGia2leWb/9TnlUMX9rcGjxxQjXDJ/8p
X5aN9+U/HHu9hmG/f8q7luFncw2/9T1VS5Q/y26LkgOuT6kj6qNuHo7vTb6b
FXs7RDHz3b6fLQTbz8XCmc3yinNA9n5xcfqGmEUjYmGmzvcF1u9k7xtXL6Bi
BwhjQLRjYVuPSPb+lsNJtYe/9GTvIy9Z+jjPUpdlw5B1aybclRDfK4G9F79e
fCafDrWaVVqv77D3v2D+++z27nO/JB3EzjPHjMpn73tJlCqekj8re19490M/
6m2WZMBr09yItiD2Pphpz4vHTy1l+V1RzRWDQez94jOGN5fdWM5y0NYua76e
YHn2zT6va3xYxvFCf8YDhfK7hbA3rFXP9r5sPGt7xvBjne0LmfJXnRLVs3/4
b1hgHj3j0GXZ+8G9HvlZa4YVQNnj4Jk7mtj7Zxz79W32t5S9P9ykbZi/xK0A
xEq9f+/6wN5Ps2b+6bqTeSx77inrfJPP3jcusd+q9HICy2vfRk2KXM2yV4am
9i+L/zzf+mSt+A7LZ3U7tw0dkiETHyv5YHS7niph1mMuWHZX1/cvhhu7nuWN
02HjX81sDMtWKbLxrVH8dXbrlsneJ/5pdlXU3iPFENZ6Z3+6Anu/eM8Ch6sL
j8neN95tfJVF0/xiWOiivFr3M3vfjrwkPSwyh+V0A2et2VKWH0etevVyEHtf
ucnkrmNGarE849ZXt5ubWO6QWvfudoTlOMMZdtYuLG89/mVeeZlsPO2nYc5e
qzwrYObwnqodIWw8bdSkJDX19CqGOyf9yA75IRsvO37L5H47rlbAxPRRFr9m
yN5Xbqs94+ml1HLYbNmQJh3G3l/+XMV8WO0P2fvMfUt/HMzbWQ5XEj30msax
95urrtyyZtMp2fvOfc71ML+hXM5wdP9FzSlbK2B7z/VXhWFsPO2zF+Nbv+ew
XL+qxdyvgWWqIumPUx/2/vTrjs+2Wk1iOVftTPymRSxP+qELs/RZPn54YsCQ
4yxH9mqb0OrEsvbX0Ss2TyiRib8196g912dDLYi+6uo3LWTjb2/ktbonNrDx
tvZDpcvCr8nej87r3iXk54YaMLunmVdYxMbf5tVdOnZ3Mnt/+qpVWX3WHWf5
g6fq865hsvert92JL4/pXsPwtNgNHwcPr2V4TxScXRtUC526aNzICmPjeRdW
+L2ansmyTYpq/LUqlr9+9Ckr6cze397+eFyPhUNZnn/1yQT3aSyfMR+xtHEZ
yyFb3Pes28ly8/zBF3yPsDx7/J3HnR1YPtFL8evOxyzn39A4PtDih0x8sYVt
zIIrP0WgW6p14MqdXJl44lk9XS09Qtn77HUvgekaoQjGdP6Tbu0uGz9suzx5
W/pItn435Sj1Cn8jgoS89f6fVGXjhQ12uLscShVB0Q3HXvcp9n74hGS5QUkR
svfFv522b3yDUj2EKpgONP7Nxg9v3pezXWEke5981cflHh8MWL7Y532RgYfs
ffNKndWfPd/P1n9FS8+Z16tFcM/yfSfvD2z88b1oP6267/9h5WcmC/L/wxYe
Ho51/+Eo15SsLux99veGOnWbMPg/bH5l7hG1/3DkebOwBf/hISc9e2/4D5tZ
ZOzY9x+OONjz+cn/8ODdCxodWb5rut1q0SOWHw77uLp2fqxMvPS0Ve7mjw0b
oWLVFBenSWy89BMqbtG0mGKGB4jqPx/1L2P4yOS6nol1svHPqrtO7l6a3AD7
nOxDZlTIxj/rBtc4fvnaAErymVEj78rGP2vvEZ5NftMIkYWz+NrL2fv0s/Uy
CyOCZO/X9xlq6dTCa2Q41H33sju5jRDea8Ge6yI2PjoxclwX30nsffy5Z+Sf
RhqwLJwhWlpwW/a+/hHdYm2b89j20rXVJHHTykaGK+t6D3/zvhH0U87ar//G
xluHWaZ+C05meVw/leZRRSxffXtuur2I5cp1aSZ1ndj1pvU1Kl7b+7MceON8
7rexLA+Zmt5fdQbLZ3+qrrm5hOXCwzYXmzexvLRXxmejfSy/eKnW+P0Yy31W
207RvMzykfKMfe6uLGfaT/bo7CMhyj8D+o5uvlue2ARvzvzYcTmK3X/0Eitp
pTqw+4+7FkcOv6vN/h4B2pOMhE/CzIUSWCanv9fjguz+ovHQbsJ8etzaHBU0
xTtQ9vcHBCvXK91c3wSuJWU3mrez8d6WlcYfO19gea2o7E+vFyxj/RnUrXxt
eoGt7yWdt449kdoEzUruOjevs79PcGqj/sbex3/J/P5AdM+T629ENcOaFVfP
7BCy+5fMeYsNM3JNK6UQ9GBy6qbfVUS8VB2MHtg3Sb+I3W/tdsn33LZGKVxz
mrjS4a1svPeFfrNmqY9shnxzq00PTNn90Nm5iqu138j+nkHVs/Kwhnq2vDrk
px0YrN8Mawc/GHV7ExsPPjCg1WD/EZbz1+58OPsmy8+EX3J7+osJ/ULhl1zm
iw5r9vcddik/FO82aYWrkLRE0kf29w88uorurJ3P3i/o1O1VxTn/VpA6a5bd
Xiv7+wfJT70MZle0wsY5fl/3LZb9PQT3i0a3vli2QlflbpllL2Xjxe+ptGhU
ObDx9MP1zx27y2uDax53dpleY+PHz+dEFutmycaThzgecJh3ii3/GS+Wx59O
aoWjC87pdjnOxpfPHTr+9RdPljsa43ueSJSNPxeopYTYnWTrJyZDoD/On+UX
tk1tkWWtsDTNR7p/FbsfE1plf+fgLpZndT+sYXKU5bejdH4esmdZZe40Y1MP
lj03KnY1DxAT5ZsA3SLyRh1S6mD689oNZQ1uDh20fc8LPluYJhOf7hPiZp/f
pwPG7LozcdhF2fj0XQv7qFj37GDq91di7tBzFztA7PE9TGAm+/sQPeHirOxl
HTDn0J67oxNk49U/f0qV917A3h9g6DgqWeVGB2hYdO0+qVI2fn3/y+LOb5rZ
9lGpdCtScS57X4DVBerScesOEG3Q9RLGsfHtcCt08+DOsr9HUThpYO+7/dj9
ypjc+6FvFrHsd2OURcwRWj9Xr8OfzrPx8BnKP9fPe8by+8fiGaE/WL4zftQQ
ql42fl5DtXhqYG/2foD6Hf2y3miw/N5xvu3LzSyf+Gys6mPNxtvfHm/t7ZvM
nucPfs7rbZTI8gnj5Hnpzex5Bc/3GVfM41l2nrXzvbiU5fMf/xSd7cKux664
seDM/Sj2PMORw9+s7HJYfrRqifHhGpa/T4rZtbkLu/83Jf7l+LifbHt6EDUu
rvkXy/JhDw9Prmb51CclBYN2lssCnQKc+rD7h/vt18rl/mDbX+6Mxd4R2Syv
L5gNr0pYjnKcmnO7nuW5s8YdO8tj03tTNERhf292P7I4c0VQ3H/aa6+ej8/N
TGRZc17TsifZLO8w0+nbW8Cy7eOnmSerWX6e0vpIIGE5scumg+s7s98Ta72c
9rk3e55hhXy/bf1i2P4Q+3txt9OJLK8IPB4oyPyP/KqvkU7Bf+Q78xSChf+R
a/T9OrqO5ZXdFpk6Sln+nnNUuZHPfn/VG584g54sx9vlnIhVZPerZjw1iLOL
Y/tfoFWU4+wklmdQk3WqMv4j731LwfPXf+S50pQtApYDnhveka9gWfN4zNaw
OpbfLZ469JiE5en97uSpdLDsn9/ikd+VzZ/GK6Pdt3qx/NY6buyK/uz5g3sf
9SerxbH9/bKn/yf9BB4Vstw5fpqvCB4oDl06VecbRI1065VuKQZ7/dM3QfMb
eG09LXliJIGRC0z3uvh9g9uHTx1QfSiB7NQt5y1UI+HpdYHnBpsy+HFM7dnA
6GS4PyJQIPZogFVH938sXJ8KvNj2zpU6YpibtkRu+ZQU2Jy8ol01RAw7Z7y6
o3oqDYKePll/ZZ0Ets72NTINS4Fr2uM26p2g53MhS5yG3ksFo+Rnm9Vp/75u
QUFIjGUaaP5+mmDEL4LFbSG/um/Ngz2pgemOnlVQZfa57/0uv+Co9ZyYW+5i
cBXtVyocmQ/fxMG3K1dLwEH+8tu97XlwUuvVak8TCagtOuV1/OkvmHr8Uadt
9hL4cdLM9eqafCh+f/Njb9o/Mn1jZH+/Ph8sE29Pj1bLA1elfXmLJv2BvgKf
DZ+XlsE6M+nqGkER9Ho2d8yHlw1gefb86oBhAphWGDG62EkMC5Y8nVo/WADz
N0bb3NeSwEn/87PbTP+A9OaD7iW0vq2qR13i3/2B9ylWNzSMJWDjfbD8XtMf
sFJcOfDsBQl0GbFz8cF5Api6YeSDWHcJXHXTfaBlKwC3O6PnHV6dAdS2+7zU
U2XQKCzYMMqmGCZ/9LfTGiiEp1ovw9f+qoRDzaHhD2JKISLHq9nkaS1MpvpN
uOAthE+RCxz2nm8AuZoTtyp/CIFvFaS1a7UY6k/M0Nl2RQjrVjXYhN4Qw5rI
RgP3BWWw/7Ke+wvab82wq3LKDxTCIZuLhUu3SiBTI+Sgd40QLE75TSw8LIGs
31cXmqiWwdGjGaZn6PxnX98ydNq+MrA26wgYdFcCOdrj6hsflQHPuuLlmJpU
EK29kPSqRxVYjuhxyGhNEcybU/+wUL4a5vS4XtflRBmcDPbv7mBdBe5zhox5
IFcNqfZv9mVcrYaR+RoFvUtr4SxvUdeM89WQNjn9wsaTIni60NTb+X4VfH94
t5tTSgMUrGvaUJNZDeO3r4+No/2/VQoDOn+Nq4JOjS0GS53FsL3fshnXDlXD
5l9mfrGzJTCm9HHUuagqGOK1+McNur0UDdEe4iypgl8HB1dsMpCA55r0w0/U
quHJ1Co5ZUsJGJ03D3tnUA37Gr5NKrSj338nNyDSpRpUPrku96HnE38EXgfS
I6vhxq1vugGGJVDn6Bk77EcdXI2PaHa1qYQ5RjcvOP6shTkNfvPiVWshb055
4OK0Wvja43lF4VkRNOsueK9tXAfjpj7b3EerAbRcdX1t1epg8K/Tszb/3zz/
3ORTo8PqQDnl503rrEZ4N+/FOI2kWhAPHD3AVlEM+4a1+g0fWQfJ24/eubpG
DENa187qaVYHrx7GKDlfFsOP3Edh4s91cLlw6F23MDGcD6lb+UdeBAktcete
vW8Ce72zK1MiayHCcda1dXFNcO9lyesrv2shWPlprCivCXxb1g2Y31wLfi8V
u7rWNsHH1R+tRQPqwFPbZuGcLhKIcx/z20e9Dtziq87mDaLbQ4Xjkp2r6uCa
nt6n82oSKNNu9FXcVwe2FbHiMSCBZkeDvrHn6+D4aS3N6A0S6JkXc/Ts/To4
JO9tbrxfAsqTNXKmv68DQ/d+r3qdovvvmfsgTKyDLWrnhW+uS2Dej85PH5bX
weqQynEbn0hgzTDTnhu7iuDcsalJQ6N+wHDnbr/OGTRAhuW48FyrPHC26KdS
0FYP8VNMaupKBDBpnNZFj1310OrpXbHIqAx6aIwos8ishxvZaT0uL6fb4dc2
u9ll9eD4bW+fPVtrQfh5WobO03rYt+h4gqW5CCT3XBzaaPnDofLvfPo2gG/U
SeVXjvVwqNE5YQc9f/m5oX7pMPkGmJ2kVNE7vgFqf5taXHNoAHn77G1F+Y1g
tlrn0lrTesj7JGz+qCCGshlFlwb518OryqYHLovEsGfE8cuFDfVwZkR3MKb9
4V/de155ObsB1q5XKqSeiWFb3cMrx840QG6hbfK9yCbY53vv4UU6vRGFU4Ns
05tA+8nU3AsX62F3Qe5945Im6HcvYrCtez14/756XrepCUqdt205/64eSvNn
7p3TQwJfrlbdOhtXD6r5RStGD5HALZsLyacL6sH0l9MUOVUJGJ8c1PdUUz28
zZunWDdXAmDxas3JPrQfl1smzqL7z8CDCx2Oj6fbba5rbpi+BCp2ZcQcndcA
1jmLw56bSuDb1kNdj2xsgM/Ztd7O5yRwdx1vsaVJA3RkPbQ/6SQBs+V3bMxt
G2BR1iozw8cSWAqqoaZ3G6D68fMvbcZxMCbgp3K6oRiib5sFGWcXgpG1WmMN
XS56/W/y46eUwOaXapLlKWLgOR1P+Na7HPK7B2gfKxCD4+mxV6svV0G0eHhH
yHMx6Lx1bNHcUguRA1ItB80Wg+GuXcMf0u3ay2OqV8CgJkgy6+RjsEQEronG
3j8W0/PK5Oi6iE8i6Gvy5FCqQAwaZV3De6s0QOcfm6Y+oOvpteHg44XHGuDh
FfenQ16KYXKWqur7cLreFxcNc+vfBAKVYevfJTdCF3mLN+E1jSAyjd5X3twI
Awb0XJIykc7vO4vTY8aJYexw76xCeh7URzzUZcdaej4/YYFpnZsYlOdGPbt5
XAyL1bP4/CQxqJwz//z9kRg2zLZyVejRBJr3vcYEBzVB15jFqj3o9B+tsVn+
i24PfjvmT1naSQzyHfqHO9Hz/s3VWtMuDBTDCf85LhMLm6Dddprm10li+LNH
KWhNTRM8G6iq1aothnVK9TmWbU2wznfsnDnrxBASm9jhKi+BpnnD5x03EsPE
06/Gfabbx+MkJQg4JoabU+xXFk6UwIq9Cotqr4qh/fc+s270+FfXJLd0ygMx
mNxcdEttiQTuO3ZeYfJGDOlLRgavp/v7opFtq3zoeSHV1JJ3zFAC5e/EawXp
Ynjlm8V3N6Pb37La9aPLxDBI//2EsDMS0M4p22jQKga7PjdXFztIQGD6Z4t7
3yaoDjOz6HlPAtf4v7ZnjWmCHUdW31H3kcDMOxn6A7WaINZ4gpmF6S/wCao+
9uu0FPgu1kPdPhdBZnpqVrKXFLyfWrr6nykBfsuQK5seSGFXLwv1we1loNeY
pKdpIoWccfblO57Xwg79aYmz5knh9/Prg4MDRZDvWynfYSGFk8InZ1RvNIC0
Mr/XZUMpKC92XRoYQffT+KSiLb5SWDfF/laNnhgSwp32qlFSep7V4ax3kq7H
N1lU6n4pgMPxGzG3xXDRffTw09el8GF2laOmvxh+XzGRjgmUwhjPeF1N7wzI
mJfX1Li5FbJdRzkdK/4FQS+X6fWb0wpHBnwySjxbBF8uDdtwqXcrdLlTLKJE
xeBlZX3kdkoLPH3pU91tWTk0afhnXVBvhR0HV/Muj62GsxbvLnSa1wr+c+Ys
CE+ohekx0vLMLq2Qd2luVaeHItC/aaE3vrgFKoy1N+qkieCQQt277dNaIauH
d33cqQbo5HVmqnNOC/RaMuz+7EcNYFMWMHB4r1agzt+mfGj929UrWn3nt0Ln
gIarg+jx2KgtYWRxXAscmtzDrvaAGIqz3B78EbRA6lPls3GnxXAw0HBIUUcL
aI9UP+FJ+1MVTiquBUNbwevuIsvTXmIwOyRS/D2zFXoqbjm06YMY6paFOP1a
3wpfLbuPM1n6ATSGhDR/3tEOY5Zprxz4OR0s/Z/PM3Nvhw+b31p9nJsPSp6e
PY6Wt8Nn894Jos1FcPqkj0/C5XZQ67HEeiaUwN3G6et16Of7WqXtc24sg66T
4yvVr7fDo+5T7imfLIfNPfepiIvbIaLIfuxgmyroLXUevGR3O1x22+KUIqwC
x+QBo888b4eVa8a2XNOtBrkXd1UCa9pB49PX1Z7utZAwIEsjcGM7eBaE5eyi
x9n5226OHu7YDgO6hxsPr6qFV+5r+l0Ob4e8aqP7QmcR1OiunjvAuB0uLijf
x3sjgkiNomr+TTq/Nyw1Bv+k/ft+1l41n9oh9ZekVb1CBGZ1fbf9+tMOrskl
rcaWDRDaIcyfYdQO6X0KYj5caoAe4SfmpZylv7cm+2bX+w2w4WK3++b32mGD
fcrOja8b4MGyO0293reDS3T8pCe0/SrpMW7zi6R2SOwcVV+d0QDT4t+9W17Z
DtdqCkJ6bRTDSPWvCr/122HI2vRVVwzEoLjOKOj04XZ49iIum28ihq7mXfUH
n2kHzR6hB8/QdkJy4zn/Pa1v2L53TWIbun5fr/bRpctbJ+LZZctrYshPqF5T
/aIdcke5D6yk7V5ytYvIgdbP+JyT9366/iP6zLw78Xs7iHPtNAtfiyFoatb8
yGy6fOacDNf7JIbnOqf/GJa1g/+ZvGC/V8HgPzb8T/plHnUhQqiu8e4HZCdt
LH70mEc9Wv1k5dst6RBy7d39V7R89LL3Vz3HZ0CPvJBdub48Sufh+6tfzuWB
SPeGdt0RHiUXIi84NfIXbG+81brEiUdFZO2G2WG/4Ovde1/uvuBRI0clyQ1Q
LgL3c3EH7ljzqCO1Vlv09YqgPvZUhgX9fEzYQC9v9yJY3X/y0jVPeZSyS3BN
ZW4ReO38FTAxhEed/P1gtdvvYnicefDalhN0/m4p7A3qXwKjiiPM+9rzqOjl
F8+kLy+Bx6IRG2Pv86iqlqbbDadpOe+Ulu0rHjXg7SG//m9L4Env9CFzQ3lU
+/AtkQNCyqB29O2vpWd41B+LMR3GxWXQc5j8vTWOPCouonrO177lME7pgpX/
PR71Rink6IC55TBfQbpa6TmPum185Y3x3nLY2tNi/OkgHrVv7dmG4KNVsOzp
mnvi4zxqk07f1dGuVaD7NuWpwwUetXjdkyepwVWgH7Lt3YgbPGr6ek1JQU4V
7I/OD31Hpz9GN0qnupX2+5P3xi+j9e+3YevTlhHVcDqvPDPnLY/ibSxr6bGw
Gi6XWgjMPvMo13UPVU961cLHZg9nw/8rz5y1qjlva2HvmRM7T9HfW7+vXWVe
aC30bV+nepvWZ0rtaxWP+Fr4dH5Sk99tHtXz9C4VXnYt7OPzI2Me8qjSrgoq
RiX083bZzoXPeFSUc9ikyHr6+S7vdra84VGeypaTJvDrYO9lB9WBH3mUzbPR
k672qYO+PfY0TQ2ny/OwwWCXKyIIGWM10+gkj2q8WP30qYsIQqss+s8/z6Mq
H5zT/OQugm/B5nWD6Pb0J7DPt4SndH+1M0sUXeNROT88dP7Q/TdGx9Tv5y0e
lSyYmtf0UQTfhxx2fE7XZ2xrqHGvSBH8FJgY2z3hUWED1jWNShBB4hvj5QZ0
fXyY/PvizCwRpJw6OH4Ond83S8wVVxWJIG3pgc4D6Pp5pt/xyKBSBJkK+wur
6fLzOOo05YhYBNm5e7/GRfCoJH6AyvrvjdBX7dO1QSqBMEtXvjYvoxHU+j/7
rtwrENY+pmaX6zWBaKDzYs1eL4A/aVFNL6smiLQZqWlr8Anely0NClSVwoh9
5QrrpjyDvKSvpXfWSqFO2/PLduVX0Dl4zpAT9DhoJDdl5rsu/qD6KGDVtltS
+NFw1fFDSwB0G9wU2ym2HnRyD10VnfsJoT9dc1K0G8B/Y+SEfefiIe7659/a
sY0QrnDhqeKTBLjoNiD1RkUjdLgdMOgR+xMuCpVnD9xK+y8qmd0e132H60ee
+jb7NsGo3/Ib75xIAMMWX/NBk6QQlf96XA/F77C7v5dZxBwp3PoQEL0u5TsY
qT0wNV8thd3OwQfdbsbDnsV3DivvlMJU4y89f2/4AXv1bhyKMZNCy8LwVxP6
/4T9R66YHLGRQtzQGB2z1J9wwNHGeORNKbjVx9e+v5UAmYnzm388lsIhrx29
5YISQNlvspzZKykcbfaS2sxKgF0OyoP7BkvhrG5VsST4J3gd6DnxbYQULj3X
SrGY+xNKl0hn6iZK4UbH+VBhyA9QGyNcIsqh098S98Jw/g8w78jYeKtECo/8
FN2yQuMhMC/KaIZICj5d9O3WU/Eg+Rhomd4mhbd6T81jv32H+W5eNsflmiH4
XbUetfg7xOzPV1uyRApDNkzaaLYhGfSNOzmV0X7GeasRO0R3kqDu0ATRDXu6
fsarhFe+S4TL2i/PPDhfD57DfN9MvpIJo6n2SU4tjRAZyNd0yM+CC57jjoXT
7cPQR84l7U8mbKt0NnN1p/1kpThvRciGpQZ/vval53tNITOr+n3MBPGsZ907
djRB2aahCdODc2GBTnnCIrr9FEV8f7t3fyZM6Byco6MlhaGJmVHVPpnQN/hS
yY5FUtiQI8g5WZYJksMbRft1pOBQXFfTSS0LCkaPbrfaIYXw2vYu1w9nQWxG
tdx5Wh9pi/zQQa+zwN/x80BHKylodB+i/qQmC+5RDqPdzknBWHHCEjWNbLjQ
uHWKl4MUHg/X3P7eKhtMXtDdyFUKWZMoMwjMhsNh9ZMTPaSw375jrumHbOgv
/+lTkLcUNukb1K91y4ZPm21WeLyQwiL1Ly+nnsiG3Y+XZVx6K4VpnYbt7bs1
G3pU9NprGkT3j/RTw2q1suHNzNS6TZ+l0Ot5dlqSUjZssbl3fl64FJpPzb7u
L86Ctu+7eo+LlYJwrdvSmxlZ4D1wgrt8ghQyRonbrIKyYLVh5aT6VLo9128K
2uiaBaIX74JysqUQEB1gNuM4rV/jySXhv6Xw5J7ixIFbsoCiIMW3WArOhy1/
N87MAqFDV0OXCrq+IcktY2AWOKXHV52sk4Kpovr6D42ZMGvUzdOGTVLQL77e
4256JuSbbJNbQbenVcGVYSffZ8Ll9yPc1Ds3wxzH1dbb72TCVF7xuEF0+5po
8EJj7rFMSF/18l17n2YYqCFXPnRzJvjdEk8U0PVrdMwzuPfUPOijMH3BJdpP
7rK3khqfkAvm10w3TaDr89kGrbh5ZrmQ1MPXJGaXFJYvtNHd1CcXNC4JbA5a
SqFM/Xv2odc5cJM/yk3Ojq7/EQOM7HRyoOGsnt+L21KY3Nug/H51NrxoG3g+
viAbHi/seuudeRuEdX+3bP3OAljY+SXlpd4G+1+NFkWGC2CCvF6D2902qI/r
v4q/qhg8ux9zP2/YBsrOjz6UNpeC/4/FKt4z2uBP10Fr+q8Vgmp210v2wjbY
e7rMRyWzAlyG71RdQ7XB+E4DRVWbK2FIp7yv10PboO/TgYssTGrgTtDmzA1D
2yA6+sqNCdU14BD32FpwpA12eSkd53vXwPuCzY13+tP+VUiNxrJbdbBde8XK
EQptMGnk192KUXXgf9suOGtjG7RduOGSL64DuerQibfc2qCbYZXelc0ieD+q
buKXeW2Qojr4TI8r9aA1wtHVbGwbbDPS4vd7UQ+blZ8eHEC///vepstDftbD
scFf53660Abfp42x+BFTDzaK20Y6ZLfBqWJtuzFbG+Gp2rBE6NYGupEKRjGH
G+GzWnjsGzq9SV7F1OELjZCidjB85MI26LD9NLLf3UYoU+vz2cmgDTIMndrf
+9H2WC3wfcfpNvCDvb92RDSC0uQdb8zvtcEym5p1SSPF8K1FPil/fhvYTHcq
tjn8FuyPaP3J7cejxv8wTBTbJEN+v4QTjl87IFGl3fSJegqYxo+yPbqQR8mv
rd0OutmgmO+8c0VqB5RF/Or4o58DWeYqNjETeZRDeueDBUcKQK0ut4chLV/U
/UR8SWsBFC8RrVw+mB7vjxzeH7yoELyntJ8p7cOjNqqbxMzdVgB+z+95eBrw
qAZhwGK1SQIY7Sp2yInogM+d/UoD3QSwWd+ic053HmUwPPRbiGkxhBVXn7ub
1wFZel695z0WwD21pHi1GbQ/OPftlt/tf0DSV+ms3CEetWet5R5xTCnsLOt9
cO+zDpheF3mYN1YIW6fc37xW0AG8O4OP9zwnBN/Zt0Yr0/rnHe926HyrEBqT
Fz9I7sSjzO2PDk3bKwThpqV39mjxqPMXJxwZWFoKenYrpON286h0+26l2z0q
YM74s+/7vO6AjJ0PPAYIK8CppnTq9IIOyNSYviVRoxJE+ippqnI8Kt4+6OwJ
cSUkO8dFRxd3gIfZhTmTDlbC8KxLvsvG8ijTpp0eSZ0qabu0XBSylEfNt5nT
2fphBSy61UNb4yCPuu+SUWlzvgYEVHxOzy8dUJkw20f+Uw20X6vQy6H1WdDL
fbdrQw1cq7xUvakb7a94t193HlQL9xWV3swbyqOm3v/g+PVwLRR+nJRil94B
T6abROmp10Lz79katgN4VP/nHXoXeLWgOSluzE66PI3eSjq/9KuBVv3aTYHr
aX9FQbROd0cNRLkMuiJvSreXrU0Ho2/UQeYPTde9Hh0wdk1Jw7SndbB02k6T
ws8dMHphuo17SB0E3Lq8wCC3A0ZpRfbqllIHY5reKOZKO2CEWsBdC2EdrPA7
XK/Wi0cNH+U5Lre9DjoMbHeaKPOoUXMcFmacFsGy1XcF3R92QPrHnRNWLxfB
3cz6bedofR3nasiHKYqg0d9nf/NAHtXH5UMoVVEHQcpii4xpPGpddm6fk7F1
EJ9tWHd2BY9yHs3b9YbOX4FbvOV4Qx5l3zBYJ+dIPex7nTLjC53+rdO7bSV2
9XC227bRvgEd8LDTi0Cl2/Vwx+BX7ztxHeBjLyqd4V0PfkFGzTa/O8BfQVt5
Y2A9RPYRlhxu7IBPbnY6lpH1YBYQZPyqK4+KHPHD1imtHk7tku7yVOBRCU8H
vPcT1MNl+Xlb7tL69eMrTLDd0QCLTshNPEC3z5xJ8oMyVRtgRp550tzSDvBa
363HlJZ6uDWqYl53un4+CB2/T8ysB+2jMfzLk+n5yAm5P6c+1oO6/C21QIpH
zel2peWnez2M8zTYXLSJRzXf7jJg9Ll6GDxH9byCMY9K9HXb0XnOI7CqrTM6
O4RPvT3pbFf91AcGP9XV11rKp1qtjvxqmRUBZ0KVl9wZxqfObbb/YDErEiY7
X1y5Zjqf4s1+5FKsFQW5u6t0Oq/gU3ZD3x/aoRUNjppbNn3ayad+jfwJv4rj
YOnrrSFG4/lUCjXY7dzvGAifpS5/RJdPjQ3cZ6x3LBqM01WdtS341C2V8dfe
x0VBH+UfSSnn+FTnR4LXfUdEQYChaT+T63zqyADvZGOrSNj2rM8G/gM+JbDf
0xARHQGtFW9u3n3BpzZ1jBk0QjkCnmjopqp/5FPfFgo7fZiWDEOsGi9spPM/
xURhlM/FZJi4B17fVeVT92/Onu+WlQwzN9ln/5rNp7qFGO64MjkFFi9N7TJ2
OZ+y+nP1xAmbFNDVGj7t4GY+9Vve//aBtBTYNfGAnt8ePmW9saCH6us0yBrk
eXrwSD6Vq2GrKZiSBi99ds0oncGn5iuMMfDwS4Xzs4ZXvV/Fpzyqw69um5IK
G2Jynl405FNXfAcYF+anwPqQIs9cUz71YNaHSTsCU+CnuZ+z0jE+5R+1XZhi
nwKrx508p3uGT0VvbPVZvSsFYrMWHb5mR3+v0ONA5IwUWHa9944YBz5Va75w
4vyeKRCxMGt5p5t8qmv7n5L3v5Nhodhz5vx7fGrotcvPpr5PhtAXpmNPPuZT
6kNV9vs4JMO8XbP7BfjwqSXP48ePMkyGj/07d1S95lM7tMyK785MhlmxPysn
BfGpw5tuRjiHZMGOr7lKe4fyqSfJ98PHSLNgUD/nyNxxfCpDx+tbIO1HpRkt
sdqozqfkf7wMW3Y0G1wCJSPj5/ApamXg1yz/bNDp5vdz0RI+dSz6c6hJTTbI
b9t9+pMOn3qxOOpL6+QciPUdqDJ9O13eYT8/3zDJgUstcRm+dHl3pK40G7En
D3bq/bT4TbdX4wNl10r75MH6MZ28p03iU6nNV1++/ZQLS8q0Mm216PK/Mem7
9f5cmPX2UM9U+ns+o2OFixRzQe3E4/njNvKpfu8PdO8VmgMjFqRbHNvNp+q0
X6UV2ebArIPfY94c4lP3fpWsFO/LAYmyzWBzun0uPD/6q9yqHPiYONN4Kl0/
ZaP0ZwyfmgOn7Co+VlnzKZdwV99pijmgPetJTz+6/c7ZmzxiiTgbWsu36B2m
66uwa6/bW3Oy4YtHr1dqV/mUvc8yuUOh2XBuQ3hr+TU+pbHS9tw5z2yAbifX
vnDhU9nlIfUul7OB92mKh7Ern7K9Jj741CQbvpn+qZ7kzqdUpmrkB+vQfvLo
eyB8xKeSEw9t/DE9Gxan6zj7eNPt0/JZ7G/aj+1i36Vwvy+fGt2/cH59cxZE
zfukMYGu37hA5YBuv7Pgcq35heJ3fMpyy5ZJQyOyYLn3+FTvD3zq5/q49gSt
AlDosTRuBN2+uwRUf3ipUwBVJRPztCfyKe2BAyyv7i+A71E9a7bR9W11Yo7q
vnMF4ONdxT8+i0/5Zhv8WehaABftkgbcAj5VoH3xwYjXBbDbKGDiW7p/Dfbw
3dwSVQCw0HXuz3V8ah0vsU/WrwIYNsp6bflWun8YNcQENhZAc7ueYXe6v4RG
DrF16V0Imb8WHBl3kE8lZs7WrKspBNOtXwo0R9D9J3HmToXkQsgz3+8bQLeH
gzHTr6i/K4TVV/taaWryqZlf1f11bhXCp8fBcwPm8yn+h8m5pkcLQeXj7s6a
tP1KeK3S9frmQrib3PPHuw20fXg2Qf2VViF0Lw+4PZ22Zwc8xm6PH1QIxzvt
3PnuAJ1enVJBgFwhKBQrS84c5lNDfvjfO9FRAI8PvRU2mfOptmdrNmrT+Z8m
WpJtdYSuf9vSXh3lBRB2Mjuu6jifitK/EB1eUADrO0w/HTxFl9es4TaXMwrg
96VOL/+c5VPXFYPnrPpRAOa93NwNbOn6qdpQ3zu8ANpvql3LvsinNsdWvUr+
UAA3hoSd2US3pzleV/ff8SuA4Y83mSY68qnh58aO2u5F+1MTynaucqL13R6a
PexeAczzO6sTRduHYs3ttwpuFMAPTUWg6PYV16dhjffFAtD79Ew9hLYXfmU3
uh08VQAVlPYorYd0+45UCVOzKIBTMYkK/rT9OPYo0rpmXwH01NnLn0y3t+2n
dmkG6BXAvTRJ3TPanizY3Fx5XLcAVPSuF41+yafGTLvzbO7yAgguHJ36gG5/
3eWnGbbPK4AVB4MiBtHtr6L4+5Dw6QWQWb0q8OZ7PpUUti/10qQCOHDst3dv
2p7/WDfHLrb6Dyjs9nJ6MJhPuXnnLUrlC+Bu9/i+SnT7NJKe75Q/QACjXouc
nOjxZorO2HDhRAE83zRUQW4yn5J4RtvWzxXAtJaFzhfo8SuiyXhh+1oBBD8x
Vmil7f+NNb35crsFQK1wcT5Gt9ftT96G9T8qgNjqYIUaejwcJ95oM+KKANbf
KXA+uIZP1axqApX7AsjS7tGviG4vnx7d79D0E8CuInUXPdp+XWqY/3VBmABK
r27tl76LT61fWXhuZaoAzNTPu+js51PePodrxGHFsIOqS9egxydFXRjY3bcY
dmaVGm+m7alNcz/tQS7FYGiR33aSzn+1l8BwonUx7OmR7vKAHl/01364PGt3
Mex/HD8+bB6f+i62f7V8ZTEYzw7/+Ie2d7Mf66ds1SiGw0nBa7uv5VPPVqpL
DgwpBvODbwpV6fFsQD1/xEl+MVjxnh3Todv3hQdpi6+WCeDY3QdyVvv4lLLz
uY262QL4dGqQWaMJnxr51MdkT7IAwvrf9fShx6uxn5Jsj8UJIPrV4MzttH2c
mCi9e+WbAH4svSffi27vaoIxb+99FEBK/hAqlLaX6tLVMS/9BZB54v5Ri5N8
SrPPsfwvvgL4paDsO+Y0n5o11qMx8YkAinzdf6XR7V97dkyvonsCEC4apnjF
hk/B2tqxDS4CqMp9sGwObU8XGw3R7uYggPqjw09XXOJTy08s2jD4ggAkvT3e
PKT7w+prh4xVTwmg/dkIwTq6P6x/cttmnpUAOlOPBne6QfsLQV/cdEwEIJc9
cm2gM13f8SWvDY0E0Mfqse3+W3zqWta18Z3DS8HD7bufgTKfsrhQr3cwuRTm
/gwNvz+Kfn/yjps/C0oho1NAZgbd3mZnhMVOry0Fq9k+lYpqfGqYzcQOt45S
6GPmzl83jfaXVG/MbOsjhBdeTkqOM2n/JbXhkNEIISzLtlOLmcunYs/qecZM
EUJhn5NUZ4pPvZoYnjV5vhDOLjm8Gej255w8qe/NNUIYfMrQ5DTtTxw97bS0
SU8IgW82nf9A28+t48Wn9Q8JYV3xitv1m+jyS9R/9+2UECqGzvdV38GnRlhH
CCc4COHyeo3QQ3R77DRWdeS1e0IYc3l8qs9ePrXxoFlHyLUyCM69wpfS+uqV
Lfv+yLoMJhnvtzw5hu5fJiPv2O0vg7viJYVNtH01qWjadWBjGchdHKt7grb/
loeTVFdTZWDdr9M3Ma2fddXzxqlTyqDco2Dacbp92pjZhikOLQO9yV8fNy6i
7XvNdkdxtzKI//hQ4dhKPuVkMX1LTr0QtJefsWmg9XGt6zk6tEAIr9J21B7Z
QvtPVn8qnvwUwjCjOYb1+nzqaX1I0KVPQrheMyjJivYPeneaFNjsIwTTU+sK
w4z5lJycfLbPEyGEN2XpltLjeVeF6rZN7kIYdMwovLcZbQ8HJY/pdEcIh0UV
02fQ7bd1eODyNzeE8M38mNcOK9pejHM7rH9VCEpV7f1tj/KperVTLnIXhHDI
5OpFH9p+10zfGRR0Wghhpf0af57kM/GSQ5sdz7XpBzPx2/bb61YFxH6AEVVt
qQt+s/fBOjfH34tYIfv7fG/F3h2d6r4x3KgyZdz29hjmvgMd26RX/LtOBD+C
6i96Hqrj2Ptju24rbx2+nOVhopN6/UxYnnGt+6cu12Xvm50Vn9vV6fVXhqcp
edg+zfjGcNQyHZvOGREMP0n0HfcuM4rhOTHKcVU5MXBM5WHHmu2V0HvZNMtf
+xPAeN/JtfCkEvreFs+Y0vKTiVedN6XBVSEpiYk3ttVZo7RbNQnsJqeYPCgR
E79vIgGd0qsLrnRNglX6gSeKzdj7Zns9zbX1DGT5pNPCxaf+sCyw9umyQZG9
r0JeN+BZ7ET29wu/WI4/fXEOy+Y33dZRq1keHSA3rlWf5dTU05IPZixfbqj6
8X/rz8hzBho+Ub/JMpZP6s303IUDUhme+Thk9MYRrLyL21hfTdV0hm/tO9VR
OCsDiqv/JG9orYGP59+PFw3Khld+Kl5aLrWQNHSLQdWuTOhu8li6upK9H3f+
ksndLd6x9+PW+gRnnbrN/h7jAgX9b9PGyv4e4+xyw08h13LgWu+lHhbb2d9j
vOC80XKIPctW+46ZTn7HskDN0iYxgeUtosO3rCpYjg0++GxgD/Y+kMsOK17M
tmqEsn5HHQr6FoLlwwf/j7A7j6fi7f8HfixlKWuWNksqRaQkKul9QiiJVJQU
slS2kpSUrVCWRIqIomxFIXuWhJDIvu/7vh3OZv3N/Xt8nOv+ns8f95/Px3XM
mblmrmuu65i5XsXrtpEgbro7WEC2B9TV9lFuXyeDxkZjD6cjPSAtWO29MZwM
uUMqLWm/e6BIqOZKZg8ZnuyN7rIJ7oHfr60v/XxEBj/lDSmcn3rB/cBKQMJO
KlzsmdjuWtUN7loPqbN7qZDHbn7mxzDm62STo4eoICbX7rjC0APu7vblHsep
8PTKuY+wBfPbKdnKU1QY9yqvdJXrgcfpVm/5z1PhbPJxyg8tzFVDTFevUCGj
JUsMd70HnoyYWsdaUGEL0z4tvBtmpu76yVtUcJeKu+8W2gMeQoZKCg+oMHhB
+EMBNi71UGiOcX1MBU3X1xW4ih7wPHues8yXCinx68n4AcxW1fe4X1NBoPbJ
Nvdl7PhCNc89CKdCXHW0Yyt7L9jx2Au4RVKhhDQTO7jSA5u8w1q8oqkwsBUa
CHM98BNXGP48HrueVPyYVkZ64KbjiNGrRCpsv9myf11XD/BMc29/m0wF5Rfi
xoL1PZB9/dBgVBoVTNLt/bdj9WvSZfQpPosKbm0FuTL5PcCm/9Q6KZcK7xk4
xxRTeyDl71eZjAIq5O+6vEkjvgcuqTUScoup0KEVr34+ogcY8pfSi8qosGhP
dDB+2QOfDu58UF6B1U+YcrT10x7Q/XL6aE01FY4UvKh1fNQD8zvurjTVU+HS
YDvO064HPoa/LexspoLjekmZQIse+MGWDDPiVBAe0D3lf6oPHpqL7lqQpcLW
BzYbqiT64NDPAM41QIXNHM/audj6YG4rA4kTa78boz7E6Az3QrKjXcdGfaw+
D+bZBpb2gk19T7GYKRX4fjcp1Mb2gsQ+3UQp7HzxXiHgNnj1wqBvYZD8Qypw
z6wvP2feCx+GZB/in1KBy3NX0CvVXjBS+XjtVBAVODYpGzZs74U8ZbEPAouz
cNapKfA8yxBsddGcOhdGhPRes9eFMYOYk3Py8SQYKNa+HMs8CNm7uq4dxsaQ
ZmkD4eUbBiHVdkTL8D4ZgptM3wf6D8KX9NlDrtFkKJvvibrINgRbbhq0abaS
gclUz8aibhAOXPa4ostPATGhN+lNsoMQ/TlwqESVDI/3bd4pZDkMHSwJrZ+D
ydA1+0TJ0HcItqdo9WRh7aG534FqTRmAGtWG7QbSVNDdtVZ4L8cguDYbWizI
UaHiZrDy1LZBkLbujw8/SgW1RPHryfKD0LZiNaakSoWCyQxfO81B8A6ale7C
6vfIfvVkWeNBUNj18LbbOSqk2TfVz94dhIHvjKnbLlNhb8Z1apr3IASd8SEW
XqNCPIUsdO/dIBzv5Tlkht2PxBSfKSukDsKUQ6jTmjtUeOu88TqldBAi2Lbl
xWLthb8g3je7fRA0I+JX1N2p4M94ONlpZhCo+/YpjzyjAjY9rVdcOwTxxZke
PgFYe3t6ibq4eQj0LkLpnjdUWPg9IpQvMwSK64S9qFj7uWSmaqQuOwRr2F+5
b8Daz3q9msgmiSGoYmV3lv5IhR/qV3uvbxuCUBY3R/VYKtw5PLadsnEIzNaS
7E0+UWHnHkfzZ9xDsHeN9a2HWHtq3rombiPrEFCZei1fJ1HBh/PlcPzKIIwK
pG4W2U2FJLf6GrHbw9DA5KVwYz92/+Ssye3Ww8YN0xfPpxyhQlt4Zdw7bJyX
0LHHbl6FCjOS5S8NdwxDcPnycxUtKrBklzhvXjcM7pk1n/30qCCkXnSjeWYI
rKOjSxuMqHCg4ce54OYh0A+83y98kwonTXOPnf8xBCoupxhuYPVpNJMlwRuL
7a+VkHAKdj07uKbzVfsNweaL00fmPajgy/Ft5bk9Vh8nivRV/LH7+duvo5oG
QzCzP/iuXwgVMiUSGtiOD0E177xhS8MsdN/it366exy2Nicftvo0C3fE52KW
uCcgbb7u0rQZEdhN/Ox0lcZg+ZPPreEfRDgyuubcL7lx+GjL+OhjAhE4qg5L
shRh4wC95Y4jxmQweua38bbjGLwPLcqLfUqGyAgdq4S+MZDpeBbBm0SG3m98
+YNnxqFqw2/zpTYy2D5l/vmKPAbPCbLKVDYK7JpaE+XqNAZjIu/v9lmSYbZx
a6Dingl4ERKygSOBDHvbY/1TH43DFSFGQQXGWjCwrLqTVjgPZ3uEBpQEW4Ft
PzNPzcQ8bOGIN7M/3w23Nz3PqMVRIMVW4OFiTzeE/1TXuk+chz/feBldsPnF
Bs0X5htVKRBN+a38wbsfPCMDHl7smIfv0R/zTC8Mw+LuewPXTlIg02a30IG1
w/BixC1sIm4ewnlE8VebxmDSYr1OrCAFXJLSr0bbjYNNV5LHHN8CVKhp4Td6
j8P99j1RV1gWgNs9RZHHdBo8I8J43XZSILJLDr/Vegpcfaf5eJ7Ow/V2Hiln
whREtlpuqD25AJ4tbT2DlBkIFN164LkdBSyCM4vy384A+dvOM1HcVPjrJvqx
vWoWNhobXvh2hQL4zeObPlfNQHHPC/b2ynlglEs9HRpFhD9+JydylSkQEu7c
n1NJhKJNWVVFLhTw6P9WqP4bO3/Dr4+U+FCAfXCdpYL3LFjoniUxvJwHYvbo
8J+fs1BVf2SQ2DkPU9Vvr/4ynoNLF1m+CjrMw3bfaTsTJzJQTrlcM9xPgasc
hrknnpOhPW+Mj1OTAmEvStdKRpKhYN+l0h9mFGjgOXCWM5UM0R9LHthh3+/i
lMts/5cMMhmxYmVGFHg8cWLvxjEyZDac8Kg9RIGsl5vudwIZlnTO30/dRoVP
P1yG7pmTwXk22C9wkgKh4336XL5kWH7dEnUrBxuXbzpZFpdMBpdDWzO1nmHj
yt1BSjm2RBCHmWpC4DzwKE3E1gQQ4dJ6GQPtgnmoP6vOPfyNCL4t1n0Jk/NQ
6tBZW9lFhHDG5bJnuAUYWKd2wU+NDMWV+SrKrvOg98txw+AFrP/eKbws9moe
SlwSagDbnwpn5yymT/OgcKjzRehdMlQ3tN/pz5uH+BnuM7NPyFAvfVT6V+08
bExQWa8VRIZmz7dDMUPz8MzsXnnsB6y+OuajvBbngSr06RnuGxl6DhoYXudZ
gDTZBwpOpWTQultgEb80D0ED68/86CSD5NwBfUbsfNx5E2nGTCIDy904dcP8
edDVlHt4koMC/bObD2W8mwfZ5dJA/x0UKLT3382N7b/cq/jINSpk+Kui6/Q3
ZQEaGUjVLhZYe31rb/XCfQEcb6kwULzJME14ZahzdgE2dwTst/tCBrdTGVo8
21C+78FbfDhS/SJtfWe57st8UqZoPf0DMbeNztSi9fSVowrXyU6h91W/rhn1
nd+zANoblQ+nuU3S1lv8vNdpdyHj+L/W1y89rxbutHsRig4+V74xidbPPzzA
Xmnh+e98ZcOLolHzKyhf+ZQqc1N6Nno/c/D6pef1txfgA5tc0JN8tL7+kxO/
f/fJo/X1Z7s1fupl/Ht9/eJN+02vrUF+7+wrwhaG3t/k3m+uvOvwAs26TJGX
x5MXIDnPIDw+DuU374mrfzE9hRzB6XftyD6U58yW3MvU+git37+vnv+gUP2/
1/PfrnwgZbYMredv96LCIug4KufTCdbjT0Tvf+q773rkaYrW733y+3Xm7m8L
EHpni/cHfZQX/cAr4avYQ+SLYYr1H94hH/r6hypWiMw3wnWR2IGssHJjKo6K
bMBf6GXAj/KnnfdsEebYj5w3HmtqbojyqEeFjmSI+CILaleytmb/O6/6dK/D
8bY+lFddGydkbXEIlcvsEIid8kQ22vd454HKRSgQKSufUUZ51rstbwiyXEAO
SGM123odmbIcn7z/AbLxyZNLar7IZUEjJw0jkGU6vYPtkv6dl/1ceeau/tgC
zR8PhIg7CqHy7B1KzW+0kR/dFc51eoRc8fxSSk4s8pa4V7GL1chWBVVvlRYW
4fBY55bu8eJ/5TU81s/cnXcP5S9ck271yDJagQ23hVu6rVr+lbdw5+hFFa6v
KM9bVMGIcYIB5XnffLLoE3AT5Sv4vdUeV+ZB5Qnp+tkh/5X3fY7sPsf5awm8
RlK7t7WM0tYLXO0vRoaPCjTeQvneljLhFXoLyKVuL//23UDv65ae2vFjHd8y
BO3WEbbnm6Rt7xDrk6c/cv6d963A8yOEKwvZbGYh64zwCs0OZ1Uf99xD7/PK
vdkddGluCUQqJHeUj6L87+lA+bgkG5T/XXDproWF8b/zvy0v6HBlxCGzfA+7
eQy3QrOByzd2K3Xkr8rlCSH+6P1f9d0H8zt/LNFswF/91oZrGRo7mTK7v6G8
8Bnns88XOFBeeIlgS4mTCfLMtZoN53v+nR9OtjjeTgpATtnzJuhCCzLpawFT
oOAK6u9CwhbeayNruN2d/foUvS8s70thkExC+fW1QUbSTiPItuElF8u3L4P1
34DH3XdQvsYmTebAg5+RFV/tuNTbjVzrY/qKwIXyy2+6f6hiBOTNaRrs4+9R
nrmPzXcD87Z/55tLebt7WD5Atp2/Py+djJxsZXt7ZhC5pZ6i4ci3QvOWRt7+
vmPIhk1Srto3kSOa1TbnBK3Q+tdvhQUqP6tRXp6Ok0MyOxl5cr+k0Hkh9P6+
30ind4TKMmTc636SZoDy1sfiuGNT7iKLtuDLvvojX2C3G02IR/ZRjFr/qRDZ
O9xsJ6EROWj9ualDY8jvHh3Pdl1Bjh+XeVKyAa3n+c1QWItjN7JO/U5xfwuU
//5AUFDwuhfyRwNWVnwsckUElbKx5N958bGbN+jlOiBHzXheEw5HfltGsXUr
RA5+b/Wwdxi5cmKG/STbCs0enDfMmHchK8p05v1QRZ7VPi/48Bry59vlt+Xd
0PvtF7V36v+RxeH94os4n3//QVuf1GMmsTNFP4Zu/YC/cCgGZ0zdi8NvjbJx
Y7lVRft8k6yL3FHFX//Kb2H9tC5HMR45f88xvsYJ9D68wN9f1Mu7kSeCmWJ4
buPwg1HdWSfkm2jbLzO3Ste/Uku3nkAtCFH8rsg4I184ldLemYG88/JX5/5O
ZMYPkTJWDOj9+2xXPqed53D4zGKnO0dPddK+j5d5ovrOrxa69RVa4Wyfv+Ws
P/KjwqICk0xkbd2/nF31yL9s3Od5JpAVveUGVdeg9/cn+lYyOg6j9/GfJ1tb
vbyGww8VGS+yWvXS9mcqfemayuVuuvUZeiBf00Azwh557Mb6FwdfIgt65ddW
JiPvn3fiWv8H+UIBQ9vlDuQHXs9iE6aQw09z3VlgQOsJF/AGK2nyoff7j8RH
wLgIev9/qqS89yoeOXqA7FljjMNr7SJ/ciodpB3P/VoJme2+/XTrNfQDx10W
J9u7yBnFIvpP/ZCN+A/JRUYjs1ro8GTnIm9hyMg89Rc5vTdoIqMdWbvYbvv2
MeTRGO1LL6jInk+lXyywoPWSRW6u+3VdAK0ncLWOncFSAa03ELDZv+/tWeRC
E56SSisc3rtPMKD67ijteINXlOIuyQzTjnf1/i7s7pQW4Yrs+OBY6fxL5Fo7
xlb9WOQ9liXjadnIxfdvn4z7jXzK7Kz8sQbkah3Z7Q3dyHpKG7itx5HbJeYW
GSnI1wQaRkKZ0PrQw4wZjfu40HoF3kWz4uzb0PoGXBULhTLyyMH1TEYXNJG3
dqxbcMLOv8rS40jxJxO0+qh9+/01681Jml3u2nel4qdoFsFPhKotj9Hqi5Y/
nTVr5voQeVhup/IuX2SpFD2RqjDkW9LPFu99Rk79lN0i/B1ZzvzPi6+lyKYt
/YYcNcgvtZYlrFuRf/4UJJf3IU8f3F8sMYEs8vlU4DMS8hlhs6tDK8jOL533
qLEx0Jy4NoQS/V/rP6zcfevkKYLWX9j1vKbGeB+yTgyLxNHjyI55Sm6CushR
DfZNBKz/sOw/3s2fN02rT6aq4SUtrHzVSaUa6hrGyOKaFgH876do9e0ej5sp
4kXruayO167uudaWdw/ZTXeDre4T5A8PinFDL5CLIx2CHoYjD5SKi3N/Ql47
1ZQVnY68W8Bb83Ah8hUGgbnkcuSJ4BafQ7XIzlIR2wpakDkKjbPUe5Aj9Hdo
Vw0jS08MDehNI+c9TnjUSUbW2nhrg8UKcscX2c8Ta9F6/DYqJLwDJ/JSc3bT
Ij9a/6IVt2w3shutf/FNy9WZfBDZJwznvUYF+dqQ+6sNOshH5Jgit11B5nH3
SJCxxOE1hNrW6n0l0M6XuatpYe4QchKuIMB76yzNn5/x736tjbzrqo2Iznu0
Hs9xY+OLXX+RL187F2i7jLw63t0w/vc1yR759flB6S5nZMG8pV+lT5FDd/Jf
TQ5E3uIvRXrzFjmCpOLvHoMsYnRZ3DIJOar0Tr5uNvL2fT56ikXI+Xk6a779
RjbMuaUYWYU8n+Vv59+A/CbjS9yjNmT5tIoOyx7kupSxDZeGkO2S2E+pTyBz
fpFwOziL1hMam+SsT9mNHPtmwFpFFtlEOXdNgyLy1vGX7yxOIDe9vqlAOfNf
+R+Ar/a+iMPnl37icLo3h/LwJu0Ltd4ge/Mdu7/tO/LUEVYpYhvyhMBloWEK
cmY4e+YXfrTevLvYdx17WeTT8TdHD2n/Oy/P4F73s/O2DDRbC/yo73+E7JoR
Iergixyo98h6TRhyNMkg63U8ckbwYWbxTAb84fPbik7kfKetn67BLs+0c20B
zXeKmJ8mJKI8vryvoz7mtq9pXh1/Ep70v3tpgyzUsPy2/C6yhvimUMZHyPb3
DwQfeYL8rkwr6I4P8u9NNwL+87ziqomWj5/3vkHelhvuszkS+TRH5lPdOGTH
qzUePl+RPyaNuRemM+D3f1heUHiB8gJb5BaV7+6upDnTPFbiTn4Vzavj300H
d7YoWyO7BpbJ4OyQByasvPIckDVPcXU4OSGnxH47cMgVWZBJz4f4BNnZiNr9
7RlyX064wu3nyCc34v2lXyIn3e3rHw1G5q/xUox/i/xQWvKleSRyj3flsFgM
ssbgbej+hPxVmS844ut/be995rhB6n9tb8FAZWMWA/5XxE4cExHlJZL8SGvg
QCPNcQL1xdO2TXTXRyfg2G3ydS2RG3vfb6iwQU7Mqb1xwg758as1+fl3kS/a
HNpwyBF5r5rVjZSHyMwi7/IkXZFbydW80Y+Rk6uZbgh5IXt9ks8L9kY2fHyT
l/s5suzl8OveAcisclW5jK+QO9cz8j4KQU4bkLtODEP2yb+ea/sO2SQkjGc4
ClnhdqWFSQwy50lcbms8cv+2AzznE5Fz5s0tKpOQA+ve5KilIt9I/MNdkIF8
zHPZ/PB3Bnxw+i6NmBsdtPMRdlIoNzKgE+VLrt333DW1iy5/sxcUNCxxBpbI
EYzGBew2yEx5F9xybiHfvK+Jt76DXLX/OE7IAVluXL6g8j5yWKyUm4sT8oqx
GF7GGdl8y0ZctytyeQNHQcBj5H0BTG7HPZFfn6IC4SnyAvPUygcfZOMf/T/O
PUcuedDqyhyAvEeuGtJfIgdO/loxf41Mis/5IfAG2dA0xbU0DPmnUBw4RjDg
bcbb2QbXo7zP2MX402FByG5vx6U1NqH8T2UOdV/G8D66/mYQ5iKMw4MtkV+e
WYzKsUbetxIS122L/DfpwJc1dsjWxlXfJO2R2XmssrQdkON/rs2/ex9Z7c6H
otAHyP1ix37nP0R2r2v5+5/nh1ct4uFQz+qGnCvH0yqNnZ/380zeuuyDtONx
FL+1e50b8tLb6Kn8WeQ7B11Yqs1Q3il9Ptb/ssv9835OXSgf1ch0NKb5OCqf
/b7Hj/Mjcrn03Th9HMrzi4zMLYy8MkbXX03CDoEv1lHVbcDZ+j1MtQDlrR7Q
Fl/23Y/yVFd/LzMlR7pk8PTBCpvZ8S2PSLTyvvWJNfHjyKvPQ509/VBtqbcX
/O62c8ccpNDKCQl3+p5dRL7Yx5ph/RA5b/P7ZzrvkLMrNP0hEzlx84yZfAXy
uxvBitI9yAEZirw7SMhPmHuGN69D+Uj3dL1+8Igir85fcm5Kfew4MgQD+amt
C7woL9bhSnGydh7Ki01wnlFkrp+jebV+UtaLjj/sG4Lkbw7HHJ1ItPLQ2bjZ
5ibkQsej2pd2kmlerS8Oly+C5nFDIFR0V6FEmUIr/5IdPvbxKrJScvF7dyfk
ytjxc0bByPvT9G4f/4rMKl3avJKP3BWjcDy/CjlTOP7To25k/5CNvIozyBbc
3k5UBpQXpeRN7c3kRb6d3nO0/hXKw70Qmud3Vv7febizDT39iW3jsBi17dM7
V5SHu8/KM0ijCrn+gPbEAW6Uj7v6+5maXgKb3kGUb4s/e/Kq78l5OF/N/atz
//i/8mzb7Hd1zr9H+bQhLQ47S1bQ+rwrRscv3MSOK8P70KRBFMqrdc8cHmLt
nKHLXyWAjtlWH7EX/7We8U7JGXwGBba79u5YIKB8yiORHqXsz2dpf7/6ezXh
oEbg/Dhav5ePeauspifKr5WyHB1aYKOCAvGadnUoyqM02MLA9q0I2axfI7V2
GFlqC2vgbh8i7fsC5jyOtJUgr/7+Wi/r9Sw/HXnXcT9NK8V52vX3a02vmkMC
yg/68bnX4sgEBYQfl0+ssUb5fdJ7DzfBfeSjrXEFDx4ja3oJfE59jnxZ1jNo
4g2yZefso13RyLHPo/mZviBnCPRtdE9D/rxr/EK5Opl2PCZ6j6PVjZA3em6c
Lb6HXJX69biyP7Jnr2rAjxjk1f/fucuveVJ3CFn8ihDTZACyHFewQ+gA8h+B
js1nDsxD63YOTaZrM7Tnf2nztT+ime0sRSAy/8e5NYVIK6flc5XL2bHtR9Y8
NF2m+uAvdLXa5ke7zNCed13dnvmQCUeaRh3t+nnprclxaaUBuHYPKPCWEGmf
p/1ef+PZselH9eCeVuf59QTKj1ndf5s77KVeErU067z3aW/XbKC5uf5h5F3X
Zlr70RfVcfpypAsmI03iPD7P0PJZVvfv88+yCzd9OmCr00O/psRZlP/yz/76
3xpxDq3tgMwYncvvKHO08tX95ZnZ8aq3t4Xmd2lbJ084dsGL+tcLIRSUPzNX
YfjE5yLKl1nd39QRoQCpwjb0/9wDhnf5ubtono5NtjQ72gNMp962KmehfBkT
3cneq2XIPwyOjzk1IwubvpoNHkZ+ZDW08I2C3GZ/hLmKFeWnHnn0fP3YRuQ3
Ht18LBLIJL8DQtsPI1947bUTTiKnRrRIX76EzBsrJX//JvLtr67Hgh4gV2XU
qiV5I0v/2Kn9J/Tfea59M2q9JS6tNFfsCLjTGtxGc5p+C+Pk13aaw33EghhK
O2j2zLPazt+Ftte00YTn3UoXzckr1/bYBnTTPHeH/wzHth6aDw2W3k5M6YH4
5Dih6A1TtHyb1f6YkZDU7CjZB4th6f2fu2Zo5avXlwrO/zXT0X5weOsVW2s1
Sytfvb4uHLUyklrbB6RTJicDz6M8H9rzCi+S+V5E9tLsfu5Kd8y7AQg/J+AT
34byfhQNCms8d6I8n1Zj202mt5BXr6eDR7mXxrBx8Kr37LU79+s7KjcP26Rk
7z0I6hz5dr5fUZ6PnkLhacJ3ZHOTkl2XSpHv+pYzFtQhP0n/2yHejfyyqzbr
+ThyFFtT0BwFOflAm+3lNSi/98eVrpOFPMh/n/btkBBG7kgZWnkhiTzeNtZK
kkdeWDOdfkUFmX3fXECxNvImA4rVHkPk3R6Lai9vICt8xYlR7yKrNTMvGbkj
X2Bkay55jmwmxZEqHfbv/OGsn33Zkyq9NG/TdWYRb0H27RW4cMW2j2bineQP
r5jQ319lOjX95w3yrqZd79v2D9A8u8M0Ve4P8o8770qfmw2i7Re0tA0uYfOQ
YyWqo7qztPyh1etPt4S7KuH8EM1ykrj2mrIxqMhKvpq0hkj7fJ1mwQbBt8ir
1+PeDSdS7L8N06wwVmRLrR0DSaMDXS+rUf5SzM41YnIcKE9JdLzRrOEk8ttv
8XH3vJBXr0eGXfXUiSvDNJMuW+Q0yI+i511CGRlmeMeh44NTc0pmA+1+uzq/
ftQm/1mXkwqRQTqOwmFdtPLV+eDdSjOdEOw8z/Aa7RQ+1I/yfVfnbxo7jpCx
68K1V9YVt36YVr46v1GaiFfexkyFN1I3m06fGqOVu24lhhqzTNK8Oj7nkRdb
fhlCgZhjRaO/JKZp5crvTtr7i8zQvO+T+fXzUzN0+9MIi2yP3K5oLMIeruY4
5h8ttOehVo83Zf+WKwzci9Cm8i4lPL2bVr56vLtfBL57XbgA1ew8WwX299PK
V4/X9pVkbqjhAjRYOfiNnx6ila8erwgpoVOEdRFeBw4UJbOO0sp/5evWvLs1
TnOuaPj4MDmb9v9/FTuBl3mVv2lePZ46y2iuQI1lkGVl8ZSUqKOVm800DREk
W2im/b5TNFiZUIIc6ZeamtW7DOeyP74/1ddJ+/zq8Sp2SC9pH1uG4VbK5kah
Xlr5Wcck7bNv++n2ZxDOxqxzUU1HDoXkj+/NsP3LTA4P7xukfb7FhwOM5AhQ
3b0t801EIZyl8tpzdxMhXet+w5PZIhg9FrxeqJIMhV03M2xiMsB+v5JM7g5s
fJraFyi1MR8yQ67KGpyigPhHo+Gv73Jh7uPLR0LRVNirP68TfyMdHrLeel2Y
hI37h5suc1tkAKON5tfrOVQoeJBu4WiaCd41u0rXl1KBdV2QXbdxFnDLM3en
1FLhbPjtRxpXsyEkrJui10mFMOkzT5MvfwfhlVyexRHsfpq/5+XGSzkQYxoq
GUWkwh4dtgg3vVyQKnNQUWOYh7s9g3HD5/IgVUrXcGz9POTdKf6mczafller
9E8e+qqP0FmBznJ03k/nvXTeQ+fddN5JZzE6i9B5K5030VmAzhvozE1nDjqz
05mFzsx0ZqDz8s7/6wU6U+lMovMcnWfoPLXz/+bXj9N59B+v5hcP0XngH9f9
4146d//j+n/c8Y/DM7dPD8ZT4bRA6Kz2+mIYq0w/ylGA9cNNffdtuYvgSL+6
94EmbLz1Zu+iH18heM+3NFyapIK6wQO3hI0/oZnbWsxtzTyEbSlmLt9aAFrr
fS1wzgQI9CL/UGGtBblFSRkhdwI0V5jt6F6uAYLIsR9980RYEUsUMs+uA6H7
gl7fhskwe1WXfyWgGgwS3x+RxNrf2+9n9T3qa+Av8dp6JRIZvJPOGrco18FS
1+CvZ7r9QDrmtWVItxleDpeU/LYZBAb3/adEfRpAU7C98G/rIASwca7L7q+H
Eqq4ebMFAUKr5xK1etrg/K88wamTc6DzdoDaUdcGVR92HkmvIYLF30nJuIYW
MPfrzX6HJ0FH6M66dfvbQaT3UkooNwl4lRlftL3qgAKJtTLZ1WRo8aDc3Wnc
Cu68uREvlslQVPmb3+NSGygv2K23kKLAF4G3Gb267aA2nscbd48Cf1auR1W3
tAKRRS5pMYsMRO6Aw7E9naCQo1PduJsChWn3HXe4twOnisK4eEsXSD19/Dfa
tRsSkioTM85NA/8JrSMPInphVsTPSM6cAOqcm6apfH0gk1P13oF7DtQSB/pN
7vUCy6Lmx2O9RCiWCP3yBt8L5++Jqn0+TgJVp7DTu1T7QMqz9fP2/STYuFSU
nBaGjYe1d5py/CZD7omDvsvY+Idz14kfTZNkEJW/vKf8cy+ILptt+cBHAU9x
9z+vefogLV2gZ78SBW4d5FuztL8PRhPYPq/H5us+C2GPvb9hn/+weGcoDJtn
/9yGEzjQC5oDLxlZs8lAFfcZdw7FxmNCT0VfY/W1d+MTZ632PjinlH26cbEZ
+F6at7eLD4KBysNee50hkHxVJjVjOgBrf6xhkpuchVGPjxOLx4dg17Dilcay
OdjVGytTajsEplcO1Q2QibCbKcZPI3oImpn/Dh48Q4K+wOcmlneHoe7aBd9Y
7PhadR78uoF9Xk7XhHVpBOvvrck2RiVD8Pq4jec5dgokPHMQ0BMeBuK+B4yf
JSkQFD2bf/reMMBcYcL0aWz8q9+rQ5AZhp+W1z3cb1FAZMNhufGaIVDpWXeF
9yUF+KteCA7aD4Hi/FM1zp/Y+Ec7KNY+cQRiw2/Kh8+RYcEox1xBdAR4QVNc
EjvfK7f6diwEDcPAZkYtufcN4Ni300fy5ShYiDrwf6zvA6tTaT9fU0bh2/LL
E4nCY+DH6nd2NmAUxD6VavWFT8GOpN/63h5jUPhMzepSzAyIOZe9+GI4Blb1
Ju9vf6bAuS/zip01I1BtdD50UyoFdDdsz7YeGYGDY2pBhTkUOPtAU34BNwph
9w4/tyqmgE6Xfar3xlFYYZB6yldJAe0T4fs27hsFs+fC7nkNFDiTUPwlVn0U
fm/keWjRSQEtngnJg0ajsDeayYFriAKn7/PHF90bhSAZkm3WFAU0O5R26vqP
AuX78A0TbP5wSsXiQ3fMKFxRa7vGzkCFk5/8RW7ljUJhTaVhKhsVNLgyw5fq
R2HXlQI9Q16sf3Ho2uQ3Pgp+w9901myhglobS8hm5jGYsY859XU7FU4c38f3
acsY6K2EqOpLUUE17mKgwoExyPHxOYY7SAUVDnfOEmycJyrgfOiTEhWU7T/5
nr82Bp5Rt2R11ahwvKWGte/BGIxKXZNaOEMFPMx72gWOgXbWefFofSpAjBgT
7tMYpKmoi2oZY/PddZpu/gVjsKnq8GYSNs5UsrNf2to8Bi4GUnzv7ahwtOmt
U8LUGPQNCHNqOFFBUamYfJhlHE7a8bDOPKbCkY/jd8uEx+HrIhNjmC8VDrPx
E/Tkx2Hw9bu3/fHY+KJFuxw3OwmcZUtbNmDnSy9hNvdM0yTIzxuGH8+jgJdz
SFJ4ziRclcrdehubz2VoK34YfT8JXle3RLyrocDgtq5Xhzwm4WuAk1BlGwUE
5h4/9boxCY2FLRELAxRQKxF3qj89Cctzh4Qlpylw7025tdj+SRDf9ebdxXms
vVraGt3mn4Qzl8jCT7FxcuNRXt186gTc89V7n46Ny9dyZaiu75yAd3npIv0b
qSDfc0nBoHACSqb4Inmx82GRuiQRHzsBk9vuih6XpkKwZ9RWks8ECJ6vi7yl
QIUS/RNcqrcmALxkt707TgWSxAjDy3MTcCMrMKpCkwrii35zXQoTEDA6vW3h
AhX0/u4bkt46AdlbdT5IYPXvFVnf8hA3AT1nksQuWlIh445jxe/+cWB35/zo
hc0LBlW3/hD8PQ6yqTbb012oICBYkGL+ZRwuD1R87HuGXT8jptGpgeNwfOi+
EW6wBjbokS57X58GHZ/ZRP51NVDim5vAbD0DQ3OSjw73dwOlSOT7zZhpGIo8
OfQW64fx9562i+6eAYnZrOKsviHIE3m5ffjYNPj3SysyF4yD1YGaLXYB0/B8
QGLos/40SCQ8K629Pw1/jzPIs5bOgEm1uqzv7WnIipq6fHTHDCQdG7BZIs5A
qhADp5zELDhQDwl/ezgF+u98jOdyZ+Gx7v6qCq9p8Iian4otmIPyjymOh5Wn
4Dl5lNRrNQvyb/bVBt2egdORooFLUkQQH1zPM145BV0EqYUpDyIIuIkeCbo6
DdduPj7a1kOEce9hgmTiNLg0paV7XyaBvF3J5sS100CuSxF6doAIabw7F5VD
Z8D74TObzDISyIGDhcCaKTizO75faZoE80kynGG3p2BDQ+nlYkEyFIiOpgu1
T0Gz+1DtKcDufxq1X6u3T0PEXpZTNRZkEHdPevzy0jSYton/1PfH7t/Zfnrn
X0xDaVFEcik2HwwSpK6IF09D2j3zhnP1ZKi11eN4GzYNURLS810EMvCUpG7m
ssPqt31O2JoH65+EeHY/UZ8Gpxe5KhQZCry4a3uQLDQN15U9bnicoUB4SIhn
4/AUnCNqPue2ocBmNd3I/NdTgI/f8C3clwJv5tbnxGL1l3X9tG3XEgkW4i44
qefPwAbhS5/UFLH7H1OOfLHlDNjWm/d/cSSDs5HoLF5wBi5JlEZkb6iG7CTO
K6ZXCHB8sYKHlbcLpNe5nkrRIgCLzc0oCtcARPGttzaVn4W97jZE/plR+Hwy
nENFlwAz8ly1+tWTEFWffYJoRIC5s+k15gIz8FXVqyKVjwBa+7ZVZNTOAK/t
bss6vlm4NaWYbHVyBvzHNNWr9Odgf/zYm6Uts3D5U82jE3gCbB12qasKn4WJ
Z2cPOk0R4IqV6aE3unPQ5RIivv8PAfJP/fQI4JyFLSc2nRt4Mgd2aY66cgxE
OGNv4VQJBHhy7mLwLy0i7Np37vV0HAFeExRa9cKw8dg4JG/gngXydQsGoSki
nFIWWn66dxZUGwfamfVJkMCbf0Y+igABquZZ4/kkWNd39X3/BgJkOYbMSxgR
4XzA+JI2YRZe7OEt+dNHghH5S87FigR4E9j8fPtaMgyZBE8+sCRAFPndhYe7
yTDgV2ckE0qAz1fMhepOkaEvk7umv5QAqUV7BiRtyNDTq6UcRiJArgQh8fEL
MnRx+KZq75yF4hdZd1tTyNBxqGzHmvOzwO+4npNUQYY/EiZxzIdnoZTn/oT8
EBnWbqoo1+afhQcJPRX3GShwnFVhMmyGAHtOnE7M2kKBh+QonsFKAnR0ZvhS
D2L96eD6g/s/E+CF4zarIzoUmGm4f/GRFwGUef1OPfxPvtGv3oel17Dzl0CS
yPWggEWa1nterD7jTpiwLb2jQOTHrMIrWwhw89Zxq68tJDD7Fn35P/WfyXM/
WYGLDFV+PYf4FedgTVoisUCVDEeuCwucwOrrnF7vkVNOZIg5fnn27qdZiKII
utUlkYF765vqaONZqOEPv3G/8Q9kED5KGnMTIbdK3rh/vAWifLO2R2UQ4SxD
2g7NimY4Pxflu9+LBFs2pHlbmfSBWLa8psjYHOTNq8ZXVg6BQgA3Q/lFIvy1
dix4nzoG9Y/VmwiWREi2tr/FvnMKVvSD185KE0Hu8MfnN4RngC/KqmApdQ7m
Ij7+7c6ZgfVK2SoSPkSoL616dW2ZAL+Ki05bJM6BQRR51tZyFqrXUS4bABG6
nETOPWychTZdKasztURgOEisS/k6BxW8AT90e+fgzsbtvzPjZsH/4MGHS+ok
WLrZa7KfB+uvbj7aPjMyBxaJ3H0pZ7H9dE7RTjhOhKrJY2ayL4ng9XLwoXko
EWoux34eqyNCmAc5Y3iICFZm89WV+7DxrbBRwaubRGC2OUNOek6CycyS33js
+Mtrgjm7sf0ybrVoV04hQeUWvfT9VSS4URAmuyNtDparbGxPj5OA0Ys7Pbtt
DmQ8PHddZyNDuKaXgjYT9neHIrrdxckgz7OY3S9JhMDxtNBwFTJUN9odddIl
ws/ICt1MYzJYhg/lczkRgXC+f12tMxmYr105HhNFBDG2xeLxMDK821VXdOQ3
EQyP9n13ycTGg3/UXd6OEmFjNm+6618ysMTd5dH9g9XvQeUktwEybHgcFc2a
SISAb3af3BfJIHLlr8IPPyKclon6+HgDdj0eWih3sCECa2J1xBNsvKqwYfdV
qTPYuH837o3HcQqoTJ6f6d1LBLcYmZeeF7Hx3G93j1AuIhwVM/Lzwsavl6O/
CupMzwHlnb/XUy8K3HBt+7y2Zg7St+S7PYugwF0D1mN5Kdi84vexbLZyEphz
r20MkCZDQPMpNTKVBImTGiYmWL21DunV9Utg87cK3/H9CSTYQb5mXHuJDIcT
/t5ntCSB7dpbEz+8yeDmzcNUt5sEbF0nrwoeKoEdw73c0li7ipMKmtYh/IJJ
yODfE0OB5uHovzI/64GFYdnhghAVzE8Ic5l61kOETWjgF1UqtEU5FKWqTsB8
+QJJgJsKy9HShyZ2TAO1ZVnjvjcFKIxqzKWGBHhVL55gSqXAbz4Lm2I+7Lgu
f0m5iY177dmfd0nozcH9isPHLvNRIcT1j5C42By8i7Aa4XbDxmkR55WnCEQQ
NjqqYphCgU+1m9eUCJKgcP5+0b0+Cmxk7SkNP0oCi+BUlUB+KpgIj3yTdSHB
ms68dSPYuPjJDU+WM+JY/WzM8rXXo0IqiV1sDJsPVEuAZjw2T7j38RTvPmz+
uL7U0I87lgKHdXwYHTrJoGHmVOmYTYGFxd+E7HEyeDC84eypoED+J7a+5Xns
fvsuXftkNwXc9U7WqbBRYFGxLiBlFjvPTN5FzwSx898yXbOJBRunJZelVu7E
jvMe54bHm6mQlbPX+grWvx00+R3IIEyFR+yLodLqWP+VZ3u9dA02Dr70u3QJ
uz5CNvEpPZ+gwJr4YGIldl7KHLJ5z2Hj/lr1su/P87DvH+ZUIhZQQfRgQu9K
AxnqFK+kpb+ngq2YP/sdbL446J+w5x427srjspPtX0uB+R7qB/krVFi3dM5A
T4QCHAc1NpMVqVBY679vo/IIVNncsP3hsgBXpeVk5a9MQPSJPeHi6QsQ9ytH
J/PbBOjm37La83QB5BgHXEPFpsFx4X1XyuYFCFoz7XTCZRo0MncsGoUswHjx
3B73rQRQ+CMpcFV+AXadDWI9ZIzdl5VEsu+9XIDkw2dx58izcIznAm/RrgWQ
lz/iJLxzDvQvVNWts1iAXNntcyPY/fN26MnX56MXYGn9RYZmrH9hOZ4xfn/L
ArBVXD13YJII8jqVP3VgAfh8zWP8WbH2YNQfLGG6AKKnrMkjYiR4ZbtgxYjt
7x42+5MnlEhQ5Mx7vO3zArR7jXGH2ZPgKB/+SKb7ApDqle/f+0mCvFtuP2sE
FwAvy/xrgZsELc+NqU0si8D3a9A/EqvvI4w1JPltC8BbWLZDoowM00Wlj31k
FoD7x+fvKbVkiPXM5+xUWgDOXD+dIx1kMFRPD9t/egHWZ9sOFmL3P162RHFP
gwVgz9B5pImNp8rKP3xrvrEArKmyvPVYf+LiF3pM6v4Cdr3wxRuyUEDuTEC5
q+cCMH8hKQ1g460xrqd6dUELwPi5uc5mKwWiapx7xT8sgM6sevKNYjIQ1Fn3
spxehO7tjU9rWsmQvdM4wU96EezOmxkdmcHaO1PWbl6uRWDwJMh/xLav3sMV
GzK9AJP7eNSeUDNB9bfukNzBZfC4eCas6WkZVNzJWRNIXoKrF82/yHPVQXYn
48aAb0vY/VTqwJuL7RDSx3HCU20ZugKZbquwd0CrlVSs7tZlIJU/tVJ36IEz
FtYSayeXwM0Dnp54OQDrXOLqUncuQ8bQicn1YYOQaWktLVWyBAsXegnXC4eh
o30Tv3buEnzYkr9w8MYIPAkL7uWSXgam684PHA+NQgw+2CKwfwkKzNIPdz4c
hy1SHS+0kpdATiLxayDDBCw7s9odXrcMUYkkv76NE1D0V7J9j8cy7CtlOJN0
YBpYzk9fOYd939Lb+9ECN6aBa9hDKpRjGZTSHm5v8p8Gw5KVE7OGyzDBk3l0
zTYC+DzlODJUvQR/DtsqHNAgwFAse/q+tcsQb7JT1uQWAVRLWPY5KS4D0SB4
18FfBPD8rGe1bmoJOtXe/c6Rxa737bmPlDOWYWvPV4vqyVn4W5pX/wrb3w7r
rPeNbHPASNXcrNewBO8oP5vbd8yBvGSrkeD8Ehh7/OHpgzmwvHwjpll4GcS4
G06NGMxBhB9pNFRlGcwlTypY/pqDzjbW3opybHvPcspurJsDhfR9c6Wly+DF
3WYW00iERCrZNjF1CWISvYlfBolw7GfopNPvJSjWOOSVQSJC9TNF25NdS9DX
PyjwYy0Jrul0TAgSl4DR/XVcqQAJiIKuNoPsyyAqpHqoGus/n3aJTqSJLgNk
E8qa5UmwOa7Q+on8Mly5EHWpRw3rX23Nxs+eXoYknELzg0ISiBDzyhs+L0Ea
/5o77SpJcJbLQeTuDhyegSyz30SiFJY67t3dtxuHj5wZiW+9Xw4fLqh923Eb
h79nyPKsdvsf+CX81ULZHIffYLbmY8GOOrjnFdq1fRcOv0xyHHExrIecN4Ix
2w1xeHcb+/f2uo0gbvXJylcWhye8nzuu86QOrvtJT1cm4vCcR5xlXN+3Qobn
Rcf7Yjg8G2nwHOPLNsj4wrLrmyYOz2T6/kKFQTvcsQsz2ncPh99sN7hLbKUV
umVDn2qm4PCVp8M37zPrgQFz1kpzRRze4ruyzLlfPYC7uWu9Dfb9RRB0Lsal
F8J2uG55rYHDJ11MT3zV2gOeXFt5r7rh8B/mRQ0yjXugqXZzRuUnHF6saJ/K
xHw/uHheex0sgcNfyTnL0nByAJgVL7VbquLwoal3/uS+GQCfae3tYITD6395
4ppUMAhc6lFeO0Vx+DwH8Y2MBwah292t6KwODv/lm80r0bQBUGUw4rj3ENt/
/SMGCfoDoBU0zjAYhsN7LawVlV/oB/2dTqQL33H4HC3PY+nlw6C63/m11B4c
flsT+wkC+wi4sLfuZT6Owz8zDtCU0RyBrD75sjY9HH5yhF/X2ncECLlBJqnW
ODwxYXJwTHwUunZ/j7+jjMP7KkhVmmWMQJz1yqv0Gzh8lrLAyRjTEbD0WL7U
7IHDD/FEHby3eQRyNdLffo/A4QV69oip1wwDJ4d1R3gGDs86qV8s9GAcltad
jr+5DYfnuEf+TEwch4gAPz32Azg873JwYGX3OBzlr2ROwOpHwEveMYZvAtpC
OVI1sf3bwtl41VljAh4KnzEZv47D71gJ/CKgOwmvrlOZyrHtMVPPBl4hTcAJ
oDLM43H4fgKPQ3TYBBAFqCsSxjh8YsjFgvLTE5D/7ov9Byccfh0167srzwQo
qBoF//HH4S0NNqXLNWKTsRHu7LkPOHx5zoOkkbBx2P2isE0oE/t+ybknl/ZO
w96rH7VysPP5jpk1uk55GrRMDorFK2D127WlWEt/GhsXl5JencDhP2bL9Jda
TYPP9Ut/3M/h8OKvVJiV3aYh3nLsva0JDh9vq78j9xU2L7dxvnv5Fg4/Jt43
0MczA8mNSqnPRXB4ofUfK3rHpuEmQ2q9+WEcXnvmWmrPr2kQk9pNUsK2594o
Ftb9fhpa9SIEBWxw+IHFV+vJHtOg1qShaOqKHd82rrZP1tNg2d3XPvICh5c9
4f3J8Dw2rx9xcbkdicNfusnkyHV0Gr4RNomSk3F41+fOaoXbp6FxIe2n808c
vptz4xpFbgIM3BTiU8TaY7RxX2iZCDZvvl2S8nc/Dn/j29e9ejIESL93S/va
URxemtmpqO8YAYScN04Q1XD4mQsnLtqdIYDHk58+3mdx+Iw47ollbB4/7m25
WwhrT07UNnc/GwKcC9hQkmyBw4NmnMBmZwLkBOeaqtrh8FqsPHesuwkguVZj
q7wMDt8hvW+rbQEBfrRM1pGx68PmnHbJrUgCnP/y2jfbAOsvHG1v27kRYNjt
qMpDrH+J/aS857UVAT7N/2z47ILDi3aZnw3QJ4CVnsSouh8OH8bnfd9XhQDS
3wKW+0NxeL5TiRFe2PFMcVB4H8fh8P6uVUXu2Lwy5abRLpF0rD9JJ4w8YiGA
/a8SxdxCHP6u/PIvl5lZ8IvoCdLG+rtiETatJ4uzULS2+kMl1t742Pjqn7LM
wfyt/BRN7Po2Iwhf9uOdA9mWxILfR3D4tDaJ3gChObip/LZKHWtfzL/kbr7e
PQdRCd6dv07i8Oe/wnTogTlo4XOcUMHqLzrk1P13x+aA28Vi8edFHH7W7cLy
h5NzoD50fh3+P+8/Whp7xp2fA1cdlc35WPt4ec5qfaLRHGRk75c4il1f3i2S
VSKF2Lwi5EZGA3b+0r/e7xWJnYO/zc92dWP12fOkmCjiMwd6mz+9GdXH+tNL
PGyitnPQdfk3G9ESh9+TqnTu9KU5eFAuVC78AIf/YXwAl6IxB5subm66ibV/
6trlOyx/vkLYSL0kvzUDvq9a6aJ6bjKkmnt9iHViwJ96t0hi3/ANKnoUNh/y
ZsCnWOW8/nszFQaujAT+DmHACx52kntZkAZLLWFsl2MZ8C5rD9ddEMwAAb3T
7uNpDHiOWy7t7I/yQHmscXCdPQO+/QkF7/LnO+hoDKZpBzDgE9/ciZnZnAVG
McTHQV9Wn+fOgCDRFO6DuQx4QzpfprMBnS/R+SKd9emsR+cLdD5P53N01qXz
WTrr0FmbzmforEXn03TWpPMpOp+kswad1emsRucTdFalswqdlel8nM74/2H4
Hz72P6z0P3z0f1jxf/jIP371jz9mEFULRcjgvt2sTMYvFw5r5j80xebrU1rJ
r64XFYJC+8gzxkkKiPHkzhhmhoCm8j3KyQtUmjulPufILFHA6mdM56bGz2C9
a7It9N48aL0+GZUb5Ar4DSbHrhmt+gXwr9RFSmrMw7wM2bHyawiMjKoxze5b
LX8P+Y3Z5jmb5kFnqbL/Qu5H2v/Hpf//81rRNB+g82E6A51P0FmTzmfprE/n
K3Q2pfNNOt+i8106O9HZlc6edPahcwCdX9P5LZ0j6RxL5wQ6p9A5g865dP5J
51I6V9C5ls5NdO6gcy+dh+k8QefZf7z6/ASFzsv/ePX5CaZf/9ds/3j1+QlO
OvP949XnKTbRWeQfN/zjHf9YTrbx7fFvVFr7MFYzPfzgN5XWPnwNphuTu6m0
9pFp63x3mEyltY/ex+y8olyofQhqtPBJis3AV9ae2HzdX5BUlGmgvJkIIb8q
VLYdLYWX8/ms+YYkuND3+4HB+3KoVFfrrpohwabXn6LzPpbAcoXmlapiCvSw
uo6Vt/yCbSaBj9iGKRAXbS7Df6kUVIiNb1XWUcEGf9reqLkMBmOc+DKOUKEs
IkoVn1MGjtWH/jq4UuG0y+SZw1W/4I/1AHnoDwU41uaEdN2uhOXY4n2iHRSI
/Th32xebJ2n0GriEbKMCZbmcyMNVC13VZ66VJlGgT/XZDW+1KvDddzRQqYIC
2msjQ7ccqwaFAImCVGx/pEYXXAjN1dA3JTAlsYYK7H/1zX7b18ALbWbhSGx7
QympJyM5a8HCzKNpTIYK1zq0DlsY1sK3hreP5Y5R4W22ybMtn2thWS1V2vk0
FepfOzRVk2vhVFZ58y8DKqy/4y3udaIOgiV6n3DepILqmQgHxaA66A2j7tW/
TwVnyZTi6e462Luep/W9JxUy1v7aELu3Hpycd3sOB1Fhsrf52uVH9fD+TnJ3
oMIMRHBKy1ncaoB3fCwyPjyzMFxAqs451gLP5FyjxU8SgfCCPSR/shEq9tT0
bo8nATf7OO62YgvsCBx5Xn+CBBGOWW/DdjSBNqnY+w4PGYY/1fA8124Efw1T
v0z//7ynsO/k1r0NYBScuHTnNAX40x6dvtfcBL6/TV3X3aLAHs4w2cRXzZC1
uJkhOpACx29kbuzVaYGqFTXRrQVkqGDIxc2318NvO2fGH7NkIPxlvt9PbIDi
vtR+k10UEAzXmvjL2QRKgq9PnJ4nwe8CFlGL+VZY28cczatKhiSu8TM/fdsh
ZtRs+YszGYreX92w61cHNIgqiv35ToF7/UP+8ywNcN5iruFPLQXKSEcevPBp
gLqEL94VoxTYzOZvuoOjEXRnLJQqGbHra0uPVvaLRqiWF52p3EyFAmm5Q2d4
m6BjJP3dKVkqcMysfGXoaISYJ78jX56kQi9O1v/S1UawEer40GpMhUxuM5uU
rgaQz5yOFnOkgq9o8Gk2kwZY1mGOs3xBBeN9ZXtMeuth7vWGviNZFPhVyL2X
06EFHv28EGs4SIE7pW05/E7NsGYi5KYLHxVEK2JPCrk2wdbnK5eYsetZW2Rm
9oNCJzAKVen95374y/MgRfVBBwwnvjuH46GC4viDxcHv7RBZV6PvhF3PAYOq
NXKzLfAq9uba81j7UuKs1/lo1grPHjCkS7dQYPSgaTVPYys4nw41ZcG2F3KF
oO2m3gZ2Ivt5e7D6UPV0r5rMagMLQlnBd0EqzCRya1+RbAcXZgEHsV1U4FRJ
kpJyaQeWCEeO0P1UUJk577wxsx0CDrbFcB2lguP7+Urm6XbY9FfpmJcaFb5o
RQrP7O6ADxaRjYs6WP0tnLjVYdIBe1YYb9lfpoLg57Efv8M6IC3EnGXUHGvP
FwO5M+o6QGlf2Xvj21RwX6tg8mF9J5SUSR5qcsLqO609xf9EJ2ibPK/WwtrD
+LXHjA9dOqGZOnWjGKvvbTy7z13P7ASTl7oMimFU0P9R+fHcdCdsvLsm73Zc
PtSV66gyXF+EKcPfIW52f0GU3Vrksdki7BQRGdXDrhvdwkERfvIiiHI9/GvW
VQ/JvZyssmuXwN5tR7VARSdoLmvtf1m5DGxcIhGJ/p3wcQswVOYugcy8x60d
mt1w36xWyclmGcp9jy4c/NkHZs9et9iNLEKeuq7B47/9sOZ2ywMNy0W4qDXw
0WhiAM62ims4bFqCOZ8PEr5d/TA7c6WRZLII29tkuE25hoCaOrj24atF2PjE
K2qqchDuHbq6c8+3Jbi89WzvNc8hePxHsGZs7zK4pETZqIoOg1frseFjb5bh
zp0sFRPhMdhRduDxx8JF8N5RV79UMgqXHa8/aMb233R9SE5k7ChoZb0ytchZ
gnm9l2YjimPwNUmbZ0x0GYY/VE4M/RiDk8IGdV+clqFC880TyYPjoBXB42VV
vgwzj5xEjlZNgs6FldelyYsQKfZHm79oEkL8ygQuXluCmWF5A6neaeCn9O+z
jML2X4vwfEfZNPiYXfzNrrYEx3+clatkmAGLW2I6914tgUVF0OV41WnoKHju
Ix+0CBSdNcDtNw2xonwPz88tgr5RQcg2m0k45J9bsTS4DLLOL3ae/j4Jr/oe
MueNL4Gvq1/Uwf1T4HT3rFaY0jJ8dyiNaQ2agmuZRceS3JYhbuCpY9L0FKyp
45Gs/rEM77tytcU2zUDpoNvPlZuLsCCb5LBHfwYemx5XMspfhNtLTLYVRjMg
FG35rgC/BG2eR6fEPQjQcfyexjOOJXjv1G974ysBeOVuNuPUl8Dslt/kp2YC
qIsb3njghtXn/+Pqz+Oh/v7/f3yGFAoRRUKLKJQlkvX+yFZJ1lJkl5RKyhIp
ldIioiJZWoSo7CqSNqQIWbLv+84wZrXM9zw/71fz+P3683p5nHmc87if230b
5nG23qqNRv1zuOP0MfMr87BxUJAv0XwGSjQk1/n+mAcFqvSvkevT4Dg7n/7H
ZhFC47vMG1Smoa3EUEimaQFOXbBMvOQ0DVytM8k6Iougs/FjS0j4NPRmVagE
WS7CMqVukz/Z09DBNbr+evAi1Ohwfd34Zxqaj/II3M5dhNj9cjvO0aahLmfL
QlgvGt9okfp6GRns5L/YqvrNg7xDClFUlQzeTqTR57nzYD5IPxriRIbQ6A2B
fFPzMCuc7ZixlQxqPDbBj7MXoS1BK+cMgQzBLa2x994vQKuiY6XbBjL4r6r4
5Na3AC3FwUP2emTwPPChR3vlIjQdeslh7UoG11tpXMJoPy7e2RyRdYUMHGai
VS9cF6HbK+N32WMyyPdkdxeHLILhEbWVnTlkOOi9b7Y3dRHewCdzSgUZgrh6
l3Eiva2UNby/op8MaTEXxTeNL6I4Oq+UMTALyw7USpJOzUNhDsfD1RwU6Ba1
Phv1YB6ynnNTrkhSoLC/9cuuD/OQHMF/eESTAg+zHVd2dM0DNWPvgX32FJh8
fjJKd34ewpv9njlFUOGLQd33jS/n4dL015vBh6jgcURIg2v1AvhdMRtd60aF
2WsuslryC3CWr/NAng8Vgt7kipxD+jgZfzpn/w0q8DRwLEk9tAAuW+eE+x9S
4eGi5Uy7xwLY5d/xv5REBcktSd1CSB+HDEXbhfOokGZBrt4bvQBm9S8ho5gK
OwL1PwW9XoAZZceNQm0UoJjkvQg6Ow9/Our/qJAokN9wqVkzbB7e39l7y4qL
CgEORvy0tHl4rPZJw2ctFbSGBAzyvs/DxR7l8ShFKiycbQk42zsP9uEvn74z
QM9Hf5Elz5qHQ8ujZEcEKfBnLk6ckr4ILz1tHJo6Z8F+e2ByY/oCFFc4FanO
zkIrt6nDQPkCdMqcWPuAhwKH+9aLzg4ifQef9Z9C9v3ziVzLsWQRRLr8Gk1U
KWD+uOyu4IZFUNYKUn2N6o3K87GG63UXYdH31MZKOwoMHjCs2nxkEWj9Krlh
pymgpt3q8ADFS5IVc/eBSxS4IXeWtIj0PFr8rZYvjAJ1okuCT6F41q98x7k6
ngIblsWuas5YhI7n5tP33lDgLGVbikHJIjQKiF4z+0iBz33FO3OakT8Eda1c
+YsCK+oO/5SYXASz13zePT+pwLvx6PGiE/NQXoal2zRRwTb/u7vHpXnQ7/Me
qB2gwmsTpZOikShes15KGs9SgdkT51GWNA/q61oPF3PQwPgC12mf/HnI2cV3
XxPVR3ErvM5s/IX86RBWkYv62dHEVs+aznlIOefNKb+dBprqhl5BM/MQZhhy
zVuHBp1OWsFRnAsQXixn7+NMgwukPZMJdfNwD2p2+YbQQPDqQdsUFC8jinyF
/V7R4I2Ac1mGF5pvVsviBoEGQyX113ysF0Co9sAWH9M85Le62WmmLFD4LZ2n
8bgY4KNresIdFozFh7uvOv0NohoWjqzsYMHVtAUf/g/VcEPp6gZBLhYMN9U4
Kn6phk1B9A2yWwgY3bVnyZ0fNVB5cm3qETcCNmjDPZH5uxYUqw4zsAcErOW2
tX7D5zq41dBkNlJIwOqrbbOEvjVBeccbB/X9LMjY0z6qINAMie512jxhBKzm
bblAan8jvBE9k6O1mYCtOLPhoz61CV6Wlwx9sSJgEup5XFlDzbBIz+P4dYmA
vdQweKTwpAVWP+fqS4knYEraDTKvLVth+57DJVfRfIeM43sLc7pAmadInXoS
PW/ILvm0kW5o1Pp5e9tKFty7SZfKcusE7bALKvslCBjP1zP0FRm9EMwdpnVS
lgUQyXM1x7wXErV8VD2rWJD2o56pXNkLfD5h+u9WErDFm08lcyR74PN1njzr
hUWwuutzqqy0B87XCtH2eLKAR3X75sqTXXCu7lGG/CMCdvXazyt/tnVBk5Nm
Yao+AfM91Goqx9kNPM9XWfidQOv/5fb58MFuIBGVHVfeIGDPS+xu8CR0w/Hl
j5leCQRMoMjK+GNfN3QIs6Jr3xKwCuORR1qCfbDNT69KbikL2tv0M9xT++Cc
edQm49MsODCVvDk6oh98kgwl/LeyYP36YzvLD/UB7eWP1+2LLAh/3Fh2+s4g
POqqGU0XZ8HtjjeSd5gDQLBu9al6zwI/z5GRQ46D4E/OeW4zxwK7nKbdjxj9
EJyUe02QmwWTzIOxF68NgPPDsuqLx1iQ5Bfx3uZeH+RGzg7vv0/ApI4tiyJJ
94Hd2TWHNr0jYMo/xcYslPrgCY/dw68qBOwI8U3Cz1t9cCTxXvVlcwJ2RVPb
FLr6QFjjG4+WJwE7aeGzpnldPwSe3vZW4ToBa9hf9Tbduh80aktuNyJ77jaS
sbwW2Q80NVv7q68JWCZ2ZepQRT+8iyMpy30mYPnrqZ/imwdB7E9U4DNOFjS1
8piEWA3BPqUBebXDLDieuEFeLmYYuLRVftoQWPBsSOYQV9gQhD5ZE78EPb+7
1Z2b2z6OQJLa4SHadRYcVmPqvO4dAbmWkJ23K1jA++FyXaHqKISc53OTJxKw
T9pE9183R8GH3pQphPR0YWYgj5I5DNacL9buZaB8mDLUSZIYAVun5LyvBizQ
tRnhGQ8bAcdPL000Ilnw+c86Qsf1ITigo/mwJxg93+VUsXHlIVDu8Vnz+SkB
K92ssmOuaxBWh2TFxyF9BxZSGe9LBqHyVptBtRQBa+2SkiHxDoHXmmedXLsI
mAbXPsutlkMgnOrir4PsGyN3PsgldggKdsoI+SK99ewp4iTVDsGxe6zMrEAC
lpbo2z1JGIZs8xeur+8SsLNz2z9NKA7DvJCh6H/+tfPQcOy4wzDsbRiqfPaG
gM1nJvqNhQ/Dw5jQa3Ef0f4c9HIW7xkFuYhJO/ttLPgkz5fGYTgGOtLKPgfO
sSDo7amS89zj0JJz5IeXDgtkJMirqnXHYJUc8U1kGQtSGS8ff48fBY/1YQH5
awlYcImIs93jCajeM16eeQH577Z7v8QQhxjGlpR/ZIE5qbpzSesEfFxpePLJ
MAt88gRmpsQngXHG/1YBLwHLW5669sSTcaB3dL42FWTBq0FbqSnqOHhH1ZxQ
QvHv6Td+aT/zCZgyLpYRusuCc/umZGIsxqCp8av94jUCNqlTa9sqMAYGQbY+
Rx4TsNMqefckqkchZ/NsaG4mAVP73rAiq3gUPNf/eH9WmYDFUVOPXJkfhcqg
C6tEDQkYS/ZistnOMZDrkPX6eoSAHbMxIUl5jcFtrebKE6cJGG1Us7syfgyi
VORv6CH73zRzSm76Nga7+tw7lW8TMJG3ISd6h8ag/WHyrg3RBCxZ9I3CBN84
XDPoebDyBQHbcbmGRNsxDpspEhMstJ7iHspbDttxqEix3TOF9uO8wapdK5Im
IfH4+0EpFM9u+d0z/TkzCXdnbjQdsWdBQhqP2w29KfAJsvp5/yELNBqWh3YI
kKAue69iCg8L5D+3Lk92noLsrrGSkVAWNE62MvgaJmHl7e97b4yyoGG3w8uv
PKjeFFSzY7IWQbUpc8nHHBIUTbRn56D9Cl794iz/GxIwBK1tunNZkNd6zaWu
lATpqlKmYw0s6HvqfOhRJwkcDw/rUeksEHbdvdeWTgKeT83xBH4CVruxTnFG
mgSvfjxaeXF+EUyGy7O37iXB1Qse5Y4KLPiZ8U3Z+RQJDsvqBhvasUDf+0Pu
43sk2N4kqCUfxoIh40ibi1JTEHbGawcf2k/zHj6D5pFJoEgsTd/3kIAVXri7
fefbSXCojpe+mULApPl5xKKCJuFnkPKT4nwCpqIasNrVbhKy7xy/9WI9AbPS
8/idGDoJL45YDh1VImA+5kdvdxegfkJWd48IRsCiHUx2Sw1Nwk3q1tRqMwL2
/rQO015kCvy/iyy77UjAmi5uz0vQnwKPKKL77rMEjLSK98D7Y1MwkXH3YfBF
AubBf1mE6/oUWKiK5tWg+N/HTeqwSpyCd4XJdZIRBMye0/Xliy9TILZbeeZ0
LLrfQoPndMcUBP34JPgxCT0ffa86Nj8FvQeMlXmQHtwYHVf28JFgz59G88MF
BOyF35p+z3UkeGPr6pXy39/j6mW0x4RRvd9Hmk6jo3qZX0wjd8c0nOYdHr+x
kQXpe5fvDLCchqXKXUNOJizYe31BBTs3Dc8ON/Zq+7EgoiNcPLQW9RP19ge9
NZG9nb3ukIKn4eEKs9W2KSwwSNnz0dl4GhoSFvYazbDgqDG5wap8BjiNxV2S
drDgW9S3a/xXZsAv8D5zMY4F3GOONXoPZuDdGPmqxDsWmO1elLyQMgOzR62X
af9mwaOYhDNvCmZgR2VBuO0ICzomNIu6fs2AxlO+0CIUf6UNWniFu2bAplG3
6hfSz6m4CzZ7Z2YggN9rZZs4AXtUskXfWGQG+hJSHDcvZ4HKsNORGsUZOH8o
x36XIguqV8SesTaeASL/p6P7rVhwSrk2uP3YDESW/bRxQHrOOcFVt+TmNAhu
8VLM9CVg2rtd8ulnpyEmdK1TOtqvH2JfEsZtpmHdRGnka6Qvyxnx4G79aXhh
dvZbGvLXjgp/9z/bpkE2V2zmZQ4Bc09qMPm5ZhoyhEs3pnwlYOeKj65ZIzQN
HseMta6heK53pHF0hfQ0GCWfGc2XJ2CrJs0/c+ycho39kbGT6kgf13/dp++Z
hsVNb/duNkDxTszIbRLN3+raRDuK4v2NrK+7+k9NQ34S8+UDOwJ20FBrRetl
tD99EtblKP7THBIs99ybBuonNyGKN7JXO38gI3YajrkHqY6geNRlcy3pTQrS
x8oY6w6Uf62ayL/sc6YBK8zyr0X54cfB47MCn6Yh0/Vn3Hf0vFp1zeuKf6Ln
5+sp+oDyRZbZfkMf1F+Gvmd0ZiB9bqr6dEamexrojkLEFyh/PDJWetQ8hvp5
HvlNj/IIGO/PF59DUf/5J1ffMBTFr8uGIkPanDOgZ2fnHlRCwCbCf5f8WEKG
aaqkRjqqd5riwi/tEifDhMt+b+XNSE+p+9VeKZNhpPpCxnt9Frx5yzMptpcM
A5rJQ1ouLIj+9uNlqAMZel/WbPh2lQVGt+uDg7LJoNLCjPdE45WeW1pKnyCD
+qUToo1Iv4finYOzd6LrT6IOiSK9XXzklavNRYbVjk77tq0mYHypH6PoybPw
vO79Hand//mD5U7T47PgqSQbuv8J0s+d1Q6+3rOw40GTuGIWC/aotYYkXJ0F
OvlWhtA3FmzqeZJREj4Lnw7tAmodC1hhzg2jcbP/vWenpqWfBW27Ni8Ips2C
kVisyycqC/L7h6U13s1CyCfpi+ZLCFhUZLqJU/EsuE/O6+nxETAvbS+fW79n
YZ9Uw3JVtL4DwzsSMttnQcE8489mpKf7SvkyGnQy3I06avpwGQs+emw5+5l3
Fu76bSsvWc+CgeTYfH0JxEdY+rMaLBDo4iWUKyLWrP0sjfxhl9ilvaZ6iNcl
aRxC9aWL1URk/UHEiz5vQ0JYYCO2cKzpOBl8xmkvB/1RPXaQuynpIBlOmdiY
7wkhYJyRq/Z5oX7fJb2QkYrqQ5tfkh+1lchgs2JdEjeqbzKXym3jkSSD+enL
JidRPbdET+1Zw3Iy7KnspJS/R+MvY4IvGDOgq4A9k0N60H5Z8EKeSAbHPTFd
TNQv7IuOCT7JTwbZ7hjx+e0EzPqGn0sq0seU/+PDC8hfXL0P6Q1sIUO+YOzD
RRSvvVxUN25C+3vldexv1j4CdsliFYezPppPP245EfUbd7CZnqfmZBBoj9vD
gfwnWrH2W7s9GZp84q9zon7nhWR24tpTZHjGl/Blied/611/o8CXDN/DQ4g6
KD7EtKjthyAyHJxQduRB/iR3br9Q2U0y9Jl0FjVcRfUit3OLSQQZzqeHrn1x
E8Xv537P62PIQFyh7u+J+qE+9TB32+dkiDzV16CJ+im/34nbe9LIIPUrYscy
VI/wuOdT3HPIkCmnfb/+CQGLX6wsmvxABp3Q4clnyN/4Zsd2uw3NQp/UWe83
HCgfHzU1lKPOQnWFw8C31SygFWfvnVpCgQ++poeb5VhwWm6VydtVFEher1s+
qcuCnvu+ZgEbKRDxa5sWF9p/a0aTpa4yBS76SWSIu7Pgl5OmNSdGgeMb+KRU
AlmA/Uyw+WlKAYvK+ci9ESjfp6ccGwqlgKawmt1jSxbEBS77GgYU2FJrxRL+
wAJCffQdZQEKzPh1xrYwWeAmJ23V2DkLDvdU15pJErBX35/kqQ8/h776sqIM
PiK2l7JWo9A7BAIi/G5FTf/laDDNO3jM/Q9+PSNnLLbhJn69OZzvE0cyEav7
f7/vf8r++3LDP9z8D7f9w53/cM8/3P8PD/3Do//wxD9M+ofJ/zD1H2b8w/P/
MOsf5sj9/2euf5j7H17+D/P/w4L/sPA/LPoPi//DUv/wxn9Y5h/e+g9v+4eV
/mHVf1j9H9b6h3X/Yb1/2PAf3vcPm/zD5v+w1T98+B+2/Ycd/mHnf9jtHz7x
D5/+H//9/4n1w6O909OfQeELp+jKX6jfq+z7WeH/DbIKT3bepxKwgbqE5e9I
3yAyNNjBZxsRw0a77c9ZVcFsg2FieSuKJ8R35U9/V0Cyw3R53joi9sjyVM27
uF+Qv/nsbhoaL5m8oanSrRLKx8cLNIGIpVKaOvqUqqA9z0MpyBztz557/cy5
Kpi8OJz6zZmIrRnl/3Gk7wdIrNh0XbQD9ZcajP6wi+WwcWGq4B2LgFUd91v3
J70a9J2udmej9SZeeqr9ZOE3xMvEvrcYRvXGPtftO1JrYHY8J2xmCRE7qLpB
IniyFn7t3Md8No3qhaC32Zvra0Dg/OXLlRuIWPVcy2k52Rr4URd9nQetz356
0cKBWg1Xd2TeMbIjYtvXrq81utEIj8Nj1iv8JmBll3447r3WAEtyvq9XnSNg
JUvW52jS/oDlWbEdd8WJ2O7ltb0+ug1g+PycQqosEfsiGCycFdIAu2rLN5fs
IGI6ojuMRiobQJ5jo1QXmu+jZP+FTcKNILXjoujcfiKmsTn6lf3RRhA6Vie4
5ggRy5c3aot50QhLo+WW7zhGxApIvC+eHquHU19UCkSbUD2fbBMURa6H8K21
GcenCJjQkTTb0OA/kPXwbNLbZUTs1A7u+SvdjVCw7f3W5+UE7EHLt0cb7Jrg
sglPd3InAftwJVC5pKkJ9E7ZPXpFRvXdZrXKY1bNsDQ0yySTm4jtjNe6s5Wz
FToSfHs3tKP+1XWXlp9aC4hxn/Vci/ZD7dvxsgO3m8Gggu9VKNp/yvJNQa4b
m2GltIROJ9r/d9ZdagFFTdB+WaFWGT2vb2L8xD3rJkht0nILQfuvNn44JZnU
COeV9zOa0f4nQay1t3knPIpcvEUoI2Cr2++su/yyA6KveKQO9KL863+x9+Z8
O0R5NpZVoPnr+r6aVlxuh4ffYkV6RFF8abG3+JjXDlkupKIVG5G/VDOt0kfa
4RfnnmO75NH9S2Ksn0h1wFDyk+XHVInYSIGqzb1DHcBpNJsboUPEFDNrj165
2wHrh4xtPxoRMZ8kTwevbx2gfTuROGRGxAofL3d2pnWAzVZ6mpANiqfhaa6W
2zrBt8LUXNeFiD0XUeJvb2yFCMYlRWYNAUuKWU1X12+DaCVt9eN9BOyl2ELP
w6w2iHef062joHwW3/drSrwdEp8WGukiew+tlN/4wb4TFtblpjh+J2DZYT+/
vvjUCczyAmZGAwEL4D7uGCbRBTS/L2bzA6gfuMG56Hu5C2Y3lSUbI39dTkhM
cOzoAlJNJePxUpRfdJ49SZbshonL9aZDq9H6eL0KL9K7QfWe26xuFQH7PdjP
6ZjdDUVORtEl6H6LxTYH9E90g8EO2Z17FwnY9mfVj2TXd0MlF3dTJfr8gvfN
7mlaF8ROcJiu3YTi8UWvdVeyuwBLuzwAiii+XbU9suJkFwy50C+5aRGxgJsG
UbEbuuCehLfw3T1E7EXY9hqZ1k5Qa554k21FxCofiK54+6AT2h6c0G90JGJj
4YN+K//0wnmLb6JJyH5UF47J/OheVP+1UhrQ+gi7JN0cD/fCtlvkOm7kf7x8
mu1LxXph+YsV2VoriZiB1zma/KpeKO/Wdl1E/ujEZWt2dksv2N3y2aWB1nsp
Ti81V6cXpral8/nIEbHHivIsimUvBP/p681UJmJvS1cd1jjRCyKB4gUju4hY
jc185qXLvfBqg1W4NEbExif7l3590AvaP0NdHNHzcN+ocuBM64Uaz2L1OFMi
Ji32/r3Rp15wFWGuaDiE4mXmU/7Qul6gfVTuFbAnYnb6t45XDfVCqMvJfGPk
z94K11QVNvRArHZzzjvkn6qBrzkn9vcA79QNKWgmYLPl9XUZfj0QmKgc/nOQ
gL0TXUj0TOyBcatOpgXSj6+7zDnFyh6wX3r3RBsn8tf3ZhiJ2gPVBeqNx4SQ
nmn7f53g6wODPf4sJoqXzMjzt/J39EEW7xI/YgsB+y4Xq7/Utg/WVkeML0P3
v1/6hXXwah+E3Bd35UfxwM5h8GPSyz6YPpjaIkwgYlvoK/xnKvvATnSHuTiq
vxIP/Yk2KOiHD8mnlonVon6yW3b+6bV+sPEI+JSB9L7sVKALw7gf6Iq3vPWQ
Pgsp1T+thPvhMSVqaxPSe/EP+SKR/j5YKfjeTVeMiPEthOtxl/fB75cO288h
/z2iQvrJzOiDCO1ltKT//Nfd0mziQR+Y1mV9aUT+O5nwtqHrQh/wnzhym0cX
xc+61XZ1dn1QtUCw0Eb7E7IsoLd0dx+EP3wldhbFmxrtthP5Mn1gstWyNxH5
77rzOlOvlvfBii/M13+Q/0ouPWccnzQIqgcH+jageF/f6SSi4T0Iiw8cT0V3
EbDb+ebdjXqD8LO2ZYabRMB0IrE3PkKD8GDlwYuXkH1mTij5CfUOwFGzaiIJ
6THNlF6a0DoAVw7ku35eS8SIz32dCsYGIOxz6O2I9Si/T8/M1c8PQKyiQ4aT
DBHL1fOKmeIbhJfPleuUFYgYb9SEynKpQcgT5KJxqBAx1wGPahmlQfga3Cz+
R52IFe0cPqm3exCqyW+wFBS/hG+7cTlYDkLbsStufvpE7ExL7/MA10EYabAM
3bOPiPbbSTvaZxCoRjJZoiieSV7qaMoOGYQlBYz6kYNEzK/K1rvy0SAIbq2i
F9oSsd+SzfzDqYMgFfdcIsyJiMl6HXrN+WEQFJb76NkfJ2JX7yz6OM/2Q5Jl
8JxvJfJXpUqn2tUDELBrU7g80u/p5liT3RoDYC5ZKtmD9NB7xX1XztEBkFni
lv0I5SsbWTXpDUEDsDDCpWeC/LmmmmPl/ecDUP/7ZT0R5S8jv5o5QskAvH63
xy0f6fkPdSIzsXEQ7q4pXWWN9CwzVJaYTBmE0fTPvj3/xcemZ1GpwkNgrPeh
6XQ3Afv1w//W6x1D8KopT4M+SsAkCiwuZlgOAc+ZzPjryH+80uTOZJ8bghMc
rxb40f4VP+Z0yoscgp8xSY5xvERM5E675fusIZDd9vTbZhFUHxhzJRlHDwPj
gMURDjT/2oL2kI0ew4DJiA1mIn9q2vz2BFN3GG4tdnsfRfVI1MO7++tWDUN1
YxqRm0bALIiu218PD4FIllfEWy5UP5/VFAz+NITi0y4JZ2FUj3leviWRPAS7
Hnid5JQgYks3Cyj8vDcEy+ipDgbSKP60Pa85HzAEjfZdViHIH+ofqPhKHBuC
lJLV+8qQPj7sKxX7aToEPltNdZdponhPsP58XmMI9CNCduzdTcRu5g+5SEgP
gRClaMudvUgfngHLfvIPQY/trEQF0oPV5uXp5xmDkPNVftXyw8if2hPMJfoH
4aqMK7eJA1rfw+2UH9WDYB4WtxDmhuo5rc0n6WGjYHpaRbCllIA1dBzUMDw+
Ck4lIVnEOtTfX73B8wBG4fzalgNyyH+UN75t6RQdhRvnFMYtxwmYY2nfK/mZ
EXj080poIIOAhR1fddH/1wikStVvSUb5q5Bb3/h78gh88JP5UbmKiAV7fNQ/
mTICucfz8l4gf3oe4BNmkDcC+d2Hm45IoXrr9rYGqW8j8NF2nsmP7NURMygx
Vz0CX/88l/y+BfVDL58db2wfgVJTQ71AVJ+sfX8kK2d0BMp/jrgpI/tpfBek
h9FHoFrv3p2hnage/1OBnVg6CnVFKhlPUD7z67t+R194FBp3NtVYoXwQNaNd
J7lxFNqyA2d5DIlYHpG6lqk4Cl1y60W/In+rXZnl2qAzCv3JpVp+KD+QpE6k
Z+8fhWHJk44KKP8JKG6g3LUZhYnHfNd7kb236bbquLuPwrRQ7svHqP40OfDw
pp7vKFDDrCtMUX3kYWfyW+L6KDCXzk0sQf63B0KT7rwdhoTMaebHnyg/3u0Z
8K8ZhrMpnbe1kP0/NO7acmJ8GPQSfq3+2EbAvDdGehzmHgGRhwXJmiifKngO
pRtJj8DwnRSVwkkCNvhBd0oNQ/a7+uCrBp2APeN6pLzZbgTuXbhi+oFIxGws
JryF/UfAxfN0+67lREzoicF7zqgRUHOz8ShA+uU3PuntcG8ULIeUVb4gPawz
cum4mjoKa3PSOfajekNO7+iepK+j0HtRtr4R+esu3YM531tG4bXBiyQXVI8a
aR4QH55BeuGX8JlE+ejgTqMQ3hVjoNkcY3ARxQsXFZhS2DwGnC+ERJai9Xlt
32VjpjsGv06FD9xH/hskp1xy7vAYRKlxv5fgIWJhMnLborzGwI4VfPOVIMoH
61ae/+4+Di/Fgr2vIXuZuRpKTRuMg6hl/BabPwRM7PXFynUbxyE09G2HEoof
faSsgL2sMZgvrnrAjfSaoT4g49M+Bp5zg3u6/zuPKGjtn2cfxqB7B2Ehn/O/
/6c3u/br0RhYnBbLjRAgYudTlHc7XBwDy/Hu1Zoov52uatdXPjkGgQWF0oJI
r8cpt4yWHBmD5BtRKsNIr04SO/Y1GY1Blbkn9gXVJ7aGnftfq40Bdd1e00dK
qJ85c8f0svQYSI1ssDuD9GkarWphvmoM9r6bO2mgTcT2fuqy2sQxBueuNVwQ
10P96kCoNZU0CnEHskJmUD7U5ttpU941CiVidx6WH0D1glrP0YTqURgfcEl8
jvSoZB/m8N97jVbnamddQPlRLkTdWS99FCBo9SdTVJ9JZ/S6isSPwkljUsVm
5P+kDMWa+2aT8E26MPDzDxTPI3orZZUmwbyzd/g00l+xV3T5p5WT0BWz3Foc
9XPylnvLrKYnwNNCtaT8v/N8dswVj9ROwAKvvZL/DAFbEM78ciV3AsJLQ57I
LBCw41SnIpGHE7AuKJO3AeWD6qZVH954T0C6etOF6ygfqDpMnbxxegJiTl+N
MvzPvmU8wZkXJkCJn+QsiOJn8nbpuObgCSjPclTsQPm2/ZFuLse9CXCx+D2f
huwtzDpSoRA7AXMzuhU+KD6YuHv3WidPQFRUZgyG8u+N3+HMq1kTsG2npNsK
ZP8i9TShN4UTUNYUrtKM+rnZZ8VyDd8nwClggZWE8rECd4ceq2YCGGvPVJ1F
8eKYF812a/sEPCxqj9NC/U98s6C31dAEKDiYnFiG8nM9pnD38gy6H+ujWj3q
N55wUy/1XxyH7YzVARLInkFf/X6fvz8O9+JUm39WEzAnf9oGYto4TGpZqvs0
ovpfyd8n4vM4mHacfST13/mJw/QyiYZxyAwKp1Qg/+Z6HiCWPjYO/OvfHPSb
QP59mHlKk2MCznz7mbcB5b+fAoGff4pOQJXLoFDVPOpHfsytPKyI1rdkyXl/
1D/fvXLJdcBwAsJSNtRuWoHsq77wzttuAsaMQOk3isf3mHY/px0mYZPZb+s4
1K+pxKQ0i3lPQhVFqNUH+Xvjjsnh3bcm4UKCtb0Z8q+LNTsZJ+MnYYN+XPdW
FI8kz1zheZA1CZUjHa5LUH9XzPNTrLBkEvwiNwx1ovx5/OVKud4mNF7dzeMD
8n9efRtN3vFJ+NWRNvEQ1ZOZXYnGKoQp8Lsx7uWJ9GJ5adTWVngK1ssrze5F
66eI7jgVvGUKftV6X9iE4lXsu8DA19pT4Oufz1xA8UCOx2hH3ioSRFrUe55E
9YvTyJxOCBcJsOMlk3zIvvIPXe9nTk4B6WKeZy7KX4+sfr+0rJuC5xFJk9Yj
BIxDWKuI+m4KzJIfes4h/Z7587I2LnYKWAXXJ58he7ZECQ3pXp6CzCpvTwOU
zwwOBc33Ok2BQ6/r5DCKD8/uflNT3DsFT3T815uh/tW+yN58t+YUnO3a/ng5
0u/aCYaHlcIU6F0bEPi5gYg1STwKcZOcAuFNCbduoHox2lTl+YWVUzBUasnC
UD1geaW68A7HFHw4znNhAfVjK7M9GuJnJyGM++vkB1QvV3UvJWUMToLDa7/j
fhpofwWTeL82T4KyybZOFVQ/H3UII93nngbfu5jXQgUBW0I0aP0+R4JmPvH9
OfUo/iXNlTAmSaAVSdns1k7ArI3yMrb1kuCpUA1BDOmNNewR49xAAmL067ZK
pLe0uxuvRf8kwbE1Ie+vov2y2N7qUf6RBGWxjvdVUf/OrLl/cCGTBFvXaZ4e
Rv6d7L1PV/kFCe4+Fd6TgOpnh1VPdL7FkiD96+D9zjVEbNlJ9Wz5pyTwafA2
70L5P/tz7cZHaLz2KEGgG9nLRvh0NCGVBEtY4VXdyN/5Dl/G7siQoKkpcPcN
1F9xuXz4dUmRBPzJWx/Fofp+4TTF2msXCQy9mkazUT6iXlDudd1NgsvaIfAD
6XMy+MyZw8YkeMe9I6qjh4ANhb+iG1uRYPxP9zAZxa+uxwPXde1IIJ14T4cX
5c/mpA0CKm4kOHpG+8H6WVTPZtrHbfYkwUON0cGdTAJW/iF2s9gFElRwPdY6
8F+9WdqQveIqCTjqDCNd/6t3fgtqE+6QQOMpuT8A+Vte64Ef5PskOOeRqBEp
9Pf3eFRoHv719A/nV9hZvCF4X9ff979/Buk/+43XaNMg/tNxCon4nf3+4otH
i+6kd+aDQfIRX1FhOnv83/c3S+ZcXX0rL5XNjMQ6F78nWWz22PegKbckD5Yu
X3G0zPDv+6eTYZks7zgxA+fLMVd7PNpwJi+jNdbzMNkccu13uDR7/FuQeypf
7VCKc03hLf7YNpx9m/pM62dwFp+FCD5eJj7+f79PUZx58c4iOxV/P+tzC7+v
yW/YLGBKUFeMzWIz63LTXHVZDpvpf7bbLf2Wx+Z2gYZdVkXv8N/nfN4sfrUg
H3+f6hm/hfS3H/D3t0r86GrJ/oi/L7ZyTfHSjE/s8yEc5tXSnYTr2Gwj/ZiY
svUPZPrctOxx+3v+Sh3QBH/sy0rD+ZDs/feLNTjnah/dZMrAWcByc+STDQw2
n+vzPXRa+e/77atB0WnPi869OE+0i06ZO+H82mZUq+QCzicaP95Wi8B5t0A2
9hLdPyFhUPXP9Ro2Xx15GXcazfeXRcPsEu4MV7DZqP+smy6lCkZu97U+Kfn7
/vU/YMJRWLl8COfMwMjPAbwMNv/9PP+L0vddT+rx+8Ue3Keq2MDmiJ5FfZHS
RvZ5IB80LUptCB0gkfMpILse8f87D6Udgq1nDA7WU0D1/73vuwUevRf7bbaP
Cl+qI5yo822QI3n54PJwGvv6X//5suad//3VLez9Kq9eoy78sZ3Nr9YsrJog
dcKps49yRY/Q2fNRbnisT7+Oc9qY+WXfdJwr4dqp5DKcSQ9zbOq7cRYe7tnD
MYfzLm2hncoiDDZPmixu6u/C1xum/rsHZOlszpu+/L1zO9LX2n2M+GCc38RG
qRdptkOgY+ew4iYGe/zQ+kDHEGWcrXrXNLYCzl+S3poomeIs72ZREmKHc4zM
pEabB86cw6HZSgE4e72Slb15C+d2j9InbdE4/93P7fIm49l0nHVDq3zaYtvY
rJWbdGSHfTNw7X86c/HwNCwdaPy8T70bZjxttvNbkcFlvFplm3c33PvVtmvX
xCwURJhPKpp0Qc/yOqmhh1RQELqn7hvRA6OYW6BwCwX8dW7P35XpAqOpH5/v
AhXuuCkULb7qhrHbFYfHR6iAzZ67sLaiC6yWRF/7qkgDwQva44svuqHJjZez
W5QGQ1Yv19hK90C9v9lpb1U6POaKX+/8rhtO0NUdtnrS4brY5LCbaDcsXlhv
3pVKh3bbYJcGaidU99GiwpTp8EDYsqT5Vzdc5GC9wQ7QIaW5H1TX9IDMhqUl
syfoUJBwoSjCBd0f+FrTbtChwolXYyyjB644CE/bPadDh/STd0aMHoDykMWy
9zR4wgHZP+Y6YZPYMEh30yDJoFWzpr0Llp00vnaNhw4HSwpdxh26QUa6jlxI
pcJc/63aZyL9sF84WyGqkwoRsm77H9n2gtNyXW4+KRp4GlU0Unj6oGWVb3qF
NQ1C55/uiU7sgxA3y0NOt2gQJhbn/2lzP9Sn7/iWVIieL0c+Mv9IFwjYNlZJ
V9Hh5Cptb5dPXbB/WUBrShcdAjVl3iwV7Ibbb8WHZGbosPtU5jo7/W4odf5M
Tl3CgGUJO+/l+HYDQcCZsHUNA6orP7OWpnUDn9aGtnpZBpQK/Fj1La8boiwk
bdfsZMAxl/nLs2HdIH5CvMXWgAFL3ikPyx7vhqQg0SNPLVE8XOZueRS6QS5a
pKkHxTsD24Sie2g/ct8IWW8+y4AfNkkHbvR1gUaxQMOJy2h+Ft/Gsegu+Na8
4mD6XQbsSfanWuztgr1TPPVTsQy4ua+vooDZCYOSsQ63iuioHnyn86ypBxRe
7mZ2N9NheOvjkGuhPXB+22i0JoUO3c0Xq1x1euDD2wfKUYIMaLllL2JE6oa7
et8uHH9Lh5wH2W7rg/thqVWSydFKOshciNOkYv1wzTVkg3k/HeKP3hCoZPXB
vLc71WCeDisxz/7Ez32ozt33S0MYrUf6yIcLl/ugwO+moxK6X3Lgo1hVxV5Q
M5750VVKB3tGjWeMXS/kSjgoRTTQYfWF5QbMO72gOF3+WHeQDr9nDcXs83sh
vVSNOEmlw+3zVye/9PfC1seJJ58sY8BuUmHJRqE+eHmKr85ElAHMM5THIdAH
DT4fJqw2M2BkeHkkxaUPSgvEvuRsY0Be8YaE/IA+eDsfECmA9udygnpaQGQf
JGGtzmd0kT39DrzVSu2Dhzc0d/wyYoCguevXhU99EPwzbslWMwa0bQ2o/PKn
D86vmGu4eZgBKZwRzdfG+sDZ/GhqvyMDznYk9+tz9INF1Ed/vRMM0MgvJHGJ
9QPWLG783IsBnPdr5n8o9oPSukvii/5IPx6D3KFG/SDl1D5+9BoDHhvMC5vY
94NAsvbnD3cY4CoptIHfpx8WhxIi1jxgwDa67Laa0H6YlF9w8o1jAL1WR+NB
Yj+I7d33ceHqNLjHluYv1AxA6WrjZ0Ki07Bl990norJDsA9bs15NmwxwRS+i
xn4A8pMKFPc0zQLtj5t+DLr+LXx8SNBkFg58cqkfTx8AIdPROattFNioBQP6
lwegObIq5eo9KhxU7D1w79UgZO842lMwTgEVte7Iy9P9kDe4giVsRAVjD4uG
iP4B4BVY+LhSnQIPLOt4rZuGYZd4ZPmD/RR4PW2qMek6jOqFi+dqMygwNfAy
Qv7sCOjmtGhTGqkgUP52D9baD9SvZptHhGhQ9kOq+CCa/+f1di01WxrsFEn7
fDp+AIQfzZvtHKBC/XG/wDctgxAhU9pgb0gHD12ih2z2ABxMs1/CfYYOAfTC
OD2DARCTo6nkRiH95Pr8skcxLKYhdN9qbTpkBd0NMREchEILk3lXKzroc1uu
zDYfhI4qvqwcDzo03ReNXxU5CATj386s/865Eu/afOH3IGwqixQ+EEuHxeSU
7Fb+IbgRs8ZdL58GzPo/Mgup/VDHq6S7tpUG9PsPnEqXDsD6oL0iM/P/va/a
PO6u2wB4TjuNl0vRYZaP/49l6QDc5NC44dVGBdmJwlspt0egcDrs3XwtFdYT
2hKlnIfgz5GHCRy8KH5uWfniOmMI1Pb3K0RgNOgt2rhrIHwYvDiKHmZ50IDn
80/zS4QRePPhIfN3FA2UvnieXOU9Al3xQoWMLDpIHqix3lTQD5GDykd3fKGD
sojQufCeftitbDF/upoOBh1Wd2m8AzAd6PXkZQcdDqdEpzirDsCLsgjd7nH0
/GeavvxC+rEUzOoSQ/5+WU2sVe3WAHDaVV+1Ws6AyAXb2WfI/nkvJzaEr0Xx
7XsCP2/rAIxpJbRoofjYyHNNYUvnACjkOArkonzexDy3Mu/bAJyR2WS4RZsB
zWMuszopA5AZP3jxKfK/1nar5p+3B2Bq5etsYQsGtFcZFFmdHgClm2cGQ48y
oOOz2vNOswE4N6e0jnicAV1ZMjdO7hiAXK9ZiwvI37qfrzkxu3oAyAP5tyYu
MqD3PrfJFWY/qB0N/OQawoC+YIYib2c/+NXokltQPdnvPboq+ls/FBhybDVH
/jV4rI0mldIPuaQayQ/IfnnNClt1Nw2BPY/Fy0gUv7QEzpeGjQ4C98babSda
6FBimO/YljMIeZoW72CSDvsvzTO3BgyCg1Wt9hpOBtTn7n7kjw0C72mL0kmU
P2xHbir/WDYIB9THJT8xZ+HKpZ3W59aNgol7X6LwJQrYlRmns7JGIV5rY3/0
ESrsOSR489H4KOz/rch72JwK8Sp2r7CtY6BzYp43LYIK7xlJXoENY6B5fCJ/
KScV9Ppsvs5YjwLne2rd+2oqcCU/M3oyPgKU92GX1TlpsD43pPxM4CgM5W/c
UqBOA+2vp0x0ecfgsPCicutlGny7P7Vtt+soRB+2eSPVQIVjdt7Hdm0fh4vC
XPLbVGngsD6y8ZX8GHzfl3ryw6ExUOY1D+2xQn3Ly0NDvb4TICYpWfExkAlh
QQojJV6TcKfBJ026nQHexzgC5TwmQd6lRKl1wxyse827l6I5BW2u/s8as+Yg
OaddOHtsCta2bbPi2jIPsi0v8iPEpqHus/PhhbvITzWMjVhh0/Bqz/TdhS0M
4JZx+uU1NQ1V3+qP9WQyYNGoUfqBExnUBq02yOigvpHQcCzFkwysgX0H01Fd
uTc5QiYplwzGj8xdN19FeaBIUrYF3V9F9dmzh40M+HqMlmweOA2O3zd5bDrK
hKLh3ZoXtSnQ8EA+z8gY6W6PxpV3UhQ4prlwy6idDmQJzpxUMwrs57564JIE
0uG1ZY+kAigQ/+LQm95DDCCbZZZdS6TAltRb1r/DUB6XPETrK6fA2zcfiEUl
aL01qz4ULyHDMbVtX9o60HofFZx7uo8Mec7OOcFaTKCdX9B3iZwFPpXY9KIM
JvRuDXh/6NMsfDcJftI1ivq6areHirNkuKMVRd7fwoDRH6eCvsvPAnNKIWVA
mgml386dPOo6C6eSv1tf8WIC18dzXuubqNChE3x2SzYDShJKIvesoMEOLsef
He6oDjg5HXB9JQ3elTxUeTBGB6tZgYs+sjQYv/Ks/zvqgzJbOcP7dWiAxZrp
GG9FfvOVEVNnRoNX/U+5MnYzYG3q1IuvzjQQUpqsErBlgHn4QEamNw0CA3Ue
nT/PgBDvtoKEEBoMlIU5NIQy4KNNbUloDA1MhdpldiUxgAQ/qv1f0aDAXn4q
7iOabyV3dhkZrb9bOLBglAGwuVpnUJIC3ZKlfI6bmVCjEfWLy5gCh+y9n3M5
Ib3N2p2sK0T5h1Je+GKYAfa/13utWksBA/8Bil4JshdZWlPBmArH+Syvd5xl
Ao+Nz/rvUVT4xO/ufAL17SlLVWRjUP+l+vzuQY9zTLB/XWZf5EyFEYnr6rsf
MEHE9GhUTwAVnsVfXCuax4Sq6amKpQ9QfhQ7vzBZz4SQ6BtEhddU4I052f19
lgnaGmK7LFD/91XYuSRBZA5eZb96UjtKAe3fHBM3SAzgSVuQ9eKlArwLF7op
zoSTzyxy+eWQ/8aL7rplhPbLWLWtfCcF5rxoRicG50BcomoiemgWnkQNe1pL
z4GEd7rOgeUU2PH529zIwTmQKr8bvkSRAhVDcbcvh8zBRqlTHR8tKeAk6CMi
+H4OVpw/zu18lgKrCJXvlnbMAfV2Rsn2uxRwtZqwauKYh+5ns0HzLykojvPP
pCL/q3ivpVlRTAFOpmKkv+k8mA13+/RUoHzNWTEr0MSAxJqe03LdVPDdZEzi
mEV6L+g95k2hQpt+xRhlJRMME/vsilD+0jtmPDS8jQmP7vQf5FpPg7QbFb1t
xkwYPjdgYqpGA4EU485qdybYch/PLz1IA/ENX2QCzJhAkfU7uOhPA9l9Jc6q
kkyI3HNzWv0JDVTO/UiYGmfAjtzx3Q9RvzBWnLwl+jcTch9Lv9gnTwOZVR9a
+24xwdP3ubSAOh3EJjxFBt2YcMkvfkcpqhdeb39oPWDBhNALj/QCDqJ47pUf
06/DhMf+9y22u9LhV05bc99WJrwMCHPqO0cHOzJLrE+ECSeYSxMP76DD3udu
LpIXUHzofPDDUQvVx4ep/bzBSF8lkpPu+nTg4r/lTgtjwrHU18Je++nQV7pm
tC+GCQV3d2r5o3qjODDtdM0LtB7P44LRH2iwXEBl141a5L9SdzMIZTTQ0ct+
f6KXAUdqs/adrqPBWd/tagfIDCgL/jPQ1EmDxLT0POUlTFBVZVzTH6NBfZuc
ymq0vhcDEpJZNBpwCbzKZiL/WBmjV7h2CR3U9WQVu3Yy4fJed+ubK1H/45uS
UbKHCWOMuzPT6+gQl7ZJIe0IE468yb5nv5UOlW2Jr8NOMqHsz5ldky1UCM/n
5/yEzYPd0zFJKxQfVuSRthZT5+D6bvf9Jn+Qvxy0NRTcPgfT7uS2bYNUKGRx
i7gazYHjvSunBeioX32T3//WYQ4q3y5fIPGg+s76+NulF+ZAsy0mvE6cBiYc
IjeORMxBKlFa8u02GtRllFi9TkXjhWP8onRpUPrb+cDTz3NgefxzhMV+GuyP
snw+/XsOWvIH0viPoPFH9MkGPWg+Hr7iX8doYCOhavR4Zg4GbVXbbp+jQXeP
dOwY5zycTj86axhEA/eXIuO6IvNAXgjm47xLg0mPpfBAZh4CzF7LfEXxyFeR
dn9AfR4IibVwOZkGc+Sh/l375uHmDP2IZg4Nggua1cNs5/93fiyqqwbaNSjh
f8/jmgTNzJ0czI3z8OS63Kv7slMQo56Xp/VxDpx++/a83z8FHe3hvutTccZS
3lVzJzDZTHv3elQscJ59vuLq0zXPKiXn4Iy/3yjTicS+39/r/GZaDLmDCwCl
fYs2z6agxdVc3JNrAXYKfd9yPpDE5r/nMQ4/nFGqEcfZnAjxlncXINe3wNnz
2TR7vApnFlSKz7D573m5lpxKiZ9FkR48BlxPofz0dz1VcfWtAk04X52/58Ev
TGHzKQe6tbQ5zk82fyVu45xln5fmfMy7vdkW54DAd81fUf4au3fmyu+lOPvd
NGjbe3cOlJfuM9h3msIeT0ml5Yu/wHlZ7JDVbWsKDBU7XTHTwznqTeKP+Cyc
i/bcwyormOzv6+pXHcJeUefYjA25WjZpzMNvH66Dh45S2evfJ5Npe/0SzsVN
1s45T3DWvsNy7/qMs1jA3YHYFpzFaetnL5FxlvB9z+HER2OzFHm/oL4szu5W
ZgeuNuLPR751oiqfg8rmK0XXDkxtx/nv94k6gzfTdp1nsnmZ+pLsvmacj109
NU7SwMfLMHZbZD+Yg27vxg1P99LY9zsu57L7vD3O490TTkbncT4fE3B17S2c
GQe4nk/G43xlyf0vxdk4//0+84fIU213wPmLDGcU1w2cb8pL0dalMtlcxNf8
KoiK8oWtp9bwxN/zqueBmu1fXLCZwua/+9uuoNydzo+zUPX8LjUPnCM+lBFG
C+bZ5zd6CC1b2o7y61+2vXrHv+4Wsrfbnls/+nD9/jwbyyPOh+/f04Cxu547
ccbGPx67dB0fX+Hza23FO5z/3n/N7bjFIcEFNl/XeKq24gDOU6OJp5VuL0Dc
3C7zj4cpbH8s5lxnXh+M89hyltlYBs706M451yacKQueCr+YOJPdWHYqklQ2
k6oiwmN341x4QD+QXkll2zN3q82FJQM4v+Y6671yAecXPTfOrhOhsTnuU9yp
Ldtw/rt/F+8nN2aV4fv7asSp0JSIX2/eLfF0Qgvn6ZwhcQFvnOvkzn/2T8Y5
L2neqbdhnv33pKC+3Mnr+nNsPqvWr68chLPjLZHYzoI5ELxyi9pajPuXipdl
QkUNzlbOEnqFnTj7WA4PvRrHOVo/LzyWifN71aAdd7jpbG7avK/FfzXO1fud
iAOAjyeX8YbbWeG8Ru+d6J/jOGt/ckzefxFnp128SiXhOIfkvf2omYjzq+2O
e3Lf4vx/5232wNnDZhnF4oswQ7uVF/G0G9ZFTgQ/N1tkX9+U5laY9orF5s4z
e/iDRAiYdV7d0F2THnAoCh2ti2Wx890NBfVfwSwWqERYk46397Ov/z0fM4wv
MvWE0yKb155a+vBh1yJQ9DGPyZJR9vwyNhmzj6+OgXnyL2kGD86rmxUftrst
wJqGxz/+CA7977zFxf/t3xBc3UrAPnzCOcLH1OGtDot9nvwmkDC+WbYAbnNR
4Z8FRtjz/b1+2K5ATOIHPv6xRKp34AoClqt87M1h4jD7ec50bipLOzPC5r/5
PcM3WL/+5iKbn5eRYi9NLMLor4bbzYUT7PmcKIY3I5dMsTlEc9uKm35T7PMz
/+Z7ooH+Ot9CnHe3pm31Ul1ks2mlueTRLQts+zibsiqKInF7Bev5J2YvYbH5
rHPaVnEXFvv87/4EE4GUvAU2b+vVUFPUX4RAyw2bKizG2ev7e903de/v/m/4
5xMKGtbzcBCwKTOszW5ujG2Pra1u5SXrJ9j893zX3bJVKV+OLLJZcQ+/bvTr
RYCAKo+xRBJ7PpKAMaNPcprN3L7Kq+1tSWz76HJNjL14TIKtu6ayH3vjnCmX
cPLd6AI476Zut+2fZo+v2ijl7nF3GvlR7qOcWZwtnVSubxXFefupynft93B7
r2iYLdoUj9t7dfLjuVgmzuYlPVJdhiw23+mVM5C+z8LrM4XaS9ebFtj8bXy/
TZvxIrznEphZJ4Y/79/rHUO9qgll+Ocvr+j+WD6Hc8Rjz8RAUQJ223dBpGsF
iW3fqy2Oo1MBOP/f+a4zoCU28r396CKbh7T3H9SJxznKKaP3SesiYI7Vwsvy
ZtjruW+8PkJ+KZnN1dra6QUWOCcozezUNJ9h29cOs+hVDpoB7hHruK3COJMN
FeJfXcJZ4ct2dZNWnCc1joidVVyEg8TKoMF0Mvt+o/bX7RleZEgnuZ7pHsTZ
bXtoKkNpkc2F2aeGcnXx60GrXR68jF0Aju2BZ/LFp9nxoV983YmaYJz/7nc3
w/qexkGcn9vJzegl4uz0ZeGQySTOFT2zEafkWWx2zns6tcadhZ9n3vwilzyG
18+ZtPDLlUZI71mnPOxscfuurlv5IuM+ru8d9pal8Uyc/35+ldiHINn3+P2v
Rc1U83TjTF/2SID63+9n/8dZ33PVh8SQPsKpa0piptl6qBE1ttk8inNbe1HU
BvWZf+L3LBg4Bn/fgvTyl8+8DP6RcAfnmIng8pUFOH9Vvf7rxiDyz5vnD3uF
zLLXPzxHPnUtH2d3a1nW+yGcDXMDckyEKGzexF/p2quN841V8j06HhS2HtLi
ExOT7+P8a5Ooy/IPOP+t10iLGws2f8c5I/3OKzsmzh62pLiHSG9/+a0P/0lY
hl9f4chXE7kX52P7Vqj33lkAhlzHUUMpMls/EUYyD4pdcP6rvwdTQ8Xa53G+
s502pZ+B89UzSyX2D+PcX74/r1aUxeYE7VuUUCOcD2UVqxv4sNjnj/tLRge2
vFtgM3P7DYPHTJwvgzffYViEm3tefs5Y/f9j/4iG2K/mOCeqCVM5HuP+zHhe
JBDTivPf+/HMXwDaW3z+WrLqYtofnB+PTRfZzuKcfa5JZykvypf/46gJNYku
pMcZprOd2UUyW2+Ec3xK0Zk48w8VcLb14rwiR2/2hOAsm2WXFNsRAec/hwZ3
XenA9/+6gH5bxwLOKuXPLmuj+vUv9wTPS8Xr4vy3n6G6eU+MbMfZ0PCDDdkV
52hp1vf5xzjrhL9zP/8D51/yo9OpMzjbVEhe6pBYZPPQCaulq/Yh+1+sywyj
zbL1ckTqPl+MBIXNxqVmpxP1cf6rP+GybXGXnHA+3Pa5uTsU53iS2RrDdzh3
cvUcetWF8xJQZOpysdh8VMxQU0QG51yy7cUxI5x5qr0Kv7nj7Jh2kxlzm8Xu
N+R0jkgUfcb7j9Waje2jkzhzqB9MEJNaZPPEjrqje5Ge3oeRQwkTuH//6L4R
Z8xLZXOT6urXUbI4D99O/dBpgLPQEh7198fwz3PLyayxv43zopk+jTMd51lf
p6bXv3F2vXZ0Y05VFmCvFAT8pAjY/9Vn1eCtHKW34h4BC00vtn16ogbMZ1e9
4jhPwP6vPqmFT9tDLs/Z4yzJ5/s0o5P1v/6/DMLEpp0fSP39/7YycPD/Vp2o
jbNS032tHBvE7fwL9tQSOB/a2y6+hoilER1rRYd+sPnvee+alz8YuzwnYDuq
Dq4yzWhkr+f/6tFmOD0cf3XrHpxZg6EPT1BYcFjRekDi+W9whjm9iFJ8ve6c
t1lcKTi/dnhkqNiMc/RdEcusRQL2f/VAHRx/v3QdjwIBo6nt8Mt7UM+e/+/1
lCSp0usSRDaHSXgWf96Os3dM0VcG4GwruPyLqgXOu+/afDrrQsTiTtw+nFpa
y35+F3FXqXVv6tn89/z690YKwZ5XCWy+Gjsm6ZBEwFausngUntrOXp+j/SvJ
/4+9+w6KYvkbRs8SBEQQUAGJgkhGkiBB6BUkCSZAlCCKCiZAFEQUUIKSERAD
ImIiKKCgJBEkKkrOOSM5590l3v295+x8veepW6du1XvreevW8+enZqZ3Zrrn
Oz0z3d/l9enGzFn17uRyTQ9W33/1n3rQkxTRGZE94KIOoYYDNuD0+EBLlql1
dNLLNsDQrBk7n5Tz/YiTRv+IF1h6e+UAxwew5IiDUFYNWOtcoujYKNi8c0BK
gA6H/+v5pw3VajooDeykwmxhT8uTfYYKr67/oHVjeit2PJTl98bdDulxw/Yq
wqeHLUTAkxaaPlflwW8jdvH7aIBPlDNkPzkI3kQzbpxoCi5QrZ78Rq4f4+fp
2qIqrVh9vE+fv7mdrh3zX/XZh8ouxwtUeVNhlroeF9bxAvzgVixu7AsV/lMC
OQa49mHHU1PBLsxd+BvzX/2XPlSu9JD+dj+lf9OHdk/mlntLwPKBkQ+3C45T
4VnUB82E535j9fvX/eY3qpiaf2CxAxzJ3RidpwM+r52RKGgP3nNzi9OTxnW0
vJJl1XmjC6tvSnswGtmxRzYQjKuurGtMBLNmac2n/QKTompkNDrAfXdOXfk1
BS4/OxpvRIPDnKZzs6+DA4enPF+73OuaO0/e37Vp5bsswr3/iEe9SPjZlrRm
flifjzdEYlkUzPFywxt+OTCrkOd2TVUwYxwpzEYLTC3mxBBgCF5JHL+bfBy8
IG1LqLYCT6V2O8xdwOHvJi5IG830YO3hWP3eioDC3n/Es0FUsV3xoYg7FeZc
VenGrHBwssUuLv0EcLQ7n0VbLvl8PVH+UCU6iB3/13nvxCydIcyTWSk04rYD
WP3/db8ZQHt+q9YGFlHuVwPImD8T58AGyzM9qDcW7gWPDjUQGMyp8HKCPB2C
W4ax8ijvDyqPX4+5JAZeD3OWENEFy1e4ZPbZgGvK6Wgtktax9w+abyts2qmo
8K+W4zuJQb+x9kVpfw8ypk30/MEbG87KVLwG359tYDyaA9Y14ew3qAJ/miBa
hHeCefza6pvG/9h+R64B7wp4KvtFsTUTDk95X9Po0KuzS5oKc/wrTWXbY+T4
efRH29vlfux8U5ZX39kWNc8H27M5vtorugtsbC3ZaCYFfmyUeT1YAdystZ81
XxW8XbHiw8x+sIXICQNhffALzr5h06PgbgZ734ATYMElws5cK/C5Me/CSRsc
3uJQIZ0FRz/WHiM8ImsG6sF4UR+cZtAAZsr7qJ3PwhoM7lJhdt6iyZ0RBv4R
Mnea/w2YgyEuzi/tP/lpjktOG49i50uMaY/kU40xzD/aI6T7DUew9vXX+PQR
pBmhqh3auY4oHn0ve/HxNlhOdyhQj3kPWLvgg0fyEfB9hdrPBleo8IfjLHwe
Bo5h5VPe96xQ652+uAP8erazCqmAdfqcNDiNwKO1jB8nL4PjTpCf3jPg/VHX
HQfF/7yPoN5Urn3LeAhrz5T2Hjy7Eml9B5zhp55U/RDcxXvnm3oCmP5zXnVS
Dphj5+bkm+XgKF209qkZzG939ej4b/CbsJdvRKbBIhnV82dWwEmt6zrPGXCY
ZdZknjVuxeEp7/d4eTIttslQYbZW15bZawiOP91AbXaJCu/9++WtN5YjWH3O
Pi03OXRy+B/9s2HkvbVmfJoLyp8XtXiczQ+2VRtU9xYGtxy+NnhQAnzw7MqD
LbLg3Bt+ezsUwdIB7D2xauCX0S/87feD2VLF5JR0wd7Faa1rhuC5Jg3vn0Zg
m9FSibCT4KZVk/qTVmA9th43wfM4/PLqdtNbKsPY9XKvYenooVYw7XWD/bzO
I//ov00ih8j3PJedqTAnKjA6uHqDB6suFviGgYUu/2J/HAO2ohOzeZsMjnrl
l/XpKxWe61KxXvmXCez8b7f+9vrnzUnMigrUx/mlpjBLr/oHvHswjl0fmo/Y
xkRtJ9DE1OJms9J1RLEYgZWbkRaW35M8elRLCFwQt+n4E2XwikCp2chhsErU
fat95PvBi21vn8zSTmO/R3k/yOm8FOQsD770mTnRVQecM73jl7s5mFlmz6Cn
A9gvmEU2ohzeN2oI8rAM42C5ysruexv4qfBFmj5jv8NHsevzyk7mDfkGY5gp
13OGuOiBWg9wQulnTZMH4KhLGvubY8DBjGXIPAV89/1xjc588A2T9Z+vy8Ft
Tim5Po1gjYjTn2y6wW8/b47XHQHT1+VHic+B7WauhjKtgmtYd9yb2IDDrChb
41rNisNT3kdzR/VFs5Hri+IGWvrTL1XAD65KCkofA+u1Hfn99SIV/tCN2i8a
0+NYe3lW8iNrBx+Ysr7VPtvXD7bD71ny3C9W4webL70dGBYCn2wton8iCjb9
0iuuJQU2eUplOC0LNnIRcHihCD56XCPsoCr48J5TnwkaYMMt7g2xWuCDs1GL
x/TAerXZXOuGYJ3UFtXkY2DtUIKlmSlYy4Hj7gYLHN5VtsD2VuoYdj0bvzrm
7rZnHLOiVsKRq+nggQMqRz7LTmCmvN//3u/NtceJCix6+srFO3/4slpedAC4
+AMnW+2jPzw9d47uFbhIoSZTJekPuyQzOmSCC7P9Ld8UUuHdCyuWj9dNY/V3
XqRDkMg1gzmRm11Dyhx8y/TVp6fn4HqlfE/As+fd+/ptHfu+gL5R+8xNgQXS
3+I52GD9HYdOJnOLghdbJ9KWlMEVtj45bQfBb+a4ir9agl09P5ZFka93Vt9O
E66kGWx/XEeaL67OgCnvn9s3nDMKEQGzI8GkK0pg/ZvdNAd1wJ4pLyzFTMFZ
QxYZG2zBLKzoqtcreL/NkTwrzlkJ5teL708mgbfMJh8R3EKFj/KmTWe7N4nF
l8ALGZP5W6cwU+KT02GvpmV3sE/alW/6geAILtPYp0/Bbz3wQQOx4LQ+iesK
n8HfdbeZeeWDP9wUNr1bCtb7er71Ri3490qspV0r+A4a6D7bC+b23nXObASc
+d1m8MgM+Bh9/CUdEnhcf3B8Hw6H2T9YxFGBEbyz2nZOnI3yvDeN0liKMq5I
U2H2Ee6kMsODjVSJBjrGYKGjW54qkOtHRKVK7dw+aM9rPu33uwPAPW/ow6Ya
4X5H2Z7wPDvyMDf8vt+Gz+Gs/GDOa4mBdYLghPY3Po92gffqPHc3FQf/TI24
wSWNw0+fFVA1tpnCrvdrvriEs2VgUsMMYzbnNOZt2aOqtLpgBl4b17wb0/94
nzCLPOr3p7vfoMJsfryaS+IOeG+zpUezL3ir2WjvvVDwTNtNHflIcJUlXVL3
K3BS18PNIe/B/md2OKt+Btv0fWgZ+grWPK+m/riY3L/OV/9dmziLnd+tFlWW
tW3g3E9yn1IY5qD/wRv4yEoB/NG37yazFVh+SKqzSWEWu57phF996HQCU76P
BVLbNz9+vo59L7MgkkSbisBSk76uHKPgtZmA80kMsP2QXU2wAS+4/561m7Qk
WJ3Wp22XCvipT6wKvy54mrokkuM4+KD3EIHlHPgtjvEE/TXy+TrVSe3vOYft
/9NtvAk+H8BMVeYGd9vAlO8bU4U/IhJ3gpnManTrZcBi023Ly2rgA34DKcJ6
YGv+6XOHTMAeGUucLmfAUYZ0FTF2YC758z3jL+H7iizVISeOIrBeleIGfP8f
yw+HVuyhge3VMmie6G+lwlfJj1V9UJ7B4pttdN6lVTswJT5+DA148dQZ3Kh1
5ufOu+AVgtJMSgB4ZzIzz75H4INn+g/8igFf25rjYPIeHPkrPLInDZzvfrHI
Lg9MQ0c6p/ATzDBzz9OnEszcyfqivv6P+0dpdPbONjBnhliTUw+Y93X6bPEg
WDAEv3nrBFjkVoXk+TmwpM1JvXQSWPZY/3laKhxmRXVHLxNyf47y/ZKPyt3j
kgR8zzwvOZ1/TAWcZHqeWlUPPOvVckDoBFj1g6HfRnK8fPHk5HGLzXB9znJ/
2DhwAKz7ElfgcBtcjuiVJ55Bf8C1dllUsRF85Z3sjyKaeaz9TuuynV2XAN8Y
mllTMwJTxiO2vML/9iS3N4o350hSl+SCdRo5BJnawB5TOPxRArjtnkvKwY1Q
3iLbuMYEF1jywxsV1V1gg9ggsTgZ8JXnzpysquCgh6c2uB0AJwXoLAwcBpd7
yvQfNQOP3eSqzzkHZrqKKxIh90+az13UJ22bw9q7r4d8zF5lMOV6KXm09bq3
C5gQvt/26Z0/ru9QB/NkX/DJ4OeHCx+AAwJ+af7n/zEozvZdUBqLAY/6CElS
JYC5vY4IbEsBG9xx3yKRBd8jlc6d0i8WAUvYnOdlkgfzX7gyZaQOZrt0vShK
D0x35dbjPmMw0c7zosRp8LiDn9r1y1T4/ZPf90gtQLznzDA6vrxtHvOEW8+N
MiVwsabDk2cnwMerk8ZG7sP2We9CufySwNu9nbSFa8F/PR9/RD3pg/z3HHCY
/dKPRqQHgXenf6UfeIfDewpPL+K2psL/Aeu0ahoWfMbMcbHowRO7DMzPZE6d
CuZ4hTnlaAA9w/U4zD+uZXzyqUyE/K53qcvS7eKQd2Opy7tLlN+PQcq2PZbf
g8Dvg15Vvt+BwzOlC26tTF9Eg08V2edP/kaxO4482rCFgLmD+vF84sTC3/kC
+rDvq8rsog5lQr9R35V+BxN9Arb8i5Ii16GHYMp4wC8KBLpw+z5sPvwIzyy/
P0s/MqrkNe9XJmK/t0U8aGeyGbjhHmnc6Tb4Sc+FTLXn4FyXfg7BdLBfqYRj
/U+wEe+10vvtYL6rWULKU+DhwlW3UWoS5rStBxqjOcDD+/w3BNTA8Shw8KiX
0BIxU+bLby6Kl50e6sHcOVjXPGbah/A8pVvMJUnY+gVPxq1aFMF4dtZEU/wf
y0MUFhoOghHjCbzxcXDevdtBtafBGlQxTUcug7+5FQpWOYPVCf12hnfBudcZ
vpQFgPdNStLoPwJT5s9blEUft+gAH7K2crPa2YsZsdjIaa71Ile2mNSE6Tn0
kZdZP2jvEBK1vjGB81rATPmezbH6kvPh7mEkSUVUVDRcRNN6ianfvIbR2cTk
5NFEMLd9hgXj0h/Ll8/E1WxcxMqjO3aRR9uGgPlgszVzyEswpb2takhdqnw6
iEifbBi9qmG5LvsmalUS+PH1z0uzQkTMlPp7ONy0Mv5rEHPoUoBUz+FhbPxd
76FLeNzWZWSjwuDa0TeL2Ltd+5tESMgq1OvIqN0c5o2MwanlgjNI4X/lLyBh
z2+JIa7XXkuCa93TGx5rLyEhvoOC8gegvBS03HHtwQxmyvgfTiWJQx4uJLTI
OLN5Q9I8trwgXnyUYR0cqNF6+oHBAuahB+oP5VnnsP2hxOs5zV6dllUSNp6k
8Ue9mwovCdl0815kOwzlqdmuhDMMwPFR1q+5dJFA+3oJ0ZoH3KyOmUMmTByG
jNeWUG+vwdkSunnMx1nTwjjOgSnj+dllGZ/t8yEhlURWJSqbRax8o2CX5P2h
4MsOHUI+2WCvqMT1ux1gBjHNqpur4NCM1uir/ATMhnxGC3I0C9jxD3fG6n02
AFPaawIzW//FNPAdnm6mTbpL2PiKn2euf7y+g4SWTnb9CKCG33s9qiEtuReM
M3rMeTEEzn+SSfUJ10owpbyxTIMNKelLiLozR1zh7gJ2fnQzjA3dv4BN2/DL
X8fAWx3fjZdxL2KOs/awTq9axI4nn1m9cnoC3Ja9oizNTMC8YJMbe0kKTLl+
MqerHOXkwNrSogdUIsEftEY/yJPA49q33rOZLGHjuX0d1ZmZWojoMTPhBXc2
nH/+bS9F2srACby6Kc86wLLCU3vNJsHZkk8LuKiImDUVkH4LG7hcdaj26U5w
vo7FtscasH3MIbba0yfAHiY/gyUcwZYWHnoL/mDVswq0Ba/BlOMZ8KP5vHoH
jq9BwVm2uwj8vbv/Y8GGZeSf1mgnZ0DA6sP/QmSKpfUf5rGY9bv5h6v5FNNC
/rBPz82ut2BEW4bP+wJOjRvnePELLKS7ecKtBRwxLFdsPgymCzR5pkIEu0je
vMrFQMQ8XPFMm8AJNnPI5WkSBSucdFSlKYT5IfJJA5fHq8Fya+bPG7vAssdq
yvMmwDKx2isJK2BpwlepcCYiZqmDsqduc4MlXsSFnBMHU+LvKfaDzq5hS5iJ
Yu7ME7/AEehjvDUO1s+aq6Nd3wOuYYllqLBZRq2qV14hUyL6oUW8Y+NajlYv
XMy6c5+IZoeuD7vcrkRvC1M0vMjt8fvOK/GFBiVor3V9DC+5fVmLG82tG5Ri
4+c7v+Ttj+upQXK2w57KDONY/qO7iVVXitmHsPxElO85rhGmZaENdcgAR3QW
u7P4dz6bUqw/dGzzJ5WGhXLUZaZ/JsKdiC1/m0lDw1ACLpFn5WReA1PGe9Bm
SW27m9mGuidoc3fd/o3lyymZmLh1sLnn7/3rwuYTGE1zBnO7dCHVnz5F5bOz
6NhNWabfn1qx8cmn9Ro03r1uRXyHdDMDfs2j2l8Jes0WrUgi9+TpnSzzSJwx
kqHEphG7H13gv8y5TNuK7Fv2ayBVyv2/GYvve/QfNIzGtCCbK692680uYssp
xz//XeatlU0LsrZ2dhyyIGLL6T68sY8IAy+m2Xl8yAa7sxlFGLeCqa/ufU8i
gv0rePNfcpEwqxJ/WPSkdmL9Hcr4G1GhJztdUvqRz1GRYi3mUWz5r9NH9S1H
KPXZj9WnJX7L6Zkvv5HACQmjhbZZtHSVL+53QS92/mj57n2evdmLjlfOdcoq
zaGz/+v5rAcRIt+8rvGYR8jp3g0npl5kPMPHLPNoHlt+Id4zMq1wEXMB5+mM
PHECZsr52l/4e49LTi9KubNh8LY8EVuuK5fvUn0C3PX7Jr2wB9jliWyk6xtw
2FnbQ0o5YC0uRb/YWvBiJU0h+zD4vU/dkuca2FLl9Z6prSTMlPF07HmuTYyj
w+jW7dCPh/hbsP7VU/39jaqcg9B/OxPPesK3/+/7zwg2n+WpOn2oueoI4mDw
YZLXnMDW/xjW+mAtegxbn9IfkzUc++rmOYyN178rxBrFe2cUqefT3rJunEV+
UfFHvdoGsfoZoB2VYbYZROYKc1cec8whu+mrvScnBrDx3Xe2ONQI049i7Tv0
gUxWIMsQ4r1AzZvLsYCt/8z5/LMNHxcxf14R3MJFS8BMqa+nuPb8TdcGUXNQ
SfYdRMSWy2w7/aHKEuwfQ3jFfxvcIxr2yOEp+FmBzEBRCtjzQ8+P04XgC1Hh
8St14MN+mn7P+sGKznMXlBbBPNaxevX0JMzUh4+LO24H007JhNYlErHzvVMk
MpwqA6x5iurR7nyw9aOLTyxLwZ7lNZGB9eCX1CrPv3SC81RevxgcAnc6Mr7a
OgteSbj2RnMFzNPdGuu4gYRZlUMzIYYVbHYo8X0FN9j1HnvykjD4ac7tj2Iy
4MzZvlRTFXCjuEHaPS3w/Jm0jM+HwFsieb70nADLV/t8ZTkLPrZhPHefHdhR
3ST/sgs41Dm3MNIT/DFJ+HtJILiyL7hk/hGYkk/R0djWUurZEOaEPU7XohSH
MXdt8/RlqANvIwQ/d3GA7Y/qfIy/xjSK2arNaVX9PdjOQcVko+4YIqR+fIMb
r/t7PPQkoowfPaV5XU21exK737RF8gxVFoyjqi5+rzCR33/PJxyH+W0s7Soa
TtPI4250fg3fKLacEj+v3mo7nMczhc3XesSyqG6Im0QrpCPV/tJT/yhvBvX1
dKUm9E2gL5LLHy0uz2DLmz1/H5kpnsUc+fFhq3rpHGbK9fyL8UGV9MAU8hU7
fcOJ/LzEhRd4K946hm6EOs9dFJ9HIl3TBQ43R1Fv14YHbjWU+c5jiDvTequV
9hx2PijPO5utN51Z2z6Nvnk9qJsyWsTWd+xjK4x7/4cHP5yqmgWb0Eup31Ai
YC42aPG+fnQBK7+P98jT69VgyvPBUe/iwLyZSSyeqBdy8hdHjGO+eKR+kqZq
AjnnuueOVRCw438w5SA5Mgx+J2QdNUhLxFx03Jixfwe401/btXcfmJCzd6jr
JJhtSty0wxksJcT7ozUM/IDgFFj2HixiND+5Kw2cl+xs7JULNqVfyOr4AZ60
vsGrXA32zV3wjGgB83O6DEz2gjOvLeofHAMfrnD5GDcPHhQhsOPWwHe8bt60
JMc7ijk6CO1ZrOCPSq74LdxgnXBirMNOcNeYK2OZFNhFh2S/SwnM8vpWnScC
xy+TlDr0wBqmt5/vNQI3pS6tP7QAOzC5nZ88D95gu/xL3wEcU+AmHXcTvJdn
JZzKC1x9w33RIhAst+eMQ1DZItaePig9Fdi2BhZXqaqJkSNgjlOj8xazAQtq
7FP4HAmmPO986WrZ7j0+AZZdm7QqmEIczXvvHLxY83f/aRal2Y1rDnl1Y6aM
N50005JdcJhBVg8C9m66SBnPNo26S1r06dXGsPUp93fXCVcFmY5p8vN7adf3
XVPYcsr9vmOWGNg9NY0K813SNv+cxcq7aH9aVvfdHGbZTbOP922fwbanxAce
1yXj0aRZ7H5/MvtMsJbgDBIoUXO4ZzGPbd/peDbUYwH8WZt7l82VBcyb68vy
eWTnsPIp8eJl/rJelOws1h/2uGVucrBzGrMESxg9E3k/ol4Fq0a1Q3nreOkt
bRKLmM/3Vo5tvw2+J7tZK6sEvBqZTh+2CHbBmVdcFCFgnrq0HrbfFHypLvY4
ty+4jS5Tp5x1Afafu9XY5Q6YEo8OEFWY1ZanMYu/m7TxvDCLxSOOEkNuVv0Z
zHSCfbbi7TMox53NNCsDfm+nV8We/Epw0H2/LT8HwHMBmrNVq2CLB6s1TduI
mIsffknpkgZLPnV6MKgNjni+237yFHj55YjB4g3wudhYibUQcNm704wb4sGk
y2WfglLAj0+I7X+UBZY74FsTnQ+ulO0/HfcTfIlPc+pDNZhu46s7mc3g14ur
zPndYPXfFi9+DoFbq7OlaqbAN3I5c1sIYLb3Nwx618EfHte3jZDjG8X63nKX
ZzeDBxxCSUucYC+LCX+aHWA+PQOuTWLgL3veJ2yVBZsI0u/lUwZPMduU7MKD
g5aKju/WA6dy+gc/mVjE2k9xRUkCJzcBc7MXXXGkDnhU6UDXdifw6pg3Keol
mBJvzssfkssqmcacd6+wKP7NDOZA2sHLJS6w/l06wbKTWnOIMv9o4E5x6DP3
OTRhonn83tOqv9/3z6FoA56NUr6dmCnPhwJad1WCyPdp7fTT+3ak/v77eXAe
e14xOxonF3B5Drlv7LweMT2CbS/erlxz6c0wtj6l/1PxCm9w+8U82nbbhz9l
aAJbnxLvNm4yfHe4dB7tCTndvnxnGls+bu6xPp81gznCnuC5u3gKK58SDy8E
W06qic2j+y8PMsd/msXWF7UyO2Z1ew6zpo7xKJ/oDLY9JR4SRNWsBFfnsXhY
MjjzRtR8Hm3letAaLTSPbX/5aoXUbAp4h/CFW35CC5jtzifpB/iDI4fWbjtT
z2G/l67VHiGRAqbEy5NUp7osN4JxXJWWAnELWLy8YnH2vdM28n65p2726ofy
mw17L7OJL2Ie5mUveW0PJo5rCsp/Bq99q0kW7APT9//q92UiYN68sZB3fA+Y
Uzbb5JgVeIfpp+BMP7CY+/vvPJ/AKvPGxFDxBez4cjM0/bT8wZT4uenM8tdv
mXOYPXyeZ3IMzmPx06aT+/E7pznMDn6FjZmT4JtyFzl+XJpHX5Tmdbb8gt8X
9n6W2NkBDqvUYHk3A17h6r92fQMR88XzAY37eMANKbtV6GXB+OX66NoD4GSd
W1TRZmCuh/znbR3APp3FP2V9wFNilySXn4KZHe1jv78HE5x9hrNSwb23nkkl
ZYHL76Q4xuSBM3x+pIf/AL/0byfeqwD7h8zsc60HX39I73WlDWzxlO+HVS9Y
O1qB0WgYvPu1/iHtqT+OL/50uPIiGJd0o1FyFTyWErRdgJYE5y/99Sl2JnBe
dtZrOnbwIvOQv3z9ItYeHt7yLn1FAu8e4Nu4eQcBc9nR7IMeOmCbXJOgMTsw
ldh0uVkEmBL/wgf3e75Zm8NMV4B7fCEDlt/UHQq7d3IBm1/5kVpOqJ+LiJKT
9a56Zjb//f6FgAhCSoHrjn1/vx9YwJ73+O8sJAgZErD+XWSudekZs0V0O9dB
xV59CFufEi+T7Z7tMScQsPepG+0PHIl0X0QCE6lH1+THsPUp8fL6t4HQY/RE
7Hkx4FbrSDH1IkrDVT8IcpzE1qfET+MmDQuOaAL2/Gil7HKdc3oRPVvQrrP2
nsbWPzNo/3UyfAbz4bgWxp4XU9jxUuJpkIZAWiL5uY7y/uj78Xnv8auLKOyX
b9vJa7PY9laPBMfw0nOYZ6zGEKkCfKWSeiakcQYrnxJvv4d5zz9qX8Qsd4rt
S4IFEYu/NeI5BQGNiyhqUDnozKF5rLzxbTnzWSXgPZl+WgHCC5il603V+NzB
H1nftC1pzGG/35kbEVVWC6bE21lp6boT64tYvF1cOrdd/Bl5/2RifzrXQXnV
OyaNjJgXMW9kV+6S0QPr0HhfYvYBe8+Xz49+A+vSEezMf4OtUjji+zcQMN8w
U+p2kAAH05hykQ6B3364ccznGjj7xONA5sfgxyPPX8ywLWDHJyNBfH7tLLj0
sknUzGcwJf76b3nqdJuwgFn3gwN1Pfk+QbHYg4rNqjkELP4mj2RK23EvYiZ0
t67z3QRrNq3UVteDQyoEYr1kCWg20UOGKQv2N8Q+KrP/F1hMNks9rw1cPFv/
/ek42Cpj2uDaGph0k7n+ICsR8yNVCXNhIbDMqk7vqgK4LP/cxWZtsI2351Tq
CTCV9guXwEvgKPqvq+fcwIplTffUQ8DVwXNMnC/B2dP0J8WTwGYVsxM7PoFJ
CZ0+XFngZz6/trN+A6ucTkuhLwa3qsZor/8C3+IIaF+sAm+fdbo22fDH71da
0Q+2/fH77/VfdPaA3x6qzUj7uYjVf8NrhRirYTDd4mNfRkYCZqWDRId0cfDF
GPMTpw+Co2Zz0cYr4HIdAbGMIPBKlBfrmWQwJf7qiGgIhJMWMPNd3V7Cc38R
83zWvF08K6xfN3rovX8oAfWqns4OnSnGvt+KGG0qZD5fj1I/VeTXTpMQq+VT
p+4f7UhGuyt3o9ISGooJpR6p7UXPEnM22B9eQoUqskmXfQdQ0jx15Sa0hPoc
1A+go6Oo5qBSrNb4Enofmu86QDeCPHclyr1gWkIV1Umn6V9Po6JR+pNO7kuI
VaHUXoVqBilF858YX11CdQJ39bvkphHOQvSz1gAJnfd6YPyjeBZF9GQe1lYj
n3fbAZZnVuTngFYibxK5n5Spee0x/6451PE2++GtG+TrSe7IkTufyP0mmhKd
/nsEdOP9hT62R7Oot8H1U+mDJaQhsevxdMssKjmxO9WZvH/I8F1xovYsSgg7
ESIqvIRkz6d5BD+cR0HX5Y3XyfG/+iuzScu1eXTvzOJo1RQBnX54b6aH3C8+
zOH3JjyYgHZdu/9lI80Cyogx6+Yg11t3p3tQ3b4FtNv1SEVyNgGt5bu7Sbxa
QFr1IrN3XAmIddYnvnEZxk8UK9p/Tbeax0wZrzcnnWM9UwjO7uiXrrq6hBpy
fCT2eC+ibcLjk1rk+ju6QM976dwiKojT8ttJRURiDEXMP0cX0CUGvQI2SwI6
s43Ym7t1ETlf/GyzkxzXIoV2Z37WWER3f/EyKVYRkK3OkWoS+fl/9obrAwt1
AnK/wKk/SI5T0lUbV4+fI6CH/t1FdWuL6KLIiytHAwjo3fuEffn/ef66I9N2
MIWA8suuZiYpkY+7qVBPu5FAbhdxu6ssCCg4NkrZm1w/W6Wmn4n5kOPkviTD
FTcCCv2gSueTSL6vNuaccSH3Q4yqy849Jd8nOPGmOyZ2E9EB7saE/fLk/uV5
lnjaUQL6ypy9aroE4yv6tNzD90jBeATKeDLbcRZTsTvgFQ0fh84VElKaPinz
WY6ItmwWiqxoIaDGtql0J00iMr4aG0hdREDOP3xVFY2JKKJaxEM5iYC2pPIV
LJ4jonqZ91cdHhHQp6h07S/O5O3DJM/GepDP932D8lv3icho+oNJmy0BTV7t
O6r2hIgeHpXVZT1KQCHmt5pWyM//tamfVXRUCOgO96BDD7n/e7wshvt0NwFZ
LBxVLtlHRII36p+EkNuTck0OLlmPiCYEGLbkrhPQtiSR8nATIvpSti90dDMR
zd4Pf3TzDBHdu3GNafsOIrIoaC5gLyRv950QeUSXgLL3nju6q5Z833VpTJU8
RUCcKZPde3sJSEo87Rc9+Tn4hsjtqwfJ/fW49rCe3/4EVP+Cbt0SR0QCDxyI
+TEEJLct/MFVNiKKxBuyRqeT6yeYl99bkIjY58TFXMsISP44fyJDDozv2BrW
5tlaDl4se3IisQPcQme8220C/BW/mc5wDRztVt7Ou5mI+U6m3+cJATDle3vz
mQSZB/vBblo77RoCwS/SayZ31oMl2PVPft8C3/OzrhYWnjdZQmrKMkWPh9pR
XzYDbrBxBRVcrJve/aIPPem9fpPZfhVZjijllV7tRTRHWlo4X62gWy1PX2j9
7sfyG1Lmm/PXWn4SGlhG55uDns/OjiA1HPNGpf2r6MDkAZOYnSNIMzDKQDl9
BflPy77YGjCBjX8gyvSJ87+fQEHUZx0J8qso5VnwpkX1SZR/QtdeJnIV0RXx
DETjJpB60eX3LIUrWH+zm3mXncfwEjK5FXPMO3EaK+9eVRzzL7sZzFvEkYe9
xzS2v5T5SPtSGWJstcAN81LJm0dWsP6nVouSOl3REhK+S8X24P0sVh6n5IsL
TyVh/FX10wnTXaqzWPmU+QPaL7wa3VnASyoZBlrPVrD+ZnTo2hpH+hJa7Mx6
9SoNxmsZ0G6s3L8GDvEJzPmoCeORsmtYzUsd5pFur+ibq1tXUZhugNVU4Dxy
VfYy/qK6imzzcOe2JcyT7ytttDjrVaSuePuCWvE8ahtUyNT3W0WKm91Hj9OR
n2uCGKdo7q+gTC6x0oD/fJ9xk+nHZ66gvUINCd/I/d/hy8dbPYZWsP6pYCAP
f1Y2jCfbNnSYLnXrMrI0fOWcrw/jo7ikLzv5XwXXM++5fuwxOHRy1ZE7B9xz
maYT3wa2wUsX5hDAo9tOxCltg/E1DmOeAZ/kwa1Jk83S/ZD/dBNvvXH4RsjP
iYKzqudlwZT4p5ktmX+pH/K/Wn8Z61GVheVbzOV8P90Ee/J+G3qWBZ7o0tP3
Jqwg86s/5yaoM7D8Rn+dn0x0u8HTOcZjDak9++oWfq0R5deK+x+sWEeWCXc7
/V/Vo1elGoOSu9dRQN+ZhFyhTsRiycTq1LiO8LRGj9qMu5C+aNBwJD8VHldz
wkKL3L/QOySk99JqHZ2S8229o9aL/R4lf0hZ+GwXdQJY/Sc6LGSxjngPrxx9
tn8AW59yvb6yOXnldDG48O1gycUjkM9SOV5HS4R+FdF8PNsl8XAUy4+aVpoV
U1wwjJVHma//8Jut/YtkcNfyPdNvwjD/371Z+FZ0MOST5Csciu0IWUUPDVcy
tu+YxMqvHqllOb5pAiufMv84b4vSdtfL4MNifB9bmsAf86dG/ORgvnNxrd8O
t/uQn7FV8NPjeYZVzM73ZlQ3ka+HB3YhQhPbIP/zbX2fZXaFaez3KfHhnb07
A40peDnCTrYsGXy09+2MMhXMn6Q/z09zTQucNxi59b0v5C98+O6NNPu5VdTs
GCSaHAz5pofPO949NQc25nG7KnpkDvOxMufxyyqz2P5R4kuFbeOlylvgczMD
wS+/gTfGGNRFrIH1Fjk+8yrA/Crfw33hcRcgX16Bbts4qyDkvyY8enYl9uIq
2lJ40+KW2zy2P7LJP1tWs8CB/RF2tDPgc4mPsjyEIf9uTTvNPhk2yBfmmJX3
drM2mNKfOyCm7pFwDZy6rBqpGgvmq1ZOq2wCX+Fi2JVNC/NLuGxZuQYlwT/S
uJi2GIOv4wTX0O11LJ4F/rDc68q3ijnebcOYiyG4SC415oYbuHPIzMg5kXw9
WLwxDToN+YN9Xi7NEtzAJr+NQs9HgoVFkyRr08Gl416xTFVg12sxXcr9YNHF
r1y2S+DG281GEeTnFIrvrc8FF4iAlbMnVpOaF9C6tMOq1voash21WuzpW0AF
99nXvFjW0SOemsltkwvIqzNzLZ9vHRUZ7h86SH4u0lS0WF+VWkfTHp+779Iu
IpqQ9XW1feuIL2VnS/rmRfS9/y3VbYN1ZNDzqGaE/Bx+f58e7ov5OnJl21DK
L7KIdB6N4xYvraN4zZuFxnKLiH48jHrPrXVU7zSc7b9vEf3SUqS57r+O4rp4
tufJZCEtx9mDeTw4fKfjy0FSezZSv8UjXK+Mw2+j2Zmu6J+LlLwPrA4dx+Fz
rR7JP9f6jIzFBA1lBqnwxmoFJ2cXytBKdHetb9I6Utc8cuH87XIsf56pSnCb
740ybL7OX/GsDJncYZ1mKgY3UqV+u75Ahbenx3Ul3Wv6R77IBiRgGvQ7JYyS
H6YBtQ4e2lXyHSwlsGcTYz/47gnuOQMayO+1fObE5dJ3lHjXhTaykzTVyPFc
lPHh87i8Luz3QvKkutqFO7D9/ev9Wgfin1D2fe8MFkHnuaSiwDLhoYkf88GB
cqJHOVvAR/nefQicBHMyijOt0UJ+qyP8cTdPx65j400cYhZnrJio8HvvJ9fJ
C/7G9o/6YLJdiVMvtn+U+0sfx3Umohv4AbV3a0YkWHUyPMEpAxzir6T6pQLc
JMaxabwTLFC60CkwBb50qTHFmAqHOY0xw8uPDfIvrUkI+DMPrKOq1l6FD26D
2P5q0l2/7OI1gO0v5f72ZrpBo8MVPL/+9mpcKFh3s9Mrh3jwM37N2r3fwALb
2JMrK8EOXVdJju3gbwmVOltHwJuuST7KWgRbqAb0mpPPP8WJNEO719ggPw99
msYx+zi4/xocC7y6YQr8izBacoSXCs8ZxrA1omAUO14B4aSQn9Qj2PFS7rdS
h3vlhu+CzVg0Dx54CPatenP2VSw4/QGN20om2PEQT6zdT3BiqW7RpTpwv7Zz
j20nmL/o1dq5YfBJjUpe6zlw+FeSqtUauFxJxMyCEYeZNs3o5smtkF+FY8yt
37cC+gv2ttefEmmo8IYnO5LC5Sax4/fTPn28avcUZkeXnsYbiePY+Whe2Dfx
48gEZkr/gFDw4qWFK/hOgrK+vB+Y7kH9LMMTcIizQ3R3LHirBaNOZho4en/s
VHAROJW6jEa9Amy58XkUfyOYgd1OjqoLnL5d/VfvIPiMIMvp4ikwk3j3QiwR
nCWbGuyLw2E+q+y18+JGMAve6Kv+FshXkTrYVIr7BP2h5sRFU6se8N29TNc7
6anw13Wog527Id+y/S6/UGsNyK9bVURy7zo2jZ3PizuYHzGEgSn9HSnf+LxX
buD0vt8nvP3A+5DgzLkIcPFzq0Dtl2AD4vOdokngOpPWXIYssPknDtPRIvBq
UE95Shn4WFKNVkUtOLasIGe4BUwYSVWg6/nj9xhfJwkOgWPEwndqTIJndb2e
my+AtS9c23JzBfzM1zooghz/KR6PO0aTuhGM/7HfrYIN8gF8qyih2foG+oNl
0V/nC0vAzXYfB66Oga/zHxtjYYD5+7c2lP+24abCv2OslpH1gnzHi19YDPuL
wb9X6gcmaSH/rFi8tzQeD97dKHKcSmIWqz+eBg2GeRMwpX8osGWtMPY2OPuF
+NCED9hY7PimvSHgic+ecp5PwP7qyaalL8FCv5rd2N+DvxnRvLb4DD7Rubsk
Ngd8LP7V6M8/9ueu3vtPpmXgD6OfXAeqwe3BX5FzI5hRpngDTTt4b215ZXgP
5f49j57rbGNLjob+L/X2bSEPssCXxrYyXqsD13zbet94AsyjF0jFQwvlHZEL
1AhmA/twB7qvku//1EFSd6yvQL5fN6uU0NSH4Hk5+dfr2WApz6EzKT3gp4qX
X/JTL8D9eWy8M2Qn2O7VVd7VA+C/4mceqo+Wq5DfQYmveajHYIlx1gCHFxVz
qCLQf8HyVTz49IlBYT3/H/muqhD/7XrXj/zgw8yGIaf2gO+8+v5600HwBwX1
zJzTOPzN9qdXn9eUY+Vx2949+fVT9X/JDysemsPKwgs+rXe64D/5wyh+jKNx
9FMGl3+NF/iuA8Y5H6ymOg7eKz15R/0cDi+3SZQqNagR+z1HZ9uwTpvm/5KP
1aHO4rEUFzjo9RlctBD4naONPZM0+Ae63Hp7L7iP5ar26H7weqfTJzNDMM8H
V75SU7Cyu0eAsjUOH+rU/sKwtAPbn3nZK18v3O/CTLdtUc6Lt+e/5Cel7Tha
MM4N1rk9G4/bCfbnehTCIflHPtNMRWdJBfCm483meDXw4TnX/ce1wKHh3GKX
DcC1Mrksd43B7FWnFiIswCZ26+3vyOc7RcZHnCekD9tfQ1+VFxtMfv+X/JnX
b7V6pHOBS3uzk3YJgHccjGp9sgt88/NtegYpcBW3heItefAuH7Vzo8pg9zGe
cAsErjdeyavQBkvkdoyrG4I9hb9xpxiBm4Nf6O0wA0sveLiEnwbfO2UVS22L
wxvQz2zg0BiEfKF1FiLvxsHmjK6ry4+H/ms+xhb2xNd/uJvwlaGRF/yc89wF
BiHwib1MJWqi4C0n0oSvSoGrXSx83siBg57Q9DUqgXUzk/CM+8A0TcYv9+0H
5y8sr17VAbtti7V8awDeq2iY03QUPGcyv32jKTjVOdpV3QJs9+hAs+MZsHj6
uGKsDQ5fzJ/Hd4RxFDsfCRVJOe3PwTduba0KFR37L/n29rkcohXZDj7zSq/u
JB/4XpnWqyBB8Lt5DYe8XeAKftV9M+LgaT3FjcK7wVudZFtM5cHKLyTjA5TA
lj9FnHNVwZ4zgppTGuBYHj5WIfL106XhM+L/DvKFibqcvMvAN4k5kCe6/HsI
uItwOej+0uR/yS/W1iefEkS+Pr62cHH4voV8QqZxB228q8Az19zT75DABZtf
aQwLzWCmjDf4eO3ED8PiXGz8gdCTXz2uhAr0tq11P+EFCUXnL+x4uLUafVVt
Dup+S0IZujypLSbVqDaqofHnexKqqsYjgcfVaHipViA1hYSGTthW2TRWo3Xz
6kuRGSRENf1jd9PGGsSRU5HmmUNCm9JPupAkapA0T9nqxUIS4nId+8ZrUIMO
uP3UPfaThIT33aHDX6lBFu3fw1UqSUiWiu3QuaAadF2tqF2wnoT2fX/7yDep
BgU8z9+1sZWE9PyVOt6X16BXy7lXZ7tI6Lhh6c7KsRqUafE1u62fhKxZLa9M
M9WiypwsmuJRErJvmPy8RaoW/ebJOJQ0TUK3I72WlAxr0ZLb56cRiyTka7lV
09yuFrF2pPS6rZDQwx0JAR7BtUh03wfJ89RL6GW/Su2r5FqkHp14w5BhCSW9
q+D6XlGLTFYS8vewLKEvdqfPDI3XosuWcYx8W5fQd9nZhI3MdahGqi/Hnuy/
xlP+n+O3/+I3/+LXf/ur1lvv2RgSop9ztv4d0oB4zq1dLognIbdDLfIO5xqQ
u7eZ8YOPJDSdoEZLUm5Ana/T1SwzSeg89ctGH5YGpFG4WVgij4RaLakTWPrr
0cuey5uIP0joUJaN67PsekRFVTL/g9weCtlK9YVD65G1gGBnRCMJKdlJ8aSc
r0dFGu4/rDtJKKkkdFxFtR7ttGr+IDNAQgKCc9++b65H9zzkn6yOk9AjN9PQ
IwN1qD865E75PAkxNGWfaftah7Rzh22fkevbQ5ZP3iasDsW1ax25QLuEZgI9
aaZt6tCG5Zi9ipuWkO3A74bbanXIlntJgIZ8/G1IN56OrQ5JRXFT5TjOojXb
5Q98p4bRqLa4bc2eWbQpe6njpP4ICpvKJU5azaMO0dy1yy8mkOAmZuuDpvNI
TWtBRqR6Au059H1Eg3kRCX7sXdpJP4Fqz3nnFJxZRIrbWeaKL5NdvULPXklA
kdPxTXdfkZ9jTXXl1EcIKCVHf6/AxDia7gg3v0hHRCW+40/zVCaQ57kOnwhB
Iuo4Fko85TuBzIprUx6oE9FHYl9VhPcEmro1R7AyI6KISz/ejClNIF/ZbXiZ
G0Tk2pbgojU2jniHlPzXw4jolEHgwecvxxFy3c7b85OAmB4/Nk8tmkQEfw23
wBkCYuMdOmp+bBKlPDvXtoeHiDjfKuvS9kygz+J7Jzwc59A364mevet5KDmE
y0r92hwarZW877WUh43n6bkwe/gdXzoqUT6v4Ru+iE60+8xR3UjFxlt4mNA2
fGxLQHIj7670UhPQByqnhi2nPiIHs8EHHxSIaGkqt22o9i16ndeTfPgWEQkU
ymhciktFxIBtK5slYDllPBmXysuK4n2/kF7P/uXj2lOotMv6/b73pWhW+ey5
5uNTiF+IU6DlUSl6u6iss3d+GnFPDOt7Dv1AAu/DD6ucmUYBNv4SO21/oupd
RSGh1+aRE4GYLnm2DLseKPODKVb4h+X/Ybl/WPYflvmHd//D0v+w1D8s+Q9L
/IvF/8Vi/2LRf7HIv3jXv1j4/8G1f3vnP5b/sz7+31rxX6z0L977L1b+F6v8
i1X/xWr/4n3/YvV/sca/GP3twLvobNZLEvrNVVG0sek7avn4rcc3gYQMDtGd
2yD5A4l0qZ02Jfcf0rw0aKg9fyBn5q+du7JIiCfz5tvVhh+oaJ+y5QL5/uAz
mqpFEi9Bm+0y276XkNAY/+jv+Tsl6NTzPWaPqkjI2Hjnven6EpRY9rn5XBMJ
5fhZCo+L/UREkqypArl/sDP38fchj59IWzylgXqQhAKnq87/rvuJIk5KG9dN
kNCsMANdt+gv1OuXVPt6gYTMzfbHtbn/QruzxI9eWyXff0JuazfV/kJugwlV
eDry9VGUNlArUopKt4kcYmVeQmGL4/cr3eD4KfPf/0/zzePRkg7k/t0bZN4v
ltqA7guGRu95Q+7vRBsc21nWgCImvJiXyfdvb9K+PL7+BvQm2/lOYRIJXTfd
Lcm11oBS71+Y8kslobNpApHsXI0o/5j5mcPk/p4RKxsds3wjquQ7VLv1Kwlp
2lNfpzdsRB0jSLOdXH/yZXNdONtGNJohn/a6mISERAcMVu42IpLXLuGLv0iI
/V7Tl8VnjYj+MNfj3eT7PXXvz10zaY2Ig5tpw0ItuX7Usx+OVTYi4cFVlxxy
/fZFJa4PDDUihc/TQ17tJFRHeG7Xg2tC++/8PqnXQ0JFJiGtbTxN6OjBplIW
cn/g86c7Oo2KTciKo1S1cYR8/CyOadVHmpB9X07S80kSCr9ivaPsUhNy+/iR
9+wcCXn+Mgr57tOEAm+/DhEjkpDjrgNLeS+aUKTOo7VJcn/htLfiheysJpTA
7nc1A7eEjnSLNKTVNqGMrls9bhvI18M+rv0fx5rQ90S7Y5pM5Pj9jPHjO7pm
VOdyuoiBdQnxLS5xvxVo/vt9XhGWT+x//P+thf7Fgv/iHf9igX8x/7+Y71/M
+w83PL65mepNHuKsZ3MutiM7a0tewf18xHdjwe+aCw4/On4is2BPAdrJ2fpc
wJPs1Tjm1/EFSDw7N6UygGyW+fNeXIVIxuJVsVsE2QKaudaBhUhx1adZ/AXZ
smFbNFcKkdrLC2PN8WTv77os5FCE9u83WL+fSraRVBF1TxHS/b17y56v//31
+z/+32vhf/Guf7HIv1j0H6b8X9f/+P8Ms/Gqvgz1qEIdhStuP8jxRYst2n17
YRVas1uR97mOw9/YsGb2lrYa7eBaGcG74vAJy6f3SutVI83i5VdrHjh863Th
1qyganTeYflErg8OzzS4cxZfXY3ub19muU2OPzETRRdsGGtQwvelH3tDcfi9
w06mEpI16NfVJfeFRzh8TZ+w9pRhDRrlXlJIi8LhL3U2KqQ71CCmEtKo4ysc
nrrFV+hWWA2SvkZ6vZscn57X7WXT+FyDDvOSTo4n4fB7KofXqRtqkONP4ubE
Tzh85c9nkz8XalD4dWLJhaz//vP7P/6/m/L/cf9/serdk5vSq8n9TM+Hpl1X
cPjQj3reZ4aakMep+0n9V3H4/k5l4qb1JvRA1ZVqzAmHV2EWd8jmaEYxnFeO
z9zE4R/s295vs7sZpcyfSiS44fC/rzCas+s0o/zao+urd3F45eek6rxT5H7+
Ry0T2ns4fEjZiPaVG82oJ0jp/UZ/HL6P1JrDGdKMZi6Kr7EGk9cXL5P7HtuM
cDq8xpxh5PJPfk1wzG1G7Ds3v+MjX2+//RL5+BqakRAV9erOSPL+ZEVFlI41
I4XO+WMS0eT1BwMZXWhakNbXoXhZ8vXXv83trhBPCzJ52rasFEteX/vKQpV8
CzrvXHlU/R35eJ0trrgdbEE3jhXEaSWT139r0Ct6tgXd3522pE/uP6jWq51o
uNWCnjDFHzmajsOHUUtVeoa3oPjhyFjTL//99fe/24pcNzNOWXahDs2KX+qX
cfj6lD1jeg5daNdiYLy+PQ5/TXd2xx7PLuTwXv/ecUccfnN3iqnAwy6UZclw
1prcPj642AdvjO1CVKw/kT25f2fAIlm0kNGF9Ivv8926hcOPxA0Ten52oYcu
B5bvuePwfurx0hWtXahdnKY1jNxedjWeO5c11oWEOwszo71x+GI7wWdvVruQ
fZjno3f3cXhr2u6qkM3dKFMLXU8nt5/159G0twS70fri6pGCIBz+hYK56nmF
bqSXmCtd8QCHVyvndDyi3Y3CT7kxtYST4/3ZxjjVE92ojVV15De5Pd1ceti+
61I32vmdWDL1FIff9vAoG5tbN7K7mRW7TI7naeIsuivB3ShDwsWbPgaHP1ZY
7j4U043WOvec2fIah586GfC5LrUb6YTPqQuQ21fItM7wt6JuFHrgM49kAg4v
6U/L/76hGzUTHElKiTj8L4Ei40eD3WhHkkyz5gcc3jbrbsBdYje6aDWZfpjc
3rwTYk4r0vWgT2wfHpqnkX/PyWNJgqUHkb5fcbTNJPfXkeXjHZw9SNNV4vD1
bBifsWp6KoY6rgD1kILx75Xm0W2nb8yuAjlI9evyAuvbeWR6NrV+8WE2YjCp
Tcr7uYC6DJ4LSh/8jiT2l+i7p1Dmn6dj+U2Tw3/52atkIkWR3AufvhIRl/mD
cZ09mehrWFeIyQgR+Rc9MxST/IrQMlU6gZOEiBJxyYxCeajRxSZKcg8J6UqU
2/dqFaDevVECQQYkVN406S2nWYgmiFWxo2dJ6IgPe6QXvggtZdNIHLxNQvUy
Sh9qNYrRBjfllPfhJHSiw6xIUP072ik5/H6JnYjtH2U+yE3z5s1vm9IwJ1s6
ToRXfkONbkwPmXRI2PoEomP6hyAwJV9x8Ma7pryFWZjfXdbdVJb1DfPPlORr
A18SMMtXdP1Sr/yEvf+NoV/tYeSpQrOySqyP3QjY+znPSoU3LzkhH+P+rcE0
bT2U/f+OlXegXlsps60Q83LfwXftbbCce3Vr37men1g+riaPgvdfcrIwu8S7
tT9Pz0ERU7FO7S9If+dzzEO1n2OprD6AN7vEhvTkgg+pxHKfqwAHrbxNGGgH
l+a/3XNxDEzv87ZwdAmsrfP2sP3GJcwCo4Nn7+jA8qe3Y6NXncGU/T20S/Wz
SVcpZsX3Ea9PDJZj5pOeCDOfrEQiCknU3ZIk7PxZMI+qjuiCw4bEnObOgb8X
XkhavQv+4nkpxeo5WPa2K392LPidk1/Ilo/gHfZPVuyzwJG2cVd+FYBZz6S3
CZWB/cyK9T3qwetGdV+aO8Auhr2i8oPgSe3pJ8FTYBu0TjdEBHcqs9zYTw3v
d03k+fqfM4Ep89fVUr98ENWsQqSxPOuDZRMoTaq79vN4OfJ82W73ccccqny3
eWXarAb5bIpRyrs7h+UfpeRzpg/crDazvxq97ernVpNfQEW4r8Na+rXowJEj
2jnlC2h18LioeXADujWq8lgqdwHbnhIPVlmD3md2kfuxeeJVXnWL6De1mlba
q2p0e6aofFqOgCSCwgUCmmuRdIMlyyl3AuJQ1Km8bFePrIzUittjCFh5lPzA
+188pBJIrsU8p5G4fkqwAt3UsXej5iZi61OubzPzg0L3mcAC6veV6SNrsfYj
0XhNT4JUjfnYASHSJRpYzhzDVKWxsQ4t36g9m/CahH1vbI6fNDv7DpzWzHSM
LwUcyiCu15IBvqKigyJywbqXzykdLgbvfO4pzVgGXi9/Ify9Bty+8pXnbjM4
S7qFXbULHGG1wLjQD3YMZceljoENC2SIl2fBYjOGU7tIYDqhy4M96+BeI7/O
5xvg+2qeT2yDKTM4Kr2wnO2P768VGc7C1Yqw/ZnsFOsVffB87miMuBXYr2BX
h+l1MM/3M9vv+YI//nxu+ikKTKkPgeBtg9+1mzEP99Wb2p5owfxJ5eFP+kut
6PDPAWGSFORrPVye7Fuz7w9XOw0nGP7hetWDdy3/cDMu2dTuD7f/Yt7t/oe7
Q6/SBYPx7qePHX0OdpJ4yfbsFTi+pau2Nw7c6sv/UCIJvEnRysgpFYx+v2DP
zQBfD++so80BxyG+iEMF4JYJS+MnP/4oLzp6S3fZH+Ud7KgXrflj/4g8jxwb
/9i/eAuT7DZwm8nzrdQ9YBaa9oaDA+D9n7gfR4yCb5w2P94xBX7HHLVt1wK4
I6e10X4JvPny9ieZ62AtLjPTdVp4n+9SEsmhtxGc6NzSFLb5j/f9f3//FKPZ
L1KV24J+ETS9fKOm0farAXx1+5ux+T76P2tiuILbsfkwXUfmdu+1bkcXAv3b
dC+MIY2NB7x2vOlBLIZFrju3jSNxwjZ6toVuVMfbPrLtyySykgspCRUeQB3a
I7TjyUQ0e0b9yf78EVTb7k5yzCciUfav93qDR1DJNdbJhVoiOlWs5ORlPoJy
6GP7bvcT0UPnNGtBsRGU+mJv8/oiEf3cJXu0cGEYxSmUl99jJKHVpmQN6+Jh
FFVqVcDIS+4v+ItL48KHkVFPzHHdD0R0YXKjjLz2EHqosu+wQQ65fIVe4rEr
Q6juYavOkVIiMnbNKroWPoTYx12QcTMR6X0LCQ7PGkJG2luVTwyQ4yH1edNP
neTtYz7JWsyR+xe6qjtqaYZRHeGw+GkcuX8TzDo6LT6M2I+NC57bTEL8tYNp
rEfJv58YwH2Bj4S2cnzzkHUZRpk3j7wPFCGh73FSVzaFDiOni8d8QqVJCLl1
8Ai/GUayZsanHpH7b1+PBleoZQyjCf3je5+pke/XIvs8jH8No0TVE2wxmiSU
ujwmfaV9GF2QNBt7Q44PkrXPu7wnh5Ewr8WPhKMkcjs0CI3CjaCeTadeJp8g
IUH3ZfR56wh6sWp16xM5fkQfS5ouFR1BZpNnjDNtSIhT1OJ173/y+3aflc4h
X68PVzYakQ6NoLrq8/QFTiTEUveVms16BIUW2PZ+J/cXAxIup4k5jyCDTxdz
Sr1IiM6D+zzebwQxvLn8uMqfhDyNyraejBpB3x/aXa0PJaEV0ds/rn4YQV4+
DvotT0jo5qq4i1/BCPK7bka7Jj+HRH6wsAfYjyIUbVjQ5DWH/N9dULzQMoFk
HHYWbOVeQO3jd0I4N0ygjntBW0ZvLaC7ikqJPzZOIgUle56o6gVkIen7vW1u
EkVPuwvM7SGiIN0Bqmd0Y8jhy5WXmcZEpHSZw3/00yjCe5oL3L5ORL3Bupv3
WY0idj39l+rhRBSc4vokZOMo+hxJE9giT0T/F3v3HRbF0i6KnlEwoiLBSFYU
RSSqCOg7KlmyAVCCgqCSRVCiZCQoIiIoCiICKpJBskTJKjlIzqDkODPE02t9
i661fZ57vPfcu8939t3rz9/Tqfqt6uqqma4q1tQ48iT7EIg8nY6dlSLD1oEU
xhi1Ich93FfNeJkMNDuy+PV9h0DSt2FG0IwMZJl8edaiIajwLtmp4kqGIZuS
G43zQ6B6P/2EWRAZ2qO/uvkJDoPqxX3xkE2CHxas3BrtPyCTnpJ6rZkEtpvH
H6vz/wSOyoocLzIJNkbnz6u5/AQvn9DiuG1keCn5RF+t7ifUiawxiK+chdZd
66/cqB4FEZbXQMVFgv3bzXkv/hiBL7LfzODLLHyh0XslbzsMa38eXeO8OAtn
15vYyVCNwCnvVy8LDpOgjPaumoTHCISE7RqiViOBKefzqeKpEXhYtf3hONae
3tCvmSmsPgoOVEx8rWEkiHrP7hyePQryJ2PDwsu/wb3be42oFBYg4NoLnoXQ
Koi9kLuaNWAessZ6Qr10GmHjm1zqDmMSvHpWL9iyaQy0oziinySRYKfkAQ3z
J+NAHaFf5V9Pgkfiu7mr3SbgYYn2UnQtCXzY46RY1CZAvuRiZPEeMv79WfLb
ott6e7F6Y03/k/XeU1CZ1GIf0UqCh685lGzWT+P+cneCgzVn6q/1Ssh4++uz
EtHwABtaX+P86wWtBaxfQ/WwZZe3wDS+/0r9lmLi4OS/FdlKULCThUKG8yHe
c7SS0/C5eiJ1Xo0MJsvRFjJLU8C9b3Eqi4Tmq1F1S0hxtSbDls4xiUKHGTx9
ruuP6t76jKz3WeebL9Usbgbl6pJXoshzaS+VBLxm8PSJJ/HlB3xBXmkfcmh+
8NelRetjMJ6WNUxXJIPFCb5t3tSz+P4EptzifjHklfHJ3BUS48oayEm+VW7H
sHpOM+DpoJXALNCdfTLBuEiCISeF6j27Z6GFPi164jQZ3PtMSYrEWbhav37i
nhUZONis5jdPzYDB0WxhU1oy3l9rLpIXPkGDrDn+QTngNhlIDN0XOVVJ+P3O
b0kJsDdBXt7oUdPgibx6nTqdQATyuTV7NOKzkU9/CN4nUYUsoEw/3dSDzD7j
lW9CQt4STHi0aiMZ9+JJG80gVuT1QuvfVMuS8HgFuYwX9ekhc9U0DlIckJM5
cjdufoZ86lbUYc4k5JX2dvDm5OyEHOTZ+/q3XkuQIUVdm5JXhPbvW3ytatyE
vO1N34ftQ8jSMgdoCheRrUeMtU3pyLjf+yek7dyDvNJ+f7A1+TbrMAm3n6kB
V4802s5Tu0nmUBjyZ5sH3m6TZFBQuqTaspoMxh3nG/Zi/ewXX322qP8xP13p
lW1CWFwNg6/YPF8gQUuonpf2Cex5oTuqbLGBDBUxKZ+FlLH3qMfG/Wd3kCEr
k4ZqvR4ZuBc6F/fsI0NM6UWxdqz8mM6t0n6XRQKeBM9jG/tI0MPMpm/xhQTe
fC8aOudJoA5ixuJtWP0ZF2uVij2/X66q3V4zSgKZw3mMDw6QYReVmVF/cj6+
XsXQ2ssPuWhyYdONZd1ElQWonP6he3JzPpi4nrTfcGMeK7eVEedLc/Dx/mPt
+eIJrt9wr8w3ub1uo1csLMLcoVFeyuUWfPzsmsp1c40ZnbgXTDbymC33Q2Hm
gIkZzMPhdeKtOw8NgrPy+LH+jQugJX1OieA9gJ8fX++9MchQX24BEhwnduU2
DkLQseRksax5WJBKM/K5O4jGQzvMbLW+MgT8SScddCPnwfxN2jbD08NAb1C3
az0s4OvT32fpP5P+fAHimmyFn6mO4Odb6c/6C42s8sTOd5Iu79RrzCvn3x22
ZjpEdQJe6NW9nzeZB9YShhC60An43kckPaubBwHnnTp2HRPAd0H102PeBeCs
Nauu3jeOx3tl/JLVW6/25vtzuJ8y0b3ttp2HtVfDvRtCJvD9V9ZbUi49OijG
Ow80a6e1xrZNgc1eW4Zi4jz06E6DkdIUiO4v9Hr2cB7WP7Fgu+c6BS8NAu4a
YemZGO3MYU6cggwOBpG79AvQLKekndU+BQ2tj8kuygtgRZ3P1Xl0Er/eSnvW
67QirVziHO5vrSVstdj9ug1o3pMPn8L3x9fPPNkkU3MFmWmCb51N9hzE0HBl
XN4zgecnvt6wXar+iyF0fx5cY8XkBwv4fHI9vaaB5mrzsPvrKIXqzCSeP565
LHavPk7gHq/jmDfZPYWff+X6InWhlFXjKD20snzJYIa2XxOyqmxsXcDfnz57
grR3nMTyZ+zUt7ipKfz8E4XSZq+w99mKGW+Cz+4gtH3l+KgLMsHvtyziNsmh
5dh4bREiJPffj3yD5htQiBM82TmJnGZSr0N/HI3vdxqPfZoujsafr3bJaNFX
QPZgKOJg0EZeH1l1Pc8U+cHR1lgTR+QtpQNTu/yQH2tMHS8NQ2YcWnK0SkSe
jq48zfioCAiREfImeUv49zUiCmPRw7eW4fLHe8WD10qA2W/EJUxpCRwT99iU
iFSD1djBwq+aS3BCld3pLG8lPv/Ayv9TW67EyVAbLeHz858Y1Dt3NWsRGkfC
6sP0q/Hz9TS2VHPy1eDjrUYDW8jj1Y2QaSx3On/NErzkuD7MsqUZ4q2zNkWW
LcHK/wN3jtPwpTEvgxWv0LO2Y634+VbqJ4PQJSbbsGW4t5SU6ZXajJ+/ISpE
2f5hD2yU5bG8S7cEP0caL9iq9ILQPoVHuU+X4PGenZqnlHrw+/lX/vZAvGrL
LsNs5EprtwQrjWXgE+JiUz3Uh18/qvz61tukQZijsCrdj17E5+9gDLa0EbmO
bF3reGQNM3a+sLdb5x4M4/vj42XZ76j5KiMHU3+7IfVjEXo3TLePTk/h+xu/
NZNmOTKNe6V9RgYJR8oe5EdPLqf230Jm697k15WFnO1PPKI9j6xx5nZzsyiW
30XjIeVfZ8Hn7r6IlxlYfV5Kd6i/aRbsyj8xpJdi+3/hzyT0zoIRywXX2sZF
mK1UlmEZm4XL5sOTo/2LcLvWvEFkDmtvF7rqbphdhPEGv2vnaUggtm13DRfN
Epg0J0ya0WHvt5tJp04xYvnRVuXks5sEu7NlEzX3LMH1rvHNb/dh7f8tXezW
gktgM7mwShJ7XlbuV+RNm53bWeTZcznThZeQP1K/MlltiLzSvohmcbQf+puf
Lwuzn/+C7Nn1szB7BPluYdh1ri1LuC+f0kifW4O2X/764sUCH/IljfZ7S+p/
cx+7LpXLIt4eruSwpBt4uYx7kCqkkyUZmdBZlHC+DHlX7qiTTweyUOh2lYKZ
ZfhuJEjfoIfGKwoolX+vdUT2EtR9Xf0CuZtp7kZlGvLL5wemd9cis4pzDez6
iRzWzt68kzCLm9OZ+euOHcgRe3bkbedDPh9i4c1Jmwubp8KbGfZTEW0MzlBe
nC8EHwXRhZ82mAsMPRIXisC0Ll83MxmtT9rt67zdn51APMjkcWZyYxgaj7Mr
+IXJ+gQ0fm9Rwed4SglaT/qv+SjIjy5+2pKzMt6/HM4P94oVmmLXyyRU0I/k
4uNxV+q3H/4ff65yQW6XmnbM6aYirswv+4zzlMYxASrizhLbuRDdcnw91Ysv
JXpqWgtxG8YJkM671OLpWZnPonHwReLsKJoPI2RB6+BTFSriZm3dArPKZnz/
lfklwkUeBUxNL8OKyYxMux+foCKuD02idboxg+9P/8HINdAJeaV/M+g47krh
Qk7OUxlLOYw8Chmr7COX8f5Qfl9qFnUOcoBPiuXDBuTrAkm828aQQ4bUbleu
RufzyGmoZKBDNn984ZA680p+5uD/3/7jf/yf6V1HNa6WbU/HbWwzXtKbn4k7
J/v+YSrjT7gXZmKid27Iw+0t1q6UqJWPe4fzlhmZRPR9Xd+F3CQaugR8veLJ
9w1CUtc/4l6Zr8x/cbeNITtyd6LVpepLyBV5I9Pc1sg8s1cFg32QfXgazDa+
Qh6+Ihdrn0Qgeny16B9VKsKvt1JfmWfFehIskTk0fa++cUSuWTAVlfRBdg1R
YhgIRBY6yT/sGY7c205XdDAOOcBxIuRLBvIpM5WWn2zIhycft7acRt5lVdP2
RZ9ATD3HVrE0WAxakpalP4wJRDdNvqa5EyVwKzx17x4svar60DfrXwJuy2Qn
TTsCkd1UaXJyoASCNMXanroQiKN3dJZHxUvhQ4bD8UovAvGToxnt0ONSyN2W
93TdYwLRx9Nx50B/KdTcXjV56hmBqPH40b4esTLoq5JQtMPitz/4lVCHXxlQ
eO9Hp0QRiLPh8cSWvjKg9SlbMxpLIBZ9yFVoFC0H9sGNevs/EoiNdPNiLLu/
wR7PtQU/TAnEWNebz1nef4UM5R/3grH8cp1tnGU59hWUdlaIncXSp35T6jxr
0Rfo64ohz2PxPdyaksh67gvYRft+jHlKIFIr7dnC1lUBW2+bW2hh6WnOf2zM
ZlYB78RU+Ta/JxDjhanK2RbL4SS18HBOEgF/f62Ut3/8f5YDf+Onv3HAL16Z
3+Ef/9f0j6uM8XFPUX7SvMv0fdVdgZtz9IqpH99X9H4aPWPKZ4+OTznXPMlR
XIn7rWa62AbPKtwE7lSmL+MleH2/Uh79Qx7SHmBD/i73OWqVCDI7eY7Yqozs
dJh9OOZvx8+wH/o0eQvZkEHEV8QWuYNGQueeC/J5shL/Z2/ksp+XCRueIEPb
9RqlF8gplbffPH2DfLDA0bLlA/KrFB9JjhQCkbW83j2Euxq/P5HEtXLNpjW4
V34/yF82a9ppiJwzoabsaI6c1QOlvXeQ0+v3E+UckD+WbEmPd0VOyiDxMXkj
x3/oeGvrhxwTUsLWGYj8/lF8kGQIcpRz0JYPb5DDbzvep4tGfqV/fdkqAfmF
mtLdllTkypPfjnCyIjs2igypCyDzmb8JeySB3L5u88ViNQIxaT2DTsXaWuCU
4Zq5ib1PHXOjxJP31MJFfVVbbiw/5a1Ed72AWvB2cVzutyIQd/J8I7lcroWc
VzFukVj+DnRerTe8WwuT2d/XX8PaBymBM0mqT2phf/OaR5xuBKKLvJefaHwt
XCYJMXZ5EojKq1hMOStqwY/x6vNXDwlElvSEsxsGauGzgC+rtj+B+NNE4sDk
qjqgKGa9YQ4iENP3NK1pZq0DXuNB7hasPLh/N+rNF60DXS+muOdhBOK5R8v5
7y/WQWDUaSH1SAKRQ/LJq8cWdVBRaJa+DYvf6Nw+BxvfOljufHmiHmt/ZCdk
XroaXQfCS2UFT5IJRC8DRRHZ4jq4sZskrZpOIIbwyvDuTWiAmHGJE1VYPDwk
N8+p+zZAe9AmmkcWBKKZVl3xQ+MGoIOGLwrY+1vdKvhJgVwDnOkPDaC9RyCe
enjlCom7AaweXteswMrHwch9vIfWNsA7Yf693lh7g+HTMOVKXz00t5CHZB5h
7cW6pOKnhfWwyTU/eS32fu8ftn5S/roe4KC3XXEwgVhJDVeWHevBolr1jDt2
vxnMNLzC2vUQYb17owTW/ggXrqDcEK+HRrbemlUxWPtF/nFxyK56WF8SE5yf
SCBaXVN7UkOuA3FTK12nNALef1ypD/7x/9wr8xX9d3Urs4XbDAXFw5Rsv1vs
eT1uqrr7SU4iaP/sXpbuu43I6dkOvcaWjbg/BrT1X92Kvr9mPEH1tjupFq+f
V+IfIXgysIYZ+afjaRvjQ8j8X6U014gj39l1FsLOIn+6rsQpehmZz+0IP60h
MoMKa8kJM2QSy1ptM0vklp9j02E2yLlpTT4195DfuOVz/vF9/4rvq0RnHPFC
NmJ9onzdF1l5yG7g2RNk4fRr98qfIe90V2BaCEFeVDkaw/sGuZuV7YzOO+Ti
obXNfrHIH9LHzQuSkB+5f187jT3vR440PvV514THt9t97NHutu+4V37vdvdI
vff+b1brvj292hT5wEkBQ20L5Pnnox3pd5C/zny4wGCH/ErlZoWJI/Kt2H2n
Sl2Rz6zvTeX0RGbSf33I4QHyQJ52eKMfcgYz8w7Bp8g+1t8fPniOrF0XuHog
BJmf/7zNqXDk1Q+2jr2IQq4f+HZtNhr53ZkHzcrxyLavZJU/JCMrzK8ppvnb
+IfDuv7eR3YjH39Lf1SWG1li2L9L8wiykgDDQ/PTyJfuPBFxU0LWz2LoDdLE
6n8BO+tHgc1wddhsYq8Rtv3E1U7qD83gkMur8QrLj82y0jK2uc3w3H8obyeW
H+HneRPGapvho/577gDs/Xz0CsMO/cFmqBK57rcZK7/lRhTH5oVmGN7IRfa0
JxB17nYMKG1tgbUd3TqrnQjEKZcipSKuFtiTFFbigOXPfd8PaaKiLXDSXZuP
7EEgMgc/ZktQbIFL6sxBFlj7JiHy7n0uvRaw4mleGsbe3xKJWmPBd1vg8VKQ
wXWs/9yUfUaN7kELxFRf+NYVQCCalB7IdQ9rgdIIhqOaWHkn1G3ZP5/SAj13
q0MasPd5YMeMr3lZCyzLPaJRwfqzPEMts31tLbCLVcGkAsu/3Nl87cuTLXB0
YkO9JJZ/51e9K65a0woqn0vF87D+7uAm38NSu1vBJMgjQhR7Hhx2WgZm8bWC
p6EE7UesvbSV69ISv0QrRJxYZcmHtQ+j+IkGUeqtkEuX1/Ieez5Exfd9223S
Ci09Dmf2ZhGInxpn5QzOt4Pq/uJWE6y+aKvs3JEq3g63s6TqLLH4L5aU99Nw
tUOAUkmFHRZ/lryUlAub2uFjj3ShC/Y8nEgPdYmcaYOGu6WZXlj7SCvBU3mm
rQ1IG2WT/LD6w+GdBatkcRvsCCt7H4S1h0PCNIcD4trguLDc61As3p+eSWX2
BrbBpdLyZ5FYvNv9+D2FHdvATvOsXwxWnyx57rrodr0NXo5X3E/G2ktsztR7
65Ta4JObvGMm1r4Em9GJPSJt0Lbj6518rP2gc6sp9zZ7GyzFKJiWhhKITjcL
HhauawPWU9/0K7H4vr4ac5lhohWgXlGrAYtvvkbgAb3vraBzs/J8G/Z8dKs4
kZLyW8FpUUm+F2s/rZIzLFoV3Qphj6vODGH1zZ7T55+o+rdCPpeK2CTWHj0j
evJquG0rdGVUC1IyCfjvz3j/5P9jr8zX93/X0R3tXT7N6PghTxF3WbM23LyC
/txrqdH+JxnU998MQlalKs1e4O7AfX3kmKpfJvK+p+9mz29pwetX6YPb9xqf
bMW9kn6XYwqBkjuRncx1G2z2It97f3dbHB+yffeDi92iyLa7wwO3SSFbn09r
kFNBvvPwyzZHTWTL4q6LydeRZ42j7mUbI5ffVL901xw51GDDUUFLZAu97K0j
d5GlrpiOvLVD3qXFXqbriDyqURPB4opccNHNqckDOfDcUc0n3siGyoPHFH2R
TyoEM6z3R6aXkx8rfIrcL7VUfu85cuaZhKjjIci+RF2X6TBk3ROM2vERyEdF
i48bvkPecMyaiSsGuV3o4ERHPHISf+uX4GRkd17fdxfSkDUOEt3osPoj1rHc
2fhmJ57fMUtVJfYk5H99/9sJXrEH9C8ZIR/jlbd6borcG2Pq3nQL2f/Q46fb
rZCJMcmRF62RR3gaPj61Qw7+QC6qu4csw7O7gcEFeSb6RL+qO/Kbg1dmH3si
K0e7rKn2QV46ELmN7hHyh/cl+5T8kTUO/Dzq+xR5zXta6a/PkFO4+dRoXyJf
fady/ewr5C3clne9w5Gz3wbeL4tENtyfEbTuPfL2ty1vpWOQi/YtpXnEI1tE
sZcWJSGz7zvTRJ2K/DVSf/BMxt/uR0ylJpsdOcQm/YjDQWS/NLbnJ4SRXWY8
FhZPIFsJjerkSCNfv3Wh8J4K8qX47H1wGVl+ZI/38jUCUfih4+YIly68fKzM
p+6gKlk6yIw8H/H6/j0uZBvSohTjYWSS7KU10UeRrV6mFgEgT43Su9dLI1uc
MpMwUkaeeFKxmqCBbNa/vzDwKrL8yCnjur+lr8Jw/dYEY2S5waqPPmbIZfrP
Ll23QJbp0Vk+bYVccmV/BKs1slT7qMycLXLR5dSRegdkie8O/olOyIUXJY89
dEU+XUfbesMDOV+lzknCC5lY+YKL/QFyrrxe+bwv8snyg2aNj5E/SU8yJAcg
ixdlpPsGIWeddtYyDEYWzZNZJRWCnHGC7i1HGLJIVuPZxXDkNJFX401Y+a5b
SB3dytKL5/83AbcH4S+QV74HGfF0j4sxRL61sUbgqAnyzEPWj7lmyDZ0RiKy
FsiL/mlZNZbIzkzUoHkXmeaZckGfDbLXrhBJM3vkTSE/Ssn3kB+zHZV3cUZm
Cnep3OiG/HxvpepTD2SWt7sbWL2QXx+4ofHOB5krJqVVwBf5/WHClSw/ZN5E
hR6JJ8iJQsEG354iv7v2JqFzB/Koc2imIzuy8Kvnn1m5kW2zA7594kPO+/6o
SfMY8hqSd/f8SWR5Ro/hYClkfwHn2eOKyN8V7am+X0BmM767wVoLWd/LgnG7
PoGYk7j++O4dfXj+JqTodp/3R8bX6wpKeqm5G/mYUfDsQU5kFXBRpnAjGzIY
RpfwIbsNqFAHHkUOyTqufe0EctojjnRBCeQqvfX0hLPIP49NGFWqIK+m/V4U
oo7M0pnHZqyDfDTlnY2oAfLpq/zHSg2RY77KnKI1Qd4mevWsshmyU5TNhYBb
f7s+vb9O023k847RN5nvIOcMFdy+Yo3Mrd7iEGGL7P956v6gPfICP63/IUdk
g5C9L82d/3b/609Epbgii965kEB2R47sNskUx96PnxNZa53rBvD8WiRZTZQS
B3GvfF+6OyLc/o/x5Pj3pvNxDyWNkbeqZoUqmCLTvi+J/2N8+YrXUtXlaVkg
r1LrrNa3RF6MHe7+Y7z5isnUlCkra+SpyzQ092yRR5O2bvOwR366I9COgRl5
vyPE83IiZ/QNdktzI5+V99+mexi5LUlMzl4Y2Wxnn0OgKDLByTcxgYj8pP9Y
X7kUMpdC144+eeS0ZG/5ZVVk2V3CTjs1kJud2pKFdJCNBzwGFLDn6YBcs0ZT
DIp/Tv8W92OMP3Cfc5VMCLRDXvk+jqwTm3V0N3LYU6bwJHZkmQoHz8P7kMep
+k2jeZCfHVW8sE8AmWicKhZ+FHnwNSsnqziyX6PHuuBTyCKbxkaZpJE7T6vV
P5ZH9rTOzdqkiswftz/cSw25qeeRJ40WstNOsqmzLvJ+pSsXFq8jj3GSw0cM
kdsP/qDKN0b+JtisHWCK/Em0Ivu6OXLs6exdYlh5XPl+V//n2XdParD3ZH0n
S+GmGRhQElkgPOmGs4KbvU97zIDb5L4LJc09YD4oGezCP/3XeMhu/Ps/efq3
be+NuvDvf0h2PjxCnl0wIspr+IB+AtaO32EmiQzg3wvXjHp1zvMO4usHB+xw
LbLsHARiXtOzecmV7+0HQcI5j/7hFWTp0+8esNohn13ttybhKXLO1G47uljk
We2oM2s/IR8u56dd+oJscCSrbroV+VWYZMjQMHLjxir97gVkuruXDn+npeCW
7e6drWRGFpSJcfflXBlPiD238U9oxg8ip2y3c1cRQrZy1KVJFkM+OiDrziiB
TFIUoLkjj5yRusO98TyyLSsVzXEtZHGPAbdgfeSlkW/UCybIuRdS3bTuIDt9
CqHOvYd8msvdjf0+8uqHxtQuj5CLps+59QQhr4z3X5uyMalDGbm5zXG0SXQQ
d/3NI8cXb/Tj6zfYbpahcLwchVcM5+1dCTN/fW85gpcnjq+0ZtFuI/BxY2N/
asbKeoPDePnydcpziwwfArYlnZef1Gfx47/41N3/+A55x431ilXDyHzhB7yF
eUjoej8FqpW5ZvHzr4zfGee+1L7LYAgq6cVpB8+S8O1JvO0VGfbIATJOPj6x
yCvfb9p08C2LMY5AYL9s1UxQDb5+4sr3xml5GYO9n+ZAVZ9DMlSmBd++sv68
7pAXv2/9HGhqMql7R3bh21fWmx88OMqsGDMH/Ud3Nb842Ydvz9zPfDjt5iDu
6ihWtaejP4GvY72ZTyEZWL+kipNVhqHzBEFe5CMFH++gp3G9I0h0Dg7yiM1n
7hsB+g7r3oZ9FHjCp/WVWXcMti1oH6A/SgGbiojDSj6j+PqoVyqtulLPjkHq
fV2FfCkKPh62wN8oPdafDJqtAXFj1mP4+eaajhoZ+4/h6VupDwTr7teoFZBB
4HrZIwrrFNgHufsqp5Hx7/3dwu7Q1nrNwY+pfAe5bWh9UIneZpJdzjQ8ldc+
tneRDG37xk6Vu01DsXWdVkwcGd7ZXZZdNTQNRReEPZ8HkOHUV/HTPbwzwJMU
pUKTQQbup9ZeLa9mQU06YONtEubjq4m22bPwssC+V4eVAgJyVsnMurMQ4p/+
2voNGU6ruTI0uszCeSn1qvlKMoTOUZNuFs7Csmhc2UcXMrQwnfqxpn0Wxt6f
6ByIIsNOAYeWN+RZ6NzxdXZnBRnMDXUkPPaS4JnwzrUVr8ngeaTc4v44tt3W
LM5lkIyvd/fqw7qi1Jl4vH70X7vOLjkuHgQ0NbMimdB8HCvji1oePrvL+aMQ
t4vg7OOw6VJgf/dJjiacgu/vWcPcGhuLPLFgZ3IxA1ljf8vS0mfkAhVRv7dV
yAftn3MotyI/iSInkQeQ56vUJF5PIV+bT62XXUb+wrXt+uSGOdwr86dSiZbL
nYjOxZ3/rnfbh7o83C7C1zyP1eXjPpPXQymsLcBNLa9npFxbiDua/bLQ8Vp0
fmeRVuGUuiLcaspaR/kaitF8zzfaj0U3luBe7aRznOt7Kb4elr902bny3RXg
Pv2adjXfGD6/RX735p35/tO45yv2XKIKXbnfOtgxfiT55xtkYUYZ2vr3yCoi
l/Rz45FNNI1z3n9E9na6tz0gCzkqws/8Xj5yYWl42Y0S5I7hFM5zX5EX6Ers
TtT+LT1Hvtft/458RGOIl77jb+lxWPRY6EU2fb2ls//n39JTxHH8j3XYV/z2
h5B/1uzf0rNJaihyAblTQF3Cb9UcSs8FwxDbdcg7be1nr21GPhLqq6TEiLyS
H8zHQ1aFPUDz48sur/4QuLUW990iw3MPA5EjfKrnXXej42tURCJsw5CrAovl
j+6vR8cH9pycj0VmD6QSyBNuwF3ylGWPe1YDTGqnnFodOo6P/7+vHnWWtW4c
DlNS2y8bdOHrexkHeZoIt3XCdIBttBDzBOj++T15J5T1iIpcfVeL158rvzfy
WN2mdhil4OvJMm7axyrKM4evF0srVNqmu3UO/Jjp6O1v/cCPX2nPhcZkP9yU
QAH744y9tZLj+PaV8WNR+2m3fcXaDSvzLW3paQjMaSXBQuFqjXDMK+M1V+pj
dfktgjRYuaGxbv/Ka4PGBxfr2pWatSKHce1wI/Gj8bgr9VdNTfeh2gkSJCcv
JO4xRuNxh6dVDQuCkdviT+j8KEGWd3jdJjOMnC1Ho/mODo035dlxs3ntEeSV
+jHyfavzGxYybkrlou2YARkO9lw0YBBA41HdmxT0959E7vwqcU3sLLJYoZie
kjpyYLqgrp4+8kTsgat3LZDl37Bf8XFEfvdsu86rB8irfTdrJz9H1nGl0SqJ
Qqan26wvGo9MyTbesS3tb+m7WVExkYNcsu2g49diZLz8RHa788YugHnPhIjy
ZBc+3m2lPM0IRt4OubCAl5fh5xaUsy4L+Hgh7m5v++zABdjcNXmJfs80fvxK
e8znON+6DwTk5nmxRjNT5JA+v/UXvyzAjsFr5z8E1uHjoVb+v95HtKty6FjC
0/uRlyL2BJaB39CrcHX3DL5/GG1uMu8CMl389Bu1bbO4nVQOBjjzI6+019bm
VC3WGiN/F7QqhUfIH97ufPIhEdmBOUdrex1yU0n7JuZZZNPv+/OK6JZxUw+Z
W5jxIAcvZOzdKYXMv3l1Y8EV5BI2eS9ju2XYFF8Zraj6ER9PsvK9tqIvz1rW
aCriddagviyqGXhCMeiIep8GRhZhDZonZyD5dKM4S2IqXp47Uzd9mM3NxU1n
+1C6t7MQOk7WX7FOJOPzVR2y1bmstRnNX7XS3uY8WUgp9qyBsFWZ5tcWp/H5
bFae16ZXjk5S6nVgs2f8a8qFWTR/kATtzEluEu53Lcoy55yr8fGdK9+fGffI
EW6enwdWy5KoMKcpoC5nihvFnv+sJNK+sVsz4Pltae8PAtYec045m5E1A8Ln
H+9iIZOAXyDLiE6RBJNBiRrbZkgQv/1wmdY1EghT7joYMZDhZaeOepEdtn37
9RwOHjIU2UXd5HiFPUfn+uQ2zJPAPi3EFlRJEPyqhfmFHhnuXwjdLNtWAIpk
j2Q/4zkwO1d6U+9LAVT03JK7aj2H18/Ddxjrs/LmIcWntHJpGxoviq8XPZti
J7F2AX5uy42iykfjS8+t++kRKYDGd67ErzG5YcD32hLuMsuC9s2uyJlH4up9
XyPHzD7/sjkPOSTNvdC3fQmc82S7TmvN4uMDo9mFeootkWucmPvkHiDPd9IM
fHuDvOfU2KBqFrIFG+m7XCWy7E6PmDddyOwMTI4LU8gk2giVC2tIuL+uEdob
twNZRyLk8sjDTHw807drD04N10YB8dabqKgXaHzWU4+481lCVMTplhJdyefR
+P4r/Q3VS4dK+nYQcJvqX9KqY0H2NvecKuBEjrJL9Urcj1zg0csWdgi5/TF9
qq8A8txLorzDUeRt70y7jcSQBZNfWl8iIivmlG+WlUQ2LCNHHJNDdq/bJ7ZP
Cfl1x/lqxvPI2T9drq/WQG6aSVic0EKeoup40qmLvIV208HK6wTiYO464RsV
o6Dux6ygsroFYuP4qnavHoWMP+vfVvC98mJ7v+9Ke/M73t/aba1Xzi3eDCyW
P69b+43jv8esvO+D9FandMx34c+/t/EEW/61HmC/ELCpsWMa+oOO0E+r94C4
1La2svhx/PeLGuMpvRCs/F9jz6SNx94vHpIEE2flKYh55twWcIEMZ4I0ai6K
oflBPBpS70kLT4HYCaWXiY/IsN2fI047cRrY4G6bsBQZxg32Pv7QMg0pjDRn
IttJcDct8tiB52i+kNZVLmkWYdNQ7XR7Y7E5GYhlvDU7N80Ac9VAqSuRDPLU
Zom9TDOwJ3Qyu/YAVs/5O1rny86A8rvh7VrY/juqD9honkHzeeRNcLYpeMwC
5aN3yjM+7Pjmqy9+RMzCtiD/9uMaZNBnuLQ2Adu+YzPL7BmsnzTOyyuy1QTN
5zF3oj+WgG1PbKj+FsePbPDqELU49t49M72fKPd5FlgLZB8EYO/9EA27/sLi
WXh4htecpxtrL1h6RXH2zIKLaZhc/joyXK048NRheRYsVFOmVLD0hHyVVlzc
TgK2BvHxN8pkaK7UX+vAT4IvGkXDM7ewen5XyLl9tGg+Cj/bjMG4Q8h58o5G
+tj51DOVNjYlI4+ziXOnYuf3r+FaEjQmY+2Bmr5NWPp/DkZcDrciw5DSZlK3
ONZ/Xd6TsRVLd8yc7Lp0WTIEM73Z5uxJBuNI950PL5JhkofTcvwxGQ4p5x/U
xerTs6dfV+u8IMPI3ILYMSzeb9TZ+SojyBAbKaJA60CGwBLfV++PYNeV8890
siZDEok+bYMMGXb5pVg765Dh2/6gb0aXsOPqG466YOVhh8vyXW8sfSy37RTb
eMmgN69N3GJHBqolIRHWXWSIs8xZF+BFhm7PYQ6dNVg7boSlesczrN5niNwY
NkkCiesOz0Ow9tO7UK2ZTqw8ER3O8AkIkfHfF2SmGwo2ArKykeHFfjlk9e7F
H3kXka9oPHZ4oYt8o2rv1jumyObS6RHKtsjWOWdFeDyQHY90VND4I9+PsdDp
DEHemMtmSLDB8mFH37NVBWS47PHg9cb7ZGCWsDvyM44MHxQoTUxPyaBotrWm
GovzAqMBHfsbMjgHvzXNwPLFoW+TyVZLMuTrcXQ0d5AhN5pRdsqeDIvqB+3G
hshAMN/NVe9OhuOKQtupyVj5PMJJSPMlg9UZ8eQd1BRwn+NuexZEhkQRSSVe
OgqU5PJl2IZh+cmrOHSKmQI65bfyVmPxS9mfm3QFS1furtWholj72MhXQPp1
IBnYjALsbmHlhHPmTUtXJBkcs7g03p0nw/fL28w5P5KhY2Pa0Q4snx8VeFLr
fSYDaMowbjMig9SB+WdvasmwNf25yiZhNH/K5RP+RfSnkSMLvI/vUEYek3aN
ZdFG3mYjF+GHnU98ymPpmTDyzkaj6O9uyEU/H71eX43mG1LezpET5pmJ1lv6
5feGf/xf09X/0+11/3avzP/4r/Z3+z/+X/S/4tn7X8b/+r3lx2/9gN9GiA17
L6/8PvNiiv7yJTHk6NQYl6dSyBk2UtFVKsil4p3VG7WQG5dtKFI3kAcKGDhc
biPPusfKfLqHjK8n9lf/EF9P7BcTf/GpX3z6F5/5xRK/WPIXS/9imV8s94vP
/mKFX6z4i5V/scovPveLz//ii79Y7Rdr/OJLv1jzF2v9Yp1ffOUX6/5ivV+s
/4sNfvGNX3zzFxv9YuOV+bf/sukv2//d66n+P3Xkbxz1l3+k9h8/LUgGp3mB
RAseCnyXvHTjIfY80uuue7BNhAJldV8DmyTIEFHabpApgT2PeqeK9iiS4Sjf
x1PaKhR4P5kyZapGhpKnPsyrtCnw3JmbM/MKGdQXrpIiDSngRfdSmcYQa//p
itTI3qWAzastjsrY82lXtjl2xJUCNw+7xr7A2nOb+PvuP/ajgMan2ZZ+rD0X
GpileySEArkHY9/x3piGHXryq2msqIhKdL2LwmbTINRv+uqLDfo96T+O9/n3
Wfs31vmNr/zGV39j3d9Y7ze+9hvr/8YGv/H13/jGb3zzNzb8jY1+Y+Pf2OQ3
Nv3F/+7x+P/4/52f/cbPf/G/e3znfzX/Z4+nSeUPF7P5Y77U0RrlKZpFmCoS
fP9cigTPfE2FMhgWgf9y4bZMZRIEHt6wzZFjEUzGz7k1XyJBwLdIsgTfIkS7
907MXSOBv+mplg0nFmFgl5XObjMSPN7c9qlKbhH2JNB8FbMhwaM467BA9UW4
IhkoqulKAl9FRldNg0XQ4E1XNLs8A5Pk+WKHsGWwXz1Tnas/A+sGQra4xy3D
q+8CF+jMZ4CtHtQfZC9DQbxp0xXbGThS2BX2pHwZ+tw/XE50m4Gzia4/gpuW
YZ3mYDvh0QzovuISDO9fBh5BLl3V5zNg/bDE9v30Miiu0+0LfzMDJZ9SrqoT
qIgW7aE3pmJnoCaFZo3mOipixPYgfRb3IWhXzaGP3EEg7lS1WHr8eAjELkYR
u5gJRN8HCkFrQofgmYavKQsHgbi6hJvfLnoIZjTvvNTgIhCtCdRlY6lDoHpF
u/zpAQJxRKzj6rXCIYjXkyJX82LvmzuZc02VQ0B7/fC+zYIEYmPC0ycKrUNw
03DbebmjBKL8kPmhgsEhKDZZcvYQJRDzueSLjs4MwZ5b/fEFJwnEY1f2a38g
DIOz5be2pdMEYkzwKhLb5mFov5u6UUyaQOSob3sUsGsYxO1Cj989iz2vWzK4
1+8fhuf3PK4nKxGItHIB+Q5Cw0ByNn06do5AdHEzuzQJw3De/WIhjzqBSMqR
mzKQH4Ykz5MT1zUJxM5W0QPqWiMQxcHfumsXgUgXksLfpTAC/dYDc5psWHnV
OixieHIE9lWF7ny1l0A0Z3kHU4dHwGD/RZEu7P7D2jik7dmw4+9tUtvDRyBW
hbxQpKHDjq//bKUvTCBSaTNd9KXCjue1D3h7nEDkZ32ktX1iGAzchJJ/YPd7
pX2dfljXMES1/KzmkSAQ/UJdjA/UDEO/YPi4iSyBmKu9cDupYBj2eWtsSVAk
EMdY79iJJWPHd9EdnsTuj7VjzOXzG+x4kVJ5YQ0C0dLRhPeE4hhUFtuEkLYT
iE+156yF1Mdgp0hiwaXd2PNw4v7nA7pjoPd+cOATK5Y/zIx07MZjELuLfRMH
J4FImQ+7vO3OGJB81ATdsPze1cL7ltZpDE4t+qoNcBOI4pmZk6u8x8DHtNhe
7hDW/nkufZLyZAzqOxZfx2L372hd5zUWMgasKkdK6IQIRG956ae0QeMwfn+G
jx8rb10pu6VK/cbhamvoodtYeRNhGZ919R6HGn6ZA6nsBOIj989vwW0cTrtP
cFGweP/H3xdS4B//93b1b1zzG9f+xnW/eGW+2jW569bbWVIRV8xgI+g2Z4fM
JqS5bOOKfGjE3ZbijSzyNn7G2h9Z8up3c/Jz9H/hfxzf+Y//8X8tB/zlvtcK
63mOkPHvI+xFy+6xA7Lg4S+9Ge/IkFPeZ7E0MwpsA3wPjyeQIbHYmP/ahjGg
DXtyJCONDBEFUyNlrGNAUSe1ieSSISjH9gOf0Bj0b73skV5MBu9Mws2n0mNQ
W55zWOQbGRxSPffNXx6DPFfOxrR6Mpgnbem9Yo6918Q9HI+1kUEvLvB1sdsY
BM/82J/WS4aL0Sw6h56Pwf04haqjw2SQjYpg9o8dA8vridapU2QQD+dpJuWP
wVV2Jo6j82TgC00K0moYA8Xv1mUfV1GAM/j4hcKfYyDm33rryAYKMAXm0R9Y
HgPus8RdH7dSgLpsz42S9ePARB1RILyTAktSA1JzDOOw6tNaoxR2CpA/R3Px
so7DmJURgzA3BSZPm1Jf4R6H1sOVWcl8FBjOE+jxFxyHsgHBa0LHKNB/cia/
SHwcPoYF0iafpEBndnoYWWocwjXmUgSlKPBd1N6RR2UcfOm1tZIUKFCbDtra
l8ehx0T5XGcsGQSuOexhXTsJtz4wsz5KJYMCG3lecX4ClgcHB09g8b3ZbFHn
ODYBD/d9TB4uIYP705GYhJ4J2H3N+d6LKjK8Vr7h3tU4Ae9fK8jKfcfyb2OP
Fv2XCTjWsZOR0kWG5mKto2fyJqCIub/97U8y1v5q2myZMgGql5LeX8TiyXDi
3EDEuwnoDLpnSbNABn7y19z6lxNgUi8HKdQUkE+Webbm8QTM02/foLeJAjdM
C82PuU+Ap3JP3dZtFHA/cFL2hs0EbPONf5XHSoHw3nSO5yYT8KbCztBsPwVy
XgnNlV2dAIH1MkdY+SnQcimuZu7CBORIMVJ9FaEAienABx65CZB36yy3O0UB
xuo3rponJ8DFjibgTgwZBPNOCNgwTsKMqzT7bBIZcv32ZyuxTMKNB14xVhlk
kL+6VXrfvkloCagQmcHi9V1gvnrh8CQohmwqssTKo8GqPs3aY5OQH6mkMv2F
DFM13wbeEydBOO5x2+1aMji9Sbdwkp2Et6m1N6ew+G2yDF+8qDoJu3KZZi06
yRAs8cCT9/IkPCxRc5nsJ8N+pjsM1Ncmgarq+WaLETKk9OmENhtPwu2mluAJ
LJ6nUmUPJFpNQn8ny/5bc2T45iGUcv/eJGj80Ekep6LAZTUW0L4/CV8mXoP5
WgoM7l9bLuw3CTDXUzGGxdeKPH5+4/NJSFq1T92MkQKrypo7ul5PAtfGG72j
uyjw6Plnw/ToSfAQ62WXxuIj1sBhHx8yDcvxkhbfkslAfURG0OLJNFjvfVt4
IYsMX5+YDgp7TcPEs3VMbQVkCJwMCCXdmwbDTYYG18rJoKOSdT7Tchp6nCvS
hqrJwJ3QtcHBcBo0Zw+tv43FY2Lzuny4Mg31hr6X5rB4ZJocvrvq4jQodox9
cB4kg+uX87xFZ6eh5JzK4rpxLD947Hrun5oGYmmSoh+JDEzer5/LHZuGDHHG
sO3LZGgfLFHaxDsNgolWE6FrKPBWepSminMarC52zYl8IIN/e9bGw2+n4XzT
OGsxVv/Q1db3ZcZNg/AlqjPnsOfDt2QsVzp1Ghhat1zvxO6PNnt9cN2naZjS
YvMxycfqn4Q9lleLpqGm43D8HJb/6yJPKI5+mYakqydr72P57/Fcjduubhoe
9yiQGGuwePneWrWudRpu6WvtDm8kg4uLT2tAzzQoDxgDH1Y/Ud2NTOUYmgb+
m/Z62d1kuGeU6xc3OQ1bhnzuy2L3v6Dz3VBsbhrGjF98aMDKg+35KYlSwgyc
2+z8WCGODHPRU7zn+EhAknqQ1ZiClU/td4Km+0jwwjGo7yqW/nR6rWNeLCSA
9PAtw1j6g4q3ikcwkqBnPPb4nVKsfrYtJuZuJMH9Axl6VJVkuHDYTrJ5FQnk
N9rRNG+fgE3lUubupVTE+eSHl7LZJmAyoYrS9ZWKGK0ZFh+6fwIagy65nqyl
ImrQJFM7801A9r1e2hdNVMR1cUUaescm4LW+aSCpjYqYerEpThIm4L48me18
DxVRf/nnam5prB4QcnmfMEhFZHi3qL5BCas3dtEKbRqlIhYo08UNX8TqGUJg
9s0pKqI5hXN1pfYEsAyySRWTqYhs4UfUEw0mYFXl+0rOJSriVzmZ2CemEzD4
UUjDcTWBaD91adWdOxPw9eWn7pZ1BKIB6/xM1RyWnt5b4pcqqIhxxONbZbB6
731fi6Igln6S7t1DuVi9l9gveXVDCxWR6P5R+mjTBKQPxN/u7qYier6d0o3F
6r28wZ0emT+x9luZwL29+RNQ8sP1mf8kFXHnsNnzFx8noPLnSLThHBVRd3Nc
Cn30BDQMqX06vQrrzxgJv78yOglNTF6MNeVUROoIsyKq3knYSqrj7azG4lVw
UD1vwyRI8jncDMbi3TTMtTN06yS8U+HJlcTi/W47R7PdjknYYPmdcQLb3/o0
8wsNtkkwCbxv+LKBiihjsl3zGFZPVaYfyZPG0r/9GT0LE+8kCLb0ME11UBEH
Cja1TwpNQsDiY6PQXiw/Rta9qhKdBBIbMV/2BxVxTmcyvnJhErab0AiwYNeP
XZN+O3nVFBh8vujB+oWKmO8vHLNKx1b8X/83rPrL3ri3mu4nnC558sv2YNwZ
LWEfrtqF/bL/G9w3qeIucjK8/eX4aNw7uLIIPdGxuNP/PF8C7t691xpUOJJw
0/15/mTc4mk/eQRNPuK+8ef10nAHyN5yps9Ix5335/UzcQ+3kBomqbN/Sc8n
3JKm9w7VKuf+kr483IpOq/I1FPNx9/2Z3gLcdmVFQ7LTBb/EpxD3W3qvbaLB
n3Gf+PN+inDXXZY/dZBYjNvwz/srwU0VucV4Vz9y0J/3W4qbd7QmcMODMtyF
f95/OW6NY4H5cwIVuMf+jMcX3O5OGsM/G5F3/xmfr7iTypi3tzh8wy3zZ7wq
cZutHw/r21qFO/PP+CHTxKmktvUiK/8Zz2rcL1STK+rTkAf+jG8NbkESY9dX
b2SHP+ONXPrizmyRVi1uhj/jj6xFbNqYw1+H+92f+YH8r/Zw6C/t43/8j/9r
O+A3fvqX/+PvNRHwj//3uvo3rvmNa3/jut+4/jdu+I0bf+Om3/j7b9z8G7f8
4hfFe6S+vCP/Nd5mFJI8btvfTkQukypM2pWJ3LmG4Ud+ATKpWJftZgXy5vtJ
F+jqkLmkVz1Ia0UWX6taoN2HfK7kNZlmFNnw/sTh2FlkZ+lT+ueXkZ+tffxi
HuvvrTi+pLM6nA65+D7/OrmdyG3STicnOJCn11ZZPjuIvLGU7QMIIXN6mnX1
iyGLyORu95VAVlq3RfGIArJ+qbZb6wVke8+4TFdtZH+ZpfGD15HfWiu3b48l
//U9C9auTTEt9EtBFhp/8G59NjKF58NDl0Lk3OtlFvPlyO5vBtQsa5DPdtCc
GPmOvHX3Xk6DLuTGi6fXdgwih/hfGVYbR9b7dq+6ioR8YENIquwy8phk1ouC
NRTcqc7fncQ2I9t/IumnMCGfoTCd5WVBXn9EmD9qL3KVuSoT2yHkkDPndqV8
WBn/PA1DVzXG9ychizjpFL9IR/YI1X+5JRe5NtvIwrUImaPllgypAtmMcpfV
qAY5e/u96fYm5PVH3cpVO5DVznuHFfchR1j43REdRp70C5SPm0SG+JecnBTk
borxuvNYfv9rPCkJjrJ8565KQvYmSsrKpyO36yXeLP2ELHifxVuiENkj2is6
rxQ5XPJ0xx/j4Nk21qySJJJg/0AwT+hHMly5ynwmVZYEMZ5Tdx9h5el1moHr
/nMkEDgo/9kJO1/3psTCZ5okSK2IoLPAytOea/OrNxiQQMxkUVOvmgzXMiUl
7MxIoKyme34Hdv6XqRxLX23IUNx0wfxsGhniazI75UzIMBkiXnM8iwQyJg4y
XDcWIEm0Je57IQmWqQI4Om8vgEWjjY/NF+w6AdFzwY4LIGS548bOehKYcOfX
XvBZ+OX70G//+L+Z1//GG/4vjl8ZL/WP/70udkg78zKEAnQi6VIj379Dx5ZE
njevKcASaJpUP/YdyK+jGaIjKXBwei9rDk0zbBWOmE94T4Fjqi1eUbub4WBx
SE9aLAUkEh7P+Ao0wxn1oIqcRAqobJa5ele6GTR/+iUXfaSAtvHSFx2tZrC0
937xJYMCRuUpIjK3m+HhZjfX2k8UsOY2iuD3aobIMAej5nwKuHtw0O181Qw5
gnfPdRVRwL+30Y7wsRkaP5uLDZZR4NVp34Ef5c0wdtFwz9hXCsSESZyr6WyG
tT/0Ns5WUyBjaS4nc7YZ2O20phbqKVCsmXjwDW0LiGxSa1ndTIHazOuBPpwt
oPJKuXBDOwU6d7CushRpgZsCch+2dlNg5E6diaZiC7gUnnmyo58Cc3Xe3yWu
tUDwhRN2bD8psFbolCSvbQskDxzV2zdKAcbHpAQmvxaosOE/yztJAY6xWOal
yBbo3XhQSHiWAocVrnn2Z7XAQsie3WJzFBD7sGv6W3ULMPGzrD69RAGZ9dU6
aQMt8NJcPOrWKwp0JIlPFrS2ww6abTnHIijQPbTasLygHQKej9UvvqNA396K
rup37UB3uGykEIv/oJa/xnffdnhQEE7jnUSBoUCN6k7LdlinZs+inEaB0Up2
2cFL7eA2dOHItmwKTKwbzBsjtsOyI59Cax4Fpk/Fi5D2tYMt43r9cCzeJNs7
CUu07TD7rtv+Rjl2/8knuNdMtYHFieyAw5UUWBymDtv0vQ1Gqp/GTNdSgGrf
l+1MuW1w08Dsc2YTBVbrPHnEHNkGvXMyrU5tFFjz7NLavT5tcOUR57QUFt/1
1RyOPLfaoGXPwsZNAxTYtOHHrKBaG6il1++pHcLK45kEU9ETbVAjHy/2fByL
r/3d/lN72kCxy/OczgwFtn88qS27vg3KrHSNuLB47h6laVAea8XL98p4y/9u
fsZzY2TvSwq8MbCVLdzaDZ/cC1pPYuVJeXGxX3BXN3R3MH9RD8fy74mzWzhn
N6wRvZtlgT3f0QdpOOl5uuFgQHX0A6x8qeV75joLdYPSKE9w1AcKUKvTak2I
dcNtGQ+vvDgKJI4+mrsigV0vvNO6GXvetd0ZnlXJd0P2guiN6RQKbGQOOkK8
0A1dF5+qbU6nQHrSrtp4rW6gSRyT4s6igL5sqDmbAXa9jXJHT+dQgL6TY/Mj
025Q1I/g0sSe/9w7kR+W7mDXy11ivPOZAsabDsiaOnZD0E4Nar8SCuyMiOlv
u49d73by1HusfBaL8rsp+HUDvyLPurOhFHhrSbwnH9wLZ/ckHC7H6rPs2BTf
Mr9eMCALX5DF7re6n/uV1P1ecP6aYVeK3W8/W0h8oUMvvAw/GS4dQ4F59a15
RMteSL1bWFocj5VHf/eqT4a9UC0vMyaZTAGuCkqn6NVeGOL4ylSUij3P1KYT
aWq9sIakIi6RicX7RDfhiGIvsH9p0C3E6jeDOxfpkyR6Qez1Za/T2P3ZxZdz
8omh8Skr83X9Z7tQYPJnGFY+2MKu87aLDcBVHcuRQ1j56B+3yK44PQDLD2bH
0rF4xZ66dzZDdgBeZlpPSmD1j6W/V3OU8gCIDs5NV0Vh99sTcDNAbQAamRxI
mtj7YLVwGNlZewCszixTBrHyUu724b6Z/gCcefO47wB2vcrwsenO0h/An+ss
OYPlT+APpfXS+T+ApeVWZB52PS3+BJbYjB+wsl7nf1yP7x//4/8zvLL+9T/+
x/8rXplf8B///9Mr80P+4/89Xplv87+r/zXf1OC/zWnkSdPrlG54kN/dJGVI
IDpvGHK7Q9UDG9d8k401JhDPMvcEu6/tAW+5jEwGMwKR6XBLQsDmHlj/KILH
9haB2AG1xW+YesCz9tHLztsE4nuVitYk5h5Yu8Nuk/QdAvG2XuFk/p4e8NA0
uBdrTSCesMpaV32wB2heq4z9sf7V2vvJrJ0CPeDWJ37F1oFArH72QXhMpAdW
H+Su7nQkEF9Gv5Fbgh5wMWU4Le1CIBpkv7iySboHCMlLSbFuBKLAtyd3mBV7
wIn0Yw/jfQJxocPnAc+FHlgWqw+w9SIQiydcw0U1e+CeUx5Nlw+B6LfaPl1W
rweWPn+4I+1LIF5msvymbtgDDuuDBmL9CESu/ca912/1wKKCizrjEwJxXOTa
3B3rHrD3NymzfUogZspp0nk49sBCg7poVxCBSKVF//FAUT9cN/fLvIfFT86k
8W5DeT9sWG2WaPzHeg8OL0Vdq/oh9qnCu0umBGL7w6uLfA39oMx96JWMOYHI
Hbovr7WlH6YyNwQetSAQLeKGXLy6+iFQ4ceDvZYEYnZOguTRgX443lniSv/H
+pqVVut6hvuh1SLKlgqLp3KHaMWjyX5wpHG/NWpDID4fW34oTu4Hjmd6N1qx
+PYsf1b+sdgPnw+e1inH4nuIzpshcPUAGHxiv5iOxffywbilM1h7/sMWSX3p
NR1wdUcpTyHWnlenOXRDYWcHXF/TrX4a62/RzNMbnTvUASbT8+75WH8raZxi
ogEdYNHNlEzE+ls6/Z3mOqodYF3F1/nHfJu0rSW39fU7wCFHdhNg/a2M6rg7
RtYd4BqjJ5qD9bf0S57a3PLpAM9gh+snsP4W/Sd7+7uhHeDrGRSQjfW3cpL0
HB0SO+DJncR8May/ZfROzsX1cwc8v1Yxmon1J7eHCrh7NXZAqGrfbtFSCnx+
ssPz0c8OiCAuy2RUUOCW17L308UOeH945x2RSgo8gqlihXWdEM8s9CatBrt+
pkFp1dZOSNmgUHW0AesPHWkuO7e7EzLJBosfv1Nga4JCRcPeTsjtdzp4pI0C
Awfzv2gc7oSiumC1lE4KfIoU/tZ6rBNGX52JeBNCgdQibs7j0b3gbVs1ZBqG
3e/MrYqaxF7Yd0FLSPQN1n/lyrI0zuiFAr6ftjRY/yv3AjXrmvxe0N5wt6AK
i2eBu0LJq9JemO9dveEl1v8q+hhofryqF4Jy/VSuY/310r6OnbWNvSAczPJc
EOuvVzAdKDTu6IUqy+jORSy+3yQtjNcM9IKJ0jHuMiy+1VZZTGGjvbD+4Gez
gAwK1EVS5x6f7YXwY8e+feybhjLHOx6yXFREonDBu8DRaSj5eZXrHA8VsZ1f
wfUu6Y/5fBU+awpQEe15m7TUqWagME9Ez+AYFXHXQT2R4+tnIJ9n7yrzE1TE
9H2j9LvoZyA3cMtrmzNURIcN1urWO7qgbnOC7ncjAvE0q+TyNfYuuEBJOOCD
lf+1gvRRKtxd0NCTOC6O1R9fJDvkT/J3gdq3pLRRrP54rBEzdVCkC5rSk++F
YeX9oolN8HZiF2i8SZFUxcr3bmepU9QyXdD88CMttT2B2BnAMDiu1AWXrVNr
P94jECPf/Y/2zvSpqSsM495aC7JUYKhIxKhR0ICIihgdi+9V2dxQB5FSXALa
glTADSMYbNSyW5BFwuaCiCmtLHFhDaAoqIAglUFEEO4luYZIBcQMwbUvX+Qv
aJ3O9OP76czznGd+z/lyzumO6/SgoMOnON33OEH6y/Ls6nZSsH1Dibcp8sLm
YWhHkS8FnbzSufURBPm6x/lkdhAFOzhl/ULkRemwseVpAQXP9MqL5p8iyGO6
9EPhzxTsHC4P60ZerJ5eINgTSUEXJXNITCBIbVshe2s8BfyGCl2HZIJsdFpT
s0pMQXdR5Z/qFIJM+n7yXpvzFHhnVaVJ0gjSM7DHyExCARV7k++ZSZDsE4Wl
2gUU+By+NWf0v3n5mTC+uogCml/9UpaFPM1dq0VXUrBr3e0bgZcIMqjCJL+x
loIeuzvCGRLk1WVtfSc1Dbwencz9yJ/YwlSDjX00BOQSr8ICCHKwbK7xdz00
ZAdpnGOQNx41JSbe7TQ8ses/m4J+VzS5TPVvpmHSO8XQRfR7Vnsb++A9Ghyr
O9YUoN/Rcj+OsIqGo1GPzpej3/0vNebhRTRIXevUd5Ef7iNR3Lg8Gp4b31rX
gnwuG29qLb5Ew7SnxVnd4QQ54+vcBRcyaHDLyh/uiyLI8CnLFucm0hDtm7Nh
BHn8gnOfdzWahirrzOwJ8cgza8/l5SIa1EOJI4aJBFnE611xR0CDVVn0Rjby
d+qqkFUPAmnwFolyLFOxr9ZPdGr9gYYUJ8HbJRkEyWxNW9O1jYYGvcDNq88R
5Hpv7galGw3Eo92Sjein9KfSTYNr0a80r/de6GfsoW0fF3TLwYv7bbMU/Xu5
sODGCUYOP/bwnj1Gfm/uJ/a29Mlh/1nbF+8xv9evbOFYDMlB6GGjmYX5NfGX
tAlG5BBpaDVhLfoZOudN3P2PckistzDaF0yQnfL1jlO/UkBmOGd6igD7/+L5
t3v1FCAB9jwZ+pu985W00kgB0hHTZfRoH05z9DMwVYDs2jdO2phn/3Yx22e6
AmoDDN3miwjygVjVcs1cAc1z9Plb0O+F7vaxE+Yp4CmlHRCK+U42Or3SY5EC
mIwvQy9gvjVN9PBvSxUw4D4ushb99/rVLv/NCgW8nfQuqS+GILksT5vsKgZ2
jQRyr6H+1mCJKrGEgYF7LgQL83OyWZ1zQsrAsVTOExH2/wJrB+8DvzOg6/eu
8Dnq74xKNPPJZiCN1xrlin0VI+9+vDmTAQutQv4NzBOPtElaeYaB663RS81Q
rzwjzHVhHAMrL+8yOIl6E4brJ86MZKAp2F7Zi/20wo1VYyBiYJujyc1NqPdF
vp9oXAgDKuNBcTHqTdUpXj6wnwGBvC6Ijflyy1MfEeJ5JoD1l5UMzzPpO0pm
ifOU4F438/AR5A816Wij9KoS7EO33lyMeri37EMaipVgbhmrM4j7ue/AuNnP
ZUrQb6/akrdv9P/k241EtRLU0a/P7cE+/tgSHmJ2VwnPlnF7zVGfc4TLbF6D
Emp7t9vSuL+Gra6HI06poCY5ffzo/9hzP1SfbotQgZvEY7sW5gcseH9YHldB
d6lxsRrX3+FAlLAqhz+9/1qf4HBHr35sXtoV+fDD47E5Z159x4B8bP7c99X/
n//d+XPfn/+vzf/0fX92SlZOfPDrT++tflG4u6ItYWxui7Iy7IxTwWoxeXA8
8kCrXsfvUJIKnG1Zk5OQR0v0VZW6qSpY1zRUwkEepGdXJC+6ooFTxHzZlEgN
XJf+0uV7VQMs/lOXmHgN/A2zeLuB
   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{9115, 9163, 4358, 8939, 3826, 8732, 7653, 6984, 7029, 9487, 
         7728, 9786, 8763, 7756, 7054, 7093, 9523, 7845, 9805, 8782, 7861, 
         7106, 7139, 9553, 7967, 9811, 8788, 7970, 7976, 7166, 8035, 2359, 
         9576, 9692, 8075, 9712, 3036, 9620, 8095, 2398, 9592, 9728, 8134, 
         9740, 3052, 9632, 8146, 2433, 9600, 9748, 8182, 9751, 3059, 9816, 
         3064, 8462, 8822, 5532, 8835, 4607, 6754, 4647, 8844, 5598, 8848, 
         4660, 6759, 6763, 9045, 5667, 9053, 2931, 9063, 6653, 9055, 1831, 
         9065, 5696, 5705, 4293, 8894, 3775, 8690, 9813, 2937, 9669, 7607, 
         7605, 8805, 7573, 7582, 6516, 8396, 1749, 2037, 8431, 8441, 7556, 
         7564, 7560, 8796, 7513, 2701, 9280, 9755, 3641, 5107, 3637, 5874, 
         8941, 4980, 4975, 8629, 8688, 8524, 8534, 3131, 9818, 3139, 9276, 
         8370, 9274, 9268, 9032, 6291, 9026, 9262, 9013, 6203, 9000, 9249, 
         8982, 6121, 8964, 9231, 3457, 6049, 3434, 5988, 8621, 9445, 9442, 
         9435, 2562, 9663, 8618, 9428, 9417, 9401, 2519, 9652, 8607, 9385, 
         9365, 9340, 6923, 6918, 8587, 8678, 6800, 9315, 6898, 6873, 8578, 
         8664, 3346, 8888, 3881, 9208, 1516}],
        "13"],
       Annotation[#, 13, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1515, 9207, 3880, 8887, 3345, 8663, 8577, 6872, 6897, 9314, 
         6799, 8677, 8586, 6917, 6922, 9339, 9364, 9384, 8606, 9651, 2518, 
         9400, 9416, 9427, 8617, 9662, 2561, 9434, 9441, 9444, 8620, 5987, 
         3433, 6048, 3456, 9230, 8963, 6120, 8981, 9248, 8999, 6202, 9012, 
         9261, 9025, 6290, 9031, 9267, 9273, 8369, 9275, 3138, 9817, 3130, 
         8533, 8523, 8687, 8628, 4974, 4979, 8940, 5873, 3636, 5106, 3640, 
         9754, 9279, 2700, 7512, 8795, 7559, 7563, 7555, 8440, 8430, 2036, 
         1748, 8395, 6515, 7581, 7572, 8804, 7604, 7606, 9668, 2936, 9812, 
         8689, 3774, 8893, 4292, 5704, 5695, 9064, 1830, 9054, 6652, 9062, 
         2930, 9052, 5666, 9044, 1829, 6762, 4659, 8847, 5597, 8843, 4646, 
         6753, 4606, 8834, 5531, 8821, 8461, 3063, 9815, 3058, 9750, 8181, 
         9747, 9599, 2432, 8145, 9631, 3051, 9739, 8133, 9727, 9591, 2397, 
         8094, 9619, 3035, 9711, 8074, 9691, 9575, 2358, 8034, 7165, 7975, 
         7969, 8787, 9810, 7966, 9552, 7138, 7105, 7860, 8781, 9804, 7844, 
         9522, 7092, 7053, 7755, 8762, 9785, 7727, 9486, 7028, 6983, 7652, 
         8731, 3825, 8938, 4357, 9162, 9114}],
        "12.74`"],
       Annotation[#, 12.74, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1514, 9206, 3879, 8886, 3344, 8662, 8576, 6871, 6896, 9313, 
         6798, 8676, 8585, 6916, 6921, 9338, 9363, 9383, 8605, 9650, 2517, 
         9399, 9415, 9426, 8616, 9661, 2560, 9433, 9440, 9443, 8619, 5986, 
         3432, 6047, 3455, 9229, 8962, 6119, 8980, 9247, 8998, 6201, 9011, 
         9260, 9024, 6289, 9030, 9266, 9272, 8368, 8356, 8506, 3137, 8528, 
         8532, 8522, 8686, 8627, 4973, 4978, 5872, 5869, 3635, 5105, 3639, 
         9753, 9278, 2699, 7511, 8794, 7558, 7562, 7554, 8439, 8429, 2035, 
         1747, 8394, 6514, 7580, 7571, 8803, 7614, 2945, 9667, 2935, 3773, 
         5694, 3769, 5716, 8892, 4291, 5703, 4275, 5613, 2086, 1774, 6651, 
         9061, 2929, 9051, 5665, 9043, 1828, 6761, 4658, 8846, 5596, 8842, 
         4645, 6752, 4605, 8833, 5530, 8820, 8460, 3062, 9814, 3057, 9749, 
         8180, 9746, 9598, 2431, 8144, 9630, 3050, 9738, 8132, 9726, 9590, 
         2396, 8093, 9618, 3034, 9710, 8073, 9690, 9574, 2357, 8033, 7164, 
         7974, 7968, 8786, 9809, 7965, 9551, 7137, 7104, 7859, 8780, 9803, 
         7843, 9521, 7091, 7052, 7754, 8761, 9784, 7726, 9485, 7027, 6982, 
         7651, 8730, 3824, 8937, 4356, 9161, 9113}],
        "12.48`"],
       Annotation[#, 12.48, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1513, 9205, 3878, 8885, 3343, 8661, 8575, 6870, 6895, 9312, 
         6797, 8675, 8584, 6915, 6920, 9337, 9362, 9382, 8604, 9649, 2516, 
         9398, 9414, 9425, 8615, 9660, 2559, 9432, 9439, 5985, 7346, 5981, 
         3431, 6046, 3454, 9228, 8961, 6118, 8979, 9246, 8997, 6200, 9010, 
         9259, 9023, 6288, 9029, 9265, 9271, 8367, 8355, 8505, 3136, 8527, 
         8531, 8521, 8685, 8626, 4972, 4977, 5871, 5868, 3634, 5104, 3638, 
         9752, 9277, 2698, 7510, 8793, 7557, 7561, 7553, 8438, 8428, 2034, 
         1746, 8393, 6513, 7579, 7570, 8802, 7613, 2944, 9666, 2934, 3772, 
         5693, 3768, 5715, 8891, 4290, 5702, 4274, 5612, 2085, 1773, 6650, 
         9060, 2928, 9050, 5664, 9042, 1827, 6760, 4657, 8845, 5595, 8841, 
         4644, 6751, 4604, 8832, 5529, 8819, 8459, 4586, 6740, 4546, 3061, 
         8179, 9745, 9597, 2430, 8143, 9629, 3049, 9737, 8131, 9725, 9589, 
         2395, 8092, 9617, 3033, 9709, 8072, 9689, 9573, 2356, 8032, 7163, 
         3013, 7973, 8785, 9808, 7964, 9550, 7136, 7103, 7858, 8779, 9802, 
         7842, 9520, 7090, 7051, 7753, 8760, 9783, 7725, 9484, 7026, 6981, 
         7650, 8729, 3823, 8936, 4355, 9160, 9112}],
        "12.22`"],
       Annotation[#, 12.22, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1512, 9204, 3877, 8884, 3342, 8660, 8574, 6869, 6894, 9311, 
         6796, 8674, 8583, 6914, 6919, 9336, 9361, 9381, 8603, 9648, 2515, 
         9397, 9413, 9424, 8614, 9659, 2558, 9431, 9438, 5984, 7345, 5980, 
         3430, 6045, 3453, 9227, 8960, 6117, 8978, 9245, 8996, 6199, 9009, 
         9258, 9022, 6287, 9028, 9264, 9270, 1703, 8366, 8514, 8504, 3135, 
         8526, 8530, 8520, 8684, 8625, 4971, 4976, 5870, 5867, 3633, 5103, 
         2697, 5008, 2694, 4069, 7509, 8792, 7568, 2771, 7552, 8437, 8427, 
         2033, 1745, 8392, 6512, 7578, 7569, 8801, 7612, 2943, 9665, 2933, 
         3771, 5692, 3767, 5714, 8890, 4289, 5701, 4273, 5611, 2084, 1772, 
         6649, 9059, 2927, 9049, 5663, 9041, 1826, 4656, 6628, 4673, 5603, 
         5594, 8840, 4643, 6750, 4603, 8831, 5528, 8818, 8458, 4585, 6739, 
         4545, 3060, 8178, 9744, 9596, 2429, 8142, 9628, 3048, 9736, 8130, 
         9724, 9588, 2394, 8091, 9616, 3032, 9708, 8071, 9688, 9572, 2355, 
         8031, 7162, 3012, 7972, 8784, 9807, 7963, 9549, 7135, 7102, 7857, 
         8778, 9801, 7841, 9519, 7089, 7050, 7752, 8759, 9782, 7724, 9483, 
         7025, 6980, 7649, 8728, 3822, 8935, 4354, 9159, 9111}],
        "11.96`"],
       Annotation[#, 11.96, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1511, 9203, 3876, 8883, 3341, 8659, 8573, 6868, 6893, 9310, 
         6795, 8673, 8582, 8329, 6948, 7306, 2156, 9335, 9360, 9380, 8602, 
         9647, 2514, 9396, 9412, 9423, 8613, 9658, 2557, 9430, 9437, 5983, 
         7344, 5979, 3429, 6044, 3452, 9226, 8959, 6116, 8977, 9244, 8995, 
         6198, 9008, 9257, 9021, 6286, 9027, 9263, 9269, 1702, 8365, 8513, 
         8503, 3134, 8525, 8529, 8519, 8683, 8624, 6381, 4990, 5861, 2638, 
         5866, 3632, 5102, 2696, 5007, 2693, 4068, 7508, 8791, 7567, 2770, 
         7551, 2761, 8436, 2032, 1744, 8391, 6511, 2784, 7577, 8800, 7611, 
         2942, 9664, 2932, 3770, 5691, 3766, 5713, 8889, 4288, 5700, 4272, 
         5610, 2083, 1771, 6648, 9058, 2926, 9048, 5662, 9040, 1825, 4655, 
         6627, 4672, 5602, 5593, 8839, 4642, 6749, 4602, 8830, 5527, 8817, 
         8457, 4584, 6738, 4544, 8177, 8162, 9743, 9595, 2428, 8141, 9627, 
         3047, 9735, 8129, 9723, 9587, 2393, 8090, 9615, 3031, 9707, 8070, 
         9687, 9571, 2354, 8030, 7161, 3011, 7971, 8783, 9806, 7962, 9548, 
         7134, 7101, 7856, 8777, 9800, 7840, 9518, 7088, 7049, 7751, 8758, 
         9781, 7723, 9482, 7024, 6979, 7648, 8727, 3821, 8934, 4353, 9158, 
         9110}],
        "11.700000000000001`"],
       Annotation[#, 11.700000000000001`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1510, 9202, 3875, 8882, 3340, 8658, 8572, 6867, 6892, 9309, 
         6794, 8672, 8581, 8328, 6947, 7305, 2155, 9334, 9359, 9379, 8601, 
         9646, 2513, 9395, 9411, 9422, 8612, 9657, 2556, 9429, 9436, 5982, 
         7343, 5978, 3428, 6043, 3451, 9225, 8958, 6115, 8976, 9243, 8994, 
         6197, 9007, 9256, 9020, 6285, 6267, 1974, 1689, 6357, 8364, 8512, 
         8502, 3133, 8547, 8540, 3604, 8518, 8682, 8623, 6380, 4989, 5860, 
         2637, 5865, 3631, 5101, 2695, 5006, 2692, 4067, 7507, 8790, 7566, 
         2769, 7550, 2760, 8435, 2031, 8390, 8386, 6510, 2783, 7576, 8799, 
         7610, 4305, 6660, 4262, 2941, 5690, 3765, 5712, 5719, 4287, 5699, 
         4271, 5609, 2082, 6647, 6639, 9057, 2925, 9047, 5661, 9039, 1824, 
         4654, 6626, 4671, 2901, 5601, 8838, 4641, 6748, 4601, 8829, 5526, 
         8816, 8456, 4583, 6737, 4543, 8176, 8161, 9742, 9594, 2427, 8140, 
         9626, 3046, 9734, 8128, 9722, 9586, 2392, 8089, 9614, 3030, 9706, 
         8069, 9686, 9570, 2353, 8029, 7160, 3010, 7961, 8008, 7940, 9547, 
         7133, 7100, 7855, 8776, 9799, 7839, 9517, 7087, 7048, 7750, 8757, 
         9780, 7722, 9481, 7023, 6978, 7647, 8726, 3820, 8933, 4352, 9157, 
         9109}],
        "11.440000000000001`"],
       Annotation[#, 11.440000000000001`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1509, 9201, 3874, 8881, 3339, 8657, 8571, 6866, 6891, 9308, 
         6793, 8671, 8580, 8327, 6946, 7304, 2154, 9333, 9358, 9378, 8600, 
         9645, 2512, 9394, 9410, 9421, 8611, 9656, 3243, 2555, 8218, 2575, 
         7342, 5977, 3427, 6042, 3450, 9224, 8957, 6114, 8975, 9242, 8993, 
         6196, 9006, 9255, 9019, 6284, 6266, 1973, 1688, 6356, 8363, 8511, 
         8501, 3132, 8546, 8539, 3603, 8517, 8681, 8622, 6379, 4988, 5859, 
         2636, 5864, 3630, 5100, 5114, 5005, 2691, 4066, 7506, 8789, 7565, 
         2768, 7549, 2759, 8434, 2030, 8389, 8385, 6509, 2782, 7575, 8798, 
         7609, 4304, 6659, 4261, 2940, 5689, 3764, 5711, 5718, 4286, 5698, 
         4270, 5608, 2081, 6646, 6638, 9056, 2924, 9046, 5660, 9038, 1823, 
         4653, 6625, 4670, 2900, 5600, 8837, 4640, 6747, 4600, 8828, 5525, 
         8815, 8455, 4582, 6736, 4542, 8175, 8160, 9741, 9593, 2426, 8139, 
         9625, 3045, 9733, 8127, 9721, 9585, 2391, 8088, 9613, 3029, 9705, 
         8068, 9685, 9569, 2352, 8028, 7159, 3009, 7960, 8007, 7939, 9546, 
         7132, 7099, 7854, 8775, 9798, 7838, 9516, 7086, 7047, 7749, 8756, 
         9779, 7721, 9480, 7022, 6977, 7646, 8725, 3819, 8932, 4351, 9156, 
         9108}],
        "11.18`"],
       Annotation[#, 11.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1508, 9200, 3873, 8880, 3338, 8656, 8570, 6865, 6890, 9307, 
         6792, 8670, 8579, 8326, 6945, 7303, 2153, 9332, 9357, 9377, 8599, 
         9644, 2511, 9393, 9409, 9420, 8610, 9655, 3242, 2554, 8217, 2574, 
         7341, 5976, 3426, 6041, 3449, 9223, 8956, 6113, 8974, 9241, 8992, 
         6195, 9005, 9254, 9018, 6283, 6265, 1972, 1687, 6355, 8362, 8510, 
         8500, 8545, 8544, 8538, 3602, 8516, 8680, 6378, 6376, 4987, 5858, 
         2635, 5863, 3629, 5099, 5113, 5004, 2690, 5097, 4065, 6506, 4070, 
         2767, 7548, 2758, 8433, 2029, 8388, 8384, 6508, 2781, 7574, 8797, 
         7608, 4303, 6658, 4260, 2939, 5688, 3763, 5710, 5717, 4285, 5697, 
         4269, 5607, 2080, 6645, 3758, 2923, 4242, 2914, 5659, 9037, 1822, 
         4652, 6624, 4669, 2899, 5599, 8836, 4639, 6746, 4599, 8827, 5524, 
         8814, 8454, 4581, 6735, 4541, 8174, 2425, 5469, 2413, 8136, 8138, 
         9624, 3044, 9732, 8126, 9720, 9584, 2390, 8087, 9612, 3028, 9704, 
         8067, 9684, 9568, 2351, 8027, 7158, 3008, 7959, 8006, 7938, 9545, 
         7131, 7098, 7853, 8774, 9797, 7837, 9515, 7085, 7046, 7748, 8755, 
         9778, 7720, 9479, 7021, 6976, 7645, 8724, 3818, 8931, 4350, 9155, 
         9107}],
        "10.92`"],
       Annotation[#, 10.92, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1507, 9199, 3872, 8879, 3337, 8655, 8569, 6864, 6889, 9306, 
         6791, 8669, 8325, 8320, 6944, 7302, 2152, 9331, 9356, 9376, 8598, 
         9643, 2510, 9392, 9408, 9419, 8609, 9654, 3241, 2553, 8216, 2573, 
         7340, 5975, 3425, 6040, 3448, 9222, 8955, 6112, 8973, 9240, 8991, 
         6194, 9004, 9253, 9017, 6282, 6264, 1971, 1686, 6354, 8361, 6362, 
         8509, 8543, 8537, 3601, 8515, 8679, 6377, 6375, 4986, 5857, 2634, 
         5862, 3628, 5098, 5112, 5003, 2689, 5096, 4064, 6505, 6497, 4036, 
         2766, 3679, 8432, 2028, 8387, 8383, 6507, 2780, 4302, 5277, 4301, 
         6667, 6657, 4259, 2938, 5687, 3762, 5709, 2252, 5641, 4284, 5618, 
         5606, 2079, 6644, 3757, 2922, 4241, 2913, 5658, 9036, 1821, 4651, 
         6623, 4668, 2898, 4638, 5585, 4630, 6758, 6745, 4598, 8826, 5523, 
         8813, 8453, 4580, 6734, 4540, 8173, 2424, 5468, 2412, 8135, 8137, 
         9623, 3043, 9731, 8125, 9719, 9583, 2389, 8086, 9611, 3027, 9703, 
         8066, 9683, 9567, 2350, 8026, 7157, 3007, 7958, 8005, 7937, 9544, 
         7130, 7097, 7852, 8773, 9796, 7836, 9514, 7084, 7045, 7747, 8754, 
         9777, 7719, 9478, 7020, 6975, 7644, 8723, 3817, 8930, 4349, 9154, 
         9106}],
        "10.66`"],
       Annotation[#, 10.66, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1506, 9198, 3871, 8878, 3336, 8654, 8568, 6863, 6888, 9305, 
         6790, 8668, 8324, 8319, 6943, 7301, 2151, 9330, 9355, 9375, 8597, 
         9642, 2509, 9391, 9407, 9418, 8608, 9653, 3240, 2552, 8215, 2572, 
         7339, 5974, 3424, 6039, 3447, 9221, 8954, 6111, 8972, 9239, 8990, 
         6193, 9003, 9252, 9016, 1674, 6281, 1970, 1685, 6353, 8360, 6361, 
         8508, 8542, 8536, 7437, 3600, 5840, 3609, 6374, 4985, 5856, 5848, 
         2633, 5060, 2642, 5111, 5002, 2688, 5095, 4063, 6504, 6496, 4035, 
         2765, 5265, 3678, 5285, 2779, 4057, 2775, 5276, 4300, 6666, 6656, 
         4258, 5686, 5680, 3761, 5708, 2251, 5640, 4283, 5617, 5605, 2078, 
         6643, 3756, 2921, 4240, 2912, 5657, 9035, 1820, 4650, 6622, 4667, 
         2897, 4637, 5584, 4629, 6757, 6744, 4597, 8825, 5522, 8812, 8452, 
         4579, 6733, 4539, 8172, 2423, 5467, 2411, 8159, 3056, 9622, 3042, 
         9730, 8124, 9718, 9582, 2388, 8085, 9610, 3026, 9702, 8065, 9682, 
         9566, 2349, 8025, 7156, 3006, 7957, 8004, 7936, 9543, 7129, 7096, 
         7851, 8772, 9795, 7835, 9513, 7083, 7044, 7746, 8753, 9776, 7718, 
         9477, 7019, 6974, 7643, 8722, 3816, 8929, 4348, 9153, 9105}],
        "10.4`"],
       Annotation[#, 10.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1505, 9197, 3870, 8877, 3335, 8653, 8567, 6862, 6887, 9304, 
         6789, 8667, 8323, 8318, 6942, 7300, 2150, 9329, 9354, 9374, 8596, 
         9641, 2508, 9390, 9406, 3239, 4824, 3234, 4878, 2551, 8214, 2571, 
         7338, 5973, 3423, 6038, 3446, 9220, 8953, 6110, 8971, 9238, 8989, 
         6192, 9002, 9251, 9015, 1673, 6280, 1969, 1684, 6352, 8359, 6360, 
         8507, 8541, 8535, 7436, 3599, 5839, 3608, 6373, 4984, 5855, 5847, 
         2632, 5059, 2641, 5110, 5001, 5094, 5091, 4062, 6503, 6495, 4034, 
         2764, 5264, 3677, 5284, 2778, 4056, 2774, 5275, 4299, 6665, 6655, 
         4257, 5685, 5679, 3760, 5707, 2250, 5639, 4282, 5616, 5604, 2077, 
         6642, 3755, 2920, 4239, 5656, 5648, 9034, 1819, 4649, 6621, 4666, 
         2896, 4636, 5583, 4628, 1817, 6756, 4596, 8824, 5521, 8811, 8451, 
         4578, 6732, 4538, 8171, 2422, 5466, 2410, 8158, 3055, 9621, 3041, 
         9729, 8123, 9717, 9581, 2387, 8084, 9609, 3025, 9701, 8064, 9681, 
         9565, 2348, 8024, 7155, 3005, 7956, 8003, 7935, 9542, 7128, 7095, 
         7850, 8771, 9794, 7834, 9512, 7082, 7043, 7745, 8752, 9775, 7717, 
         9476, 7018, 6973, 7642, 8721, 3815, 8928, 4347, 9152, 9104}],
        "10.14`"],
       Annotation[#, 10.14, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1504, 9196, 3869, 8876, 3334, 8652, 8566, 6861, 6886, 9303, 
         6788, 8666, 8322, 8317, 6941, 7299, 2149, 9328, 9353, 9373, 8595, 
         9640, 2507, 9389, 9405, 3238, 4823, 3233, 4877, 2550, 8213, 2570, 
         7337, 5972, 3422, 6037, 3445, 9219, 8952, 6109, 8970, 9237, 8988, 
         6191, 9001, 9250, 9014, 1672, 6279, 1968, 1683, 6351, 8358, 6359, 
         7435, 7443, 7433, 3598, 5838, 3607, 6372, 4983, 5854, 5846, 2631, 
         5058, 2640, 5109, 5000, 5093, 5090, 4061, 6502, 6494, 4033, 2763, 
         5263, 3676, 5283, 2777, 4055, 2773, 5274, 4298, 6664, 6654, 4256, 
         5684, 5678, 3759, 5706, 2249, 5638, 4281, 2907, 5615, 2076, 6641, 
         3754, 2919, 4238, 5655, 5647, 9033, 1818, 4648, 6620, 4665, 2895, 
         4635, 5582, 4627, 1816, 6755, 4595, 8823, 5520, 8810, 8450, 4577, 
         6731, 4537, 8170, 2421, 5465, 2409, 8157, 4522, 6721, 4490, 3054, 
         8122, 9716, 9580, 2386, 8083, 9608, 3024, 9700, 8063, 9680, 9564, 
         2347, 8023, 7154, 3004, 7955, 8002, 7934, 9541, 7127, 7094, 7849, 
         8770, 9793, 7833, 9511, 7081, 7042, 7744, 8751, 9774, 7716, 9475, 
         7017, 6972, 7641, 8720, 3814, 8927, 4346, 9151, 9103}],
        "9.88`"],
       Annotation[#, 9.88, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1503, 9195, 3868, 8875, 3333, 8651, 8565, 6860, 6885, 9302, 
         6787, 8665, 8321, 8316, 6940, 7298, 2148, 9327, 9352, 9372, 8594, 
         9639, 2506, 9388, 9404, 3237, 4822, 3232, 4876, 2549, 8212, 2569, 
         7336, 5971, 3421, 6036, 3444, 9218, 8951, 6108, 8969, 9236, 8987, 
         6190, 6176, 1938, 1652, 3572, 6278, 1967, 1682, 6350, 8357, 6358, 
         7434, 7442, 7432, 3597, 5837, 3606, 6371, 4982, 3148, 5853, 2630, 
         5057, 2639, 5108, 4999, 5092, 5089, 4060, 1743, 6501, 4032, 2762, 
         5262, 3675, 5282, 2776, 4054, 2772, 5273, 4297, 1778, 6663, 4255, 
         5683, 2248, 5249, 2245, 5634, 5637, 4280, 2906, 5614, 2075, 6640, 
         3753, 2918, 4237, 5654, 4224, 5544, 2074, 1767, 6619, 4664, 2894, 
         4634, 5581, 4626, 1815, 4594, 6603, 4618, 5536, 5519, 8809, 8449, 
         4576, 6730, 4536, 8169, 2420, 5464, 2408, 8156, 4521, 6720, 4489, 
         3053, 8121, 9715, 9579, 2385, 8082, 9607, 3023, 9699, 8062, 9679, 
         9563, 2346, 8022, 7153, 3003, 7954, 8001, 7933, 9540, 2318, 7910, 
         7126, 7867, 7848, 8769, 9792, 7832, 9510, 7080, 7041, 7743, 8750, 
         9773, 7715, 9474, 7016, 6971, 7640, 8719, 3813, 8926, 4345, 9150, 
         9102}],
        "9.620000000000001`"],
       Annotation[#, 9.620000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1502, 9194, 3867, 8874, 3332, 8650, 8564, 6859, 6884, 9301, 
         6786, 7267, 6816, 8315, 6939, 7297, 2147, 9326, 9351, 9371, 8593, 
         9638, 2505, 9387, 9403, 3236, 4821, 3231, 4875, 2548, 8211, 2568, 
         7335, 5970, 3420, 6035, 3443, 9217, 8950, 6107, 8968, 9235, 8986, 
         6189, 6175, 1937, 1651, 3571, 6277, 1966, 1681, 6369, 7420, 7439, 
         7441, 7431, 3596, 5836, 3605, 6370, 4981, 3147, 5852, 2629, 5056, 
         5062, 4998, 5047, 4992, 5088, 4059, 1742, 6500, 4031, 5261, 5258, 
         3674, 5281, 5289, 4053, 5272, 5268, 4296, 1777, 6662, 4254, 5682, 
         2247, 5248, 2244, 5633, 5636, 4279, 2905, 3752, 5631, 3748, 5675, 
         2917, 4236, 5653, 4223, 5543, 2073, 1766, 6618, 4663, 2893, 4633, 
         5580, 4625, 1814, 4593, 6602, 4617, 5535, 5518, 8808, 8448, 4575, 
         6729, 4535, 8168, 2419, 5463, 2407, 8155, 4520, 6719, 4488, 8120, 
         8108, 9714, 9578, 2384, 8081, 9606, 3022, 9698, 8061, 9678, 9562, 
         2345, 8021, 7152, 3002, 7953, 8000, 7932, 9539, 2317, 7909, 7125, 
         7866, 7847, 8768, 9791, 7831, 9509, 7079, 7040, 7742, 8749, 9772, 
         7714, 9473, 7015, 6970, 7639, 8718, 3812, 8925, 4344, 9149, 9101}],
        "9.36`"],
       Annotation[#, 9.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1501, 9193, 3866, 8873, 3331, 8649, 8563, 6858, 6883, 9300, 
         6785, 7266, 6815, 8314, 6938, 7296, 2146, 9325, 9350, 9370, 8592, 
         9637, 2504, 9386, 9402, 3235, 4820, 3230, 4874, 2547, 8210, 2567, 
         7334, 5969, 3419, 6034, 3442, 9216, 8949, 6106, 8967, 9234, 8985, 
         6188, 6174, 1936, 1650, 3570, 6276, 1965, 1680, 6368, 7419, 7438, 
         7440, 7430, 3595, 5835, 3146, 4934, 3144, 4968, 5851, 2628, 5055, 
         5061, 4997, 5046, 4991, 5087, 4058, 1741, 6499, 4030, 5260, 5257, 
         3673, 5280, 5288, 4052, 5271, 5267, 4295, 1776, 6661, 4253, 5681, 
         2246, 5247, 2243, 5632, 5635, 4278, 2904, 3751, 5630, 3747, 5674, 
         2916, 4235, 5652, 4222, 5542, 2072, 6617, 6610, 4662, 2892, 4632, 
         5579, 4624, 1813, 4592, 6601, 4616, 2873, 5534, 8807, 8447, 4574, 
         6728, 4534, 8167, 2418, 5462, 2406, 8154, 4519, 6718, 4487, 8119, 
         8107, 9713, 9577, 2383, 8080, 9605, 3021, 9697, 8060, 9677, 9561, 
         2344, 8020, 7151, 3001, 7952, 7999, 7931, 9538, 2316, 7908, 7124, 
         7865, 7846, 8767, 9790, 7830, 9508, 7078, 7039, 7741, 8748, 9771, 
         7713, 9472, 7014, 6969, 7638, 8717, 3811, 8924, 4343, 9148, 9100}],
        "9.1`"],
       Annotation[#, 9.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1500, 9192, 3865, 8872, 3330, 8648, 8562, 6857, 6882, 9299, 
         6784, 7265, 6814, 8313, 6937, 7295, 2145, 9324, 9349, 9369, 8591, 
         9636, 3199, 2503, 5764, 2529, 4819, 3229, 4873, 2546, 8209, 2566, 
         7333, 5968, 3418, 6033, 3441, 9215, 8948, 6105, 8966, 9233, 8984, 
         1639, 6187, 1935, 1649, 3569, 6275, 1964, 1679, 6367, 7418, 7447, 
         2617, 7429, 3594, 5834, 3145, 4933, 3143, 4967, 5850, 2627, 5064, 
         2680, 4996, 5045, 5039, 2004, 1721, 4028, 6498, 4029, 5259, 5256, 
         3672, 5279, 5287, 4051, 5270, 5266, 4294, 1775, 4252, 6493, 4268, 
         5254, 5246, 2242, 5646, 2911, 4277, 2903, 3750, 5629, 3746, 5673, 
         2915, 4234, 5651, 4221, 5541, 2071, 6616, 6609, 4661, 2891, 4631, 
         5578, 4623, 1812, 4591, 6600, 4615, 2872, 5533, 8806, 8446, 4573, 
         6727, 4533, 8166, 2417, 5461, 2405, 8153, 4518, 6717, 4486, 8118, 
         2382, 5416, 2372, 8077, 8079, 9604, 3020, 9696, 8059, 9676, 9560, 
         2343, 8019, 7150, 3000, 7951, 7998, 7930, 9537, 2315, 7907, 7123, 
         2986, 7864, 8766, 9789, 7829, 9507, 7077, 7038, 7740, 8747, 9770, 
         7712, 9471, 7013, 6968, 7637, 8716, 3810, 8923, 4342, 9147, 9099}],
        "8.84`"],
       Annotation[#, 8.84, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1499, 9191, 3864, 8871, 3329, 8647, 8561, 6856, 6881, 9298, 
         6783, 7264, 6813, 8312, 6936, 7294, 2144, 9323, 9348, 9368, 8590, 
         9635, 3198, 2502, 5763, 2528, 4818, 3228, 4872, 2545, 8208, 2565, 
         7332, 5967, 3417, 6032, 3440, 9214, 8947, 6104, 8965, 9232, 8983, 
         1638, 6186, 1934, 1648, 3568, 6274, 1963, 1678, 6366, 7417, 7446, 
         2616, 7428, 3593, 5833, 5845, 4932, 3142, 4966, 5849, 2626, 5063, 
         2679, 4995, 5044, 5038, 2003, 1720, 6433, 4042, 5086, 2189, 5255, 
         3671, 5278, 5286, 4050, 5269, 4043, 5215, 2027, 1740, 6492, 4267, 
         5253, 5245, 2241, 5645, 2910, 4276, 2902, 3749, 5628, 3745, 5672, 
         5677, 4233, 5650, 4220, 5540, 2070, 6615, 3740, 2890, 4199, 2883, 
         5577, 4622, 1811, 4590, 6599, 4614, 2871, 4572, 5511, 4565, 6743, 
         6726, 4532, 8165, 2416, 5460, 2404, 8152, 4517, 6716, 4485, 8117, 
         2381, 5415, 2371, 8076, 8078, 9603, 3019, 9695, 8058, 9675, 9559, 
         2342, 8018, 7149, 2999, 7950, 7997, 7929, 9536, 2314, 7906, 7122, 
         2985, 7863, 8765, 9788, 7828, 9506, 7076, 7037, 7739, 8746, 9769, 
         7711, 9470, 7012, 6967, 7636, 8715, 3809, 8922, 4341, 9146, 9098}],
        "8.58`"],
       Annotation[#, 8.58, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1498, 9190, 3863, 8870, 3328, 8646, 8560, 6855, 6880, 9297, 
         6782, 7263, 6812, 8311, 6935, 7293, 2143, 9322, 9347, 9367, 8589, 
         9634, 3197, 2501, 5762, 2527, 4817, 3227, 4871, 2544, 8207, 2564, 
         7331, 5966, 3416, 6031, 3439, 9213, 8946, 6103, 6090, 1909, 1620, 
         3527, 6185, 1933, 1647, 3567, 6273, 1962, 1677, 6365, 7416, 7445, 
         7410, 2615, 7425, 2621, 5844, 4931, 3141, 5832, 4965, 6425, 4970, 
         2678, 4994, 2672, 5043, 2002, 1719, 6432, 4041, 5085, 5079, 2188, 
         5223, 5226, 4049, 5220, 5214, 2026, 1739, 6491, 4266, 2757, 5252, 
         2240, 5644, 4251, 6633, 4214, 2909, 5627, 3744, 5671, 5676, 4232, 
         5649, 4219, 5539, 2069, 6614, 3739, 2889, 4198, 2882, 5576, 4621, 
         1810, 4589, 6598, 4613, 2870, 4571, 5510, 4564, 6742, 6725, 4531, 
         8164, 2415, 5459, 2403, 8151, 4516, 6715, 4484, 8116, 2380, 5414, 
         2370, 8106, 3040, 9602, 3018, 9694, 8057, 9674, 9558, 2341, 8017, 
         7148, 2998, 7949, 7996, 7928, 9535, 2313, 7905, 7121, 2984, 7862, 
         8764, 9787, 7827, 9505, 7075, 7036, 7738, 8745, 9768, 7710, 9469, 
         7011, 6966, 7635, 8714, 3808, 8921, 4340, 9145, 9097}],
        "8.32`"],
       Annotation[#, 8.32, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1497, 9189, 3862, 8869, 3327, 8645, 8559, 6854, 6879, 9296, 
         6781, 7262, 6811, 8310, 6934, 7292, 2142, 9321, 9346, 9366, 8588, 
         9633, 3196, 2500, 5761, 2526, 4816, 3226, 4870, 2543, 8206, 2563, 
         7330, 5965, 3415, 6030, 3438, 9212, 8945, 6102, 6089, 1908, 1619, 
         3526, 6184, 1932, 1646, 3566, 6272, 1961, 1676, 6364, 7415, 7444, 
         7409, 2614, 7424, 2620, 5843, 4930, 3140, 5831, 4964, 6424, 4969, 
         2677, 4993, 2671, 5042, 2001, 1718, 6431, 4040, 5084, 5078, 2187, 
         5222, 5225, 4048, 5219, 5213, 2025, 1738, 6490, 4265, 2756, 5251, 
         2239, 5643, 4250, 6632, 4213, 2908, 5626, 3743, 5670, 2237, 5563, 
         4231, 5547, 5538, 2068, 6613, 3738, 2888, 4197, 5575, 5569, 4620, 
         1809, 4588, 6597, 4612, 2869, 4570, 5509, 4563, 1807, 6741, 4530, 
         8163, 2414, 5458, 2402, 8150, 4515, 6714, 4483, 8115, 2379, 5413, 
         2369, 8105, 3039, 9601, 3017, 9693, 8056, 9673, 9557, 2340, 8016, 
         7147, 2997, 7948, 7995, 7927, 9534, 2312, 7904, 7120, 2983, 7826, 
         7889, 7812, 9504, 7074, 7035, 7737, 8744, 9767, 7709, 9468, 7010, 
         6965, 7634, 8713, 3807, 8920, 4339, 9144, 9096}],
        "8.06`"],
       Annotation[#, 8.06, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1496, 9188, 3861, 8868, 3326, 8644, 8558, 6853, 6878, 9295, 
         6780, 7261, 6810, 8309, 6933, 7291, 2141, 9320, 9345, 3195, 3961, 
         3190, 4793, 2499, 5760, 2525, 4815, 3225, 4869, 2542, 8205, 8220, 
         7329, 8203, 7320, 5964, 3414, 6029, 3437, 9211, 8944, 1609, 6101, 
         1907, 1618, 3525, 6183, 1931, 1645, 3565, 6271, 1960, 1675, 6363, 
         6303, 7414, 8418, 2613, 7423, 2619, 5842, 4929, 5830, 5828, 4963, 
         6423, 6417, 4947, 2676, 3626, 5041, 2000, 6430, 6428, 4039, 5083, 
         5077, 2186, 5221, 5224, 4047, 5218, 5212, 2024, 6489, 6486, 4264, 
         2755, 5250, 2238, 5642, 4249, 6631, 4212, 5625, 5620, 3742, 5669, 
         2236, 5562, 4230, 5546, 5537, 2067, 6612, 3737, 2887, 4196, 5574, 
         5568, 4619, 1808, 4587, 6596, 4611, 2868, 4569, 5508, 4562, 1806, 
         4529, 6582, 4555, 5472, 5457, 2401, 8149, 4514, 6713, 4482, 8114, 
         2378, 5412, 2368, 8104, 4471, 6706, 4446, 3038, 8055, 9672, 9556, 
         2339, 8015, 7146, 2996, 7947, 7994, 7926, 9533, 2311, 7903, 7119, 
         2982, 7825, 7888, 7811, 9503, 7073, 7034, 7736, 8743, 9766, 7708, 
         9467, 7009, 6964, 7633, 8712, 3806, 8919, 4338, 9143, 9095}],
        "7.800000000000001`"],
       Annotation[#, 7.800000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1495, 9187, 3860, 8867, 3325, 8643, 8557, 6852, 6877, 9294, 
         6779, 7260, 6809, 8308, 6932, 7290, 2140, 9319, 9344, 3194, 3960, 
         3189, 4792, 2498, 5759, 2524, 4814, 3224, 4868, 2541, 8204, 8219, 
         7328, 8202, 7319, 5963, 3413, 6028, 3436, 9210, 8943, 1608, 6100, 
         1906, 1617, 3524, 6182, 1930, 1644, 3564, 6270, 1959, 6302, 6299, 
         6343, 7413, 8417, 2612, 7422, 2618, 5841, 4928, 5829, 5827, 4962, 
         6422, 6416, 4946, 2675, 3625, 5040, 1999, 6429, 6427, 4038, 2687, 
         5082, 2185, 5229, 2748, 4046, 2743, 5217, 2023, 6488, 6485, 4263, 
         2754, 4248, 5237, 4247, 6637, 6630, 4211, 5624, 5619, 3741, 5668, 
         2235, 5561, 4229, 2878, 5545, 2066, 6611, 3736, 2886, 4195, 5573, 
         4185, 5478, 2065, 1762, 6595, 4610, 2867, 4568, 5507, 4561, 1805, 
         4528, 6581, 4554, 5471, 5456, 2400, 8148, 4513, 6712, 4481, 8113, 
         2377, 5411, 2367, 8103, 4470, 6705, 4445, 3037, 8054, 9671, 9555, 
         2338, 8014, 7145, 2995, 7946, 7993, 7925, 9532, 2310, 7902, 7118, 
         2981, 7824, 7887, 7810, 9502, 7072, 7033, 7735, 8742, 9765, 7707, 
         9466, 7008, 6963, 7632, 8711, 3805, 8918, 4337, 9142, 9094}],
        "7.54`"],
       Annotation[#, 7.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1494, 9186, 3859, 8866, 3324, 8642, 8556, 6851, 6876, 9293, 
         6778, 7259, 6808, 8307, 6931, 7289, 2139, 9318, 9343, 3193, 3959, 
         3188, 4791, 2497, 5758, 2523, 4813, 3223, 4867, 2540, 8221, 3101, 
         7327, 8201, 7318, 5962, 3412, 6027, 3435, 9209, 8942, 1607, 6099, 
         1905, 1616, 3523, 6181, 1929, 1643, 3563, 6269, 1958, 6301, 6298, 
         6342, 7412, 8416, 8419, 7421, 7426, 4927, 5810, 4925, 5826, 4961, 
         1717, 6421, 4945, 2674, 5054, 3624, 5074, 3627, 6426, 4037, 2686, 
         5081, 2184, 5228, 2747, 4045, 2742, 5216, 2022, 6487, 3670, 2753, 
         4022, 2750, 5236, 4246, 6636, 6629, 4210, 5623, 2234, 5208, 2231, 
         5558, 5560, 4228, 2877, 3735, 5556, 3731, 5591, 2885, 4194, 5572, 
         4184, 5477, 2064, 6594, 6588, 4609, 2866, 4567, 5506, 4560, 1804, 
         4527, 6580, 4553, 2851, 5470, 2399, 8147, 4512, 6711, 4480, 8112, 
         2376, 5410, 2366, 8102, 4469, 6704, 4444, 8053, 8044, 9670, 9554, 
         2337, 8013, 7144, 2994, 7945, 7992, 7924, 9531, 2309, 7901, 7117, 
         2980, 7823, 7886, 7809, 9501, 7071, 7032, 7734, 8741, 9764, 7706, 
         9465, 7007, 6962, 7631, 8710, 3804, 8917, 4336, 9141, 9093}],
        "7.28`"],
       Annotation[#, 7.28, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1493, 9185, 3858, 8865, 3323, 8641, 8555, 6850, 6875, 9292, 
         6777, 7258, 6807, 8306, 6930, 7288, 2138, 9317, 9342, 3192, 3958, 
         3187, 4790, 2496, 5757, 2522, 4812, 3222, 4866, 5957, 4884, 3100, 
         7326, 8200, 7317, 5961, 3411, 6026, 6016, 1885, 1596, 3489, 6098, 
         1904, 1615, 3522, 6180, 1928, 1642, 3562, 6268, 1957, 6300, 6297, 
         6341, 7411, 8415, 7427, 8495, 8497, 8270, 4926, 5809, 4924, 5825, 
         4960, 1716, 6420, 4944, 2673, 5053, 3623, 5073, 2685, 4959, 2683, 
         4027, 5080, 2183, 5227, 2746, 4044, 2741, 3669, 7547, 3668, 5242, 
         2752, 4021, 2749, 5235, 4245, 1770, 6635, 4209, 5622, 2233, 5207, 
         2230, 5557, 5559, 4227, 2876, 3734, 5555, 3730, 5590, 2884, 4193, 
         5571, 4183, 5476, 2063, 6593, 6587, 4608, 2865, 4566, 5505, 4559, 
         1803, 4526, 6579, 4552, 2850, 4511, 5450, 4505, 6724, 6710, 4479, 
         8111, 2375, 5409, 2365, 8101, 4468, 6703, 4443, 8052, 2336, 5374, 
         2328, 8010, 8012, 7143, 2993, 7944, 7991, 7923, 9530, 2308, 7900, 
         7116, 2979, 7822, 7885, 7808, 9500, 7070, 7031, 7733, 8740, 9763, 
         7705, 9464, 7006, 6961, 7630, 8709, 3803, 8916, 4335, 9140, 9092}],
        "7.0200000000000005`"],
       Annotation[#, 7.0200000000000005`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1492, 9184, 3857, 8864, 3322, 8640, 8554, 6849, 6874, 9291, 
         6776, 7257, 6806, 8305, 6929, 7287, 2137, 9316, 9341, 3191, 3957, 
         3186, 4789, 2495, 5756, 2521, 4811, 3221, 4865, 5956, 4883, 3099, 
         7325, 8199, 7316, 5960, 3410, 6025, 6015, 1884, 1595, 3488, 6097, 
         1903, 1614, 3521, 6179, 1927, 1641, 6212, 3561, 6257, 3577, 6296, 
         6340, 8354, 6345, 8494, 8496, 8498, 8269, 8271, 5808, 5804, 1986, 
         1701, 4941, 6419, 4943, 5052, 5050, 3622, 5072, 2684, 4958, 2682, 
         5069, 4026, 6484, 6480, 6412, 2745, 7546, 3667, 5241, 2751, 4020, 
         5234, 5231, 4244, 1769, 6634, 4208, 5621, 2232, 5206, 2229, 5567, 
         2881, 4226, 2875, 3733, 5554, 3729, 5589, 5592, 4192, 5570, 4182, 
         5475, 2062, 6592, 3725, 2864, 4165, 2859, 5504, 4558, 1802, 4525, 
         6578, 4551, 2849, 4510, 5449, 4504, 6723, 6709, 4478, 8110, 2374, 
         5408, 2364, 8100, 4467, 6702, 4442, 8051, 2335, 5373, 2327, 8009, 
         8011, 7142, 2992, 7943, 7990, 7922, 9529, 2307, 7899, 7115, 2978, 
         7821, 7884, 7807, 9499, 7069, 7030, 7732, 8739, 9762, 7704, 9463, 
         7005, 6960, 7629, 8708, 3802, 8915, 4334, 9139, 9091}],
        "6.76`"],
       Annotation[#, 6.76, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1491, 9183, 3856, 8863, 3321, 8639, 8553, 8296, 6913, 7228, 
         2117, 9290, 6775, 7256, 6805, 8304, 6928, 7286, 7276, 2136, 4750, 
         2163, 3956, 3185, 4788, 2494, 5755, 2520, 4810, 3220, 4864, 5955, 
         4882, 3098, 7324, 8198, 7315, 5959, 3409, 1587, 7361, 6024, 6830, 
         1883, 1594, 3487, 6096, 1902, 1613, 3520, 6178, 1926, 1640, 6211, 
         3560, 6256, 3576, 6295, 6339, 8353, 6344, 8493, 8499, 3125, 8268, 
         3122, 8264, 5807, 1985, 1700, 4940, 6418, 4942, 5051, 5049, 3621, 
         5071, 5076, 4957, 2681, 5068, 4025, 6483, 6479, 6411, 2744, 7545, 
         3666, 5240, 5244, 4019, 5233, 5230, 4243, 1768, 4207, 6478, 4218, 
         5211, 5205, 2228, 5566, 2880, 4225, 2874, 3732, 5553, 3728, 5588, 
         2225, 5493, 4191, 5481, 5474, 2061, 6591, 3724, 2863, 4164, 5503, 
         5498, 4557, 1801, 4524, 6577, 4550, 2848, 4509, 5448, 4503, 1799, 
         6722, 4477, 8109, 2373, 5407, 2363, 8099, 4466, 6701, 4441, 8050, 
         2334, 5372, 2326, 8043, 3016, 7141, 2991, 7942, 7989, 7921, 9528, 
         2306, 7898, 7114, 2977, 7820, 7883, 7806, 9498, 2287, 7791, 7068, 
         7762, 7731, 8738, 9761, 7703, 9462, 7004, 6959, 7628, 8707, 3801, 
         8914, 4333, 9138, 9090}],
        "6.5`"],
       Annotation[#, 6.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1490, 9182, 3855, 8862, 3320, 8638, 8552, 8295, 6912, 7227, 
         2116, 9289, 6774, 7255, 6804, 8303, 6927, 7285, 7275, 2135, 4749, 
         2162, 3955, 3184, 4787, 2493, 5754, 5765, 4809, 5749, 4802, 3219, 
         4863, 5954, 4881, 3097, 7323, 8197, 7314, 5958, 3408, 1586, 7360, 
         6023, 6829, 1882, 1593, 3486, 6095, 1901, 1612, 3519, 6177, 1925, 
         6210, 6209, 3559, 6255, 3575, 6294, 6338, 8352, 8492, 8490, 3124, 
         8267, 3121, 8263, 5806, 1984, 1699, 6349, 4950, 5824, 2625, 5048, 
         3620, 5070, 5075, 4956, 5067, 5066, 4024, 1737, 6482, 6410, 7544, 
         7542, 3665, 5239, 5243, 4018, 5232, 4013, 5179, 2021, 1735, 6477, 
         4217, 2740, 5210, 2227, 5565, 4206, 6606, 4177, 2879, 5552, 3727, 
         5587, 2224, 5492, 4190, 5480, 5473, 2060, 6590, 3723, 2862, 4163, 
         5502, 5497, 4556, 1800, 4523, 6576, 4549, 2847, 4508, 5447, 4502, 
         1798, 4476, 6565, 4497, 5419, 5406, 2362, 8098, 4465, 6700, 4440, 
         8049, 2333, 5371, 2325, 8042, 3015, 7140, 2990, 7941, 7988, 7920, 
         9527, 2305, 7897, 7113, 2976, 7819, 7882, 7805, 9497, 2286, 7790, 
         7067, 7761, 7730, 8737, 9760, 7702, 9461, 7003, 6958, 7627, 8706, 
         3800, 8913, 4332, 9137, 9089}],
        "6.24`"],
       Annotation[#, 6.24, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1489, 9181, 3854, 8861, 3319, 8637, 8551, 8294, 6911, 7226, 
         2115, 9288, 6773, 7254, 6803, 8302, 6926, 7284, 7274, 2134, 4748, 
         2161, 3954, 3183, 4786, 2492, 5767, 3081, 4808, 5748, 4801, 3218, 
         4862, 5953, 4880, 3096, 7322, 8196, 8191, 1870, 1572, 7355, 7359, 
         6022, 6828, 1881, 1592, 3485, 6094, 1900, 1611, 6130, 3518, 6169, 
         3532, 6208, 3558, 6254, 3574, 6293, 6337, 8351, 8491, 8348, 8485, 
         3123, 8489, 8266, 3591, 5805, 1983, 6348, 6347, 4949, 5823, 5820, 
         2624, 5034, 5036, 4955, 5028, 4951, 5065, 4023, 1736, 6481, 6409, 
         7543, 7541, 3664, 5238, 2182, 5190, 4017, 5182, 5178, 2020, 1734, 
         6476, 4216, 2739, 5209, 2226, 5564, 4205, 6605, 4176, 5551, 5548, 
         3726, 5586, 2223, 5491, 4189, 2855, 5479, 2059, 6589, 3722, 2861, 
         4162, 5501, 4155, 5423, 2058, 1759, 6575, 4548, 2846, 4507, 5446, 
         4501, 1797, 4475, 6564, 4496, 2835, 5418, 2361, 8097, 4464, 6699, 
         4439, 8048, 2332, 5370, 2324, 8041, 4431, 6693, 4411, 3014, 7987, 
         7919, 9526, 2304, 7896, 7112, 2975, 7818, 7881, 7804, 9496, 2285, 
         7789, 7066, 7760, 7729, 8736, 9759, 7701, 9460, 7002, 6957, 7626, 
         8705, 3799, 8912, 4331, 9136, 9088}],
        "5.98`"],
       Annotation[#, 5.98, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1488, 9180, 3853, 8860, 3318, 8636, 8550, 8293, 6910, 7225, 
         2114, 9287, 6772, 7253, 6802, 8301, 6925, 2471, 7283, 2133, 4747, 
         2160, 3953, 3182, 4785, 2491, 5766, 3080, 4807, 5747, 4800, 3217, 
         4861, 5952, 4879, 3095, 7321, 3090, 8195, 1869, 1571, 7354, 7358, 
         6021, 6827, 1880, 1591, 3484, 6093, 1899, 1610, 6129, 3517, 6168, 
         3531, 6207, 3557, 6253, 3573, 6292, 6336, 1698, 8350, 8486, 8484, 
         8488, 8487, 8265, 7404, 3590, 5817, 3592, 6346, 4948, 3129, 5822, 
         2623, 5033, 5035, 4954, 5027, 5024, 1998, 1715, 8379, 6415, 7505, 
         7502, 2181, 5188, 5189, 4016, 5181, 5177, 2019, 6475, 6473, 4215, 
         2738, 4204, 5199, 4203, 6608, 6604, 4175, 5550, 2222, 5174, 2220, 
         5489, 5490, 4188, 2854, 3721, 5488, 3718, 5516, 2860, 4161, 5500, 
         4154, 5422, 2057, 6574, 6570, 4547, 2845, 4506, 5445, 4500, 1796, 
         4474, 6563, 4495, 2834, 5417, 2360, 8096, 4463, 6698, 4438, 8047, 
         2331, 5369, 2323, 8040, 4430, 6692, 4410, 7986, 7978, 7918, 9525, 
         2303, 7895, 7111, 2974, 7817, 7880, 7803, 9495, 2284, 7788, 7065, 
         2966, 7759, 8735, 9758, 7700, 9459, 7001, 6956, 7625, 8704, 3798, 
         8911, 4330, 9135, 9087}],
        "5.720000000000001`"],
       Annotation[#, 5.720000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1487, 9179, 3852, 8859, 3317, 8635, 8549, 8292, 6909, 7224, 
         2113, 9286, 6771, 7252, 6801, 8300, 6924, 2470, 7282, 2132, 4746, 
         2159, 3952, 3181, 4784, 5928, 4797, 3079, 4806, 5746, 4799, 3216, 
         4860, 5951, 5946, 4848, 3094, 3399, 8194, 1868, 1570, 7353, 7357, 
         6020, 6826, 6833, 1590, 3483, 6092, 1898, 6128, 6126, 3516, 6167, 
         3530, 6206, 3556, 6252, 6246, 1956, 1671, 6331, 8349, 6332, 7403, 
         7407, 7402, 3589, 5816, 3128, 4916, 3127, 4938, 5821, 2622, 5037, 
         2665, 4953, 2662, 5026, 1997, 1714, 8378, 6414, 7504, 7501, 2180, 
         5192, 2734, 4015, 2731, 5180, 2018, 6474, 3663, 2737, 4009, 2735, 
         5198, 4202, 1765, 6607, 4174, 5549, 2221, 5173, 2219, 5496, 2858, 
         4187, 2853, 3720, 5487, 3717, 5515, 5517, 4160, 5499, 4153, 5421, 
         2056, 6573, 3713, 2844, 4140, 2840, 5444, 4499, 1795, 4473, 6562, 
         4494, 2833, 4462, 5402, 4458, 6708, 6697, 4437, 8046, 2330, 5368, 
         2322, 8039, 4429, 6691, 4409, 7985, 7977, 7917, 9524, 2302, 7894, 
         7110, 2973, 7816, 7879, 7802, 9494, 2283, 7787, 7064, 2965, 7758, 
         8734, 9757, 7699, 9458, 7000, 6955, 7624, 8703, 3797, 8910, 4329, 
         9134, 9086}],
        "5.46`"],
       Annotation[#, 5.46, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1486, 9178, 3851, 8858, 3316, 8634, 8291, 8286, 6908, 7223, 
         2112, 9285, 6770, 7251, 2469, 3911, 2467, 3937, 7281, 2131, 4745, 
         2158, 3951, 3180, 4783, 5927, 4796, 3078, 4805, 5745, 4798, 3215, 
         4859, 1564, 5950, 4847, 3093, 3398, 8193, 1867, 1569, 7352, 7356, 
         6019, 6825, 6832, 1589, 3482, 6091, 1897, 6127, 6125, 3515, 6166, 
         3529, 6205, 3555, 1667, 6251, 1955, 1670, 6335, 7396, 7405, 7406, 
         7401, 3588, 5815, 5819, 4915, 3126, 5814, 4937, 6408, 4939, 2664, 
         4952, 2661, 5025, 1996, 8377, 8376, 6413, 2670, 7503, 2179, 5191, 
         2733, 4014, 2730, 3662, 5187, 3661, 5202, 2736, 4008, 5197, 5194, 
         4201, 1764, 4173, 6468, 4181, 5176, 5172, 2218, 5495, 2857, 4186, 
         2852, 3719, 5486, 3716, 5514, 2216, 5436, 4159, 5425, 5420, 2055, 
         6572, 3712, 2843, 4139, 5443, 5439, 4498, 1794, 4472, 6561, 4493, 
         2832, 4461, 5401, 4457, 1793, 6707, 4436, 8045, 2329, 5367, 2321, 
         8038, 4428, 6690, 4408, 7984, 2301, 5340, 2295, 7891, 7893, 7109, 
         2972, 7815, 7878, 7801, 9493, 2282, 7786, 7063, 2964, 7757, 8733, 
         9756, 7698, 9457, 6999, 6954, 7623, 8702, 3796, 8909, 4328, 9133, 
         9085}],
        "5.2`"],
       Annotation[#, 5.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1485, 9177, 3850, 8857, 3315, 8633, 8290, 8285, 6907, 7222, 
         2111, 9284, 6769, 7250, 2468, 3910, 2466, 3936, 7280, 2130, 4744, 
         2157, 3950, 3179, 4782, 5926, 4795, 3077, 4804, 5744, 5739, 1858, 
         1554, 4843, 5949, 4846, 3092, 3397, 8192, 1866, 1568, 7365, 2585, 
         6018, 6824, 6831, 1588, 6056, 3481, 6084, 3492, 6124, 3514, 6165, 
         3528, 6204, 3554, 1666, 6250, 1954, 1669, 6334, 7395, 7408, 7392, 
         2607, 7398, 2608, 5818, 4914, 5813, 5812, 4936, 6407, 6405, 4920, 
         2663, 5032, 3619, 7499, 2669, 7480, 2667, 7496, 4012, 6472, 6469, 
         4000, 2732, 5186, 3660, 5201, 5204, 4007, 5196, 5193, 4200, 1763, 
         4172, 6467, 4180, 2729, 5175, 2217, 5494, 4171, 6584, 4149, 2856, 
         5485, 3715, 5513, 2215, 5435, 4158, 2838, 5424, 2054, 6571, 3711, 
         2842, 4138, 5442, 4131, 5380, 2053, 1757, 6560, 4492, 2831, 4460, 
         5400, 4456, 1792, 4435, 6552, 4452, 5376, 5366, 2320, 8037, 4427, 
         6689, 4407, 7983, 2300, 5339, 2294, 7890, 7892, 7108, 2971, 7814, 
         7877, 7800, 9492, 2281, 7785, 7062, 2963, 7697, 7776, 7689, 9456, 
         6998, 6953, 7622, 8701, 3795, 8908, 4327, 9132, 9084}],
        "4.94`"],
       Annotation[#, 4.94, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1484, 9176, 3849, 8856, 3314, 8632, 8289, 8284, 6906, 7221, 
         2110, 9283, 6768, 7249, 7273, 3909, 2465, 3935, 7279, 2129, 4743, 
         4752, 3949, 4737, 3943, 3178, 4781, 5925, 4794, 3076, 4803, 3071, 
         5743, 1857, 1553, 4842, 5948, 4845, 3091, 5782, 3396, 3402, 1567, 
         7364, 2584, 6017, 6823, 6055, 7373, 6054, 3480, 6083, 3491, 6123, 
         3513, 6164, 6159, 1924, 1637, 3552, 6249, 1953, 1668, 6333, 6263, 
         7394, 8414, 2606, 7397, 7399, 4913, 5794, 4911, 5811, 4935, 1713, 
         6406, 4919, 5031, 5030, 3618, 7498, 2668, 7479, 2666, 7495, 4011, 
         1733, 6471, 3999, 5185, 5183, 3659, 5200, 5203, 4006, 5195, 4003, 
         5155, 2017, 1731, 6466, 4179, 2728, 4170, 5168, 4168, 6586, 6583, 
         4148, 5484, 5482, 3714, 5512, 2214, 5434, 4157, 2837, 3710, 5431, 
         3708, 5454, 2841, 4137, 5441, 4130, 5379, 2052, 6559, 6555, 4491, 
         2830, 4459, 5399, 4455, 1791, 4434, 6551, 4451, 2820, 5375, 2319, 
         8036, 4426, 6688, 4406, 7982, 2299, 5338, 2293, 7916, 2989, 7107, 
         2970, 7813, 7876, 7799, 9491, 2280, 7784, 7061, 2962, 7696, 7775, 
         7688, 9455, 6997, 6952, 7621, 8700, 3794, 8907, 4326, 9131, 9083}],
        "4.68`"],
       Annotation[#, 4.68, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1483, 9175, 3848, 8855, 3313, 8631, 8288, 8283, 6905, 7220, 
         2109, 9282, 6767, 7248, 7272, 3908, 2464, 3934, 7278, 2128, 4742, 
         4751, 3948, 4736, 3942, 3177, 4780, 5924, 5919, 4770, 3075, 3384, 
         5742, 1856, 1552, 4841, 5947, 4844, 5781, 5780, 3395, 3401, 1566, 
         7363, 3257, 2583, 8235, 2587, 7372, 6053, 3479, 6082, 3490, 6122, 
         3512, 1633, 6163, 1923, 1636, 3551, 6248, 1952, 6262, 6260, 6326, 
         7393, 8413, 7400, 8482, 8483, 8262, 4912, 5793, 5791, 1982, 1697, 
         6330, 4923, 5803, 2611, 5029, 3617, 7497, 7500, 7478, 7494, 7493, 
         4010, 1732, 6470, 3998, 5184, 2178, 5021, 2177, 5161, 5162, 4005, 
         5157, 5154, 2016, 6465, 6463, 4178, 2727, 4169, 5167, 4167, 1761, 
         6585, 4147, 5483, 2213, 5151, 2212, 5432, 5433, 4156, 2836, 3709, 
         5430, 3707, 5453, 5455, 4136, 5440, 4129, 5378, 2051, 6558, 3704, 
         2829, 4117, 2825, 5398, 4454, 1790, 4433, 6550, 4450, 2819, 4425, 
         5363, 4421, 6696, 6687, 4405, 7981, 2298, 5337, 2292, 7915, 4399, 
         6683, 4385, 2988, 7875, 7798, 9490, 2279, 7783, 7060, 2961, 7695, 
         7774, 7687, 9454, 6996, 6951, 7620, 8699, 3793, 8906, 4325, 9130, 
         9082}],
        "4.42`"],
       Annotation[#, 4.42, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1482, 9174, 3847, 8854, 3312, 8630, 8287, 8282, 6904, 7219, 
         2108, 9281, 6766, 7247, 7271, 3907, 2463, 3933, 7277, 2127, 4753, 
         2484, 3947, 4735, 3941, 3176, 4779, 1547, 5923, 4769, 3074, 3383, 
         5741, 1855, 1551, 4852, 2537, 5779, 3394, 3400, 1565, 7362, 3256, 
         2582, 8234, 2586, 7371, 6052, 3478, 6081, 6076, 1896, 1606, 3510, 
         6162, 1922, 1635, 3550, 6247, 1951, 6261, 6259, 6325, 8347, 8481, 
         8480, 3118, 8261, 3117, 8259, 5792, 1981, 6329, 6328, 4922, 5802, 
         5800, 2610, 7484, 7485, 7477, 8426, 8424, 1995, 1712, 6404, 4002, 
         5023, 5020, 2176, 5164, 2724, 4004, 2722, 5156, 2015, 6464, 3658, 
         2726, 3994, 2725, 5166, 4166, 1760, 4146, 6459, 4152, 5153, 5150, 
         2211, 5438, 4145, 6568, 4125, 2839, 5429, 3706, 5452, 2209, 5391, 
         4135, 5382, 5377, 2050, 6557, 3703, 2828, 4116, 5397, 5394, 4453, 
         1789, 4432, 6549, 4449, 2818, 4424, 5362, 4420, 6695, 6686, 4404, 
         7980, 2297, 5336, 2291, 7914, 4398, 6682, 4384, 2987, 7874, 7797, 
         9489, 2278, 7782, 7059, 2960, 7694, 7773, 7686, 9453, 6995, 6950, 
         7619, 8698, 3792, 8905, 4324, 9129, 9081}],
        "4.16`"],
       Annotation[#, 4.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1481, 9173, 3846, 8853, 4700, 3311, 7206, 3351, 8281, 6903, 
         7218, 7211, 2107, 4712, 2120, 7270, 3906, 2462, 4722, 3932, 5906, 
         3940, 2483, 3946, 4734, 4730, 1849, 1538, 4765, 5922, 4768, 3073, 
         3382, 5740, 1854, 1550, 4851, 2536, 5778, 3393, 3255, 4858, 3254, 
         4894, 2581, 8233, 8236, 7370, 8230, 7367, 6051, 3477, 6080, 6075, 
         1895, 1605, 3509, 6161, 1921, 1634, 6173, 3549, 6242, 3553, 6258, 
         6324, 1696, 8346, 8477, 8476, 8479, 8478, 8260, 7389, 3586, 5798, 
         3587, 6327, 4921, 3120, 5801, 2609, 7486, 2657, 7476, 2655, 8425, 
         1994, 6403, 6402, 4001, 2660, 5022, 2175, 5163, 3997, 6461, 3987, 
         2723, 5160, 3657, 5170, 5171, 3993, 5165, 3990, 5137, 2014, 1729, 
         6458, 4151, 2721, 5152, 2210, 5437, 4144, 6567, 4124, 5428, 5426, 
         3705, 5451, 2208, 5390, 4134, 2823, 5381, 2049, 6556, 3702, 2827, 
         4115, 5396, 4110, 5345, 2048, 1754, 6548, 4448, 2817, 4423, 5361, 
         4419, 1788, 6694, 4403, 7979, 2296, 5335, 2290, 7913, 4397, 6681, 
         4383, 7873, 7868, 7796, 9488, 2277, 7781, 7058, 2959, 7693, 7772, 
         7685, 9452, 6994, 6949, 7618, 8697, 3791, 8904, 4323, 9128, 9080}],
        "3.9000000000000004`"],
       Annotation[#, 3.9000000000000004`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1480, 9172, 3845, 8852, 4699, 3310, 7205, 3350, 8280, 6902, 
         7217, 7210, 2106, 4711, 2119, 7269, 3905, 2461, 4721, 3931, 5905, 
         3939, 2482, 3945, 4733, 4729, 1848, 1537, 4764, 5921, 4767, 3072, 
         5753, 3381, 3386, 1549, 4850, 3214, 2535, 5776, 2539, 4857, 3253, 
         4893, 6011, 4896, 3107, 7369, 8229, 7366, 6050, 3476, 1602, 6079, 
         1894, 1604, 3508, 6160, 1920, 6172, 6171, 3548, 6241, 6238, 1950, 
         1665, 6321, 8345, 6322, 7388, 7390, 7387, 3585, 5797, 5799, 4908, 
         3119, 5796, 4918, 6401, 6399, 6319, 2656, 7483, 3616, 7491, 2659, 
         7470, 2658, 7489, 3996, 6462, 6460, 3986, 5159, 5158, 3656, 5169, 
         2174, 5142, 3992, 5139, 5136, 2013, 6457, 6455, 4150, 2720, 4143, 
         5146, 4142, 6569, 6566, 4123, 5427, 2207, 5133, 2206, 5388, 5389, 
         4133, 2822, 3701, 5387, 3699, 5405, 2826, 4114, 5395, 4109, 5344, 
         2047, 6547, 6544, 4447, 2816, 4422, 5360, 4418, 1787, 4402, 6540, 
         4415, 5342, 5334, 2289, 7912, 4396, 6680, 4382, 7872, 2276, 5314, 
         2272, 7778, 7780, 7057, 2958, 7692, 7771, 7684, 9451, 2266, 7675, 
         6993, 7659, 7617, 8696, 3790, 8903, 4322, 9127, 9079}],
        "3.64`"],
       Annotation[#, 3.64, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1479, 9171, 3844, 8851, 4698, 3309, 7204, 3349, 8279, 6901, 
         7216, 7209, 2105, 4710, 2118, 7268, 3904, 4720, 4719, 3930, 5904, 
         3938, 2481, 3944, 2478, 4732, 1847, 1536, 4763, 5920, 4766, 5752, 
         5751, 3380, 3385, 1548, 4849, 3213, 2534, 5775, 2538, 4856, 3252, 
         4892, 6010, 4895, 3106, 7368, 3104, 8228, 1879, 1585, 3474, 6078, 
         1893, 1603, 6088, 3507, 6154, 3511, 6170, 3547, 1663, 6240, 1949, 
         1664, 6323, 7383, 7391, 7381, 2604, 7384, 7385, 4907, 5785, 4906, 
         5795, 4917, 1711, 6400, 6318, 7482, 7481, 3615, 7490, 7492, 7469, 
         7488, 7487, 3995, 1730, 3985, 6398, 3989, 5019, 5017, 2173, 5140, 
         5141, 3991, 2716, 5138, 2012, 6456, 3655, 2719, 3982, 2718, 5145, 
         4141, 1758, 4122, 6452, 4128, 5135, 5132, 2205, 5393, 2824, 4132, 
         2821, 3700, 5386, 3698, 5404, 2203, 5354, 4113, 5347, 5343, 2046, 
         6546, 3696, 2815, 4099, 2812, 5359, 4417, 1786, 4401, 6539, 4414, 
         2808, 5341, 2288, 7911, 4395, 6679, 4381, 7871, 2275, 5313, 2271, 
         7777, 7779, 7056, 2957, 7691, 7770, 7683, 9450, 2265, 7674, 6992, 
         7658, 7616, 8695, 3789, 8902, 4321, 9126, 9078}],
        "3.38`"],
       Annotation[#, 3.38, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1478, 9170, 3843, 8850, 4697, 3308, 7203, 3348, 8278, 6900, 
         2450, 7215, 2104, 4709, 4714, 3903, 4707, 3898, 4718, 3929, 5903, 
         5900, 3921, 2480, 3369, 4731, 1846, 1535, 4773, 2489, 5750, 3379, 
         3212, 4778, 3211, 4839, 2533, 5777, 3089, 4855, 5773, 4853, 3251, 
         4891, 1583, 6009, 4889, 3105, 6822, 8227, 1878, 1584, 3473, 6077, 
         1892, 6087, 6086, 3506, 6153, 6150, 1919, 1632, 3545, 6239, 1948, 
         6245, 6244, 6317, 7382, 8412, 7386, 8473, 8474, 8475, 8256, 3113, 
         5784, 1980, 1695, 8344, 6320, 8258, 8257, 2605, 7474, 7475, 7468, 
         8423, 8422, 1993, 6397, 6396, 3988, 2654, 5018, 2172, 5143, 3984, 
         6453, 6391, 2717, 7540, 3654, 5148, 5149, 3981, 5144, 3978, 5123, 
         2011, 1727, 6451, 4127, 2715, 5134, 2204, 5392, 4121, 6553, 4106, 
         5385, 5383, 3697, 5403, 2202, 5353, 4112, 2810, 5346, 2045, 6545, 
         3695, 2814, 4098, 5358, 5356, 4416, 1785, 4400, 6538, 4413, 2807, 
         4394, 5330, 4392, 6685, 6678, 4380, 7870, 2274, 5312, 2270, 7795, 
         2969, 7055, 2956, 7690, 7769, 7682, 9449, 2264, 7673, 6991, 7657, 
         7615, 8694, 3788, 8901, 4320, 9125, 9077}],
        "3.12`"],
       Annotation[#, 3.12, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1477, 9169, 3842, 8849, 4696, 3307, 7202, 3347, 8277, 6899, 
         2449, 7214, 2103, 4708, 4713, 3902, 4706, 3897, 4717, 3928, 1532, 
         5902, 3920, 2479, 4741, 3368, 3371, 1534, 4772, 3175, 2488, 5737, 
         2490, 4777, 3210, 4838, 5945, 4840, 3088, 4854, 3086, 5772, 1865, 
         1563, 4887, 6008, 4888, 8232, 8231, 6821, 6014, 7351, 6013, 3472, 
         6072, 3475, 6085, 3505, 1630, 6152, 1918, 1631, 6158, 3544, 6234, 
         3546, 6243, 6316, 8343, 8472, 8342, 6314, 3114, 8255, 3584, 5789, 
         3116, 4905, 3115, 5788, 4910, 6395, 6393, 6312, 2651, 7473, 3614, 
         5016, 2653, 4902, 2652, 5014, 3983, 1728, 6454, 6390, 7539, 7538, 
         3653, 5147, 2171, 5125, 3980, 5124, 5122, 2010, 6450, 6449, 4126, 
         2714, 4120, 5129, 4119, 1756, 6554, 4105, 5384, 2201, 5120, 2200, 
         5351, 5352, 4111, 2809, 3694, 5350, 3693, 5365, 2813, 4097, 5357, 
         4094, 5318, 2044, 6537, 6534, 4412, 2806, 4393, 5329, 4391, 1784, 
         6684, 4379, 7869, 2273, 5311, 2269, 7794, 4376, 6675, 4367, 2968, 
         7768, 7681, 9448, 2263, 7672, 6990, 2951, 7656, 8693, 3787, 8900, 
         4319, 9124, 9076}],
        "2.8600000000000003`"],
       Annotation[#, 2.8600000000000003`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1476, 9168, 3841, 4695, 4690, 3306, 7201, 2448, 7180, 2445, 
         3895, 7213, 2102, 4716, 2460, 3901, 4705, 4702, 1842, 1526, 3918, 
         5901, 3919, 4740, 4739, 3367, 3370, 1533, 4771, 3174, 2487, 5736, 
         5738, 4776, 5733, 4774, 3209, 4837, 1561, 5944, 4831, 3087, 3392, 
         5771, 1864, 1562, 4890, 3250, 2579, 8225, 2580, 7350, 6012, 3471, 
         6071, 6069, 1891, 1601, 3503, 6151, 1917, 6157, 6156, 3543, 6233, 
         6231, 1947, 1662, 6315, 6237, 2602, 3271, 2603, 5790, 4904, 5787, 
         5786, 4909, 1710, 6394, 6311, 7472, 7471, 3613, 5015, 2601, 5012, 
         4901, 5011, 5010, 1992, 1709, 8375, 6392, 7467, 7466, 2170, 5126, 
         2712, 3979, 2711, 3652, 7537, 3651, 5131, 2713, 3976, 5128, 5127, 
         4118, 1755, 4104, 6446, 4108, 2710, 5121, 2199, 5355, 4103, 6542, 
         4091, 2811, 5349, 3692, 5364, 2198, 5323, 4096, 5320, 5317, 2043, 
         6536, 3691, 2805, 4085, 2803, 5328, 4390, 1783, 4378, 6530, 4388, 
         5316, 5310, 2268, 7793, 4375, 6674, 4366, 2967, 7767, 7680, 9447, 
         2262, 7671, 6989, 2950, 7655, 8692, 3786, 8899, 4318, 9123, 9075}],
        "2.6`"],
       Annotation[#, 2.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1475, 9167, 3840, 4694, 4689, 3305, 7200, 2447, 7179, 2444, 
         3894, 7212, 2101, 4715, 2459, 3900, 4704, 4701, 1841, 1525, 3924, 
         2125, 4738, 3366, 3173, 3927, 3172, 4761, 5918, 4762, 3070, 4775, 
         3068, 5732, 1853, 1546, 4833, 2532, 5774, 3391, 3249, 4836, 3248, 
         4886, 2578, 8226, 3103, 7349, 8223, 8222, 1877, 1582, 3469, 6070, 
         1890, 1600, 6074, 3502, 6147, 3504, 6155, 3542, 1661, 6232, 1946, 
         6236, 6235, 7379, 7380, 3270, 4903, 3268, 1979, 8341, 8340, 6313, 
         3112, 8254, 2600, 5013, 2648, 4900, 2647, 3612, 3611, 7465, 2650, 
         7463, 2649, 7464, 3977, 6448, 6447, 6387, 7536, 7535, 3650, 5130, 
         2169, 3975, 3295, 2009, 6445, 6444, 4107, 2709, 4102, 7533, 4101, 
         6543, 6541, 4090, 5348, 2197, 5118, 2196, 5321, 5322, 4095, 2801, 
         5319, 2042, 6535, 3690, 2804, 4084, 5327, 5325, 4389, 1782, 4377, 
         6529, 4387, 2800, 5315, 2267, 7792, 4374, 6673, 4365, 7766, 7763, 
         7679, 9446, 2261, 7670, 6988, 2949, 7654, 8691, 3785, 8898, 4317, 
         9122, 9074}],
        "2.34`"],
       Annotation[#, 2.34, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1474, 9166, 3839, 4693, 4688, 3304, 7199, 2446, 7178, 2443, 
         7196, 3893, 5887, 3896, 2458, 3899, 2456, 4703, 1840, 1524, 3923, 
         3162, 2124, 4727, 2126, 3926, 3171, 4760, 1544, 5917, 4757, 3069, 
         5735, 3377, 3378, 1545, 4832, 3208, 2531, 5769, 5770, 4835, 4834, 
         3247, 4885, 1580, 6005, 6003, 3102, 8224, 6819, 6820, 1581, 6007, 
         3468, 6066, 3470, 6073, 3501, 1628, 6146, 1916, 1629, 6149, 3541, 
         6228, 6226, 1945, 1660, 7378, 2599, 3269, 3583, 8252, 8253, 8249, 
         8251, 8250, 4899, 1708, 6389, 4898, 2598, 5783, 2597, 3282, 7462, 
         3280, 1991, 1707, 8374, 6388, 2646, 7461, 2168, 3296, 3974, 3294, 
         3649, 3648, 7534, 2708, 7530, 7532, 7531, 4100, 1753, 4089, 6443, 
         4093, 5119, 5117, 2195, 5324, 4088, 6532, 6439, 2802, 7603, 3689, 
         5332, 5333, 4083, 5326, 4080, 5300, 2041, 1752, 6528, 4386, 2799, 
         4373, 5307, 4372, 6677, 6672, 4364, 7765, 2260, 5297, 2258, 7668, 
         7669, 6987, 2948, 3784, 7667, 3781, 5725, 8897, 4316, 9121, 9073}],
        "2.08`"],
       Annotation[#, 2.08, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1473, 9165, 3838, 4692, 4687, 3303, 7198, 7208, 7177, 2442, 
         7195, 3892, 5886, 5884, 5876, 2457, 7246, 3356, 3357, 1523, 3922, 
         3161, 2123, 4728, 2477, 3925, 4724, 4723, 1845, 1531, 4759, 2486, 
         5734, 3376, 3207, 8185, 3206, 4830, 5943, 5942, 4828, 3085, 3390, 
         1863, 1560, 6004, 3246, 2576, 6001, 2577, 7348, 6006, 3467, 1598, 
         6065, 1889, 1599, 6068, 3499, 6143, 3500, 6148, 3540, 1659, 6227, 
         1944, 6230, 6229, 7377, 1694, 3267, 3582, 8248, 3111, 8246, 3110, 
         8247, 4897, 1706, 6309, 3281, 3610, 7460, 2645, 7457, 7459, 7458, 
         3973, 1726, 3971, 2167, 5009, 2166, 3293, 7529, 3291, 2008, 6442, 
         6441, 4092, 2707, 4087, 4086, 6533, 6531, 6438, 7602, 7601, 3688, 
         5331, 2194, 5302, 4082, 2794, 5301, 2040, 6527, 3687, 2798, 4078, 
         2796, 5306, 4371, 1781, 6676, 4363, 7764, 2259, 5296, 2257, 7678, 
         2954, 6986, 2947, 3783, 7666, 3780, 5724, 8896, 4315, 9120, 9072}],
        "1.82`"],
       Annotation[#, 1.82, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1472, 9164, 3837, 4691, 4686, 3302, 7197, 7207, 7176, 7194, 
         7193, 3891, 1522, 5885, 5875, 7245, 7244, 3355, 3160, 7240, 3159, 
         3917, 5899, 5898, 3915, 2476, 4726, 3364, 3365, 1530, 4758, 3170, 
         2485, 8188, 3067, 8184, 8470, 8469, 1852, 1543, 4829, 2530, 5768, 
         3389, 3245, 3244, 7347, 1578, 6000, 1876, 1579, 6002, 3465, 3466, 
         6067, 3498, 1627, 6142, 1915, 6145, 6144, 3539, 6224, 6223, 1943, 
         1658, 6225, 2596, 3266, 8245, 3265, 1978, 8339, 8338, 6310, 3109, 
         8244, 2595, 3279, 7456, 3278, 1990, 6386, 6385, 3972, 2644, 3970, 
         3969, 1725, 6383, 3292, 3647, 5115, 5116, 3968, 3966, 3289, 2007, 
         1724, 8382, 6440, 7528, 7527, 2193, 5303, 2795, 4081, 2793, 3686, 
         7600, 3685, 5309, 2797, 4077, 5305, 5304, 4370, 1780, 4362, 6525, 
         4369, 5299, 5295, 2256, 7677, 2953, 6985, 2946, 3782, 7665, 3779, 
         5723, 8895, 4314, 9119, 9071}],
        "1.56`"],
       Annotation[#, 1.56, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1471, 3836, 3886, 4685, 4681, 2094, 7185, 7187, 7175, 8404, 
         8402, 1835, 1466, 8276, 5878, 7192, 7190, 2100, 7241, 7242, 7239, 
         8409, 8407, 1839, 1521, 3916, 2122, 4725, 3363, 3169, 3168, 4756, 
         1542, 5916, 5915, 8187, 8186, 3375, 3205, 3204, 4827, 5940, 5939, 
         5938, 3084, 8190, 6817, 6818, 1559, 5941, 3407, 5999, 5998, 1875, 
         1577, 3464, 1888, 6064, 6063, 3497, 1625, 6140, 1914, 1626, 6141, 
         3538, 6221, 6220, 1942, 1657, 6222, 2594, 3264, 3263, 1977, 1693, 
         8337, 6308, 8243, 8242, 2593, 3277, 3276, 1989, 8373, 8372, 6384, 
         2643, 7455, 2165, 3290, 3967, 3288, 3646, 3645, 7526, 2706, 7524, 
         2705, 7525, 4079, 1751, 6526, 6436, 7599, 7598, 3684, 5308, 2192, 
         5293, 4076, 5292, 5291, 2039, 6524, 6523, 4368, 2792, 5298, 2255, 
         7676, 4361, 6669, 6519, 2952, 7664, 3778, 5722, 5728, 4313, 9118, 
         9070}],
        "1.3`"],
       Annotation[#, 1.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1470, 3835, 3885, 4684, 4680, 2093, 7184, 7186, 7174, 8403, 
         8401, 1834, 8275, 8274, 5877, 2439, 7191, 2099, 7243, 2455, 7238, 
         2454, 8408, 1838, 3354, 3158, 7235, 3157, 3914, 5897, 5896, 5894, 
         2475, 7310, 3362, 3167, 3166, 4755, 5914, 5913, 5912, 3066, 8183, 
         3374, 3203, 3202, 4825, 4826, 3083, 8189, 3082, 8471, 1862, 1558, 
         5937, 3406, 5997, 5996, 1874, 1576, 3463, 1887, 6062, 6061, 3496, 
         1624, 6137, 1913, 6139, 6138, 3537, 6218, 6217, 1941, 1656, 6219, 
         2592, 3262, 3261, 1976, 1692, 8336, 6307, 8241, 8240, 2591, 3275, 
         3274, 1988, 1705, 8371, 6382, 7454, 7453, 2164, 3287, 7523, 3285, 
         2006, 8381, 8380, 6437, 2704, 7522, 2191, 5294, 2789, 4075, 2788, 
         3683, 7591, 3682, 7596, 2791, 7585, 2790, 7594, 4360, 6671, 6668, 
         6518, 7663, 7661, 3777, 5721, 5727, 4312, 9117, 9069}],
        "1.04`"],
       Annotation[#, 1.04, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1469, 3834, 3884, 4683, 4679, 2092, 7189, 2436, 7173, 2435, 
         3301, 7183, 3300, 4678, 2438, 3828, 2437, 4676, 3890, 1520, 5883, 
         3889, 2098, 3153, 2097, 7236, 7237, 7234, 8406, 8405, 1837, 1519, 
         5895, 3156, 2121, 3913, 5893, 5892, 2474, 7309, 3361, 3165, 3164, 
         4754, 8333, 8332, 8331, 8468, 8467, 3373, 3201, 3200, 7313, 1557, 
         5934, 1861, 5936, 5935, 3405, 1574, 5994, 1873, 1575, 5995, 3462, 
         6060, 6059, 1886, 1597, 3495, 1912, 6136, 6135, 3536, 1654, 6215, 
         1940, 1655, 6216, 2590, 3260, 3259, 1975, 1691, 8335, 6306, 8239, 
         8238, 2589, 3273, 3272, 1987, 1704, 3964, 3965, 3286, 3644, 7520, 
         7521, 7517, 7519, 7518, 4074, 1750, 6522, 6521, 7590, 7589, 3681, 
         7595, 7597, 7584, 7593, 7592, 4359, 1779, 6670, 6517, 7662, 7660, 
         3776, 5720, 5726, 4311, 9116, 9068}],
        "0.78`"],
       Annotation[#, 0.78, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1468, 3833, 3883, 2441, 4682, 2091, 7188, 3831, 8273, 6841, 
         7182, 7181, 3299, 4677, 2090, 3827, 4675, 4674, 1833, 3298, 3152, 
         7170, 3151, 3888, 1518, 8299, 6848, 2096, 6765, 2095, 7232, 7233, 
         7231, 2453, 3353, 3352, 3155, 3154, 3912, 1529, 8330, 7308, 2473, 
         7307, 2472, 8465, 8466, 8463, 3065, 8464, 1844, 1528, 3163, 7312, 
         7311, 1541, 5909, 1851, 5911, 5910, 3388, 1556, 5931, 1860, 5933, 
         5932, 3404, 5992, 5991, 1872, 1573, 5993, 3460, 3461, 6058, 3494, 
         1622, 6133, 1911, 1623, 6134, 3534, 3535, 6214, 7376, 1690, 3258, 
         3580, 3581, 8334, 6305, 3108, 8237, 2588, 8410, 8411, 7375, 7374, 
         7452, 3963, 1723, 3284, 3643, 7516, 2703, 7514, 2702, 7515, 4072, 
         4073, 2786, 7583, 2785, 8442, 2038, 8398, 8397, 6520, 7588, 7586, 
         2254, 5729, 5730, 4310, 4308, 9067}],
        "0.52`"],
       Annotation[#, 0.52, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1467, 3832, 3882, 2440, 3830, 3829, 1465, 6840, 6842, 6838, 
         2089, 6839, 8272, 6837, 2088, 6836, 2087, 7171, 7172, 8400, 8399, 
         2434, 7169, 8548, 7168, 6764, 6835, 6834, 7167, 1832, 3297, 3150, 
         3149, 3887, 1517, 6846, 6847, 6843, 6845, 6844, 8298, 8297, 7230, 
         2452, 7229, 2451, 5880, 5879, 1836, 5882, 5881, 3360, 1527, 3359, 
         3358, 5889, 5888, 1843, 5891, 5890, 3372, 1539, 5907, 1850, 1540, 
         5908, 3387, 5930, 5929, 1859, 1555, 3403, 1871, 5990, 5989, 3458, 
         3459, 6057, 3493, 6132, 6131, 1910, 1621, 3533, 1939, 1653, 6213, 
         3578, 3579, 6304, 8420, 8421, 7448, 7450, 7449, 7451, 3962, 1722, 
         3283, 3642, 2005, 6435, 6434, 4071, 2190, 5290, 3680, 8444, 8445, 
         8443, 2787, 4306, 7587, 2253, 5731, 2955, 4309, 4307, 9066}],
        "0.26`"],
       Annotation[#, 0.26, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{0, 1.6596235986105279`}, {0, 2.257205326820854}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->497119469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197073264],

Cell["Parametrize a lemniscate by arc length:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->145942121],

Cell[BoxData[
 RowBox[{
  RowBox[{"lemniscate", "[", "s_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", "=", 
      RowBox[{
       SqrtBox["2"], "s"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"NevilleThetaC", "[", 
         RowBox[{"t", ",", 
          RowBox[{"1", "/", "2"}]}], "]"}], " ", 
        RowBox[{"NevilleThetaD", "[", 
         RowBox[{"t", ",", 
          RowBox[{"1", "/", "2"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"NevilleThetaC", "[", 
         RowBox[{"t", ",", 
          RowBox[{"1", "/", "2"}]}], "]"}], " ", 
        RowBox[{
         RowBox[{"NevilleThetaS", "[", 
          RowBox[{"t", ",", 
           RowBox[{"1", "/", "2"}]}], "]"}], "/", 
         SqrtBox["2"]}]}]}], " ", "}"}], "/", 
     SuperscriptBox[
      RowBox[{"NevilleThetaN", "[", 
       RowBox[{"t", ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], "2"]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119965250],

Cell["Show the classical and arc length parametrizations:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->73665792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], ">", "0"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", "0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"lemniscate", "[", "s", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "/", "4"}], "]"}], "^", "2"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "Pi"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440886841],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1m0uoXlcVx3fu991X2iRNk5uHNbkxfag1te+qTdNUQ1prm4qIOhAHsQjt
QCu1TnTiA8xEJzqxUOzAB7Q6qBQqQgWxIBbEglgQFaSC1IFFsDgoCMffWv/9
OGef8333Ozc1JF/OPmfvtf7rsdd+rX3u/GMPfeaz5x97+MHzx+559PznH3r4
wS8cu/uRR3k12RHCjq+FEO46FHhuePJ/9ufr/NOjnt5tv5PXXvvPS7/7O3/D
kv1Y2Ws34QQ/S0H1lvn2ca//+utvdOr/+U//HKgfJq+88q9WvRPO8R32O335
D//44Q9e+upXnn/kc88unT71eJh85MPf55m/Ycl+1ijznr8PP/QML5783m9f
+NVfAfZ2p5zkacI19rMMgp8+8/KFb/ySqp/42I+C0VxOtJdF+zvf/vXPnvvj
q6/+O9xrbVZBR/lb33yBb/fd+yQ1+Q1T5/7gp38i7moKd6rSYJg7H37x/F8e
/+6LVKVlkESf+uRTLYmEBA48wxO0tApXu078dxUSKIQaSAwtiqa5nfZtDX1R
AMaXv/RzICEi0vDmqqjvK63WOuqBLlXOnnkCHLABNbVM5nWnI0v/+OnfoyqI
ABE6KO+Mf+UTbaDPeypAizcYez1RFwY+UYFqPICSCs7f1HLca/IGxggjUjxg
bNrCKOKQB8EAftQACg+88faisgJqXqIP2ovNvvQeAWQ0EOAWe6MWJi3r8Bvs
3UplsU3XNcRgDg0QwgQab7zx3yD62AX66I+/iMGHU/6eNggPVJrRGHV4/VUe
JC140D1QjdZlIzAdc/rZ/lJrom/yZqwAAIbLoFbLfJUtqWOWOJywgknOgu4p
7vJ+V3iGsFqhmETER1OPgq7UY374ltZbuKEhk/J9/hbyOKzgma+pLkpFHrkq
woSxCKBEy2z/SBVKsgLfTN4jTspbTEHEN/wJ2TdTbZAVDKZ5gxCWhSBDGcRi
xSuczou/+Zv6thwi8oMidOHH5/f4G3QNM36pdDQhQFfqLKab7SLAK7PmTW4h
4Ikyb8H1Vqfj+phiMcCiDHAcTzZSzai39Z41lqP2a+88nCiigS8+9hwPHm2m
SEMRUJC7Ob1R7OKN6gALlhgQ+GM5Qg0HljWvTNLCDqZ8cm8ILvNE4cDiqeIx
QktWGUKa7XCuOU4jkkMtySCJrIr4QAAIUTjc6GX8Ef1a2b9PKSuWAnEsN5rI
i+gw4oY7QZ2iNCHPnyAJ0lM1XJvaybepvrJQ32qXN1KPyTScqo39CG797Xov
a5g2j7k26VrBJoznecBbiIICyDubOJ/A0nCSRiS1vQUJmg/Xpd6W/S15znLs
Iyux7FJNsAv6M3rXJc0hQ6Y0IaQhtT2eSJrkFa6LC82lPKUC1WRno7UEnYOO
+VDiBEaUGW5o+Y2V90c6+1qeLI6qSZHK9nhtKqNke7y+kilR2p/sEz3xhlSm
abZwxCVQ9nhjT5dLzfBINUlBqmXBvS0sps+bK+w+u5ugFGAUbvIypIXtaG6G
VVEFMjdZa8KaZDtYcb+liTGH+qYRRts5HpmCsKHZm3SHx1mUvqVlTRv91C81
Xymc4KFuO5qT4oVhvNXLGuLs0f1DPcW8J9rS9KxRw+aT7VFjKLZYcXfyMxpI
d7el/o3tbCy8OtmSGhYlCw8640I89qTeFCPEbUlrUDTZJIv6JI4OX+Pz3ibG
aCjQVg9bxo5diQq2NYv4zMMiJRayxysTb/RqFvTvJg5YDNuiHORtFt/EAVpQ
NJCXt6TR2GCPmQ9NgDJnVrMrIVa3Dycr7z2etBn7faaswXzODOFSLzA3i5Hg
ZOWt7nMxXpS3t7sdRM00GoLNzyeJazZ/3SsvaeI4gLim2TuS3ojqpqe3tdDU
fMwyIViPWZSP9GX+6rPwCUS13PQZdoynZne4W607orbdcpjJYm+yQIrllyRN
E8jt8c4m9v44KvjMekIvAKg9nsw04cNrZJ9BE1OiFdOCaEKA+gXt7mixHC0i
AqOw2cxeMch2Gict7u6MddfTe7iaz27MobEZeftaO/a6FI03alzRdlvhUm9A
iKi59Vh3Z9JojF/7F8Il27ZxuVYVZ1azZ/CnW7PtNVf0/KruNbsjbW85lSIY
UiKK2gtXk4ajL21sSf9IqwaawVmWem02ehIpDlycRFm7UetD8qw1TWcGtH+U
PIoefXnc3k57mnAU6UooGJBuI7bp06xx9NePiiHYLvai0hvVVhHAHOXAKClp
RzTpI9o9LB/O0e1Rb658WsiLfFc+zWut3y8oX8RMO5bV/M6wiftIXqWsd6Ut
k7tt+Wrykf76d+o1tTcVQn/WsVzZ9OAomZsUNGYg39etW6Ze/xcpNS7MllKR
3lZho6UsU8m+1zVlbRN685/KzvQAdL2wBtL89rLBLz4y8mxenFZW05Y9bV5w
aCbNYxV3WwH0NVvF1DJ8vyn4LfaHYPOdLv4yMmyBvyArk4IBZLVVlmbbKvJi
LskMtR9fjvTe1GPBnl6N7I0x4qQYUNvq8Ja0N7syMy1lGjdD5nbfgyvBFK2O
styCUsW1QFcqWdAiymip5kb+xSy51qS5ZZOiTp5bbjYl2tv/MySzNzigTDbI
tWW5KyqaR5tqNnT2zBNqmuZ3GZ3G8e2goyXWh/0wumKBWejUDjfH2b3dQOQc
1q/m5ZqH2eOdTXfe7k6QtZfmncIlgU1rH/JyGUC0I1fWUoNUwSqld6lql9Sk
FdUSsNdGSFR2dJzKNIvQRgATufx93qaExHoM8ajX2rcRzew1bZp6iWxG0yLx
+gjUxYKOaC2jVsWM936vXdbCyR/2VhoTleLdafqmoqiUoXyMfunXOgYNTmVF
SIP/EcZzM+TXrkjZIbg/WV1bNyGvTmN92aYMCsMo6+iiNf/pU4/H8rnkBRnf
Ay18eWRr4TqXbKwWPDzgNbTTb4+1ZDsciRSmJZzp6qmg/aqng1YAO/jfau6Y
g5ty1G4dYevygS2+jy1PZljzyJvMZ1cqa2kZI0bw3Rx7vOYi6buXrhSvSjbc
uEi60oPNPGXhYR8Y7jOU45RxXO+Wbhbt1VdVvLWPub1efnFRVLhHRE1+txM1
y+jlmQuToldv1dlHyGBnjFlFT6JVxrg+rXqkKnuVY3Ssc217PN30d4HSo889
MudSq8jzQS/ntatmgq19xvnUNaOsqeu0yyS8t9LWGAkLBt/1m7v66c49i3T3
eLnEXp1sImqcCp+aQVk7t/NmtfekMsSagR49LJnidFkE9vlPW/4UQn+u3JbQ
/OvupttbJGHpTbM4aI9/NgdJavve4lBG0jGSlmjUx6F9GCUYFd2X3bUi49nK
iyRjmSfOot2OlF3aks52zEW79MEx0hUP7SPwdsuEJGHUy7x2zTtp8WzBM4Um
WnPa45GEMi6EZtHPO+OD9LWvbjtZZ1JZq8C4k1xLmXx9V6VvP4tYbXNvfGvV
Ngx6caEqt3d6Td8f8HKJvUcr/Q/ykpNsyavehX1/5SdpVahNjn2VX59q0qpM
O/8WXSatFuVkoJxX3JWko0ubXjcH/CKv9BAaIB2ak0xTu/pm67sq7e9poS0n
MjoJUaS1+ekllS78LAOOpxP1GacwpyqJhuh4PIo9afgERicpZUzK50XLJYtR
M59pKH6mXgRXaHXOvOgFVq7PvApVgZ9HVSdcFj3uSBLGUVfndvWJ4+2JDK9M
v924GELdO0AQ6Q+fOBYPz5Tz8cp8ypLXRqCTle3ayKuT3xWezLl8OBTZeiU/
8+w3ctPJbBkrB89+LaKFvMxYmIv6v/nX8Pnvgaqn+pn3VEt9i1/9FU89ai01
W57QR3vVJ/S3pRb0eUm3KK89ydLRf4dP6pVPUUZCz3KwyK3YH/W4CM/+3gK+
Ec+9F8qtWFZuRZycb5srvh/HrVuT70dfb0usmGKx6aakYSoqyPX3VaeDb6xX
XN7qFeYLyo4p6xrLjrG5v7jUWTGjuJRcu5gV49EpnoN5jCsZSTHutjOSbMRo
Z9+1R459CR32UK7dcIYSn6Mu6wylWZTbGUsFkU587FFZPYdbNrFx+LrUw5Sx
hLbqNa7OMKGIZMp5PJFozM37Uv6m3HKYZuYa8718/hrReiQouXmg7eTmAURi
prF86Ow7aeZA0rlyW/GXmdl4sQfnbDxktmi1CJeDyQNiBp9o1Nl37ZxKi0JV
TqUUrBnM3HOptOt5KOla6f64iXp8yYG6seqr/ZzKsdyU0dfOqSy5WsqpzHmy
vFWa6PGunDFPdudCnNvlnC+LY+E8sGznyypVqp0vK0b9fNntcqZplTeb/ZwH
5c3mfGncGaWj6k2XHkTK5I750pf2MNT5kTk/Gp7KQ56XH51zP5E450crafqC
8qMX5ZjzoWltSLNElNUllA99LNVWLvpAljxGERmKu3vct5o1HEl6u9DPls+5
+XW2PFrhLZrOZ2k2K1LCPET04SKwyIadvPn8VunZMW++fdMiX+gASvvmAYbV
pQSsuHfhfuh6H7hnYbzzPQvZKrtNvmchj9CKsH0PorpnsTgan5+XGxbSTP+G
RfYD7w3BdxrXACa+Z888oe5KWwZ53czRHSeCIm6kmzmSM52ctVfzAzd1AEP/
09UkXbbp3NTRWks3dTAczHRTBwaymBrrrhBAq5s6gJZ+s2FzJtYwLvhLSSKt
6RK0rIe5vKsUdGuqfW1HflTudtEIGhBI97DCGprTjSpdiwIc7jTrPtcq6tW0
IN/NsltdTmkVAvliFjrp3OlSOw00mEvXx2I73SjLF7qQ02ajM/lDF83KddUu
0sl3wyhd8CztcpMr3ZPz8SZSTHfiNH8Aa7wT51t3Ex2H2aePNnGc6nwvd/He
1aFT7uxNqjt4nlPv4tS3/cKO/wFSlLpK\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{386, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156731194]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->546452156],

Cell["Basic simplifications are automatically carried out:", "ExampleText",
 CellID->247164911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{"-", "z"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->861769126],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"NevilleThetaS", "[", 
   RowBox[{"z", ",", "m"}], "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117889009]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{"z", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102242826],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"NevilleThetaS", "[", 
   RowBox[{"z", ",", "m"}], "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271996633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220964469],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " for expressions containing Neville theta functions: "
}], "ExampleText",
 CellID->267766199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NevilleThetaS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "\[Equal]", 
   FractionBox[
    RowBox[{"NevilleThetaD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], 
    RowBox[{"JacobiDS", "[", 
     RowBox[{"z", ",", "m"}], "]"}]]}], "  ", "//", " ", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55198608],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148615273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305996662],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->132650086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"NevilleThetaS", "[", 
       RowBox[{"z", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], "3"], "+", 
     RowBox[{"NevilleThetaS", "[", 
      RowBox[{"z", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], "+", "z"}], "\[Equal]", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393951761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "1.1493400537639773`"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69528427]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->131032853],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->161876237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NevilleThetaS", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301223656],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35209860]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"NevilleThetaS", "[", 
    RowBox[{
     RowBox[{"10", "^", "3"}], ",", "2"}], "]"}], ",", "20"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->896025579],

Cell[BoxData[
 RowBox[{"2.175281171968250143816657556985378`19.90607702187664*^99224", "-", 
  
  RowBox[{
  "3.138974764780554560819744005870325`20.065349445315668*^99224", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290374820]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9588],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NevilleThetaN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NevilleThetaN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->302693564],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->581147133]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NevilleThetaS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 4.0446050}", "context" -> "System`", 
    "keywords" -> {
     "elliptic function", "Jacobi elliptic function", 
      "Neville theta function", "theta function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NevilleThetaS[z, m] gives the Neville theta function \\[CurlyTheta]_s (z \
\\[VerticalSeparator] m). ", "synonyms" -> {"Neville theta S"}, "title" -> 
    "NevilleThetaS", "type" -> "Symbol", "uri" -> "ref/NevilleThetaS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6266, 223, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88103723]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 266809, 5201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1423, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2046, 63, 51, 1, 70, "ObjectName",
 CellID->26660],
Cell[2100, 66, 780, 25, 70, "Usage",
 CellID->232553040]
}, Open  ]],
Cell[CellGroupData[{
Cell[2917, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3395, 113, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3518, 119, 1483, 52, 70, "Notes",
 CellID->332344037],
Cell[5004, 173, 520, 17, 70, "Notes",
 CellID->357751223],
Cell[5527, 192, 257, 8, 70, "Notes",
 CellID->41224833],
Cell[5787, 202, 228, 7, 70, "Notes",
 CellID->31226],
Cell[6018, 211, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6266, 223, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88103723],
Cell[CellGroupData[{
Cell[6650, 237, 148, 5, 70, "ExampleSection",
 CellID->245459113],
Cell[6801, 244, 202, 5, 70, "ExampleText",
 CellID->165320842],
Cell[CellGroupData[{
Cell[7028, 253, 158, 5, 28, "Input",
 CellID->716090850],
Cell[7189, 260, 223, 7, 36, "Output",
 CellID->14710754]
}, Open  ]],
Cell[7427, 270, 125, 3, 70, "ExampleDelimiter",
 CellID->386901079],
Cell[CellGroupData[{
Cell[7577, 277, 300, 10, 28, "Input",
 CellID->131671312],
Cell[7880, 289, 3875, 69, 160, "Output",
 Evaluatable->False,
 CellID->81615590]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11804, 364, 220, 7, 70, "ExampleSection",
 CellID->751110847],
Cell[12027, 373, 207, 5, 70, "ExampleText",
 CellID->181752673],
Cell[CellGroupData[{
Cell[12259, 382, 241, 8, 70, "Input",
 CellID->949316997],
Cell[12503, 392, 282, 9, 36, "Output",
 CellID->81007909]
}, Open  ]],
Cell[12800, 404, 125, 3, 70, "ExampleDelimiter",
 CellID->348792755],
Cell[12928, 409, 113, 3, 70, "ExampleText",
 CellID->139999503],
Cell[CellGroupData[{
Cell[13066, 416, 181, 5, 70, "Input",
 CellID->40464168],
Cell[13250, 423, 267, 8, 36, "Output",
 CellID->178897488]
}, Open  ]],
Cell[13532, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->327581776],
Cell[13660, 439, 357, 11, 70, "ExampleText",
 CellID->622073750],
Cell[CellGroupData[{
Cell[14042, 454, 205, 7, 70, "Input",
 CellID->56712901],
Cell[14250, 463, 367, 12, 36, "Output",
 CellID->225667784]
}, Open  ]],
Cell[14632, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->139623543],
Cell[14760, 483, 224, 5, 70, "ExampleText",
 CellID->8497793],
Cell[CellGroupData[{
Cell[15009, 492, 210, 7, 70, "Input",
 CellID->97908953],
Cell[15222, 501, 320, 9, 36, "Output",
 CellID->273608535]
}, Open  ]],
Cell[15557, 513, 125, 3, 70, "ExampleDelimiter",
 CellID->788262499],
Cell[15685, 518, 370, 11, 70, "ExampleText",
 CellID->514284625],
Cell[CellGroupData[{
Cell[16080, 533, 131, 4, 70, "Input",
 CellID->86235157],
Cell[16214, 539, 233, 8, 36, "Output",
 CellID->8443951]
}, Open  ]],
Cell[16462, 550, 124, 3, 70, "ExampleDelimiter",
 CellID->46966542],
Cell[16589, 555, 341, 11, 70, "ExampleText",
 CellID->362547317],
Cell[CellGroupData[{
Cell[16955, 570, 184, 6, 70, "Input",
 CellID->764212764],
Cell[17142, 578, 360, 12, 50, "Output",
 CellID->119762613]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17551, 596, 243, 7, 70, "ExampleSection",
 CellID->192316772],
Cell[17797, 605, 219, 7, 70, "ExampleText",
 CellID->682037774],
Cell[CellGroupData[{
Cell[18041, 616, 269, 9, 70, "Input",
 CellID->222541118],
Cell[18313, 627, 1685, 51, 112, "Output",
 CellID->433162790]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20047, 684, 227, 7, 70, "ExampleSection",
 CellID->154935901],
Cell[20277, 693, 75, 1, 70, "ExampleText",
 CellID->262705325],
Cell[CellGroupData[{
Cell[20377, 698, 460, 16, 70, "Input",
 CellID->45726795],
Cell[20840, 716, 18629, 309, 70, "Output",
 Evaluatable->False,
 CellID->94438969]
}, Open  ]],
Cell[39484, 1028, 122, 3, 70, "ExampleDelimiter",
 CellID->419712],
Cell[39609, 1033, 232, 5, 70, "ExampleText",
 CellID->112622043],
Cell[39844, 1040, 2309, 69, 70, "Input",
 CellID->111426961],
Cell[42156, 1111, 217, 5, 70, "ExampleText",
 CellID->727922517],
Cell[42376, 1118, 1753, 54, 70, "Input",
 CellID->234316327],
Cell[CellGroupData[{
Cell[44154, 1176, 868, 28, 70, "Input",
 CellID->73481383],
Cell[45025, 1206, 8718, 148, 70, "Output",
 Evaluatable->False,
 CellID->69106609]
}, Open  ]],
Cell[53758, 1357, 125, 3, 70, "ExampleDelimiter",
 CellID->134899328],
Cell[53886, 1362, 479, 17, 70, "ExampleText",
 CellID->63611837],
Cell[54368, 1381, 3082, 89, 70, "Input",
 CellID->17774370],
Cell[57453, 1472, 289, 10, 70, "ExampleText",
 CellID->445819958],
Cell[CellGroupData[{
Cell[57767, 1486, 452, 14, 70, "Input",
 CellID->521221765],
Cell[58222, 1502, 1514, 29, 70, "Output",
 Evaluatable->False,
 CellID->179723376]
}, Open  ]],
Cell[59751, 1534, 396, 15, 70, "ExampleText",
 CellID->186161311],
Cell[CellGroupData[{
Cell[60172, 1553, 316, 10, 70, "Input",
 CellID->352610275],
Cell[60491, 1565, 736, 16, 70, "Output",
 Evaluatable->False,
 CellID->362123272]
}, Open  ]],
Cell[61242, 1584, 123, 3, 70, "ExampleDelimiter",
 CellID->4689963],
Cell[61368, 1589, 288, 8, 70, "ExampleText",
 CellID->135928130],
Cell[61659, 1599, 967, 29, 70, "Input",
 CellID->295932],
Cell[62629, 1630, 200, 5, 70, "ExampleText",
 CellID->465920297],
Cell[CellGroupData[{
Cell[62854, 1639, 689, 19, 70, "Input",
 CellID->872996547],
Cell[63546, 1660, 187256, 3044, 70, "Output",
 CellID->497119469]
}, Open  ]],
Cell[250817, 4707, 125, 3, 70, "ExampleDelimiter",
 CellID->197073264],
Cell[250945, 4712, 219, 5, 70, "ExampleText",
 CellID->145942121],
Cell[251167, 4719, 1022, 33, 70, "Input",
 CellID->119965250],
Cell[252192, 4754, 230, 5, 70, "ExampleText",
 CellID->73665792],
Cell[CellGroupData[{
Cell[252447, 4763, 1369, 42, 70, "Input",
 CellID->440886841],
Cell[253819, 4807, 5172, 90, 70, "Output",
 Evaluatable->False,
 CellID->156731194]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[259040, 4903, 237, 7, 70, "ExampleSection",
 CellID->546452156],
Cell[259280, 4912, 95, 1, 70, "ExampleText",
 CellID->247164911],
Cell[CellGroupData[{
Cell[259400, 4917, 151, 5, 70, "Input",
 CellID->861769126],
Cell[259554, 4924, 288, 10, 36, "Output",
 CellID->117889009]
}, Open  ]],
Cell[CellGroupData[{
Cell[259879, 4939, 220, 7, 70, "Input",
 CellID->102242826],
Cell[260102, 4948, 288, 10, 36, "Output",
 CellID->271996633]
}, Open  ]],
Cell[260405, 4961, 125, 3, 70, "ExampleDelimiter",
 CellID->220964469],
Cell[260533, 4966, 247, 8, 70, "ExampleText",
 CellID->267766199],
Cell[CellGroupData[{
Cell[260805, 4978, 366, 12, 70, "Input",
 CellID->55198608],
Cell[261174, 4992, 209, 7, 36, "Output",
 CellID->148615273]
}, Open  ]],
Cell[261398, 5002, 125, 3, 70, "ExampleDelimiter",
 CellID->305996662],
Cell[261526, 5007, 96, 1, 70, "ExampleText",
 CellID->132650086],
Cell[CellGroupData[{
Cell[261647, 5012, 468, 15, 70, "Input",
 CellID->393951761],
Cell[262118, 5029, 274, 9, 36, "Output",
 CellID->69528427]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[262441, 5044, 230, 7, 70, "ExampleSection",
 CellID->131032853],
Cell[262674, 5053, 253, 7, 70, "ExampleText",
 CellID->161876237],
Cell[CellGroupData[{
Cell[262952, 5064, 158, 5, 70, "Input",
 CellID->301223656],
Cell[263113, 5071, 287, 9, 36, "Output",
 CellID->35209860]
}, Open  ]],
Cell[CellGroupData[{
Cell[263437, 5085, 216, 8, 70, "Input",
 CellID->896025579],
Cell[263656, 5095, 345, 10, 36, "Output",
 CellID->290374820]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[264062, 5112, 310, 9, 70, "SeeAlsoSection",
 CellID->9588],
Cell[264375, 5123, 726, 26, 70, "SeeAlso",
 CellID->29499]
}, Open  ]],
Cell[CellGroupData[{
Cell[265138, 5154, 319, 9, 70, "MoreAboutSection",
 CellID->302693564],
Cell[265460, 5165, 147, 3, 70, "MoreAbout",
 CellID->581147133]
}, Open  ]],
Cell[265622, 5171, 27, 0, 70, "History"],
Cell[265652, 5173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

