(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24860,        852]
NotebookOptionsPosition[     19641,        671]
NotebookOutlinePosition[     20875,        707]
CellTagsIndexPosition[     20790,        702]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Prime" :> Documentation`HelpLookup["paclet:ref/Prime"], 
          "PrimePi" :> Documentation`HelpLookup["paclet:ref/PrimePi"], 
          "RandomPrime" :> Documentation`HelpLookup["paclet:ref/RandomPrime"],
           "PrimeQ" :> Documentation`HelpLookup["paclet:ref/PrimeQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Prime\"\>", 
       2->"\<\"PrimePi\"\>", 3->"\<\"RandomPrime\"\>", 
       4->"\<\"PrimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Number Theoretic Functions\"\>", 
       2->"\<\"Number Theory\"\>", 3->"\<\"Prime Numbers\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NextPrime", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NextPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NextPrime"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the next prime above ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NextPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NextPrime"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " prime above ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The number ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " can be negative, giving previous primes."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The number ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " need not be an integer, and can be negative. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->92875155,
  ButtonNote->"92875155"]
}], "Notes",
 CellID->658277779]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->358159751],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->96930277],

Cell["The next prime after a million:", "ExampleText",
 CellID->575790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", "1000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7398958],

Cell[BoxData["1000003"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1264777461]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->593027954],

Cell["The last prime before a million:", "ExampleText",
 CellID->173445753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", 
  RowBox[{"1000000", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->527434417],

Cell[BoxData["999983"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1321649021]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NextPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NextPrime"]], "InlineFormula"],
 " allows real numbers as arguments:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->92875155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", "789.67", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386066214],

Cell[BoxData["797"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1531735026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"NextPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"10", "^", "4"}], ",", 
     RowBox[{
      RowBox[{"10", "^", "4"}], "+", "100"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92536251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWU1oE0EYnWSTVG17VAOKFLx4Ez2oF1ERFRGpHqRgFY1BSA5aqREEvQkW
Lx7UgwVpDv6APwfBUi8KoiAIxYInUUF6kF4sgsVDoBDfNzvZTCYzm9lNdhNd
ktmdmTff+2a+mTezyeFcqXD2XK5UzOeGDoznLhSK+YtD+8fGUeQkGGPT+J7I
MjxX8cS/09Uq7m66AWkShXe8HHOQnfv4Ax/WR4lTqSxX+cVuNKLGzr/Ah2Uo
cUaOPXr4YI6qkkioOilsp8Wd8imp3DHgUmSEgNXa5Yd2NHcbXErBqXkZJ/VZ
jESGkr7y1Cz6jhQ9d0eJCQuS/8JWYwnHpN0SL20o9aBW9vwZWtrKyCVSeyek
b7b2pBFtthQMobOZ8IndwsJvBA4fTFxM8/jGOq2ODUH4NJUrgrEYxuDfjxut
wFW8PRaaFyabKKXaGYcVzeNgzxxDnJr4klpsSouNYk2tjD9GlmMQOj7RR7sr
6mcdqU7vCVHEq5NK3fPRYvyqnUv8zj9JDc58qjKha/Hxw+lOVX755lOVp/BO
fU5OmMciUtQ6pDcB6te2SSn5pGSDiTHxw7fKO11uH7U/A1aRGFDqs23m7ViD
zqVemrX/oz9CIMQlv6OZtSyjtTxx/c2unZP4sI2UOPv23puf/0VVOU5hUOpQ
O5CqAJs5An17+uQTure4+Od0ME5pv3A8iZFABkbQgbRYeI40IKP+nbSpl0S5
hXPjPQpvUPR4KlTf6FF/ElD71ht8rqy5l7rL2c1Lvd3aqtlqrLWz0UlUr/kT
j9f+2qOeZOyiG2bFtzoxqvtrvMydU4DwfV1aqoCZZH0913ZovajfHd4TK20Y
5nloOhSWHvcE42vxlmLH1kqJ5PN7RtyPaC2p60LPp0d9/fJT7K8ZHoPbt96L
+h3aViOUpDFnjg7fd39mrlSW2XYfLKJ8qTQDV06OPoZ1CUs9GuVtXs58doPP
tmktHY8F1a4/7SmP3mYcq9Fjzp95Vp6aZf2UUF7Ub4rZE++3XeHJoYNlFIX3
hB7NukCgAkdDjNriCdPjXmP2U6VWM1hvsbayisZaOxudRAX1B+olVHKQqyRa
QTipKqttdZlHCwt58u4HSCTeWNaacenXr765/8VhouMlg63RYq8o/q5u6M1V
ba1ZkRwpb4qnnjGKX8/Uudlt5nq80zzeCAy2MaoajNQTyl5T+h4to5zvAWYc
EEAumNvRItfiu7ffsYPULTb+Xy7/k84SfwELFDZZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36969052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->702596657],

Cell["Arguments can be negative:", "ExampleText",
 CellID->1606058847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", 
  RowBox[{"-", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1656954773],

Cell[BoxData[
 RowBox[{"-", "7"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733269535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2678170],

Cell["A negative second argument gives previous primes:", "ExampleText",
 CellID->271548295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", 
  RowBox[{"11", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580031235],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1799908259]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Plot prime gaps around powers of 10:", "ExampleText",
 CellID->84304871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"NextPrime", "[", 
      RowBox[{"10", "^", "s"}], "]"}], "-", 
     RowBox[{"NextPrime", "[", 
      RowBox[{
       RowBox[{"10", "^", "s"}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5634],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 4.}, {2., 4.}, {3., 12.}, {4., 34.}, {5., 12.}, {6., 20.}, {
     7., 28.}, {8., 18.}, {9., 70.}, {10., 52.}, {11., 26.}, {12., 50.}, {13.,
      66.}, {14., 58.}, {15., 48.}, {16., 124.}, {17., 6.}, {18., 14.}, {19., 
     90.}, {20., 50.}, {21., 218.}, {22., 36.}, {23., 140.}, {24., 264.}, {
     25., 136.}, {26., 208.}, {27., 202.}, {28., 540.}, {29., 346.}, {30., 
     68.}, {31., 60.}, {32., 70.}, {33., 70.}, {34., 604.}, {35., 92.}, {36., 
     226.}, {37., 124.}, {38., 192.}, {39., 60.}, {40., 138.}, {41., 228.}, {
     42., 146.}, {43., 138.}, {44., 84.}, {45., 18.}, {46., 154.}, {47., 
     74.}, {48., 226.}, {49., 66.}, {50., 208.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{223., Automatic},
  PlotRange->{{0., 50.}, {0., 604.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{227, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1603457371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140395543],

Cell["Find twin primes:", "ExampleText",
 CellID->42436644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "1000", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"PrimeQ", "[", "#", "]"}], "&&", 
     RowBox[{
      RowBox[{"NextPrime", "[", "#", "]"}], "\[Equal]", 
      RowBox[{"2", "+", "#"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751497951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "5", ",", "11", ",", "17", ",", "29", ",", "41", ",", "59", ",", 
   "71", ",", "101", ",", "107", ",", "137", ",", "149", ",", "179", ",", 
   "191", ",", "197", ",", "227", ",", "239", ",", "269", ",", "281", ",", 
   "311", ",", "347", ",", "419", ",", "431", ",", "461", ",", "521", ",", 
   "569", ",", "599", ",", "617", ",", "641", ",", "659", ",", "809", ",", 
   "821", ",", "827", ",", "857", ",", "881"}], "}"}]], "Output",
 ImageSize->{549, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535748194]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", "1000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119616394],

Cell[BoxData["1000003"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2068448334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "1000000", "]"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->920700143],

Cell[BoxData["1000003"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->945871902]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimePi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->562718417],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->14076414],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->78223612],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->66383904],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->1105195],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->258573668]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NextPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 5.4196402}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NextPrime[n] gives the next prime above n. NextPrime[n, k] gives the \
k\\[Null]^th prime above n.", "synonyms" -> {"next prime"}, "title" -> 
    "NextPrime", "type" -> "Symbol", "uri" -> "ref/NextPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7182, 213, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->358159751]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20647, 695}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2811, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3434, 91, 1574, 37, 70, "ObjectNameGrid"],
Cell[5011, 130, 1152, 38, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6200, 173, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6678, 190, 174, 6, 70, "Notes",
 CellID->1067943069],
Cell[6855, 198, 290, 10, 70, "Notes",
 CellID->658277779]
}, Closed]],
Cell[CellGroupData[{
Cell[7182, 213, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->358159751],
Cell[CellGroupData[{
Cell[7567, 227, 147, 5, 70, "ExampleSection",
 CellID->96930277],
Cell[7717, 234, 71, 1, 70, "ExampleText",
 CellID->575790],
Cell[CellGroupData[{
Cell[7813, 239, 109, 3, 28, "Input",
 CellID->7398958],
Cell[7925, 244, 165, 5, 36, "Output",
 CellID->1264777461]
}, Open  ]],
Cell[8105, 252, 125, 3, 70, "ExampleDelimiter",
 CellID->593027954],
Cell[8233, 257, 75, 1, 70, "ExampleText",
 CellID->173445753],
Cell[CellGroupData[{
Cell[8333, 262, 153, 5, 70, "Input",
 CellID->527434417],
Cell[8489, 269, 164, 5, 36, "Output",
 CellID->1321649021]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8702, 280, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8926, 289, 260, 8, 70, "ExampleText",
 CellID->92875155],
Cell[CellGroupData[{
Cell[9211, 301, 110, 3, 70, "Input",
 CellID->386066214],
Cell[9324, 306, 161, 5, 36, "Output",
 CellID->1531735026]
}, Open  ]],
Cell[CellGroupData[{
Cell[9522, 316, 301, 10, 70, "Input",
 CellID->92536251],
Cell[9826, 328, 1471, 28, 70, "Output",
 Evaluatable->False,
 CellID->36969052]
}, Open  ]],
Cell[11312, 359, 125, 3, 70, "ExampleDelimiter",
 CellID->702596657],
Cell[11440, 364, 70, 1, 70, "ExampleText",
 CellID->1606058847],
Cell[CellGroupData[{
Cell[11535, 369, 125, 4, 70, "Input",
 CellID->1656954773],
Cell[11663, 375, 175, 6, 36, "Output",
 CellID->733269535]
}, Open  ]],
Cell[11853, 384, 123, 3, 70, "ExampleDelimiter",
 CellID->2678170],
Cell[11979, 389, 92, 1, 70, "ExampleText",
 CellID->271548295],
Cell[CellGroupData[{
Cell[12096, 394, 148, 5, 70, "Input",
 CellID->580031235],
Cell[12247, 401, 159, 5, 36, "Output",
 CellID->1799908259]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12455, 412, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[12685, 421, 78, 1, 70, "ExampleText",
 CellID->84304871],
Cell[CellGroupData[{
Cell[12788, 426, 421, 14, 70, "Input",
 CellID->5634],
Cell[13212, 442, 1154, 26, 165, "Output",
 CellID->1603457371]
}, Open  ]],
Cell[14381, 471, 125, 3, 70, "ExampleDelimiter",
 CellID->140395543],
Cell[14509, 476, 59, 1, 70, "ExampleText",
 CellID->42436644],
Cell[CellGroupData[{
Cell[14593, 481, 342, 11, 70, "Input",
 CellID->751497951],
Cell[14938, 494, 617, 13, 54, "Output",
 CellID->535748194]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15604, 513, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[CellGroupData[{
Cell[15867, 524, 111, 3, 70, "Input",
 CellID->119616394],
Cell[15981, 529, 165, 5, 36, "Output",
 CellID->2068448334]
}, Open  ]],
Cell[CellGroupData[{
Cell[16183, 539, 165, 5, 70, "Input",
 CellID->920700143],
Cell[16351, 546, 164, 5, 36, "Output",
 CellID->945871902]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16576, 558, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16895, 569, 939, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17871, 609, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[18192, 620, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[18427, 629, 319, 9, 70, "MoreAboutSection",
 CellID->562718417],
Cell[18749, 640, 161, 3, 70, "MoreAbout",
 CellID->14076414],
Cell[18913, 645, 136, 3, 70, "MoreAbout",
 CellID->78223612],
Cell[19052, 650, 136, 3, 70, "MoreAbout",
 CellID->66383904],
Cell[19191, 655, 177, 3, 70, "MoreAbout",
 CellID->1105195],
Cell[19371, 660, 198, 4, 70, "MoreAbout",
 CellID->258573668]
}, Open  ]],
Cell[19584, 667, 27, 0, 70, "History"],
Cell[19614, 669, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

