(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15184,        580]
NotebookOptionsPosition[     11570,        459]
NotebookOutlinePosition[     13011,        499]
CellTagsIndexPosition[     12926,        494]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differentiation" :> 
          Documentation`HelpLookup["paclet:tutorial/Differentiation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Differentiation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dt" :> Documentation`HelpLookup["paclet:ref/Dt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NonConstants", "ObjectName",
 CellID->5741],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NonConstants",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NonConstants"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/D"]], "InlineFormula"],
     " which gives a list of objects to be taken to depend implicitly on the \
differentiation variables. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " does not appear in the list of ",
 Cell[BoxData[
  ButtonBox["NonConstants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonConstants"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData["0"], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " are identical expressions. "
}], "Notes",
 CellID->4609]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136113834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2516946],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " is treated as a constant under differentiation:"
}], "ExampleText",
 CellID->582387751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"c", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41869088],

Cell[BoxData[
 RowBox[{"2", " ", "c", " ", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369914557]
}, Open  ]],

Cell[TextData[{
 "Specify that ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " depends implicitly on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->123669442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"c", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", "x", ",", " ", 
   RowBox[{"NonConstants", " ", "\[Rule]", " ", 
    RowBox[{"{", "c", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142955896],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "c", " ", "x"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"D", "[", 
    RowBox[{"c", ",", "x", ",", 
     RowBox[{"NonConstants", "\[Rule]", 
      RowBox[{"{", "c", "}"}]}]}], "]"}]}]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120367438]
}, Open  ]],

Cell[TextData[{
 "Specify that both ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " depend implicitly on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->41170259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "d"}], ",", " ", "x", ",", " ", 
   RowBox[{"NonConstants", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->531751470],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "c", " ", "x"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"D", "[", 
    RowBox[{"c", ",", "x", ",", 
     RowBox[{"NonConstants", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}]}], "]"}]}], "+", 
  RowBox[{"D", "[", 
   RowBox[{"d", ",", "x", ",", 
    RowBox[{"NonConstants", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}]}], "]"}]}]], "Output",
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->190749991]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NonConstants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonConstants"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " to emulate ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->791938067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}], ",", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x", ",", 
     RowBox[{"NonConstants", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57345850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Dt", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "+", 
    RowBox[{"Dt", "[", 
     RowBox[{"b", ",", "x"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"D", "[", 
      RowBox[{"a", ",", "x", ",", 
       RowBox[{"NonConstants", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}], "+", 
    RowBox[{"D", "[", 
     RowBox[{"b", ",", "x", ",", 
      RowBox[{"NonConstants", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{479, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->459920192]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392826432],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Constants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constants"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 " to emulate ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->252662062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x", ",", 
     RowBox[{"Constants", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->624858263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "a", " ", "x"}], ",", 
   RowBox[{"2", " ", "a", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427266133]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14779],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->11343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16019],

Cell[TextData[ButtonBox["Differentiation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Differentiation"]], "Tutorials",
 CellID->25827]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NonConstants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 25.3889014}", "context" -> "System`", 
    "keywords" -> {
     "dependent functions", "dependent variables in differentiation", 
      "differentiation variables", 
      "implicit dependencies in differentiation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NonConstants is an option for D which gives a list of objects to be \
taken to depend implicitly on the differentiation variables. ", 
    "synonyms" -> {"non constants"}, "title" -> "NonConstants", "type" -> 
    "Symbol", "uri" -> "ref/NonConstants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3688, 133, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->136113834]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12783, 487}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1110, 29, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1733, 56, 49, 1, 70, "ObjectName",
 CellID->5741],
Cell[1785, 59, 637, 19, 70, "Usage",
 CellID->7056]
}, Open  ]],
Cell[CellGroupData[{
Cell[2459, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2937, 100, 714, 28, 70, "Notes",
 CellID->4609]
}, Closed]],
Cell[CellGroupData[{
Cell[3688, 133, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136113834],
Cell[CellGroupData[{
Cell[4073, 147, 146, 5, 70, "ExampleSection",
 CellID->2516946],
Cell[4222, 154, 173, 6, 70, "ExampleText",
 CellID->582387751],
Cell[CellGroupData[{
Cell[4420, 164, 173, 6, 28, "Input",
 CellID->41869088],
Cell[4596, 172, 190, 6, 36, "Output",
 CellID->369914557]
}, Open  ]],
Cell[4801, 181, 219, 9, 70, "ExampleText",
 CellID->123669442],
Cell[CellGroupData[{
Cell[5045, 194, 265, 8, 28, "Input",
 CellID->142955896],
Cell[5313, 204, 396, 13, 36, "Output",
 CellID->120367438]
}, Open  ]],
Cell[5724, 220, 289, 12, 70, "ExampleText",
 CellID->41170259],
Cell[CellGroupData[{
Cell[6038, 236, 317, 10, 70, "Input",
 CellID->531751470],
Cell[6358, 248, 591, 19, 36, "Output",
 CellID->190749991]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6998, 273, 233, 7, 70, "ExampleSection",
 CellID->13991],
Cell[7234, 282, 429, 17, 70, "ExampleText",
 CellID->791938067],
Cell[CellGroupData[{
Cell[7688, 303, 493, 17, 70, "Input",
 CellID->57345850],
Cell[8184, 322, 901, 29, 58, "Output",
 CellID->459920192]
}, Open  ]],
Cell[9100, 354, 125, 3, 70, "ExampleDelimiter",
 CellID->392826432],
Cell[9228, 359, 423, 17, 70, "ExampleText",
 CellID->252662062],
Cell[CellGroupData[{
Cell[9676, 380, 494, 18, 70, "Input",
 CellID->624858263],
Cell[10173, 400, 271, 9, 36, "Output",
 CellID->427266133]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10505, 416, 311, 9, 70, "SeeAlsoSection",
 CellID->14779],
Cell[10819, 427, 184, 6, 70, "SeeAlso",
 CellID->11343]
}, Open  ]],
Cell[CellGroupData[{
Cell[11040, 438, 314, 9, 70, "TutorialsSection",
 CellID->16019],
Cell[11357, 449, 141, 3, 70, "Tutorials",
 CellID->25827]
}, Open  ]],
Cell[11513, 455, 27, 0, 70, "History"],
Cell[11543, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

