(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10196,        361]
NotebookOptionsPosition[      7783,        281]
NotebookOutlinePosition[      9050,        318]
CellTagsIndexPosition[      8966,        313]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Positive" :> Documentation`HelpLookup["paclet:ref/Positive"], 
          "Negative" :> Documentation`HelpLookup["paclet:ref/Negative"], 
          "NonNegative" :> Documentation`HelpLookup["paclet:ref/NonNegative"],
           "Sign" :> Documentation`HelpLookup["paclet:ref/Sign"], "Less" :> 
          Documentation`HelpLookup["paclet:ref/Less"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Positive\"\>", 
       2->"\<\"Negative\"\>", 3->"\<\"NonNegative\"\>", 4->"\<\"Sign\"\>", 
       5->"\<\"Less\"\>", 6->"\<\"Simplify\"\>", 
       7->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NonPositive", "ObjectName",
 CellID->16015],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NonPositive",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NonPositive"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a non\[Hyphen]positive number. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->3139917],

Cell["Evaluate different types of numbers:", "ExampleText",
 CellID->115213883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonPositive", "[", 
  RowBox[{"{", 
   RowBox[{"1.6", ",", 
    RowBox[{"3", "/", "4"}], ",", "Pi", ",", "0", ",", 
    RowBox[{"-", "5"}], ",", 
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", "^", "5"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187009233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "True", ",", "True", ",", "False",
    ",", "False"}], "}"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380733520]
}, Open  ]],

Cell[TextData[{
 "Quantities that are not ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " remain unevaluated:"
}], "ExampleText",
 CellID->236549865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonPositive", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"Sin", "[", "y", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238276832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NonPositive", "[", "x", "]"}], ",", 
   RowBox[{"NonPositive", "[", 
    RowBox[{"Sin", "[", "y", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127861488]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14017],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Negative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Negative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonNegative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonNegative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Less",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Less"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->6300202]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NonPositive - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 29.0921212}", "context" -> "System`", 
    "keywords" -> {
     "non-positive", "non-positive number", "testing if non-positive"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NonPositive[x] gives True if x is a non-positive number. ", 
    "synonyms" -> {"non positive"}, "title" -> "NonPositive", "type" -> 
    "Symbol", "uri" -> "ref/NonPositive"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3153, 96, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8832, 306}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1738, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2361, 65, 49, 1, 70, "ObjectName",
 CellID->16015],
Cell[2413, 68, 703, 23, 70, "Usage",
 CellID->19372]
}, Open  ]],
Cell[CellGroupData[{
Cell[3153, 96, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3530, 110, 146, 5, 70, "ExampleSection",
 CellID->3139917],
Cell[3679, 117, 79, 1, 70, "ExampleText",
 CellID->115213883],
Cell[CellGroupData[{
Cell[3783, 122, 336, 10, 28, "Input",
 CellID->187009233],
Cell[4122, 134, 287, 9, 36, "Output",
 CellID->380733520]
}, Open  ]],
Cell[4424, 146, 226, 8, 70, "ExampleText",
 CellID->236549865],
Cell[CellGroupData[{
Cell[4675, 158, 186, 6, 28, "Input",
 CellID->238276832],
Cell[4864, 166, 314, 10, 36, "Output",
 CellID->127861488]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5239, 183, 311, 9, 70, "SeeAlsoSection",
 CellID->14017],
Cell[5553, 194, 1672, 62, 70, "SeeAlso",
 CellID->20485]
}, Open  ]],
Cell[CellGroupData[{
Cell[7262, 261, 299, 8, 70, "MoreAboutSection"],
Cell[7564, 271, 147, 3, 70, "MoreAbout",
 CellID->6300202]
}, Open  ]],
Cell[7726, 277, 27, 0, 70, "History"],
Cell[7756, 279, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

