(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50283,       1084]
NotebookOptionsPosition[     47286,        985]
NotebookOutlinePosition[     48578,       1022]
CellTagsIndexPosition[     48492,       1017]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "Automatic" :> 
         Documentation`HelpLookup["paclet:ref/Automatic"], "Null" :> 
         Documentation`HelpLookup["paclet:ref/Null"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"All\"\>", 2->"\<\"Automatic\"\>", 
      3->"\<\"Null\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["None", "ObjectName",
 CellID->17192],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     "\[LineSeparator]is a setting used for certain options. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7546]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->1560011],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ", Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to only show the contour lines:"
}], "ExampleText",
 CellID->170919351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ContourShading", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522438672],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnXmYVcWZxq9KWEUBCZnRmbihgmJk2iBi36QQN3CLcUE0wSAoGhDsiEKL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   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1340, 1586, 1341, 1611, 1610, 1618, 1617, 1347, 1615, 1616, 
         1614, 1686, 1346, 1577, 1495}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1342, 1587, 1343, 1613, 1612, 1635, 1634, 1511, 1578, 1579, 
         1492, 1512, 1335, 1591, 1589}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1390, 1519, 1356, 1864, 1386, 1646, 1647, 1648, 1322, 1385, 
         1861, 1863, 1862, 1352, 1853, 1854, 1636, 1637, 1638, 1320, 1376, 
         1851, 1377, 1852, 1348, 1517, 1593}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1433, 1506, 1505, 1917, 1435, 1915, 1434, 1916, 1530, 1667, 
         1666, 1665, 1923, 1922, 1508, 1926, 1927, 1924, 1442, 1925, 1533, 
         1673, 1672, 1671, 1449, 1933, 1509, 1510, 1598}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1266, 1518, 1641, 1640, 1639, 1378, 1496, 1321, 1265, 1981, 
         1379, 1353, 1866, 1867, 1865, 1387, 1323, 1270, 1703, 1704, 1676, 
         2003, 1677, 1706, 1705, 1873, 1325, 1272, 1982, 1391, 1357, 1876, 
         1398, 1875, 1397, 1327, 1499, 1400, 1877, 1399, 1878, 1521, 1549}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1319, 1334, 1447, 1932, 1448, 1532, 1531, 1920, 1440, 1919, 
         1441, 1921, 1507, 1439, 2001, 1317, 1529, 1914, 1832, 1833, 1829, 
         1371, 1828, 1831, 1830, 1313, 1528, 1903, 1904, 1902, 1906, 1905, 
         1504, 1428, 1998, 1309, 1525, 1526, 1421, 1653, 1654, 1655, 1331, 
         1562}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1280, 1988, 1409, 1360, 1620, 1361, 1621, 1279, 1723, 1362, 
         1722, 1725, 1724, 1281, 1522, 1881, 1882, 1880, 1407, 1883, 1500, 
         1501, 1405, 1406, 1359, 1403, 1986, 1276, 1328, 1401, 2004, 1402, 
         1358, 1393, 1984, 1274, 1498, 1497, 1392, 1983, 1273, 1520, 1868, 
         1695, 1696, 1693, 1354, 1694, 1381, 1619, 1350, 1687, 1349, 1856, 
         1857, 1855, 1380}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1299, 1652, 1899, 1898, 1628, 1603, 1368, 1624, 1416, 1897, 
         1896, 1680, 1812, 1811, 1895, 1330, 1298, 1989, 1415, 1369, 1523, 
         1303, 1992, 1418, 1502, 1420, 2005, 1419, 1524, 1308, 1997, 1425, 
         1503, 1427, 2006, 1426, 1527, 1370, 1913, 1432, 1912, 1431, 1333, 
         1312, 1843, 1844, 1683, 1684, 1685, 1316, 1625, 1375, 1604, 1605, 
         1930, 1931, 1929, 1446}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1267, 1689, 1690, 1688, 1692, 1691, 1858, 1698, 1699, 1697, 
         1701, 1700, 1869, 1708, 1709, 1707, 1711, 1710, 1874, 1713, 1714, 
         1712, 1716, 1715, 1879, 1718, 1719, 1717, 1721, 1720, 1884, 1727, 
         1728, 1726, 1730, 1729, 1885, 1736, 1737, 1735, 1739, 1738, 1962, 
         1963, 1595, 1474, 1553, 1552, 1291, 1776, 1777, 1775, 1779, 1778, 
         1292, 1781, 1782, 1780, 1784, 1783, 1293, 1786, 1787, 1785, 1789, 
         1788, 1294, 1791, 1792, 1790, 1794, 1793, 1295, 1796, 1797, 1795, 
         1799, 1798, 1296, 1801, 1802, 1800, 1804, 1803, 1297}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1889, 1741, 1742, 1740, 1744, 1743, 1284, 1746, 1747, 1745, 
         1749, 1748, 1285, 1751, 1752, 1750, 1754, 1753, 1286, 1756, 1757, 
         1755, 1759, 1758, 1287, 1761, 1762, 1760, 1764, 1763, 1288, 1766, 
         1767, 1765, 1769, 1768, 1289, 1771, 1772, 1770, 1774, 1773, 1290, 
         1596, 1411, 1555, 1554, 1890, 1807, 1808, 1806, 1810, 1809, 1894, 
         1814, 1815, 1813, 1817, 1816, 1900, 1819, 1820, 1818, 1822, 1821, 
         1901, 1824, 1825, 1823, 1827, 1826, 1911, 1839, 1840, 1838, 1842, 
         1841, 1918, 1847, 1848, 1846, 1850, 1849, 1928}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1268, 1642, 1860, 1859, 1351, 1599, 1600, 1601, 1269, 1702, 
         1355, 1674, 1675, 1324, 1271, 1539, 1275, 1985, 1460, 1394, 1543, 
         1461, 2007, 1462, 1395, 1465, 2010, 1464, 1545, 1466, 2008, 1467, 
         1404, 1472, 2011, 1471, 1550, 1408, 1473, 1987, 1277, 1551, 1282, 
         1732, 1733, 1731, 1363, 1734, 1283, 1623, 1364, 1622, 1365, 1887, 
         1888, 1886, 1410}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1318, 2002, 1445, 1374, 1845, 1373, 2009, 1629, 1438, 1837, 
         1372, 1834, 1836, 1835, 1910, 1568, 1971, 1972, 1970, 1486, 1973, 
         1424, 1564, 1307, 1996, 1484, 1423, 1483, 1995, 1306, 1561, 1302, 
         1991, 1480, 1417, 1479, 1990, 1301, 1557, 1414, 1967, 1476, 1966, 
         1475, 1556, 1965, 1329, 1964, 1679, 1367, 1805, 1412, 1627, 1626, 
         1602, 1366, 1892, 1893, 1891, 1413}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1278, 1548, 1651, 1650, 1649, 1470, 1547, 1546, 1960, 1468, 
         1959, 1469, 1961, 1396, 1957, 1958, 1956, 1463, 1544, 1955, 1326, 
         1954, 1678, 1388, 1870, 1872, 1871, 1947, 1540, 1943, 1944, 1942, 
         1946, 1945, 1382, 1935, 1452, 1934, 1451, 1535, 1536, 1450, 1643, 
         1644, 1645, 1534, 1575}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1300, 1558, 1477, 1968, 1478, 1560, 1559, 1304, 1993, 1481, 
         1422, 1482, 1994, 1305, 1563, 1310, 1908, 1909, 1907, 1430, 1681, 
         1682, 1332, 1311, 1567, 1314, 1999, 1487, 1437, 1488, 2000, 1315, 
         1570, 1571, 1491, 1979, 1490, 1980, 1573, 1574}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1444, 1572, 1443, 1978, 1489, 1668, 1669, 1670, 1569, 1664, 
         1663, 1662, 1977, 1976, 1436, 1974, 1975, 1659, 1660, 1661, 1566, 
         1658, 1657, 1656, 1485, 1969, 1429, 1565, 1597}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1453, 1537, 1383, 1938, 1455, 1936, 1454, 1937, 1538, 1456, 
         1939, 1941, 1940, 1384, 1950, 1951, 1948, 1457, 1949, 1541, 1458, 
         1952, 1459, 1953, 1389, 1542, 1594}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1336, 1582, 1337, 1607, 1606, 1631, 1630, 1513, 1580, 1581, 
         1493, 1515, 1344, 1592, 1590}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1338, 1585, 1339, 1609, 1608, 1633, 1632, 1514, 1583, 1584, 
         1494, 1516, 1345, 1588, 1576}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87829275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15058177],

Cell["Plot only mesh lines:", "ExampleText",
 CellID->28152926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"Cos", "[", "y", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"Sin", "[", "y", "]"}]}], ",", 
     RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216606411],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340934767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54585871],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to indicate holes or the no content for mesh regions: "
}], "ExampleText",
 CellID->623678210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "8"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Orange", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "Blue"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43800131],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161213401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506485777],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to indicate no vertex labels should be used: "
}], "ExampleText",
 CellID->49241855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"{", "#", "}"}], ",", "#"}], "}"}], "&"}], ",", "x", ",", 
     "4"}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186312259],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJyFlU9IVFEUxmeiMgQjSTNHncbR0TGt+VPgqt6DKIyCZGAWFoFGBkEoCEVF
SuRiQNpEIBURFNRKiGiC3Ahh1CBIBIFBRIuJhjDJWchbVFhx/b7LOTPRwPD4
7u/e75537j3nNZ8aTg2u8/l89//8/z6fZIOL/a2t7rPpS+cPfKpwvy1HP3d+
qHTHrs1tPJFf7/Ycabg1Uig65ulfm7fghKPvUzULvxzf2s+Mew641vAxukCO
cfjJeR7nyzhKn9n/+OIpfb2ScR2HfG/PQX4wDo11yJuMw8886rxCy/gryOFf
fv8i52M9uNbPxblVkU89nu0fO7vFle9fRX9wrbPiXKrJA8Hw/mMD25if/JeR
N2cGt7oyr9XcD1xrmZ8acvjDDxoc88vHY7XMdx15b/rtVPfJelfeizr6g2st
zytAjvrCOUMjPzOzsYlN6R3cL3P9akOor1Gdd4D+4FrjfYxPEzn84Qct66OJ
68G1xv0x5x8ivzw6fOVitJn+4PAH11reH8uRH+RD9ifPqa1//fTco7DqS9YP
XGvEb+5XC7k8D7s/OOZjPbjW6IPmnC0/2nshnH4QUffZ+oNrjfXmvraRj2ci
N/bdizI/hcX5vsOhdlUfbdwPXGt5/y2HP/ygZb9pL4lHa8Rv6qODPNgymks0
7lT100F/cK1lP7P85uTtoR+5OOsrfbyrO7B9F+treubdauROJ/OF9dgfXGtZ
X13k8IcfNDjmY72Mx2pZr5Yvr4wPbZ7c7crvlvUH11rWe4wc+UE+oOH/KreU
8lfGVX+I0Q9ca/n9iJecR/n9i5yP9eBa4/6YfpEgHzh9cGIlk6A/OPzBtZb9
xvKfq3dffN2wh/mJJYsPvx9Kqu+V3Q9ca/iZfmM5/OEHLftZ8h/xWC37keVz
8z0f8y+tPzj8wbWW/W4v+W+Lk8Pa
    "], {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 55}, {1, 109}, {2, 3}, {2, 20}, {2, 38}, {3, 4}, {
       3, 9}, {3, 15}, {4, 5}, {4, 6}, {4, 8}, {6, 7}, {9, 10}, {10, 11}, {10,
        12}, {10, 14}, {12, 13}, {15, 16}, {15, 17}, {15, 19}, {17, 18}, {20, 
       21}, {21, 22}, {21, 27}, {21, 33}, {22, 23}, {22, 24}, {22, 26}, {24, 
       25}, {27, 28}, {28, 29}, {28, 30}, {28, 32}, {30, 31}, {33, 34}, {33, 
       35}, {33, 37}, {35, 36}, {38, 39}, {38, 44}, {38, 50}, {39, 40}, {39, 
       41}, {39, 43}, {41, 42}, {44, 45}, {45, 46}, {45, 47}, {45, 49}, {47, 
       48}, {50, 51}, {50, 52}, {50, 54}, {52, 53}, {55, 56}, {56, 57}, {56, 
       74}, {56, 92}, {57, 58}, {57, 63}, {57, 69}, {58, 59}, {58, 60}, {58, 
       62}, {60, 61}, {63, 64}, {64, 65}, {64, 66}, {64, 68}, {66, 67}, {69, 
       70}, {69, 71}, {69, 73}, {71, 72}, {74, 75}, {75, 76}, {75, 81}, {75, 
       87}, {76, 77}, {76, 78}, {76, 80}, {78, 79}, {81, 82}, {82, 83}, {82, 
       84}, {82, 86}, {84, 85}, {87, 88}, {87, 89}, {87, 91}, {89, 90}, {92, 
       93}, {92, 98}, {92, 104}, {93, 94}, {93, 95}, {93, 97}, {95, 96}, {98, 
       99}, {99, 100}, {99, 101}, {99, 103}, {101, 102}, {104, 105}, {104, 
       106}, {104, 108}, {106, 107}, {109, 110}, {109, 127}, {109, 145}, {110,
        111}, {110, 116}, {110, 122}, {111, 112}, {111, 113}, {111, 115}, {
       113, 114}, {116, 117}, {117, 118}, {117, 119}, {117, 121}, {119, 
       120}, {122, 123}, {122, 124}, {122, 126}, {124, 125}, {127, 128}, {128,
        129}, {128, 134}, {128, 140}, {129, 130}, {129, 131}, {129, 133}, {
       131, 132}, {134, 135}, {135, 136}, {135, 137}, {135, 139}, {137, 
       138}, {140, 141}, {140, 142}, {140, 144}, {142, 143}, {145, 146}, {145,
        151}, {145, 157}, {146, 147}, {146, 148}, {146, 150}, {148, 149}, {
       151, 152}, {152, 153}, {152, 154}, {152, 156}, {154, 155}, {157, 
       158}, {157, 159}, {157, 161}, {159, 160}}]}, 
     {RGBColor[0, 0, 0.7], PointBox[1], PointBox[2], PointBox[3], PointBox[4],
       PointBox[5], PointBox[6], PointBox[7], PointBox[8], PointBox[9], 
      PointBox[10], PointBox[11], PointBox[12], PointBox[13], PointBox[14], 
      PointBox[15], PointBox[16], PointBox[17], PointBox[18], PointBox[19], 
      PointBox[20], PointBox[21], PointBox[22], PointBox[23], PointBox[24], 
      PointBox[25], PointBox[26], PointBox[27], PointBox[28], PointBox[29], 
      PointBox[30], PointBox[31], PointBox[32], PointBox[33], PointBox[34], 
      PointBox[35], PointBox[36], PointBox[37], PointBox[38], PointBox[39], 
      PointBox[40], PointBox[41], PointBox[42], PointBox[43], PointBox[44], 
      PointBox[45], PointBox[46], PointBox[47], PointBox[48], PointBox[49], 
      PointBox[50], PointBox[51], PointBox[52], PointBox[53], PointBox[54], 
      PointBox[55], PointBox[56], PointBox[57], PointBox[58], PointBox[59], 
      PointBox[60], PointBox[61], PointBox[62], PointBox[63], PointBox[64], 
      PointBox[65], PointBox[66], PointBox[67], PointBox[68], PointBox[69], 
      PointBox[70], PointBox[71], PointBox[72], PointBox[73], PointBox[74], 
      PointBox[75], PointBox[76], PointBox[77], PointBox[78], PointBox[79], 
      PointBox[80], PointBox[81], PointBox[82], PointBox[83], PointBox[84], 
      PointBox[85], PointBox[86], PointBox[87], PointBox[88], PointBox[89], 
      PointBox[90], PointBox[91], PointBox[92], PointBox[93], PointBox[94], 
      PointBox[95], PointBox[96], PointBox[97], PointBox[98], PointBox[99], 
      PointBox[100], PointBox[101], PointBox[102], PointBox[103], 
      PointBox[104], PointBox[105], PointBox[106], PointBox[107], 
      PointBox[108], PointBox[109], PointBox[110], PointBox[111], 
      PointBox[112], PointBox[113], PointBox[114], PointBox[115], 
      PointBox[116], PointBox[117], PointBox[118], PointBox[119], 
      PointBox[120], PointBox[121], PointBox[122], PointBox[123], 
      PointBox[124], PointBox[125], PointBox[126], PointBox[127], 
      PointBox[128], PointBox[129], PointBox[130], PointBox[131], 
      PointBox[132], PointBox[133], PointBox[134], PointBox[135], 
      PointBox[136], PointBox[137], PointBox[138], PointBox[139], 
      PointBox[140], PointBox[141], PointBox[142], PointBox[143], 
      PointBox[144], PointBox[145], PointBox[146], PointBox[147], 
      PointBox[148], PointBox[149], PointBox[150], PointBox[151], 
      PointBox[152], PointBox[153], PointBox[154], PointBox[155], 
      PointBox[156], PointBox[157], PointBox[158], PointBox[159], 
      PointBox[160], PointBox[161]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJyFlU9IVFEUxmeiMgQjSTNHncbR0TGt+VPgqt6DKIyCZGAWFoFGBkEoCEVF
SuRiQNpEIBURFNRKiGiC3Ahh1CBIBIFBRIuJhjDJWchbVFhx/b7LOTPRwPD4
7u/e75537j3nNZ8aTg2u8/l89//8/z6fZIOL/a2t7rPpS+cPfKpwvy1HP3d+
qHTHrs1tPJFf7/Ycabg1Uig65ulfm7fghKPvUzULvxzf2s+Mew641vAxukCO
cfjJeR7nyzhKn9n/+OIpfb2ScR2HfG/PQX4wDo11yJuMw8886rxCy/gryOFf
fv8i52M9uNbPxblVkU89nu0fO7vFle9fRX9wrbPiXKrJA8Hw/mMD25if/JeR
N2cGt7oyr9XcD1xrmZ8acvjDDxoc88vHY7XMdx15b/rtVPfJelfeizr6g2st
zytAjvrCOUMjPzOzsYlN6R3cL3P9akOor1Gdd4D+4FrjfYxPEzn84Qct66OJ
68G1xv0x5x8ivzw6fOVitJn+4PAH11reH8uRH+RD9ifPqa1//fTco7DqS9YP
XGvEb+5XC7k8D7s/OOZjPbjW6IPmnC0/2nshnH4QUffZ+oNrjfXmvraRj2ci
N/bdizI/hcX5vsOhdlUfbdwPXGt5/y2HP/ygZb9pL4lHa8Rv6qODPNgymks0
7lT100F/cK1lP7P85uTtoR+5OOsrfbyrO7B9F+treubdauROJ/OF9dgfXGtZ
X13k8IcfNDjmY72Mx2pZr5Yvr4wPbZ7c7crvlvUH11rWe4wc+UE+oOH/KreU
8lfGVX+I0Q9ca/n9iJecR/n9i5yP9eBa4/6YfpEgHzh9cGIlk6A/OPzBtZb9
xvKfq3dffN2wh/mJJYsPvx9Kqu+V3Q9ca/iZfmM5/OEHLftZ8h/xWC37keVz
8z0f8y+tPzj8wbWW/W4v+W+Lk8Pa
     "]]& ],
  AspectRatio->NCache[3 58^Rational[-1, 2], 0.39391929857916763`],
  FrameTicks->Automatic,
  ImageSize->{279., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{283, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->307091717]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1933]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"None - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 25.9982920}", "context" -> "System`", 
    "keywords" -> {
     "no mesh regions", "no contour regions", "no axes", "no frames", 
      "no labels", "no vertex labels", "no axes labels", "no frame labels"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "None is a setting used for certain options. ", "synonyms" -> {}, "title" -> 
    "None", "type" -> "Symbol", "uri" -> "ref/None"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1841, 64, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48358, 1010}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 723, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1346, 43, 42, 1, 70, "ObjectName",
 CellID->17192],
Cell[1391, 46, 413, 13, 70, "Usage",
 CellID->7546]
}, Open  ]],
Cell[CellGroupData[{
Cell[1841, 64, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2218, 78, 146, 5, 70, "ExampleSection",
 CellID->1560011],
Cell[2367, 85, 346, 13, 70, "ExampleText",
 CellID->170919351],
Cell[CellGroupData[{
Cell[2738, 102, 412, 13, 28, "Input",
 CellID->522438672],
Cell[3153, 117, 18371, 344, 193, "Output",
 CellID->87829275]
}, Open  ]],
Cell[21539, 464, 124, 3, 70, "ExampleDelimiter",
 CellID->15058177],
Cell[21666, 469, 63, 1, 70, "ExampleText",
 CellID->28152926],
Cell[CellGroupData[{
Cell[21754, 474, 586, 18, 47, "Input",
 CellID->216606411],
Cell[22343, 494, 4783, 82, 169, "Output",
 Evaluatable->False,
 CellID->340934767]
}, Open  ]],
Cell[27141, 579, 124, 3, 70, "ExampleDelimiter",
 CellID->54585871],
Cell[27268, 584, 233, 8, 70, "ExampleText",
 CellID->623678210],
Cell[CellGroupData[{
Cell[27526, 596, 576, 18, 47, "Input",
 CellID->43800131],
Cell[28105, 616, 10400, 175, 165, "Output",
 Evaluatable->False,
 CellID->161213401]
}, Open  ]],
Cell[38520, 794, 125, 3, 70, "ExampleDelimiter",
 CellID->506485777],
Cell[38648, 799, 223, 8, 70, "ExampleText",
 CellID->49241855],
Cell[CellGroupData[{
Cell[38896, 811, 361, 12, 70, "Input",
 CellID->186312259],
Cell[39260, 825, 6900, 109, 146, "Output",
 CellID->307091717]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46221, 941, 311, 9, 70, "SeeAlsoSection",
 CellID->25809],
Cell[46535, 952, 679, 26, 70, "SeeAlso",
 CellID->1933]
}, Open  ]],
Cell[47229, 981, 27, 0, 70, "History"],
Cell[47259, 983, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

