(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40053,       1371]
NotebookOptionsPosition[     34206,       1174]
NotebookOutlinePosition[     35652,       1213]
CellTagsIndexPosition[     35566,       1208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BernoulliB" :> 
          Documentation`HelpLookup["paclet:ref/BernoulliB"], "StirlingS2" :> 
          Documentation`HelpLookup["paclet:ref/StirlingS2"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BernoulliB\"\>", 
       2->"\<\"StirlingS2\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Recurrence and Sum Functions" :> 
          Documentation`HelpLookup["paclet:guide/RecurrenceAndSumFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Recurrence and Sum Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>", 
       3->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NorlundB", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NorlundB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NorlundB"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives N\[ODoubleDot]rlund polynomials ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["B", "n", 
        RowBox[{"(", "a", ")"}]], TraditionalForm]], "InlineMath"],
     " of degree ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NorlundB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NorlundB"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives generalized Bernoulli polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["B", "n", 
         RowBox[{"(", "a", ")"}]], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The N\[ODoubleDot]rlund polynomials satisfy the generating function \
relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"t", "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["e", "t"], "-", "1"}], ")"}]}], ")"}], "a"], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SubsuperscriptBox["B", "n", 
       RowBox[{"(", "a", ")"}]], "(", 
      RowBox[{
       SuperscriptBox["t", "n"], "/", 
       RowBox[{"n", "!"}]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->106554572],

Cell[TextData[{
 "The generalized Bernoulli polynomials satisfy the generating function \
relation",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"t", "/", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["e", "t"], "-", "1"}], ")"}]}], ")"}], "a"], 
      SuperscriptBox["e", 
       RowBox[{"x", "t"}]]}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["B", "n", 
         RowBox[{"(", "a", ")"}]], "(", "x", ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["t", "n"], "/", 
         RowBox[{"n", "!"}]}], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->290938260],

Cell[TextData[{
 "The Bernoulli numbers are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "n"], "=", 
    SubsuperscriptBox["B", "n", 
     RowBox[{"(", "1", ")"}]]}], TraditionalForm]], "InlineMath"],
 ". Generalized Bernoulli numbers are given by higher integer values of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5351],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NorlundB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NorlundB"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NorlundB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NorlundB"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19298602],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->333839198],

Cell["\<\
First five N\[ODoubleDot]rlund polynomials:\
\>", "ExampleText",
 CellID->80606158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"NorlundB", "[", 
    RowBox[{"n", ",", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444770619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["a", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["a", "12"]}], "+", 
    FractionBox[
     SuperscriptBox["a", "2"], "4"]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["a", "2"], "8"], "-", 
    FractionBox[
     SuperscriptBox["a", "3"], "8"]}], ",", 
   RowBox[{
    FractionBox["a", "120"], "+", 
    FractionBox[
     SuperscriptBox["a", "2"], "48"], "-", 
    FractionBox[
     SuperscriptBox["a", "3"], "8"], "+", 
    FractionBox[
     SuperscriptBox["a", "4"], "16"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["a", "2"], "48"]}], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["a", "3"]}], "96"], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["a", "4"]}], "48"], "-", 
    FractionBox[
     SuperscriptBox["a", "5"], "32"]}]}], "}"}]], "Output",
 ImageSize->{434, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170044689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174885139],

Cell["Generalized Bernoulli polynomials:", "ExampleText",
 CellID->108012684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"NorlundB", "[", 
    RowBox[{"n", ",", "a", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429954315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["a", "2"]}], "+", "x"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["a", "12"]}], "+", 
    FractionBox[
     SuperscriptBox["a", "2"], "4"], "-", 
    RowBox[{"a", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["a", "2"], "8"], "-", 
    FractionBox[
     SuperscriptBox["a", "3"], "8"], "+", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["a", "12"]}], "+", 
       FractionBox[
        SuperscriptBox["a", "2"], "4"]}], ")"}], " ", "x"}], "-", 
    FractionBox[
     RowBox[{"3", " ", "a", " ", 
      SuperscriptBox["x", "2"]}], "2"], "+", 
    SuperscriptBox["x", "3"]}]}], "}"}]], "Output",
 ImageSize->{411, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72515642]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NorlundB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NorlundB"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->223107885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NorlundB", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "a", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184477360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["a", "2"]}], "+", "x"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["a", "12"]}], "+", 
    FractionBox[
     SuperscriptBox["a", "2"], "4"], "-", 
    RowBox[{"a", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["a", "2"], "8"], "-", 
    FractionBox[
     SuperscriptBox["a", "3"], "8"], "+", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["a", "12"]}], "+", 
       FractionBox[
        SuperscriptBox["a", "2"], "4"]}], ")"}], " ", "x"}], "-", 
    FractionBox[
     RowBox[{"3", " ", "a", " ", 
      SuperscriptBox["x", "2"]}], "2"], "+", 
    SuperscriptBox["x", "3"]}]}], "}"}]], "Output",
 ImageSize->{411, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498519468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93350133],

Cell["Plot N\[ODoubleDot]rlund polynomials:", "ExampleText",
 CellID->166401852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"NorlundB", "[", 
       RowBox[{"n", ",", "a"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154236037],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305492505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599375461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->224622332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NorlundB", "[", 
   RowBox[{"n", ",", "a"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393246305],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox[
   TagBox["B",
    NorlundB], "n", 
   RowBox[{"(", "a", ")"}]], TraditionalForm]], "Output",
 ImageSize->{24, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->430662031]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NorlundB", "[", 
   RowBox[{"n", ",", "a", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425263503],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    TagBox["B",
     NorlundB], "n", 
    RowBox[{"(", "a", ")"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{37, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->44794533]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Higher-order generalized Bernoulli numbers:", "ExampleText",
 CellID->538090093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NorlundB", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75773106],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"-", 
      FractionBox["1", "2"]}], 
     FractionBox["1", "6"], "0", 
     RowBox[{"-", 
      FractionBox["1", "30"]}], "0", 
     FractionBox["1", "42"], "0", 
     RowBox[{"-", 
      FractionBox["1", "30"]}], "0", 
     FractionBox["5", "66"]},
    {
     RowBox[{"-", "1"}], 
     FractionBox["5", "6"], 
     RowBox[{"-", 
      FractionBox["1", "2"]}], 
     FractionBox["1", "10"], 
     FractionBox["1", "6"], 
     RowBox[{"-", 
      FractionBox["5", "42"]}], 
     RowBox[{"-", 
      FractionBox["1", "6"]}], 
     FractionBox["7", "30"], 
     FractionBox["3", "10"], 
     RowBox[{"-", 
      FractionBox["15", "22"]}]},
    {
     RowBox[{"-", 
      FractionBox["3", "2"]}], "2", 
     RowBox[{"-", 
      FractionBox["9", "4"]}], 
     FractionBox["19", "10"], 
     RowBox[{"-", 
      FractionBox["3", "4"]}], 
     RowBox[{"-", 
      FractionBox["16", "21"]}], 
     FractionBox["5", "4"], 
     FractionBox["19", "30"], 
     RowBox[{"-", 
      FractionBox["63", "20"]}], 
     RowBox[{"-", 
      FractionBox["3", "11"]}]},
    {
     RowBox[{"-", "2"}], 
     FractionBox["11", "3"], 
     RowBox[{"-", "6"}], 
     FractionBox["251", "30"], 
     RowBox[{"-", "9"}], 
     FractionBox["221", "42"], 
     FractionBox["11", "3"], 
     RowBox[{"-", 
      FractionBox["199", "18"]}], 
     FractionBox["3", "5"], 
     FractionBox["707", "22"]},
    {
     RowBox[{"-", 
      FractionBox["5", "2"]}], 
     FractionBox["35", "6"], 
     RowBox[{"-", 
      FractionBox["25", "2"]}], "24", 
     RowBox[{"-", 
      FractionBox["475", "12"]}], 
     FractionBox["4315", "84"], 
     RowBox[{"-", 
      FractionBox["475", "12"]}], 
     RowBox[{"-", 
      FractionBox["329", "18"]}], 
     FractionBox["395", "4"], 
     RowBox[{"-", 
      FractionBox["2385", "44"]}]}
   }],
  "Grid"]], "Output",
 ImageSize->{313, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->891727]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137951870],

Cell["First ten N\[ODoubleDot]rlund numbers:", "ExampleText",
 CellID->163982229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"NorlundB", "[", 
    RowBox[{"n", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71351836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["5", "6"], ",", 
   RowBox[{"-", 
    FractionBox["9", "4"]}], ",", 
   FractionBox["251", "30"], ",", 
   RowBox[{"-", 
    FractionBox["475", "12"]}], ",", 
   FractionBox["19087", "84"], ",", 
   RowBox[{"-", 
    FractionBox["36799", "24"]}], ",", 
   FractionBox["1070017", "90"], ",", 
   RowBox[{"-", 
    FractionBox["2082753", "20"]}], ",", 
   FractionBox["134211265", "132"]}], "}"}]], "Output",
 ImageSize->{510, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148437090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->661731571],

Cell["Stirling numbers:", "ExampleText",
 CellID->25490290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"n", ",", "k"}], "]"}], 
       RowBox[{"NorlundB", "[", 
        RowBox[{"k", ",", 
         RowBox[{"n", "+", "1"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", "Grid"}], ",",
    
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"StirlingS1", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"n", "-", "k", "+", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", "Grid"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->654914939],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1", "", "", "", "", ""},
      {"1", 
       RowBox[{"-", "1"}], "", "", "", ""},
      {"1", 
       RowBox[{"-", "3"}], "2", "", "", ""},
      {"1", 
       RowBox[{"-", "6"}], "11", 
       RowBox[{"-", "6"}], "", ""},
      {"1", 
       RowBox[{"-", "10"}], "35", 
       RowBox[{"-", "50"}], "24", ""},
      {"1", 
       RowBox[{"-", "15"}], "85", 
       RowBox[{"-", "225"}], "274", 
       RowBox[{"-", "120"}]}
     }],
    "Grid"], ",", 
   TagBox[GridBox[{
      {"1", "", "", "", "", ""},
      {"1", 
       RowBox[{"-", "1"}], "", "", "", ""},
      {"1", 
       RowBox[{"-", "3"}], "2", "", "", ""},
      {"1", 
       RowBox[{"-", "6"}], "11", 
       RowBox[{"-", "6"}], "", ""},
      {"1", 
       RowBox[{"-", "10"}], "35", 
       RowBox[{"-", "50"}], "24", ""},
      {"1", 
       RowBox[{"-", "15"}], "85", 
       RowBox[{"-", "225"}], "274", 
       RowBox[{"-", "120"}]}
     }],
    "Grid"]}], "}"}]], "Output",
 ImageSize->{362, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304625980]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{
         RowBox[{"n", "+", "k"}], ",", "k"}], "]"}], 
       RowBox[{"NorlundB", "[", 
        RowBox[{"k", ",", 
         RowBox[{"-", "n"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", "Grid"}], ",",
    
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"StirlingS2", "[", 
       RowBox[{
        RowBox[{"n", "+", "k"}], ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", "Grid"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->256419761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1", "", "", "", "", ""},
      {"1", "1", "", "", "", ""},
      {"1", "3", "7", "", "", ""},
      {"1", "6", "25", "90", "", ""},
      {"1", "10", "65", "350", "1701", ""},
      {"1", "15", "140", "1050", "6951", "42525"}
     }],
    "Grid"], ",", 
   TagBox[GridBox[{
      {"1", "", "", "", "", ""},
      {"1", "1", "", "", "", ""},
      {"1", "3", "7", "", "", ""},
      {"1", "6", "25", "90", "", ""},
      {"1", "10", "65", "350", "1701", ""},
      {"1", "15", "140", "1050", "6951", "42525"}
     }],
    "Grid"]}], "}"}]], "Output",
 ImageSize->{390, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2278866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->460249490],

Cell[TextData[{
 "Expand ratio of ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " functions at infinity:"
}], "ExampleText",
 CellID->63025887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "=", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"s", "!"}], 
      SuperscriptBox["s", 
       RowBox[{"a", "-", "1"}]]}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"s", "+", "a"}], "]"}]], " ", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "k"], 
        RowBox[{
         SuperscriptBox["s", "k"], 
         RowBox[{"k", "!"}]}]], 
       RowBox[{"Pochhammer", "[", 
        RowBox[{
         RowBox[{"1", "-", "a"}], ",", "k"}], "]"}], 
       RowBox[{"NorlundB", "[", 
        RowBox[{"k", ",", "a", ",", "a"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->52385817],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["s"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "2"], "+", "s"}], "]"}]}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox["59697183", 
      RowBox[{"274877906944", " ", 
       SuperscriptBox["s", "10"]}]], "-", 
     FractionBox["28717403", 
      RowBox[{"17179869184", " ", 
       SuperscriptBox["s", "9"]}]], "-", 
     FractionBox["334477", 
      RowBox[{"2147483648", " ", 
       SuperscriptBox["s", "8"]}]], "+", 
     FractionBox["39325", 
      RowBox[{"33554432", " ", 
       SuperscriptBox["s", "7"]}]], "+", 
     FractionBox["869", 
      RowBox[{"4194304", " ", 
       SuperscriptBox["s", "6"]}]], "-", 
     FractionBox["399", 
      RowBox[{"262144", " ", 
       SuperscriptBox["s", "5"]}]], "-", 
     FractionBox["21", 
      RowBox[{"32768", " ", 
       SuperscriptBox["s", "4"]}]], "+", 
     FractionBox["5", 
      RowBox[{"1024", " ", 
       SuperscriptBox["s", "3"]}]], "+", 
     FractionBox["1", 
      RowBox[{"128", " ", 
       SuperscriptBox["s", "2"]}]], "-", 
     FractionBox["1", 
      RowBox[{"8", " ", "s"}]]}], ")"}], " ", 
   RowBox[{"s", "!"}]}]}]], "Output",
 ImageSize->{565, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81277162]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "Infinity", ",", "11"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480044409],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"8400372435", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "s"], ")"}], "11"]}], "2199023255552"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "s"], "]"}], "12"],
    SeriesData[$CellContext`s, 
     DirectedInfinity[1], {}, 0, 24, 2],
    Editable->False]}],
  SeriesData[$CellContext`s, 
   DirectedInfinity[1], {
   1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    Rational[-8400372435, 2199023255552]}, 0, 24, 2],
  Editable->False]], "Output",
 ImageSize->{197, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->591546821]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BernoulliB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BernoulliB"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StirlingS2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StirlingS2"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->478445707],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->69858139],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->641208226]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NorlundB - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 29.5608832}", "context" -> "System`", 
    "keywords" -> {
     "generalized Bernoulli numbers", "generalized Bernoulli polynomials", 
      "Norlund polynomials", "No\"rlund polynomials"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NorlundB[n, a] gives No\"rlund polynomials SubsuperscriptBox[B, n, (a)] \
of degree n in a. NorlundB[n, a, x] gives generalized Bernoulli polynomials \
SubsuperscriptBox[B, n, (a)](x).", "synonyms" -> {"Norlund B"}, "title" -> 
    "NorlundB", "type" -> "Symbol", "uri" -> "ref/NorlundB"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8410, 276, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19298602]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35424, 1201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1720, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2343, 67, 1573, 37, 70, "ObjectNameGrid"],
Cell[3919, 106, 1427, 47, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5383, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5861, 175, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5984, 181, 696, 24, 70, "Notes",
 CellID->106554572],
Cell[6683, 207, 869, 31, 70, "Notes",
 CellID->290938260],
Cell[7555, 240, 393, 13, 70, "Notes",
 CellID->5351],
Cell[7951, 255, 218, 7, 70, "Notes",
 CellID->31226],
Cell[8172, 264, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8410, 276, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19298602],
Cell[CellGroupData[{
Cell[8794, 290, 148, 5, 70, "ExampleSection",
 CellID->333839198],
Cell[8945, 297, 93, 3, 70, "ExampleText",
 CellID->80606158],
Cell[CellGroupData[{
Cell[9063, 304, 234, 8, 28, "Input",
 CellID->444770619],
Cell[9300, 314, 1064, 39, 54, "Output",
 CellID->170044689]
}, Open  ]],
Cell[10379, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->174885139],
Cell[10507, 361, 77, 1, 70, "ExampleText",
 CellID->108012684],
Cell[CellGroupData[{
Cell[10609, 366, 244, 8, 70, "Input",
 CellID->429954315],
Cell[10856, 376, 933, 33, 54, "Output",
 CellID->72515642]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11838, 415, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12062, 424, 210, 7, 70, "ExampleText",
 CellID->223107885],
Cell[CellGroupData[{
Cell[12297, 435, 199, 7, 70, "Input",
 CellID->184477360],
Cell[12499, 444, 934, 33, 54, "Output",
 CellID->498519468]
}, Open  ]],
Cell[13448, 480, 124, 3, 70, "ExampleDelimiter",
 CellID->93350133],
Cell[13575, 485, 80, 1, 70, "ExampleText",
 CellID->166401852],
Cell[CellGroupData[{
Cell[13680, 490, 421, 14, 70, "Input",
 CellID->154236037],
Cell[14104, 506, 5430, 93, 70, "Output",
 Evaluatable->False,
 CellID->305492505]
}, Open  ]],
Cell[19549, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->599375461],
Cell[19677, 607, 203, 7, 70, "ExampleText",
 CellID->224622332],
Cell[CellGroupData[{
Cell[19905, 618, 166, 5, 70, "Input",
 CellID->393246305],
Cell[20074, 625, 285, 10, 54, "Output",
 CellID->430662031]
}, Open  ]],
Cell[CellGroupData[{
Cell[20396, 640, 179, 6, 70, "Input",
 CellID->425263503],
Cell[20578, 648, 316, 11, 54, "Output",
 CellID->44794533]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20943, 665, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[21173, 674, 86, 1, 70, "ExampleText",
 CellID->538090093],
Cell[CellGroupData[{
Cell[21284, 679, 327, 11, 70, "Input",
 CellID->75773106],
Cell[21614, 692, 2007, 77, 138, "Output",
 CellID->891727]
}, Open  ]],
Cell[23636, 772, 125, 3, 70, "ExampleDelimiter",
 CellID->137951870],
Cell[23764, 777, 81, 1, 70, "ExampleText",
 CellID->163982229],
Cell[CellGroupData[{
Cell[23870, 782, 234, 8, 70, "Input",
 CellID->71351836],
Cell[24107, 792, 644, 22, 51, "Output",
 CellID->148437090]
}, Open  ]],
Cell[24766, 817, 125, 3, 70, "ExampleDelimiter",
 CellID->661731571],
Cell[24894, 822, 59, 1, 70, "ExampleText",
 CellID->25490290],
Cell[CellGroupData[{
Cell[24978, 827, 905, 30, 70, "Input",
 CellID->654914939],
Cell[25886, 859, 1144, 43, 108, "Output",
 CellID->304625980]
}, Open  ]],
Cell[CellGroupData[{
Cell[27067, 907, 891, 30, 70, "Input",
 CellID->256419761],
Cell[27961, 939, 746, 25, 108, "Output",
 CellID->2278866]
}, Open  ]],
Cell[28722, 967, 125, 3, 70, "ExampleDelimiter",
 CellID->460249490],
Cell[28850, 972, 214, 8, 70, "ExampleText",
 CellID->63025887],
Cell[CellGroupData[{
Cell[29089, 984, 930, 33, 70, "Input",
 CellID->52385817],
Cell[30022, 1019, 1358, 45, 126, "Output",
 CellID->81277162]
}, Open  ]],
Cell[CellGroupData[{
Cell[31417, 1069, 229, 8, 70, "Input",
 CellID->480044409],
Cell[31649, 1079, 761, 24, 60, "Output",
 CellID->591546821]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32471, 1110, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32790, 1121, 463, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[33290, 1143, 299, 8, 70, "MoreAboutSection"],
Cell[33592, 1153, 165, 3, 70, "MoreAbout",
 CellID->478445707],
Cell[33760, 1158, 173, 3, 70, "MoreAbout",
 CellID->69858139],
Cell[33936, 1163, 198, 4, 70, "MoreAbout",
 CellID->641208226]
}, Open  ]],
Cell[34149, 1170, 27, 0, 70, "History"],
Cell[34179, 1172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

