(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51499,       1270]
NotebookOptionsPosition[     47118,       1120]
NotebookOutlinePosition[     48446,       1157]
CellTagsIndexPosition[     48360,       1152]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"], 
         "NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"], 
         "DistanceFunction" :> 
         Documentation`HelpLookup["paclet:ref/DistanceFunction"], "Minimize" :> 
         Documentation`HelpLookup["paclet:ref/Minimize"], "NMinimize" :> 
         Documentation`HelpLookup["paclet:ref/NMinimize"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"FindFit\"\>", 2->"\<\"NDSolve\"\>", 
      3->"\<\"DistanceFunction\"\>", 4->"\<\"Minimize\"\>", 
      5->"\<\"NMinimize\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NormFunction", "ObjectName",
 CellID->29738],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NormFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NormFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for functions such as ",
     Cell[BoxData[
      ButtonBox["FindFit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     " which gives a function to be minimized in generating results."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NormFunction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " should be minimized in generating results."
}], "Notes",
 CellID->3686]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->630401073],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->228025385],

Cell["Find a \"best\" fit for data using different norms:", "ExampleText",
 CellID->78067760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "20"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24887865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "13", ",", "17", ",", 
   "19", ",", "23", ",", "29", ",", "31", ",", "37", ",", "41", ",", "43", 
   ",", "47", ",", "53", ",", "59", ",", "61", ",", "67", ",", "71"}], 
  "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93892349]
}, Open  ]],

Cell["The default is to find the best least-squares fit:", "ExampleText",
 CellID->117745648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"c", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3720920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1.4207557242233555`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.655581377626135`"}], ",", 
   RowBox[{"c", "\[Rule]", "0.5346453120672511`"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->345800890]
}, Open  ]],

Cell["Use the \[Infinity]-norm instead:", "ExampleText",
 CellID->487219474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"c", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x", ",", 
   RowBox[{"NormFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"#", ",", "Infinity"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->443269537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1.1507695890710887`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.0022987426644`"}], ",", 
   RowBox[{"c", "\[Rule]", "1.0468558066626197`"}]}], "}"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->875015640]
}, Open  ]],

Cell["Use the 1-norm:", "ExampleText",
 CellID->46023764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"c", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x", ",", 
   RowBox[{"NormFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"#", ",", "1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14151221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1.1477982444745727`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.0047401048565836`"}], ",", 
   RowBox[{"c", "\[Rule]", "1.0517840067414115`"}]}], "}"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->419376575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->747127080],

Cell["Use a 2-norm for estimating local error in solving an ODE:", \
"ExampleText",
 CellID->311791382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"First", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"100", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"NormFunction", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#", ",", "2"}], "]"}], "&"}], ")"}]}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396561696],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "314.1592653589793`"}], "}"}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386311301]
}, Open  ]],

Cell["Use an \[Infinity]-norm:", "ExampleText",
 CellID->516556533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soli", "=", 
  RowBox[{"First", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"100", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"NormFunction", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#", ",", "\[Infinity]"}], "]"}], "&"}], ")"}]}]}], "]"}]}],
    "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->597680583],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "314.1592653589793`"}], "}"}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102656634]
}, Open  ]],

Cell["\<\
The error measure makes a difference in the solution quality:\
\>", "ExampleText",
 CellID->282224828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"sol2", "[", 
     RowBox[{"100", "\[Pi]"}], "]"}], ",", 
    RowBox[{"soli", "[", 
     RowBox[{"100", "\[Pi]"}], "]"}]}], "}"}], "-", "1"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->771397426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.071298082886088`*^-6", ",", "4.85973637287529`*^-6"}], 
  "}"}]], "Output",
 ImageSize->{192, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43646290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->414076849],

Cell["The norm is used for space and time in PDE solutions:", "ExampleText",
 CellID->340610123],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "[", "p_", "]"}], ":=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t", ",", "t"}], "]"}], 
       "\[Equal]", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
      
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
        RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
       RowBox[{"-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"x", "^", "2"}]}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"t", ",", 
         RowBox[{"-", "L"}]}], "]"}], "\[Equal]", 
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "L"}], "]"}]}]}], "}"}], ",", "u", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"4", "L"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", 
    RowBox[{"NormFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"#", ",", "p"}], "]"}], "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9997003],

Cell["\<\
Plot the actual solution error, when using different error estimation norms:\
\>", "ExampleText",
 CellID->584581073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", "10"}], ";", 
  RowBox[{"Table", "[", "\n", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"40", ",", "x"}], "]"}], "/.", 
          RowBox[{"sol", "[", "p", "]"}]}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"-", 
            RowBox[{"x", "^", "2"}]}], "]"}], "-", 
          RowBox[{"2", 
           SqrtBox["\[Pi]"]}]}], ")"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "L"}], ",", "L"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "\[Infinity]"}], "}"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93900919],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->259897366]
}, Open  ]],

Cell["A plot of the best solution:", "ExampleText",
 CellID->63035132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], "/.", 
     RowBox[{"sol", "[", "1", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->452718695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->439628865]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19913],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DistanceFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DistanceFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMinimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMinimize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->154]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NormFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 35.5141606}", "context" -> "System`", 
    "keywords" -> {"error function", "error measure function"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NormFunction is an option for functions such as FindFit and NDSolve \
which gives a function to be minimized in generating results.", 
    "synonyms" -> {"norm function"}, "title" -> "NormFunction", "type" -> 
    "Symbol", "uri" -> "ref/NormFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3295, 111, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->630401073]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48217, 1145}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 977, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1600, 47, 50, 1, 70, "ObjectName",
 CellID->29738],
Cell[1653, 50, 777, 23, 70, "Usage",
 CellID->4409]
}, Open  ]],
Cell[CellGroupData[{
Cell[2467, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2945, 95, 313, 11, 70, "Notes",
 CellID->3686]
}, Closed]],
Cell[CellGroupData[{
Cell[3295, 111, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->630401073],
Cell[CellGroupData[{
Cell[3680, 125, 148, 5, 70, "ExampleSection",
 CellID->228025385],
Cell[3831, 132, 93, 1, 70, "ExampleText",
 CellID->78067760],
Cell[CellGroupData[{
Cell[3949, 137, 236, 8, 28, "Input",
 CellID->24887865],
Cell[4188, 147, 413, 11, 36, "Output",
 CellID->93892349]
}, Open  ]],
Cell[4616, 161, 93, 1, 70, "ExampleText",
 CellID->117745648],
Cell[CellGroupData[{
Cell[4734, 166, 320, 10, 28, "Input",
 CellID->3720920],
Cell[5057, 178, 357, 10, 36, "Output",
 CellID->345800890]
}, Open  ]],
Cell[5429, 191, 76, 1, 70, "ExampleText",
 CellID->487219474],
Cell[CellGroupData[{
Cell[5530, 196, 487, 16, 70, "Input",
 CellID->443269537],
Cell[6020, 214, 355, 10, 36, "Output",
 CellID->875015640]
}, Open  ]],
Cell[6390, 227, 57, 1, 70, "ExampleText",
 CellID->46023764],
Cell[CellGroupData[{
Cell[6472, 232, 476, 15, 70, "Input",
 CellID->14151221],
Cell[6951, 249, 358, 10, 36, "Output",
 CellID->419376575]
}, Open  ]],
Cell[7324, 262, 125, 3, 70, "ExampleDelimiter",
 CellID->747127080],
Cell[7452, 267, 103, 2, 70, "ExampleText",
 CellID->311791382],
Cell[CellGroupData[{
Cell[7580, 273, 904, 29, 70, "Input",
 CellID->396561696],
Cell[8487, 304, 380, 14, 36, "Output",
 CellID->386311301]
}, Open  ]],
Cell[8882, 321, 67, 1, 70, "ExampleText",
 CellID->516556533],
Cell[CellGroupData[{
Cell[8974, 326, 914, 29, 70, "Input",
 CellID->597680583],
Cell[9891, 357, 380, 14, 36, "Output",
 CellID->102656634]
}, Open  ]],
Cell[10286, 374, 112, 3, 70, "ExampleText",
 CellID->282224828],
Cell[CellGroupData[{
Cell[10423, 381, 259, 9, 70, "Input",
 CellID->771397426],
Cell[10685, 392, 247, 8, 39, "Output",
 CellID->43646290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10981, 406, 220, 7, 70, "ExampleSection",
 CellID->414076849],
Cell[11204, 415, 96, 1, 70, "ExampleText",
 CellID->340610123],
Cell[11303, 418, 1615, 52, 70, "Input",
 CellID->9997003],
Cell[12921, 472, 127, 3, 70, "ExampleText",
 CellID->584581073],
Cell[CellGroupData[{
Cell[13073, 479, 962, 31, 70, "Input",
 CellID->93900919],
Cell[14038, 512, 10408, 175, 70, "Output",
 Evaluatable->False,
 CellID->259897366]
}, Open  ]],
Cell[24461, 690, 70, 1, 70, "ExampleText",
 CellID->63035132],
Cell[CellGroupData[{
Cell[24556, 695, 527, 16, 70, "Input",
 CellID->452718695],
Cell[25086, 713, 20387, 338, 70, "Output",
 Evaluatable->False,
 CellID->439628865]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45534, 1058, 311, 9, 70, "SeeAlsoSection",
 CellID->19913],
Cell[45848, 1069, 1198, 44, 70, "SeeAlso",
 CellID->154]
}, Open  ]],
Cell[47061, 1116, 27, 0, 70, "History"],
Cell[47091, 1118, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

