(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54535,       1803]
NotebookOptionsPosition[     46555,       1518]
NotebookOutlinePosition[     47906,       1556]
CellTagsIndexPosition[     47820,       1551]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/PowerSeries"], 
          "Sparse Arrays: Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SparseArrays-ManipulatingLists"], 
          "Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/AlgebraicNumbers"], 
          "Converting Power Series to Normal Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Power Series\"\>", 
       2->"\<\"Sparse Arrays: Manipulating Lists\"\>", 
       3->"\<\"Algebraic Numbers\"\>", 
       4->"\<\"Converting Power Series to Normal Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SeriesCoefficient" :> 
          Documentation`HelpLookup["paclet:ref/SeriesCoefficient"], 
          "SparseArray" :> Documentation`HelpLookup["paclet:ref/SparseArray"],
           "Chop" :> Documentation`HelpLookup["paclet:ref/Chop"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SeriesCoefficient\"\>", 
       2->"\<\"SparseArray\"\>", 3->"\<\"Chop\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Constructing Matrices\"\>", 3->"\<\"Series Expansions\"\>", 
       4->"\<\"Sparse Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Normal", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Normal",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Normal"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a normal expression, from a variety of special forms. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects into ordinary arrays. "
}], "Notes",
 CellID->13460],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " converts a power series to a normal expression by truncating higher\
\[Hyphen]order terms. "
}], "Notes",
 CellID->1714],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " objects into ordinary lists of graphics primitives and directives. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12444],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " if possible converts ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Translate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Translate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AffineTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AffineTransform"]], "InlineFormula"],
 " constructs into explicit graphics primitives. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12415],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " objects into explicit sums involving ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->23714],

Cell[TextData[{
 "When additional \[OpenCurlyDoubleQuote]data types\[CloseCurlyDoubleQuote] \
are introduced, ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " should be defined to convert them, when possible, to normal expressions. "
}], "Notes",
 CellID->9924]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2750588],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->241283817],

Cell["Create a normal dense list from a sparse array:", "ExampleText",
 CellID->25086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "->", "a"}], ",", 
    RowBox[{"9", "->", "b"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5475],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "9", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32724]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "a", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "b"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13517],

Cell["Create a normal expression from a series expansion:", "ExampleText",
 CellID->10282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2071],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[Cell$$5350`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[Cell$$5350`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17501],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "24"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "120"]}]], "Output",
 ImageSize->{158, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17235]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23273],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " objects to ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->45052197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "5"}], "+", 
       RowBox[{"11", " ", "x"}], "+", "1"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7185514],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"11", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "#1"}], "]"}], 
       RowBox[{"11", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]}], "+", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"11", " ", "#1"}], "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"3", "-", "#1"}], "]"}], 
      RowBox[{"11", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]}]], "Output",
 ImageSize->{526, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99606370]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nint", "=", 
  RowBox[{"Normal", "[", "int", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45626687],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{455, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->210932107]
}, Open  ]],

Cell[TextData[{
 "Typically the ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " objects will give more accurate numerical values:"
}], "ExampleText",
 CellID->215665400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "int", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->116056396],

Cell[BoxData[
 RowBox[{"0.051278805184286944`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->261535321]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "nint", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->54558709],

Cell[BoxData[
 RowBox[{"0.05127880518428696`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.734723475976807`*^-18", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->10778015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223512364],

Cell[TextData[{
 "Convert from a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " object to graphics primitives:"
}], "ExampleText",
 CellID->860982825],

Cell[BoxData[
 RowBox[{
  RowBox[{"gc", "=", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.2", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6", ",", "7.2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Point", "[", "1", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359444423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Normal", "[", "gc", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302052398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"1.2`", ",", "3.5`"}], "}"}], "]"}], "}"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.2`", ",", "3.5`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5.6`", ",", "7.2`"}], "}"}]}], "}"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->885753629]
}, Open  ]],

Cell["Both forms produce the same image:", "ExampleText",
 CellID->178073185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", "gc", "]"}], ",", 
   RowBox[{"Graphics", "[", "gc", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93781147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1.2, 3.5}, {5.6, 
     7.2}}, {PointBox[1], LineBox[{1, 2}]}]], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1.2, 3.5}, {5.6, 
     7.2}}, {PointBox[1], LineBox[{1, 2}]}]]}], "}"}]], "Output",
 ImageSize->{230, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->144700205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465555013],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will affect expressions nested inside other expressions:"
}], "ExampleText",
 CellID->25149794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"j", "/", "i"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "j"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435977713],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOwzAMzXrdBrsBQuNtQkJ8BTzCEx9RTUjbAwKN/X9J2rhEp07SDqi2
sUltdpw4dk8S291esu3q9S3brpfZ4nmTfazWy8/F0/tGisKeEMG5EGIyF/J7
Lr8VF33G8hIiUvewkotU3hR8kG0k21i2gWxvYNwQ8ADwBHCk54lBPurY3rhj
e2HBcuiZ7ZGZzcRzPTt6NdTymUc/1OPQ667sTju2izhgV6GQRiUWxUeNUAKl
H5NA6D55BUa/asvlpg9Nz2nFWkyty9sEcKzncI3pM88Wi/r5TixyH05OXDXm
Kt1nrqIK52UkRC0fW6HWw0iXWuS7n82A1vLbZ/K3LonN56oorElxb0TsKB+T
vEVbDnDlBiVPdItZgWOu6ThOLz1CTnktH7OB01Zq7W3Ccv/E8h+zXI8eyI0Z
gdtxP6iNoyywG7OmVrW2TJxLQU516ZiRu+pQtv408OzgmMF8RLsNmUGryAzO
g15fHBwzeN7oPCIzuLeQGfQSMdrvFX6xdYOLv7ysbThOqA5BzppGhKhuzaLp
ysO+twrunc+FvWft3zHiPWN7wwhkEAsfGFOQDzZnt66FqeKmVfFWFnocXyHw
WZljlHZG27l872jICuLf3nX0m8+x8MdnjUsY5asUfLlpcmSsUdZkKyImAkxz
e0282/ssF2HNd3ozymEf/YJAscC0Kiw6gWWeUPeFFW3C6DW9PAN87Xn2tidz
dJCsoNdXgH+aFbB+O7HC4WbnTD3TPcgWgLve5U18Kmr7WoxDz/hIOGKlTbLk
/nvJ7wJOau5mdb/TslvdnuX8Pz+k64r/Zr/PhlKdMzYUpBxrq0JnHdjg/7Gi
NRm3RKL3BfsyVcM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320613826]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->338779221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["3", "2"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{392, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52946197]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17388],

Cell["\<\
Compare the actual error to the theoretical asymptotic error for a difference \
quotient:\
\>", "ExampleText",
 CellID->387718616],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dq", "[", "f_", "]"}], "[", "x_", "]"}], "[", "h_", "]"}], ":=", 
  
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "+", "h"}], "]"}], "-", 
     RowBox[{"2", 
      RowBox[{"f", "[", "x", "]"}]}], "+", 
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "h"}], "]"}]}], ")"}], "/", 
   RowBox[{"h", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114092087],

Cell[TextData[{
 "Power series about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "=", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->159221247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"dq", "[", "f", "]"}], "[", "x", "]"}], "[", "h", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647984001],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVstOwzAQTOOkBQKioiAhkFAPRTzUU3ldENzgxEdEFVJ7gJZS8Vn9hX6a
8SvBGW+dRFSCSokz9ni9O7u2+5LOR69v6Xw8TLvPs3Q6Gg8/u0+TmehijSAI
FuI5OQzENxdf6llwLlr9Hoh3LDpD005V77V8M8lVPzUaxDlWnFVcBviDZEWA
aVsx4AnJagJ+rx3DlXiHAsn15BTtc9v0JqZ9AHwBeCufZa+bAL4vGT8rGd/Q
njMTgPzM1o7s6EKTVdmi2i3AR1xnv1PLSmTU0gPZb5vIITPaFm27c7F2dKxh
iSJh0XK2lifeY8D7tS0q7FTTDqGQy0Id6cpEVjUtmMkV7gnpb5z3L5dLo3ii
ZBfY9tijjM++G0NiVv0/OtSthHrx/n3+f78XyEr3nNzV9kp2jvh8r64WZQ3x
Os7JHtf1i+cSashqWbVPQu3ZQeXIi/NQabpGwDvCMmbilLIAmBG6lGWYqiUJ
d6vH77n3M68Ur4ic6O17+9xmllU6UYmZnSanz4o2/7kB7bporeA3lJubjt+P
xPoRkYUu4EvD07rccF3Te57oKPUpqzZfb7Q7YHVWaObzWVrr2zzHavl93QNG
n9QY7c7X1HtrvP9SSP/TDhrfAiwDeQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{174, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302654960]
}, Open  ]],

Cell[TextData[{
 "Asymptotic truncation error for small ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->197635339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"err", "[", "f_", "]"}], "[", "x_", "]"}], "[", "h_", "]"}], "=", 
  
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "''"}], "[", "x", "]"}], "-", 
    RowBox[{"Normal", "[", "ps", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28048710],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"Abs", "[", 
   RowBox[{
    SuperscriptBox["h", "2"], " ", 
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", "4", ")"}],
       Derivative],
      MultilineFunction->None], "[", "x", "]"}]}], "]"}]}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->53739232]
}, Open  ]],

Cell[TextData[{
 "Compare actual and asymptotic errors as a function of ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"sin", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->145647145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "=", "Sin"}], ",", 
     RowBox[{"x", "=", "1."}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"LogLogPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"err", "[", "f", "]"}], "[", "x", "]"}], "[", "h", "]"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "8"}]}], ",", "1"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"h", ",", 
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"dq", "[", "f", "]"}], "[", "x", "]"}], "[", "h", "]"}],
             "-", 
            RowBox[{
             RowBox[{"f", "''"}], "[", "x", "]"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"h", ",", 
          RowBox[{"10.", "^", 
           RowBox[{"Range", "[", 
            RowBox[{
             RowBox[{"-", "8"}], ",", "0"}], "]"}]}]}], "}"}]}], "]"}], 
      "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->106627190],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5480959]
}, Open  ]],

Cell[TextData[{
 "With higher precision, the asymptotic error holds for smaller ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->12068559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "=", "Sin"}], ",", 
     RowBox[{"x", "=", 
      RowBox[{"N", "[", 
       RowBox[{"1", ",", "32"}], "]"}]}], ",", 
     RowBox[{"$MaxPrecision", "=", "32"}], ",", 
     RowBox[{"$MinPrecision", "=", "32"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"LogLogPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"err", "[", "f", "]"}], "[", "x", "]"}], "[", "h", "]"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "16"}]}], ",", "1"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"h", ",", 
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"dq", "[", "f", "]"}], "[", "x", "]"}], "[", "h", "]"}],
             "-", 
            RowBox[{
             RowBox[{"f", "''"}], "[", "x", "]"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"h", ",", 
          RowBox[{"10", "^", 
           RowBox[{"Range", "[", 
            RowBox[{
             RowBox[{"-", "16"}], ",", "0"}], "]"}]}]}], "}"}]}], "]"}], 
      "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->457661759],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1269337]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20917],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " that work with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", often ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Normal", "[", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["s", "TI"], "]"}], "]"}], "===", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{"Normal", "[", 
     StyleBox["s", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3875307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"1", "/", "i"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       RowBox[{"i", "/", "j"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35237013],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "7", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 7, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345191227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Normal", "[", "s", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105077832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "1", "]"}], ",", 
     RowBox[{"Sin", "[", 
      FractionBox["1", "2"], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "2", "]"}], ",", 
     RowBox[{"Sin", "[", 
      FractionBox["1", "2"], "]"}], ",", 
     RowBox[{"Sin", "[", 
      FractionBox["2", "3"], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Sin", "[", 
      FractionBox["3", "2"], "]"}], ",", 
     RowBox[{"Sin", "[", 
      FractionBox["1", "3"], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{479, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59775488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  RowBox[{"Normal", "[", 
   RowBox[{"Sin", "[", "s", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19458002],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->209252335]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"N", "[", "s", "]"}], "]"}], "===", 
  RowBox[{"N", "[", 
   RowBox[{"Normal", "[", "s", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16248140],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->71381971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#", ".", "#"}], " ", "+", " ", 
     RowBox[{"2", " ", "#"}]}], ")"}], "&"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->114164531],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"#1", ".", "#1"}], "+", 
   RowBox[{"2", " ", "#1"}]}], "&"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5172977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"f", "[", "s", "]"}], "]"}], "===", 
  RowBox[{"f", "[", 
   RowBox[{"Normal", "[", "s", "]"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->88626999],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->89178391]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12218],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9961],

Cell[TextData[ButtonBox["Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PowerSeries"]], "Tutorials",
 CellID->27725],

Cell[TextData[ButtonBox["Sparse Arrays: Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-ManipulatingLists"]], "Tutorials",
 CellID->26200],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "Tutorials",
 CellID->1667],

Cell[TextData[ButtonBox["Converting Power Series to Normal Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"]], "Tutorials",
 CellID->29772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->112437860],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->8780982],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->410150798],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->398538193],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout",
 CellID->128576324]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Normal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 33.4359824}", "context" -> "System`", 
    "keywords" -> {
     "power series", "truncation of power series", "convert sparse array", 
      "convert graphics primitives", "convert RootSum", "convert Series"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Normal[expr] converts expr to a normal expression, from a variety of \
special forms. ", "synonyms" -> {}, "title" -> "Normal", "type" -> "Symbol", 
    "uri" -> "ref/Normal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11923, 334, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2750588]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47678, 1544}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2924, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3547, 93, 4190, 83, 70, "ObjectNameGrid"],
Cell[7740, 178, 584, 18, 70, "Usage",
 CellID->4683]
}, Open  ]],
Cell[CellGroupData[{
Cell[8361, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8839, 218, 388, 14, 70, "Notes",
 CellID->13460],
Cell[9230, 234, 308, 10, 70, "Notes",
 CellID->1714],
Cell[9541, 246, 563, 17, 70, "Notes",
 CellID->12444],
Cell[10107, 265, 927, 32, 70, "Notes",
 CellID->12415],
Cell[11037, 299, 513, 19, 70, "Notes",
 CellID->23714],
Cell[11553, 320, 333, 9, 70, "Notes",
 CellID->9924]
}, Closed]],
Cell[CellGroupData[{
Cell[11923, 334, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2750588],
Cell[CellGroupData[{
Cell[12306, 348, 148, 5, 70, "ExampleSection",
 CellID->241283817],
Cell[12457, 355, 86, 1, 70, "ExampleText",
 CellID->25086],
Cell[CellGroupData[{
Cell[12568, 360, 201, 7, 28, "Input",
 CellID->5475],
Cell[12772, 369, 449, 16, 36, "Output",
 CellID->32724]
}, Open  ]],
Cell[CellGroupData[{
Cell[13258, 390, 97, 3, 28, "Input",
 CellID->4246],
Cell[13358, 395, 276, 9, 36, "Output",
 CellID->5187]
}, Open  ]],
Cell[13649, 407, 121, 3, 70, "ExampleDelimiter",
 CellID->13517],
Cell[13773, 412, 90, 1, 70, "ExampleText",
 CellID->10282],
Cell[CellGroupData[{
Cell[13888, 417, 210, 7, 70, "Input",
 CellID->2071],
Cell[14101, 426, 745, 26, 54, "Output",
 CellID->20340]
}, Open  ]],
Cell[CellGroupData[{
Cell[14883, 457, 98, 3, 70, "Input",
 CellID->17501],
Cell[14984, 462, 404, 14, 54, "Output",
 CellID->17235]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15437, 482, 216, 7, 70, "ExampleSection",
 CellID->23273],
Cell[15656, 491, 324, 13, 70, "ExampleText",
 CellID->45052197],
Cell[CellGroupData[{
Cell[16005, 508, 358, 12, 70, "Input",
 CellID->7185514],
Cell[16366, 522, 943, 33, 53, "Output",
 CellID->99606370]
}, Open  ]],
Cell[CellGroupData[{
Cell[17346, 560, 129, 4, 70, "Input",
 CellID->45626687],
Cell[17478, 566, 3547, 62, 70, "Output",
 Evaluatable->False,
 CellID->210932107]
}, Open  ]],
Cell[21040, 631, 244, 8, 70, "ExampleText",
 CellID->215665400],
Cell[CellGroupData[{
Cell[21309, 643, 99, 3, 70, "Input",
 CellID->116056396],
Cell[21411, 648, 259, 7, 36, "Output",
 CellID->261535321]
}, Open  ]],
Cell[CellGroupData[{
Cell[21707, 660, 99, 3, 70, "Input",
 CellID->54558709],
Cell[21809, 665, 277, 7, 36, "Output",
 CellID->10778015]
}, Open  ]],
Cell[22101, 675, 125, 3, 70, "ExampleDelimiter",
 CellID->223512364],
Cell[22229, 680, 242, 8, 70, "ExampleText",
 CellID->860982825],
Cell[22474, 690, 542, 19, 70, "Input",
 CellID->359444423],
Cell[CellGroupData[{
Cell[23041, 713, 126, 4, 70, "Input",
 CellID->302052398],
Cell[23170, 719, 529, 19, 36, "Output",
 CellID->885753629]
}, Open  ]],
Cell[23714, 741, 77, 1, 70, "ExampleText",
 CellID->178073185],
Cell[CellGroupData[{
Cell[23816, 746, 188, 6, 70, "Input",
 CellID->93781147],
Cell[24007, 754, 458, 14, 108, "Output",
 CellID->144700205]
}, Open  ]],
Cell[24480, 771, 125, 3, 70, "ExampleDelimiter",
 CellID->465555013],
Cell[24608, 776, 229, 7, 70, "ExampleText",
 CellID->25149794],
Cell[CellGroupData[{
Cell[24862, 787, 440, 15, 70, "Input",
 CellID->435977713],
Cell[25305, 804, 1082, 22, 70, "Output",
 Evaluatable->False,
 CellID->320613826]
}, Open  ]],
Cell[CellGroupData[{
Cell[26424, 831, 102, 3, 70, "Input",
 CellID->338779221],
Cell[26529, 836, 691, 24, 51, "Output",
 CellID->52946197]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27269, 866, 223, 7, 70, "ExampleSection",
 CellID->17388],
Cell[27495, 875, 140, 4, 70, "ExampleText",
 CellID->387718616],
Cell[27638, 881, 462, 17, 70, "Input",
 CellID->114092087],
Cell[28103, 900, 171, 7, 70, "ExampleText",
 CellID->159221247],
Cell[CellGroupData[{
Cell[28299, 911, 315, 10, 70, "Input",
 CellID->647984001],
Cell[28617, 923, 854, 18, 70, "Output",
 Evaluatable->False,
 CellID->302654960]
}, Open  ]],
Cell[29486, 944, 166, 6, 70, "ExampleText",
 CellID->197635339],
Cell[CellGroupData[{
Cell[29677, 954, 328, 12, 70, "Input",
 CellID->28048710],
Cell[30008, 968, 432, 16, 51, "Output",
 CellID->53739232]
}, Open  ]],
Cell[30455, 987, 439, 16, 70, "ExampleText",
 CellID->145647145],
Cell[CellGroupData[{
Cell[30919, 1007, 1322, 42, 70, "Input",
 CellID->106627190],
Cell[32244, 1051, 2260, 41, 70, "Output",
 Evaluatable->False,
 CellID->5480959]
}, Open  ]],
Cell[34519, 1095, 189, 6, 70, "ExampleText",
 CellID->12068559],
Cell[CellGroupData[{
Cell[34733, 1105, 1485, 47, 70, "Input",
 CellID->457661759],
Cell[36221, 1154, 2516, 45, 70, "Output",
 Evaluatable->False,
 CellID->1269337]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38786, 1205, 233, 7, 70, "ExampleSection",
 CellID->20917],
Cell[39022, 1214, 631, 25, 70, "ExampleText",
 CellID->3875307],
Cell[CellGroupData[{
Cell[39678, 1243, 635, 21, 70, "Input",
 CellID->35237013],
Cell[40316, 1266, 479, 17, 36, "Output",
 CellID->345191227]
}, Open  ]],
Cell[CellGroupData[{
Cell[40832, 1288, 132, 4, 70, "Input",
 CellID->105077832],
Cell[40967, 1294, 746, 25, 51, "Output",
 CellID->59775488]
}, Open  ]],
Cell[CellGroupData[{
Cell[41750, 1324, 157, 5, 70, "Input",
 CellID->19458002],
Cell[41910, 1331, 161, 5, 36, "Output",
 CellID->209252335]
}, Open  ]],
Cell[CellGroupData[{
Cell[42108, 1341, 217, 7, 70, "Input",
 CellID->16248140],
Cell[42328, 1350, 160, 5, 36, "Output",
 CellID->71381971]
}, Open  ]],
Cell[CellGroupData[{
Cell[42525, 1360, 221, 8, 70, "Input",
 CellID->114164531],
Cell[42749, 1370, 247, 9, 36, "Output",
 CellID->5172977]
}, Open  ]],
Cell[CellGroupData[{
Cell[43033, 1384, 217, 7, 70, "Input",
 CellID->88626999],
Cell[43253, 1393, 160, 5, 36, "Output",
 CellID->89178391]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43474, 1405, 311, 9, 70, "SeeAlsoSection",
 CellID->12218],
Cell[43788, 1416, 712, 26, 70, "SeeAlso",
 CellID->29813]
}, Open  ]],
Cell[CellGroupData[{
Cell[44537, 1447, 313, 9, 70, "TutorialsSection",
 CellID->9961],
Cell[44853, 1458, 134, 3, 70, "Tutorials",
 CellID->27725],
Cell[44990, 1463, 174, 3, 70, "Tutorials",
 CellID->26200],
Cell[45167, 1468, 143, 3, 70, "Tutorials",
 CellID->1667],
Cell[45313, 1473, 199, 4, 70, "Tutorials",
 CellID->29772]
}, Open  ]],
Cell[CellGroupData[{
Cell[45549, 1482, 319, 9, 70, "MoreAboutSection",
 CellID->112437860],
Cell[45871, 1493, 145, 3, 70, "MoreAbout",
 CellID->8780982],
Cell[46019, 1498, 153, 3, 70, "MoreAbout",
 CellID->410150798],
Cell[46175, 1503, 145, 3, 70, "MoreAbout",
 CellID->398538193],
Cell[46323, 1508, 137, 3, 70, "MoreAbout",
 CellID->128576324]
}, Open  ]],
Cell[46475, 1514, 50, 0, 70, "History"],
Cell[46528, 1516, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

