(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41291,       1500]
NotebookOptionsPosition[     33531,       1233]
NotebookOutlinePosition[     34878,       1270]
CellTagsIndexPosition[     34792,       1265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Vector Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Norm" :> Documentation`HelpLookup["paclet:ref/Norm"], "Abs" :> 
          Documentation`HelpLookup["paclet:ref/Abs"], "Dot" :> 
          Documentation`HelpLookup["paclet:ref/Dot"], "Sign" :> 
          Documentation`HelpLookup["paclet:ref/Sign"], "UnitVector" :> 
          Documentation`HelpLookup["paclet:ref/UnitVector"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Norm\"\>", 2->"\<\"Abs\"\>", 
       3->"\<\"Dot\"\>", 4->"\<\"Sign\"\>", 
       5->"\<\"UnitVector\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Data Transforms and Smoothing\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>", 
       4->"\<\"Matrices and Linear Algebra\"\>", 
       5->"\<\"Operations on Vectors\"\>", 
       6->"\<\"New in 6.0: Symbolic Computation\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       8->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Normalize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Normalize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Normalize"], "[", 
       StyleBox["v", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the normalized form of a vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Normalize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Normalize"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the normalized form a complex number ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Normalize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Normalize"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]normalizes with respect to the norm function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"], "[", 
   StyleBox["v", "TI"], "]"}]], "InlineFormula"],
 " is effectively ",
 Cell[BoxData[
  RowBox[{
   StyleBox["v", "TI"], "/", 
   RowBox[{
    ButtonBox["Norm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Norm"], "[", 
    StyleBox["v", "TI"], "]"}]}]], "InlineFormula"],
 ", except that zero vectors are returned unchanged."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Except in the case of zero vectors, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"], "[", 
   StyleBox["v", "TI"], "]"}]], "InlineFormula"],
 " returns the unit vector in the direction of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->130254878],

Cell[TextData[{
 "For a complex number ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], "/", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 ", except that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"], "[", "0", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "Notes",
 CellID->371256158],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["expr", "TI"], "]"}]}]], "InlineFormula"],
 ", except when there are zeros in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->709720930]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242712109],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->546208391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37993685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], ",", 
   FractionBox["5", 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], ",", 
   FractionBox["1", 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]]}], "}"}]], "Output",
 ImageSize->{155, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312397760]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Symbolic vectors:", "ExampleText",
 CellID->723583178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700406833],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["x", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "y", "]"}], "2"]}]]], ",", 
   FractionBox["y", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "y", "]"}], "2"]}]]]}], "}"}]], "Output",
 ImageSize->{291, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131709203]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193072010],

Cell["Use an arbitrary norm function:", "ExampleText",
 CellID->180186729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "f"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520973712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}]], ",", 
   FractionBox["y", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}]]}], "}"}]], "Output",
 ImageSize->{158, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17150791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524513362],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " is a complex\[Hyphen]valued vector:"
}], "ExampleText",
 CellID->146129686],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"2", " ", "I"}], ",", "3", ",", 
     RowBox[{"4", " ", "I"}], ",", "5", ",", 
     RowBox[{"6", "I"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41295926],

Cell["Normalize using exact arithmetic:", "ExampleText",
 CellID->207883595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", "v", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->722334410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["91"]], ",", 
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]"}], 
    SqrtBox["91"]], ",", 
   FractionBox["3", 
    SqrtBox["91"]], ",", 
   FractionBox[
    RowBox[{"4", " ", "\[ImaginaryI]"}], 
    SqrtBox["91"]], ",", 
   FractionBox["5", 
    SqrtBox["91"]], ",", 
   FractionBox[
    RowBox[{"6", " ", "\[ImaginaryI]"}], 
    SqrtBox["91"]]}], "}"}]], "Output",
 ImageSize->{284, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->611422127]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->303789343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{"N", "[", "v", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->196253223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.10482848367219183`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.20965696734438366`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.3144854510165755`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.4193139346887673`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5241424183609592`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.628970902033151`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{322, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9808414]
}, Open  ]],

Cell["\<\
Use 24\[Hyphen]digit precision arithmetic:\
\>", "ExampleText",
 CellID->42141360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{"N", "[", 
   RowBox[{"v", ",", " ", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->898593403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.10482848367219182957721116329925566377`23.69897000433602", ",", 
   RowBox[{
   "0.20965696734438365915442232659851132753`23.69897000433602", " ", 
    "\[ImaginaryI]"}], ",", 
   "0.31448545101657548873163348989776699129`23.69897000433602", ",", 
   RowBox[{
   "0.41931393468876731830884465319702265506`23.69897000433602", " ", 
    "\[ImaginaryI]"}], ",", 
   "0.52414241836095914788605581649627831882`23.69897000433602", ",", 
   RowBox[{
   "0.62897090203315097746326697979553398259`23.69897000433602", " ", 
    "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{405, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->252536382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123364488],

Cell["Normalize a sparse vector:", "ExampleText",
 CellID->94514500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"N", "[", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "^", "i"}], "}"}], "\[Rule]", "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", " ", "20"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->164296792],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "20", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 20, ">"],
     Editable->False], ",", 
    RowBox[{"{", "1048576", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447015047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->169579282],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "20", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 20, ">"],
     Editable->False], ",", 
    RowBox[{"{", "1048576", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146303955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->118528435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", "2", "}"}], "\[Rule]", "0.018666334823663935`"}], ",", 
   RowBox[{
    RowBox[{"{", "4", "}"}], "\[Rule]", "0.03733266964732787`"}], ",", 
   RowBox[{
    RowBox[{"{", "8", "}"}], "\[Rule]", "0.055999004470991806`"}], ",", 
   RowBox[{
    RowBox[{"{", "16", "}"}], "\[Rule]", "0.07466533929465574`"}], ",", 
   RowBox[{
    RowBox[{"{", "32", "}"}], "\[Rule]", "0.09333167411831968`"}], ",", 
   RowBox[{
    RowBox[{"{", "64", "}"}], "\[Rule]", "0.11199800894198361`"}], ",", 
   RowBox[{
    RowBox[{"{", "128", "}"}], "\[Rule]", "0.13066434376564756`"}], ",", 
   RowBox[{
    RowBox[{"{", "256", "}"}], "\[Rule]", "0.14933067858931148`"}], ",", 
   RowBox[{
    RowBox[{"{", "512", "}"}], "\[Rule]", "0.1679970134129754`"}], ",", 
   RowBox[{
    RowBox[{"{", "1024", "}"}], "\[Rule]", "0.18666334823663935`"}], ",", 
   RowBox[{
    RowBox[{"{", "2048", "}"}], "\[Rule]", "0.2053296830603033`"}], ",", 
   RowBox[{
    RowBox[{"{", "4096", "}"}], "\[Rule]", "0.22399601788396722`"}], ",", 
   RowBox[{
    RowBox[{"{", "8192", "}"}], "\[Rule]", "0.24266235270763115`"}], ",", 
   RowBox[{
    RowBox[{"{", "16384", "}"}], "\[Rule]", "0.2613286875312951`"}], ",", 
   RowBox[{
    RowBox[{"{", "32768", "}"}], "\[Rule]", "0.27999502235495904`"}], ",", 
   RowBox[{
    RowBox[{"{", "65536", "}"}], "\[Rule]", "0.29866135717862297`"}], ",", 
   RowBox[{
    RowBox[{"{", "131072", "}"}], "\[Rule]", "0.3173276920022869`"}], ",", 
   RowBox[{
    RowBox[{"{", "262144", "}"}], "\[Rule]", "0.3359940268259508`"}], ",", 
   RowBox[{
    RowBox[{"{", "524288", "}"}], "\[Rule]", "0.3546603616496148`"}], ",", 
   RowBox[{
    RowBox[{"{", "1048576", "}"}], "\[Rule]", "0.3733266964732787`"}], ",", 
   RowBox[{
    RowBox[{"{", "_", "}"}], "\[Rule]", "0.`"}]}], "}"}]], "Output",
 ImageSize->{570, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->39946889]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["Normalize a matrix by explicitly specifying a norm function:", \
"ExampleText",
 CellID->287656641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}], ",", "Norm"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->135197545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"23", "+", 
        RowBox[{"2", " ", 
         SqrtBox["130"]}]}]]], ",", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{"23", "+", 
        RowBox[{"2", " ", 
         SqrtBox["130"]}]}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", 
      SqrtBox[
       RowBox[{"23", "+", 
        RowBox[{"2", " ", 
         SqrtBox["130"]}]}]]], ",", 
     FractionBox["5", 
      SqrtBox[
       RowBox[{"23", "+", 
        RowBox[{"2", " ", 
         SqrtBox["130"]}]}]]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{470, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298127042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34115773],

Cell["\<\
Normalize a polynomial with respect to integration over the interval -1 to 1:\
\
\>", "ExampleText",
 CellID->387418005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{
   RowBox[{"1", "+", "x", "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"#", "^", "2"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110850738],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "22"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{91, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254468039]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a symmetric matrix with distinct eigenvalues:"
}], "ExampleText",
 CellID->379499485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38782954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17124048]
}, Open  ]],

Cell["\<\
Power method to find the eigenvector associated with the largest eigenvalue:\
\>", "ExampleText",
 CellID->199233785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", " ", "=", " ", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Normalize", "[", 
      RowBox[{"m", ".", "#"}], "]"}], "&"}], ",", " ", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45434595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.40010905939260016`", ",", "0.7382392526879304`", ",", 
   "0.543061273138432`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211804113]
}, Open  ]],

Cell[TextData[{
 "This is consistent (up to sign) with what ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " gives:"
}], "ExampleText",
 CellID->351497133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->474095914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "0.4001090593926`"}], ",", 
    RowBox[{"-", "0.7382392526879307`"}], ",", 
    RowBox[{"-", "0.5430612731384319`"}]}], "}"}], "}"}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->411263723]
}, Open  ]],

Cell[TextData[{
 "The eigenvalue can be found with ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->398509151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"m", ".", "v"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->451119158],

Cell[BoxData["8.762039503693863`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9156993]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " is a random vector:"
}], "ExampleText",
 CellID->48183351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", " ", "=", " ", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", "2"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2122457],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3508426526632782`", ",", "0.4853377813590014`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->554967475]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is the normalization of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32870494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", " ", "=", " ", 
  RowBox[{"Normalize", "[", "v", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15451679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5858426794735137`", ",", "0.810424799045102`"}], "}"}]], "Output",\

 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356906970]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is a unit vector in the direction of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->265403078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.025", "]"}], ",", " ", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", " ", "u"}], "}"}], "]"}]}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"Green", ",", " ", 
       RowBox[{"Thickness", "[", "0.0125", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", " ", "v"}], "}"}], "]"}]}], 
      "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->39953093],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], 
   {Thickness[0.025], 
    ArrowBox[{{0, 0}, {0.5858426794735137, 0.810424799045102}}]}, 
   {RGBColor[0, 1, 0], Thickness[0.0125], 
    ArrowBox[{{0, 0}, {0.3508426526632782, 0.4853377813590014}}]}}]], "Output",\

 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->407249556]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitVector"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Vector Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorOperations"]], "Tutorials",
 CellID->513408734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Normalize",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Normalize"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->46950888],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->678603760],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->68063395],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->259009927],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->688387397],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->139572531],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->289403438],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->193690502],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->34907916]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Normalize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 32.7172140}", "context" -> "System`", 
    "keywords" -> {"length of vector", "normalize vector"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Normalize[v] gives the normalized form of a vector v. Normalize[z] gives \
the normalized form a complex number z. Normalize[expr, f] normalizes with \
respect to the norm function f.", "synonyms" -> {}, "title" -> "Normalize", 
    "type" -> "Symbol", "uri" -> "ref/Normalize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9734, 300, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->242712109]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34649, 1258}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3358, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3981, 100, 1574, 37, 70, "ObjectNameGrid"],
Cell[5558, 139, 1378, 44, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6973, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7451, 205, 506, 18, 70, "Notes",
 CellID->1067943069],
Cell[7960, 225, 373, 13, 70, "Notes",
 CellID->130254878],
Cell[8336, 240, 758, 30, 70, "Notes",
 CellID->371256158],
Cell[9097, 272, 600, 23, 70, "Notes",
 CellID->709720930]
}, Closed]],
Cell[CellGroupData[{
Cell[9734, 300, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242712109],
Cell[CellGroupData[{
Cell[10119, 314, 148, 5, 70, "ExampleSection",
 CellID->546208391],
Cell[CellGroupData[{
Cell[10292, 323, 161, 5, 28, "Input",
 CellID->37993685],
Cell[10456, 330, 400, 16, 55, "Output",
 CellID->312397760]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10905, 352, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11129, 361, 60, 1, 70, "ExampleText",
 CellID->723583178],
Cell[CellGroupData[{
Cell[11214, 366, 152, 5, 70, "Input",
 CellID->700406833],
Cell[11369, 373, 580, 21, 60, "Output",
 CellID->131709203]
}, Open  ]],
Cell[11964, 397, 125, 3, 70, "ExampleDelimiter",
 CellID->193072010],
Cell[12092, 402, 74, 1, 70, "ExampleText",
 CellID->180186729],
Cell[CellGroupData[{
Cell[12191, 407, 177, 6, 70, "Input",
 CellID->520973712],
Cell[12371, 415, 413, 15, 51, "Output",
 CellID->17150791]
}, Open  ]],
Cell[12799, 433, 125, 3, 70, "ExampleDelimiter",
 CellID->524513362],
Cell[12927, 438, 151, 5, 70, "ExampleText",
 CellID->146129686],
Cell[13081, 445, 281, 9, 70, "Input",
 CellID->41295926],
Cell[13365, 456, 76, 1, 70, "ExampleText",
 CellID->207883595],
Cell[CellGroupData[{
Cell[13466, 461, 105, 3, 70, "Input",
 CellID->722334410],
Cell[13574, 466, 577, 22, 55, "Output",
 CellID->611422127]
}, Open  ]],
Cell[14166, 491, 66, 1, 70, "ExampleText",
 CellID->303789343],
Cell[CellGroupData[{
Cell[14257, 496, 133, 4, 70, "Input",
 CellID->196253223],
Cell[14393, 502, 857, 20, 54, "Output",
 CellID->9808414]
}, Open  ]],
Cell[15265, 525, 92, 3, 70, "ExampleText",
 CellID->42141360],
Cell[CellGroupData[{
Cell[15382, 532, 163, 5, 70, "Input",
 CellID->898593403],
Cell[15548, 539, 729, 18, 71, "Output",
 CellID->252536382]
}, Open  ]],
Cell[16292, 560, 125, 3, 70, "ExampleDelimiter",
 CellID->123364488],
Cell[16420, 565, 68, 1, 70, "ExampleText",
 CellID->94514500],
Cell[CellGroupData[{
Cell[16513, 570, 382, 13, 70, "Input",
 CellID->164296792],
Cell[16898, 585, 461, 16, 36, "Output",
 CellID->447015047]
}, Open  ]],
Cell[CellGroupData[{
Cell[17396, 606, 105, 3, 70, "Input",
 CellID->169579282],
Cell[17504, 611, 461, 16, 36, "Output",
 CellID->146303955]
}, Open  ]],
Cell[CellGroupData[{
Cell[18002, 632, 106, 3, 70, "Input",
 CellID->118528435],
Cell[18111, 637, 1979, 49, 105, "Output",
 CellID->39946889]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20139, 692, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[20386, 701, 105, 2, 70, "ExampleText",
 CellID->287656641],
Cell[CellGroupData[{
Cell[20516, 707, 288, 11, 70, "Input",
 CellID->135197545],
Cell[20807, 720, 778, 31, 62, "Output",
 CellID->298127042]
}, Open  ]],
Cell[21600, 754, 124, 3, 70, "ExampleDelimiter",
 CellID->34115773],
Cell[21727, 759, 130, 4, 70, "ExampleText",
 CellID->387418005],
Cell[CellGroupData[{
Cell[21882, 767, 389, 14, 70, "Input",
 CellID->110850738],
Cell[22274, 783, 285, 10, 51, "Output",
 CellID->254468039]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22608, 799, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[22838, 808, 164, 5, 70, "ExampleText",
 CellID->379499485],
Cell[CellGroupData[{
Cell[23027, 817, 341, 11, 70, "Input",
 CellID->38782954],
Cell[23371, 830, 390, 13, 36, "Output",
 CellID->17124048]
}, Open  ]],
Cell[23776, 846, 127, 3, 70, "ExampleText",
 CellID->199233785],
Cell[CellGroupData[{
Cell[23928, 853, 345, 11, 70, "Input",
 CellID->45434595],
Cell[24276, 866, 275, 9, 36, "Output",
 CellID->211804113]
}, Open  ]],
Cell[24566, 878, 239, 8, 70, "ExampleText",
 CellID->351497133],
Cell[CellGroupData[{
Cell[24830, 890, 160, 5, 70, "Input",
 CellID->474095914],
Cell[24993, 897, 349, 11, 36, "Output",
 CellID->411263723]
}, Open  ]],
Cell[25357, 911, 208, 8, 70, "ExampleText",
 CellID->398509151],
Cell[CellGroupData[{
Cell[25590, 923, 123, 4, 70, "Input",
 CellID->451119158],
Cell[25716, 929, 173, 5, 36, "Output",
 CellID->9156993]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25938, 940, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[26179, 949, 134, 5, 70, "ExampleText",
 CellID->48183351],
Cell[CellGroupData[{
Cell[26338, 958, 243, 9, 70, "Input",
 CellID->2122457],
Cell[26584, 969, 243, 8, 36, "Output",
 CellID->554967475]
}, Open  ]],
Cell[26842, 980, 202, 8, 70, "ExampleText",
 CellID->32870494],
Cell[CellGroupData[{
Cell[27069, 992, 137, 4, 70, "Input",
 CellID->15451679],
Cell[27209, 998, 241, 8, 36, "Output",
 CellID->356906970]
}, Open  ]],
Cell[27465, 1009, 216, 8, 70, "ExampleText",
 CellID->265403078],
Cell[CellGroupData[{
Cell[27706, 1021, 881, 28, 70, "Input",
 CellID->39953093],
Cell[28590, 1051, 394, 11, 201, "Output",
 CellID->407249556]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29045, 1069, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[29364, 1080, 1158, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[30559, 1129, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[30880, 1140, 148, 3, 70, "Tutorials",
 CellID->513408734]
}, Open  ]],
Cell[CellGroupData[{
Cell[31065, 1148, 305, 8, 70, "RelatedLinksSection"],
Cell[31373, 1158, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31773, 1175, 318, 9, 70, "MoreAboutSection",
 CellID->46950888],
Cell[32094, 1186, 128, 3, 70, "MoreAbout",
 CellID->678603760],
Cell[32225, 1191, 166, 3, 70, "MoreAbout",
 CellID->68063395],
Cell[32394, 1196, 190, 4, 70, "MoreAbout",
 CellID->259009927],
Cell[32587, 1202, 163, 3, 70, "MoreAbout",
 CellID->688387397],
Cell[32753, 1207, 152, 3, 70, "MoreAbout",
 CellID->139572531],
Cell[32908, 1212, 169, 3, 70, "MoreAbout",
 CellID->289403438],
Cell[33080, 1217, 179, 3, 70, "MoreAbout",
 CellID->193690502],
Cell[33262, 1222, 197, 4, 70, "MoreAbout",
 CellID->34907916]
}, Open  ]],
Cell[33474, 1229, 27, 0, 70, "History"],
Cell[33504, 1231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

