(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22978,        830]
NotebookOptionsPosition[     18749,        691]
NotebookOutlinePosition[     20236,        730]
CellTagsIndexPosition[     20151,        725]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
         "MemberQ" :> Documentation`HelpLookup["paclet:ref/MemberQ"], 
         "IntegerQ" :> Documentation`HelpLookup["paclet:ref/IntegerQ"], 
         "Condition" :> Documentation`HelpLookup["paclet:ref/Condition"], 
         "PatternTest" :> Documentation`HelpLookup["paclet:ref/PatternTest"], 
         "Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], "Less" :> 
         Documentation`HelpLookup["paclet:ref/Less"], "Divisible" :> 
         Documentation`HelpLookup["paclet:ref/Divisible"], "CoprimeQ" :> 
         Documentation`HelpLookup["paclet:ref/CoprimeQ"], "Booleans" :> 
         Documentation`HelpLookup["paclet:ref/Booleans"], "Primes" :> 
         Documentation`HelpLookup["paclet:ref/Primes"], "Exists" :> 
         Documentation`HelpLookup["paclet:ref/Exists"], "ForAll" :> 
         Documentation`HelpLookup["paclet:ref/ForAll"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Element\"\>", 2->"\<\"MemberQ\"\>", 
      3->"\<\"IntegerQ\"\>", 4->"\<\"Condition\"\>", 5->"\<\"PatternTest\"\>",
       6->"\<\"Equal\"\>", 7->"\<\"Less\"\>", 8->"\<\"Divisible\"\>", 
      9->"\<\"CoprimeQ\"\>", 10->"\<\"Booleans\"\>", 11->"\<\"Primes\"\>", 
      12->"\<\"Exists\"\>", 13->"\<\"ForAll\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "NotElement ",
     StyleBox["(\[NotElement])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotElement",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotElement"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[NotElement]", 
       StyleBox["dom", "TI"]}]], "InlineFormula"],
     " asserts that ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is not an element of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotElement",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotElement"], "[", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], "|", 
         StyleBox["\[Ellipsis]", "TR"], "|", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["n", "TI"]]}], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]asserts that none of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " are elements of ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotElement",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotElement"], "[", 
       RowBox[{
        StyleBox["patt", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]asserts that any expression matching the pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " is not an element of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->741124854]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[NotElement]", 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]!el\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "NotElement", "]"}]}], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11686],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotElement"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], "[", 
   RowBox[{
    ButtonBox["Element",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Element"], "[", 
    RowBox[{
     StyleBox["x", "TI"], ",", " ", 
     StyleBox["dom", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->200611394],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotElement"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], "|", 
     StyleBox["\[Ellipsis]", "TR"], "|", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Not",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Not"], "[", 
    RowBox[{
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["dom", "TI"]}], "]"}], "]"}], "&&", 
   StyleBox["\[Ellipsis]", "TR"], "&&", 
   RowBox[{
    ButtonBox["Not",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Not"], "[", 
    RowBox[{
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["n", "TI"]], ",", 
      StyleBox["dom", "TI"]}], "]"}], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->92507693]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->665875026],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->107073946],

Cell[TextData[{
 "Test whether ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " is not an element of the integers:"
}], "ExampleText",
 CellID->6334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", " ", "\[NotElement]", " ", "Integers"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83094188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205387439],

Cell[TextData[{
 "Express that ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is not real:"
}], "ExampleText",
 CellID->318579202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotElement", "[", 
  RowBox[{"x", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220101818],

Cell[BoxData[
 RowBox[{"x", "\[NotElement]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60284899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37477389],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]!elem\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[NotElement]", "Reals"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"x", "\[NotElement]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148430486]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->262278864],

Cell["Test domain membership:", "ExampleText",
 CellID->760646380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NotElement", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "Complexes", ",", "Algebraics", ",", "Reals", ",", "Rationals", ",", 
    "Integers", ",", "Primes"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587943959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "True", ",", "True", ",", 
   "True"}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411743317]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22818],

Cell[TextData[{
 "For a single variable, the negation of ",
 Cell[BoxData[
  ButtonBox["NotElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotElement"]], "InlineFormula"],
 " is automatically converted ",
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->817758621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"NotElement", "[", 
   RowBox[{"a", ",", "Reals"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286126246],

Cell[BoxData[
 RowBox[{"a", "\[Element]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758230491]
}, Open  ]],

Cell[TextData[{
 "For multiple variables the negation of ",
 Cell[BoxData[
  ButtonBox["NotElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotElement"]], "InlineFormula"],
 " is not automatically simplified:"
}], "ExampleText",
 CellID->74140771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"NotElement", "[", 
   RowBox[{
    RowBox[{"a", "|", "b", "|", "c"}], ",", "Reals"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246688360],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "|", "b", "|", "c"}], ")"}], "\[NotElement]", 
   "Reals"}]}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173515263]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to find the representation in terms of  ",
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->615168356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71806121],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Element]", "Reals"}], "||", 
  RowBox[{"b", "\[Element]", "Reals"}], "||", 
  RowBox[{"c", "\[Element]", "Reals"}]}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->299220]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Less",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Less"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Booleans",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Booleans"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Primes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Primes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1285019739]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotElement (\[NotElement]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 10.1556724}", "context" -> "System`", 
    "keywords" -> {"domain exclusion", "element"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotElement[x, dom] or x \\[NotElement] dom asserts that x is not an \
element of the domain dom. NotElement[x_1 | ... | x_n, dom] asserts that none \
of the x_i are elements of dom. NotElement[patt, dom] asserts that any \
expression matching the pattern patt is not an element of the domain dom.", 
    "synonyms" -> {"not element"}, "title" -> "NotElement", "type" -> 
    "Symbol", "uri" -> "ref/NotElement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9244, 295, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->665875026]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20008, 718}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1702, 29, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2325, 56, 1654, 40, 70, "ObjectNameGrid"],
Cell[3982, 98, 2173, 70, 70, "Usage",
 CellID->741124854]
}, Open  ]],
Cell[CellGroupData[{
Cell[6192, 173, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6670, 190, 617, 24, 70, "Notes",
 CellID->11686],
Cell[7290, 216, 628, 24, 70, "Notes",
 CellID->200611394],
Cell[7921, 242, 1286, 48, 70, "Notes",
 CellID->92507693]
}, Closed]],
Cell[CellGroupData[{
Cell[9244, 295, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->665875026],
Cell[CellGroupData[{
Cell[9629, 309, 148, 5, 70, "ExampleSection",
 CellID->107073946],
Cell[9780, 316, 174, 6, 70, "ExampleText",
 CellID->6334],
Cell[CellGroupData[{
Cell[9979, 326, 115, 3, 28, "Input",
 CellID->41],
Cell[10097, 331, 160, 5, 36, "Output",
 CellID->83094188]
}, Open  ]],
Cell[10272, 339, 125, 3, 70, "ExampleDelimiter",
 CellID->205387439],
Cell[10400, 344, 153, 6, 70, "ExampleText",
 CellID->318579202],
Cell[CellGroupData[{
Cell[10578, 354, 133, 4, 70, "Input",
 CellID->220101818],
Cell[10714, 360, 195, 6, 36, "Output",
 CellID->60284899]
}, Open  ]],
Cell[10924, 369, 124, 3, 70, "ExampleDelimiter",
 CellID->37477389],
Cell[11051, 374, 192, 7, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[11268, 385, 108, 3, 70, "Input",
 CellID->162312622],
Cell[11379, 390, 196, 6, 36, "Output",
 CellID->148430486]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11624, 402, 220, 7, 70, "ExampleSection",
 CellID->262278864],
Cell[11847, 411, 66, 1, 70, "ExampleText",
 CellID->760646380],
Cell[CellGroupData[{
Cell[11938, 416, 345, 11, 70, "Input",
 CellID->587943959],
Cell[12286, 429, 272, 9, 36, "Output",
 CellID->411743317]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12607, 444, 233, 7, 70, "ExampleSection",
 CellID->22818],
Cell[12843, 453, 376, 13, 70, "ExampleText",
 CellID->817758621],
Cell[CellGroupData[{
Cell[13244, 470, 152, 5, 70, "Input",
 CellID->286126246],
Cell[13399, 477, 193, 6, 36, "Output",
 CellID->758230491]
}, Open  ]],
Cell[13607, 486, 257, 8, 70, "ExampleText",
 CellID->74140771],
Cell[CellGroupData[{
Cell[13889, 498, 187, 6, 70, "Input",
 CellID->246688360],
Cell[14079, 506, 278, 10, 36, "Output",
 CellID->173515263]
}, Open  ]],
Cell[14372, 519, 360, 13, 70, "ExampleText",
 CellID->615168356],
Cell[CellGroupData[{
Cell[14757, 536, 108, 3, 70, "Input",
 CellID->71806121],
Cell[14868, 541, 298, 9, 36, "Output",
 CellID->299220]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15227, 557, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15546, 568, 3131, 116, 70, "SeeAlso",
 CellID->1285019739]
}, Open  ]],
Cell[18692, 687, 27, 0, 70, "History"],
Cell[18722, 689, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

