(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44231,       1165]
NotebookOptionsPosition[     39147,        995]
NotebookOutlinePosition[     40791,       1042]
CellTagsIndexPosition[     40671,       1036]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DocumentNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DocumentNotebook"], 
          "PaletteNotebook" :> 
          Documentation`HelpLookup["paclet:ref/PaletteNotebook"], "Cell" :> 
          Documentation`HelpLookup["paclet:ref/Cell"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DocumentNotebook\"\>", 
       2->"\<\"PaletteNotebook\"\>", 3->"\<\"Cell\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Notebook", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Notebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Notebook"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the low\[Hyphen]level construct that represents a \
notebook manipulated by the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6744]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Notebook files contain explicit ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expressions written out in textual form. "
}], "Notes",
 CellID->23658],

Cell["\<\
You can manipulate open notebooks in the front end using standard commands in \
the front end, and using the Option Inspector. \
\>", "Notes",
 CellID->5512],

Cell[TextData[{
 "Open notebooks in the front end are referred to in the kernel by ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " constructs. You can use ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " to look at and modify options for open notebooks. "
}], "Notes",
 CellID->24098]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354211893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->216599431],

Cell[TextData[{
 "Use low-level ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expressions to construct a notebook:"
}], "ExampleText",
 CellID->120859389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"\"\<head\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{"\"\<text\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], "]"}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198498612],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1vU9cdx/FM+73qv7D/BO3hR0Ct+ktXaSVohHRThTb1t6JKq0a7FTqN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   "], {{0, 0}, {458, 129}}, {0, 255}],
  ImageSize->{458 0.75, 129 0.75},
  PlotRange->{{0, 458}, {0, 129}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->897676502]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1008996814],

Cell[TextData[{
 "Use a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression for representing graphics:"
}], "ExampleText",
 CellID->648693245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{"Cell", "[", 
      RowBox[{"BoxData", "[", 
       RowBox[{"GraphicsBox", "[", 
        RowBox[{
         RowBox[{"DiskBox", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "]"}], "]"}], "]"}], 
     "}"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413964107],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3U2MG+d9x3EVvfBU8DhH9qYjj3sk+gLwZLNFDmwLNJRRy0yLIEyRA4EA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   "], {{0, 0}, {458, 222}}, {0, 255}],
  ImageSize->{458 0.75, 222 0.75},
  PlotRange->{{0, 458}, {0, 222}}]], "NotebookImage",
 CellID->162355281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96402294],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression for a two-dimensional input form:"
}], "ExampleText",
 CellID->109051812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\"\<x\>\"", ",", "\"\<p\>\""}], "]"}], "]"}], ",", 
       "\"\<Input\>\""}], "]"}], "}"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416822032],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1TlFUcx2m6b/wXuu+vyLrVqfGmmklwArTGcWy6aKaZLpzUkmzCFxAF
VAIURBFIRIwXeVmWBZeXBVmQxYLVCQRfSBgJ6HSePbtnzz67IMo+avH5zEfm
9z3n9zx59Z2d1ertHXs+3PFmSkrKZvnL80ZKijVnZHyLiIhOuLi0jIiISVS3
6/my64iImBRt7frKP0IjIv4PTNiuAgAA1kFG5LtW2hUAIInQrgAATkC7AgA4
Ae0KAOAEtCsAgBPQrgAATkC7AgA4Ae0KAOAEtCsAgBPQrgAATkC7AgA4Ae0K
AOAEtCsAgBPQrgAATkC7AgA4Ae0KAOAEtCsAgBPQrgAAL8xX39S8vyVP+cFH
p80r2hUAICnIgjUj7QoAkBRoVwAAJ9hQ7ZryTqvSNgMAJJ0N1a4iUqrmAADg
BButXQWfWgHgpUC7AgA4wUZr1/hvBihbAHCCDdWuK/2pFtUKAElnQ7XrSvDx
FQCSy+jYNO0qjM+uFCwArB9ZrepfiTUPaddX+zsBgP86qlr/erJAu+qvBahW
AFgnuloF37sCACQJs1oF7QoAkCRy8117v67W/wXCnXsqzFvaFQDACWhXAAAn
oF0BAJyAdgUAcALaFQDACWhXAAAnoF0BAJzAbNcvdmcFRn+vqnEfyipGRMR1
uvj3oss9tPfL7Izdh2W7SoeHxxARcZ2a7TrsnxBieXl5CRER1+M/y0tmu94a
HF9cXJqbfyqdDxme5+TPBR3n5sIL8lAv69l0nkgkEl/T+NyddiK/rGDbu6Vb
N5dsfS9eeS5v5Y568OnThbm5Bd2u/X13Hs/OTc88np55FPr5ODI/ss8PzAW9
rw9nY2+JRCLxtYov0mnV27YsHT0mzhSJwsIEnimSt3JHPTjzwHpEt2tPz+i9
P2fGg/fHJybf2rTJdDw4OR6cCs8T5jwlNdbuR4YpPasYPTf2Ey5H3xxaVrdq
sD8Ve0skEolrilaJTYYO1clk5Dxi+GrSeiryhtuZaaL2iqgsX9HaK3JHPTtx
9/5EcFq3a1f3yOide8O3J1R9yUEZicHo+Uh0JzKMh5bDOyMxLxk3o+3ltlsZ
YxesW3N59VsikUh8ZowMwejhSGy05nFjx3rDSEaaqK4SF86F/9KVHJQ6VlfJ
ndAjwZHR4O3APd2u7k6/b/BOny+gGkwOvb6AGfWQ6HAs4Xlv7Et6Y18ef9sb
O6tbc3n1WyKRSFxj7Iud4xwzn5KDvV0lFcYcaVf1VP9AYODWH7pd5dDl9Xtu
DqkG6+z2u7v8nd3RGBmGzDk83PR3dg1FY5d+asgj941o+wYgflnN7thNt/UP
jbnVb5YDkUgkrj16uv3SzsjPTuvcb52HGk8t607TbxjJSBXVlaK8xNJG6WlR
Uigulcl27VTvvOn39o7qdm13Dba5fK0un2owObS2+1pc/eHYHnNuO2wJHba2
6+X+6LnLZ0b9YMsKy+G5vV8/q5bXckskEolriOETOUdPwudhdafpNwx/tt3q
1aJTouikOGv8nwgKc0TBMXHqiCzY4fTtkUf63R5/040+1a5trsHG5h6parCG
G9bceMOroj7XmsuRE69tsMWG5p6G2EcarJd4E73cq5bVrY6r3xKJROIaYvik
IXweo7Ef8warXYsLRF62OJFt/+x69LA48qMoyJPtqt/T5hr4tdat2rW1faCu
vvPadY9qMDkoVay73nXN0nOt3iNnK9Z3GcuhK+vcE9rUTyWOtmUz6hfG3+ru
XelZIpFIfGasi54n6DR1G99pw+mpojBv6ecs3akLP0Xn+R8OitzjI+mpoWc9
dfWe5pbe8+WN4XZtG6ipdV256lYNJgelLdqMve3Q0TjviI+G9mh74XPdEolE
4nPG1e3QP63vXXOPzx48oOr0yfcHZkOq+HD/fnH8mNzRzzY0efMLayLtOlhZ
1VFV43ZC1YrJ3UREfGkGdqaJnJzpffse7v8uXnkucnMCmalq+XK1u/63nuyj
5eF2bb1VcaHt0kUXIiLa9O76WJzMFbnSnATm5IiT+d2ff6qWL1a4rtZ6D2UV
q3ZtbvYVnW0oLW5CRESbJ/LLetI/Gdu1YzQzLd6xnWnezDS5o5ZLfmm8XOmm
XRERkyvtiojohLQrIqIT2tq1pdVXXNRwrrQJERHXY2lJY3VVtF0ngg8CY1OB
sUlERFynd+8+0u2KiIjJVbbrv2qYrrE=
   "], {{0, 0}, {458, 67}}, {0, 255}],
  ImageSize->{458 0.75, 67 0.75},
  PlotRange->{{0, 458}, {0, 67}}]], "NotebookImage",
 CellID->335220026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->953222826],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression for text and a control object:"
}], "ExampleText",
 CellID->263342617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cell", "[", "\"\<Click OK to continue.\>\"", "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{"BoxData", "[", 
        RowBox[{"ButtonBox", "[", 
         RowBox[{"\"\<OK\>\"", ",", " ", 
          RowBox[{"ButtonFunction", "\[RuleDelayed]", 
           RowBox[{"DialogReturn", "[", "]"}]}], ",", 
          RowBox[{"Evaluator", "\[Rule]", "Automatic"}]}], "]"}], "]"}], 
       "]"}]}], "}"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103924885],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1TVFUcx2l63/Qv9K/08FanhzfVTImTaDWNU9OLZprpRZM9WU2mghii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   "], {{0, 0}, {458, 83}}, {0, 255}],
  ImageSize->{458 0.75, 83 0.75},
  PlotRange->{{0, 458}, {0, 83}}]], "NotebookImage",
 CellID->119250258]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->172776178],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->484084019],

Cell["Set a background color:", "ExampleText",
 CellID->306668154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", "\"\<a\>\"", "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<b\>\"", "]"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721989471],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1PU1ccx3GW/b74L+xf2cOvOheTJTOZYCbqFrNs2c+LMVM3mcsUBXHK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   "], {{0, 0}, {458, 80}}, {0, 255}],
  ImageSize->{458 0.75, 80 0.75},
  PlotRange->{{0, 458}, {0, 80}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->28942336]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellGrouping",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4253089],

Cell[TextData[{
 "Set to ",
 Cell[BoxData[
  ButtonBox["Manual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manual"]], "InlineFormula"],
 " to allow arbitrary cell grouping arrangements:"
}], "ExampleText",
 CellID->153167649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Cell", "[", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cell", "[", "\"\<a\>\"", "]"}], ",", 
           RowBox[{"Cell", "[", "\"\<b\>\"", "]"}]}], "}"}], ",", "Open"}], 
        "]"}], "]"}], "}"}], ",", 
     RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123541005],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1Pk1ccx1l2v/gv7F/Zy61G481mMsEM0C3GbNndkl2YqZvMZfgCooDK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   "], {{0, 0}, {458, 81}}, {0, 255}],
  ImageSize->{458 0.75, 81 0.75},
  PlotRange->{{0, 458}, {0, 81}}]], "NotebookImage",
 CellID->615519042]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Editable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->147963174],

Cell[TextData[{
 "Set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to disable interactive changes:"
}], "ExampleText",
 CellID->325850365],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cell", "[", "\"\<a\>\"", "]"}], ",", 
        RowBox[{"Cell", "[", "\"\<b\>\"", "]"}]}], "}"}], ",", 
      RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->586517617]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19753],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DocumentNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DocumentNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaletteNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaletteNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cell"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4772],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->19355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->1847978],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->233906272]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 56.3584442}", "context" -> "System`", 
    "keywords" -> {
     "notebook container", "low-level notebook representation", "TextData", 
      "BoxData", "StyleData", "CellGroupData"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Notebook[{cell_1, cell_2, ...}] is the low-level construct that \
represents a notebook manipulated by the Mathematica front end. ", 
    "synonyms" -> {}, "title" -> "Notebook", "type" -> "Symbol", "uri" -> 
    "ref/Notebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9473, 255, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->354211893]},
 "Notebook Image"->{
  Cell[10780, 307, 3353, 58, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->897676502],
  Cell[29534, 722, 2458, 43, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->28942336]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40299, 1022},
 {"Notebook Image", 40440, 1026}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2251, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2874, 82, 4192, 83, 70, "ObjectNameGrid"],
Cell[7069, 167, 853, 27, 70, "Usage",
 CellID->6744]
}, Open  ]],
Cell[CellGroupData[{
Cell[7959, 199, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8437, 216, 246, 8, 70, "Notes",
 CellID->23658],
Cell[8686, 226, 167, 4, 70, "Notes",
 CellID->5512],
Cell[8856, 232, 580, 18, 70, "Notes",
 CellID->24098]
}, Closed]],
Cell[CellGroupData[{
Cell[9473, 255, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354211893],
Cell[CellGroupData[{
Cell[9858, 269, 148, 5, 70, "ExampleSection",
 CellID->216599431],
Cell[10009, 276, 354, 13, 70, "ExampleText",
 CellID->120859389],
Cell[CellGroupData[{
Cell[10388, 293, 389, 12, 70, "Input",
 CellID->198498612],
Cell[10780, 307, 3353, 58, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->897676502]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14182, 371, 221, 7, 70, "ExampleSection",
 CellID->1008996814],
Cell[14406, 380, 226, 8, 70, "ExampleText",
 CellID->648693245],
Cell[CellGroupData[{
Cell[14657, 392, 488, 15, 70, "Input",
 CellID->413964107],
Cell[15148, 409, 6284, 105, 70, "NotebookImage",
 CellID->162355281]
}, Open  ]],
Cell[21447, 517, 124, 3, 70, "ExampleDelimiter",
 CellID->96402294],
Cell[21574, 522, 229, 8, 70, "ExampleText",
 CellID->109051812],
Cell[CellGroupData[{
Cell[21828, 534, 399, 12, 70, "Input",
 CellID->416822032],
Cell[22230, 548, 2430, 42, 70, "NotebookImage",
 CellID->335220026]
}, Open  ]],
Cell[24675, 593, 125, 3, 70, "ExampleDelimiter",
 CellID->953222826],
Cell[24803, 598, 226, 8, 70, "ExampleText",
 CellID->263342617],
Cell[CellGroupData[{
Cell[25054, 610, 606, 16, 70, "Input",
 CellID->103924885],
Cell[25663, 628, 2873, 49, 70, "NotebookImage",
 CellID->119250258]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28585, 683, 222, 7, 70, "ExampleSection",
 CellID->172776178],
Cell[CellGroupData[{
Cell[28832, 694, 231, 7, 70, "ExampleSubsection",
 CellID->484084019],
Cell[29066, 703, 66, 1, 70, "ExampleText",
 CellID->306668154],
Cell[CellGroupData[{
Cell[29157, 708, 374, 12, 70, "Input",
 CellID->721989471],
Cell[29534, 722, 2458, 43, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->28942336]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32041, 771, 231, 7, 70, "ExampleSubsection",
 CellID->4253089],
Cell[32275, 780, 232, 8, 70, "ExampleText",
 CellID->153167649],
Cell[CellGroupData[{
Cell[32532, 792, 541, 17, 70, "Input",
 CellID->123541005],
Cell[33076, 811, 2524, 44, 70, "NotebookImage",
 CellID->615519042]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35649, 861, 229, 7, 70, "ExampleSubsection",
 CellID->147963174],
Cell[35881, 870, 215, 8, 70, "ExampleText",
 CellID->325850365],
Cell[36099, 880, 405, 13, 70, "Input",
 CellID->586517617]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36565, 900, 311, 9, 70, "SeeAlsoSection",
 CellID->19753],
Cell[36879, 911, 718, 26, 70, "SeeAlso",
 CellID->21448]
}, Open  ]],
Cell[CellGroupData[{
Cell[37634, 942, 313, 9, 70, "TutorialsSection",
 CellID->4772],
Cell[37950, 953, 428, 12, 70, "Tutorials",
 CellID->19355]
}, Open  ]],
Cell[CellGroupData[{
Cell[38415, 970, 299, 8, 70, "MoreAboutSection"],
Cell[38717, 980, 167, 3, 70, "MoreAbout",
 CellID->1847978],
Cell[38887, 985, 165, 3, 70, "MoreAbout",
 CellID->233906272]
}, Open  ]],
Cell[39067, 991, 50, 0, 70, "History"],
Cell[39120, 993, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

