(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18942,        550]
NotebookOptionsPosition[     15243,        428]
NotebookOutlinePosition[     16877,        474]
CellTagsIndexPosition[     16759,        468]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookSave" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSave"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"NotebookSave\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Options in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/EvaluationOptionsInNotebooks"], 
          "Managing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ManagingComputationsInNotebooks"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation Options in Notebooks\"\>", 
       2->"\<\"Managing Computations in Notebooks\"\>", 
       3->"\<\"Mathematica Session History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookAutoSave", "ObjectName",
 CellID->26612],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NotebookAutoSave",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookAutoSave"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies whether the \
notebook should automatically be saved after each piece of output generated \
by evaluation in it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->530222255],

Cell[TextData[{
 "Create a notebook with ",
 Cell[BoxData[
  RowBox[{"NotebookAutoSave", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and save it to a file:"
}], "ExampleText",
 CellID->16580820],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ExpressionCell", "[", 
         RowBox[{
          RowBox[{"Defer", "[", 
           RowBox[{"#", "+", "#"}], "]"}], ",", "\"\<Input\>\""}], "]"}], 
        "&"}], ",", 
       RowBox[{"Range", "[", "3", "]"}]}], "]"}], ",", 
     RowBox[{"NotebookAutoSave", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89162640],

Cell[BoxData[
 RowBox[{
  RowBox[{"fname", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<autosave.nb\>\""}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50167563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookSave", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<autosave.nb\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8786137],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9vU9cdx3FPez71X9i/sm5PWzH1CZ20EjRCuqlCTHuANmkPqtFuZZ1G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   "], {{0, 0}, {458, 122}}, {0, 255}],
  ImageSize->{458 0.75, 122 0.75},
  PlotRange->{{0, 458}, {0, 122}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->261392313]
}, Open  ]],

Cell["Check the time of creation of the notebook file:", "ExampleText",
 CellID->7584726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"Date", "/.", 
    RowBox[{"FileInformation", "[", "fname", "]"}]}], ",", "\"\<Time\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->39845456],

Cell[BoxData["\<\"12:58:22\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->317531243]
}, Open  ]],

Cell["\<\
When you evaluate an input, the notebook is automatically resaved:\
\>", "ExampleText",
 CellID->158380582],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}], "\n", 
 RowBox[{"SelectionEvaluate", "[", "nb", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->456854127],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1PW9cBx3GmvZ/6L+xfWbe3iVL1TVppDdFC6KYKMe1FpEl70S3t1qzT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   "], {{0, 0}, {458, 131}}, {0, 255}],
  ImageSize->{458 0.75, 131 0.75},
  PlotRange->{{0, 458}, {0, 131}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->22831342]
}, Open  ]],

Cell["This shows the newer modification time of the file:", "ExampleText",
 CellID->120703019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"Date", "/.", 
    RowBox[{"FileInformation", "[", "fname", "]"}]}], ",", "\"\<Time\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->11799512],

Cell[BoxData["\<\"13:02:18\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->74325035]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13748],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NotebookSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookSave"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15692],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->90800921],

Cell[TextData[ButtonBox["Evaluation Options in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationOptionsInNotebooks"]], "MoreAbout",
 CellID->833308179],

Cell[TextData[ButtonBox["Managing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManagingComputationsInNotebooks"]], "MoreAbout",
 CellID->134703850],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->314279278]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookAutoSave - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 40.9049236}", "context" -> "System`", 
    "keywords" -> {"auto-save", "checkpointing", "safe editing"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NotebookAutoSave is a notebook option which specifies whether the \
notebook should automatically be saved after each piece of output generated \
by evaluation in it. ", "synonyms" -> {"notebook auto save"}, "title" -> 
    "NotebookAutoSave", "type" -> "Symbol", "uri" -> 
    "ref/NotebookAutoSave"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3439, 104, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Notebook Image"->{
  Cell[5147, 173, 3129, 54, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->261392313],
  Cell[9184, 267, 3502, 60, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->22831342]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16397, 454},
 {"Notebook Image", 16530, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2174, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2797, 81, 54, 1, 70, "ObjectName",
 CellID->26612],
Cell[2854, 84, 548, 15, 70, "Usage",
 CellID->5521]
}, Open  ]],
Cell[CellGroupData[{
Cell[3439, 104, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3816, 118, 148, 5, 70, "ExampleSection",
 CellID->530222255],
Cell[3967, 125, 261, 9, 70, "ExampleText",
 CellID->16580820],
Cell[4231, 136, 520, 17, 70, "Input",
 CellID->89162640],
Cell[4754, 155, 174, 6, 70, "Input",
 CellID->50167563],
Cell[CellGroupData[{
Cell[4953, 165, 191, 6, 70, "Input",
 CellID->8786137],
Cell[5147, 173, 3129, 54, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->261392313]
}, Open  ]],
Cell[8291, 230, 89, 1, 70, "ExampleText",
 CellID->7584726],
Cell[CellGroupData[{
Cell[8405, 235, 218, 7, 70, "Input",
 CellID->39845456],
Cell[8626, 244, 173, 5, 36, "Output",
 CellID->317531243]
}, Open  ]],
Cell[8814, 252, 117, 3, 70, "ExampleText",
 CellID->158380582],
Cell[CellGroupData[{
Cell[8956, 259, 225, 6, 70, "Input",
 CellID->456854127],
Cell[9184, 267, 3502, 60, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->22831342]
}, Open  ]],
Cell[12701, 330, 94, 1, 70, "ExampleText",
 CellID->120703019],
Cell[CellGroupData[{
Cell[12820, 335, 218, 7, 70, "Input",
 CellID->11799512],
Cell[13041, 344, 172, 5, 36, "Output",
 CellID->74325035]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13274, 356, 311, 9, 70, "SeeAlsoSection",
 CellID->13748],
Cell[13588, 367, 204, 6, 70, "SeeAlso",
 CellID->21415]
}, Open  ]],
Cell[CellGroupData[{
Cell[13829, 378, 314, 9, 70, "TutorialsSection",
 CellID->15692],
Cell[14146, 389, 149, 3, 70, "Tutorials",
 CellID->407]
}, Open  ]],
Cell[CellGroupData[{
Cell[14332, 397, 318, 9, 70, "MoreAboutSection",
 CellID->90800921],
Cell[14653, 408, 171, 3, 70, "MoreAbout",
 CellID->833308179],
Cell[14827, 413, 177, 3, 70, "MoreAbout",
 CellID->134703850],
Cell[15007, 418, 164, 3, 70, "MoreAbout",
 CellID->314279278]
}, Open  ]],
Cell[15186, 424, 27, 0, 70, "History"],
Cell[15216, 426, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

