(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70947,       1741]
NotebookOptionsPosition[     64405,       1526]
NotebookOutlinePosition[     66832,       1593]
CellTagsIndexPosition[     66712,       1587]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateWindow" :> 
          Documentation`HelpLookup["paclet:ref/CreateWindow"], 
          "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "CreatePalette" :> 
          Documentation`HelpLookup["paclet:ref/CreatePalette"], 
          "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], "NotebookGet" :> 
          Documentation`HelpLookup["paclet:ref/NotebookGet"], "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CreateWindow\"\>", 2->"\<\"CreateDocument\"\>", 
       3->"\<\"CreatePalette\"\>", 4->"\<\"CreateDialog\"\>", 
       5->"\<\"NotebookGet\"\>", 6->"\<\"NotebookOpen\"\>", 
       7->"\<\"Put\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookPut", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookPut",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookPut"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a notebook corresponding to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " and makes it the currently selected notebook in the front end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookPut",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookPut"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a new empty notebook."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookPut",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookPut"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the notebook represented by the notebook \
object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " with one corresponding to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->10580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 " is a low-level function that allows you to take a raw notebook expression \
in the kernel and make it an open notebook in the front end. "
}], "Notes",
 CellID->479661519],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should have head ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 ", and contain raw ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " objects, with boxes data."
}], "Notes",
 CellID->59089378],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " corresponding to the notebook it creates. "
}], "Notes",
 CellID->4850],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookPut",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPut"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
 " overwrites whatever data was contained in the notebook represented by the \
notebook object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->619993251,
  ButtonNote->"619993251"]
}], "Notes",
 CellID->10944],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 " can take any notebook option. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->137909394,
  ButtonNote->"137909394"]
}], "Notes",
 CellID->8018]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4693823],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->522624745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
       "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
    "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141379686],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1TlNcZh+n0syX/Qv+KTGOmSWqa8VOcZGIco6NgBTVO4jTDt2TSNtX4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   "], {{0, 0}, {458, 107}}, {0, 255}],
  ImageSize->{458 0.75, 107 0.75},
  PlotRange->{{0, 458}, {0, 107}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->510184350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121658514],

Cell["Assign a generated notebook object to a symbol:", "ExampleText",
 CellID->25215456],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195775508],

Cell["Rewrite the notebook content:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->619993251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{"Cell", "[", 
       RowBox[{"\"\<Replacement content.\>\"", ",", "\"\<Subsection\>\""}], 
       "]"}], "}"}], "]"}], ",", "nb"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77399953],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnflTlPcdx+n0Z0v+hfwVmQanSYrN+FOcdjzG6ABLYUGZJFPH33TSNoV4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   "], {{0, 0}, {458, 72}}, {0, 255}],
  ImageSize->{458 0.75, 72 0.75},
  PlotRange->{{0, 458}, {0, 72}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->853135897]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->335159380],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->77022394],

Cell["Set the background color:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->137909394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Section heading\>\"", ",", "\"\<Subsection\>\""}], "]"}],
        ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], ",", 
    RowBox[{"Background", "->", 
     RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->798865207],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnf1TVNcZx+n0Z0v+hY5/RKboNEm1mfEXTDIqk+joQgHfJin11zhpmmh8
NyUqbypEBIliomBUlKIGBBZQEFB5UbQFdOpr1CmOVu3tOff93r27LLCnTdjP
Z76u53nOc5571h++nr27s/vrrD++l/XLlJSUVeJP+y9SUuQ4N/cThBBCKvTi
5SuEEEIJlO2u3xysRwghlBD53PX/foRGCKFpoEB3/RQAAKZArnWvFXcFAEgg
uCsAgApwVwAAFeCuAAAqwF0BAFSAuwIAqAB3BQBQAe4KAKAC3BUAQAW4KwCA
CnBXAAAV4K4AACrAXQEAVIC7AgCoAHcFAFAB7goAoALcFQBABbgrAIAKcFcA
ABXgrgAAKsBdAQBUgLsCAMTDgsU7fp9ebGjeu4Uxkga4KwDARBFeOm4SdwUA
mChJ566h9PRQ+swUnbSQkcvzJkJpZmAOZlorZqbn2bP2YrtxWkQHGem9rb/d
HWSlTOopAJh2JJ+7pll+Jq3Na3FiZAxEkWGTdsYqtmfEyOOvdmVEjZgxL+O7
CgBMZ5LQXW1TNFzQ8k2JZXxR3dV0ygAczwyoEWdf55CKuwIkBUnnrhb6K3Xp
cm6zsw62sdw1xSbK2TWgRt4LsKtxV4CkICnd1bjxGXGWNG+R5vlvsrpf14fS
7HsHbovMywu57wx4awyvDqUbF3FXAsD0Jfnc1TZMB/u06Zw+3e9kec3Yfqsr
L6Kr/10t82is59Ots3K0d8UAYHqRdO7qvOVknSYT1jjeE2n8lQDw8yUZ3VX3
toR/GCovPS3OdvFXAsDPl6RzV9dd18SeXQEA3CShuwIAqMP5VoH5uCsAQOLh
7AoAkCjcX4f1TsbOyALcFQBABbgrAIAKcFcAABXgrgAAKsBdAQBUgLsCAKgA
dwUAUMG894rcIe4KAJAQOLsCAKgAdwUAUAHuCgCgAtwVAEAFuCsAgApwVwAA
FeCuAAAqwF0hGPvXc1OCfhgXIOlxf7/rvHcLIwtwVwjC5638cDhALPhtApgk
ptdirwDBJKm7ek5hnte3xi/GBh7MXFOuJXYrmTNKXMtirbHLIlbFVxZtq3Ze
5PRxwJKZ6SFXc3fnOC8qno2vEgA8TBN3jXjNGuuOYMALXNMiPH7lda2IKfMK
Tl5Werwo8jrWrhLgrtG2GvDkvFcNenrxuqv3ojNn4q4A0UlCd/W9onXsw5gI
XmlUmXPuQq8zuiPTirxWG9f50LvToLLoW/XMeHbt3Y8nitNdPe18/QDARxK6
a+BC5+AZePKL7mZR3TViiT5nxFN213G3Gvlv4d9P3oTvDMTqAAB+ktZdvf4U
w7LGOStOwV3tudjuGlQWY6uRz28y7hp0UdwVYCIkpbv6qi1/8LuHyw6DXmNH
GtME7wx4bzREddegslhbjWgQ9BTGuzMQuDfuDABMgGR0V/fdAC+RR0LfK2Tv
jPeqE35Xa9wdxyqLvtWgnUZZEsNd47go72oBxGKauOuECDjRBX/MyWccrqkg
I4pwV9+agE9kObOB/xvYL73dn7EK3E/0iSgz438iK8re+EQWQJwko7tGP91N
upcai1FqX3gjgFqS0l0/jXamnHSvoPuuU+d/5q4q/4sASFaS1V0BAJTgfJHL
fNwVACDxcHYFAEgU7m8gfCdjZ4ykAe4KAKAC3BUAQAW4KwCACnBXAAAV4K4A
ACrAXQEAVIC7AgCoAHcFAFAB7goAoALcFQBABbgrAIAKcFcAABW43XX1h1uG
rv+95lh485YKhBBCU9SLf79oCff9aU1+7ofbhLsKDQzcQAghNEW53XWgf0TT
Xr169RIhhNBU9J9XL93uevXK8IsXL8eePhN6qsscj4nH53Y4NmYWiKRdbI/d
ekpISEj4Ew0n7GlFew7uXfC7A/PnVM6fGymRF7Oixlj47NnzsbHntrv2dN98
/GTs/oPH9x880h8fW+NH/vFDd4FdbyefeGcJCQkJf1LhZDytdkH6yx07ta/L
tdLSAH1dLmZFjbHwwUO5xHbXrq7rt//5YHj03vDIneGRoytTU3/12mtCM1Lf
3hq+Mzx6d/jwRzJcfVSMD62Wsyur7w6P3G3d/rZV+dEhp+Ze67ag/Mjd4XD+
HKu50JztncOjXVvnOhmz86hsLh/llsSjsyVPjTnrKyYkJCSMEgqLG9U9zdDI
HStvyZy6I1dZHa4tz9ROHNeOHIqqE8dFjbF25Na9kdH7trt2XBi8fvP2wLWR
gWvVOampM1JXV+jjXHM8OlC5Wjrk8uqBwZGK5dLocirt4lV6savGaTI8KKbs
fOUq3W+N5kJy9uzGuSL55sawCF2dzdkBR8ODRp85284GzhISEhKOF1qDUSc5
6A3leNhVIzsM5mZqtTVadZVmIAaG7LC2RtToS0YHr49eG7ptu2u4rb/3ys3u
3qHushXSwbKrLolx79DebGl3WWVDl6y8SJZaye7eqizpoitK9WJXjZnfq+ft
nnXr5ojBG+uaRHND7m6XvGNjttuqvGT3eXNTXeAsISEhYXxht3ccoRvuVWLg
d1fBYdfYcldjVc/loctX/2G7qxh0dPa3X+xr250jHSxzf7ijv+1CX2GmtLtl
Jf3tJblGvu1Cf5GZ7Gvr2L9MumhuYUefKG4r0deGRM3+pTKfUySSHVY+c3/t
n99yv7o3iq1L9LWLy4XkeGmJuUQ/6L619nvZXMy2Fet9fru+xgj1i4YvWLOE
hISE44XtF/qF2qzHNpnvl3nd8Yzitov95sDqMJgb0mqPaIcqpXwcKNMqS7Xv
Dgp3bTN6XuzvvHTddtfmlivnW3qbhAr+IB1saVlTc29jS8+OpdLuluwS+WyZ
n72uurnXSTaXLZEumr2jWYx7Go2apaVOvkXmm3Zlmz2PrJuVmjrr49ONVvGs
j+uc2Ra7c0+jsRmxVmyj2Qp36Xub/Xl14CwhISHh+KGZEWMnY+ZNNVpldoeB
7GXSV8t3a+Ul2r5ix1pLC7S9O7XdXwmDHchZZi3pCbf3n/2h23DX8y1Xzpzr
ksrPkg62ZI8c/9D55WJpdx/kdzXkZ8r8rDfS9HeXZsz6S9W5LmPWOmRmfmms
XbwnWr5B9s90pmSTzjPePvrlOkWlLNZnxaMZmnv4tCpwlpCQkHD80Mw0mHmP
XPWeDtJdK/ZqxflaUb7/7Lpjm/bVVm1vsXBXu8/5lsvfnwgb7trUfLnudNup
+vZT20PSwd4vkuP69q3vS99btL3jVH2HzJxur6vvEDp1WoZ19cWL5Bk1tFUW
i7yc1RcWZej5LUZo9bRmfcVOaFwuY3vkbNEi+2MMaZ+UB60lJCQkHDesc/KB
niZnzSlXh4GckFZa/PKvW2xPfb7dGT/dtEEr3DWYE9LXttedbj/XeOmbQ2dM
dz1/+diJluMnw8c3L5MOllEoxyfDmzKkpy3cHDbCCBUulC66bJMct5atmS2K
X19z1JVv9fZs9S73h97LRRTvW/u6aPubtWWBs4SEhIQTC2Or1X6U910Ldz3Z
8IVhp//a+MUTXUb44/r12q6dosZe23C2c0/pMctdrxypaa05FlaiDbq7Liwc
t3L9QumuCzao2QZCCE1KQysytYKC+5999uP6dZESea2wYGh5yCg+Whs+/beu
/B2HTHdtunq4+vx337YghBDyqXPlB1pJoVYoVBCgggKtZM+FVUuN4m8Pt5w8
0bl5S4XhrufO9ZbvazhQcRYhhJBPRXsOduUsvrEy6/ryzEjdWJHZuTxT1BjF
lfvPHD0Sxl0RQiixwl0RQkiFcFeEEFIhn7s2NvVWlDdUHTiLEEJoKjpQeaa2
xnHXkdGHQzfuDt24gxBCaIq6deuR7a4IIYQSK+Gu/wXLCoTo
   "], {{0, 0}, {458, 106}}, {0, 255}],
  ImageSize->{458 0.75, 106 0.75},
  PlotRange->{{0, 458}, {0, 106}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->101172181]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowTitle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->91843203],

Cell[TextData[{
 "An explicit setting of ",
 Cell[BoxData[
  ButtonBox["WindowTitle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowTitle"]], "InlineFormula"],
 " is reflected in the name of the resulting notebook object:"
}], "ExampleText",
 CellID->219789206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Section heading\>\"", ",", "\"\<Subsection\>\""}], "]"}],
        ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], ",", 
    RowBox[{"WindowTitle", "\[Rule]", "\"\<Example Notebook\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207336981],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnelTVFcah5mazw75F+afmJRLKQ5qMfMhVlJZKtEKi4IaK0lNiqokpTGb
mhiXDBpATAsRQcMSEYwGybBEBJolgKBhUWQGSGqMmsUarDjq3Dnn7rf7dttA
n2js56lfOuc95z3veZsPP09fKPhj1stPZP0+KSlpo/iv63dJSXKck7MFIYSQ
Ct2+cxchhFAcZbvrpxVfIoQQiotC3PW+X6ERQughkK+7agAAMAdyrGetuCsA
QBzBXQEAVIC7AgCoAHcFAFAB7goAoALcFQBABbgrAIAKcFcAABXgrgAAKsBd
AQBUgLsCAKgAdwUAUAHuCgCgAtwVAEAFuCsAgApwVwAAFeCuAAAqwF0BAFSA
uwIAqAB3BQBQAe4KAKAC3BUAQAW4KwBALORuOrH8sSJDjz9bEmXSAHcFAJgp
wkvvOYm7AgDMlIRz1+ZAoDmQlqST22zMjXsnmnPNwBykWTvSAuP2qr3ZLpwb
VkFGem3r/+4KMlNO6lMA8NCReO6aa/mZtDavxYmRMRBJhk3aM1ayvSJGHn+1
M8NyxIp5TMgpAPAwk4Duapui4YKWb0os44vorqZT+uB4pk+OuPs6l1TcFSAh
SDh3tdA/qUuXc5uddbGN5q5JNhHurj458lmAnY27AiQECemuxoPPsLuk+Yh0
PPQhq/tzfXOu/ezAbZHj483uJwPeHMOrmwPGIe5MAHh4STx3tQ3Twb5tOrdP
93eyvGZsf6trPKxq6He1zKuxPh+w7sqRvisGAA8XCeeuzrecrNtk3ArHeiON
PRMAfrskorvq3hb3H4YaD+TGWC72TAD47ZJw7up66hrfuysAgJsEdFcAAHU4
v1VgJe4KABB/uLsCAMQL96/DWv9ydXgC7goAoALcFQBABbgrAIAKcFcAABXg
rgAAKsBdAQBUgLsCAKjgiVWH3CHuCgAQF7i7AgCoAHcFAFAB7goAoALcFQBA
BbgrAIAKcFcAABXgrgAAKsBdwR/7r+cm+f1hXICEx/37XR9/tiQ8AXcFP0K8
lT8cDhAN/jYBzBLTa7FXAH8S1F09tzDP51vjL8b6XsxcS64tdik5Z6S4tkXb
Y6eF7YotLVKr9ryY08c+W9ICza7i7soxHireTUgmAHh4SNw17DNrtCeCPh9w
TYvw+JXXtcKWzBOceZnp8aLwc6yu4uCukVr1eXPeU/3eXqzu6j00LQ13BYhM
ArpryCdaxz6MBf+dRpa55k70OqM7Mq3Ia7Ux3Q+9nfqlRW7Vs+Lp2tuPJ4rR
XT3lQuoBQAgJ6K6+G52Lp+/NL7KbRXTXsC36mhHP2V3v2Wr41yK0n/EZPxmI
VgEAQklYd/X6UxTLusddcQ7uaq9Fd1e/tCithr+/2bir36G4K8BMSEh3Dcm2
/CHUPVx26PcZO9yYZvhkwPugIaK7+qVFazWsgN9buNeTAd/eeDIAMAMS0V3d
TwO8hF8JQz4he1e8p874u1r37DhaWuRW/TqNsCWKu8ZwKN/VAojGQ+KuM8Ln
Ruf/Y04hxuFa8jOiMHcN2ePzE1nOqu+/BvZHb/fPWPn2E3khwsq9fyIrQm/8
RBZAjCSiu0a+3c26lhqLUWpfeCOAWhLSXbVId8pZ1/J77jp3fjV3VflPBECi
kqjuCgCgBOcXuazEXQEA4g93VwCAeOH+DYTrX66OMmmAuwIAqAB3BQBQAe4K
AKAC3BUAQAW4KwCACnBXAAAV4K4AACrAXQEAVIC7AgCoAHcFAFAB7goAoALc
FQBABW533fjizrFL/6w9EfxgZxlCCKE56vZ/b7cHh/72Sl7Oi7uFuwqNjFxG
CCE0R7nddWR4UtPu3r17ByGE0Fz0v7t33O76zYWJ27fvTN/8ReimLnM8LV5v
2eH0tJkgJu1ke+zWTd9wuOgvycnz/lo0HEsyISEhoZJwxp62P1Bx8Mk/H1mZ
Wr5yWbjEvFgVOcbGX365NT19y3bXgXPjP9+Yvnb952vXf9Jff7bGP4WOf3An
2Pn25A3vqjfsL1gh3DWtoC+WZEJCQsL4h7PxtLonH7uz7yPtk1KtuNhHn5SK
VZFjbLz+g9xiu2tf36Xv/n19YurqRNWLf3jkEVupe47vWp4sBhuqv5+Y+r5j
9woxnrcsr2Py+IZkOT8veUXq8mTxuit4dSKYlyrMc3lex9RVIzN1d6/YVbnR
qqAn2MXnbTwuVieqXzLHk6EJqXt6ZUuTztEbqmVoFDRWjXkrv8+drLf3UuVU
WFnRlU8nsnLHnhWeNLHXd9J+p9aqeZB+ut0zISHhAxdOXpmYuqJPGjNXrHlL
5tIVucuqcHFdpnbqpFZTGVGnToocY+/kt1cnp67Z7trdM3pp/LuRi5Mj5Rul
V6yrkuOLk6P6a9k64Z8byy5WZQtLWbq7+eKUmBFpKe8HRy4Gt6eK1WXbW6ZG
WnaniIRUkTDZ/P4yPaFjVN8uxtnlkyMtu5ZaCcZkTrnrxPIXdJsSB03qp0+M
mgMpo6AsorchxkvF6U63E84pRp92HSPHKatXdrXqbDSrVXp6NrrSvyBOz/Z2
4x3Jt+/TMyEh4YMWWoMpZ3LUG8rxhCtHVhjNydTqarWqo+YPXYmBITusqxU5
+pap0UtTF8e+s9012Dk8eGH83ODYuZL10kzWHu0X48Ex4/Xc4NEs86a6vlif
qd+aKsIlW1vFuHitsJfUdxrG+ht2LBZWk7Kj3kpYbCWIcVaJTFhiJfRbB9kn
2jX79XOto82xsSqL6PlGplPZ07ns1mi139uqU9mvk4NWNffX4aDrCKdn450m
py5OSY7SMyEh4YMZnvOOw3TZvUsMQt1VUO0aW+5q7Bo4P3b+m3/Z7ioG3b3D
XV8PdX6cLQ0k83Cwe7izZ0ioq0cMmt5YbLhrdmHPcJeY7B6ufXOp88k6eekb
nw91fr5tkfCcxdtqe4Zq9NVFbzZ2dg8VZsq96QeGuqyEGlH5gH5QxmFzkHm4
zlXQLCtWe4aCehvGqigiqqVnyi2LtjQ6lUVOkVmns+dwurQ+0arcWxteVuSc
cFrtshqwq4me7a72W5NBd8/mG1lqFwmaXyt9LyEh4YMadkkHE55mvnbKedPT
Oq3kzq+HzYFVYTQnQ6ur0SrLpUI4UqKVF2vHKoS7dho1vx7u7b9ku2tb+4Wz
7YOtQgVrXJ6Z8nrNYGvbwL7nhVmlvFZTslqYyaKtVSKtzVbDa4vk6uvHBs7U
bF0obW3NvrbBqk0pssLzJcZ2MV5dMNhqJIgKbQNGwsJN9a35a81MfXXhpoYz
bQNnCtaaq22DMmw3C67OFz2s2Wuv2nvbB81T8kWy3qfehtxrltVL5a/RNza0
HntX7+TdKquyPFdfDe25wDxClNprHdF6bOsC4424Vs8YX8C2AbtnQkLCBy80
Z8TYmWl3e5o+r6fZFUbWpktfLf1YKz2gHXL9fe3iAu3gR9rHe4XBjmSnW1sG
gl3DzV+dM9z1bPuFppY+qbwsaRerA3L8Va94/XCVtJT5r54U46OvLpGrC98+
WvH2Atd3hRa8eqqppbex4u35wnMWLllgPkbI+lCvpm9562hLX6N3l6zT0mue
uCrQKE/PDF2VXfU2Wkc/typLZupbFrhacrdhNGz9A5H5oTjXasMq29dU8Za3
E9me2OutdlKc2+g9Yr5+RJP+RoxSxnHmG9SL2D0TEhI+eKE502jOe+TK91SQ
7lp2UCvK0/bnhd5d9+3W9u7SDhYJd7XrnG0///mpoOGurW3n6xs6T3/ZdXpP
hvSKZ/fLsa56qe7TUl2nG+RYhg3d+pIYd5lL+rjeHM8ktE6Mnlyau9jwt2f2
dNfrW+bn1kVI3v+0vLtm7IpybtkW+Q/Bgi2ls+vZ2T7zvYSEhPcvrHfmZ+Bp
I9kZWnHRnb/vtD311h5nfHPHe1ph/mh2hr63q76hq+VM/6eVTaa7nj1/4lT7
yS+CJz9Idz+ifPSV43IyJnW4XkMmo4b6ifOeKYyeXPLKIv0umr7D2uLtzZ1c
+JR0Vz0z0rmHNj8qcuZvLpldz872me8lJCR8UMLocjxNPnctzL/x3nbDTv/z
/vYbuozwx23btPyPRI69t7G5N1B8wnLXCzW1HbUngvdB7+nu+lThr3po8eY/
CXt8dHPgvmxHCP2mNLY+UysouPbOOz9u2xouMa8VFoytyzCSj9cFG/7Rl7ev
0nTX1m+qq84e+6wdIYRQiHo3PKcdKNQKhQp8VFCgHQj0vPC8kfxZdfsXp3o/
2FlmuGtLy2DpocYjZc0IIYRCtD9Q0Ze96vKGrEvrMsN1eX1m77pMkWMklx9u
Ol4TxF0RQii+wl0RQkiFcFeEEFKhEHc90zpYVtp49EgzQgihuehIeVNdreOu
k1M/jF3+fuzyFYQQQnPUt9/+ZLsrQgih+Eq46/8BKkVrtw==
   "], {{0, 0}, {458, 107}}, {0, 255}],
  ImageSize->{458 0.75, 107 0.75},
  PlotRange->{{0, 458}, {0, 107}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->247230717]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24535],

Cell["\<\
Create a palette for generating a choice of new template notebooks using \
specific stylesheets:\
\>", "ExampleText",
 CellID->183333870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Button", "[", 
          RowBox[{"\"\<Start Outline\>\"", ",", " ", 
           RowBox[{"NotebookPut", "[", 
            RowBox[{
             RowBox[{"Notebook", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<My outline title\>\"", ",", "\"\<Title\>\""}], 
                 "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Level 1 Topic\>\"", ",", "\"\<Outline1\>\""}], 
                 "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Level 2 Topic\>\"", ",", "\"\<Outline1\>\""}], 
                 "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Level 3 Topic\>\"", ",", "\"\<Outline1\>\""}], 
                 "]"}]}], "}"}], "]"}], ",", 
             RowBox[{"StyleDefinitions", "->", 
              RowBox[{"FrontEnd`FileName", "[", 
               RowBox[{
                RowBox[{"{", "\"\<Utility\>\"", "}"}], ",", 
                "\"\<Outline.nb\>\""}], "]"}]}]}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Button", "[", 
          RowBox[{"\"\<Start Preprint\>\"", ",", " ", "\[IndentingNewLine]", 
           RowBox[{"NotebookPut", "[", 
            RowBox[{
             RowBox[{"Notebook", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Preprint Title\>\"", ",", "\"\<Title\>\""}], 
                 "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{
                 "\"\<Preprint Subtitle is Optional\>\"", ",", 
                  "\"\<Subtitle\>\""}], "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{
                 "\"\<Abstract begins here...\>\"", ",", "\"\<Abstract\>\""}],
                  "]"}], ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Author Name\>\"", ",", "\"\<Author\>\""}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Cell", "[", 
                 RowBox[{
                 "\"\<author@domain.net\>\"", ",", "\"\<AuthorEmail\>\""}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Section\>\"", ",", "\"\<Section\>\""}], "]"}], 
                ",", 
                RowBox[{"Cell", "[", 
                 RowBox[{"\"\<Text begins here...\>\"", ",", "\"\<Text\>\""}],
                  "]"}]}], "}"}], "]"}], ",", 
             RowBox[{"StyleDefinitions", "->", 
              RowBox[{"FrontEnd`FileName", "[", 
               RowBox[{
                RowBox[{"{", "\"\<Article\>\"", "}"}], ",", 
                "\"\<Preprint.nb\>\""}], "]"}]}]}], "]"}]}], "]"}]}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Spacings", "\[Rule]", "0"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Palette\>\""}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2114735941],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWPtTU+kZPjP92WZ/6u/9Yf+IFcYNDTBtZ9qd6ax2unYUkHCRQdbSmdax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   "], {{0, 0}, {85, 73}}, {0, 255},
   ColorFunction->RGBColor],
  DisplayFunction->Identity,
  ImageSize->{85 0.75, 73 0.75},
  PlotRange->{{0, 85}, {0, 73}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->614987054]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 " and similar low\[Hyphen]level functions require detailed specifications:"
}], "ExampleText",
 CellID->569430701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Cell", "[", 
       RowBox[{"BoxData", "[", 
        RowBox[{"GridBox", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"ButtonBox", "[", 
            RowBox[{"\"\<Sample Button\>\"", ",", 
             RowBox[{"Appearance", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}], ",", 
             RowBox[{"ButtonFunction", "\[RuleDelayed]", 
              RowBox[{"CreateDocument", "[", "]"}]}], ",", 
             RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "]"}], 
           "}"}], "}"}], "]"}], "]"}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Active", "\[Rule]", "True"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"WindowFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
     RowBox[{"WindowFrameElements", "\[Rule]", "\"\<CloseBox\>\""}], ",", 
     RowBox[{"WindowElements", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"WindowSize", "\[Rule]", "All"}], ",", 
     RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", 
     RowBox[{"WindowFloating", "\[Rule]", "True"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Palette\>\""}], ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"WindowClickSelect", "\[Rule]", "False"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 ShowSyntaxStyles->False,
 CellLabel->"In[1]:=",
 CellID->14243436],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWO1TU9kZvzP9bLOf+n0/7B/QjyuMCw0ync60O9NZ7XTdUUACIoPU2pnW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   "], {{0, 0}, {92, 49}}, {0, 255},
   ColorFunction->RGBColor],
  DisplayFunction->Identity,
  ImageSize->{92 0.75, 49 0.75},
  PlotRange->{{0, 92}, {0, 49}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->605072756]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " and other high-level notebook functions create the same result more \
easily:"
}], "ExampleText",
 CellID->342863884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"Column", "[", 
     RowBox[{"{", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<Sample Button\>\"", ",", 
        RowBox[{"CreateDocument", "[", "]"}]}], "]"}], "}"}], "]"}], ",", 
    RowBox[{"WindowTitle", "\[Rule]", "\"\<Palette\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5063857],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWO1TU9kZvzP9bLOf+r0f9g/oxxXGhQaZTmfanemsdrpuFZCAyCC1dqZ1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   "], {{0, 0}, {93, 49}}, {0, 255},
   ColorFunction->RGBColor],
  DisplayFunction->Identity,
  ImageSize->{93 0.75, 49 0.75},
  PlotRange->{{0, 93}, {0, 49}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->591446039]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15012],

Cell[TextData[{
 "Create a staggered series of notebooks using ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->681810046],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NotebookPut", "[", "#", "]"}], "&"}], "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Notebook", "[", 
       RowBox[{
        RowBox[{"{", "#", "}"}], ",", " ", 
        RowBox[{"WindowMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"m", "++"}], "20"}], ",", "Inherited"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Inherited", ",", 
             RowBox[{
              RowBox[{"m", "++"}], "30"}]}], "}"}]}], "}"}]}]}], "]"}], "&"}],
      "/@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<First\>\"", ",", "\"\<Subsection\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Second\>\"", ",", "\"\<Subsection\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Third\>\"", ",", "\"\<Subsection\>\""}], "]"}]}], 
      "}"}]}], ")"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1447071703],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVlQW/ehh7lzn3O5T31oOuncdjJpxy+unZnEwdhJ09qeJlN7ShvXexNn
801S0zpt7HCT1Fnw0gsYbF+MwYRNIrYxS7ywmsVmE0gWEggQCIQAyQIkLCEQ
Agl8/+cc6egcJNbjIkC/b756dP7bUfvw9RybOP/11tHfvfXvISEhzeQ/9/4t
JIT6LJG0TT12GQb6yYfHy0ig7vvuu587XVPfXS0lH5bzvgCAtQoqCgAAQkBF
AQBACKgoAAAIARUFAAAhoKIAACAEVBQAAISAigIAgBBQUQAAEAIqCgAAQkBF
AQBACKgoAAAIARUFAAAhoKIAACAEVBQAAISAigIAgBBQUQAAEAIqCgAAQkBF
AQBACKgoAAAIARUFAAAhoKIAACAEVBQAAISAigIAgBBQUQAAEAIqCgAAQkBF
AQBACKgoAAAIARUFAAAhoKIAACAEVBQAAISAigIAgBBQUQAAEAIqCgAAQkBF
AQBACKgoAAAIARVdrWhTdoSEhOxI0fKuP65wX1Z8HMJecj/PWMZbTZ9X4XcB
AGA2UNEVAdM2Dt46zr3lSVTU5+aoKACLABVdEQSyou7nUPcQ/woAMC+o6Iog
gBWd5xwAwDygoiuCJ1ZR9nruinKOR0UBEAYquiJ4YhX1DLivZqso93xm1jOA
N3oAFgkquiJ4chX1d4qfinIXsH9AzwEVBWChoKKrlVnfxNko+v09UveyFHdM
eZ0NwU86AbB4UNHVhr9nTm8XhdcPvy8KwOJARVcbS6go91l0geejogAsFFQU
AACEgIoCAIAQUFEAABACKgoAAEJARQEAQAioKAAACAEVBQAAIaCiAAAgBFQU
AACEgIoCAIAQUFEAABACKgoAAEJARQEAQAioKAAACCGYK+rvL5gDAIDFEYQV
HR+fuHQp+5NPEiCEULjBWdGyuzIIIXwiBmdF+/v6IITwiRiEFbVYR5fzjgCA
tU0QVrRX1+t0uZxOl9M15XJOOYkuImGK+sXJ/Mr+wiyjZumVLNQyJ7WYnoVw
wQb6/vAJG4QV7enR2ccnyHu93a1jnLp02CmpD9Sl3cGuGWe0swvYjexeCBeh
Ha4tg7Ci3V06q3WUSF7tLSOjyuYWpbJF2axSNKvIB4WSumymPjOXKgUzS12q
zMMWauPIGHXCCLWdPmcMQhi0BmFFNZ09g0MWSpNlYOiRVNaUnZ2dmZGZkZGR
TpOWlnYt6vi3HtJomCmy0r136BH3g7ZJUXfPraxtyDOlbyYjTXrmsr+tte5e
q7qfnurSuNdLdP1DQ2oJ+azRDvlOuU9u7uJPseewd/HKnfJnv07G+5Jw2TXB
NWUQVlSt1vbpB/v6B/v0Q8SYmPjk5OScnJwBD32trV2H9gxptSaTyWw29yqU
JoPBYrGMjIxkZmZSG/uH3CfQn7PeDP2P//xPxl+drZaSlD3o7dMX/Hdo6FP7
U+nPQ/Wx254KfSXqemurdqjvxofM4qd+HV+vl8f8OvSp0MP/d0/doZ8xNXT9
A+rkg4ndWjL13fvuqdBtMdXd0np6UH/trVDv3b230M+iJP5XoaFbThRJWwyz
roH/avsH4VoyCCva1t6t6TawFhaXk0fNwcFBg07XXlFJPrRkZhm3bbGnJpCE
DlwXN+8/YHn0iCTUZrORitK79LTUB9H7pIFbo251UyPVsa+Qcr6ZWnevXdV9
4z2molJqqursr58KfTnqeotSLTn9auhTYV/m1XW2U4fQl1RFyZYZU/QJzGV1
7MvUaWlKNX2XV2Or2AWhh5Oaevm30Hu+oY/0N9x8oqiR3gIhFG4QVlTV2qVq
72lt15FfiQnnk+Li4mJjY8lT6K0/7JHtO6A+dNC6c9vo2b2mz/bUPv9swxcn
mYTazKasrCwVtVGnaiMnEK+9zaRS0tlKRtp6Mt5hktiqaONNlX3zKzpxzfJm
epy0sVbdQm2p+eYV/hbvlPeylNq+Neo6981dUXfpPfL8GUYeLJt6+LfoaW1q
ZV/wFW09LbJm9+X1L8NCQ8kW8lki62a+M1xu2+GaMggrqmzpkis1TZRd5NdT
p2PJE+ZDg4E8hTYlp9x++gf6/ZvHj0VYo7a3HNsqeu5pUfiW8jPRjZFH9AW5
pKJN7r0a+hDxm0wq69uZwSuHmSSqZErxW5ypoq9eZRInldPjpI3VrfQJVSdf
5m/xTnkvUw57X9vdL+/k5MR3qff984r6hg7eLVLe87zgv3eFHp+xl7j580r2
vwhcZuXKLriWDMKKNik7G2XtDTJ14wPya3v+zbIrkR/c2v17+Z596p2/Mbwd
9vj2R5O3jk6c+p1h1wuSDT9XRLxkjNiujztnt9uzRCKyt1Gm9mzPPMSksraV
DBKT3mSS2CyRZbmnqlVk8c1/vEI/THrGqTZS442yis+38rd4p7yX31PbX/6f
64r6+rZGz8n1BdGbyev5p+TBkuxlbkFVVCJVM1/G7S1q2VNvptffU9Tnf7OZ
fqOnz1HDwPgArimDsKJyeUdNfQvrx3//7FLUp3e3hNteWW/fu2Pin4em6j93
NccMXjgi3betL/7w9PfHnF98RBLqcDhEWSJqVx2jqqYu/YA7lc3VdSrihYPu
JFbXpe93N5C8TRdFhVHjF2vJmrQDzDjzil1dcmIzu2XG1LfuE+43V+d9Q72J
R5XUkvHzh8nD5IELLdV1ZfTety/ep9bnndhKh1pZQ92Fr2c7+0ZfW90ycw1c
Nutb4FoyCCsqfdBxr1pZVa2oon5VZl+9lZiYWFhYaM26Yv3yt9aTEZNXI7su
flh65I1rr4ePlh9/XPi+I3Knvbt7YmJCJBIxu4j3qBNS9zEVva+gD1QkHGCS
qLhPT+07cNjzcr31eA5ZUHR8M+eP1A+kkvX07OEEnyn34XRUqXvlfPmS54/j
X/q0iLndzAPp3zutdk/xvUB9k/0nPBW9728NXCaVcC0ZhBVtkLaXV8rvVsrL
Kx8Q//7JP5KSksTZ4oHiIu0H4do/hXcc+mXRa2E33nj96u7tD7/eZY0MH3p1
3cDG9dq4c2KxmN7F7CWHpOxlKlrlPi1uH1PRpir60p/0FtLGKnmlZ7CqijxM
ki0zpvysnMPsT5hn0ab7sy9gYksqWuP5wnD5vQvXlkFYUUlD+52i+uKyxhJK
aXLK1dTUK43f35Rt2Fj802fu/+TH0l2bejOPtp7cLd70s9xfPNP72vPDKYlj
8kaH5B6paHGZtKRUymwvLru8m6lo5QMyTvzfvUxF5eX0pV+pNS99kcm99Gzh
T9GH0xUtm/001sy/bWEqWjnnralH2eNF1RWyeQ+E/yJL4NoyCCtaJ2m7daeO
hPROkeROseSzz8/GxMTE7/9jX2lpQ8LFvOd+6Dj/1nRHnCv94ODeDaXP/qhw
3brJyUmn0+lyuUhFyZZCemNhseRO0aU3SOh2XyIjjGd3kyQeOuu5XIizb6EP
3/RZ+sLOSf8rqeiWv2TMvazgL5tCX/hrwcK/Hnzi3oFryyCsaG09VVHWU6cv
pqamqlpaLBaLTiprCts4+dW79qgI6zsvGna9PHjma/mLL+SfPkP9LU5TU+Ls
bO5eCCFERePOpUZHR1+4cH5kZER64thwdPTY2Nh4r9YWtn4oMYE8hTpMJsW5
hAm7fXp6OhsVhRDyDc6KFtysZ/3bJ9+kpaXpenQjj4a1JUUkocwPNSn/fHS8
tJB5kSdPodM0pKLcvRBCGJwVLSqU5+XWMX6bejsmJuaaD6L4+JvJSb7j7EYI
ISQGYUUrqxR1dS0516shhFC4wVlRpVJ7+5YkK7McQggFGoQV/S67wmAwK5U9
ZWXygvxqcgkhhEs22CpKOHUqua291+Vy9fcZm5p6Gho6SE4hhHBpBmFFyePo
xQvXmZCOWG2moWFd7xC5hBDCJRiEFX3sCalC0c38S5GX/wsAANYMwVnRx3RI
iadPXSE5Dfjvq0AIV69BW1EGpqUQQrhkg7yiAAAgEFQUAACEgIoCAIAQUFEA
ABACKgoAAEJARQWhTdkRwrIjReudqfjYOxHycQV3E2eKt2WWCeYe7BHMIu+J
7KYdKRX8lQCA5QAV5cGrom/m5lnMFoyXUH5Ifabcd/A9zHPruSrq5yugogAs
L6goj8VU1L2Wn0fqipnwv5NZxSsnfeGOKz+OzNUcFeXv4l8BAJYHVJTHop5F
/W2kEubnSdRz0myB9Rmnz2CuZ6/ozF1avNEDsPygojwWX1F+MumC+a+o3+7x
7ztXRdk5VBSAlQUqymNxFZ2x2pOvmXHjFJH/Rs8J4rxv9DN+/5T7Ru+5E97o
AQgEqCiPJf3pkm+2fJ9GZ7yQ+87M96dL/uf8PfaiogAsK6jo0uE9c876A0i+
XeNMLeRHoDzv6d5Z/z9ShZ90AiAgoKICmO25MlDg90UBCACoqDBm/Qn6QICK
AhAAUFEAABACKgoAAEJARQEAQAioKAAACAEVBQAAIaCiAAAgBFQUAACEgIoC
AIAQUFEAABACKgoAAEJARQEAQAioKAAACAEVBQAAIaCiAAAghJVQUd+/rh0A
AFYLgapoSUnNoHmMKG1UQwjh6jXgFYUQwlVtYCtKbg0hhKvawFZ0Oe8IAAD/
CgJb0empaQghXNUGtqIu1xSEEK5qA1tRp9PF2ukPjUbj93J83MHdCyGEgTKw
FZ2cdLJ2dHRmZ2dnZmRmZGSk06SlpV2LOv6thzQaZoqs5O6FEMJAGdiKOhwT
rJcvX05OTs7JyRnw0Nfa2nVoz5BWazKZzGZzr0JpMhgsFsvIyEhmZiZ3L6Om
Mp30l7FAPuQZ76okI5VdzOWQvCCDTA7SU5pK93pqNZkhnys1Dt8p98mVGv4U
ew57F6/cKc43lBcUsGs8XwlCuKoNbEXtHGQyGXnUHBwcNOh07RWV5ENLZpZx
2xZ7agJJ6MB1cfP+A5ZHj0hCbTYbqaidT2cFSVP+AyN9YZRRsaroZGYqvZ/J
TL5nmfFBfnpGvszoPoC+TGfWzZiiT2AuuSeTz+419AL3Xu4tfOisKGB20OcU
yPwuAgCsJgJb0VGbV7E4Oy4uLjY2ljyF3vrDHtm+A+pDB607t42e3Wv6bE/t
8882fHGSSajNbMrKyuLuHbV1VJCOlXewIx3lVNY6fKYeSqnEyQye8TzZQ/cW
oyyPv8U75b3kbOeorqCefqVGn1vMIX077y0ghKvVwFbUbLGxJiVfIU+YDw0G
8hTalJxy++kf6PdvHj8WYY3a3nJsq+i5p0XhW8rPRDdGHtEX5JKKcveaLeoy
EroyNTuiKiNJLFf5TOka8jLS8yR9nvE8qc69xSDJ42/xTnkv6WP5kpPbysmH
sjbbzFvQ47TMsVzp23lvASFcrQa2osMc5HL5lcgPbu3+vXzPPvXO3xjeDnt8
+6PJW0cnTv3OsOsFyYafKyJeMkZs18edI4/QWSLRMI9WOpWt3OuMdOaaN9Ur
oRLX0OsZz5P0unf0NuTxt3invJec7ZyTyWh6Orucv2YWWssyOFsAAKuXwFbU
OGBlPX0m9lLUp3e3hNteWW/fu2Pin4em6j93NccMXjgi3betL/7w9PfHnF98
RBLqcDhEWSLuXuNAewkJWkk7O6IsIUm8q2Snchs11Gd9ba7f8bmnOJfdjVQw
6/TUePNdUsKS5hl7rZo6qqK13Vb+N2RlFjMbIYSr3sBW1GA0s9bWSxMTEwsL
C61ZV6xf/tZ6MmLyamTXxQ9Lj7xx7fXw0fLjjwvfd0TutHd3T0xMiEQi7l6D
UUVXVMWONFEVLWvyTJWUlHlervNqNGRQV5PLeSsvUdHrmS0zp9yH59ZrmMM1
9bme2dxaneeO/F3uu8yugvo+JYo510AIV4OBrWi/3swaE3s+KSlJnC0eKC7S
fhCu/VN4x6FfFr0WduON16/u3v7w613WyPChV9cNbFyvjTsnFou5e/v1qmLS
riIVOyIvopIo560x+9lyo149/9QcK/2orqaeRas75lzWQaU4t1q3kAMhhCvZ
wFa0z2BkvVtRlZp6pfH7m7ING4t/+sz9n/xYumtTb+bR1pO7xZt+lvuLZ3pf
e344JXFM3uiQ3CMV5e7tMyiKSOiKFeyIvJhUtETOWzNTak1urdrfFv4UfThn
5dyqa3IzSCA7/c02lbi/JPlAKlqjWciBEMKVbGAr2q0dZL2UlB4TExO//499
paUNCRfznvuh4/xb0x1xrvSDg3s3lD77o8J16yYnJ51Op8vlIhXl7u3WNheS
0BU2syONhSSJpY28NfM4+xb68Jy6loWd01JFVbRK5XeWPoqR820hhKvXwFe0
x8Ao/i4nNTVV1dJisVh0UllT2MbJr961R0VY33nRsOvlwTNfy198If/0GZLQ
qakpcXY2uxFCCAPoyqlofsGd6OjoCxfOj4yMSE8cG46OHhsbG+/V2sLWDyUm
kKdQh8mkOJcwYbdPT09no6IQwpVhYCva2WXQdBkZExIup6Wl6Xp0I4+GtSVF
JKHMDzUp/3x0vLSQeZEnT6HTNKSi7EYIIQygga1oe3s/CSljnUQRExNzzQdR
fPzN5CTfcXYjhBAG0ABW1Dgw3NPzUK3WQwjh6jWAFdV06Q0GU1urrq2tD0II
V6kBrGhTk8ZisRkM5o6OflVLd8D/p4AQwiUYqIo+9rzUO53OR8NWvd6s0w0G
/J9BgBDCxRrYitbWKpmQ2u3jtpFR8/CIaXgMQghXkQGsKBtSvd7kpJmaheX/
YgAAsEACW9HHdEiJSmU3aWnA/z8FQggXa8Arym0phBCuOldIRQEAYJWCigIA
gBBQUQAAEAIqCgAAQkBFAQBACKu/otqUHSEhIR9X+Jmq+DiEnfK3jBlzsyNF
6zPOGQMAAL+s0Iry+jZ3z5ZaUZ9bsLPMtpDZTgUAAA7BW9HZl3I/AwDA3AR1
RWfexX0TVBQAsHDWSkXneDXnVpR7jPfFfcbbOyoKAFg4QVZRzjm+WfWAigIA
Fs5aqegC3+i5x814FmUG+ctQUgDAfKzQii6Cxf2+aIq7knSVecn0F1tUFAAw
H2ulorO80y8JvNEDABbOmq7o0nNIdqKiAICFsPorCgAAgQQVBQAAIaCiAAAg
BFQUAACEgIoCAIAQUFEAABACKgoAAEJARQEAQAioKAAACAEVBQAAIaCiAAAg
BFQUAACEgIoCAIAQUFEAABACt6J+/oI5AAAAc1JSUjNoHiNKG9UQQggXK1tR
CCGES5CpKHmphxBCuASZigb6d2cBAGC1wlR0emoaQgjhEmQq6nJNQQghXIJM
RZ1OF2unPzQajd/L8XEHdy+EEAabTEUnJ52sHR2d2dnZmRmZGRkZ6TRpaWnX
oo5/6yGNhpkiK7l7IYQw2GQq6nBMsF6+fDk5OTknJ2fAQ19ra9ehPUNarclk
MpvNvQqlyWCwWCwjIyOZmZncvYyaynTSX8YC+ZBnvKuSjFR2MZdD8oIMMjlI
T2kq3eup1WSGfK7UOHyn3CdXavhT7DnsXbxyp2ZbM9syCCGcX6aidg4ymYw8
ag4ODhp0uvaKSvKhJTPLuG2LPTWBJHTgurh5/wHLo0ckoTabjVTUzqezgkQp
/4GRvjDKCkijKjqZmUrvZzKT71lmfJCfnpEvM7oPoC/TmXUzpugTmEvuyeSz
ew29wL2XewsfOisyOCsBAGDJMBUdtXkVi7Pj4uJiY2PJU+itP+yR7TugPnTQ
unPb6Nm9ps/21D7/bMMXJ5mE2symrKws7t5RW0cFqVN5BzvSUU7FqsNn6qGU
SpzM4BnPkz10bzHK8vhbvFPeS852jmqqjQVSo88t/Eh/Me9iCCFcmkxFzRYb
a1LyFfKE+dBgIE+hTckpt5/+gX7/5vFjEdao7S3Htoqee1oUvqX8THRj5BF9
QS6pKHev2aIuI6ErU7MjqjISq3KVz5SuIS8jPU/S5xnPk+rcWwySPP4W75T3
kj6WLzm5rZx8KGuzzbwFPU7LHMs5zf0dIIRwiTIVHeYgl8uvRH5wa/fv5Xv2
qXf+xvB22OPbH03eOjpx6neGXS9INvxcEfGSMWK7Pu4ceZTNEomGebTSqWzl
XmekM9e8qV4JlbiGXs94nqTXvaO3IY+/xTvlveRs55xMRtPT2eX8Nf5oLcvg
nQ8AAIuGqahxwMp6+kzspahP724Jt72y3r53x8Q/D03Vf+5qjhm8cES6b1tf
/OHp7485v/iIJNThcIiyRNy9xoH2EtKlknZ2RFlCknhXyU7lNmqoz/raXL/j
c09xLrsbqWDW6anx5rskhiXNM/ZaNXVURWu7rfxvyJP+esxeCCFcikxFDUYz
a229NDExsbCw0Jp1xfrlb60nIyavRnZd/LD0yBvXXg8fLT/+uPB9R+ROe3f3
xMSESCTi7jUYVXRFVexIE5WpsibPVElJmeflOq9GQwZ1Nbmct/ISFb2e2TJz
yn14br2GOVxTn+uZza3Vee7I3+W+y+wyh3C+MIQQLkqmov16M2tM7PmkpCRx
tniguEj7Qbj2T+Edh35Z9FrYjTdev7p7+8Ovd1kjw4deXTewcb027pxYLObu
7derikmUilTsiLyISqKct8bsZ8uNevX8U3Os9KO6mnoWre6Ye5mu+sYizoQQ
whkyFe0zGFnvVlSlpl5p/P6mbMPG4p8+c/8nP5bu2tSbebT15G7xpp/l/uKZ
3teeH05JHJM3OiT3SEW5e/sMiiISumIFOyIvJhUtkfPWzJRak1ur9reFP0Uf
zlk5t+qa3Iz03OpO3ynqnNwajc9nCCFctExFu7WDrJeS0mNiYuL3/7GvtLQh
4WLecz90nH9ruiPOlX5wcO+G0md/VLhu3eTkpNPpdLlcpKLcvd3a5kISusJm
dqSxkCSxtJG3Zh5n30IfnlPXsrBzWqqoilap/M02lnrf+jnfFkIIF6u3oj0G
RvF3OampqaqWFovFopPKmsI2Tn71rj0qwvrOi4ZdLw+e+Vr+4gv5p8+QhE5N
TYmzs9mNEEIYhPpWNL/gTnR09IUL50dGRqQnjg1HR4+NjY33am1h64cSE8hT
qMNkUpxLmLDbp6ens1FRCGFwy1S0s8ug6TIyJiRcTktL0/XoRh4Na0uKSEKZ
H2pS/vnoeGkh8yJPnkKnaUhF2Y0QQhiEMhVtb+8nIWWskyhiYmKu+SCKj7+Z
nOQ7zm6EEMIglFTUODDc0/NQrdZDCCFcrKSimi69wWBqa9W1tfVBCCFclKSi
TU0ai8VmMJg7OvpVLd0B/0oQQriKZP4FduSl3ul0Phq26vVmnW4w4P8sAIQQ
rhaZitbWKpmQ2u3jtpFR8/CIaXgMQgjhvLL/PmUSUr3e5KSZmoVA/iufAQBg
ZUNCSlQqu0lLA952CCFcLfptKYQQwgX6/27C05A=
   "], {{0, 0}, {450, 211}}, {0, 255},
   ColorFunction->RGBColor],
  DisplayFunction->Identity,
  ImageSize->{337.5, 158.25},
  PlotRange->{{0, 450}, {0, 211}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->712297737]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30826],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreatePalette",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreatePalette"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2716],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->14061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->262760912],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->500908489]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookPut - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 1.4679500}", "context" -> "System`", 
    "keywords" -> {
     "create document", "create notebook", "display of expression", 
      "make notebook object"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookPut[expr] creates a notebook corresponding to expr and makes it \
the currently selected notebook in the front end. NotebookPut[] creates a new \
empty notebook. NotebookPut[expr, obj] replaces the notebook represented by \
the notebook object obj with one corresponding to expr. ", 
    "synonyms" -> {"notebook put"}, "title" -> "NotebookPut", "type" -> 
    "Symbol", "uri" -> "ref/NotebookPut"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11344, 317, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4693823]},
 "Notebook Image"->{
  Cell[12324, 355, 4251, 72, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->510184350],
  Cell[17743, 472, 3561, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->853135897],
  Cell[22503, 583, 4125, 70, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->101172181],
  Cell[27726, 698, 4674, 79, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->247230717],
  Cell[36146, 879, 3497, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->614987054],
  Cell[42224, 1017, 3225, 57, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->605072756],
  Cell[46152, 1103, 3229, 57, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->591446039],
  Cell[51190, 1229, 9720, 163, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->712297737]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65712, 1555},
 {"Notebook Image", 65852, 1559}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2528, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3151, 87, 4195, 83, 70, "ObjectNameGrid"],
Cell[7349, 172, 1456, 44, 70, "Usage",
 CellID->10580]
}, Open  ]],
Cell[CellGroupData[{
Cell[8842, 221, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9320, 238, 315, 8, 70, "Notes",
 CellID->479661519],
Cell[9638, 248, 433, 16, 70, "Notes",
 CellID->59089378],
Cell[10074, 266, 362, 12, 70, "Notes",
 CellID->4850],
Cell[10439, 280, 548, 19, 70, "Notes",
 CellID->10944],
Cell[10990, 301, 317, 11, 70, "Notes",
 CellID->8018]
}, Closed]],
Cell[CellGroupData[{
Cell[11344, 317, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4693823],
Cell[CellGroupData[{
Cell[11727, 331, 148, 5, 70, "ExampleSection",
 CellID->522624745],
Cell[CellGroupData[{
Cell[11900, 340, 421, 13, 70, "Input",
 CellID->141379686],
Cell[12324, 355, 4251, 72, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->510184350]
}, Open  ]],
Cell[16590, 430, 125, 3, 70, "ExampleDelimiter",
 CellID->121658514],
Cell[16718, 435, 89, 1, 70, "ExampleText",
 CellID->25215456],
Cell[16810, 438, 455, 14, 70, "Input",
 CellID->195775508],
Cell[17268, 454, 120, 2, 70, "ExampleText",
 CellID->619993251],
Cell[CellGroupData[{
Cell[17413, 460, 327, 10, 70, "Input",
 CellID->77399953],
Cell[17743, 472, 3561, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->853135897]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21353, 539, 222, 7, 70, "ExampleSection",
 CellID->335159380],
Cell[CellGroupData[{
Cell[21600, 550, 230, 7, 70, "ExampleSubsection",
 CellID->77022394],
Cell[21833, 559, 116, 2, 70, "ExampleText",
 CellID->137909394],
Cell[CellGroupData[{
Cell[21974, 565, 526, 16, 70, "Input",
 CellID->798865207],
Cell[22503, 583, 4125, 70, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->101172181]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26677, 659, 231, 7, 70, "ExampleSubsection",
 CellID->91843203],
Cell[26911, 668, 270, 8, 70, "ExampleText",
 CellID->219789206],
Cell[CellGroupData[{
Cell[27206, 680, 517, 16, 70, "Input",
 CellID->207336981],
Cell[27726, 698, 4674, 79, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->247230717]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32461, 784, 223, 7, 70, "ExampleSection",
 CellID->24535],
Cell[32687, 793, 147, 4, 70, "ExampleText",
 CellID->183333870],
Cell[CellGroupData[{
Cell[32859, 801, 3284, 76, 70, "Input",
 CellID->2114735941],
Cell[36146, 879, 3497, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->614987054]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39692, 946, 232, 7, 70, "ExampleSection",
 CellID->9502],
Cell[39927, 955, 256, 7, 70, "ExampleText",
 CellID->569430701],
Cell[CellGroupData[{
Cell[40208, 966, 2013, 49, 70, "Input",
 CellID->14243436],
Cell[42224, 1017, 3225, 57, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->605072756]
}, Open  ]],
Cell[45464, 1077, 265, 8, 70, "ExampleText",
 CellID->342863884],
Cell[CellGroupData[{
Cell[45754, 1089, 395, 12, 70, "Input",
 CellID->5063857],
Cell[46152, 1103, 3229, 57, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->591446039]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49430, 1166, 224, 7, 70, "ExampleSection",
 CellID->15012],
Cell[49657, 1175, 357, 13, 70, "ExampleText",
 CellID->681810046],
Cell[CellGroupData[{
Cell[50039, 1192, 1148, 35, 70, "Input",
 CellID->1447071703],
Cell[51190, 1229, 9720, 163, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->712297737]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60971, 1399, 311, 9, 70, "SeeAlsoSection",
 CellID->30826],
Cell[61285, 1410, 1716, 62, 70, "SeeAlso",
 CellID->703]
}, Open  ]],
Cell[CellGroupData[{
Cell[63038, 1477, 313, 9, 70, "TutorialsSection",
 CellID->2716],
Cell[63354, 1488, 428, 12, 70, "Tutorials",
 CellID->14061]
}, Open  ]],
Cell[CellGroupData[{
Cell[63819, 1505, 319, 9, 70, "MoreAboutSection",
 CellID->262760912],
Cell[64141, 1516, 169, 3, 70, "MoreAbout",
 CellID->500908489]
}, Open  ]],
Cell[64325, 1522, 50, 0, 70, "History"],
Cell[64378, 1524, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

