(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61825,       1473]
NotebookOptionsPosition[     56390,       1287]
NotebookOutlinePosition[     58152,       1338]
CellTagsIndexPosition[     58032,       1332]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookGet" :> 
          Documentation`HelpLookup["paclet:ref/NotebookGet"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"], 
          "NotebookDelete" :> 
          Documentation`HelpLookup["paclet:ref/NotebookDelete"], 
          "ButtonSource" :> 
          Documentation`HelpLookup["paclet:ref/ButtonSource"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookGet\"\>", 2->"\<\"Get\"\>", 
       3->"\<\"NotebookWrite\"\>", 4->"\<\"NotebookDelete\"\>", 
       5->"\<\"ButtonSource\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookRead", "ObjectName",
 CellID->7807],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookRead",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookRead"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the expression corresponding to the current \
selection in the specified notebook object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookRead"]], "InlineFormula"],
 " is the basic way to get into the kernel pieces of notebooks that are being \
manipulated by the front end. "
}], "Notes",
 CellID->2749]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8623339],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->59496731],

Cell["This creates a document notebook:", "ExampleText",
 CellID->4449957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<This is the quadratic formula:\>\"", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "b"}], "\[PlusMinus]", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}], "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "a"}], ")"}]}], "//", "TraditionalForm"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4329873],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["3ig_shm", 1, 1]], 71]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Untitled-1\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["3ig_shm", 1, 1]], 71],
  Editable->False]], "Output",
 ImageSize->{209, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293973754]
}, Open  ]],

Cell["This selects the first cell:", "ExampleText",
 CellID->463918591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32930150],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3ftTVOcdx/Ht9Bd/6vijv/Y3/4xOLzP+0PHS5gdqZ5rFiWjaycR0Op3O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   "], {{0, 0}, {458, 118}}, {0, 255}],
  ImageSize->{458 0.75, 118 0.75},
  PlotRange->{{0, 458}, {0, 118}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->13245499]
}, Open  ]],

Cell[TextData[{
 "This reads the cell and returns its ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->262508665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->420408763],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"\<\"This is the quadratic formula:\"\>", ",", "\<\"Text\"\>"}], 
  "]"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->402288634]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31310],

Cell["Create a notebook and move the selection to the first \"T\":", \
"ExampleText",
 CellID->1037626643],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Text Group\>\"", ",", "\"\<Section\>\""}], "]"}], ",",
           
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Mary had a little lamb.\>\"", ",", "\"\<Text\>\""}], 
           "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{
           "\"\<Its fleece was white as snow.\>\"", ",", "\"\<Text\>\""}], 
           "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Graphics Group\>\"", ",", "\"\<Section\>\""}], "]"}], 
          ",", 
          RowBox[{"ExpressionCell", "[", " ", 
           RowBox[{
            RowBox[{"Plot", "[", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"-", 
                RowBox[{"x", "^", "2"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
            "\"\<Output\>\""}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356012824],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "CellContents"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Character"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->342746478],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zHdV9x3F1+nsn/0L/kE6Zpvkhk8EaM2EY6qEBU0BuJ9akY2Y6mOlA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   "], {{0, 0}, {458, 384}}, {0, 255}],
  ImageSize->{458 0.75, 384 0.75},
  PlotRange->{{0, 458}, {0, 384}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->532742073]
}, Open  ]],

Cell["Read the current selection:", "ExampleText",
 CellID->71975722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->399637059],

Cell[BoxData["\<\"T\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->139093266]
}, Open  ]],

Cell["Select multiple cells and read the content:", "ExampleText",
 CellID->288773701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellGroup"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14612606],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zHdV9x3F1+nsn/0L/kE6Zpvkhk2CN0zAM9ZCAKUZuJ9akY2Y6mOlA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   "], {{0, 0}, {458, 384}}, {0, 255}],
  ImageSize->{458 0.75, 384 0.75},
  PlotRange->{{0, 458}, {0, 384}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->230360298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->491503552],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"CellGroupData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"\<\"Text Group\"\>", ",", "\<\"Section\"\>"}], "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{"\<\"Mary had a little lamb.\"\>", ",", "\<\"Text\"\>"}], 
       "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{"\<\"Its fleece was white as snow.\"\>", ",", "\<\"Text\"\>"}],
        "]"}]}], "}"}], ",", "Open"}], "]"}], "]"}]], "Output",
 ImageSize->{577, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->27557690]
}, Open  ]],

Cell["Select and read graphics:", "ExampleText",
 CellID->934259820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellContents", ",", "2"}], "]"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->155037575],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3X+sFeWdx/GzMbl/mNuNwT80JjVu1JhgTDBNaEwwNrA1kiA3KprwI1vo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   "], {{0, 0}, {458, 384}}, {0, 255}],
  ImageSize->{458 0.75, 384 0.75},
  PlotRange->{{0, 458}, {0, 384}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->143992278]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"grbox", "=", 
   RowBox[{"NotebookRead", "[", "nb", "]"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->15572261],

Cell["Display the result: ", "ExampleText",
 CellID->411128277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "grbox", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->644426818],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->60254327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30259],

Cell["\<\
A palette that reads the word at the current selection and makes it upper \
case:\
\>", "ExampleText",
 CellID->9216189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"Button", "[", 
   RowBox[{"\"\<Make Upper Case\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"in", "=", 
        RowBox[{"InputNotebook", "[", "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"SelectionMove", "[", 
        RowBox[{"in", ",", "All", ",", "Word"}], "]"}], ";", 
       RowBox[{"NotebookWrite", "[", 
        RowBox[{"in", ",", 
         RowBox[{"ToUpperCase", "[", 
          RowBox[{"NotebookRead", "[", "in", "]"}], "]"}]}], "]"}]}]}], 
     "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587292102],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                 "\"Make Upper Case\"", ButtonFunction :> 
                  With[{$CellContext`in = InputNotebook[]}, 
                    SelectionMove[$CellContext`in, All, Word]; 
                    NotebookWrite[$CellContext`in, 
                    ToUpperCase[
                    NotebookRead[$CellContext`in]]]], Appearance -> Automatic,
                   ButtonFrame -> "DialogBox", Evaluator -> Automatic, Method -> 
                  "Preemptive", ButtonData -> "paclet:ref/Make Upper Case"], 
                 StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          ButtonBox["\<\"Make Upper Case\"\>",
           Appearance->Automatic,
           ButtonData->"paclet:ref/Make Upper Case",
           ButtonFrame->"DialogBox",
           
           ButtonFunction:>
            With[{$CellContext`in = InputNotebook[]}, 
             SelectionMove[$CellContext`in, All, Word]; 
             NotebookWrite[$CellContext`in, 
               ToUpperCase[
                NotebookRead[$CellContext`in]]]],
           Evaluator->Automatic,
           Method->"Preemptive"]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  PaletteNotebook[
   Button["Make Upper Case", 
    With[{$CellContext`in = InputNotebook[]}, 
     SelectionMove[$CellContext`in, All, Word]; 
     NotebookWrite[$CellContext`in, 
       ToUpperCase[
        NotebookRead[$CellContext`in]]]]]]]], "Output",
 ImageSize->{120, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439101792]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26895],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonSource",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonSource"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12273],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->13964]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->123480987]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookRead - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 2.9992392}", "context" -> "System`", 
    "keywords" -> {"import notebook"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookRead[notebook] gives the expression corresponding to the current \
selection in the specified notebook object. ", 
    "synonyms" -> {"notebook read"}, "title" -> "NotebookRead", "type" -> 
    "Symbol", "uri" -> "ref/NotebookRead"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4358, 137, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8623339]},
 "Notebook Image"->{
  Cell[6951, 232, 3945, 67, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->13245499],
  Cell[13618, 399, 9884, 165, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->532742073],
  Cell[24170, 596, 9912, 165, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->230360298],
  Cell[35151, 804, 11104, 185, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->143992278]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57451, 1312},
 {"Notebook Image", 57590, 1316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2296, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2919, 83, 49, 1, 70, "ObjectName",
 CellID->7807],
Cell[2971, 86, 553, 16, 70, "Usage",
 CellID->21526]
}, Open  ]],
Cell[CellGroupData[{
Cell[3561, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4039, 124, 282, 8, 70, "Notes",
 CellID->2749]
}, Closed]],
Cell[CellGroupData[{
Cell[4358, 137, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8623339],
Cell[CellGroupData[{
Cell[4741, 151, 147, 5, 70, "ExampleSection",
 CellID->59496731],
Cell[4891, 158, 74, 1, 70, "ExampleText",
 CellID->4449957],
Cell[CellGroupData[{
Cell[4990, 163, 583, 18, 47, "Input",
 CellID->4329873],
Cell[5576, 183, 1113, 35, 60, "Output",
 CellID->293973754]
}, Open  ]],
Cell[6704, 221, 71, 1, 70, "ExampleText",
 CellID->463918591],
Cell[CellGroupData[{
Cell[6800, 226, 148, 4, 70, "Input",
 CellID->32930150],
Cell[6951, 232, 3945, 67, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->13245499]
}, Open  ]],
Cell[10911, 302, 222, 8, 70, "ExampleText",
 CellID->262508665],
Cell[CellGroupData[{
Cell[11158, 314, 109, 3, 70, "Input",
 CellID->420408763],
Cell[11270, 319, 263, 8, 36, "Output",
 CellID->402288634]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11582, 333, 216, 7, 70, "ExampleSection",
 CellID->31310],
Cell[11801, 342, 106, 2, 70, "ExampleText",
 CellID->1037626643],
Cell[11910, 346, 1386, 39, 70, "Input",
 CellID->356012824],
Cell[CellGroupData[{
Cell[13321, 389, 294, 8, 70, "Input",
 CellID->342746478],
Cell[13618, 399, 9884, 165, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->532742073]
}, Open  ]],
Cell[23517, 567, 69, 1, 70, "ExampleText",
 CellID->71975722],
Cell[CellGroupData[{
Cell[23611, 572, 109, 3, 70, "Input",
 CellID->399637059],
Cell[23723, 577, 166, 5, 36, "Output",
 CellID->139093266]
}, Open  ]],
Cell[23904, 585, 86, 1, 70, "ExampleText",
 CellID->288773701],
Cell[CellGroupData[{
Cell[24015, 590, 152, 4, 70, "Input",
 CellID->14612606],
Cell[24170, 596, 9912, 165, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->230360298]
}, Open  ]],
Cell[CellGroupData[{
Cell[34119, 766, 109, 3, 70, "Input",
 CellID->491503552],
Cell[34231, 771, 640, 18, 54, "Output",
 CellID->27557690]
}, Open  ]],
Cell[34886, 792, 68, 1, 70, "ExampleText",
 CellID->934259820],
Cell[CellGroupData[{
Cell[34979, 797, 169, 5, 70, "Input",
 CellID->155037575],
Cell[35151, 804, 11104, 185, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->143992278]
}, Open  ]],
Cell[46270, 992, 154, 5, 70, "Input",
 CellID->15572261],
Cell[46427, 999, 63, 1, 70, "ExampleText",
 CellID->411128277],
Cell[CellGroupData[{
Cell[46515, 1004, 112, 3, 70, "Input",
 CellID->644426818],
Cell[46630, 1009, 2786, 50, 70, "Output",
 Evaluatable->False,
 CellID->60254327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49465, 1065, 223, 7, 70, "ExampleSection",
 CellID->30259],
Cell[49691, 1074, 130, 4, 70, "ExampleText",
 CellID->9216189],
Cell[CellGroupData[{
Cell[49846, 1082, 660, 18, 70, "Input",
 CellID->587292102],
Cell[50509, 1102, 3175, 78, 70, "Output",
 CellID->439101792]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53745, 1187, 311, 9, 70, "SeeAlsoSection",
 CellID->26895],
Cell[54059, 1198, 1211, 44, 70, "SeeAlso",
 CellID->4922]
}, Open  ]],
Cell[CellGroupData[{
Cell[55307, 1247, 314, 9, 70, "TutorialsSection",
 CellID->12273],
Cell[55624, 1258, 186, 4, 70, "Tutorials",
 CellID->13964]
}, Open  ]],
Cell[CellGroupData[{
Cell[55847, 1267, 299, 8, 70, "MoreAboutSection"],
Cell[56149, 1277, 169, 3, 70, "MoreAbout",
 CellID->123480987]
}, Open  ]],
Cell[56333, 1283, 27, 0, 70, "History"],
Cell[56363, 1285, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

