(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11857,        440]
NotebookOptionsPosition[      8286,        320]
NotebookOutlinePosition[      9717,        359]
CellTagsIndexPosition[      9633,        354]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/WordSeparators"], "NullWords" :> 
          Documentation`HelpLookup["paclet:ref/NullWords"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WordSeparators\"\>", 
       2->"\<\"NullWords\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NullRecords", "ObjectName",
 CellID->993],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NullRecords",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NullRecords"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     " and related functions which specifies whether null records should be \
taken to exist between repeated record separators. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"NullRecords", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", repeated record separators are treated like single record separators. "
}], "Notes",
 CellID->19197]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173212155],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->541948267],

Cell["Create a stream of records: ", "ExampleText",
 CellID->855939584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stream", "=", 
  RowBox[{
  "StringToStream", "[", "\"\<a\\nb\\n\\nc\\n\\n\\nd\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320591936],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "87"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200908979]
}, Open  ]],

Cell["Read its records: ", "ExampleText",
 CellID->21119133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"stream", ",", "Record"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96727487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14747091]
}, Open  ]],

Cell["Close stream:", "ExampleText",
 CellID->209237940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stream", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73888004],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156072139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29536687],

Cell["Read the same stream including all zero length records: ", "ExampleText",
 CellID->46080629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stream", "=", 
  RowBox[{
  "StringToStream", "[", "\"\<a\\nb\\n\\nc\\n\\n\\nd\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108463554],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "88"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181216275]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"stream", ",", "Record", ",", 
   RowBox[{"NullRecords", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223244729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"\"\>", ",", "\<\"\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30285695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stream", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->164374151],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->224181030]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15748],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullWords"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->139],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->24207]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NullRecords - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 5.5477154}", "context" -> "System`", 
    "keywords" -> {
     "null records", "empty records", "reading records", "parsing records", 
      "parsing tabular data", "reading tabular data"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NullRecords is an option for Read and related functions which specifies \
whether null records should be taken to exist between repeated record \
separators. ", "synonyms" -> {"null records"}, "title" -> "NullRecords", 
    "type" -> "Symbol", "uri" -> "ref/NullRecords"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3468, 117, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->173212155]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9490, 347}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1278, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1901, 59, 47, 1, 70, "ObjectName",
 CellID->993],
Cell[1951, 62, 665, 19, 70, "Usage",
 CellID->24521]
}, Open  ]],
Cell[CellGroupData[{
Cell[2653, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3131, 103, 300, 9, 70, "Notes",
 CellID->19197]
}, Closed]],
Cell[CellGroupData[{
Cell[3468, 117, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173212155],
Cell[CellGroupData[{
Cell[3853, 131, 148, 5, 70, "ExampleSection",
 CellID->541948267],
Cell[4004, 138, 71, 1, 70, "ExampleText",
 CellID->855939584],
Cell[CellGroupData[{
Cell[4100, 143, 170, 5, 28, "Input",
 CellID->320591936],
Cell[4273, 150, 225, 7, 36, "Output",
 CellID->200908979]
}, Open  ]],
Cell[4513, 160, 60, 1, 70, "ExampleText",
 CellID->21119133],
Cell[CellGroupData[{
Cell[4598, 165, 136, 4, 28, "Input",
 CellID->96727487],
Cell[4737, 171, 257, 8, 36, "Output",
 CellID->14747091]
}, Open  ]],
Cell[5009, 182, 56, 1, 70, "ExampleText",
 CellID->209237940],
Cell[CellGroupData[{
Cell[5090, 187, 105, 3, 70, "Input",
 CellID->73888004],
Cell[5198, 192, 163, 5, 36, "Output",
 CellID->156072139]
}, Open  ]],
Cell[5376, 200, 124, 3, 70, "ExampleDelimiter",
 CellID->29536687],
Cell[5503, 205, 98, 1, 70, "ExampleText",
 CellID->46080629],
Cell[CellGroupData[{
Cell[5626, 210, 170, 5, 70, "Input",
 CellID->108463554],
Cell[5799, 217, 225, 7, 36, "Output",
 CellID->181216275]
}, Open  ]],
Cell[CellGroupData[{
Cell[6061, 229, 190, 5, 70, "Input",
 CellID->223244729],
Cell[6254, 236, 310, 8, 36, "Output",
 CellID->30285695]
}, Open  ]],
Cell[CellGroupData[{
Cell[6601, 249, 106, 3, 70, "Input",
 CellID->164374151],
Cell[6710, 254, 163, 5, 36, "Output",
 CellID->224181030]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6934, 266, 311, 9, 70, "SeeAlsoSection",
 CellID->15748],
Cell[7248, 277, 465, 17, 70, "SeeAlso",
 CellID->20691]
}, Open  ]],
Cell[CellGroupData[{
Cell[7750, 299, 312, 9, 70, "TutorialsSection",
 CellID->139],
Cell[8065, 310, 149, 3, 70, "Tutorials",
 CellID->24207]
}, Open  ]],
Cell[8229, 316, 27, 0, 70, "History"],
Cell[8259, 318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

