(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10577,        373]
NotebookOptionsPosition[      7570,        274]
NotebookOutlinePosition[      9008,        314]
CellTagsIndexPosition[      8924,        309]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TokenWords" :> 
          Documentation`HelpLookup["paclet:ref/TokenWords"], 
          "RecordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/RecordSeparators"], 
          "NullRecords" :> 
          Documentation`HelpLookup["paclet:ref/NullRecords"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TokenWords\"\>", 
       2->"\<\"RecordSeparators\"\>", 
       3->"\<\"NullRecords\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NullWords", "ObjectName",
 CellID->28858],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NullWords",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NullWords"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     " and related functions which specifies whether null words should be \
taken to exist between repeated word separators. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17679]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"NullWords", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", repeated word separators are treated like single word separators. "
}], "Notes",
 CellID->20483]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33700506],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->575839029],

Cell["A file containing words separated by colons:", "ExampleText",
 CellID->1492523603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/words\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1836203850],

Cell["first:second::fourth:::seventh", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->269547422]
}, Open  ]],

Cell["Repeated colons are treated as single separators:", "ExampleText",
 CellID->1595080418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/words\>\"", ",", "Word", ",", 
   RowBox[{"WordSeparators", "->", 
    RowBox[{"{", "\"\<:\>\"", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87715014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"first\"\>", ",", "\<\"second\"\>", ",", "\<\"fourth\"\>", 
   ",", "\<\"seventh\"\>"}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13964691]
}, Open  ]],

Cell["Repeaed colons are taken to have nulls words in between:", "ExampleText",
 CellID->1478219825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/words\>\"", ",", "Word", ",", 
   RowBox[{"WordSeparators", "->", 
    RowBox[{"{", "\"\<:\>\"", "}"}]}], ",", 
   RowBox[{"NullWords", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->807536240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"first\"\>", ",", "\<\"second\"\>", ",", "\<\"\"\>", 
   ",", "\<\"fourth\"\>", ",", "\<\"\"\>", ",", "\<\"\"\>", 
   ",", "\<\"seventh\"\>"}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->297091001]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5262],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TokenWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TokenWords"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RecordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RecordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullRecords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullRecords"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27129],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->13203]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NullWords - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 6.5164902}", "context" -> "System`", 
    "keywords" -> {
     "empty words", "null words", "empty fields", "null fields", 
      "parsing records", "parsing fields", "reading records", 
      "reading fields"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NullWords is an option for Read and related functions which specifies \
whether null words should be taken to exist between repeated word separators. \
", "synonyms" -> {"null words"}, "title" -> "NullWords", "type" -> "Symbol", 
    "uri" -> "ref/NullWords"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3599, 121, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33700506]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8782, 302}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1423, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2046, 63, 47, 1, 70, "ObjectName",
 CellID->28858],
Cell[2096, 66, 657, 19, 70, "Usage",
 CellID->17679]
}, Open  ]],
Cell[CellGroupData[{
Cell[2790, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3268, 107, 294, 9, 70, "Notes",
 CellID->20483]
}, Closed]],
Cell[CellGroupData[{
Cell[3599, 121, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33700506],
Cell[CellGroupData[{
Cell[3983, 135, 148, 5, 70, "ExampleSection",
 CellID->575839029],
Cell[4134, 142, 88, 1, 70, "ExampleText",
 CellID->1492523603],
Cell[CellGroupData[{
Cell[4247, 147, 130, 3, 70, "Input",
 CellID->1836203850],
Cell[4380, 152, 111, 2, 70, "Print",
 CellID->269547422]
}, Open  ]],
Cell[4506, 157, 93, 1, 70, "ExampleText",
 CellID->1595080418],
Cell[CellGroupData[{
Cell[4624, 162, 234, 6, 70, "Input",
 CellID->87715014],
Cell[4861, 170, 279, 8, 36, "Output",
 CellID->13964691]
}, Open  ]],
Cell[5155, 181, 100, 1, 70, "ExampleText",
 CellID->1478219825],
Cell[CellGroupData[{
Cell[5280, 186, 281, 7, 70, "Input",
 CellID->807536240],
Cell[5564, 195, 335, 9, 36, "Output",
 CellID->297091001]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5960, 211, 310, 9, 70, "SeeAlsoSection",
 CellID->5262],
Cell[6273, 222, 722, 26, 70, "SeeAlso",
 CellID->13528]
}, Open  ]],
Cell[CellGroupData[{
Cell[7032, 253, 314, 9, 70, "TutorialsSection",
 CellID->27129],
Cell[7349, 264, 149, 3, 70, "Tutorials",
 CellID->13203]
}, Open  ]],
Cell[7513, 270, 27, 0, 70, "History"],
Cell[7543, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

