(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10426,        401]
NotebookOptionsPosition[      7265,        292]
NotebookOutlinePosition[      8501,        328]
CellTagsIndexPosition[      8417,        323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Real" :> Documentation`HelpLookup["paclet:ref/Real"], "DigitQ" :> 
          Documentation`HelpLookup["paclet:ref/DigitQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Real\"\>", 
       2->"\<\"DigitQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Number", "ObjectName",
 CellID->8621],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"]], "InlineFormula"],
     "\[LineSeparator]represents an exact integer or an approximate real \
number in ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7034]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
An integer is returned if no explicit decimal point is present. \
\>", "Notes",
 CellID->10440],

Cell[TextData[{
 "Approximate real numbers can be given in C or Fortran forms, such as ",
 Cell[BoxData[
  RowBox[{"2.4", "E5"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.4"}], "e"}], "-", "4"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17453]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136889514],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->161578111],

Cell["Open a stream:", "ExampleText",
 CellID->2102684787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<12.3 456 789\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1322990999],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "88"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->514721151]
}, Open  ]],

Cell["Read numbers from the stream object:", "ExampleText",
 CellID->832320077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1592955828],

Cell[BoxData["12.3`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32117510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1012679237],

Cell[BoxData["456"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47154066]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->865765518],

Cell[BoxData["789"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->403399019]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->2052414146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1418257024],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->20184383]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14661],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Real",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Real"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19907],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->27806]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Number - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 18.9855594}", "context" -> "System`", 
    "keywords" -> {"read numbers", "read reals", "read integers"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Number represents an exact integer or an approximate real number in \
Read. ", "synonyms" -> {}, "title" -> "Number", "type" -> "Symbol", "uri" -> 
    "ref/Number"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3430, 123, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->136889514]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8274, 316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1228, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1851, 58, 43, 1, 70, "ObjectName",
 CellID->8621],
Cell[1897, 61, 579, 19, 70, "Usage",
 CellID->7034]
}, Open  ]],
Cell[CellGroupData[{
Cell[2513, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2991, 102, 105, 3, 70, "Notes",
 CellID->10440],
Cell[3099, 107, 294, 11, 70, "Notes",
 CellID->17453]
}, Closed]],
Cell[CellGroupData[{
Cell[3430, 123, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136889514],
Cell[CellGroupData[{
Cell[3815, 137, 148, 5, 70, "ExampleSection",
 CellID->161578111],
Cell[3966, 144, 58, 1, 70, "ExampleText",
 CellID->2102684787],
Cell[CellGroupData[{
Cell[4049, 149, 155, 4, 28, "Input",
 CellID->1322990999],
Cell[4207, 155, 225, 7, 36, "Output",
 CellID->514721151]
}, Open  ]],
Cell[4447, 165, 79, 1, 70, "ExampleText",
 CellID->832320077],
Cell[CellGroupData[{
Cell[4551, 170, 131, 4, 28, "Input",
 CellID->1592955828],
Cell[4685, 176, 161, 5, 36, "Output",
 CellID->32117510]
}, Open  ]],
Cell[CellGroupData[{
Cell[4883, 186, 131, 4, 70, "Input",
 CellID->1012679237],
Cell[5017, 192, 159, 5, 36, "Output",
 CellID->47154066]
}, Open  ]],
Cell[CellGroupData[{
Cell[5213, 202, 130, 4, 70, "Input",
 CellID->865765518],
Cell[5346, 208, 160, 5, 36, "Output",
 CellID->403399019]
}, Open  ]],
Cell[5521, 216, 61, 1, 70, "ExampleText",
 CellID->2052414146],
Cell[CellGroupData[{
Cell[5607, 221, 104, 3, 70, "Input",
 CellID->1418257024],
Cell[5714, 226, 162, 5, 36, "Output",
 CellID->20184383]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5937, 238, 311, 9, 70, "SeeAlsoSection",
 CellID->14661],
Cell[6251, 249, 439, 17, 70, "SeeAlso",
 CellID->12367]
}, Open  ]],
Cell[CellGroupData[{
Cell[6727, 271, 314, 9, 70, "TutorialsSection",
 CellID->19907],
Cell[7044, 282, 149, 3, 70, "Tutorials",
 CellID->27806]
}, Open  ]],
Cell[7208, 288, 27, 0, 70, "History"],
Cell[7238, 290, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

