(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18773,        675]
NotebookOptionsPosition[     14303,        522]
NotebookOutlinePosition[     15671,        560]
CellTagsIndexPosition[     15586,        555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberFieldDiscriminant" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldDiscriminant"], 
          "NumberFieldRegulator" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRegulator"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NumberFieldDiscriminant\"\>",
        2->"\<\"NumberFieldRegulator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Number Theory\"\>", 
       2->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldClassNumber", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldClassNumber",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldClassNumber"], "[", 
       StyleBox["\[Theta]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the class number for the algebraic number field \
",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
       TraditionalForm]], "InlineMath"],
     " generated by ",
     Cell[BoxData[
      FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->232031125],

Cell[TextData[{
 "Find the class number of the algebraic number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    SqrtBox["5"], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->126110277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"Sqrt", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263426191],

Cell[BoxData["1"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485120731]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Class number of complex and real quadratic fields:", "ExampleText",
 CellID->1761645834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"-", "151"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->889603525],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53899224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"Sqrt", "[", "3263123", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267819435],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83229577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1820791404],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldClassNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldClassNumber"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->1821383950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"-", "71"}], "]"}], ",", " ", 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161773854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "1"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710226046]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Value of the Dirichlet L-functions at ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " for the real primitive character modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "11"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->919804158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", " ", 
  RowBox[{
   RowBox[{"NumberFieldClassNumber", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"-", "11"}], "]"}], "]"}], "/", 
   RowBox[{"Sqrt", "[", "11", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1220833658],

Cell[BoxData[
 FractionBox["\[Pi]", 
  SqrtBox["11"]]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{39, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->566055716]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["Number of representations of 19 as a sum of 3 squares:", "ExampleText",
 CellID->107853424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"12", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"JacobiSymbol", "[", 
     RowBox[{
      RowBox[{"-", "19"}], ",", "2"}], "]"}]}], ")"}], " ", 
  RowBox[{"NumberFieldClassNumber", "[", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"-", "19"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430613057],

Cell[BoxData["24"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246977521]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquaresR", "[", 
  RowBox[{"3", ",", " ", "19"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310620327],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245111008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Class number for some algebraic number fields may not be yet available:\
\>", "ExampleText",
 CellID->865002216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"1", "+", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1487876314],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberFieldClassNumber", "::", "\<\"unkn\"\>"}], ":", 
  " ", "\<\"The class number of the number field generated by \\!\\(\\@\\(1 + \
\\@2\\)\\) is not yet available.\"\>"}]], "Message", "MSG",
 CellID->56896230],

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  SqrtBox[
   RowBox[{"1", "+", 
    SqrtBox["2"]}]], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{235, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265097]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldDiscriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldDiscriminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRegulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRegulator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->465520745],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->44727649],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->119135406]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldClassNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 7.6102682}", "context" -> "System`", 
    "keywords" -> {"class number", "number field"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldClassNumber[\\[Theta]] gives the class number for the \
algebraic number field \\[DoubleStruckCapitalQ][\\[Theta]] generated by \
\\[Theta].", "synonyms" -> {"number field class number"}, "title" -> 
    "NumberFieldClassNumber", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldClassNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5289, 149, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15451, 548}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2247, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2870, 81, 1587, 37, 70, "ObjectNameGrid"],
Cell[4460, 120, 792, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5289, 149, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5666, 163, 148, 5, 70, "ExampleSection",
 CellID->232031125],
Cell[5817, 170, 245, 8, 70, "ExampleText",
 CellID->126110277],
Cell[CellGroupData[{
Cell[6087, 182, 149, 4, 28, "Input",
 CellID->263426191],
Cell[6239, 188, 206, 7, 36, "Output",
 CellID->485120731]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6494, 201, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[6718, 210, 94, 1, 70, "ExampleText",
 CellID->1761645834],
Cell[CellGroupData[{
Cell[6837, 215, 170, 5, 70, "Input",
 CellID->889603525],
Cell[7010, 222, 157, 5, 36, "Output",
 CellID->53899224]
}, Open  ]],
Cell[CellGroupData[{
Cell[7204, 232, 155, 4, 70, "Input",
 CellID->267819435],
Cell[7362, 238, 157, 5, 36, "Output",
 CellID->83229577]
}, Open  ]],
Cell[7534, 246, 126, 3, 70, "ExampleDelimiter",
 CellID->1820791404],
Cell[7663, 251, 240, 7, 70, "ExampleText",
 CellID->1821383950],
Cell[CellGroupData[{
Cell[7928, 262, 303, 10, 70, "Input",
 CellID->161773854],
Cell[8234, 274, 251, 9, 36, "Output",
 CellID->710226046]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8534, 289, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[8764, 298, 296, 10, 70, "ExampleText",
 CellID->919804158],
Cell[CellGroupData[{
Cell[9085, 312, 255, 8, 70, "Input",
 CellID->1220833658],
Cell[9343, 322, 243, 9, 53, "Output",
 CellID->566055716]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9635, 337, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[9876, 346, 97, 1, 70, "ExampleText",
 CellID->107853424],
Cell[CellGroupData[{
Cell[9998, 351, 338, 11, 70, "Input",
 CellID->1430613057],
Cell[10339, 364, 207, 7, 36, "Output",
 CellID->246977521]
}, Open  ]],
Cell[CellGroupData[{
Cell[10583, 376, 133, 4, 70, "Input",
 CellID->310620327],
Cell[10719, 382, 159, 5, 36, "Output",
 CellID->245111008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10927, 393, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[11161, 402, 122, 3, 70, "ExampleText",
 CellID->865002216],
Cell[CellGroupData[{
Cell[11308, 409, 207, 6, 70, "Input",
 CellID->1487876314],
Cell[11518, 417, 248, 5, 70, "Message",
 CellID->56896230],
Cell[11769, 424, 302, 11, 49, "Output",
 CellID->265097]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12132, 442, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12451, 453, 509, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12997, 475, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[13318, 486, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[13553, 495, 319, 9, 70, "MoreAboutSection",
 CellID->465520745],
Cell[13875, 506, 155, 3, 70, "MoreAbout",
 CellID->44727649],
Cell[14033, 511, 198, 4, 70, "MoreAbout",
 CellID->119135406]
}, Open  ]],
Cell[14246, 518, 27, 0, 70, "History"],
Cell[14276, 520, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

