(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27048,        963]
NotebookOptionsPosition[     21454,        773]
NotebookOutlinePosition[     22786,        811]
CellTagsIndexPosition[     22701,        806]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberFieldIntegralBasis" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldIntegralBasis"], 
          "NumberFieldClassNumber" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldClassNumber"], 
          "AlgebraicNumberTrace" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumberTrace"], 
          "NumberFieldSignature" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldSignature"], 
          "NumberFieldRegulator" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRegulator"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"NumberFieldIntegralBasis\"\>", 
       2->"\<\"NumberFieldClassNumber\"\>", 3->"\<\"AlgebraicNumberTrace\"\>",
        4->"\<\"NumberFieldSignature\"\>", 
       5->"\<\"NumberFieldRegulator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Number Theory\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"New in 6.0: Symbolic Computation\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldDiscriminant", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldDiscriminant",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldDiscriminant"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the discriminant of the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"],
     " generated by the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For a number field with integral basis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " the discriminant is the determinant of the matrix of traces of products ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "i"], " ", 
    SubscriptBox["a", "j"]}], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->20912],

Cell["The discriminant of a number field is always an integer.", "Notes",
 CellID->222880640]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106955453],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->243750043],

Cell[TextData[{
 "Find the discriminant of the number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1684937216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92599118],

Cell[BoxData["2304"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578615209]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Radical expressions:", "ExampleText",
 CellID->693594686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"3", "+", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704651686],

Cell[BoxData["7168"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->979864047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403282186],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->505310170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"#", "^", "3"}]}], "-", "#", "+", "1"}], "&"}], ",", "2"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1597686952],

Cell[BoxData[
 RowBox[{"-", "4"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1670432733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1431317199],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->36349899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "+", "#", "+", "1"}], "&"}], ",", "3"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1047396745],

Cell[BoxData[
 RowBox[{"-", "31"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->909226300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148007755],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldDiscriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->367263992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}], ",", " ", 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "4"}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1963380777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", 
   RowBox[{"-", "108"}], ",", 
   RowBox[{"-", "2048"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2020275695]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Rational primes that ramify in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RadicalBox["2", "3"], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1751896394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Divisors", "[", 
    RowBox[{"NumberFieldDiscriminant", "[", 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}]}], "]"}], "]"}], ",", " ", "PrimeQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1676737605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->909663148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1917101039],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalZ]", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}]}], "]"}], TraditionalForm]], "InlineMath"],
 " is  the ring of integers of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    SqrtBox["5"], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->734425591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberFieldDiscriminant", "[", 
   RowBox[{"Sqrt", "[", "5", "]"}], "]"}], " ", "==", 
  RowBox[{"Discriminant", "[", 
   RowBox[{
    RowBox[{"MinimalPolynomial", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Sqrt", "[", "5", "]"}]}], ")"}], "/", "2"}], ",", "x"}], 
     "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1130598189],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772445443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberFieldIntegralBasis", "[", 
   RowBox[{"Sqrt", "[", "5", "]"}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194452904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     SqrtBox["5"], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->951914386]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 " Find the discriminant of the number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], ",", "\[ImaginaryI]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1510764384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{
   RowBox[{"ToNumberField", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], ",", "I"}], "}"}], ",", " ", "All"}], 
    "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->742722939],

Cell[BoxData["256"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71915352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1887146521],

Cell[TextData[{
 "The discriminant of a number field is always congruent to ",
 Cell[BoxData[
  RowBox[{"0", " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData["1"], "InlineFormula"],
 " modulo ",
 Cell[BoxData["4"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->911642727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell["", "InlineFormula"], 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"NumberFieldDiscriminant", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", 
       RowBox[{"Range", "[", "20", "]"}]}], "]"}], "]"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1477105785],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
   ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
   "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1795511450]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldIntegralBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldIntegralBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldClassNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldClassNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumberTrace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberTrace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldSignature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldSignature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRegulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRegulator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->70142185],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->656429341],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->39080431],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->81347763],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->81511602],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->267148251],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->484381692]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldDiscriminant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 8.2977858}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldDiscriminant[a] gives the discriminant of the field \
\\[DoubleStruckCapitalQ][a] generated by the algebraic number a.", 
    "synonyms" -> {"number field discriminant"}, "title" -> 
    "NumberFieldDiscriminant", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldDiscriminant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7584, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->106955453]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22558, 799}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3331, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3954, 101, 1588, 37, 70, "ObjectNameGrid"],
Cell[5545, 140, 773, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6355, 168, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6833, 185, 618, 21, 70, "Notes",
 CellID->20912],
Cell[7454, 208, 93, 1, 70, "Notes",
 CellID->222880640]
}, Closed]],
Cell[CellGroupData[{
Cell[7584, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106955453],
Cell[CellGroupData[{
Cell[7969, 228, 148, 5, 70, "ExampleSection",
 CellID->243750043],
Cell[8120, 235, 277, 10, 70, "ExampleText",
 CellID->1684937216],
Cell[CellGroupData[{
Cell[8422, 249, 205, 6, 28, "Input",
 CellID->92599118],
Cell[8630, 257, 161, 5, 36, "Output",
 CellID->578615209]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8840, 268, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9064, 277, 63, 1, 70, "ExampleText",
 CellID->693594686],
Cell[CellGroupData[{
Cell[9152, 282, 207, 6, 70, "Input",
 CellID->704651686],
Cell[9362, 290, 161, 5, 36, "Output",
 CellID->979864047]
}, Open  ]],
Cell[9538, 298, 125, 3, 70, "ExampleDelimiter",
 CellID->403282186],
Cell[9666, 303, 178, 7, 70, "ExampleText",
 CellID->505310170],
Cell[CellGroupData[{
Cell[9869, 314, 285, 10, 70, "Input",
 CellID->1597686952],
Cell[10157, 326, 176, 6, 36, "Output",
 CellID->1670432733]
}, Open  ]],
Cell[10348, 335, 126, 3, 70, "ExampleDelimiter",
 CellID->1431317199],
Cell[10477, 340, 199, 7, 70, "ExampleText",
 CellID->36349899],
Cell[CellGroupData[{
Cell[10701, 351, 401, 13, 70, "Input",
 CellID->1047396745],
Cell[11105, 366, 176, 6, 36, "Output",
 CellID->909226300]
}, Open  ]],
Cell[11296, 375, 125, 3, 70, "ExampleDelimiter",
 CellID->148007755],
Cell[11424, 380, 241, 7, 70, "ExampleText",
 CellID->367263992],
Cell[CellGroupData[{
Cell[11690, 391, 376, 12, 70, "Input",
 CellID->1963380777],
Cell[12069, 405, 306, 11, 36, "Output",
 CellID->2020275695]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12424, 422, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[12654, 431, 233, 8, 70, "ExampleText",
 CellID->1751896394],
Cell[CellGroupData[{
Cell[12912, 443, 308, 10, 70, "Input",
 CellID->1676737605],
Cell[13223, 455, 251, 9, 36, "Output",
 CellID->909663148]
}, Open  ]],
Cell[13489, 467, 126, 3, 70, "ExampleDelimiter",
 CellID->1917101039],
Cell[13618, 472, 472, 17, 70, "ExampleText",
 CellID->734425591],
Cell[CellGroupData[{
Cell[14115, 493, 444, 14, 70, "Input",
 CellID->1130598189],
Cell[14562, 509, 209, 7, 36, "Output",
 CellID->772445443]
}, Open  ]],
Cell[CellGroupData[{
Cell[14808, 521, 170, 5, 70, "Input",
 CellID->194452904],
Cell[14981, 528, 440, 16, 51, "Output",
 CellID->951914386]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15470, 550, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[15711, 559, 278, 10, 70, "ExampleText",
 CellID->1510764384],
Cell[CellGroupData[{
Cell[16014, 573, 363, 12, 70, "Input",
 CellID->742722939],
Cell[16380, 587, 207, 7, 36, "Output",
 CellID->71915352]
}, Open  ]],
Cell[16602, 597, 126, 3, 70, "ExampleDelimiter",
 CellID->1887146521],
Cell[16731, 602, 275, 10, 70, "ExampleText",
 CellID->911642727],
Cell[CellGroupData[{
Cell[17031, 616, 314, 10, 70, "Input",
 CellID->1477105785],
Cell[17348, 628, 444, 12, 36, "Output",
 CellID->1795511450]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17853, 647, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18172, 658, 1322, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19531, 707, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19852, 718, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[20048, 726, 318, 9, 70, "MoreAboutSection",
 CellID->70142185],
Cell[20369, 737, 156, 3, 70, "MoreAbout",
 CellID->656429341],
Cell[20528, 742, 161, 3, 70, "MoreAbout",
 CellID->39080431],
Cell[20692, 747, 136, 3, 70, "MoreAbout",
 CellID->81347763],
Cell[20831, 752, 168, 3, 70, "MoreAbout",
 CellID->81511602],
Cell[21002, 757, 179, 3, 70, "MoreAbout",
 CellID->267148251],
Cell[21184, 762, 198, 4, 70, "MoreAbout",
 CellID->484381692]
}, Open  ]],
Cell[21397, 769, 27, 0, 70, "History"],
Cell[21427, 771, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

