(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31390,       1116]
NotebookOptionsPosition[     25770,        926]
NotebookOutlinePosition[     27164,        964]
CellTagsIndexPosition[     27079,        959]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberFieldFundamentalUnits" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldFundamentalUnits"], 
          "AlgebraicIntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicIntegerQ"], 
          "NumberFieldRootsOfUnity" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRootsOfUnity"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"NumberFieldFundamentalUnits\"\>", 
       2->"\<\"AlgebraicIntegerQ\"\>", 
       3->"\<\"NumberFieldRootsOfUnity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Number Theory\"\>", 
       2->"\<\"Number Theory\"\>", 
       3->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldIntegralBasis", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldIntegralBasis",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldIntegralBasis"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an integral basis for the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"],
     " generated by the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldIntegralBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFormula"],
 " gives a list of algebraic integers generating the module of integers in \
the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The basis produced by ",
 Cell[BoxData[
  ButtonBox["NumberFieldIntegralBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFormula"],
 " may not be unique."
}], "Notes",
 CellID->22646481]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137002005],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->214775572],

Cell[TextData[{
 "Find an integral basis for the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RadicalBox["2", "3"], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->45785423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"2", "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "3"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320487291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{342, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430566336]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1056549],

Cell["Radical objects:", "ExampleText",
 CellID->1156168886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485657585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "0", ",", 
       FractionBox["1", "2"], ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "4"], ",", 
       FractionBox["3", "4"], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "4"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{401, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1656002409]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2113958255],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1326935817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"3", 
       RowBox[{"#1", "^", "3"}]}]}], "&"}], ",", "2"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->192602224],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"18", "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"18", "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox["1", "3"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{341, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1044422943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->958528747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1717814682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "10"}], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", 
      RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541210106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "127"}], "+", 
         RowBox[{"27", " ", "#1"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "127"}], "+", 
         RowBox[{"27", " ", "#1"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["19", "30"], ",", 
       FractionBox["2", "15"], ",", 
       FractionBox["1", "30"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{457, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85072423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->566868134],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldIntegralBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFormula"],
 " threads over lists:"
}], "ExampleText",
 CellID->1115270046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"Sqrt", "[", "5", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1106392106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       SqrtBox["2"], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       SqrtBox["5"], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{489, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1735588106]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->224836661],

Cell["Elements of an integral basis are all algebraic integers:", \
"ExampleText",
 CellID->20416240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"E", "^", 
   RowBox[{"(", 
    RowBox[{"I", " ", 
     RowBox[{"Pi", "/", "4"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1685845807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{352, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758920341]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", " ", "/@", " ", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1295386027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1268791654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1681788559],

Cell["\<\
Algebraic integers are linear combinations of elements of the integral basis:\
\
\>", "ExampleText",
 CellID->640549299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"basis", " ", "=", " ", 
  RowBox[{"NumberFieldIntegralBasis", "[", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"2", "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376545882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{394, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68714068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"basis", ".", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "2", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2119814712],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", "2", ",", "3"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{370, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1678622437]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->976099110],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1114628020]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189064311],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " to find an integral basis for the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], ",", "\[ImaginaryI]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1241171774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"primitive", "=", 
  RowBox[{
   RowBox[{"ToNumberField", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], ",", "I"}], "}"}], ",", "All"}], 
    "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135311350],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"9", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{156, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1053279359]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", "primitive", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1186298791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "0", ",", 
       FractionBox["1", "2"], ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "4"], ",", 
       FractionBox["7", "12"], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{407, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->758484492]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldFundamentalUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldFundamentalUnits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicIntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicIntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRootsOfUnity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRootsOfUnity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->92275050],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->276371317],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->269438229],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->272683152]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldIntegralBasis - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 9.4540654}", "context" -> "System`", 
    "keywords" -> {"integral basis", "number field", "number field basis"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldIntegralBasis[a] gives an integral basis for the field \
\\[DoubleStruckCapitalQ][a] generated by the algebraic number a.", 
    "synonyms" -> {"number field integral basis"}, "title" -> 
    "NumberFieldIntegralBasis", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldIntegralBasis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6692, 199, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->137002005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26936, 952}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2484, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3107, 87, 1589, 37, 70, "ObjectNameGrid"],
Cell[4699, 126, 777, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5513, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5991, 171, 413, 13, 70, "Notes",
 CellID->1067943069],
Cell[6407, 186, 248, 8, 70, "Notes",
 CellID->22646481]
}, Closed]],
Cell[CellGroupData[{
Cell[6692, 199, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137002005],
Cell[CellGroupData[{
Cell[7077, 213, 148, 5, 70, "ExampleSection",
 CellID->214775572],
Cell[7228, 220, 237, 8, 70, "ExampleText",
 CellID->45785423],
Cell[CellGroupData[{
Cell[7490, 232, 192, 6, 28, "Input",
 CellID->320487291],
Cell[7685, 240, 816, 27, 58, "Output",
 CellID->430566336]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8550, 273, 218, 7, 70, "ExampleSection",
 CellID->1056549],
Cell[8771, 282, 60, 1, 70, "ExampleText",
 CellID->1156168886],
Cell[CellGroupData[{
Cell[8856, 287, 207, 6, 70, "Input",
 CellID->485657585],
Cell[9066, 295, 1461, 46, 103, "Output",
 CellID->1656002409]
}, Open  ]],
Cell[10542, 344, 126, 3, 70, "ExampleDelimiter",
 CellID->2113958255],
Cell[10671, 349, 179, 7, 70, "ExampleText",
 CellID->1326935817],
Cell[CellGroupData[{
Cell[10875, 360, 274, 10, 70, "Input",
 CellID->192602224],
Cell[11152, 372, 795, 26, 73, "Output",
 CellID->1044422943]
}, Open  ]],
Cell[11962, 401, 125, 3, 70, "ExampleDelimiter",
 CellID->958528747],
Cell[12090, 406, 201, 7, 70, "ExampleText",
 CellID->1717814682],
Cell[CellGroupData[{
Cell[12316, 417, 439, 14, 70, "Input",
 CellID->541210106],
Cell[12758, 433, 1131, 36, 73, "Output",
 CellID->85072423]
}, Open  ]],
Cell[13904, 472, 125, 3, 70, "ExampleDelimiter",
 CellID->566868134],
Cell[14032, 477, 230, 7, 70, "ExampleText",
 CellID->1115270046],
Cell[CellGroupData[{
Cell[14287, 488, 234, 7, 70, "Input",
 CellID->1106392106],
Cell[14524, 497, 653, 24, 51, "Output",
 CellID->1735588106]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15226, 527, 237, 7, 70, "ExampleSection",
 CellID->224836661],
Cell[15466, 536, 101, 2, 70, "ExampleText",
 CellID->20416240],
Cell[CellGroupData[{
Cell[15592, 542, 220, 7, 70, "Input",
 CellID->1685845807],
Cell[15815, 551, 1085, 35, 77, "Output",
 CellID->758920341]
}, Open  ]],
Cell[CellGroupData[{
Cell[16937, 591, 120, 3, 70, "Input",
 CellID->1295386027],
Cell[17060, 596, 237, 7, 36, "Output",
 CellID->1268791654]
}, Open  ]],
Cell[17312, 606, 126, 3, 70, "ExampleDelimiter",
 CellID->1681788559],
Cell[17441, 611, 130, 4, 70, "ExampleText",
 CellID->640549299],
Cell[CellGroupData[{
Cell[17596, 619, 248, 7, 70, "Input",
 CellID->376545882],
Cell[17847, 628, 1303, 41, 77, "Output",
 CellID->68714068]
}, Open  ]],
Cell[CellGroupData[{
Cell[19187, 674, 184, 6, 70, "Input",
 CellID->2119814712],
Cell[19374, 682, 521, 18, 39, "Output",
 CellID->1678622437]
}, Open  ]],
Cell[CellGroupData[{
Cell[19932, 705, 113, 3, 70, "Input",
 CellID->976099110],
Cell[20048, 710, 162, 5, 36, "Output",
 CellID->1114628020]
}, Open  ]],
Cell[20225, 718, 125, 3, 70, "ExampleDelimiter",
 CellID->189064311],
Cell[20353, 723, 414, 15, 70, "ExampleText",
 CellID->1241171774],
Cell[CellGroupData[{
Cell[20792, 742, 339, 12, 70, "Input",
 CellID->135311350],
Cell[21134, 756, 350, 12, 39, "Output",
 CellID->1053279359]
}, Open  ]],
Cell[CellGroupData[{
Cell[21521, 773, 129, 3, 70, "Input",
 CellID->1186298791],
Cell[21653, 778, 1507, 48, 103, "Output",
 CellID->758484492]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23221, 833, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[23540, 844, 786, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24363, 875, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[24684, 886, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[24880, 894, 318, 9, 70, "MoreAboutSection",
 CellID->92275050],
Cell[25201, 905, 156, 3, 70, "MoreAbout",
 CellID->276371317],
Cell[25360, 910, 137, 3, 70, "MoreAbout",
 CellID->269438229],
Cell[25500, 915, 198, 4, 70, "MoreAbout",
 CellID->272683152]
}, Open  ]],
Cell[25713, 922, 27, 0, 70, "History"],
Cell[25743, 924, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

