(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27927,       1033]
NotebookOptionsPosition[     22768,        856]
NotebookOutlinePosition[     24075,        894]
CellTagsIndexPosition[     23990,        889]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberFieldSignature" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldSignature"], 
          "NumberFieldDiscriminant" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldDiscriminant"], 
          "NumberFieldClassNumber" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldClassNumber"], 
          "NumberFieldFundamentalUnits" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldFundamentalUnits"], 
          "NumberFieldRootsOfUnity" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRootsOfUnity"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NumberFieldSignature\"\>", 
       2->"\<\"NumberFieldDiscriminant\"\>", 
       3->"\<\"NumberFieldClassNumber\"\>", 
       4->"\<\"NumberFieldFundamentalUnits\"\>", 
       5->"\<\"NumberFieldRootsOfUnity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldRegulator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldRegulator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldRegulator"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the regulator of the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"],
     " generated by the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->488727595],

Cell[TextData[{
 "Find the regulator of the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], "+", "\[ImaginaryI]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1020385064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307742140],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SqrtBox["2"]}], "]"}]}]], "Output",
 ImageSize->{108, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->962250587]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->83692572],

Cell["Radical objects:", "ExampleText",
 CellID->1156168886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619221969],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"2", "-", 
     SqrtBox["3"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "-", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"2", "-", 
     SqrtBox["3"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "-", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"2", "+", 
     SqrtBox["3"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "-", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"2", "-", 
     SqrtBox["3"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"2", "+", 
     SqrtBox["3"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{573, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1993753799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2113958255],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1326935817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"3", 
       RowBox[{"#1", "^", "3"}]}]}], "&"}], ",", "2"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->192602224],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"55", "+", 
   RowBox[{"24", " ", 
    SuperscriptBox["2", 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{"21", " ", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"2", "/", "3"}]]}]}], "]"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1832755652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->958528747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1717814682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "10"}], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", 
      RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541210106],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   FractionBox["23", "3"], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["10", 
      RowBox[{"1", "/", "3"}]]}], "3"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["10", 
      RowBox[{"2", "/", "3"}]]}], "3"]}], "]"}]], "Output",
 ImageSize->{177, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1766294243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->372894549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldRegulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRegulator"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->118079070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"Pi", "*", 
       RowBox[{"I", "/", "4"}]}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58697740],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["1", 
          SqrtBox["2"]]}], ")"}], "2"], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}]}]}], "]"}]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{312, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1440889620]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->226014174],

Cell["\<\
Find the volume of the fundamental domain of the lattice generated by \
fundamental units:\
\>", "ExampleText",
 CellID->409951936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumberFieldRegulator", "[", "#", "]"}], 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"NumberFieldFundamentalUnits", "[", "#", "]"}], "]"}], "+", 
      "1"}], "]"}]}], "&"}], "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1651409102],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "-", 
       SqrtBox["3"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "-", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "-", 
       SqrtBox["3"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "-", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "+", 
       SqrtBox["3"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "-", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "-", 
       SqrtBox["3"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "+", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "+", 
       SqrtBox["3"]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"5", "+", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]}], "]"}]}]}], ")"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{584, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2006239768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40139863],

Cell[BoxData["5.3217971603807275`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1231039229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1439681700],

Cell[TextData[{
 "The Dirichlet L-functions at ",
 Cell[BoxData["1"], "InlineFormula"],
 " for the real primitive character ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "13"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->919804158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"NumberFieldClassNumber", "[", 
   RowBox[{"Sqrt", "[", "13", "]"}], "]"}], 
  RowBox[{
   RowBox[{"NumberFieldRegulator", "[", 
    RowBox[{"Sqrt", "[", "13", "]"}], "]"}], "/", 
   RowBox[{"Sqrt", "[", "13", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1220833658],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       SqrtBox["13"]}], ")"}]}], "]"}]}], 
  SqrtBox["13"]]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{131, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1218866605]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->278165451],

Cell[TextData[{
 "The regulator of an imaginary quadratic field is ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->334543825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"-", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565878929],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644521502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1453393788],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " to find the regulator of the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], ",", 
     SqrtBox[
      RowBox[{"-", "5"}]]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1561639889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"primitive", "=", 
  RowBox[{
   RowBox[{"ToNumberField", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"-", "5"}], "]"}]}], "}"}], ",", " ", "All"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280461458],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"49", "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565368646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", "primitive", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190083454],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}], "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{93, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1683178994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldSignature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldSignature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldDiscriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldDiscriminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldClassNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldClassNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldFundamentalUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldFundamentalUnits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRootsOfUnity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRootsOfUnity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->489467637],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->472075734]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldRegulator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 10.8916022}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldRegulator[a] gives the regulator of the field \
\\[DoubleStruckCapitalQ][a] generated by the algebraic number a.", 
    "synonyms" -> {"number field regulator"}, "title" -> 
    "NumberFieldRegulator", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldRegulator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5457, 152, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23855, 882}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2445, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3068, 85, 1585, 37, 70, "ObjectNameGrid"],
Cell[4656, 124, 764, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5457, 152, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5834, 166, 148, 5, 70, "ExampleSection",
 CellID->488727595],
Cell[5985, 173, 267, 10, 70, "ExampleText",
 CellID->1020385064],
Cell[CellGroupData[{
Cell[6277, 187, 171, 5, 28, "Input",
 CellID->307742140],
Cell[6451, 194, 287, 11, 43, "Output",
 CellID->962250587]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6787, 211, 219, 7, 70, "ExampleSection",
 CellID->83692572],
Cell[7009, 220, 60, 1, 70, "ExampleText",
 CellID->1156168886],
Cell[CellGroupData[{
Cell[7094, 225, 203, 6, 70, "Input",
 CellID->619221969],
Cell[7300, 233, 1820, 70, 111, "Output",
 CellID->1993753799]
}, Open  ]],
Cell[9135, 306, 126, 3, 70, "ExampleDelimiter",
 CellID->2113958255],
Cell[9264, 311, 179, 7, 70, "ExampleText",
 CellID->1326935817],
Cell[CellGroupData[{
Cell[9468, 322, 270, 10, 70, "Input",
 CellID->192602224],
Cell[9741, 334, 501, 17, 39, "Output",
 CellID->1832755652]
}, Open  ]],
Cell[10257, 354, 125, 3, 70, "ExampleDelimiter",
 CellID->958528747],
Cell[10385, 359, 201, 7, 70, "ExampleText",
 CellID->1717814682],
Cell[CellGroupData[{
Cell[10611, 370, 435, 14, 70, "Input",
 CellID->541210106],
Cell[11049, 386, 450, 16, 54, "Output",
 CellID->1766294243]
}, Open  ]],
Cell[11514, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->372894549],
Cell[11642, 410, 235, 7, 70, "ExampleText",
 CellID->118079070],
Cell[CellGroupData[{
Cell[11902, 421, 302, 10, 70, "Input",
 CellID->58697740],
Cell[12207, 433, 694, 26, 59, "Output",
 CellID->1440889620]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12950, 465, 227, 7, 70, "ExampleSection",
 CellID->226014174],
Cell[13180, 474, 141, 4, 70, "ExampleText",
 CellID->409951936],
Cell[CellGroupData[{
Cell[13346, 482, 433, 14, 70, "Input",
 CellID->1651409102],
Cell[13782, 498, 2043, 74, 111, "Output",
 CellID->2006239768]
}, Open  ]],
Cell[CellGroupData[{
Cell[15862, 577, 96, 3, 70, "Input",
 CellID->40139863],
Cell[15961, 582, 177, 5, 36, "Output",
 CellID->1231039229]
}, Open  ]],
Cell[16153, 590, 126, 3, 70, "ExampleDelimiter",
 CellID->1439681700],
Cell[16282, 595, 301, 11, 70, "ExampleText",
 CellID->919804158],
Cell[CellGroupData[{
Cell[16608, 610, 313, 9, 70, "Input",
 CellID->1220833658],
Cell[16924, 621, 415, 16, 65, "Output",
 CellID->1218866605]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17388, 643, 237, 7, 70, "ExampleSection",
 CellID->278165451],
Cell[17628, 652, 151, 5, 70, "ExampleText",
 CellID->334543825],
Cell[CellGroupData[{
Cell[17804, 661, 166, 5, 70, "Input",
 CellID->565878929],
Cell[17973, 668, 158, 5, 36, "Output",
 CellID->644521502]
}, Open  ]],
Cell[18146, 676, 126, 3, 70, "ExampleDelimiter",
 CellID->1453393788],
Cell[18275, 681, 431, 16, 70, "ExampleText",
 CellID->1561639889],
Cell[CellGroupData[{
Cell[18731, 701, 399, 13, 70, "Input",
 CellID->280461458],
Cell[19133, 716, 350, 12, 39, "Output",
 CellID->565368646]
}, Open  ]],
Cell[CellGroupData[{
Cell[19520, 733, 124, 3, 70, "Input",
 CellID->190083454],
Cell[19647, 738, 297, 11, 43, "Output",
 CellID->1683178994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20005, 756, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[20324, 767, 1340, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[21701, 816, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[22022, 827, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[22218, 835, 319, 9, 70, "MoreAboutSection",
 CellID->489467637],
Cell[22540, 846, 156, 3, 70, "MoreAbout",
 CellID->472075734]
}, Open  ]],
Cell[22711, 852, 27, 0, 70, "History"],
Cell[22741, 854, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

