(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20827,        694]
NotebookOptionsPosition[     17102,        571]
NotebookOutlinePosition[     18435,        609]
CellTagsIndexPosition[     18350,        604]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScientificForm" :> 
          Documentation`HelpLookup["paclet:ref/ScientificForm"], 
          "EngineeringForm" :> 
          Documentation`HelpLookup["paclet:ref/EngineeringForm"], 
          "AccountingForm" :> 
          Documentation`HelpLookup["paclet:ref/AccountingForm"], "BaseForm" :> 
          Documentation`HelpLookup["paclet:ref/BaseForm"], "PaddedForm" :> 
          Documentation`HelpLookup["paclet:ref/PaddedForm"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "NumberMarks" :> 
          Documentation`HelpLookup["paclet:ref/NumberMarks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ScientificForm\"\>", 
       2->"\<\"EngineeringForm\"\>", 3->"\<\"AccountingForm\"\>", 
       4->"\<\"BaseForm\"\>", 5->"\<\"PaddedForm\"\>", 6->"\<\"N\"\>", 
       7->"\<\"NumberMarks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"], "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Display of Numbers\"\>", 
       2->"\<\"Locale & Internationalization\"\>", 
       3->"\<\"Mathematical Typesetting\"\>", 
       4->"\<\"Math Typesetting Options & Tweaking\"\>", 
       5->"\<\"Number Digits\"\>", 
       6->"\<\"Numerical Evaluation & Precision\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberForm", "ObjectName",
 CellID->15629],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with approximate real numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " given to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["f", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " prints with approximate real numbers having ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " digits, with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " digits to the right of the decimal point. "
}], "Notes",
 CellID->13918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 " works on integers as well as approximate real numbers. "
}], "Notes",
 CellID->7556],

Cell["The following options can be given: ", "Notes",
 CellID->29110],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DigitBlock",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitBlock"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "number of digits between breaks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to apply to exponents ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentStep",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentStep"], "1", Cell[
    "steps by which exponents can increase", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberFormat"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function used to assemble mantissa, base, exponent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberMultiplier",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMultiplier"], "\"\<\[Times]\>\"", Cell[
    "string to use to indicate multiplication ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPadding"], 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}], Cell[
    "strings to use for left and right padding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPoint"], "\"\<.\>\"", Cell[
    "decimal point string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSeparator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSeparator"], 
    RowBox[{"{", 
     RowBox[{"\"\<,\>\"", ",", " ", "\"\< \>\""}], "}"}], Cell[
    "string to insert at breaks between blocks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSigns",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSigns"], 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SignPadding"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to insert padding after the sign ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->20002],

Cell[TextData[{
 "All options except ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExponentStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentStep"]], "InlineFormula"],
 " apply to integers as well as approximate real numbers. "
}], "Notes",
 CellID->3080],

Cell[TextData[{
 "You can mix ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->109346987]
}], "Notes",
 CellID->32326],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->29547]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->582162684],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->34904611],

Cell[TextData[{
 "Display the first 10 digits of a numeric approximation to ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->310837198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"N", "[", "Pi", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182688219],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"3.141592654\"\>",
   3.141592653589793,
   AutoDelete->True],
  NumberForm[#, 10]& ]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->13311662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->629919901],

Cell["\<\
Display a number with 3 precise digits and 4 digits to the right of the \
decimal:\
\>", "ExampleText",
 CellID->114750236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"1.23456", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145863617],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"1.2300\"\>",
   1.23456,
   AutoDelete->True],
  NumberForm[#, {3, 4}]& ]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->258946680]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9332],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScientificForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScientificForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EngineeringForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EngineeringForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccountingForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccountingForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaddedForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaddedForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberMarks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberMarks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30647]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->333],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->23779]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with NumberForm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=NumberForm"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->146984590],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->45121595],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->152035078],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->755794206],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->305362979],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->426073204],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->297050402]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 16.3292414}", "context" -> "System`", 
    "keywords" -> {
     "number formatting", "numeric formatting", "number output", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberForm[expr, n] prints with approximate real numbers in expr given \
to n-digit precision. ", "synonyms" -> {"number form"}, "title" -> 
    "NumberForm", "type" -> "Symbol", "uri" -> "ref/NumberForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10407, 312, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->582162684]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18206, 597}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3307, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3930, 100, 48, 1, 70, "ObjectName",
 CellID->15629],
Cell[3981, 103, 729, 23, 70, "Usage",
 CellID->7728]
}, Open  ]],
Cell[CellGroupData[{
Cell[4747, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5225, 148, 597, 21, 70, "Notes",
 CellID->13918],
Cell[5825, 171, 226, 7, 70, "Notes",
 CellID->7556],
Cell[6054, 180, 69, 1, 70, "Notes",
 CellID->29110],
Cell[6126, 183, 3191, 82, 70, "3ColumnTableMod",
 CellID->20002],
Cell[9320, 267, 399, 13, 70, "Notes",
 CellID->3080],
Cell[9722, 282, 406, 16, 70, "Notes",
 CellID->32326],
Cell[10131, 300, 239, 7, 70, "Notes",
 CellID->29547]
}, Closed]],
Cell[CellGroupData[{
Cell[10407, 312, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->582162684],
Cell[CellGroupData[{
Cell[10792, 326, 147, 5, 70, "ExampleSection",
 CellID->34904611],
Cell[10942, 333, 183, 6, 70, "ExampleText",
 CellID->310837198],
Cell[CellGroupData[{
Cell[11150, 343, 160, 5, 28, "Input",
 CellID->182688219],
Cell[11313, 350, 285, 10, 50, "Output",
 CellID->13311662]
}, Open  ]],
Cell[11613, 363, 125, 3, 70, "ExampleDelimiter",
 CellID->629919901],
Cell[11741, 368, 133, 4, 70, "ExampleText",
 CellID->114750236],
Cell[CellGroupData[{
Cell[11899, 376, 184, 6, 70, "Input",
 CellID->145863617],
Cell[12086, 384, 275, 10, 50, "Output",
 CellID->258946680]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12422, 401, 310, 9, 70, "SeeAlsoSection",
 CellID->9332],
Cell[12735, 412, 1710, 62, 70, "SeeAlso",
 CellID->30647]
}, Open  ]],
Cell[CellGroupData[{
Cell[14482, 479, 312, 9, 70, "TutorialsSection",
 CellID->333],
Cell[14797, 490, 160, 3, 70, "Tutorials",
 CellID->23779]
}, Open  ]],
Cell[CellGroupData[{
Cell[14994, 498, 305, 8, 70, "RelatedLinksSection"],
Cell[15302, 508, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15704, 525, 319, 9, 70, "MoreAboutSection",
 CellID->146984590],
Cell[16026, 536, 145, 3, 70, "MoreAbout",
 CellID->45121595],
Cell[16174, 541, 170, 3, 70, "MoreAbout",
 CellID->152035078],
Cell[16347, 546, 159, 3, 70, "MoreAbout",
 CellID->755794206],
Cell[16509, 551, 180, 3, 70, "MoreAbout",
 CellID->305362979],
Cell[16692, 556, 137, 3, 70, "MoreAbout",
 CellID->426073204],
Cell[16832, 561, 175, 3, 70, "MoreAbout",
 CellID->297050402]
}, Open  ]],
Cell[17022, 567, 50, 0, 70, "History"],
Cell[17075, 569, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

