(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13256,        474]
NotebookOptionsPosition[      9924,        362]
NotebookOutlinePosition[     11332,        401]
CellTagsIndexPosition[     11247,        396]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExponentFunction" :> 
          Documentation`HelpLookup["paclet:ref/ExponentFunction"], 
          "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExponentFunction\"\>", 
       2->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberFormat", "ObjectName",
 CellID->24856],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberFormat",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberFormat"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which specifies how the mantissa, base and \
exponent should be assembled into a final print form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7165]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"NumberFormat", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is supplied with three arguments: the mantissa, base and exponent of each \
number to be printed. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->263494383]
}], "Notes",
 CellID->26815],

Cell[TextData[{
 "The arguments are all given as strings. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->130040485]
}], "Notes",
 CellID->1622],

Cell[TextData[{
 "When no exponent is to be printed, the third argument is given as ",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23244725]
}], "Notes",
 CellID->28013],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " must return the final format for the number. "
}], "Notes",
 CellID->22086]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78343667],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56418277],

Cell["\<\
Display numbers in a Fortran\[Hyphen]like form:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->263494383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"8.", "^", "5"}], ",", 
    RowBox[{"11.", "^", "7"}], ",", 
    RowBox[{"13.", "^", "9"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555632758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"32768.`", ",", "1.9487171`*^7", ",", "1.0604499373`*^10"}], 
  "}"}]], "Output",
 ImageSize->{249, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68528518]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"v", ",", 
   RowBox[{"NumberFormat", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"#1", ",", "\"\<e\>\"", ",", "#3"}], "}"}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33746969],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1V0tOwzAQdRM7baPSwo4NUu8AZ6BsQFwhqpDaBQKV3raHMXZkN+b5OXEK
VIonM/F8n2fkPjfH3dt7c9xvm/Xm0Hzu9tuv9ePHwYjKiRDiZJ7VrTDv2ry1
z0lrQ6VdS8u3P3EP/Ab4F+DL1koJ0gezFIZ9cvQVvhdUy/KWtVSJODb/XQbU
WleGSrK/cnZKt8/rTR0tHFUkOq/H7A75USROSyvwK5390F8qnrharVSd+XaP
SEgx4jG6YfUwayufE5QKV+VQ3mYlOz6RUV6UEAei0xeXHJE7l1Y8kx+SWVYu
FJcowynVnVFpHAlWGXG5Af4K63s224qi6IZQHPK/BH4+Aom0tPJ9dAEq2H8T
zfoPzx3mrajtPHys2grkte6mRW4lMBOGlSL7/geTRCeFNcueVbxzMD8/C9iM
CFDQ3Zy3m2rqEfHgNeH4lqkYuH4PYvnISG9tRIx8/18iQquQRsbXLfJWu4iv
s+oResk/jfEp8beHvnnZ0yuD6GOc7DwnbwgXIvL7LqZnNtp1l1WnPKTGSLmf
Ed08mNkQaousinO0mDS8U4Z3Zc+Xrtp28i10N30K6PTwzlk7fgl6CuyGdqTT
wztv/P/glFjF5BtAmo/1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//NumberForm=",
 CellID->254529998]
}, Open  ]],

Cell["Display only the mantissas:", "ExampleText",
 CellID->477029130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"v", ",", 
   RowBox[{"NumberFormat", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#1", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->206100651],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"32768.\"\>",
     32768.,
     Editable->False], ",", 
    InterpretationBox["\<\"1.94872\"\>",
     1.9487171*^7,
     Editable->False], ",", 
    InterpretationBox["\<\"1.06045\"\>",
     1.0604499373*^10,
     Editable->False]}], "}"}],
  NumberForm[#, NumberFormat -> (#& )]& ]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//NumberForm=",
 CellID->129388729]
}, Open  ]],

Cell["Display the exponents after converting to scientific form:", \
"ExampleText",
 CellID->302136742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"v", ",", 
   RowBox[{"NumberFormat", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#3", "&"}], ")"}]}], ",", 
   RowBox[{"ExponentFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->185673390],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U00PgjAMHWwjasKHF8ORv8JFT/6IhZjAwWiQ/4/tADXPkqAJJOv23tq+
tWNn19WXq+uayhWn1t3rpnoUx1tLlA6UUiWNNFe07mnlR9n3NBu2mrH/1BZw
CvgAWPssGtgdmZBgNs457IdilCXDEPkNYDxzRMaOcUzbRWqR4MVnxQ6YGd5n
tS/sNb77OWiHQtcivhLgk0UaWF8g1ifHZn8pylWhosfmjddV+/TiqD3sxytq
xWIuvM1fFJGd/jpW4hTJiKc3gv7DOyxnrAqe54AigQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//NumberForm=",
 CellID->389928758]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19356],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExponentFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30649]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26707],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->6033]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFormat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 15.5323460}", "context" -> "System`", 
    "keywords" -> {
     "number formatting", "numeric formatting", "number output", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberFormat is an option for NumberForm and related functions which \
specifies how the mantissa, base and exponent should be assembled into a \
final print form. ", "synonyms" -> {"number format"}, "title" -> 
    "NumberFormat", "type" -> "Symbol", "uri" -> "ref/NumberFormat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4261, 150, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78343667]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11105, 389}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1326, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1949, 61, 50, 1, 70, "ObjectName",
 CellID->24856],
Cell[2002, 64, 677, 19, 70, "Usage",
 CellID->7165]
}, Open  ]],
Cell[CellGroupData[{
Cell[2716, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3194, 105, 426, 14, 70, "Notes",
 CellID->26815],
Cell[3623, 121, 174, 6, 70, "Notes",
 CellID->1622],
Cell[3800, 129, 252, 8, 70, "Notes",
 CellID->28013],
Cell[4055, 139, 169, 6, 70, "Notes",
 CellID->22086]
}, Closed]],
Cell[CellGroupData[{
Cell[4261, 150, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78343667],
Cell[CellGroupData[{
Cell[4645, 164, 147, 5, 70, "ExampleSection",
 CellID->56418277],
Cell[4795, 171, 146, 4, 70, "ExampleText",
 CellID->263494383],
Cell[CellGroupData[{
Cell[4966, 179, 229, 8, 28, "Input",
 CellID->555632758],
Cell[5198, 189, 250, 8, 39, "Output",
 CellID->68528518]
}, Open  ]],
Cell[CellGroupData[{
Cell[5485, 202, 332, 11, 28, "Input",
 CellID->33746969],
Cell[5820, 215, 854, 18, 50, "Output",
 Evaluatable->False,
 CellID->254529998]
}, Open  ]],
Cell[6689, 236, 70, 1, 70, "ExampleText",
 CellID->477029130],
Cell[CellGroupData[{
Cell[6784, 241, 217, 7, 70, "Input",
 CellID->206100651],
Cell[7004, 250, 514, 18, 50, "Output",
 CellID->129388729]
}, Open  ]],
Cell[7533, 271, 103, 2, 70, "ExampleText",
 CellID->302136742],
Cell[CellGroupData[{
Cell[7661, 277, 318, 10, 28, "Input",
 CellID->185673390],
Cell[7982, 289, 511, 12, 50, "Output",
 Evaluatable->False,
 CellID->389928758]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8554, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->19356],
Cell[8868, 319, 471, 17, 70, "SeeAlso",
 CellID->30649]
}, Open  ]],
Cell[CellGroupData[{
Cell[9376, 341, 314, 9, 70, "TutorialsSection",
 CellID->26707],
Cell[9693, 352, 159, 3, 70, "Tutorials",
 CellID->6033]
}, Open  ]],
Cell[9867, 358, 27, 0, 70, "History"],
Cell[9897, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

