(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10919,        394]
NotebookOptionsPosition[      7855,        295]
NotebookOutlinePosition[      9335,        335]
CellTagsIndexPosition[      9251,        330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SignPadding" :> 
          Documentation`HelpLookup["paclet:ref/SignPadding"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SignPadding\"\>", 
       2->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberPadding", "ObjectName",
 CellID->26931],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberPadding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberPadding"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which gives strings to use as padding on the \
left\[Hyphen] and right\[Hyphen]hand sides of numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberPadding", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"sleft\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"sright\", \"TI\"]\)\>\""}], "}"}]}]], "InlineFormula"],
 " specifies strings to use for padding on the left and right. "
}], "Notes",
 CellID->25716],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ", the default setting is ",
 Cell[BoxData[
  RowBox[{"NumberPadding", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18284],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 ", the default setting is ",
 Cell[BoxData[
  RowBox[{"NumberPadding", "->", 
   RowBox[{"{", 
    RowBox[{"\"\< \>\"", ",", "\"\<0\>\""}], "}"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->207164334]
}], "Notes",
 CellID->3269],

Cell["\<\
The strings specified as padding are inserted in place of digits. \
\>", "Notes",
 CellID->21161]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62697999],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->727311781],

Cell["Default format without padding:", "ExampleText",
 CellID->49819505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"1234567.89", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138753121],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1.23456789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"6\"\>"]}],
   1.23456789*^6,
   AutoDelete->True],
  NumberForm[#, 10]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->55630650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305306991],

Cell["Pad with a tab on the left:", "ExampleText",
 CellID->153708253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"1234567.89", ",", "10", ",", 
   RowBox[{"NumberPadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\\t\>\"", ",", "\"\<\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215567583],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"\\t\\t1.23456789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"6\"\>"]}],
   1.23456789*^6,
   AutoDelete->True],
  NumberForm[#, 10, NumberPadding -> {"\t", ""}]& ]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->439999095]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->796],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SignPadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SignPadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23840],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->3968]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberPadding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 19.5949500}", "context" -> "System`", 
    "keywords" -> {
     "AMPL conversion specification", "C format identifiers", "number format",
       "number formatting", "numeric formatting", "number output", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberPadding is an option for NumberForm and related functions which \
gives strings to use as padding on the left- and right-hand sides of numbers. \
", "synonyms" -> {"number padding"}, "title" -> "NumberPadding", "type" -> 
    "Symbol", "uri" -> "ref/NumberPadding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4431, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62697999]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9109, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1300, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1923, 60, 51, 1, 70, "ObjectName",
 CellID->26931],
Cell[1977, 63, 683, 19, 70, "Usage",
 CellID->24258]
}, Open  ]],
Cell[CellGroupData[{
Cell[2697, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3175, 104, 319, 9, 70, "Notes",
 CellID->25716],
Cell[3497, 115, 348, 13, 70, "Notes",
 CellID->18284],
Cell[3848, 130, 436, 16, 70, "Notes",
 CellID->3269],
Cell[4287, 148, 107, 3, 70, "Notes",
 CellID->21161]
}, Closed]],
Cell[CellGroupData[{
Cell[4431, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62697999],
Cell[CellGroupData[{
Cell[4815, 170, 148, 5, 70, "ExampleSection",
 CellID->727311781],
Cell[4966, 177, 73, 1, 70, "ExampleText",
 CellID->49819505],
Cell[CellGroupData[{
Cell[5064, 182, 139, 4, 28, "Input",
 CellID->138753121],
Cell[5206, 188, 347, 12, 50, "Output",
 CellID->55630650]
}, Open  ]],
Cell[5568, 203, 125, 3, 70, "ExampleDelimiter",
 CellID->305306991],
Cell[5696, 208, 70, 1, 70, "ExampleText",
 CellID->153708253],
Cell[CellGroupData[{
Cell[5791, 213, 259, 7, 70, "Input",
 CellID->215567583],
Cell[6053, 222, 383, 12, 50, "Output",
 CellID->439999095]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6497, 241, 309, 9, 70, "SeeAlsoSection",
 CellID->796],
Cell[6809, 252, 461, 17, 70, "SeeAlso",
 CellID->17410]
}, Open  ]],
Cell[CellGroupData[{
Cell[7307, 274, 314, 9, 70, "TutorialsSection",
 CellID->23840],
Cell[7624, 285, 159, 3, 70, "Tutorials",
 CellID->3968]
}, Open  ]],
Cell[7798, 291, 27, 0, 70, "History"],
Cell[7828, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

