(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9788,        346]
NotebookOptionsPosition[      6861,        251]
NotebookOutlinePosition[      8289,        291]
CellTagsIndexPosition[      8205,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Locale & Internationalization\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberPoint", "ObjectName",
 CellID->4606],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberPoint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberPoint"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which gives the string to use as a decimal \
point. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{"NumberPoint", "->", "\"\<.\>\""}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->263067636]
}], "Notes",
 CellID->21271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->703841802],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->127888115],

Cell["The default multiplier is a period:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->263067636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"12345678.9", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172619616],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1.23456789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"7\"\>"]}],
   1.23456789*^7,
   AutoDelete->True],
  NumberForm[#, 10]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->183857075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249544197],

Cell["Use a comma instead:", "ExampleText",
 CellID->65928263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"12345678.9", ",", "10", ",", 
   RowBox[{"NumberPoint", "\[Rule]", "\"\<,\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181529350],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1,23456789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"7\"\>"]}],
   1.23456789*^7,
   AutoDelete->True],
  NumberForm[#, 10, NumberPoint -> ","]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->720396887]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17358],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->12219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->176792999],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->113585990],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->324508701]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberPoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 20.3449692}", "context" -> "System`", 
    "keywords" -> {
     "decimal format", "decimal point", "output of decimal point", 
      "number formatting", "numeric formatting", "number output", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberPoint is an option for NumberForm and related functions which \
gives the string to use as a decimal point. ", "synonyms" -> {"number point"},
     "title" -> "NumberPoint", "type" -> "Symbol", "uri" -> 
    "ref/NumberPoint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3564, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->703841802]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8062, 279}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1472, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2095, 64, 48, 1, 70, "ObjectName",
 CellID->4606],
Cell[2146, 67, 629, 19, 70, "Usage",
 CellID->23220]
}, Open  ]],
Cell[CellGroupData[{
Cell[2812, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3290, 108, 237, 9, 70, "Notes",
 CellID->21271]
}, Closed]],
Cell[CellGroupData[{
Cell[3564, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->703841802],
Cell[CellGroupData[{
Cell[3949, 136, 148, 5, 70, "ExampleSection",
 CellID->127888115],
Cell[4100, 143, 126, 2, 70, "ExampleText",
 CellID->263067636],
Cell[CellGroupData[{
Cell[4251, 149, 139, 4, 28, "Input",
 CellID->172619616],
Cell[4393, 155, 348, 12, 50, "Output",
 CellID->183857075]
}, Open  ]],
Cell[4756, 170, 125, 3, 70, "ExampleDelimiter",
 CellID->249544197],
Cell[4884, 175, 62, 1, 70, "ExampleText",
 CellID->65928263],
Cell[CellGroupData[{
Cell[4971, 180, 197, 5, 70, "Input",
 CellID->181529350],
Cell[5171, 187, 368, 12, 50, "Output",
 CellID->720396887]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5600, 206, 314, 9, 70, "TutorialsSection",
 CellID->17358],
Cell[5917, 217, 160, 3, 70, "Tutorials",
 CellID->12219]
}, Open  ]],
Cell[CellGroupData[{
Cell[6114, 225, 319, 9, 70, "MoreAboutSection",
 CellID->176792999],
Cell[6436, 236, 170, 3, 70, "MoreAbout",
 CellID->113585990],
Cell[6609, 241, 180, 3, 70, "MoreAbout",
 CellID->324508701]
}, Open  ]],
Cell[6804, 247, 27, 0, 70, "History"],
Cell[6834, 249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

