(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44257,       1500]
NotebookOptionsPosition[     36085,       1209]
NotebookOutlinePosition[     37372,       1246]
CellTagsIndexPosition[     37286,       1241]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Numeric Quantities" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericQuantities"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Numeric Quantities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberQ" :> Documentation`HelpLookup["paclet:ref/NumberQ"], 
          "NumericFunction" :> 
          Documentation`HelpLookup["paclet:ref/NumericFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberQ\"\>", 
       2->"\<\"NumericFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumericQ", "ObjectName",
 CellID->24008],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumericQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumericQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a numeric quantity, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An expression is considered a numeric quantity if it is either an explicit \
number or a mathematical constant such as ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ", or is a function that has attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " and all of whose arguments are numeric quantities. "
}], "Notes",
 CellID->3173],

Cell[TextData[{
 "In most cases, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " whenever ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " would yield an explicit number. "
}], "Notes",
 CellID->1575]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->330785213],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->279061441],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " tests whether an object is a numeric quantity:"
}], "ExampleText",
 CellID->716711489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"Sqrt", "[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568774955],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41979935]
}, Open  ]],

Cell[TextData[{
 "In most cases, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " whenever ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " yields an explicit number: "
}], "ExampleText",
 CellID->58398026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"Sqrt", "[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->685738523],

Cell[BoxData["0.9877659459927356`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270523206]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->57247738],

Cell["An object is numeric if all its constituents are numeric:", \
"ExampleText",
 CellID->94268904],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"BesselJ", "[", 
    RowBox[{"2", ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "3", "]"}], "+", "4"}], "]"}], "]"}], " ", "+", 
      " ", "x"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372638323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241606275],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->314591638]
}, Open  ]],

Cell["Some parts of the expression are numeric:", "ExampleText",
 CellID->260545899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"NumericQ", "[", "#", "]"}]}], "}"}], "&"}], ",", 
     RowBox[{"Level", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<e\>\"", ",", "\"\<NumericQ[e]\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->921997923],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0tvFEcQHs941oBtIvESj0OsHBOiCAMHhASXiJxyjpDig4Ui2YfIicMP
CVIOkAgkDIjHXyDKL0nEIQfED8jRaqZnu3Zrv6l+TE/PrK14pN3Z7qnqenTX
V9Uzs99u3t/64cfN+9v3Nte+2d38aWv73i9rd3Z2q65iIcuy/erz9nxW/VbV
r/qzr1R1LvV3odv1kV2vvvKqeducL5lzac53rVy8fQval6C9CO3v5jjqCWhf
6U2K9t96/OiLk97qKKuGptWduTkX5sz7S9OvZY9g7JyNw/tprnNzXpJ0NNpk
9VGYkcaK0kFsBfDrdmH00Vw4A6jPsqEvSUoxlVIw+8nuL8QZyWvTuA8zw9uQ
LVN5eSX/slnLQnVa5H6f4T8maJsLmohtUU47Kt1e9czWCrSLDrLRji9V/MxK
vnN71z9/uLI/UdOZK20jtp4XcV31PiOjhvVftfQ+YU9hRicskDDH72vkOGl8
fRz6h/F5EYBbK8BD+IR05CPyjR2/COVbIVRgr5QFXGsdr9fWOuOpVFMcR8tC
UIzQjvMHRzpoWlg92QKZGr1tMg+PDJ69qR9H8c0HrliqOMi7JwWvkBdyUigb
HygLx+aVBtnQNhIkG9EHl1v4c62lv8JG0Z45FcSJ/kV5ok8aoyCm3Jh6oFH/
ralpPLhw5TM1O8OSdssW3lXL2FKNNsrGaKxl3RRnzlfRn2ZtaR2m2TecUU0c
aTc63yGdg+u5Ctkx/Tdo72U1u5t7Y6Vy7U1eHSaumWjhOIhYxqnH6Jd2N/O9
SrZ7mcmuuCvju7Z57QU2BN/0W/vzvW2ZNavBYSruOLtDK2yyEeuaYWyVKt0N
oOle2brX9kjNp3LcUANUilakGrJik2Y0vkI7i57JUlVRGyKXo2pivedU+jpI
o7u/7sG85atzwrKfrY6xc7vqFbkmGLZOuWB0uWjOf1mpePsitP88pFwcB8dR
3a0Swfzws5pFYwlHqBpZt2o4dI2Bd692BatdbUnfa6J1rkwYbpUvn0bZ462O
5mlRIay1eKtK6+qz3RlJXQVg9SHZkpOfAvO9PZ76yvDocbSCvDY2g4CF1x/k
76tBusfneBxpp3bFtN2coa9FjdBr1NcmvyO91mWpat4RJSLOY17HSArLFpTX
w7kneb1RS8oZdNis3qYXc9gjlSJn+bPMY0GP/rNKsOQe8L92YvX5PVq+HalD
kfahICsNsvrQ8TfBM53R0It0vyoVjWwcpR4oFyohCr0TqQhl5Ku4g/tHpDoI
iCH30vp8pqLwYwlm0hC/FOalA0p0kdIGEUZNOdre59FyyiBvoUZ7wvjp6ige
3U+E612iG6uGGjMj4vi40fMP5YpfXktrVT+IVPR8T76KGr8XqQ5CpMq99Kx4
T3XN/5gJpFWYJtNrqpHBnL4yuhwVySIZeWbWuCQlTfxiNYaSusYvjv+0YVtY
/NIzFs1vj9+DED9HWdEbVf+brPhC6O8STfX95Yjo0XyHMWrIG89VP3vRoBUX
lZGicl+ivWa8LP++Eld0f/tGtKKffWJsPiJZWstDE1nW551U62mqlG9KiPE1
yFsJ0jpN/14Al5Jl6Z/Gc9wb/ik4r6ZJHq0StM7/ZPqNqEfY8+PXKuRZ7wGL
tnTV3xzzGHKKcZUoj+F67mNvhW1px3iUz2Ly2X5tQvrY+dd4Y5l5pUn1t5Lf
rsG7MQtW6xeN9wqIRylGl1ic0nqjc8E0caElaiprhrPX2J8LMzzpM6tj8t2g
9EVHm4wiZiNHPLSwV7bDqVdHmxGVerS2NFHX3Upaff1YJ/13yDGHjTHT2Cj/
m8P2H8tOa9dLZccS3Xym2LsRM+8WTZB/NOmaXHa9h5CrKaIQ8vi1tL27IWv/
mmvN+j8PkhWGtq+MRizzVcenQHWC6d3E//F/qLOFj+GS7ms=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{253, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->24771332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348961774],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " attribute then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 " is numeric when ",
 Cell[BoxData[
  StyleBox["args", "TI"]], "InlineFormula"],
 " are numeric:"
}], "ExampleText",
 CellID->246480166],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NumericFunction"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92581754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Pi", ",", 
    RowBox[{"Sin", "[", 
     RowBox[{"1", "+", "I"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10906446],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559539387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189733729],

Cell["The system symbols that represent numerical constants:", "ExampleText",
 CellID->229804501],

Cell[BoxData[
 RowBox[{
  RowBox[{"ssymb", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], "]"}], ",", 
     "_Symbol"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90761623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constants", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"ssymb", ",", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Attributes", "[", "#", "]"}], ",", "Constant"}], "]"}], 
     "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->414949811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Catalan", ",", "\[Degree]", ",", "\[ExponentialE]", ",", "EulerGamma", ",",
    "Glaisher", ",", "GoldenRatio", ",", "Khinchin", ",", "MachinePrecision", 
   ",", "\[Pi]"}], "}"}]], "Output",
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->903011581]
}, Open  ]],

Cell[TextData[{
 "The system symbols with the ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->321917217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nfuns", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"ssymb", ",", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Attributes", "[", "#", "]"}], ",", "NumericFunction"}], "]"}],
      "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37578381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Abs", ",", "AiryAi", ",", "AiryAiPrime", ",", "AiryAiZero", ",", "AiryBi", 
   ",", "AiryBiPrime", ",", "AiryBiZero", ",", "AppellF1", ",", "ArcCos", ",",
    "ArcCosh", ",", "ArcCot", ",", "ArcCoth", ",", "ArcCsc", ",", "ArcCsch", 
   ",", "ArcSec", ",", "ArcSech", ",", "ArcSin", ",", "ArcSinh", ",", 
   "ArcTan", ",", "ArcTanh", ",", "Arg", ",", "ArithmeticGeometricMean", ",", 
   "BellB", ",", "BesselI", ",", "BesselJ", ",", "BesselJZero", ",", 
   "BesselK", ",", "BesselY", ",", "BesselYZero", ",", "Beta", ",", 
   "BetaRegularized", ",", "Binomial", ",", "CatalanNumber", ",", "Ceiling", 
   ",", "ChebyshevT", ",", "ChebyshevU", ",", "Clip", ",", "Conjugate", ",", 
   "Cos", ",", "Cosh", ",", "CoshIntegral", ",", "CosIntegral", ",", "Cot", 
   ",", "Coth", ",", "Csc", ",", "Csch", ",", "DedekindEta", ",", "Divide", 
   ",", "EllipticE", ",", "EllipticF", ",", "EllipticK", ",", "EllipticNomeQ",
    ",", "EllipticPi", ",", "Erf", ",", "Erfc", ",", "Erfi", ",", "Exp", ",", 
   "ExpIntegralE", ",", "ExpIntegralEi", ",", "Factorial", ",", "Factorial2", 
   ",", "Fibonacci", ",", "Floor", ",", "FractionalPart", ",", "FresnelC", 
   ",", "FresnelS", ",", "Gamma", ",", "GammaRegularized", ",", "GegenbauerC",
    ",", "HankelH1", ",", "HankelH2", ",", "HarmonicNumber", ",", "HermiteH", 
   ",", "Hypergeometric0F1", ",", "Hypergeometric0F1Regularized", ",", 
   "Hypergeometric1F1", ",", "Hypergeometric1F1Regularized", ",", 
   "Hypergeometric2F1", ",", "Hypergeometric2F1Regularized", ",", 
   "HypergeometricU", ",", "Im", ",", "IntegerPart", ",", 
   "InverseBetaRegularized", ",", "InverseEllipticNomeQ", ",", "InverseErf", 
   ",", "InverseErfc", ",", "InverseGammaRegularized", ",", "InverseJacobiCD",
    ",", "InverseJacobiCN", ",", "InverseJacobiCS", ",", "InverseJacobiDC", 
   ",", "InverseJacobiDN", ",", "InverseJacobiDS", ",", "InverseJacobiNC", 
   ",", "InverseJacobiND", ",", "InverseJacobiNS", ",", "InverseJacobiSC", 
   ",", "InverseJacobiSD", ",", "InverseJacobiSN", ",", "JacobiAmplitude", 
   ",", "JacobiCD", ",", "JacobiCN", ",", "JacobiCS", ",", "JacobiDC", ",", 
   "JacobiDN", ",", "JacobiDS", ",", "JacobiNC", ",", "JacobiND", ",", 
   "JacobiNS", ",", "JacobiP", ",", "JacobiSC", ",", "JacobiSD", ",", 
   "JacobiSN", ",", "JacobiZeta", ",", "KelvinBei", ",", "KelvinBer", ",", 
   "KelvinKei", ",", "KelvinKer", ",", "KleinInvariantJ", ",", "LaguerreL", 
   ",", "LerchPhi", ",", "Log", ",", "LogGamma", ",", "LogIntegral", ",", 
   "LucasL", ",", "MathieuC", ",", "MathieuCharacteristicA", ",", 
   "MathieuCharacteristicB", ",", "MathieuCharacteristicExponent", ",", 
   "MathieuCPrime", ",", "MathieuS", ",", "MathieuSPrime", ",", "Max", ",", 
   "Min", ",", "Minus", ",", "Mod", ",", "ModularLambda", ",", "Multinomial", 
   ",", "NevilleThetaC", ",", "NevilleThetaD", ",", "NevilleThetaN", ",", 
   "NevilleThetaS", ",", "ParabolicCylinderD", ",", "Plus", ",", "Pochhammer",
    ",", "PolyGamma", ",", "PolyLog", ",", "Power", ",", "Quotient", ",", 
   "QuotientRemainder", ",", "RamanujanTau", ",", "RamanujanTauL", ",", 
   "RamanujanTauTheta", ",", "RamanujanTauZ", ",", "Re", ",", "Rescale", ",", 
   "RiemannSiegelTheta", ",", "RiemannSiegelZ", ",", "Round", ",", "Sec", ",",
    "Sech", ",", "SiegelTheta", ",", "Sign", ",", "Sin", ",", "Sinc", ",", 
   "Sinh", ",", "SinhIntegral", ",", "SinIntegral", ",", "SphericalBesselJ", 
   ",", "SphericalBesselY", ",", "SphericalHankelH1", ",", 
   "SphericalHankelH2", ",", "SphericalHarmonicY", ",", 
   "SpheroidalEigenvalue", ",", "SpheroidalJoiningFactor", ",", 
   "SpheroidalPS", ",", "SpheroidalPSPrime", ",", "SpheroidalQS", ",", 
   "SpheroidalQSPrime", ",", "SpheroidalRadialFactor", ",", "SpheroidalS1", 
   ",", "SpheroidalS1Prime", ",", "SpheroidalS2", ",", "SpheroidalS2Prime", 
   ",", "Sqrt", ",", "StruveH", ",", "StruveL", ",", "Subfactorial", ",", 
   "Subtract", ",", "Tan", ",", "Tanh", ",", "Times", ",", "UnitStep", ",", 
   "WhittakerM", ",", "WhittakerW", ",", "Zeta", ",", "ZetaZero"}], 
  "}"}]], "Output",
 ImageSize->{576, 543},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->86545374]
}, Open  ]],

Cell["\<\
Any combination of these functions with numeric arguments will be numeric:\
\>", "ExampleText",
 CellID->409102407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomChoice", "[", "nfuns", "]"}], "[", 
       RowBox[{
        RowBox[{"RandomChoice", "[", "constants", "]"}], ",", "#"}], "]"}], 
      "&"}], ",", "1", ",", "10"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->444163480],

Cell[BoxData[
 RowBox[{"Zeta", "[", 
  RowBox[{"\[Pi]", ",", 
   RowBox[{"Csch", "[", 
    RowBox[{"\[ExponentialE]", ",", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"MachinePrecision", ",", 
       RowBox[{"Round", "[", 
        RowBox[{"GoldenRatio", ",", 
         RowBox[{"Sec", "[", 
          RowBox[{"Glaisher", ",", 
           RowBox[{"SpheroidalJoiningFactor", "[", 
            RowBox[{"\[Degree]", ",", 
             RowBox[{"JacobiCS", "[", 
              RowBox[{"GoldenRatio", ",", 
               RowBox[{"Re", "[", 
                RowBox[{"MachinePrecision", ",", 
                 RowBox[{"JacobiSD", "[", 
                  RowBox[{"\[Pi]", ",", 
                   RowBox[{"InverseErfc", "[", 
                    RowBox[{"\[Pi]", ",", "1"}], "]"}]}], "]"}]}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27654575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "e", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->291182116],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->14923556]
}, Open  ]],

Cell[TextData[{
 "In most cases, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " will not be a number since it is improbable that the arguments are \
correct:"
}], "ExampleText",
 CellID->123297208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "[", 
  RowBox[{"N", "[", "e", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->536348717],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->46710598]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23679813],

Cell["Test if a matrix consists of numeric entries:", "ExampleText",
 CellID->234068435],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "1", "]"}], ",", 
       RowBox[{"Sin", "[", "1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Sin", "[", "1", "]"}]}], ",", 
       RowBox[{"Cos", "[", "1", "]"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618697659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"m", ",", "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->311253756],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174699850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17859210],

Cell["\<\
Define a function that only evaluates when its argument is numeric:\
\>", "ExampleText",
 CellID->869787512],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"g", ",", "x"}], "}"}], ",", 
    RowBox[{"Quiet", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", "x_", "]"}], "=", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "x", "+", "a"}]}], ";", 
      RowBox[{"r", "=", 
       RowBox[{"x", "/.", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{"g", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"g", "[", "r", "]"}], "]"}], "<", 
         RowBox[{"10", "^", 
          RowBox[{"-", "4"}]}]}], ",", "r", ",", 
        RowBox[{"x", "/.", 
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{"g", "[", "x", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"1", "+", "I"}]}], "}"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370639570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->897412134],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4861739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22120927],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.4999999999999974`"}], "+", 
  RowBox[{"1.0789872855474703`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->376912454]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"f", "[", "a", "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"f", "[", "a", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12108557],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->37055746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->566111470],

Cell["\<\
Define a function that has a special case for numeric arguments:\
\>", "ExampleText",
 CellID->30774793],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x_", "?", "NumericQ"}], ",", 
    RowBox[{"prec_:", "MachinePrecision"}]}], "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{"x", ",", "prec"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92077840],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"FullSimplify", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116065750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "1", "]"}], "+", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->467556815],

Cell[BoxData["3.0861612696304874`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->187850058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], "+", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->350927181],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cosh", "[", "x", "]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->956834098]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29643729],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " does not always imply that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " will yield a number:"
}], "ExampleText",
 CellID->119011216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "1", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "1", "]"}], "^", "2"}], "-", "1"}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590905525],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "1", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "1", "]"}], "2"]}]]], "Output",
 ImageSize->{144, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146872132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46066467],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167590431]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "e", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->619786080],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0.`\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->379825524],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0.`\\^1.`\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->952728679],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156999050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->126535464],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->46558972]
}, Open  ]],

Cell["\<\
This can also happen when the arguments for the function are given \
incorrectly:\
\>", "ExampleText",
 CellID->52206321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Sin", "[", 
   RowBox[{"1", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->288385286],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->432965965],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->515512879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "e", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->95459647],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->160686859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"N", "[", "e", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->106837174],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->84711976],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->273093858]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17881],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31406]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5058],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->32699],

Cell[TextData[ButtonBox["Numeric Quantities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericQuantities"]], "Tutorials",
 CellID->11559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->342295546]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumericQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 26.3451228}", "context" -> "System`", 
    "keywords" -> {
     "numbers", "numeric quantities", "exact numbers", "exact constants"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumericQ[expr] gives True if expr is a numeric quantity, and False \
otherwise. ", "synonyms" -> {"numeric q"}, "title" -> "NumericQ", "type" -> 
    "Symbol", "uri" -> "ref/NumericQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5189, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->330785213]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37143, 1234}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 78, 46, 1, 70, "ObjectName",
 CellID->24008],
Cell[2713, 81, 845, 28, 70, "Usage",
 CellID->8008]
}, Open  ]],
Cell[CellGroupData[{
Cell[3595, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4073, 131, 506, 14, 70, "Notes",
 CellID->3173],
Cell[4582, 147, 570, 22, 70, "Notes",
 CellID->1575]
}, Closed]],
Cell[CellGroupData[{
Cell[5189, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->330785213],
Cell[CellGroupData[{
Cell[5574, 188, 148, 5, 70, "ExampleSection",
 CellID->279061441],
Cell[5725, 195, 224, 7, 70, "ExampleText",
 CellID->716711489],
Cell[CellGroupData[{
Cell[5974, 206, 166, 5, 28, "Input",
 CellID->568774955],
Cell[6143, 213, 160, 5, 36, "Output",
 CellID->41979935]
}, Open  ]],
Cell[6318, 221, 575, 22, 70, "ExampleText",
 CellID->58398026],
Cell[CellGroupData[{
Cell[6918, 247, 159, 5, 28, "Input",
 CellID->685738523],
Cell[7080, 254, 176, 5, 36, "Output",
 CellID->270523206]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7305, 265, 219, 7, 70, "ExampleSection",
 CellID->57247738],
Cell[7527, 274, 101, 2, 70, "ExampleText",
 CellID->94268904],
Cell[7631, 278, 351, 12, 70, "Input",
 CellID->372638323],
Cell[CellGroupData[{
Cell[8007, 294, 107, 3, 70, "Input",
 CellID->241606275],
Cell[8117, 299, 162, 5, 36, "Output",
 CellID->314591638]
}, Open  ]],
Cell[8294, 307, 84, 1, 70, "ExampleText",
 CellID->260545899],
Cell[CellGroupData[{
Cell[8403, 312, 629, 21, 70, "Input",
 CellID->921997923],
Cell[9035, 335, 2162, 39, 70, "Output",
 Evaluatable->False,
 CellID->24771332]
}, Open  ]],
Cell[11212, 377, 125, 3, 70, "ExampleDelimiter",
 CellID->348961774],
Cell[11340, 382, 497, 19, 70, "ExampleText",
 CellID->246480166],
Cell[11840, 403, 145, 4, 70, "Input",
 CellID->92581754],
Cell[CellGroupData[{
Cell[12010, 411, 214, 7, 70, "Input",
 CellID->10906446],
Cell[12227, 420, 161, 5, 36, "Output",
 CellID->559539387]
}, Open  ]],
Cell[12403, 428, 125, 3, 70, "ExampleDelimiter",
 CellID->189733729],
Cell[12531, 433, 97, 1, 70, "ExampleText",
 CellID->229804501],
Cell[12631, 436, 306, 10, 70, "Input",
 CellID->90761623],
Cell[CellGroupData[{
Cell[12962, 450, 300, 10, 70, "Input",
 CellID->414949811],
Cell[13265, 462, 365, 10, 36, "Output",
 CellID->903011581]
}, Open  ]],
Cell[13645, 475, 235, 8, 70, "ExampleText",
 CellID->321917217],
Cell[CellGroupData[{
Cell[13905, 487, 302, 10, 70, "Input",
 CellID->37578381],
Cell[14210, 499, 4210, 62, 564, "Output",
 CellID->86545374]
}, Open  ]],
Cell[18435, 564, 125, 3, 70, "ExampleText",
 CellID->409102407],
Cell[CellGroupData[{
Cell[18585, 571, 381, 12, 70, "Input",
 CellID->444163480],
Cell[18969, 585, 1016, 27, 71, "Output",
 CellID->27654575]
}, Open  ]],
Cell[CellGroupData[{
Cell[20022, 617, 104, 3, 70, "Input",
 CellID->291182116],
Cell[20129, 622, 160, 5, 36, "Output",
 CellID->14923556]
}, Open  ]],
Cell[20304, 630, 312, 11, 70, "ExampleText",
 CellID->123297208],
Cell[CellGroupData[{
Cell[20641, 645, 129, 4, 70, "Input",
 CellID->536348717],
Cell[20773, 651, 169, 5, 36, "Output",
 CellID->46710598]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20991, 662, 226, 7, 70, "ExampleSection",
 CellID->23679813],
Cell[21220, 671, 88, 1, 70, "ExampleText",
 CellID->234068435],
Cell[21311, 674, 429, 15, 70, "Input",
 CellID->618697659],
Cell[CellGroupData[{
Cell[21765, 693, 133, 4, 70, "Input",
 CellID->311253756],
Cell[21901, 699, 161, 5, 36, "Output",
 CellID->174699850]
}, Open  ]],
Cell[22077, 707, 124, 3, 70, "ExampleDelimiter",
 CellID->17859210],
Cell[22204, 712, 118, 3, 70, "ExampleText",
 CellID->869787512],
Cell[22325, 717, 1158, 37, 70, "Input",
 CellID->370639570],
Cell[CellGroupData[{
Cell[23508, 758, 97, 3, 70, "Input",
 CellID->897412134],
Cell[23608, 763, 183, 6, 36, "Output",
 CellID->4861739]
}, Open  ]],
Cell[CellGroupData[{
Cell[23828, 774, 127, 4, 70, "Input",
 CellID->22120927],
Cell[23958, 780, 270, 8, 36, "Output",
 CellID->376912454]
}, Open  ]],
Cell[CellGroupData[{
Cell[24265, 793, 379, 13, 70, "Input",
 CellID->12108557],
Cell[24647, 808, 2806, 50, 70, "Output",
 Evaluatable->False,
 CellID->37055746]
}, Open  ]],
Cell[27468, 861, 125, 3, 70, "ExampleDelimiter",
 CellID->566111470],
Cell[27596, 866, 114, 3, 70, "ExampleText",
 CellID->30774793],
Cell[27713, 871, 272, 9, 70, "Input",
 CellID->92077840],
Cell[27988, 882, 161, 5, 70, "Input",
 CellID->116065750],
Cell[CellGroupData[{
Cell[28174, 891, 202, 7, 70, "Input",
 CellID->467556815],
Cell[28379, 900, 176, 5, 36, "Output",
 CellID->187850058]
}, Open  ]],
Cell[CellGroupData[{
Cell[28592, 910, 202, 7, 70, "Input",
 CellID->350927181],
Cell[28797, 919, 211, 7, 36, "Output",
 CellID->956834098]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29057, 932, 229, 7, 70, "ExampleSection",
 CellID->29643729],
Cell[29289, 941, 438, 16, 70, "ExampleText",
 CellID->119011216],
Cell[CellGroupData[{
Cell[29752, 961, 299, 11, 70, "Input",
 CellID->590905525],
Cell[30054, 974, 345, 12, 54, "Output",
 CellID->146872132]
}, Open  ]],
Cell[CellGroupData[{
Cell[30436, 991, 103, 3, 70, "Input",
 CellID->46066467],
Cell[30542, 996, 161, 5, 36, "Output",
 CellID->167590431]
}, Open  ]],
Cell[CellGroupData[{
Cell[30740, 1006, 97, 3, 70, "Input",
 CellID->619786080],
Cell[30840, 1011, 369, 7, 70, "Message",
 CellID->379825524],
Cell[31212, 1020, 375, 7, 70, "Message",
 CellID->952728679],
Cell[31590, 1029, 173, 5, 36, "Output",
 CellID->156999050]
}, Open  ]],
Cell[CellGroupData[{
Cell[31800, 1039, 103, 3, 70, "Input",
 CellID->126535464],
Cell[31906, 1044, 161, 5, 36, "Output",
 CellID->46558972]
}, Open  ]],
Cell[32082, 1052, 131, 4, 70, "ExampleText",
 CellID->52206321],
Cell[CellGroupData[{
Cell[32238, 1060, 146, 5, 70, "Input",
 CellID->288385286],
Cell[32387, 1067, 388, 8, 70, "Message",
 CellID->432965965],
Cell[32778, 1077, 210, 7, 36, "Output",
 CellID->515512879]
}, Open  ]],
Cell[CellGroupData[{
Cell[33025, 1089, 103, 3, 70, "Input",
 CellID->95459647],
Cell[33131, 1094, 161, 5, 36, "Output",
 CellID->160686859]
}, Open  ]],
Cell[CellGroupData[{
Cell[33329, 1104, 131, 4, 70, "Input",
 CellID->106837174],
Cell[33463, 1110, 387, 8, 70, "Message",
 CellID->84711976],
Cell[33853, 1120, 162, 5, 36, "Output",
 CellID->273093858]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34076, 1132, 311, 9, 70, "SeeAlsoSection",
 CellID->17881],
Cell[34390, 1143, 463, 17, 70, "SeeAlso",
 CellID->31406]
}, Open  ]],
Cell[CellGroupData[{
Cell[34890, 1165, 313, 9, 70, "TutorialsSection",
 CellID->5058],
Cell[35206, 1176, 170, 3, 70, "Tutorials",
 CellID->32699],
Cell[35379, 1181, 146, 3, 70, "Tutorials",
 CellID->11559]
}, Open  ]],
Cell[CellGroupData[{
Cell[35562, 1189, 299, 8, 70, "MoreAboutSection"],
Cell[35864, 1199, 149, 3, 70, "MoreAbout",
 CellID->342295546]
}, Open  ]],
Cell[36028, 1205, 27, 0, 70, "History"],
Cell[36058, 1207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

