(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15546,        553]
NotebookOptionsPosition[     12115,        440]
NotebookOutlinePosition[     13496,        478]
CellTagsIndexPosition[     13411,        473]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Warnings and Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/WarningsAndMessages"], 
          "Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Warnings and Messages\"\>", 
       2->"\<\"Messages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quiet" :> Documentation`HelpLookup["paclet:ref/Quiet"], "On" :> 
          Documentation`HelpLookup["paclet:ref/On"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quiet\"\>", 2->"\<\"On\"\>", 
       3->"\<\"Message\"\>", 4->"\<\"Check\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Messages" :> Documentation`HelpLookup["paclet:guide/Messages"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mathematica Sessions\"\>", 
       2->"\<\"Messages\"\>", 
       3->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Off", "ObjectName",
 CellID->17041],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Off",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Off"], "[", 
       RowBox[{
        StyleBox["symbol", "TI"], "::", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]switches off a message, so that it is no longer \
printed. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Off",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Off"], "[", 
       StyleBox["s", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]switches off tracing messages associated with the \
symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Off",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Off"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]switches off several messages. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Off",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Off"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]switches off all tracing messages. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26901]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["value", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " is not affected by ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22927],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    ButtonBox["General",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/General"], "::", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 " switches off all messages derived from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->398666679],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    StyleBox["s", "TI"], "::", "trace"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9660],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    StyleBox["s", "TI"], "::", "trace"}], "]"}]], "InlineFormula"],
 " for all symbols. "
}], "Notes",
 CellID->19282]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355347786],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->713481592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24499751],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "::", "\<\"argt\"\>"}], ":", 
  " ", "\<\"\\!\\(Log\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" called with \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(3\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" arguments; \\\\\\\
\"\\\", \\\"MSG\\\"]\\)\\!\\(1\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" or \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(2\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" arguments are \
expected.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/argt\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->109822288],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62926120]
}, Open  ]],

Cell["Switch off the message:", "ExampleText",
 CellID->54398944],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"Log", "::", "argt"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->377189226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126713198],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->454587538]
}, Open  ]],

Cell["Switch the message back on:", "ExampleText",
 CellID->482854873],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"Log", "::", "argt"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->255653489]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29025],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quiet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quiet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21357],

Cell[TextData[ButtonBox["Warnings and Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WarningsAndMessages"]], "Tutorials",
 CellID->19191],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->1397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->401235415],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->6367561],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->33800306],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->78075907]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Off - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 27.5482786}", "context" -> "System`", 
    "keywords" -> {"quiet message", "tracing functions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Off[symbol::tag] switches off a message, so that it is no longer \
printed. Off[s] switches off tracing messages associated with the symbol s. \
Off[m_1, m_2, ...] switches off several messages. Off[] switches off all \
tracing messages. ", "synonyms" -> {}, "title" -> "Off", "type" -> "Symbol", 
    "uri" -> "ref/Off"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6998, 241, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->355347786]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13268, 466}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2346, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2969, 81, 41, 1, 70, "ObjectName",
 CellID->17041],
Cell[3013, 84, 1678, 55, 70, "Usage",
 CellID->26901]
}, Open  ]],
Cell[CellGroupData[{
Cell[4728, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5206, 161, 371, 16, 70, "Notes",
 CellID->22927],
Cell[5580, 179, 539, 20, 70, "Notes",
 CellID->398666679],
Cell[6122, 201, 422, 17, 70, "Notes",
 CellID->9660],
Cell[6547, 220, 414, 16, 70, "Notes",
 CellID->19282]
}, Closed]],
Cell[CellGroupData[{
Cell[6998, 241, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355347786],
Cell[CellGroupData[{
Cell[7383, 255, 148, 5, 70, "ExampleSection",
 CellID->713481592],
Cell[CellGroupData[{
Cell[7556, 264, 131, 4, 70, "Input",
 CellID->24499751],
Cell[7690, 270, 621, 12, 19, "Message",
 CellID->109822288],
Cell[8314, 284, 219, 7, 36, "Output",
 CellID->62926120]
}, Open  ]],
Cell[8548, 294, 65, 1, 70, "ExampleText",
 CellID->54398944],
Cell[8616, 297, 128, 4, 70, "Input",
 CellID->377189226],
Cell[CellGroupData[{
Cell[8769, 305, 132, 4, 70, "Input",
 CellID->126713198],
Cell[8904, 311, 220, 7, 36, "Output",
 CellID->454587538]
}, Open  ]],
Cell[9139, 321, 70, 1, 70, "ExampleText",
 CellID->482854873],
Cell[9212, 324, 127, 4, 70, "Input",
 CellID->255653489]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9388, 334, 311, 9, 70, "SeeAlsoSection",
 CellID->29025],
Cell[9702, 345, 914, 35, 70, "SeeAlso",
 CellID->9691]
}, Open  ]],
Cell[CellGroupData[{
Cell[10653, 385, 314, 9, 70, "TutorialsSection",
 CellID->21357],
Cell[10970, 396, 151, 3, 70, "Tutorials",
 CellID->19191],
Cell[11124, 401, 126, 3, 70, "Tutorials",
 CellID->1397]
}, Open  ]],
Cell[CellGroupData[{
Cell[11287, 409, 319, 9, 70, "MoreAboutSection",
 CellID->401235415],
Cell[11609, 420, 149, 3, 70, "MoreAbout",
 CellID->6367561],
Cell[11761, 425, 127, 3, 70, "MoreAbout",
 CellID->33800306],
Cell[11891, 430, 152, 3, 70, "MoreAbout",
 CellID->78075907]
}, Open  ]],
Cell[12058, 436, 27, 0, 70, "History"],
Cell[12088, 438, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

